/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.support;

import com.yqbsoft.laser.service.monitor.enums.PeriodType;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import java.util.Calendar;
import java.util.Date;

public class PeriodUtil {
    public static long getNow2NextPeriodDelay(PeriodType type) {
        Calendar cal = Calendar.getInstance();
        long expireTime = 0L;
        switch (type) {
            case DAY: {
                cal.roll(5, 1);
                expireTime = DateUtil.roundDate((Calendar)cal, (int)5).getTime();
                break;
            }
            case HOUR: {
                cal.roll(11, 1);
                expireTime = DateUtil.roundDate((Calendar)cal, (int)11).getTime();
                break;
            }
            case MIN: {
                cal.roll(12, 1);
                expireTime = DateUtil.roundDate((Calendar)cal, (int)12).getTime();
            }
        }
        return expireTime - new Date().getTime();
    }

    public static String getCurrentPeriod(PeriodType type) {
        switch (type) {
            case DAY: {
                return DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd");
            }
            case HOUR: {
                return DateUtil.getDateString((Date)new Date(), (String)"yyyyMMddHH");
            }
            case MIN: {
                return DateUtil.getDateString((Date)new Date(), (String)"yyyyMMddHHmm");
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(PeriodUtil.getNow2NextPeriodDelay(PeriodType.HOUR));
    }
}

