/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.organize.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.organize.dao.OrgDepartMapper;
import com.yqbsoft.laser.service.organize.dao.OrgDepartdealerMapper;
import com.yqbsoft.laser.service.organize.domain.OrgDepartdealerDomain;
import com.yqbsoft.laser.service.organize.domain.OrgDepartdealerReDomain;
import com.yqbsoft.laser.service.organize.model.OrgDepart;
import com.yqbsoft.laser.service.organize.model.OrgDepartdealer;
import com.yqbsoft.laser.service.organize.service.OrgDepartdealerService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OrgDepartdealerServiceImpl
extends BaseServiceImpl
implements OrgDepartdealerService {
    private static final String SYS_CODE = "org.OrgDepartdealerServiceImpl";
    private OrgDepartdealerMapper orgDepartdealerMapper;
    private OrgDepartMapper orgDepartMapper;

    public void setOrgDepartdealerMapper(OrgDepartdealerMapper orgDepartdealerMapper) {
        this.orgDepartdealerMapper = orgDepartdealerMapper;
    }

    public void setOrgDepartMapper(OrgDepartMapper orgDepartMapper) {
        this.orgDepartMapper = orgDepartMapper;
    }

    private Date getSysDate() {
        try {
            return this.orgDepartdealerMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartdealerServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrgDepartdealer(OrgDepartdealerDomain orgDepartdealerDomain) {
        if (null == orgDepartdealerDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgDepartdealerDomain.getDepartCode())) {
            msg = msg + "\u90e8\u95e8\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgDepartdealerDomain.getDealerCode())) {
            msg = msg + "\u7ecf\u9500\u5546\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgDepartdealerDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOrgDepartdealerDefault(OrgDepartdealer orgDepartdealer) {
        if (null == orgDepartdealer) {
            return;
        }
        if (null == orgDepartdealer.getDataState()) {
            orgDepartdealer.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == orgDepartdealer.getGmtCreate()) {
            orgDepartdealer.setGmtCreate(date);
        }
        orgDepartdealer.setGmtModified(date);
        if (StringUtils.isBlank((String)orgDepartdealer.getDepartdealerCode())) {
            orgDepartdealer.setDepartdealerCode(this.getNo(null, "OrgDepartdealer", "orgDepartdealer", orgDepartdealer.getTenantCode()));
        }
    }

    private int getOrgDepartdealerMaxCode() {
        int code = 0;
        try {
            return this.orgDepartdealerMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartdealerServiceImpl.getOrgDepartdealerMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrgDepartdealerUpdataDefault(OrgDepartdealer orgDepartdealer) {
        if (null == orgDepartdealer) {
            return;
        }
        orgDepartdealer.setGmtModified(this.getSysDate());
    }

    private void saveOrgDepartdealerModel(OrgDepartdealer orgDepartdealer) throws ApiException {
        if (null == orgDepartdealer) {
            return;
        }
        try {
            this.orgDepartdealerMapper.insert(orgDepartdealer);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.saveOrgDepartdealerModel.ex", (Throwable)e);
        }
    }

    private void saveOrgDepartdealerBatchModel(List<OrgDepartdealer> orgDepartdealerList) throws ApiException {
        if (null == orgDepartdealerList || orgDepartdealerList.isEmpty()) {
            return;
        }
        try {
            this.orgDepartdealerMapper.insertBatch(orgDepartdealerList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.saveOrgDepartdealerBatchModel.ex", (Throwable)e);
        }
    }

    private OrgDepartdealer getOrgDepartdealerModelById(Integer departdealerId) {
        if (null == departdealerId) {
            return null;
        }
        try {
            return this.orgDepartdealerMapper.selectByPrimaryKey(departdealerId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartdealerServiceImpl.getOrgDepartdealerModelById", (Throwable)e);
            return null;
        }
    }

    private OrgDepartdealer getOrgDepartdealerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgDepartdealerMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartdealerServiceImpl.getOrgDepartdealerModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOrgDepartdealerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartdealerMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.delOrgDepartdealerModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.delOrgDepartdealerModelByCode.num");
        }
    }

    private void deleteOrgDepartdealerModel(Integer departdealerId) throws ApiException {
        if (null == departdealerId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartdealerMapper.deleteByPrimaryKey(departdealerId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.deleteOrgDepartdealerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.deleteOrgDepartdealerModel.num");
        }
    }

    private void updateOrgDepartdealerModel(OrgDepartdealer orgDepartdealer) throws ApiException {
        if (null == orgDepartdealer) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartdealerMapper.updateByPrimaryKey(orgDepartdealer);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.updateOrgDepartdealerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.updateOrgDepartdealerModel.num");
        }
    }

    private void updateStateOrgDepartdealerModel(Integer departdealerId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == departdealerId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("departdealerId", departdealerId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.orgDepartdealerMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.updateStateOrgDepartdealerModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.updateStateOrgDepartdealerModel.null");
        }
    }

    private void updateStateOrgDepartdealerModelByCode(String tenantCode, String departdealerCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)departdealerCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departdealerCode", departdealerCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.orgDepartdealerMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.updateStateOrgDepartdealerModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.updateStateOrgDepartdealerModelByCode.null");
        }
    }

    private OrgDepartdealer makeOrgDepartdealer(OrgDepartdealerDomain orgDepartdealerDomain, OrgDepartdealer orgDepartdealer) {
        if (null == orgDepartdealerDomain) {
            return null;
        }
        if (null == orgDepartdealer) {
            orgDepartdealer = new OrgDepartdealer();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartdealer, (Object)orgDepartdealerDomain);
            return orgDepartdealer;
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartdealerServiceImpl.makeOrgDepartdealer", (Throwable)e);
            return null;
        }
    }

    private OrgDepartdealerReDomain makeOrgDepartdealerReDomain(OrgDepartdealer orgDepartdealer) {
        if (null == orgDepartdealer) {
            return null;
        }
        OrgDepartdealerReDomain orgDepartdealerReDomain = new OrgDepartdealerReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartdealerReDomain, (Object)orgDepartdealer);
            return orgDepartdealerReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartdealerServiceImpl.makeOrgDepartdealerReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgDepartdealer> queryOrgDepartdealerModelPage(Map<String, Object> parammap) {
        try {
            return this.orgDepartdealerMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartdealerServiceImpl.queryOrgDepartdealerModel", (Throwable)e);
            return null;
        }
    }

    private int countOrgDepartdealer(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgDepartdealerMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartdealerServiceImpl.countOrgDepartdealer", (Throwable)e);
        }
        return i;
    }

    private OrgDepartdealer createOrgDepartdealer(OrgDepartdealerDomain orgDepartdealerDomain) {
        String msg = this.checkOrgDepartdealer(orgDepartdealerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.saveOrgDepartdealer.checkOrgDepartdealer", msg);
        }
        OrgDepartdealer orgDepartdealer = this.makeOrgDepartdealer(orgDepartdealerDomain, null);
        this.setOrgDepartdealerDefault(orgDepartdealer);
        return orgDepartdealer;
    }

    @Override
    public String saveOrgDepartdealer(OrgDepartdealerDomain orgDepartdealerDomain) throws ApiException {
        OrgDepartdealer orgDepartdealer = this.createOrgDepartdealer(orgDepartdealerDomain);
        this.saveOrgDepartdealerModel(orgDepartdealer);
        return orgDepartdealer.getDepartdealerCode();
    }

    @Override
    public String saveOrgDepartdealerBatch(List<OrgDepartdealerDomain> orgDepartdealerDomainList) throws ApiException {
        if (null == orgDepartdealerDomainList || orgDepartdealerDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgDepartdealer> orgDepartdealerList = new ArrayList<OrgDepartdealer>();
        String code = "";
        for (OrgDepartdealerDomain orgDepartdealerDomain : orgDepartdealerDomainList) {
            OrgDepartdealer orgDepartdealer = this.createOrgDepartdealer(orgDepartdealerDomain);
            code = orgDepartdealer.getDepartdealerCode();
            orgDepartdealerList.add(orgDepartdealer);
        }
        this.saveOrgDepartdealerBatchModel(orgDepartdealerList);
        return code;
    }

    @Override
    public void updateOrgDepartdealerState(Integer departdealerId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == departdealerId) {
            return;
        }
        this.updateStateOrgDepartdealerModel(departdealerId, dataState, oldDataState, map);
    }

    @Override
    public void updateOrgDepartdealerStateByCode(String tenantCode, String departdealerCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)departdealerCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOrgDepartdealerModelByCode(tenantCode, departdealerCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOrgDepartdealer(OrgDepartdealerDomain orgDepartdealerDomain) throws ApiException {
        String msg = this.checkOrgDepartdealer(orgDepartdealerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.updateOrgDepartdealer.checkOrgDepartdealer", msg);
        }
        OrgDepartdealer oldOrgDepartdealer = this.getOrgDepartdealerModelById(orgDepartdealerDomain.getDepartdealerId());
        if (null == oldOrgDepartdealer) {
            throw new ApiException("org.OrgDepartdealerServiceImpl.updateOrgDepartdealer.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgDepartdealer orgDepartdealer = this.makeOrgDepartdealer(orgDepartdealerDomain, oldOrgDepartdealer);
        this.setOrgDepartdealerUpdataDefault(orgDepartdealer);
        this.updateOrgDepartdealerModel(orgDepartdealer);
    }

    @Override
    public OrgDepartdealer getOrgDepartdealer(Integer departdealerId) {
        if (null == departdealerId) {
            return null;
        }
        return this.getOrgDepartdealerModelById(departdealerId);
    }

    @Override
    public void deleteOrgDepartdealer(Integer departdealerId) throws ApiException {
        if (null == departdealerId) {
            return;
        }
        this.deleteOrgDepartdealerModel(departdealerId);
    }

    @Override
    public QueryResult<OrgDepartdealer> queryOrgDepartdealerPage(Map<String, Object> map) {
        List<OrgDepartdealer> orgDepartdealerList = this.queryOrgDepartdealerModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrgDepartdealer(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgDepartdealerList);
        return queryResult;
    }

    @Override
    public OrgDepartdealer getOrgDepartdealerByCode(String tenantCode, String departdealerCode) throws ApiException {
        if (StringUtils.isBlank((String)departdealerCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departdealerCode", departdealerCode);
        return this.getOrgDepartdealerModelByCode(map);
    }

    @Override
    public void deleteOrgDepartdealerByCode(String tenantCode, String departdealerCode) throws ApiException {
        if (StringUtils.isBlank((String)departdealerCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departdealerCode", departdealerCode);
        this.delOrgDepartdealerModelByCode(map);
    }

    @Override
    public List<OrgDepartdealer> queryOrgDepartdealerByManager(Map<String, Object> map) {
        HashMap<String, Object> departParam = new HashMap<String, Object>();
        departParam.put("tenantCode", map.get("tenantCode"));
        departParam.put("dealerChannel", map.get("dealerChannel"));
        departParam.put("departContactsPhone", map.get("departContactsPhone"));
        departParam.put("dataState", 0);
        List<OrgDepart> orgDeparts = this.orgDepartMapper.query(departParam);
        if (ListUtil.isEmpty(orgDeparts)) {
            return new ArrayList<OrgDepartdealer>();
        }
        ArrayList<OrgDepart> areaList = new ArrayList<OrgDepart>();
        ArrayList<OrgDepart> provinceList = new ArrayList<OrgDepart>();
        for (OrgDepart orgDepart : orgDeparts) {
            if (orgDepart.getDepartPcode().equals("-1")) {
                areaList.add(orgDepart);
                continue;
            }
            provinceList.add(orgDepart);
        }
        if (ListUtil.isNotEmpty(areaList)) {
            List areaDepartCodes = areaList.stream().map(OrgDepart::getDepartCode).distinct().collect(Collectors.toList());
            String areaDepartCodesStr = String.join((CharSequence)",", areaDepartCodes);
            HashMap<String, Object> provinceDepartParam = new HashMap<String, Object>();
            provinceDepartParam.put("tenantCode", map.get("tenantCode"));
            provinceDepartParam.put("dealerChannel", map.get("dealerChannel"));
            provinceDepartParam.put("departPcode", areaDepartCodesStr);
            List<OrgDepart> provinceOrgDeparts = this.orgDepartMapper.query(provinceDepartParam);
            if (ListUtil.isNotEmpty(provinceOrgDeparts)) {
                provinceList.addAll(provinceOrgDeparts);
            }
        }
        if (ListUtil.isEmpty(provinceList)) {
            return new ArrayList<OrgDepartdealer>();
        }
        List provinceDepartCodes = provinceList.stream().map(OrgDepart::getDepartCode).distinct().collect(Collectors.toList());
        String provinceListDepartCodesStr = String.join((CharSequence)",", provinceDepartCodes);
        HashMap<String, Object> departdealerParam = new HashMap<String, Object>();
        departdealerParam.put("tenantCode", map.get("tenantCode"));
        departdealerParam.put("departCode", provinceListDepartCodesStr);
        List<OrgDepartdealer> orgDepartdealerList = this.orgDepartdealerMapper.query(departdealerParam);
        return orgDepartdealerList;
    }
}

