/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.payengine.domain.CallbackResult;
import com.yqbsoft.laser.service.payengine.domain.ChannelRestForm;
import com.yqbsoft.laser.service.payengine.domain.PeCflowNodeReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeCflowPprocessDomain;
import com.yqbsoft.laser.service.payengine.domain.PeCflowPserviceReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeCflowReDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentOrderDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentParticipantDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentReorderDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearinfoDomain;
import com.yqbsoft.laser.service.payengine.domain.PeReorderDomain;
import com.yqbsoft.laser.service.payengine.enumc.DicactorEnum;
import com.yqbsoft.laser.service.payengine.enumc.FlowStartCon;
import com.yqbsoft.laser.service.payengine.model.PeCflowNode;
import com.yqbsoft.laser.service.payengine.model.PeCflowPprocess;
import com.yqbsoft.laser.service.payengine.model.PeProtClearinfo;
import com.yqbsoft.laser.service.payengine.model.PeProtEtc;
import com.yqbsoft.laser.service.payengine.service.PeCflowPprocessService;
import com.yqbsoft.laser.service.payengine.service.PePayClearService;
import com.yqbsoft.laser.service.payengine.service.PePayEngineBaseService;
import com.yqbsoft.laser.service.payengine.service.PePaymentService;
import com.yqbsoft.laser.service.payengine.service.impl.PeProtEtcServiceImpl;
import com.yqbsoft.laser.service.payengine.transformer.ClearInfoContext;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PePayEngineBaseServiceImpl
extends BaseServiceImpl
implements PePayEngineBaseService {
    public static final String SYS_CODE = "pe.PePayEngineBaseServiceImpl";
    private PePaymentService pePaymentService;
    private PeCflowPprocessService peCflowPprocessService;
    private PePayClearService pePayClearService;
    private String conmap_key_startType = "startType";
    private String conmap_key_payment = "pePaymentDomain";
    private String conmap_key_order = "pePaymentOrderDomain";
    private String conmap_key_participant = "pePaymentParticipant";
    private static final Integer EXECUTE_INDEX = 100;

    public void setPePayClearService(PePayClearService pePayClearService) {
        this.pePayClearService = pePayClearService;
    }

    public void setPeCflowPprocessService(PeCflowPprocessService peCflowPprocessService) {
        this.peCflowPprocessService = peCflowPprocessService;
    }

    public void setPePaymentService(PePaymentService pePaymentService) {
        this.pePaymentService = pePaymentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeProtClearinfo> savePaymentNext(PeReorderDomain peReorderDomain) throws ApiException {
        if (null == peReorderDomain) {
            throw new ApiException("pe.PePayEngineBaseServiceImpl.savePaymentNext.null", "null");
        }
        long start = System.currentTimeMillis();
        this.logger.error("pe.PePayEngineBaseServiceImpl.savePaymentNext.updateCflowPprocessStateByCode", (Object)(peReorderDomain.getOrderState() + "=:=" + peReorderDomain.getPaymentSeqno()));
        try {
            List<PeProtClearinfo> peProtClearinfoList;
            PeCflowPprocess peCflowPprocess;
            Integer dataState = 2;
            String startType = FlowStartCon.CS.getCode();
            Integer oldDataState = 0;
            if (peReorderDomain.isError()) {
                dataState = 3;
                startType = FlowStartCon.CE.getCode();
            }
            if (peReorderDomain.isProcess()) {
                dataState = 1;
                startType = FlowStartCon.AP.getCode();
            }
            if (null == (peCflowPprocess = this.peCflowPprocessService.getCflowPprocessByCode(peReorderDomain.getCflowPprocessCode(), peReorderDomain.getTenantCode()))) {
                throw new ApiException("pe.PePayEngineBaseServiceImpl.savePaymentNext.peCflowPprocess", JsonUtil.buildNormalBinder().toJson((Object)peReorderDomain));
            }
            PePaymentDomain pePaymentDomain = this.pePaymentService.getPaymentByCode(peCflowPprocess.getPaymentSeqno(), peCflowPprocess.getTenantCode());
            if (null == pePaymentDomain) {
                throw new ApiException("pe.PePayEngineBaseServiceImpl.saveFlowNext.pePaymentDomain", "null");
            }
            PeCflowNode peCflowNode = (PeCflowNode)DisUtil.getMapJson((String)"peProtCflowNode", (String)(peCflowPprocess.getCflowNodeCode() + "-" + peCflowPprocess.getTenantCode()), PeCflowNode.class);
            if (null == peCflowNode) {
                peCflowNode = (PeCflowNode)DisUtil.getMapJson((String)"peProtCflowNode", (String)(peCflowPprocess.getCflowNodeCode() + "-00000000"), PeCflowNode.class);
            }
            if (null == peCflowNode) {
                throw new ApiException("pe.PePayEngineBaseServiceImpl.savePaymentNext.peCflowNode", peCflowPprocess.getCflowNodeCode());
            }
            oldDataState = peCflowPprocess.getDataState();
            if (oldDataState.equals(dataState)) {
                List<PeProtClearinfo> list = null;
                return list;
            }
            if (2 == oldDataState || 3 == oldDataState) {
                throw new ApiException("pe.PePayEngineBaseServiceImpl.savePaymentNext.oldDataState", "null");
            }
            CallbackResult callbackResult = this.call(peCflowNode, pePaymentDomain, peReorderDomain, dataState);
            if (1 == dataState) {
                List<PeProtClearinfo> list = null;
                return list;
            }
            if (callbackResult.isBack()) {
                startType = FlowStartCon.AB.getCode();
            }
            this.logger.error("pe.PePayEngineBaseServiceImpl.savePaymentNext.updateCflowPprocessStateByCode", (Object)(peCflowPprocess.getCflowPprocessCode() + "=:=" + peCflowPprocess.getTenantCode() + "=:=" + dataState + "=:=" + oldDataState));
            this.peCflowPprocessService.updateCflowPprocessStateByCode(peCflowPprocess.getCflowPprocessCode(), peCflowPprocess.getTenantCode(), dataState, oldDataState);
            PePaymentOrderDomain pePaymentOrderDomain = this.pePaymentService.getPaymentOrderByCode(peCflowPprocess.getPaymentOrderSeqno(), peCflowPprocess.getTenantCode());
            if (null == pePaymentOrderDomain) {
                throw new ApiException("pe.PePayEngineBaseServiceImpl.saveFlowNext.pePaymentOrderDomain", "null");
            }
            List nodeList = DisUtil.getMapListJson((String)"peProtCflowNodeByParent", (String)(peCflowNode.getCflowCode() + "-" + peCflowNode.getCflowNodeNextcode() + "-" + peCflowPprocess.getTenantCode()), PeCflowNodeReDomain.class);
            if (ListUtil.isEmpty((Collection)nodeList) && ListUtil.isEmpty((Collection)(nodeList = DisUtil.getMapListJson((String)"peProtCflowNodeByParent", (String)(peCflowNode.getCflowCode() + "-" + peCflowNode.getCflowNodeNextcode() + "-00000000"), PeCflowNodeReDomain.class)))) {
                List<PeProtClearinfo> list = null;
                return list;
            }
            ArrayList<PeProtClearinfoDomain> clearinfoDomianList = new ArrayList<PeProtClearinfoDomain>();
            ArrayList<PeCflowPprocessDomain> peCflowPprocessDomainList = new ArrayList<PeCflowPprocessDomain>();
            ClearInfoContext clearInfoContext = new ClearInfoContext(startType, clearinfoDomianList, peCflowPprocessDomainList, pePaymentDomain, pePaymentOrderDomain, nodeList, peReorderDomain);
            this.createClearInfo(clearInfoContext);
            this.saveBatchCflowPprocess(peCflowPprocessDomainList, clearInfoContext.isNeedUpdateProcess());
            if (null == clearinfoDomianList || clearinfoDomianList.isEmpty()) {
                List<PeProtClearinfo> list = null;
                return list;
            }
            List<PeProtClearinfo> list = peProtClearinfoList = this.pePayClearService.saveProtClearinfoBatch(clearinfoDomianList);
            return list;
        }
        finally {
            OpenPerfLogUtil.info((String)("pePayEngineService sendPaymentNext end time consuming:{}ms,paymentSeqno" + peReorderDomain.getPaymentSeqno()), (long)(System.currentTimeMillis() - start));
        }
    }

    private void saveBatchCflowPprocess(List<PeCflowPprocessDomain> peCflowPprocessDomainList, boolean updateProcess) {
        if (null == peCflowPprocessDomainList || peCflowPprocessDomainList.isEmpty()) {
            return;
        }
        this.peCflowPprocessService.saveBatchCflowPprocess(peCflowPprocessDomainList);
        if (updateProcess) {
            PeCflowPprocessDomain peCflowPprocessDomain = peCflowPprocessDomainList.get(peCflowPprocessDomainList.size() - 1);
            this.pePaymentService.updateProcessByCode(peCflowPprocessDomain.getCflowPprocessCode(), peCflowPprocessDomain.getCflowNodeCode(), peCflowPprocessDomain.getPaymentOrderSeqno(), peCflowPprocessDomain.getTenantCode());
        }
    }

    private CallbackResult call(PeCflowNode peCflowNode, PePaymentDomain pePaymentDomain, PeReorderDomain peReorderDomain, Integer dataState) {
        if (null == peCflowNode || null == pePaymentDomain) {
            return CallbackResult.SUCCESS;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("peCflowNode", peCflowNode);
        map.put("peReorderDomain", peReorderDomain);
        map.put("dataState", dataState);
        return this.savecall(peCflowNode.getCflowNodeCallcon(), peCflowNode.getCflowNodeCallparam(), map, pePaymentDomain, peReorderDomain, dataState);
    }

    private CallbackResult callStart(PeCflowNode peCflowNode, PePaymentDomain pePaymentDomain, PeReorderDomain peReorderDomain, Integer dataState) {
        if (null == peCflowNode || null == pePaymentDomain) {
            return CallbackResult.SUCCESS;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("peCflowNode", peCflowNode);
        map.put("peReorderDomain", peReorderDomain);
        map.put("dataState", dataState);
        return this.savecall(peCflowNode.getCflowNodeScallcon(), peCflowNode.getCflowNodeScallparam(), map, pePaymentDomain, peReorderDomain, dataState);
    }

    private CallbackResult savecall(String js, String callparam, Map<String, Object> map, PePaymentDomain pePaymentDomain, PeReorderDomain peReorderDomain, Integer dataState) {
        ChannelRestForm channelRestForm;
        if (StringUtils.isBlank((String)js) || null == pePaymentDomain) {
            return CallbackResult.SUCCESS;
        }
        String res = (String)ScriptUtil.evel((String)js, map);
        if (!"ok".equals(res)) {
            this.logger.debug("pe.PePayEngineBaseServiceImpl.call.error", (Object)("condition:" + js));
            return CallbackResult.SUCCESS;
        }
        PePaymentReorderDomain pePaymentReorderDomain = this.makeReorderDomain(pePaymentDomain, peReorderDomain);
        if (null == pePaymentReorderDomain) {
            throw new ApiException("pe.PePayEngineBaseServiceImpl.call.pePaymentReorderDomain", "null");
        }
        String extjs = pePaymentReorderDomain.getPaymentReorderMemo();
        if (StringUtils.isNotBlank((String)extjs) && (channelRestForm = (ChannelRestForm)JsonUtil.buildNormalBinder().getJsonToObject(extjs, ChannelRestForm.class)) != null) {
            String channelClearFchannel = channelRestForm.getChannelClearFchannel();
            if (StringUtils.isNotBlank((String)channelClearFchannel)) {
                pePaymentDomain.setFchannelCode(channelClearFchannel);
            } else {
                this.setDefaultFchannelCode(pePaymentDomain);
                channelRestForm.setChannelClearFchannel(pePaymentDomain.getFchannelCode());
                extjs = JsonUtil.buildNormalBinder().toJson((Object)channelRestForm);
            }
        }
        String calljson = "{\"callmap\":" + callparam + ",\"channelRestForm\":" + extjs + "}";
        pePaymentReorderDomain.setPaymentReorderMemo(calljson);
        return this.pePaymentService.savePaymentReorder(pePaymentReorderDomain);
    }

    private void setDefaultFchannelCode(PePaymentDomain pePaymentDomain) {
        if (pePaymentDomain == null) {
            return;
        }
        if (ListUtil.isEmpty(pePaymentDomain.getOrderDomainList())) {
            return;
        }
        if (ListUtil.isEmpty(pePaymentDomain.getOrderDomainList().get(0).getParticipantDomainList())) {
            return;
        }
        for (PePaymentParticipantDomain part : pePaymentDomain.getOrderDomainList().get(0).getParticipantDomainList()) {
            if (!DicactorEnum.BANK.getCode().equals(part.getDicActorCode())) continue;
            pePaymentDomain.setFchannelCode(part.getFchannelCode());
        }
    }

    private PePaymentReorderDomain makeReorderDomain(PePaymentDomain pePaymentDomain, PeReorderDomain peReorderDomain) {
        if (null == peReorderDomain || null == pePaymentDomain) {
            return null;
        }
        PePaymentReorderDomain pePaymentReorderDomain = new PePaymentReorderDomain();
        pePaymentReorderDomain.setPartnerCode(pePaymentDomain.getPartnerCode());
        pePaymentReorderDomain.setPaymentOrderSeqno(peReorderDomain.getPaymentOrderSeqno());
        pePaymentReorderDomain.setPaymentReorderMemo(peReorderDomain.getPaymentReorderMemo());
        pePaymentReorderDomain.setPaymentReorderUrl(pePaymentDomain.getPaymentReturnurl());
        pePaymentReorderDomain.setPaymentSeqno(pePaymentDomain.getPaymentSeqno());
        pePaymentReorderDomain.setPtradeSeqno(pePaymentDomain.getPtradeSeqno());
        pePaymentReorderDomain.setTenantCode(pePaymentDomain.getTenantCode());
        return pePaymentReorderDomain;
    }

    private List<PeProtClearinfo> execute(PePaymentDomain pePaymentDomain, String startType) {
        if (null == pePaymentDomain || null == pePaymentDomain.getOrderDomainList() || pePaymentDomain.getOrderDomainList().isEmpty()) {
            throw new ApiException("pe.PePayEngineBaseServiceImpl.execute.null", "null");
        }
        ArrayList<PeProtClearinfoDomain> clearinfoDomianList = new ArrayList<PeProtClearinfoDomain>();
        ArrayList<PeCflowPprocessDomain> peCflowPprocessDomainList = new ArrayList<PeCflowPprocessDomain>();
        List nodeReList = null;
        ClearInfoContext clearInfoContext = null;
        for (PePaymentOrderDomain pePaymentOrderDomain : pePaymentDomain.getOrderDomainList()) {
            if (StringUtils.isBlank((String)pePaymentOrderDomain.getCflowNodeCode())) {
                PeCflowReDomain peCflowReDomain = (PeCflowReDomain)DisUtil.getMapJson((String)"peProtCflow", (String)(pePaymentOrderDomain.getDicPaypdCode() + "-" + pePaymentOrderDomain.getTenantCode()), PeCflowReDomain.class);
                if (null == peCflowReDomain) {
                    peCflowReDomain = (PeCflowReDomain)DisUtil.getMapJson((String)"peProtCflow", (String)(pePaymentOrderDomain.getDicPaypdCode() + "-00000000"), PeCflowReDomain.class);
                }
                if (null == peCflowReDomain) {
                    throw new ApiException("pe.PePayEngineBaseServiceImpl.execute.noflow", "null", "\u3010" + pePaymentOrderDomain.getDicPaypdCode() + "\u3011:\u3010" + pePaymentOrderDomain.getTenantCode() + "\u3011\u65e0\u6d41\u7a0b\u914d\u7f6e");
                }
                nodeReList = peCflowReDomain.getNodeReList();
            } else {
                PeCflowNode peCflowNode = (PeCflowNode)DisUtil.getMapJson((String)"peProtCflowNode", (String)(pePaymentOrderDomain.getCflowNodeCode() + "-" + pePaymentOrderDomain.getTenantCode()), PeCflowNode.class);
                if (null == peCflowNode) {
                    peCflowNode = (PeCflowNode)DisUtil.getMapJson((String)"peProtCflowNode", (String)(pePaymentOrderDomain.getCflowNodeCode() + "-00000000"), PeCflowNode.class);
                }
                if (null == peCflowNode) {
                    throw new ApiException("pe.PePayEngineBaseServiceImpl.savePaymentNext.peCflowNode", pePaymentOrderDomain.getCflowNodeCode());
                }
                nodeReList = DisUtil.getMapListJson((String)"peProtCflowNodeByParent", (String)(peCflowNode.getCflowCode() + "-" + peCflowNode.getCflowNodeNextcode() + "-" + peCflowNode.getTenantCode()), PeCflowNodeReDomain.class);
                if (ListUtil.isEmpty((Collection)nodeReList)) {
                    nodeReList = DisUtil.getMapListJson((String)"peProtCflowNodeByParent", (String)(peCflowNode.getCflowCode() + "-" + peCflowNode.getCflowNodeNextcode() + "-00000000"), PeCflowNodeReDomain.class);
                }
                if (ListUtil.isEmpty((Collection)nodeReList)) continue;
            }
            clearInfoContext = new ClearInfoContext(startType, clearinfoDomianList, peCflowPprocessDomainList, pePaymentDomain, pePaymentOrderDomain, nodeReList, null);
            this.createClearInfo(clearInfoContext);
        }
        this.logger.info("pe.PePayEngineBaseServiceImplexecute\u4ea4\u6613\u53f7" + pePaymentDomain.getPaymentSeqno(), (Object)("peCflowPprocessDomainList is null(" + ListUtil.isEmpty(peCflowPprocessDomainList) + ")-clearinfoDomianList is null(" + ListUtil.isEmpty(clearinfoDomianList)));
        if (null != peCflowPprocessDomainList && !peCflowPprocessDomainList.isEmpty()) {
            this.saveBatchCflowPprocess(peCflowPprocessDomainList, clearInfoContext.isNeedUpdateProcess());
        }
        if (null == clearinfoDomianList || clearinfoDomianList.isEmpty()) {
            this.logger.info("pe.PePayEngineBaseServiceImplexecute\u4ea4\u6613\u53f7" + pePaymentDomain.getPaymentSeqno(), (Object)"\u6d41\u7a0b\u7ed3\u675f");
            return null;
        }
        List<PeProtClearinfo> peProtClearinfoList = this.pePayClearService.saveProtClearinfoBatch(clearinfoDomianList);
        return peProtClearinfoList;
    }

    private void createClearInfo(ClearInfoContext clearInfoContext) {
        if (null == clearInfoContext.getNodeReList() || clearInfoContext.getNodeReList().isEmpty() || null == clearInfoContext.getInfoList() || null == clearInfoContext.getPeCflowPprocessDomainList() || null == clearInfoContext.getPePaymentOrderDomain().getParticipantDomainList()) {
            throw new ApiException("pe.PePayEngineBaseServiceImpl.createClearInfo.null", "null");
        }
        HashMap<String, Object> conMap = new HashMap<String, Object>();
        conMap.put(this.conmap_key_startType, clearInfoContext.getStartType());
        conMap.put(this.conmap_key_payment, clearInfoContext.getPePaymentDomain());
        conMap.put(this.conmap_key_order, clearInfoContext.getPePaymentOrderDomain());
        HashMap<String, PePaymentParticipantDomain> pcMap = new HashMap<String, PePaymentParticipantDomain>();
        for (PePaymentParticipantDomain pePaymentParticipantDomain : clearInfoContext.getPePaymentOrderDomain().getParticipantDomainList()) {
            pcMap.put(pePaymentParticipantDomain.getDicActorCode(), pePaymentParticipantDomain);
        }
        conMap.put(this.conmap_key_participant, pcMap);
        clearInfoContext.setConMap(conMap);
        this.createCflowList(clearInfoContext);
    }

    private void createCflowList(ClearInfoContext clearInfoContext) {
        PePaymentDomain pePaymentDomain = clearInfoContext.getPePaymentDomain();
        PePaymentOrderDomain pePaymentOrderDomain = clearInfoContext.getPePaymentOrderDomain();
        List<PeCflowNodeReDomain> nodeReList = clearInfoContext.getNodeReList();
        List<PeProtClearinfoDomain> infoList = clearInfoContext.getInfoList();
        List<PeCflowPprocessDomain> peCflowPprocessDomainList = clearInfoContext.getPeCflowPprocessDomainList();
        Map<String, Object> conMap = clearInfoContext.getConMap();
        PeReorderDomain peReorderDomain = clearInfoContext.getPeReorderDomain();
        if (null == nodeReList || null == infoList || null == peCflowPprocessDomainList) {
            throw new ApiException("pe.PePayEngineBaseServiceImpl.createCflowList.null", "null");
        }
        int index = 99;
        int nowIndex = 0;
        boolean parallel = false;
        PeCflowNodeReDomain endPeCflowNodeReDomain = null;
        for (PeCflowNodeReDomain peCflowNodeReDomain : nodeReList) {
            if (peCflowNodeReDomain.getCflowNodeNextcode().equals(peCflowNodeReDomain.getCflowCode()) && StringUtils.isBlank((String)peCflowNodeReDomain.getCflowPserviceCode())) {
                if (!StringUtils.isNotBlank((String)peCflowNodeReDomain.getCflowNodeStart()) || !peCflowNodeReDomain.getCflowNodeStart().equals((String)conMap.get(this.conmap_key_startType))) continue;
                this.logger.debug("pe.PePayEngineBaseServiceImpl.excetuCon.end", (Object)"end");
                endPeCflowNodeReDomain = peCflowNodeReDomain;
                continue;
            }
            if (!this.excetuCon(conMap, peCflowNodeReDomain)) continue;
            if (StringUtils.isBlank((String)peCflowNodeReDomain.getCflowNodeIndex())) {
                peCflowNodeReDomain.setCflowNodeIndex("0");
            }
            if ((nowIndex = Integer.valueOf(peCflowNodeReDomain.getCflowNodeIndex()).intValue()) > index && nowIndex != EXECUTE_INDEX) continue;
            PeCflowPserviceReDomain peCflowPserviceReDomain = this.getPservice(peCflowNodeReDomain);
            if (null == peCflowPserviceReDomain && peCflowNodeReDomain.getCflowCode().equals(peCflowNodeReDomain.getCflowNodeNextcode())) {
                throw new ApiException("pe.PePayEngineBaseServiceImpl.createCflowList.noservice", "null");
            }
            if (!this.excetuConJs(conMap, peCflowPserviceReDomain.getCflowPserviceItemCn())) continue;
            PeCflowPprocessDomain peCflowPprocessDomain = this.createProcess(pePaymentOrderDomain, peCflowPprocessDomainList, peCflowNodeReDomain, false);
            PeProtClearinfoDomain peProtClearinfoDomain = this.createClearinfo(peCflowPprocessDomain, pePaymentDomain, pePaymentOrderDomain, peCflowPserviceReDomain, peCflowNodeReDomain);
            if (null != peProtClearinfoDomain && StringUtils.isNotBlank((String)peCflowNodeReDomain.getDicActorCode())) {
                peProtClearinfoDomain.setDicActorCode(peCflowNodeReDomain.getDicActorCode());
            }
            infoList.add(peProtClearinfoDomain);
            if (nowIndex != EXECUTE_INDEX) {
                index = nowIndex;
            } else {
                parallel = true;
            }
            this.callStart(this.makePeCflowNode(peCflowNodeReDomain), pePaymentDomain, peReorderDomain, 0);
        }
        if (index == 99 && parallel) {
            clearInfoContext.setNeedUpdateProcess(false);
        }
        if (peCflowPprocessDomainList.isEmpty() && null != endPeCflowNodeReDomain && null != peReorderDomain) {
            this.createProcess(pePaymentOrderDomain, peCflowPprocessDomainList, endPeCflowNodeReDomain, true);
            this.call(this.makePeCflowNode(endPeCflowNodeReDomain), pePaymentDomain, peReorderDomain, 2);
        }
    }

    private PeCflowNode makePeCflowNode(PeCflowNodeReDomain peCflowNodeReDomain) {
        if (null == peCflowNodeReDomain) {
            return null;
        }
        PeCflowNode peCflowNode = new PeCflowNode();
        try {
            BeanUtils.copyAllPropertys((Object)peCflowNode, (Object)peCflowNodeReDomain);
            return peCflowNode;
        }
        catch (Exception e) {
            return null;
        }
    }

    private PeCflowPprocessDomain createProcess(PePaymentOrderDomain pePaymentOrderDomain, List<PeCflowPprocessDomain> peCflowPprocessDomainList, PeCflowNodeReDomain peCflowNodeReDomain, boolean endFlag) {
        PeCflowPprocessDomain peCflowPprocessDomain = this.createPprocessDomain(pePaymentOrderDomain, peCflowNodeReDomain, endFlag);
        if (null == peCflowPprocessDomain) {
            throw new ApiException("pe.PePayEngineBaseServiceImpl.createCflowList.pprocess", "null");
        }
        peCflowPprocessDomainList.add(peCflowPprocessDomain);
        return peCflowPprocessDomain;
    }

    private PeProtClearinfoDomain createClearinfo(PeCflowPprocessDomain peCflowPprocessDomain, PePaymentDomain pePaymentDomain, PePaymentOrderDomain pePaymentOrderDomain, PeCflowPserviceReDomain peCflowPserviceReDomain, PeCflowNodeReDomain peCflowNodeReDomain) {
        if (null == pePaymentOrderDomain || null == peCflowPserviceReDomain) {
            throw new ApiException("pe.PePayEngineBaseServiceImpl.createClearinfo.null", "null");
        }
        PeProtEtc peProtEtc = (PeProtEtc)DisUtil.getMapJson((String)PeProtEtcServiceImpl.CACHE_KEY_ETC, (String)(peCflowPserviceReDomain.getProtEtcCode() + "-" + peCflowPserviceReDomain.getTenantCode()), PeProtEtc.class);
        if (null == peProtEtc) {
            peProtEtc = (PeProtEtc)DisUtil.getMapJson((String)PeProtEtcServiceImpl.CACHE_KEY_ETC, (String)(peCflowPserviceReDomain.getProtEtcCode() + "-00000000"), PeProtEtc.class);
        }
        if (null == peProtEtc) {
            throw new ApiException("pe.PePayEngineBaseServiceImpl.createClearinfo.peProtEtc", peCflowPserviceReDomain.getProtEtcCode() + "-" + peCflowPserviceReDomain.getTenantCode());
        }
        PeProtClearinfoDomain peProtClearinfoDomain = new PeProtClearinfoDomain();
        peProtClearinfoDomain.setDicActorCode(peCflowPserviceReDomain.getDicActorCode());
        peProtClearinfoDomain.setCflowPprocessCode(peCflowPprocessDomain.getCflowPprocessCode());
        peProtClearinfoDomain.setDicPayType(peCflowPserviceReDomain.getDicPayType());
        peProtClearinfoDomain.setDicClearCode(peCflowPserviceReDomain.getDicClearCode());
        peProtClearinfoDomain.setDicClearreqCode(peCflowPserviceReDomain.getDicClearreqCode());
        peProtClearinfoDomain.setOrderAmount(pePaymentOrderDomain.getOrderAmount());
        peProtClearinfoDomain.setOrderCurrency(pePaymentOrderDomain.getOrderCurrency());
        peProtClearinfoDomain.setOrderPortion(pePaymentOrderDomain.getOrderPortion());
        peProtClearinfoDomain.setOrderPrice(pePaymentOrderDomain.getOrderPrice());
        peProtClearinfoDomain.setPartnerCode(pePaymentDomain.getPartnerCode());
        peProtClearinfoDomain.setPaymentOrderSeqno(pePaymentOrderDomain.getPaymentOrderSeqno());
        peProtClearinfoDomain.setPaymentSeqno(pePaymentOrderDomain.getPaymentSeqno());
        peProtClearinfoDomain.setTenantCode(pePaymentOrderDomain.getTenantCode());
        peProtClearinfoDomain.setProtEtcCode(peCflowPserviceReDomain.getProtEtcCode());
        peProtClearinfoDomain.setProtEtcSeqno(peProtEtc.getProtEtcSeqno());
        peProtClearinfoDomain.setProtEtcCode(peProtEtc.getProtEtcCode());
        peProtClearinfoDomain.setBusinessType(pePaymentDomain.getBusinessType());
        peProtClearinfoDomain.setBusinessOrder(pePaymentDomain.getBusinessOrder());
        peProtClearinfoDomain.setBusinessOrderno(pePaymentDomain.getBusinessOrderno());
        if ("N".equals(peCflowNodeReDomain.getCflowNodeAsyn())) {
            peProtClearinfoDomain.setClearAsync(true);
        }
        return peProtClearinfoDomain;
    }

    public String createProtEtcSeqno(String protEtcSeqnoEx, PePaymentOrderDomain pePaymentOrderDomain) {
        if (null == pePaymentOrderDomain) {
            return "";
        }
        if (StringUtils.isBlank((String)protEtcSeqnoEx) || "-".equals(protEtcSeqnoEx)) {
            return "-";
        }
        String[] paStr = protEtcSeqnoEx.split("+");
        if (null == paStr) {
            return protEtcSeqnoEx;
        }
        String protEtcSeqno = "";
        String proName = "";
        for (int i = 0; i < paStr.length; ++i) {
            proName = paStr[i];
            if (StringUtils.isNotBlank((String)protEtcSeqno)) {
                protEtcSeqno = protEtcSeqno + "-";
            }
            if (proName.indexOf("$") >= 0) {
                proName = proName.replace("$", "").replace("{", "").replace("}", "").trim();
                protEtcSeqno = protEtcSeqno + (String)BeanUtils.forceGetProperty((Object)pePaymentOrderDomain, (String)proName);
                continue;
            }
            protEtcSeqno = protEtcSeqno + proName;
        }
        return protEtcSeqno;
    }

    private PeCflowPprocessDomain createPprocessDomain(PePaymentOrderDomain pePaymentOrderDomain, PeCflowNodeReDomain peCflowNodeReDomain, boolean endFlag) {
        if (null == peCflowNodeReDomain || null == pePaymentOrderDomain) {
            return null;
        }
        PeCflowPprocessDomain peCflowPprocessDomain = new PeCflowPprocessDomain();
        peCflowPprocessDomain.setCflowPprocessCode(this.createUUIDString());
        peCflowPprocessDomain.setCflowCode(peCflowNodeReDomain.getCflowCode());
        peCflowPprocessDomain.setCflowNodeCode(peCflowNodeReDomain.getCflowNodeCode());
        peCflowPprocessDomain.setCflowPprocessTime(new Date());
        peCflowPprocessDomain.setPaymentOrderSeqno(pePaymentOrderDomain.getPaymentOrderSeqno());
        peCflowPprocessDomain.setPaymentSeqno(pePaymentOrderDomain.getPaymentSeqno());
        peCflowPprocessDomain.setTenantCode(pePaymentOrderDomain.getTenantCode());
        peCflowPprocessDomain.setEndFlag(endFlag);
        return peCflowPprocessDomain;
    }

    private boolean excetuCon(Map<String, Object> conMap, PeCflowNodeReDomain peCflowNodeReDomain) {
        if (null == peCflowNodeReDomain || null == conMap || conMap.isEmpty()) {
            return false;
        }
        if (peCflowNodeReDomain.getCflowNodeNextcode().equals(peCflowNodeReDomain.getCflowCode()) && StringUtils.isBlank((String)peCflowNodeReDomain.getCflowPserviceCode())) {
            this.logger.debug("pe.PePayEngineBaseServiceImpl.excetuCon.end", (Object)"end");
            return false;
        }
        if (!conMap.get(this.conmap_key_startType).equals(peCflowNodeReDomain.getCflowNodeStart())) {
            this.logger.debug("pe.PePayEngineBaseServiceImpl.excetuCon.startType", (Object)("conmap_key_startType:" + conMap.get(this.conmap_key_startType) + "-" + peCflowNodeReDomain.getCflowNodeStart()));
            return false;
        }
        if (StringUtils.isNotBlank((String)peCflowNodeReDomain.getCflowNodeStart()) && !peCflowNodeReDomain.getCflowNodeStart().equals((String)conMap.get(this.conmap_key_startType))) {
            this.logger.debug("pe.PePayEngineBaseServiceImpl.excetuCon.fchannelType", (Object)("fchannelType:" + (String)conMap.get(this.conmap_key_startType) + "-" + peCflowNodeReDomain.getCflowNodeStart()));
            return false;
        }
        return this.excetuConJs(conMap, peCflowNodeReDomain.getCflowNodeCondition());
    }

    private boolean excetuConJs(Map<String, Object> conMap, String conStr) {
        if (StringUtils.isBlank((String)conStr)) {
            return true;
        }
        String res = (String)ScriptUtil.evel((String)conStr, conMap);
        if (!"ok".equals(res)) {
            this.logger.debug("pe.PePayEngineBaseServiceImpl.excetuCon.js", (Object)("condition:" + conStr));
            return false;
        }
        return true;
    }

    private PeCflowPserviceReDomain getPservice(PeCflowNodeReDomain peCflowNodeReDomain) {
        if (null == peCflowNodeReDomain || StringUtils.isBlank((String)peCflowNodeReDomain.getCflowPserviceCode())) {
            return null;
        }
        PeCflowPserviceReDomain peCflowPserviceReDomain = (PeCflowPserviceReDomain)DisUtil.getMapJson((String)"PeCflowPservice", (String)(peCflowNodeReDomain.getCflowPserviceCode() + "-" + peCflowNodeReDomain.getTenantCode()), PeCflowPserviceReDomain.class);
        if (null == peCflowPserviceReDomain) {
            throw new ApiException("pe.PePayEngineBaseServiceImpl.getPservice.peCflowPserviceReDomainStr", peCflowNodeReDomain.getCflowPserviceCode() + "-" + peCflowNodeReDomain.getTenantCode());
        }
        return peCflowPserviceReDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeProtClearinfo> savePaymentDomainNext(PePaymentDomain pePaymentDomain) throws ApiException {
        this.logger.error("pe.PePayEngineBaseServiceImpl.savePaymentDomainNext.pePaymentDomain" + JsonUtil.buildNormalBinder().toJson((Object)pePaymentDomain));
        if (null == pePaymentDomain) {
            return null;
        }
        long start = System.currentTimeMillis();
        try {
            if (StringUtils.isBlank((String)pePaymentDomain.getOrderDomainList().get(0).getCflowNodeCode()) && 0 == pePaymentDomain.getDataState()) {
                this.pePaymentService.updatePaymentState(pePaymentDomain.getPaymentId(), 1, 0);
            }
            List<PeProtClearinfo> list = this.execute(pePaymentDomain, pePaymentDomain.getPaymentType());
            return list;
        }
        finally {
            OpenPerfLogUtil.debug((String)("pePayEngineService savePaymentDomainNext end time consuming:{}ms,paymentSeqno=" + pePaymentDomain.getPaymentSeqno()), (long)(System.currentTimeMillis() - start));
        }
    }

    @Override
    public List<PeProtClearinfo> savePaymentDomainBack(PePaymentDomain pePaymentDomain) throws ApiException {
        if (null == pePaymentDomain) {
            return null;
        }
        this.pePaymentService.updatePaymentState(pePaymentDomain.getPaymentId(), 2, 1);
        return this.execute(pePaymentDomain, FlowStartCon.AB.getCode());
    }
}

