/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.payengine.enumc.PortEtcType;
import com.yqbsoft.laser.service.payengine.model.PeProtEtcInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EtcInfoProcessService {
    private static Map<String, PeProtEtcInfo> etcInfoRtMap = new ConcurrentHashMap<String, PeProtEtcInfo>();
    private static Map<String, PeProtEtcInfo> etcInfoAsMap = new ConcurrentHashMap<String, PeProtEtcInfo>();
    private Object lock = new Object();
    private static Map<String, String> etcInfoExcuteMap = new ConcurrentHashMap<String, String>();
    private Object exlock = new Object();

    public PeProtEtcInfo get(String cacheKey) {
        PeProtEtcInfo peProtEtcInfo = etcInfoAsMap.get(cacheKey);
        if (null == peProtEtcInfo) {
            etcInfoRtMap.get(cacheKey);
        }
        return peProtEtcInfo;
    }

    public PeProtEtcInfo getRt(String cacheKey) {
        return etcInfoRtMap.get(cacheKey);
    }

    public PeProtEtcInfo getAs(String cacheKey) {
        return etcInfoAsMap.get(cacheKey);
    }

    public boolean containsKeyRt(String cacheKey) {
        return etcInfoRtMap.containsKey(cacheKey);
    }

    public boolean containsKeyAs(String cacheKey) {
        return etcInfoAsMap.containsKey(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCache(PeProtEtcInfo peProtEtcInfo) {
        if (null == peProtEtcInfo) {
            return;
        }
        String type = peProtEtcInfo.getProtEtcType();
        Object object = this.lock;
        synchronized (object) {
            if (PortEtcType.RT.getCode().equals(type)) {
                etcInfoRtMap.put(peProtEtcInfo.getProtEtcSeqno() + "-" + peProtEtcInfo.getTenantCode(), peProtEtcInfo);
            } else {
                etcInfoAsMap.put(peProtEtcInfo.getProtEtcSeqno() + "-" + peProtEtcInfo.getTenantCode(), peProtEtcInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockExcute(String protEtcSeqno, String tenantCode) {
        Object object = this.exlock;
        synchronized (object) {
            String key = protEtcSeqno + "-" + tenantCode;
            if (etcInfoExcuteMap.containsKey(key)) {
                return false;
            }
            etcInfoExcuteMap.put(key, key);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLockExcute(String protEtcSeqno, String tenantCode) {
        Object object = this.exlock;
        synchronized (object) {
            etcInfoExcuteMap.remove(protEtcSeqno + "-" + tenantCode);
        }
    }
}

