/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.dao.PeClearCtrlMapper;
import com.yqbsoft.laser.service.payengine.dao.PeClearOrderMapper;
import com.yqbsoft.laser.service.payengine.dao.PeClearRespMapper;
import com.yqbsoft.laser.service.payengine.domain.PayClearInfoQ;
import com.yqbsoft.laser.service.payengine.domain.PeClearCtrlDomain;
import com.yqbsoft.laser.service.payengine.domain.PeClearOrderDomain;
import com.yqbsoft.laser.service.payengine.domain.PeClearRespDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtEtcDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtEtcInfoDomain;
import com.yqbsoft.laser.service.payengine.domain.PeReorderDomain;
import com.yqbsoft.laser.service.payengine.enumc.PortEtcType;
import com.yqbsoft.laser.service.payengine.model.PeClearCtrl;
import com.yqbsoft.laser.service.payengine.model.PeClearOrder;
import com.yqbsoft.laser.service.payengine.model.PeClearResp;
import com.yqbsoft.laser.service.payengine.model.PeProtEtc;
import com.yqbsoft.laser.service.payengine.model.PeProtEtcInfo;
import com.yqbsoft.laser.service.payengine.service.PeClearOrderService;
import com.yqbsoft.laser.service.payengine.service.PeProtClearagService;
import com.yqbsoft.laser.service.payengine.service.PeProtEtcService;
import com.yqbsoft.laser.service.payengine.service.impl.ClearCallPollThread;
import com.yqbsoft.laser.service.payengine.service.impl.ClearCallService;
import com.yqbsoft.laser.service.payengine.service.impl.ClearProcessRtService;
import com.yqbsoft.laser.service.payengine.service.impl.ClearProcessService;
import com.yqbsoft.laser.service.payengine.service.impl.EtcInfoPollThread;
import com.yqbsoft.laser.service.payengine.service.impl.EtcInfoProcessService;
import com.yqbsoft.laser.service.payengine.service.impl.EtcInfoPutThread;
import com.yqbsoft.laser.service.payengine.service.impl.EtcInfoRtPollThread;
import com.yqbsoft.laser.service.payengine.service.impl.PeProtEtcServiceImpl;
import com.yqbsoft.laser.service.payengine.service.impl.ProtEtcPollThread;
import com.yqbsoft.laser.service.payengine.service.impl.ProtEtcService;
import com.yqbsoft.laser.service.payengine.service.impl.RuleService;
import com.yqbsoft.laser.service.suppercore.supper.SupperRuestDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.quartz.CronExpression;

public class PeClearOrderServiceImpl
extends BaseServiceImpl
implements PeClearOrderService {
    public static final String SYS_CODE = "pe.PeClearOrderServiceImpl";
    private PeClearOrderMapper peClearOrderMapper;
    private PeClearCtrlMapper peClearCtrlMapper;
    private PeClearRespMapper peClearRespMapper;
    private PeProtClearagService peProtClearagService;
    private PeProtEtcService peProtEtcService;
    private static ClearCallService clearCallService;
    private static Object callLock;
    private static EtcInfoProcessService etcInfoProcessService;
    private static Object etcProcesslock;
    private static Map<String, ClearProcessService> etcInfo;
    private static Object etclock;
    private static ClearProcessRtService clearProcessRtService;
    private static Object lock;
    private Object etcLock = new Object();
    private static ProtEtcService protEtcService;
    private static Object obj;
    private RuleService ruleService = new RuleService();

    public PeProtEtcService getPeProtEtcService() {
        return this.peProtEtcService;
    }

    public void setPeProtEtcService(PeProtEtcService peProtEtcService) {
        this.peProtEtcService = peProtEtcService;
    }

    public void setPeProtClearagService(PeProtClearagService peProtClearagService) {
        this.peProtClearagService = peProtClearagService;
    }

    public void setPeClearOrderMapper(PeClearOrderMapper peClearOrderMapper) {
        this.peClearOrderMapper = peClearOrderMapper;
    }

    public void setPeClearCtrlMapper(PeClearCtrlMapper peClearCtrlMapper) {
        this.peClearCtrlMapper = peClearCtrlMapper;
    }

    public void setPeClearRespMapper(PeClearRespMapper peClearRespMapper) {
        this.peClearRespMapper = peClearRespMapper;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkClearOrder(PeClearOrderDomain peClearOrderDomain) {
        if (null == peClearOrderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setClearOrderDefault(PeClearOrder peClearOrder) {
        if (null == peClearOrder) {
            return;
        }
        if (null == peClearOrder.getDataState()) {
            peClearOrder.setDataState(0);
        }
        if (null == peClearOrder.getClearOrderState()) {
            peClearOrder.setClearOrderState(0);
        }
        Date date = this.getSysDate();
        if (null == peClearOrder.getGmtCreate()) {
            peClearOrder.setGmtCreate(date);
        }
        peClearOrder.setGmtModified(date);
        if (StringUtils.isBlank((String)peClearOrder.getClearOrderSeqno())) {
            peClearOrder.setClearOrderSeqno(this.createUUIDString());
        }
    }

    private int getClearOrderMaxCode() {
        int code = 0;
        try {
            return this.peClearOrderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getClearOrderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setClearOrderUpdataDefault(PeClearOrder peClearOrder) {
        if (null == peClearOrder) {
            return;
        }
        peClearOrder.setGmtModified(this.getSysDate());
    }

    private void saveClearOrderModel(PeClearOrder peClearOrder) throws ApiException {
        if (null == peClearOrder) {
            return;
        }
        try {
            this.peClearOrderMapper.insert(peClearOrder);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearOrderModel.ex", (Throwable)e);
        }
    }

    private void saveClearOrderBatchModel(List<PeClearOrder> peClearOrderList) throws ApiException {
        if (null == peClearOrderList || peClearOrderList.isEmpty()) {
            return;
        }
        try {
            this.peClearOrderMapper.insertBatch(peClearOrderList);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearOrderBatchModel.ex", (Throwable)e);
        }
    }

    private PeClearOrder getClearOrderModelById(Integer clearOrderId) {
        if (null == clearOrderId) {
            return null;
        }
        try {
            return this.peClearOrderMapper.selectByPrimaryKey(clearOrderId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getClearOrderModelById", (Throwable)e);
            return null;
        }
    }

    public PeClearOrder getClearOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peClearOrderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getClearOrderModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delClearOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peClearOrderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.delClearOrderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeClearOrderServiceImpl.delClearOrderModelByCode.num");
        }
    }

    private void deleteClearOrderModel(Integer clearOrderId) throws ApiException {
        if (null == clearOrderId) {
            return;
        }
        int i = 0;
        try {
            i = this.peClearOrderMapper.deleteByPrimaryKey(clearOrderId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.deleteClearOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeClearOrderServiceImpl.deleteClearOrderModel.num");
        }
    }

    private void updateClearOrderModel(PeClearOrder peClearOrder) throws ApiException {
        if (null == peClearOrder) {
            return;
        }
        try {
            this.peClearOrderMapper.updateByPrimaryKeySelective(peClearOrder);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateClearOrderModel.ex", (Throwable)e);
        }
    }

    private void updateStateClearOrderByCodeModel(String clearOrderSeqno, String protEtcInfoSeqno, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == clearOrderSeqno || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clearOrderSeqno", clearOrderSeqno);
        map.put("protEtcInfoSeqno", protEtcInfoSeqno);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.peClearOrderMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateStateClearOrderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateStateClearOrderModel.null", ((Object)map).toString());
        }
    }

    public int updateEtcInfoByEtcModel(String protEtcInfoSeqno, String tenantCode, String protEtcSeqno) throws ApiException {
        if (null == protEtcInfoSeqno || null == protEtcSeqno) {
            return 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protEtcInfoSeqno", protEtcInfoSeqno);
        map.put("protEtcSeqno", protEtcSeqno);
        map.put("tenantCode", tenantCode);
        map.put("dataState", 0);
        int i = 0;
        try {
            i = this.peClearOrderMapper.updateEtcInfoByEtc(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateEtcInfoByEtcModel.ex", (Throwable)e);
        }
        if (i < 0) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateEtcInfoByEtcModel.null");
        }
        return i;
    }

    private void updateStateClearOrderModel(Integer clearOrderId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == clearOrderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clearOrderId", clearOrderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peClearOrderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateStateClearOrderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateStateClearOrderModel.null");
        }
    }

    private int updateCallStateClearOrderBySeqoModel(String cflowPprocessCode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cflowPprocessCode || null == dataState) {
            return 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cflowPprocessCode", cflowPprocessCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.peClearOrderMapper.updateCallStateBySeqo(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateCallStateClearOrderBySeqoModel.ex", (Throwable)e);
        }
        if (i < 0) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateCallStateClearOrderBySeqoModel.null");
        }
        return i;
    }

    private PeClearOrder makeClearOrder(PeClearOrderDomain peClearOrderDomain, PeClearOrder peClearOrder) {
        if (null == peClearOrderDomain) {
            return null;
        }
        if (null == peClearOrder) {
            peClearOrder = new PeClearOrder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peClearOrder, (Object)peClearOrderDomain);
            return peClearOrder;
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.makeClearOrder", (Throwable)e);
            return null;
        }
    }

    private List<PeClearOrder> queryClearOrderModelPage(Map<String, Object> parammap) {
        try {
            return this.peClearOrderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.queryClearOrderModel", (Throwable)e);
            return null;
        }
    }

    private int countClearOrder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peClearOrderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.countClearOrder", (Throwable)e);
        }
        return i;
    }

    private String checkClearCtrl(PeClearCtrlDomain peClearCtrlDomain) {
        if (null == peClearCtrlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setClearCtrlDefault(PeClearCtrl peClearCtrl) {
        if (null == peClearCtrl) {
            return;
        }
        if (null == peClearCtrl.getDataState()) {
            peClearCtrl.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == peClearCtrl.getGmtCreate()) {
            peClearCtrl.setGmtCreate(date);
        }
        peClearCtrl.setGmtModified(date);
    }

    private int getClearCtrlMaxCode() {
        int code = 0;
        try {
            return this.peClearCtrlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getClearCtrlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setClearCtrlUpdataDefault(PeClearCtrl peClearCtrl) {
        if (null == peClearCtrl) {
            return;
        }
        peClearCtrl.setGmtModified(this.getSysDate());
    }

    private void saveClearCtrlModel(PeClearCtrl peClearCtrl) throws ApiException {
        if (null == peClearCtrl) {
            return;
        }
        try {
            this.peClearCtrlMapper.insert(peClearCtrl);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearCtrlModel.ex", (Throwable)e);
        }
    }

    private void saveClearCtrlBatchModel(List<PeClearCtrl> peClearCtrlList) throws ApiException {
        if (null == peClearCtrlList || peClearCtrlList.isEmpty()) {
            return;
        }
        try {
            this.peClearCtrlMapper.insertBatch(peClearCtrlList);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearCtrlModel.ex", (Throwable)e);
        }
    }

    private PeClearCtrl getClearCtrlModelById(Integer clearCtrlId) {
        if (null == clearCtrlId) {
            return null;
        }
        try {
            return this.peClearCtrlMapper.selectByPrimaryKey(clearCtrlId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getClearCtrlModelById", (Throwable)e);
            return null;
        }
    }

    public PeClearCtrl getClearCtrlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peClearCtrlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getClearCtrlModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delClearCtrlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peClearCtrlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.delClearCtrlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeClearOrderServiceImpl.delClearCtrlModelByCode.num");
        }
    }

    private void deleteClearCtrlModel(Integer clearCtrlId) throws ApiException {
        if (null == clearCtrlId) {
            return;
        }
        int i = 0;
        try {
            i = this.peClearCtrlMapper.deleteByPrimaryKey(clearCtrlId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.deleteClearCtrlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeClearOrderServiceImpl.deleteClearCtrlModel.num");
        }
    }

    private void updateClearCtrlModel(PeClearCtrl peClearCtrl) throws ApiException {
        if (null == peClearCtrl) {
            return;
        }
        try {
            this.peClearCtrlMapper.updateByPrimaryKeySelective(peClearCtrl);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateClearCtrlModel.ex", (Throwable)e);
        }
    }

    private void updateStateClearCtrlModel(Integer clearCtrlId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == clearCtrlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clearCtrlId", clearCtrlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peClearCtrlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateStateClearCtrlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateStateClearCtrlModel.null");
        }
    }

    private PeClearCtrl makeClearCtrl(PeClearCtrlDomain peClearCtrlDomain, PeClearCtrl peClearCtrl) {
        if (null == peClearCtrlDomain) {
            return null;
        }
        if (null == peClearCtrl) {
            peClearCtrl = new PeClearCtrl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peClearCtrl, (Object)peClearCtrlDomain);
            return peClearCtrl;
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.makeClearCtrl", (Throwable)e);
            return null;
        }
    }

    private List<PeClearCtrl> queryClearCtrlModelPage(Map<String, Object> parammap) {
        try {
            return this.peClearCtrlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.queryClearCtrlModel", (Throwable)e);
            return null;
        }
    }

    private int countClearCtrl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peClearCtrlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.countClearCtrl", (Throwable)e);
        }
        return i;
    }

    private String checkClearResp(PeClearRespDomain peClearRespDomain) {
        if (null == peClearRespDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setClearRespDefault(PeClearResp peClearResp) {
        if (null == peClearResp) {
            return;
        }
        if (null == peClearResp.getDataState()) {
            peClearResp.setDataState(0);
        }
        if (null == peClearResp.getGmtCreate()) {
            peClearResp.setGmtCreate(this.getSysDate());
        }
        peClearResp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)peClearResp.getClearRespSeqno())) {
            peClearResp.setClearRespSeqno(this.createUUIDString());
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.peClearRespMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setClearRespUpdataDefault(PeClearResp peClearResp) {
        if (null == peClearResp) {
            return;
        }
        peClearResp.setGmtModified(this.getSysDate());
    }

    private void saveClearRespModel(PeClearResp peClearResp) throws ApiException {
        if (null == peClearResp) {
            return;
        }
        try {
            this.peClearRespMapper.insert(peClearResp);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearRespModel.ex", (Throwable)e);
        }
    }

    private PeClearResp getClearRespModelById(Integer clearRespId) {
        if (null == clearRespId) {
            return null;
        }
        try {
            return this.peClearRespMapper.selectByPrimaryKey(clearRespId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getClearRespModelById", (Throwable)e);
            return null;
        }
    }

    public PeClearResp getClearRespModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peClearRespMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.getClearRespModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delClearRespModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peClearRespMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.delClearRespModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeClearOrderServiceImpl.delClearRespModelByCode.num");
        }
    }

    private void deleteClearRespModel(Integer clearRespId) throws ApiException {
        if (null == clearRespId) {
            return;
        }
        int i = 0;
        try {
            i = this.peClearRespMapper.deleteByPrimaryKey(clearRespId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.deleteClearRespModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeClearOrderServiceImpl.deleteClearRespModel.num");
        }
    }

    private void updateClearRespModel(PeClearResp peClearResp) throws ApiException {
        if (null == peClearResp) {
            return;
        }
        try {
            this.peClearRespMapper.updateByPrimaryKeySelective(peClearResp);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateClearRespModel.ex", (Throwable)e);
        }
    }

    private void updateStateClearRespModel(Integer clearRespId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == clearRespId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clearRespId", clearRespId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peClearRespMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateStateClearRespModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateStateClearRespModel.null", ((Object)map).toString());
        }
    }

    public void updateCallStateClearRespModel(Integer clearRespId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == clearRespId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clearRespId", clearRespId);
        map.put("clearRespState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peClearRespMapper.updateCallStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateCallStateClearRespModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateCallStateClearRespModel.null", ((Object)map).toString());
        }
    }

    private boolean updateCallStateClearRespByCodeModel(String clearRespSeqno, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == clearRespSeqno || null == dataState) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clearRespSeqno", clearRespSeqno);
        map.put("tenantCode", tenantCode);
        map.put("clearRespState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peClearRespMapper.updateCallStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateCallStateClearRespByCodeModel.ex", (Throwable)e);
        }
        return i > 0;
    }

    private PeClearResp makeClearResp(PeClearRespDomain peClearRespDomain, PeClearResp peClearResp) {
        if (null == peClearRespDomain) {
            return null;
        }
        if (null == peClearResp) {
            peClearResp = new PeClearResp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peClearResp, (Object)peClearRespDomain);
            return peClearResp;
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.makeClearResp", (Throwable)e);
            return null;
        }
    }

    private List<PeClearResp> queryClearRespModelPage(Map<String, Object> parammap) {
        try {
            return this.peClearRespMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.queryClearRespModel", (Throwable)e);
            return null;
        }
    }

    private int countClearResp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peClearRespMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.countClearResp", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveClearOrder(PeClearOrderDomain peClearOrderDomain) throws ApiException {
        PeClearOrder peClearOrder = this.createClearOrder(peClearOrderDomain);
        this.saveClearOrderModel(peClearOrder);
    }

    private PeClearOrder createClearOrder(PeClearOrderDomain peClearOrderDomain) {
        String msg = this.checkClearOrder(peClearOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearOrder.checkClearOrder", msg);
        }
        PeClearOrder peClearOrder = this.makeClearOrder(peClearOrderDomain, null);
        this.setClearOrderDefault(peClearOrder);
        peClearOrderDomain.setClearOrderSeqno(peClearOrder.getClearOrderSeqno());
        return peClearOrder;
    }

    @Override
    public List<PeClearOrder> saveClearOrderBatch(List<PeClearOrderDomain> peClearOrderDomainList) throws ApiException {
        if (null == peClearOrderDomainList || peClearOrderDomainList.isEmpty()) {
            this.logger.error("pe.PeClearOrderServiceImpl.saveClearOrderBatch.null");
            return null;
        }
        long start = System.currentTimeMillis();
        ArrayList<PeClearOrder> orderList = new ArrayList<PeClearOrder>();
        for (PeClearOrderDomain peClearOrderDomain : peClearOrderDomainList) {
            orderList.add(this.createClearOrder(peClearOrderDomain));
        }
        this.saveClearOrderBatchModel(orderList);
        List<PeClearOrder> orderRtList = this.createEtc(orderList);
        this.peProtClearagService.saveProtClearinfoNext(this.createReorder(peClearOrderDomainList));
        OpenPerfLogUtil.info((String)("PeClearOrderServiceImpl saveClearOrderBatch end time consuming:{}ms,paymentSeqno=" + peClearOrderDomainList.get(0).getPaymentSeqno()), (long)(System.currentTimeMillis() - start));
        return orderRtList;
    }

    private List<PeReorderDomain> createReorder(List<PeClearOrderDomain> peClearOrderDomainList) {
        if (null == peClearOrderDomainList || peClearOrderDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PeReorderDomain> peReorderDomainList = new ArrayList<PeReorderDomain>();
        peReorderDomainList.add(this.createReorder(peClearOrderDomainList.get(0)));
        return peReorderDomainList;
    }

    private PeReorderDomain createReorder(PeClearOrderDomain peClearOrderDomain) {
        if (null == peClearOrderDomain) {
            return null;
        }
        PeReorderDomain peReorderDomain = new PeReorderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peReorderDomain, (Object)peClearOrderDomain);
            peReorderDomain.setOrderCode(peClearOrderDomain.getProtClearinfoSeqno());
            peReorderDomain.setOrderState("1");
            peReorderDomain.setReorderCode(peClearOrderDomain.getClearOrderSeqno());
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.createReorder.e", (Throwable)e);
        }
        return peReorderDomain;
    }

    @Override
    public void updateClearOrderState(Integer clearOrderId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateClearOrderModel(clearOrderId, dataState, oldDataState);
    }

    @Override
    public void updateClearOrder(PeClearOrderDomain peClearOrderDomain) throws ApiException {
        String msg = this.checkClearOrder(peClearOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateClearOrder.checkClearOrder", msg);
        }
        PeClearOrder oldPeClearOrder = this.getClearOrderModelById(peClearOrderDomain.getClearOrderId());
        if (null == oldPeClearOrder) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateClearOrder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeClearOrder peClearOrder = this.makeClearOrder(peClearOrderDomain, oldPeClearOrder);
        this.setClearOrderUpdataDefault(peClearOrder);
        this.updateClearOrderModel(peClearOrder);
    }

    @Override
    public PeClearOrder getClearOrder(Integer clearOrderId) {
        return this.getClearOrderModelById(clearOrderId);
    }

    @Override
    public void deleteClearOrder(Integer clearOrderId) throws ApiException {
        this.deleteClearOrderModel(clearOrderId);
    }

    @Override
    public QueryResult<PeClearOrder> queryClearOrderPage(Map<String, Object> map) {
        List<PeClearOrder> peClearOrderList = this.queryClearOrderModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countClearOrder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peClearOrderList);
        return queryResult;
    }

    @Override
    public void saveClearOrderSend(List<PeClearOrder> peClearOrderlist) throws ApiException {
        if (null == peClearOrderlist || peClearOrderlist.isEmpty()) {
            this.logger.error("pe.PeClearOrderServiceImpl.saveClearOrderSend.null");
            return;
        }
        long start = System.currentTimeMillis();
        String key = peClearOrderlist.get(0).getFchannelCode() + "-" + peClearOrderlist.get(0).getTenantCode();
        String apicode = DisUtil.getMap((String)"Fchannel_apicode", (String)key);
        if (StringUtils.isBlank((String)apicode)) {
            key = peClearOrderlist.get(0).getFchannelCode() + "-00000000";
            apicode = DisUtil.getMap((String)"Fchannel_apicode", (String)key);
        }
        if (StringUtils.isBlank((String)apicode)) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearOrderSend.apicode", key + "-" + peClearOrderlist.get(0).getClearOrderSeqno());
        }
        ArrayList<PeClearCtrl> ctrlList = new ArrayList<PeClearCtrl>();
        for (PeClearOrder peClearOrder : peClearOrderlist) {
            long start1 = System.currentTimeMillis();
            this.updateStateClearOrderByCodeModel(peClearOrder.getClearOrderSeqno(), peClearOrder.getProtEtcInfoSeqno(), peClearOrder.getTenantCode(), 1, 0);
            this.logger.info("PeClearOrderService saveClearOrderSend 1 consuming:{" + (System.currentTimeMillis() - start1) + "}ms {" + (System.currentTimeMillis() - start) + "}ms,paymentSeqno=" + peClearOrderlist.get(0).getPaymentSeqno());
            PeClearCtrlDomain peClearCtrlDomain = new PeClearCtrlDomain();
            peClearCtrlDomain.setClearOrderSeqno(peClearOrder.getClearOrderSeqno());
            peClearCtrlDomain.setTenantCode(peClearOrder.getTenantCode());
            peClearCtrlDomain.setProtEtcType(peClearOrder.getClearOrderCtype());
            ctrlList.add(this.createCtrl(peClearCtrlDomain));
        }
        long start3 = System.currentTimeMillis();
        this.saveClearCtrlBatchModel(ctrlList);
        this.logger.info("PeClearOrderService saveClearOrderSend 2 consuming:{" + (System.currentTimeMillis() - start3) + "}ms {" + (System.currentTimeMillis() - start) + "}ms,paymentSeqno=" + peClearOrderlist.get(0).getPaymentSeqno());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("vdFaccountDoDomainList", JsonUtil.buildNormalBinder().toJson(peClearOrderlist));
        long start4 = System.currentTimeMillis();
        String resultInvoke = this.internalInvoke(apicode, paramMap);
        this.logger.info("PeClearOrderService saveClearOrderSend 3 consuming:{" + (System.currentTimeMillis() - start4) + "}ms {" + (System.currentTimeMillis() - start) + "}ms,paymentSeqno=" + peClearOrderlist.get(0).getPaymentSeqno(), (Object)("apicode:" + apicode + ",paramMap:" + JSONObject.toJSONString(paramMap) + ",result:" + resultInvoke));
    }

    @Override
    public void saveClearCtrl(PeClearCtrlDomain peClearCtrlDomain) throws ApiException {
        PeClearCtrl peClearCtrl = this.createCtrl(peClearCtrlDomain);
        this.saveClearCtrlModel(peClearCtrl);
    }

    private PeClearCtrl createCtrl(PeClearCtrlDomain peClearCtrlDomain) {
        String msg = this.checkClearCtrl(peClearCtrlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearCtrl.checkClearCtrl", msg);
        }
        PeClearCtrl peClearCtrl = this.makeClearCtrl(peClearCtrlDomain, null);
        this.setClearCtrlDefault(peClearCtrl);
        return peClearCtrl;
    }

    @Override
    public void updateClearCtrlState(Integer clearCtrlId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateClearCtrlModel(clearCtrlId, dataState, oldDataState);
    }

    @Override
    public void updateClearCtrl(PeClearCtrlDomain peClearCtrlDomain) throws ApiException {
        String msg = this.checkClearCtrl(peClearCtrlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateClearCtrl.checkClearCtrl", msg);
        }
        PeClearCtrl oldPeClearCtrl = this.getClearCtrlModelById(peClearCtrlDomain.getClearCtrlId());
        if (null == oldPeClearCtrl) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateClearCtrl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeClearCtrl peClearCtrl = this.makeClearCtrl(peClearCtrlDomain, oldPeClearCtrl);
        this.setClearCtrlUpdataDefault(peClearCtrl);
        this.updateClearCtrlModel(peClearCtrl);
    }

    @Override
    public PeClearCtrl getClearCtrl(Integer clearCtrlId) {
        return this.getClearCtrlModelById(clearCtrlId);
    }

    @Override
    public void deleteClearCtrl(Integer clearCtrlId) throws ApiException {
        this.deleteClearCtrlModel(clearCtrlId);
    }

    @Override
    public QueryResult<PeClearCtrl> queryClearCtrlPage(Map<String, Object> map) {
        List<PeClearCtrl> peClearCtrlList = this.queryClearCtrlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countClearCtrl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peClearCtrlList);
        return queryResult;
    }

    @Override
    public PeClearResp saveClearResp(PeClearRespDomain peClearRespDomain) throws ApiException {
        return this.updateClearRespCall(peClearRespDomain);
    }

    private PeClearResp updateClearRespCall(PeClearRespDomain peClearRespDomain) {
        long start = System.currentTimeMillis();
        String msg = this.checkClearResp(peClearRespDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearResp.checkClearResp", msg);
        }
        PeClearResp peClearResp = this.makeClearResp(peClearRespDomain, null);
        this.setClearRespDefault(peClearResp);
        this.saveClearRespModel(peClearResp);
        this.logger.info("======updateClearRespCall=====time0=============", (Object)(System.currentTimeMillis() - start));
        this.updateStateClearOrderByCodeModel(peClearResp.getClearOrderSeqno(), null, peClearResp.getTenantCode(), peClearResp.getDataState(), 1);
        this.logger.info("======updateClearRespCall=====time1=============", (Object)(System.currentTimeMillis() - start));
        return peClearResp;
    }

    private PeReorderDomain make(PeClearOrder peClearOrder, PeClearResp peClearResp) {
        if (null == peClearResp || null == peClearOrder) {
            return null;
        }
        PeReorderDomain peReorderDomain = new PeReorderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peReorderDomain, (Object)peClearResp);
            BeanUtils.copyAllPropertys((Object)peReorderDomain, (Object)peClearOrder);
            peReorderDomain.setReorderCode(peClearResp.getClearRespSeqno());
            peReorderDomain.setOrderCode(peClearOrder.getCflowPprocessCode());
            peReorderDomain.setPaymentReorderMemo(peClearResp.getClearRespRepinfo());
            peReorderDomain.setOrderState(String.valueOf(peClearResp.getDataState()));
            return peReorderDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.make.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateClearRespState(Integer clearRespId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateClearRespModel(clearRespId, dataState, oldDataState);
    }

    @Override
    public void updateClearResp(PeClearRespDomain peClearRespDomain) throws ApiException {
        String msg = this.checkClearResp(peClearRespDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateClearResp.checkClearResp", msg);
        }
        PeClearResp oldPeClearResp = this.getClearRespModelById(peClearRespDomain.getClearRespId());
        if (null == oldPeClearResp) {
            throw new ApiException("pe.PeClearOrderServiceImpl.updateClearResp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeClearResp peClearResp = this.makeClearResp(peClearRespDomain, oldPeClearResp);
        this.setClearRespUpdataDefault(peClearResp);
        this.updateClearRespModel(peClearResp);
    }

    @Override
    public PeClearResp getClearResp(Integer clearRespId) {
        return this.getClearRespModelById(clearRespId);
    }

    @Override
    public void deleteClearResp(Integer clearRespId) throws ApiException {
        this.deleteClearRespModel(clearRespId);
    }

    @Override
    public QueryResult<PeClearResp> queryClearRespPage(Map<String, Object> map) {
        List<PeClearResp> peClearRespList = this.queryClearRespModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countClearResp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peClearRespList);
        return queryResult;
    }

    @Override
    public List<PeClearResp> saveClearOrderNext(SupperRuestDomain ruestDomain) {
        if (null == ruestDomain) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearOrderNext.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        long start = System.currentTimeMillis();
        PeClearRespDomain peClearRespDomain = new PeClearRespDomain();
        peClearRespDomain.setClearOrderSeqno(ruestDomain.getOrderCode());
        peClearRespDomain.setTenantCode(ruestDomain.getTenantCode());
        peClearRespDomain.setDataState(Integer.valueOf(ruestDomain.getOrderState()));
        peClearRespDomain.setClearRespState(0);
        peClearRespDomain.setClearRespRepinfo(ruestDomain.getExtStr());
        PeClearResp peClearResp = this.saveClearResp(peClearRespDomain);
        ArrayList<PeClearResp> list = new ArrayList<PeClearResp>();
        list.add(peClearResp);
        this.logger.info("======saveClearOrderNext=====time=============", (Object)(System.currentTimeMillis() - start));
        return list;
    }

    @Override
    public void sendClearOrderNext(List<PeClearResp> peClearRespList) {
        for (PeClearResp peClearResp : peClearRespList) {
            this.logger.debug("ClearCallService.putQueue.start", (Object)peClearResp.getClearRespSeqno());
            this.getClearCallService().putQueue(peClearResp);
            this.logger.debug("ClearCallService.putQueue.end", (Object)peClearResp.getClearRespSeqno());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClearCallService getClearCallService() {
        Object object = callLock;
        synchronized (object) {
            if (null == clearCallService) {
                clearCallService = new ClearCallService((PeClearOrderService)SpringApplicationContextUtil.getBean((String)"peClearOrderService"));
                for (int i = 0; i < 80; ++i) {
                    clearCallService.addPollPool(new ClearCallPollThread(clearCallService));
                }
            }
            return clearCallService;
        }
    }

    @Override
    public void saveClearOrderCall(PeClearResp peClearResp) {
        if (null == peClearResp) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearOrderCall.peClearResp", "null");
        }
        this.logger.debug("pe.PeClearOrderServiceImpl.saveClearOrderCall.start", (Object)peClearResp.getClearRespSeqno());
        long start = System.currentTimeMillis();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("clearOrderSeqno", peClearResp.getClearOrderSeqno());
        parammap.put("tenantCode", peClearResp.getTenantCode());
        if (!this.updateCallStateClearRespByCodeModel(peClearResp.getClearRespSeqno(), peClearResp.getTenantCode(), 1, 0)) {
            this.logger.info("pe.PeClearOrderServiceImpl.saveClearOrderCall.updateCallStateClearRespByCodeModel", (Object)peClearResp.getClearRespSeqno());
            return;
        }
        PeClearOrder peClearOrder = this.getClearOrderModelByCode(parammap);
        if (null == peClearOrder) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearOrderCall.peClearOrder", "null");
        }
        if (1 == peClearResp.getDataState()) {
            this.saveCall(peClearResp, peClearOrder);
            OpenPerfLogUtil.info((String)("PeClearOrderService saveClearOrderCall 0 end time consuming:{}ms,paymentSeqno=" + peClearOrder.getPaymentSeqno()), (long)(System.currentTimeMillis() - start));
            return;
        }
        this.updateCallStateClearOrderBySeqoModel(peClearOrder.getCflowPprocessCode(), peClearOrder.getTenantCode(), 2, peClearOrder.getClearOrderState());
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.put("cflowPprocessCode", peClearOrder.getCflowPprocessCode());
        cmap.put("tenantCode", peClearOrder.getTenantCode());
        List<PeClearOrder> list = this.queryClearOrderModelPage(cmap);
        if (null == list || list.isEmpty()) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearOrderCall.list", "null");
        }
        boolean waitflag = false;
        for (PeClearOrder peClearOrder2 : list) {
            if (null != peClearOrder2.getDataState() && peClearOrder2.getDataState() > 1) continue;
            waitflag = true;
        }
        if (waitflag) {
            OpenPerfLogUtil.info((String)("PeClearOrderService saveClearOrderCall 1 end time consuming:{}ms,paymentSeqno=" + peClearOrder.getPaymentSeqno()), (long)(System.currentTimeMillis() - start));
            return;
        }
        this.saveCall(peClearResp, peClearOrder);
        OpenPerfLogUtil.info((String)("PeClearOrderService saveClearOrderCall end time consuming:{}ms,paymentSeqno=" + peClearOrder.getPaymentSeqno()), (long)(System.currentTimeMillis() - start));
    }

    private void saveCall(PeClearResp peClearResp, PeClearOrder peClearOrder) {
        PeReorderDomain peReorderDomain = this.make(peClearOrder, peClearResp);
        if (null == peReorderDomain) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveClearResp.peReorderDomain", "");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("peReorderDomain", JsonUtil.buildNormalBinder().toJson((Object)peReorderDomain));
        this.internalInvoke("pe.paymentEngine.sendFlowNext", paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EtcInfoProcessService getEtcInfoProcessService() {
        Object object = etcProcesslock;
        synchronized (object) {
            if (null == etcInfoProcessService) {
                etcInfoProcessService = new EtcInfoProcessService();
            }
        }
        return etcInfoProcessService;
    }

    @Override
    public synchronized void saveEtc(String protEtcSeqno, String tenantCode) {
        PeProtEtcInfo peProtEtcInfo = this.getEtc(protEtcSeqno, tenantCode);
        this.sendExEtc(peProtEtcInfo);
    }

    private PeProtEtcInfo getEtc(String protEtcSeqno, String tenantCode) {
        String cacheKey = protEtcSeqno + "-" + tenantCode;
        PeProtEtcInfo peProtEtcInfo = PeClearOrderServiceImpl.getEtcInfoProcessService().get(cacheKey);
        if (null == peProtEtcInfo && null != (peProtEtcInfo = this.peProtEtcService.getProtEtcInfoByCode(protEtcSeqno, tenantCode))) {
            PeClearOrderServiceImpl.getEtcInfoProcessService().addCache(peProtEtcInfo);
        }
        return peProtEtcInfo;
    }

    @Override
    public void defenderLoadEtcInfo() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        QueryResult<PeProtEtcInfo> etcInfo = this.peProtEtcService.queryProtEtcInfoPage(params);
        if (null == etcInfo || null == etcInfo.getRows()) {
            return;
        }
        for (PeProtEtcInfo peProtEtcInfo : etcInfo.getRows()) {
            PeClearOrderServiceImpl.getEtcInfoProcessService().addCache(peProtEtcInfo);
            this.sendExEtc(peProtEtcInfo);
        }
    }

    @Override
    public void loadOrderRest() {
        this.loadDb(0);
    }

    @Override
    public void loadOrderRestafter(int len) {
        this.loadDb(len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDb(int len) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("clearRespState", 0);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            if (len > 0) {
                map.put("endDate", DateUtil.addMinutes((Date)new Date(), (int)(-len)));
            }
            QueryResult<PeClearResp> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getClearCallService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getClearCallService().getPage());
                result = this.queryClearRespPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    for (PeClearResp peClearResp : result.getRows()) {
                        this.getClearCallService().putQueue(peClearResp);
                    }
                    if (result.getRows().size() == this.getClearCallService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getClearCallService().initStartRow();
        }
        catch (Exception e) {
            this.logger.error("pe.PeClearOrderServiceImpl.loadDb.e", (Throwable)e);
        }
    }

    private void sendExEtc(PeProtEtcInfo peProtEtcInfo) {
        if (null == peProtEtcInfo) {
            return;
        }
        if (!PeClearOrderServiceImpl.getEtcInfoProcessService().lockExcute(peProtEtcInfo.getProtEtcSeqno(), peProtEtcInfo.getTenantCode())) {
            this.logger.error("pe.PeClearOrderServiceImpl.sendExEtc.lockExcute", (Object)(peProtEtcInfo.getProtEtcSeqno() + "-" + peProtEtcInfo.getTenantCode()));
            return;
        }
        try {
            this.updateEtcInfoByEtcModel(peProtEtcInfo.getProtEtcInfoSeqno(), peProtEtcInfo.getTenantCode(), peProtEtcInfo.getProtEtcSeqno());
            PeClearOrderServiceImpl.getEtcInfoProcessService().unLockExcute(peProtEtcInfo.getProtEtcSeqno(), peProtEtcInfo.getTenantCode());
        }
        catch (Exception e) {
            PeClearOrderServiceImpl.getEtcInfoProcessService().unLockExcute(peProtEtcInfo.getProtEtcSeqno(), peProtEtcInfo.getTenantCode());
            this.logger.error("pe.PeClearOrderServiceImpl.sendExEtc.e", (Object)(peProtEtcInfo.getProtEtcSeqno() + "-" + peProtEtcInfo.getTenantCode()));
            return;
        }
        ClearProcessService clearProcessService = this.getEtcInfo().get(peProtEtcInfo.getProtEtcSeqno() + "-" + peProtEtcInfo.getTenantCode());
        if (null != clearProcessService) {
            this.logger.error("pe.PeClearOrderServiceImpl.sendExEtc.clearProcessService", (Object)(peProtEtcInfo.getProtEtcSeqno() + "-" + peProtEtcInfo.getTenantCode()));
            return;
        }
        clearProcessService = new ClearProcessService(peProtEtcInfo, this.peProtClearagService, (PeClearOrderService)SpringApplicationContextUtil.getBean((String)"peClearOrderService"), this.peProtEtcService, PeClearOrderServiceImpl.getEtcInfoProcessService());
        clearProcessService.addPutPool(new EtcInfoPutThread(clearProcessService));
        clearProcessService.addPollPool(new EtcInfoPollThread(clearProcessService));
        this.getEtcInfo().put(peProtEtcInfo.getProtEtcSeqno() + "-" + peProtEtcInfo.getTenantCode(), clearProcessService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ClearProcessService> getEtcInfo() {
        Object object = etclock;
        synchronized (object) {
            if (null == etcInfo) {
                etcInfo = new ConcurrentHashMap<String, ClearProcessService>();
            }
        }
        return etcInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClearProcessRtService getClearProcessRtService() {
        Object object = lock;
        synchronized (object) {
            if (null == clearProcessRtService) {
                clearProcessRtService = new ClearProcessRtService((PeClearOrderService)SpringApplicationContextUtil.getBean((String)"peClearOrderService"));
                for (int i = 0; i < 80; ++i) {
                    clearProcessRtService.addPutPool(new EtcInfoRtPollThread(clearProcessRtService));
                }
            }
            return clearProcessRtService;
        }
    }

    @Override
    public void sendExEtc(List<PeClearOrder> list) {
        if (null == list || list.isEmpty()) {
            return;
        }
        this.getClearProcessRtService().putQueue(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PeClearOrder> createEtc(List<PeClearOrder> orderList) {
        if (null == orderList || orderList.isEmpty()) {
            return null;
        }
        ArrayList<PeProtEtcInfo> etcRtList = new ArrayList<PeProtEtcInfo>();
        String cacheKey = "";
        PeProtEtcInfo peProtEtcInfo = null;
        HashMap etcMap = new HashMap();
        ArrayList<PeClearOrder> orderRtList = new ArrayList<PeClearOrder>();
        for (PeClearOrder peProtClearinfoDomain : orderList) {
            if (StringUtils.isBlank((String)peProtClearinfoDomain.getProtEtcSeqno())) {
                peProtClearinfoDomain.setProtEtcSeqno("-");
            }
            cacheKey = peProtClearinfoDomain.getProtEtcSeqno() + "-" + peProtClearinfoDomain.getTenantCode();
            Object object = this.etcLock;
            synchronized (object) {
                this.getEtc(peProtClearinfoDomain.getProtEtcSeqno(), peProtClearinfoDomain.getTenantCode());
                if (PeClearOrderServiceImpl.getEtcInfoProcessService().containsKeyAs(cacheKey)) {
                    continue;
                }
                if (PeClearOrderServiceImpl.getEtcInfoProcessService().containsKeyRt(cacheKey)) {
                    peProtEtcInfo = PeClearOrderServiceImpl.getEtcInfoProcessService().getRt(cacheKey);
                    if (!etcMap.containsKey(cacheKey)) {
                        etcRtList.add(PeClearOrderServiceImpl.getEtcInfoProcessService().getRt(cacheKey));
                    }
                    peProtClearinfoDomain.setProtEtcInfoSeqno(peProtEtcInfo.getProtEtcInfoSeqno());
                    orderRtList.add(peProtClearinfoDomain);
                    continue;
                }
                peProtEtcInfo = this.saveEtcInfo(peProtClearinfoDomain.getProtEtcCode(), peProtClearinfoDomain.getProtEtcSeqno(), peProtClearinfoDomain.getTenantCode());
                PeClearOrderServiceImpl.getEtcInfoProcessService().addCache(peProtEtcInfo);
            }
            if (!PortEtcType.RT.getCode().equals(peProtEtcInfo.getProtEtcType())) continue;
            etcRtList.add(peProtEtcInfo);
            peProtClearinfoDomain.setProtEtcInfoSeqno(peProtEtcInfo.getProtEtcInfoSeqno());
            orderRtList.add(peProtClearinfoDomain);
        }
        return orderRtList;
    }

    private PeProtEtcInfo saveEtcInfo(String protEtcCode, String protEtcSeqno, String tenantCode) {
        PeProtEtc peProtEtc = (PeProtEtc)DisUtil.getMapJson((String)PeProtEtcServiceImpl.CACHE_KEY_ETC, (String)(protEtcCode + "-" + tenantCode), PeProtEtc.class);
        if (null == peProtEtc) {
            peProtEtc = (PeProtEtc)DisUtil.getMapJson((String)PeProtEtcServiceImpl.CACHE_KEY_ETC, (String)(protEtcCode + "-00000000"), PeProtEtc.class);
        }
        if (null == peProtEtc) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveEtcInfo.peProtEtc", "null");
        }
        PeProtEtcInfoDomain peProtEtcInfoDomain = this.makeEtcInfo(protEtcSeqno, peProtEtc, tenantCode);
        if (null == peProtEtcInfoDomain) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveEtcInfo.peProtEtcInfoDomain", "null");
        }
        PeProtEtcInfo peProtEtcInfo = this.peProtEtcService.saveProtEtcInfo(peProtEtcInfoDomain);
        if (null == peProtEtcInfo) {
            throw new ApiException("pe.PeClearOrderServiceImpl.saveEtcInfo.peProtEtcInfo", "null");
        }
        return peProtEtcInfo;
    }

    private PeProtEtcInfoDomain makeEtcInfo(String protEtcSeqno, PeProtEtc peProtEtc, String tenantCode) {
        if (null == peProtEtc || StringUtils.isBlank((String)protEtcSeqno)) {
            return null;
        }
        PeProtEtcInfoDomain peProtEtcInfoDomain = new PeProtEtcInfoDomain();
        peProtEtcInfoDomain.setProtEtcRetype(peProtEtc.getProtEtcRetype());
        peProtEtcInfoDomain.setProtEtcSeqno(protEtcSeqno);
        peProtEtcInfoDomain.setTenantCode(tenantCode);
        peProtEtcInfoDomain.setProtEtcType(peProtEtc.getProtEtcType());
        peProtEtcInfoDomain.setProtEtcCode(peProtEtc.getProtEtcCode());
        peProtEtcInfoDomain.setProtEtcTime(peProtEtc.getProtEtcTime());
        peProtEtcInfoDomain.setProtEtcInfoSeqno(this.createUUIDString());
        if (PortEtcType.AS.getCode().equals(peProtEtc.getProtEtcType()) && StringUtils.isNotBlank((String)peProtEtcInfoDomain.getProtEtcTime())) {
            try {
                CronExpression cron = new CronExpression(peProtEtcInfoDomain.getProtEtcTime());
                peProtEtcInfoDomain.setProtEtcPreTime(cron.getNextValidTimeAfter(new Date()));
            }
            catch (Exception e) {
                this.logger.error("pe.PeClearOrderServiceImpl.makeEtcInfo.e", (Throwable)e);
            }
        } else {
            peProtEtcInfoDomain.setProtEtcPreTime(new Date());
        }
        return peProtEtcInfoDomain;
    }

    @Override
    public void saveProtEtcInit(String tenantCode) {
        QueryResult<PeProtEtc> rs = this.peProtEtcService.queryProtEtcPage(this.getQueryParamMap("tenantCode", new Object[]{"00000000"}));
        List list = rs.getList();
        QueryResult<PeProtEtcInfo> rsinfo = this.peProtEtcService.queryProtEtcInfoPage(null);
        List infolist = rsinfo.getList();
        HashMap map = new HashMap();
        for (PeProtEtcInfo ei : infolist) {
            ArrayList<PeProtEtcInfo> info = (ArrayList<PeProtEtcInfo>)map.get(ei.getProtEtcCode());
            if (null == info) {
                info = new ArrayList<PeProtEtcInfo>();
            }
            ei.setTenantCode(tenantCode);
            ei.setProtEtcInfoId(null);
            info.add(ei);
            map.put(ei.getProtEtcCode(), info);
        }
        for (PeProtEtc c : list) {
            c.setTenantCode(tenantCode);
            c.setProtEtcId(null);
            c.setList((List)map.get(c.getProtEtcCode()));
        }
        this.getProtEtcService().putQueue(list);
    }

    @Override
    public void saveProtEtcByList(List<PeProtEtc> list) {
        for (PeProtEtc etc : list) {
            PeProtEtcDomain peProtEtcDomain = new PeProtEtcDomain();
            try {
                BeanUtils.copyAllPropertys((Object)peProtEtcDomain, (Object)etc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.peProtEtcService.saveProtEtc(peProtEtcDomain);
            for (PeProtEtcInfo tecInfo : etc.getList()) {
                this.peProtEtcService.saveProtEtcInfo(tecInfo);
            }
        }
        this.peProtEtcService.queryProtEtcCache();
        this.defenderLoadEtcInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtEtcService getProtEtcService() {
        Object object = obj;
        synchronized (object) {
            if (null == protEtcService) {
                protEtcService = new ProtEtcService((PeClearOrderService)SpringApplicationContextUtil.getBean((String)"peClearOrderService"));
                protEtcService.addPollPool(new ProtEtcPollThread(protEtcService));
            }
            return protEtcService;
        }
    }

    @Override
    public void clearInfo(PayClearInfoQ payClearInfoQ) {
        long start = System.currentTimeMillis();
        try {
            this.ruleService.setInternalRouter(this.getInternalRouter());
            List<PeClearOrderDomain> claerOrderList = this.ruleService.exRule(payClearInfoQ);
            this.logger.info("======clearInfo=====time===1==========", (Object)(System.currentTimeMillis() - start));
            List<PeClearOrder> etcList = this.saveClearOrderBatch(claerOrderList);
            this.logger.info("======clearInfo=====time===2==========", (Object)(System.currentTimeMillis() - start));
            if (null != etcList && !etcList.isEmpty() && !payClearInfoQ.isClearAsync()) {
                this.sendExEtc(etcList);
            }
        }
        catch (Exception e) {
            this.logger.error("ClearInfoService.doStart", (Throwable)e);
        }
        this.logger.info("======clearInfo=====time=============", (Object)(System.currentTimeMillis() - start));
    }

    static {
        callLock = new Object();
        etcInfoProcessService = null;
        etcProcesslock = new Object();
        etcInfo = null;
        etclock = new Object();
        lock = new Object();
        obj = new Object();
    }
}

