/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.dao.PeDicSettingMapper;
import com.yqbsoft.laser.service.payengine.domain.PeDicSettingDomain;
import com.yqbsoft.laser.service.payengine.model.PeDicSetting;
import com.yqbsoft.laser.service.payengine.service.PeDicSettingService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PeDicSettingServiceImpl
extends BaseServiceImpl
implements PeDicSettingService {
    public static final String SYS_CODE = "pe.PeDicSettingServiceImpl";
    private PeDicSettingMapper peDicSettingMapper;

    public void setPeDicSettingMapper(PeDicSettingMapper peDicSettingMapper) {
        this.peDicSettingMapper = peDicSettingMapper;
    }

    private Date getSysDate() {
        try {
            return this.peDicSettingMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pe.PeDicSettingServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDicSetting(PeDicSettingDomain peDicSettingDomain) {
        if (null == peDicSettingDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setDicSettingDefault(PeDicSetting peDicSetting) {
        if (null == peDicSetting) {
            return;
        }
        if (null == peDicSetting.getDataState()) {
            peDicSetting.setDataState(0);
        }
        if (null == peDicSetting.getGmtCreate()) {
            peDicSetting.setGmtCreate(this.getSysDate());
        }
        peDicSetting.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.peDicSettingMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeDicSettingServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDicSettingUpdataDefault(PeDicSetting peDicSetting) {
        if (null == peDicSetting) {
            return;
        }
        peDicSetting.setGmtModified(this.getSysDate());
    }

    private void saveDicSettingModel(PeDicSetting peDicSetting) throws ApiException {
        if (null == peDicSetting) {
            return;
        }
        try {
            this.peDicSettingMapper.insert(peDicSetting);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeDicSettingServiceImpl.saveDicSettingModel.ex", (Throwable)e);
        }
    }

    private PeDicSetting getDicSettingModelById(Integer dicSettingId) {
        if (null == dicSettingId) {
            return null;
        }
        try {
            return this.peDicSettingMapper.selectByPrimaryKey(dicSettingId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeDicSettingServiceImpl.getDicSettingModelById", (Throwable)e);
            return null;
        }
    }

    public PeDicSetting getDicSettingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peDicSettingMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeDicSettingServiceImpl.getDicSettingModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delDicSettingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peDicSettingMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeDicSettingServiceImpl.delDicSettingModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeDicSettingServiceImpl.delDicSettingModelByCode.num");
        }
    }

    private void deleteDicSettingModel(Integer dicSettingId) throws ApiException {
        if (null == dicSettingId) {
            return;
        }
        int i = 0;
        try {
            i = this.peDicSettingMapper.deleteByPrimaryKey(dicSettingId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeDicSettingServiceImpl.deleteDicSettingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeDicSettingServiceImpl.deleteDicSettingModel.num");
        }
    }

    private void updateDicSettingModel(PeDicSetting peDicSetting) throws ApiException {
        if (null == peDicSetting) {
            return;
        }
        try {
            this.peDicSettingMapper.updateByPrimaryKeySelective(peDicSetting);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeDicSettingServiceImpl.updateDicSettingModel.ex", (Throwable)e);
        }
    }

    private void updateStateDicSettingModel(Integer dicSettingId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dicSettingId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dicSettingId", dicSettingId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peDicSettingMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeDicSettingServiceImpl.updateStateDicSettingModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeDicSettingServiceImpl.updateStateDicSettingModel.null");
        }
    }

    private PeDicSetting makeDicSetting(PeDicSettingDomain peDicSettingDomain, PeDicSetting peDicSetting) {
        if (null == peDicSettingDomain) {
            return null;
        }
        if (null == peDicSetting) {
            peDicSetting = new PeDicSetting();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peDicSetting, (Object)peDicSettingDomain);
            return peDicSetting;
        }
        catch (Exception e) {
            this.logger.error("pe.PeDicSettingServiceImpl.makeDicSetting", (Throwable)e);
            return null;
        }
    }

    private List<PeDicSetting> queryDicSettingModelPage(Map<String, Object> parammap) {
        try {
            return this.peDicSettingMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeDicSettingServiceImpl.queryDicSettingModel", (Throwable)e);
            return null;
        }
    }

    private int countDicSetting(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peDicSettingMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeDicSettingServiceImpl.countDicSetting", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveDicSetting(PeDicSettingDomain peDicSettingDomain) throws ApiException {
        String msg = this.checkDicSetting(peDicSettingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeDicSettingServiceImpl.saveDicSetting.checkDicSetting", msg);
        }
        PeDicSetting peDicSetting = this.makeDicSetting(peDicSettingDomain, null);
        this.setDicSettingDefault(peDicSetting);
        this.saveDicSettingModel(peDicSetting);
    }

    @Override
    public void updateDicSettingState(Integer dicSettingId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDicSettingModel(dicSettingId, dataState, oldDataState);
    }

    @Override
    public void updateDicSetting(PeDicSettingDomain peDicSettingDomain) throws ApiException {
        String msg = this.checkDicSetting(peDicSettingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeDicSettingServiceImpl.updateDicSetting.checkDicSetting", msg);
        }
        PeDicSetting oldPeDicSetting = this.getDicSettingModelById(peDicSettingDomain.getDicSettingId());
        if (null == oldPeDicSetting) {
            throw new ApiException("pe.PeDicSettingServiceImpl.updateDicSetting.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeDicSetting peDicSetting = this.makeDicSetting(peDicSettingDomain, oldPeDicSetting);
        this.setDicSettingUpdataDefault(peDicSetting);
        this.updateDicSettingModel(peDicSetting);
    }

    @Override
    public PeDicSetting getDicSetting(Integer dicSettingId) {
        return this.getDicSettingModelById(dicSettingId);
    }

    @Override
    public void deleteDicSetting(Integer dicSettingId) throws ApiException {
        this.deleteDicSettingModel(dicSettingId);
    }

    @Override
    public QueryResult<PeDicSetting> queryDicSettingPage(Map<String, Object> map) {
        List<PeDicSetting> peDicSettingList = this.queryDicSettingModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDicSetting(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peDicSettingList);
        return queryResult;
    }

    @Override
    public void queryDicSettingCache() {
        this.logger.info("pe.PeDicSettingServiceImpl.queryDicSettingCache.start", (Object)"=======\u8c03\u5ea6start=======");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<PeDicSetting> peDicSettingList = this.queryDicSettingModelPage(parammap);
        String key = "DicSetting-list";
        String keyvalue = "DicSetting-key";
        if (null == peDicSettingList || peDicSettingList.isEmpty()) {
            DisUtil.delVer((String)key);
            DisUtil.delVer((String)keyvalue);
            this.logger.info("pe.PeDicSettingServiceImpl.queryDicSettingCache.delend", (Object)"=======\u8c03\u5ea6del-end=======");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> cachemapList = new HashMap<String, String>();
        HashMap<String, ArrayList<PeDicSetting>> mapList = new HashMap<String, ArrayList<PeDicSetting>>();
        ArrayList<PeDicSetting> falgList = null;
        String listkey = null;
        for (PeDicSetting peDicSetting : peDicSettingList) {
            listkey = peDicSetting.getTenantCode() + "-" + peDicSetting.getDicSettingType();
            map.put(listkey + "-" + peDicSetting.getDicSettingCode(), peDicSetting.getDicSettingInfo());
            falgList = (ArrayList<PeDicSetting>)mapList.get(listkey);
            if (null == falgList) {
                falgList = new ArrayList<PeDicSetting>();
                mapList.put(listkey, falgList);
            }
            falgList.add(peDicSetting);
        }
        for (String listmapkey : mapList.keySet()) {
            cachemapList.put(listmapkey, JsonUtil.buildNormalBinder().toJson(mapList.get(listmapkey)));
        }
        DisUtil.setMapVer((String)keyvalue, map);
        DisUtil.setMapVer((String)key, cachemapList);
        this.logger.info("pe.PeDicSettingServiceImpl.queryDicSettingCache.end", (Object)"=======\u8c03\u5ea6end=======");
    }
}

