/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.dao.PeProtCruleInfoMapper;
import com.yqbsoft.laser.service.payengine.dao.PeProtCruleMapper;
import com.yqbsoft.laser.service.payengine.domain.PeProtCruleDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtCruleInfoDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtCruleInfoReDomain;
import com.yqbsoft.laser.service.payengine.domain.PeProtCruleReDomain;
import com.yqbsoft.laser.service.payengine.model.PeProtCrule;
import com.yqbsoft.laser.service.payengine.model.PeProtCruleInfo;
import com.yqbsoft.laser.service.payengine.model.VdFaccountInner;
import com.yqbsoft.laser.service.payengine.service.PeProtCruleService;
import com.yqbsoft.laser.service.payengine.service.impl.CflowCrulePollThread;
import com.yqbsoft.laser.service.payengine.service.impl.CflowCruleService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PeProtCruleServiceImpl
extends BaseServiceImpl
implements PeProtCruleService {
    public static final String SYS_CODE = "pe.PeProtCruleServiceImpl";
    private PeProtCruleMapper peProtCruleMapper;
    private PeProtCruleInfoMapper peProtCruleInfoMapper;
    private Integer statDate = 1;
    public static final String CACHE_KEY_CRULE = "peProtCrule";
    private static CflowCruleService cflowCruleService;
    private static Object lock;

    public void setPeProtCruleMapper(PeProtCruleMapper peProtCruleMapper) {
        this.peProtCruleMapper = peProtCruleMapper;
    }

    public void setPeProtCruleInfoMapper(PeProtCruleInfoMapper peProtCruleInfoMapper) {
        this.peProtCruleInfoMapper = peProtCruleInfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.peProtCruleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProtCrule(PeProtCruleDomain peProtCruleDomain) {
        if (null == peProtCruleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProtCruleDefault(PeProtCrule peProtCrule) {
        if (null == peProtCrule) {
            return;
        }
        if (null == peProtCrule.getDataState()) {
            peProtCrule.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == peProtCrule.getGmtCreate()) {
            peProtCrule.setGmtCreate(date);
        }
        peProtCrule.setGmtModified(date);
    }

    private int getProtCruleMaxCode() {
        int code = 0;
        try {
            return this.peProtCruleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.getProtCruleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProtCruleUpdataDefault(PeProtCrule peProtCrule) {
        if (null == peProtCrule) {
            return;
        }
        peProtCrule.setGmtModified(this.getSysDate());
    }

    private void saveProtCruleModel(PeProtCrule peProtCrule) throws ApiException {
        if (null == peProtCrule) {
            return;
        }
        try {
            this.peProtCruleMapper.insert(peProtCrule);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.saveProtCruleModel.ex", (Throwable)e);
        }
    }

    private PeProtCrule getProtCruleModelById(Integer protCruleId) {
        if (null == protCruleId) {
            return null;
        }
        try {
            return this.peProtCruleMapper.selectByPrimaryKey(protCruleId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.getProtCruleModelById", (Throwable)e);
            return null;
        }
    }

    public PeProtCrule getProtCruleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peProtCruleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.getProtCruleModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProtCruleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtCruleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.delProtCruleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtCruleServiceImpl.delProtCruleModelByCode.num");
        }
    }

    private void deleteProtCruleModel(Integer protCruleId) throws ApiException {
        if (null == protCruleId) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtCruleMapper.deleteByPrimaryKey(protCruleId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.deleteProtCruleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtCruleServiceImpl.deleteProtCruleModel.num");
        }
    }

    private void updateProtCruleModel(PeProtCrule peProtCrule) throws ApiException {
        if (null == peProtCrule) {
            return;
        }
        try {
            this.peProtCruleMapper.updateByPrimaryKeySelective(peProtCrule);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateProtCruleModel.ex", (Throwable)e);
        }
    }

    private void updateStateProtCruleModel(Integer protCruleId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == protCruleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protCruleId", protCruleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (this.statDate.equals(dataState) || this.statDate.equals(oldDataState)) {
            PeProtCrule peProtCrule = this.getProtCruleModelById(protCruleId);
            if (null == peProtCrule) {
                throw new ApiException("pe.PeProtCruleServiceImpl.updateStateProtCruleModel.peProtCrule", "null");
            }
            if (this.statDate.equals(dataState)) {
                this.updateCache(peProtCrule);
            } else {
                this.delCache(peProtCrule);
            }
        }
        int i = 0;
        try {
            i = this.peProtCruleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateStateProtCruleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateStateProtCruleModel.null");
        }
    }

    private PeProtCrule makeProtCrule(PeProtCruleDomain peProtCruleDomain, PeProtCrule peProtCrule) {
        if (null == peProtCruleDomain) {
            return null;
        }
        if (null == peProtCrule) {
            peProtCrule = new PeProtCrule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peProtCrule, (Object)peProtCruleDomain);
            return peProtCrule;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.makeProtCrule", (Throwable)e);
            return null;
        }
    }

    private List<PeProtCrule> queryProtCruleModelPage(Map<String, Object> parammap) {
        try {
            return this.peProtCruleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.queryProtCruleModel", (Throwable)e);
            return null;
        }
    }

    private int countProtCrule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peProtCruleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.countProtCrule", (Throwable)e);
        }
        return i;
    }

    private String checkProtCruleInfo(PeProtCruleInfoDomain peProtCruleInfoDomain) {
        if (null == peProtCruleInfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProtCruleInfoDefault(PeProtCruleInfo peProtCruleInfo) {
        if (null == peProtCruleInfo) {
            return;
        }
        if (null == peProtCruleInfo.getDataState()) {
            peProtCruleInfo.setDataState(0);
        }
        if (null == peProtCruleInfo.getGmtCreate()) {
            peProtCruleInfo.setGmtCreate(this.getSysDate());
        }
        peProtCruleInfo.setGmtModified(this.getSysDate());
    }

    private int getProtCruleInfoMaxCode() {
        int code = 0;
        try {
            return this.peProtCruleInfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.getProtCruleInfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProtCruleInfoUpdataDefault(PeProtCruleInfo peProtCruleInfo) {
        if (null == peProtCruleInfo) {
            return;
        }
        peProtCruleInfo.setGmtModified(this.getSysDate());
    }

    private void saveProtCruleInfoModel(PeProtCruleInfo peProtCruleInfo) throws ApiException {
        if (null == peProtCruleInfo) {
            return;
        }
        try {
            this.peProtCruleInfoMapper.insert(peProtCruleInfo);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.saveProtCruleInfoModel.ex", (Throwable)e);
        }
    }

    private PeProtCruleInfo getProtCruleInfoModelById(Integer protCruleInfoId) {
        if (null == protCruleInfoId) {
            return null;
        }
        try {
            return this.peProtCruleInfoMapper.selectByPrimaryKey(protCruleInfoId);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.getProtCruleInfoModelById", (Throwable)e);
            return null;
        }
    }

    public PeProtCruleInfo getProtCruleInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.peProtCruleInfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.getProtCruleInfoModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProtCruleInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtCruleInfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.delProtCruleInfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtCruleServiceImpl.delProtCruleInfoModelByCode.num");
        }
    }

    private void deleteProtCruleInfoModel(Integer protCruleInfoId) throws ApiException {
        if (null == protCruleInfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.peProtCruleInfoMapper.deleteByPrimaryKey(protCruleInfoId);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.deleteProtCruleInfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pe.PeProtCruleServiceImpl.deleteProtCruleInfoModel.num");
        }
    }

    private void updateProtCruleInfoModel(PeProtCruleInfo peProtCruleInfo) throws ApiException {
        if (null == peProtCruleInfo) {
            return;
        }
        try {
            this.peProtCruleInfoMapper.updateByPrimaryKeySelective(peProtCruleInfo);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateProtCruleInfoModel.ex", (Throwable)e);
        }
    }

    private void updateStateProtCruleInfoModel(Integer protCruleInfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == protCruleInfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("protCruleInfoId", protCruleInfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.peProtCruleInfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateStateProtCruleInfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateStateProtCruleInfoModel.null");
        }
    }

    private PeProtCruleInfo makeProtCruleInfo(PeProtCruleInfoDomain peProtCruleInfoDomain, PeProtCruleInfo peProtCruleInfo) {
        if (null == peProtCruleInfoDomain) {
            return null;
        }
        if (null == peProtCruleInfo) {
            peProtCruleInfo = new PeProtCruleInfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)peProtCruleInfo, (Object)peProtCruleInfoDomain);
            return peProtCruleInfo;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.makeProtCruleInfo", (Throwable)e);
            return null;
        }
    }

    private List<PeProtCruleInfo> queryProtCruleInfoModelPage(Map<String, Object> parammap) {
        try {
            return this.peProtCruleInfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.queryProtCruleInfoModel", (Throwable)e);
            return null;
        }
    }

    private int countProtCruleInfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.peProtCruleInfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.countProtCruleInfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveProtCrule(PeProtCruleDomain peProtCruleDomain) throws ApiException {
        String msg = this.checkProtCrule(peProtCruleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtCruleServiceImpl.saveProtCrule.checkProtCrule", msg);
        }
        PeProtCrule peProtCrule = this.makeProtCrule(peProtCruleDomain, null);
        this.setProtCruleDefault(peProtCrule);
        this.saveProtCruleModel(peProtCrule);
    }

    @Override
    public void updateProtCruleState(Integer protCruleId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProtCruleModel(protCruleId, dataState, oldDataState);
    }

    @Override
    public void updateProtCrule(PeProtCruleDomain peProtCruleDomain) throws ApiException {
        String msg = this.checkProtCrule(peProtCruleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateProtCrule.checkProtCrule", msg);
        }
        PeProtCrule oldPeProtCrule = this.getProtCruleModelById(peProtCruleDomain.getProtCruleId());
        if (null == oldPeProtCrule) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateProtCrule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeProtCrule peProtCrule = this.makeProtCrule(peProtCruleDomain, oldPeProtCrule);
        this.setProtCruleUpdataDefault(peProtCrule);
        this.updateProtCruleModel(peProtCrule);
    }

    @Override
    public PeProtCrule getProtCrule(Integer protCruleId) {
        return this.getProtCruleModelById(protCruleId);
    }

    @Override
    public void deleteProtCrule(Integer protCruleId) throws ApiException {
        this.deleteProtCruleModel(protCruleId);
    }

    @Override
    public QueryResult<PeProtCrule> queryProtCrulePage(Map<String, Object> map) {
        List<PeProtCrule> peProtCruleList = this.queryProtCruleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProtCrule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peProtCruleList);
        return queryResult;
    }

    @Override
    public void saveProtCruleInfo(PeProtCruleInfoDomain peProtCruleInfoDomain) throws ApiException {
        String msg = this.checkProtCruleInfo(peProtCruleInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtCruleServiceImpl.saveProtCruleInfo.checkProtCruleInfo", msg);
        }
        PeProtCruleInfo peProtCruleInfo = this.makeProtCruleInfo(peProtCruleInfoDomain, null);
        this.setProtCruleInfoDefault(peProtCruleInfo);
        this.saveProtCruleInfoModel(peProtCruleInfo);
    }

    @Override
    public void updateProtCruleInfoState(Integer protCruleInfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProtCruleInfoModel(protCruleInfoId, dataState, oldDataState);
    }

    @Override
    public void updateProtCruleInfo(PeProtCruleInfoDomain peProtCruleInfoDomain) throws ApiException {
        String msg = this.checkProtCruleInfo(peProtCruleInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateProtCruleInfo.checkProtCruleInfo", msg);
        }
        PeProtCruleInfo oldPeProtCruleInfo = this.getProtCruleInfoModelById(peProtCruleInfoDomain.getProtCruleInfoId());
        if (null == oldPeProtCruleInfo) {
            throw new ApiException("pe.PeProtCruleServiceImpl.updateProtCruleInfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PeProtCruleInfo peProtCruleInfo = this.makeProtCruleInfo(peProtCruleInfoDomain, oldPeProtCruleInfo);
        this.setProtCruleInfoUpdataDefault(peProtCruleInfo);
        this.updateProtCruleInfoModel(peProtCruleInfo);
    }

    @Override
    public PeProtCruleInfo getProtCruleInfo(Integer protCruleInfoId) {
        return this.getProtCruleInfoModelById(protCruleInfoId);
    }

    @Override
    public void deleteProtCruleInfo(Integer protCruleInfoId) throws ApiException {
        this.deleteProtCruleInfoModel(protCruleInfoId);
    }

    @Override
    public QueryResult<PeProtCruleInfo> queryProtCruleInfoPage(Map<String, Object> map) {
        List<PeProtCruleInfo> peProtCruleInfoList = this.queryProtCruleInfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProtCruleInfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(peProtCruleInfoList);
        return queryResult;
    }

    @Override
    public void queryProtCruleCache() {
        this.info("pe.PeProtCruleServiceImpl.queryProtCruleCache.start", "=======\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataStates", 1L);
        List<PeProtCrule> cruleList = this.queryProtCruleModelPage(params);
        DisUtil.delVer((String)CACHE_KEY_CRULE);
        if (CollectionUtils.isEmpty(cruleList)) {
            this.info("pe.PeProtCruleServiceImpl.queryProtCruleCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        String key = "";
        for (PeProtCrule peProtCrule : cruleList) {
            PeProtCruleReDomain peProtCruleReDomain = this.makeProtCruleReDomain(peProtCrule);
            key = this.getCacheKey(peProtCrule);
            mmap.put(key, JsonUtil.buildNormalBinder().toJson((Object)peProtCruleReDomain));
        }
        DisUtil.setMap((String)CACHE_KEY_CRULE, mmap);
        this.info("pe.PeProtCruleServiceImpl.queryProtCruleCache.end", "=======\u8c03\u5ea6end=======");
    }

    private String getCacheKey(PeProtCrule peProtCrule) {
        if (null == peProtCrule) {
            return null;
        }
        String key = "";
        key = key + peProtCrule.getTenantCode();
        if (StringUtils.isBlank((String)peProtCrule.getProtEtcType())) {
            peProtCrule.setProtEtcType("*");
        }
        key = key + "-" + peProtCrule.getDicPaypdCode() + "-" + peProtCrule.getDicPayType() + "-" + peProtCrule.getDicClearCode() + "-" + peProtCrule.getDicClearreqCode() + "-" + peProtCrule.getProtEtcType();
        return key;
    }

    private void updateCache(PeProtCrule peProtCrule) {
        if (null == peProtCrule) {
            return;
        }
        String key = this.getCacheKey(peProtCrule);
        Map mmap = DisUtil.getMapAll((String)CACHE_KEY_CRULE);
        mmap.put(key, JsonUtil.buildNormalBinder().toJson((Object)this.makeProtCruleReDomain(peProtCrule)));
        DisUtil.setMap((String)CACHE_KEY_CRULE, (Map)mmap);
    }

    private void delCache(PeProtCrule peProtCrule) {
        if (null == peProtCrule) {
            return;
        }
        String key = this.getCacheKey(peProtCrule);
        Map mmap = DisUtil.getMapAll((String)CACHE_KEY_CRULE);
        mmap.remove(key);
        DisUtil.setMap((String)CACHE_KEY_CRULE, (Map)mmap);
    }

    private PeProtCruleReDomain makeProtCruleReDomain(PeProtCrule peProtCrule) {
        if (null == peProtCrule) {
            return null;
        }
        PeProtCruleReDomain peProtCruleReDomain = new PeProtCruleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peProtCruleReDomain, (Object)peProtCrule);
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.makeProtCruleReDomain.e", (Throwable)e);
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("protCruleCode", peProtCrule.getProtCruleCode());
        params.put("tenantCode", peProtCrule.getTenantCode());
        params.put("order", true);
        params.put("orderStr", "PROT_CRULE_INFO_CODE asc");
        List<PeProtCruleInfo> infoList = this.queryProtCruleInfoModelPage(params);
        peProtCruleReDomain.setInfoReDomainList(this.makeProtCruleInfoReDomainList(infoList));
        return peProtCruleReDomain;
    }

    private List<PeProtCruleInfoReDomain> makeProtCruleInfoReDomainList(List<PeProtCruleInfo> infoList) {
        if (null == infoList || infoList.isEmpty()) {
            return null;
        }
        ArrayList<PeProtCruleInfoReDomain> infoReDomainList = new ArrayList<PeProtCruleInfoReDomain>();
        for (PeProtCruleInfo peProtCruleInfo : infoList) {
            infoReDomainList.add(this.makeProtCruleInfoReDomain(peProtCruleInfo));
        }
        return infoReDomainList;
    }

    private PeProtCruleInfoReDomain makeProtCruleInfoReDomain(PeProtCruleInfo peProtCruleInfo) {
        if (null == peProtCruleInfo) {
            return null;
        }
        PeProtCruleInfoReDomain peProtCruleInfoReDomain = new PeProtCruleInfoReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)peProtCruleInfoReDomain, (Object)peProtCruleInfo);
            return peProtCruleInfoReDomain;
        }
        catch (Exception e) {
            this.logger.error("pe.PeProtCruleServiceImpl.makeProtCruleInfoReDomain.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public void savePeProtCruleInit(String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryParamMap("tenantCode", new Object[]{tenantCode})));
        HashMap<String, String> inner = new HashMap<String, String>();
        String s = this.internalInvoke("vd.faccountInner.queryFaccountInnerPage", pmap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(s, SupQueryResult.class);
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), VdFaccountInner.class);
        if (list.size() > 0) {
            for (VdFaccountInner v : list) {
                inner.put(v.getFaccountType(), v.getFaccountInnerNo());
            }
        }
        List<PeProtCruleInfo> infolist = this.queryProtCruleInfoModelPage(this.getQueryParamMap("tenantCode", new Object[]{"00000000"}));
        List<PeProtCrule> crulelist = this.queryProtCruleModelPage(this.getQueryParamMap("tenantCode", new Object[]{"00000000"}));
        HashMap map = new HashMap();
        for (PeProtCruleInfo ci : infolist) {
            ArrayList<PeProtCruleInfo> info = (ArrayList<PeProtCruleInfo>)map.get(ci.getProtCruleCode());
            if (null == info) {
                info = new ArrayList<PeProtCruleInfo>();
            }
            if (ci.getProtCruleType().equals("SYSID")) {
                String ss = ci.getProtCruleIdType();
                ss = ss.substring(ss.lastIndexOf("-") + 1, ss.length());
                ci.setProtCruleIdType("09-" + (String)inner.get(ss) + "-" + ss);
            }
            ci.setTenantCode(tenantCode);
            ci.setProtCruleInfoId(null);
            info.add(ci);
            map.put(ci.getProtCruleCode(), info);
        }
        for (PeProtCrule c : crulelist) {
            c.setTenantCode(tenantCode);
            c.setProtCruleId(null);
            c.setPeProtCruleInfo((List)map.get(c.getProtCruleCode()));
        }
        this.getCflowCruleService().putQueue(crulelist);
    }

    @Override
    public void savePeProtCruleByList(List<PeProtCrule> list) {
        for (PeProtCrule c : list) {
            this.saveProtCruleModel(c);
            for (PeProtCruleInfo info : c.getPeProtCruleInfo()) {
                this.saveProtCruleInfoModel(info);
            }
        }
        this.queryProtCruleCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CflowCruleService getCflowCruleService() {
        Object object = lock;
        synchronized (object) {
            if (null == cflowCruleService) {
                cflowCruleService = new CflowCruleService((PeProtCruleService)SpringApplicationContextUtil.getBean((String)"peProtCruleService"));
                cflowCruleService.addPollPool(new CflowCrulePollThread(cflowCruleService));
            }
            return cflowCruleService;
        }
    }

    public static void main(String[] args) {
        String s = "09-2132132-01";
        System.out.println(s.substring(s.lastIndexOf("-") + 1, s.length()));
    }

    static {
        lock = new Object();
    }
}

