/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.dao.PteFeeGoodsMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PteFeeGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteFeeGoodsReDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteFeeGoods;
import com.yqbsoft.laser.service.paytradeengine.service.PteFeeGoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteFeeGoodsServiceImpl
extends BaseServiceImpl
implements PteFeeGoodsService {
    private static final String SYS_CODE = "pte.PteFeeGoodsServiceImpl";
    private PteFeeGoodsMapper pteFeeGoodsMapper;

    public void setPteFeeGoodsMapper(PteFeeGoodsMapper pteFeeGoodsMapper) {
        this.pteFeeGoodsMapper = pteFeeGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.pteFeeGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFeeGoods(PteFeeGoodsDomain pteFeeGoodsDomain) {
        if (null == pteFeeGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteFeeGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFeeGoodsDefault(PteFeeGoods pteFeeGoods) {
        if (null == pteFeeGoods) {
            return;
        }
        if (null == pteFeeGoods.getDataState()) {
            pteFeeGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pteFeeGoods.getGmtCreate()) {
            pteFeeGoods.setGmtCreate(date);
        }
        pteFeeGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)pteFeeGoods.getFeeGoodsCode())) {
            pteFeeGoods.setFeeGoodsCode(this.getNo(null, "PteFeeGoods", "pteFeeGoods", pteFeeGoods.getTenantCode()));
        }
    }

    private int getFeeGoodsMaxCode() {
        int code = 0;
        try {
            return this.pteFeeGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeGoodsServiceImpl.getFeeGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFeeGoodsUpdataDefault(PteFeeGoods pteFeeGoods) {
        if (null == pteFeeGoods) {
            return;
        }
        pteFeeGoods.setGmtModified(this.getSysDate());
    }

    private void saveFeeGoodsModel(PteFeeGoods pteFeeGoods) throws ApiException {
        if (null == pteFeeGoods) {
            return;
        }
        try {
            this.pteFeeGoodsMapper.insert(pteFeeGoods);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.saveFeeGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveFeeGoodsBatchModel(List<PteFeeGoods> pteFeeGoodsList) throws ApiException {
        if (null == pteFeeGoodsList || pteFeeGoodsList.isEmpty()) {
            return;
        }
        try {
            this.pteFeeGoodsMapper.insertBatch(pteFeeGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.saveFeeGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private PteFeeGoods getFeeGoodsModelById(Integer feeGoodsId) {
        if (null == feeGoodsId) {
            return null;
        }
        try {
            return this.pteFeeGoodsMapper.selectByPrimaryKey(feeGoodsId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeGoodsServiceImpl.getFeeGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private PteFeeGoods getFeeGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteFeeGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeGoodsServiceImpl.getFeeGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delFeeGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteFeeGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.delFeeGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.delFeeGoodsModelByCode.num");
        }
    }

    private void deleteFeeGoodsModel(Integer feeGoodsId) throws ApiException {
        if (null == feeGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteFeeGoodsMapper.deleteByPrimaryKey(feeGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.deleteFeeGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.deleteFeeGoodsModel.num");
        }
    }

    private void updateFeeGoodsModel(PteFeeGoods pteFeeGoods) throws ApiException {
        if (null == pteFeeGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.pteFeeGoodsMapper.updateByPrimaryKey(pteFeeGoods);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.updateFeeGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.updateFeeGoodsModel.num");
        }
    }

    private void updateStateFeeGoodsModel(Integer feeGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == feeGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("feeGoodsId", feeGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteFeeGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.updateStateFeeGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.updateStateFeeGoodsModel.null");
        }
    }

    private void updateStateFeeGoodsModelByCode(String tenantCode, String feeGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)feeGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("feeGoodsCode", feeGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteFeeGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.updateStateFeeGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.updateStateFeeGoodsModelByCode.null");
        }
    }

    private PteFeeGoods makeFeeGoods(PteFeeGoodsDomain pteFeeGoodsDomain, PteFeeGoods pteFeeGoods) {
        if (null == pteFeeGoodsDomain) {
            return null;
        }
        if (null == pteFeeGoods) {
            pteFeeGoods = new PteFeeGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteFeeGoods, (Object)pteFeeGoodsDomain);
            return pteFeeGoods;
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeGoodsServiceImpl.makeFeeGoods", (Throwable)e);
            return null;
        }
    }

    private PteFeeGoodsReDomain makePteFeeGoodsReDomain(PteFeeGoods pteFeeGoods) {
        if (null == pteFeeGoods) {
            return null;
        }
        PteFeeGoodsReDomain pteFeeGoodsReDomain = new PteFeeGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteFeeGoodsReDomain, (Object)pteFeeGoods);
            return pteFeeGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeGoodsServiceImpl.makePteFeeGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteFeeGoods> queryFeeGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.pteFeeGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeGoodsServiceImpl.queryFeeGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countFeeGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteFeeGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeGoodsServiceImpl.countFeeGoods", (Throwable)e);
        }
        return i;
    }

    private PteFeeGoods createPteFeeGoods(PteFeeGoodsDomain pteFeeGoodsDomain) {
        String msg = this.checkFeeGoods(pteFeeGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.saveFeeGoods.checkFeeGoods", msg);
        }
        PteFeeGoods pteFeeGoods = this.makeFeeGoods(pteFeeGoodsDomain, null);
        this.setFeeGoodsDefault(pteFeeGoods);
        return pteFeeGoods;
    }

    @Override
    public String saveFeeGoods(PteFeeGoodsDomain pteFeeGoodsDomain) throws ApiException {
        PteFeeGoods pteFeeGoods = this.createPteFeeGoods(pteFeeGoodsDomain);
        this.saveFeeGoodsModel(pteFeeGoods);
        return pteFeeGoods.getFeeGoodsCode();
    }

    @Override
    public String saveFeeGoodsBatch(List<PteFeeGoodsDomain> pteFeeGoodsDomainList) throws ApiException {
        if (null == pteFeeGoodsDomainList || pteFeeGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteFeeGoods> pteFeeGoodsList = new ArrayList<PteFeeGoods>();
        String code = "";
        for (PteFeeGoodsDomain pteFeeGoodsDomain : pteFeeGoodsDomainList) {
            PteFeeGoods pteFeeGoods = this.createPteFeeGoods(pteFeeGoodsDomain);
            code = pteFeeGoods.getFeeGoodsCode();
            pteFeeGoodsList.add(pteFeeGoods);
        }
        this.saveFeeGoodsBatchModel(pteFeeGoodsList);
        return code;
    }

    @Override
    public void updateFeeGoodsState(Integer feeGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == feeGoodsId) {
            return;
        }
        this.updateStateFeeGoodsModel(feeGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateFeeGoodsStateByCode(String tenantCode, String feeGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)feeGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateFeeGoodsModelByCode(tenantCode, feeGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateFeeGoods(PteFeeGoodsDomain pteFeeGoodsDomain) throws ApiException {
        String msg = this.checkFeeGoods(pteFeeGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.updateFeeGoods.checkFeeGoods", msg);
        }
        PteFeeGoods oldPteFeeGoods = this.getFeeGoodsModelById(pteFeeGoodsDomain.getFeeGoodsId());
        if (null == oldPteFeeGoods) {
            throw new ApiException("pte.PteFeeGoodsServiceImpl.updateFeeGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteFeeGoods pteFeeGoods = this.makeFeeGoods(pteFeeGoodsDomain, oldPteFeeGoods);
        this.setFeeGoodsUpdataDefault(pteFeeGoods);
        this.updateFeeGoodsModel(pteFeeGoods);
    }

    @Override
    public PteFeeGoods getFeeGoods(Integer feeGoodsId) {
        if (null == feeGoodsId) {
            return null;
        }
        return this.getFeeGoodsModelById(feeGoodsId);
    }

    @Override
    public void deleteFeeGoods(Integer feeGoodsId) throws ApiException {
        if (null == feeGoodsId) {
            return;
        }
        this.deleteFeeGoodsModel(feeGoodsId);
    }

    @Override
    public QueryResult<PteFeeGoods> queryFeeGoodsPage(Map<String, Object> map) {
        List<PteFeeGoods> pteFeeGoodsList = this.queryFeeGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFeeGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteFeeGoodsList);
        return queryResult;
    }

    @Override
    public PteFeeGoods getFeeGoodsByCode(String tenantCode, String feeGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)feeGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("feeGoodsCode", feeGoodsCode);
        return this.getFeeGoodsModelByCode(map);
    }

    @Override
    public void deleteFeeGoodsByCode(String tenantCode, String feeGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)feeGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("feeGoodsCode", feeGoodsCode);
        this.delFeeGoodsModelByCode(map);
    }
}

