/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.check;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.check.BaseCheckOrder;
import com.yqbsoft.laser.service.paytradeengine.check.CheckContext;
import com.yqbsoft.laser.service.paytradeengine.enumc.PtradpdeEnum;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtrade;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepeatPayCheck
extends BaseCheckOrder {
    private static final String EXT = "ext";
    private static final String SEQ = "seq";

    @Override
    public CheckContext check(PtePtrade ptePtrade, Map<String, Object> callbackMap) {
        String paymentstate = (String)callbackMap.get("paymentstate");
        String paymentSeqno = (String)callbackMap.get("paymentSeqno");
        if (StringUtils.isBlank((String)paymentstate) || StringUtils.isBlank((String)paymentSeqno)) {
            return null;
        }
        CheckContext checkContext = null;
        Integer callbackState = Integer.valueOf(paymentstate);
        if (this.successStatus(ptePtrade.getDataState()) && this.successStatus(callbackState)) {
            String seqno;
            List<PtePtrade> extPtradeList;
            List<PtePtrade> ptradeList;
            String oldseqno;
            if (!ptePtrade.getPaymentSeqno().equals(paymentSeqno)) {
                checkContext = new CheckContext();
                checkContext.setStatus(CheckContext.BACK);
            }
            if (!StringUtils.isBlank((String)(oldseqno = ptePtrade.getPtradeOldseqno())) && ListUtil.isNotEmpty(ptradeList = this.queryPtrade(SEQ, oldseqno, ptePtrade.getTenantCode()))) {
                for (PtePtrade mainPtrade : ptradeList) {
                    CheckContext context;
                    if (!PtradpdeEnum.PAYMENTREPLACE.equals(ptePtrade.getPtradpdeCode()) || (context = this.check(mainPtrade, callbackMap)) == null) continue;
                    return context;
                }
            }
            if (ListUtil.isNotEmpty(extPtradeList = this.queryPtrade(EXT, seqno = ptePtrade.getPtradeSeqno(), ptePtrade.getTenantCode()))) {
                for (PtePtrade mainPtrade : extPtradeList) {
                    CheckContext context;
                    if (!PtradpdeEnum.PAYMENTREPLACE.equals(mainPtrade.getPtradpdeCode()) || (context = this.check(mainPtrade, callbackMap)) == null) continue;
                    return context;
                }
            }
        }
        return checkContext;
    }

    private List<PtePtrade> queryPtrade(String type, String seqno, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        if (SEQ.equals(type)) {
            map.put("ptradeSeqno", seqno);
        } else {
            map.put("ptradeOldseqno", seqno);
        }
        QueryResult<PtePtrade> queryResult = this.getService().queryPtradePage(map);
        if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            return queryResult.getList();
        }
        return null;
    }
}

