/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.service.paytradeengine.enumc.PtradpdeEnum;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PtradeBean;
import com.yqbsoft.laser.service.paytradeengine.sdomain.RequestObject;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeService;
import com.yqbsoft.laser.service.paytradeengine.service.PteTransferService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class PteTransferServiceImpl
extends BaseServiceImpl
implements PteTransferService {
    public static final String SYS_CODE = "pte.PteTransferServiceImpl";
    @Autowired
    private PtePtradeService ptePtradeService;

    @Override
    public String sendTransfer(RequestObject requestObject) throws ApiException {
        String msg = this.checkTransfer(requestObject);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteTransferServiceImpl.sendTransfer.checkTransfer", msg);
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeDomain, (Object)requestObject);
            ptePtradeDomain.setPtradeType(requestObject.getRequestType());
            ptePtradeDomain.setOpuserCode(requestObject.getUserCode());
            ptePtradeDomain.setOpuserName(requestObject.getUserName());
            ptePtradeDomain.setMerchantCode(requestObject.getUserPcode());
            ptePtradeDomain.setOrderAmount(requestObject.getMoney());
            ptePtradeDomain.setFchannelPmodeCode(requestObject.getFchannelPmodeCode());
            ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.TRANSFER.getCode());
            String remark = requestObject.getRemark();
            if (StringUtils.isBlank((String)remark)) {
                remark = "\u8f6c\u8d26";
            }
            ptePtradeDomain.setPaymentMemo(remark);
        }
        catch (Exception e) {
            this.logger.error("pte.PteTransferServiceImpl.copyAllPropertys", (Throwable)e);
        }
        PtradeBean ptradeBean = this.makeTransferParticipant(requestObject);
        ptePtradeDomain.setPtradeBean(ptradeBean);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        return this.ptePtradeService.sendSavePtrade(ptePtradeDomain);
    }

    private String checkTransfer(RequestObject requestObject) {
        if (null == requestObject) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)requestObject.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)requestObject.getPartnerCode())) {
            msg = msg + "\u5408\u4f5c\u65b9\u7f16\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)requestObject.getFaccountId())) {
            msg = msg + "\u8d26\u6237ID\u4e3a\u7a7a;";
        }
        if (requestObject.getMoney() == null) {
            msg = msg + "\u91d1\u989d\u4e3a\u7a7a;";
        }
        if (requestObject.getMoney().compareTo(new BigDecimal(0)) != 1) {
            msg = msg + "\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0;";
        }
        if (StringUtils.isBlank((String)requestObject.getUserCode())) {
            msg = msg + "\u7528\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)requestObject.getUserPcode())) {
            msg = msg + "\u6536\u6b3e\u65b9\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)requestObject.getRequestType())) {
            msg = msg + "\u4ea4\u6613\u7c7b\u578b\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)requestObject.getFchannelPmodeCode())) {
            requestObject.setFchannelPmodeCode("WEB");
        }
        if (StringUtils.isBlank((String)requestObject.getFchannelMode())) {
            requestObject.setFchannelMode("1");
        }
        return msg;
    }

    private PtradeBean makeTransferParticipant(RequestObject requestObject) {
        PtradeBean pb = new PtradeBean();
        pb.setTenantCode(requestObject.getTenantCode());
        pb.setFchannelPmodeCode(requestObject.getFchannelPmodeCode());
        pb.setFchannelMode(requestObject.getFchannelMode());
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        String code = requestObject.getUserCode().substring(0, 1);
        PtePtradeParticipantDomain pd1 = new PtePtradeParticipantDomain();
        pd1.setDicActorCode("BUY_B");
        pd1.setFaccountId(requestObject.getFaccountId());
        pd1.setFchannelCode("0" + code);
        pd1.setFchannelClassifyCode(code + "01");
        if (StringUtils.isNotBlank((String)requestObject.getFchannelCode())) {
            pd1.setFchannelCode(requestObject.getFchannelCode());
        }
        if (StringUtils.isNotBlank((String)requestObject.getFchannelClassifyCode())) {
            pd1.setFchannelClassifyCode(requestObject.getFchannelClassifyCode());
        }
        pd1.setOrderAmount(requestObject.getMoney());
        partList.add(pd1);
        pb.setPartList(partList);
        return pb;
    }
}

