/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.dao.UpOpdataListMapper;
import com.yqbsoft.laser.service.permis.domain.UpOpdataListDomain;
import com.yqbsoft.laser.service.permis.domain.UpOpdataListReDomain;
import com.yqbsoft.laser.service.permis.model.UpOpdataList;
import com.yqbsoft.laser.service.permis.service.UpOpdataListService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpOpdataListServiceImpl
extends BaseServiceImpl
implements UpOpdataListService {
    private static final String SYS_CODE = "up.PERMIS.UpOpdataListServiceImpl";
    private UpOpdataListMapper upOpdataListMapper;

    public void setUpOpdataListMapper(UpOpdataListMapper upOpdataListMapper) {
        this.upOpdataListMapper = upOpdataListMapper;
    }

    private Date getSysDate() {
        try {
            return this.upOpdataListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpdataList(UpOpdataListDomain upOpdataListDomain) {
        if (null == upOpdataListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upOpdataListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpdataListDefault(UpOpdataList upOpdataList) {
        if (null == upOpdataList) {
            return;
        }
        if (null == upOpdataList.getDataState()) {
            upOpdataList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == upOpdataList.getGmtCreate()) {
            upOpdataList.setGmtCreate(date);
        }
        upOpdataList.setGmtModified(date);
        if (StringUtils.isBlank((String)upOpdataList.getOpdataListCode())) {
            upOpdataList.setOpdataListCode(this.getNo(null, "UpOpdataList", "upOpdataList", upOpdataList.getTenantCode()));
        }
    }

    private int getOpdataListMaxCode() {
        int code = 0;
        try {
            return this.upOpdataListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataListServiceImpl.getOpdataListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpdataListUpdataDefault(UpOpdataList upOpdataList) {
        if (null == upOpdataList) {
            return;
        }
        upOpdataList.setGmtModified(this.getSysDate());
    }

    private void saveOpdataListModel(UpOpdataList upOpdataList) throws ApiException {
        if (null == upOpdataList) {
            return;
        }
        try {
            this.upOpdataListMapper.insert(upOpdataList);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.saveOpdataListModel.ex", (Throwable)e);
        }
    }

    private void saveOpdataListBatchModel(List<UpOpdataList> upOpdataListList) throws ApiException {
        if (null == upOpdataListList || upOpdataListList.isEmpty()) {
            return;
        }
        try {
            this.upOpdataListMapper.insertBatch(upOpdataListList);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.saveOpdataListBatchModel.ex", (Throwable)e);
        }
    }

    private UpOpdataList getOpdataListModelById(Integer opdataListId) {
        if (null == opdataListId) {
            return null;
        }
        try {
            return this.upOpdataListMapper.selectByPrimaryKey(opdataListId);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataListServiceImpl.getOpdataListModelById", (Throwable)e);
            return null;
        }
    }

    private UpOpdataList getOpdataListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upOpdataListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataListServiceImpl.getOpdataListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpdataListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdataListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.delOpdataListModelByCode.ex", (Throwable)e);
        }
    }

    private void deleteOpdataListModel(Integer opdataListId) throws ApiException {
        if (null == opdataListId) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdataListMapper.deleteByPrimaryKey(opdataListId);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.deleteOpdataListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.deleteOpdataListModel.num");
        }
    }

    private void updateOpdataListModel(UpOpdataList upOpdataList) throws ApiException {
        if (null == upOpdataList) {
            return;
        }
        int i = 0;
        try {
            i = this.upOpdataListMapper.updateByPrimaryKey(upOpdataList);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.updateOpdataListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.updateOpdataListModel.num");
        }
    }

    private void updateStateOpdataListModel(Integer opdataListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opdataListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opdataListId", opdataListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upOpdataListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.updateStateOpdataListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.updateStateOpdataListModel.null");
        }
    }

    private void updateStateOpdataListModelByCode(String tenantCode, String opdataListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opdataListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdataListCode", opdataListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upOpdataListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.updateStateOpdataListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.updateStateOpdataListModelByCode.null");
        }
    }

    private UpOpdataList makeOpdataList(UpOpdataListDomain upOpdataListDomain, UpOpdataList upOpdataList) {
        if (null == upOpdataListDomain) {
            return null;
        }
        if (null == upOpdataList) {
            upOpdataList = new UpOpdataList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upOpdataList, (Object)upOpdataListDomain);
            return upOpdataList;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataListServiceImpl.makeOpdataList", (Throwable)e);
            return null;
        }
    }

    private UpOpdataListReDomain makeUpOpdataListReDomain(UpOpdataList upOpdataList) {
        if (null == upOpdataList) {
            return null;
        }
        UpOpdataListReDomain upOpdataListReDomain = new UpOpdataListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upOpdataListReDomain, (Object)upOpdataList);
            return upOpdataListReDomain;
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataListServiceImpl.makeUpOpdataListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UpOpdataList> queryOpdataListModelPage(Map<String, Object> parammap) {
        try {
            return this.upOpdataListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataListServiceImpl.queryOpdataListModel", (Throwable)e);
            return null;
        }
    }

    private int countOpdataList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upOpdataListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.UpOpdataListServiceImpl.countOpdataList", (Throwable)e);
        }
        return i;
    }

    private UpOpdataList createUpOpdataList(UpOpdataListDomain upOpdataListDomain) {
        String msg = this.checkOpdataList(upOpdataListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.saveOpdataList.checkOpdataList", msg);
        }
        UpOpdataList upOpdataList = this.makeOpdataList(upOpdataListDomain, null);
        this.setOpdataListDefault(upOpdataList);
        return upOpdataList;
    }

    @Override
    public String saveOpdataList(UpOpdataListDomain upOpdataListDomain) throws ApiException {
        UpOpdataList upOpdataList = this.createUpOpdataList(upOpdataListDomain);
        this.saveOpdataListModel(upOpdataList);
        return upOpdataList.getOpdataListCode();
    }

    @Override
    public String saveOpdataListBatch(List<UpOpdataListDomain> upOpdataListDomainList) throws ApiException {
        if (null == upOpdataListDomainList || upOpdataListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UpOpdataList> upOpdataListList = new ArrayList<UpOpdataList>();
        String code = "";
        for (UpOpdataListDomain upOpdataListDomain : upOpdataListDomainList) {
            UpOpdataList upOpdataList = this.createUpOpdataList(upOpdataListDomain);
            code = upOpdataList.getOpdataListCode();
            upOpdataListList.add(upOpdataList);
        }
        this.saveOpdataListBatchModel(upOpdataListList);
        return code;
    }

    @Override
    public void updateOpdataListState(Integer opdataListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opdataListId) {
            return;
        }
        this.updateStateOpdataListModel(opdataListId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpdataListStateByCode(String tenantCode, String opdataListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opdataListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpdataListModelByCode(tenantCode, opdataListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpdataList(UpOpdataListDomain upOpdataListDomain) throws ApiException {
        String msg = this.checkOpdataList(upOpdataListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.updateOpdataList.checkOpdataList", msg);
        }
        UpOpdataList oldUpOpdataList = this.getOpdataListModelById(upOpdataListDomain.getOpdataListId());
        if (null == oldUpOpdataList) {
            throw new ApiException("up.PERMIS.UpOpdataListServiceImpl.updateOpdataList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpOpdataList upOpdataList = this.makeOpdataList(upOpdataListDomain, oldUpOpdataList);
        this.setOpdataListUpdataDefault(upOpdataList);
        this.updateOpdataListModel(upOpdataList);
    }

    @Override
    public UpOpdataList getOpdataList(Integer opdataListId) {
        if (null == opdataListId) {
            return null;
        }
        return this.getOpdataListModelById(opdataListId);
    }

    @Override
    public void deleteOpdataList(Integer opdataListId) throws ApiException {
        if (null == opdataListId) {
            return;
        }
        this.deleteOpdataListModel(opdataListId);
    }

    @Override
    public QueryResult<UpOpdataList> queryOpdataListPage(Map<String, Object> map) {
        List<UpOpdataList> upOpdataListList = this.queryOpdataListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpdataList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upOpdataListList);
        return queryResult;
    }

    @Override
    public UpOpdataList getOpdataListByCode(String tenantCode, String opdataListCode) throws ApiException {
        if (StringUtils.isBlank((String)opdataListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdataListCode", opdataListCode);
        return this.getOpdataListModelByCode(map);
    }

    @Override
    public void deleteOpdataListByCode(String tenantCode, String opdataListCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opdataListCode", opdataListCode);
        this.delOpdataListModelByCode(map);
    }
}

