/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.permis.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.permis.PermisConstants;
import com.yqbsoft.laser.service.permis.dao.UpOpPermissionMapper;
import com.yqbsoft.laser.service.permis.dao.UpRoleMapper;
import com.yqbsoft.laser.service.permis.domain.Permisson;
import com.yqbsoft.laser.service.permis.domain.UpMenuDomainBean;
import com.yqbsoft.laser.service.permis.model.UpOpPermission;
import com.yqbsoft.laser.service.permis.model.UpRole;
import com.yqbsoft.laser.service.permis.service.OpPermissionService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.FreeMarkerTemplateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpPermissionServiceImpl
extends BaseServiceImpl
implements OpPermissionService {
    public static final String SYS_CODE = "up.PERMIS.OpPermissionServiceImpl";
    private UpOpPermissionMapper upOpPermissionMapper;
    private UpRoleMapper upRoleMapper;
    String cachekey = "os-UpOpPermission";

    public UpRoleMapper getUpRoleMapper() {
        return this.upRoleMapper;
    }

    public void setUpRoleMapper(UpRoleMapper upRoleMapper) {
        this.upRoleMapper = upRoleMapper;
    }

    public UpOpPermissionMapper getUpOpPermissionMapper() {
        return this.upOpPermissionMapper;
    }

    public void setUpOpPermissionMapper(UpOpPermissionMapper upOpPermissionMapper) {
        this.upOpPermissionMapper = upOpPermissionMapper;
    }

    @Override
    public void saveOpPermission(UpOpPermission upOpPermission) {
        if (null == upOpPermission) {
            return;
        }
        this.upOpPermissionMapper.insert(upOpPermission);
    }

    private List<UpOpPermission> queryOpPermission(Map<String, Object> parammap) {
        try {
            return this.upOpPermissionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    private List<UpRole> queryOpRule(Map<String, Object> parammap) {
        try {
            return this.upRoleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UpOpPermission getOpPermission(Integer opPermissionId) {
        return this.upOpPermissionMapper.selectByPrimaryKey(opPermissionId);
    }

    @Override
    public void updateOpPermission(UpOpPermission upOpPermission) {
        this.upOpPermissionMapper.updateByPrimaryKey(upOpPermission);
    }

    @Override
    public List<UpOpPermission> queryUpOpPermission(Map<String, Object> map) {
        return this.queryOpPermission(map);
    }

    @Override
    public QueryResult<UpOpPermission> queryOpPermissionPage(Map<String, Object> map) {
        List<UpOpPermission> upOpPermissionInfo = this.queryOpPermission(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpPermissionList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upOpPermissionInfo);
        return queryResult;
    }

    private int countOpPermissionList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upOpPermissionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.OpPermissionServiceImpl.countUser", (Throwable)e);
        }
        return i;
    }

    @Override
    public void deleteOpPermission(Integer opPermissionId) {
        this.upOpPermissionMapper.deleteByPrimaryKey(opPermissionId);
    }

    public Map<String, String> queryMuserPermissionAndAttach(Integer opPermissionApp, String roleCode, String userCode) {
        List<UpOpPermission> muserPermisList = null;
        try {
            muserPermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("opPermissionApp,opPermissionType,opPermissionCode", new Object[]{opPermissionApp, PermisConstants.PERMIS_TYPE_OPER, userCode}));
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.OpPermissionServiceImpl.queryMuserPermissionTm.queryMuserPermissionTm", (Object)"e", (Throwable)e);
            return null;
        }
        List<UpOpPermission> rolePermisList = null;
        if (StringUtils.isNotBlank((String)roleCode)) {
            rolePermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("opPermissionApp,opPermissionType,opPermissionCode", new Object[]{opPermissionApp, PermisConstants.PERMIS_TYPE_ROLE, roleCode}));
        }
        return this.permissionHandler(muserPermisList, rolePermisList, "menuCode,permissionAttach");
    }

    @Override
    public Map<String, String> queryMuserPermission(String tenantCode, String roleCode, String userCode) {
        return this.queryMuserPermissionTm(tenantCode, PermisConstants.PERMIS_APP_UM, roleCode, userCode, null);
    }

    @Override
    public Map<String, String> queryMuserPermissionTm(String tenantCode, String roleCode, String userCode) {
        return this.queryMuserPermissionTm(tenantCode, PermisConstants.PERMIS_APP_MM, roleCode, userCode, null);
    }

    @Override
    public Map<String, String> queryMuserPermissionByYH(String tenantCode, String roleCode, String userCode) {
        return this.queryMuserPermissionTm(tenantCode, PermisConstants.PERMIS_APP_UM, roleCode, userCode, null);
    }

    private Map<String, String> queryMuserPermissionTm(String tenantCode, Integer opPermissionApp, String roleCode, String userCode, String proappCode) {
        List<UpOpPermission> muserPermisList = null;
        try {
            Map pamap = StringUtils.isBlank((String)proappCode) ? this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_OPER, userCode}) : this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode,appmanageIcode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_OPER, userCode, proappCode});
            muserPermisList = this.upOpPermissionMapper.query(pamap);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.OpPermissionServiceImpl.queryMuserPermissionTm.queryMuserPermissionTm", (Object)"e", (Throwable)e);
            return null;
        }
        List<UpOpPermission> rolePermisList = this.getRoleOpList(tenantCode, opPermissionApp, roleCode, proappCode);
        Map<String, String> map = this.permissionHandler(muserPermisList, rolePermisList, "menuCode");
        if (map == null || map.isEmpty()) {
            return map;
        }
        return this.permissionHandlerByTenant(tenantCode, opPermissionApp, map);
    }

    public Map<String, String> queryMuserPermissionByYH(String tenantCode, Integer opPermissionApp, String roleCode, String userCode, String proappCode) {
        List<UpOpPermission> muserPermisList = null;
        try {
            Map pamap = StringUtils.isBlank((String)proappCode) ? this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_TENANT, userCode}) : this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode,appmanageIcode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_TENANT, userCode, proappCode});
            muserPermisList = this.upOpPermissionMapper.query(pamap);
        }
        catch (Exception e) {
            this.logger.error("up.PERMIS.OpPermissionServiceImpl.queryMuserPermissionTmByYH.queryMuserPermissionTmByYH", (Object)"e", (Throwable)e);
            return null;
        }
        List<UpOpPermission> rolePermisList = this.getRoleOpList(tenantCode, opPermissionApp, roleCode, proappCode);
        Map<String, String> map = this.permissionHandler(muserPermisList, rolePermisList, "menuCode");
        if (map == null || map.isEmpty()) {
            return map;
        }
        return this.permissionHandlerByTenant(tenantCode, opPermissionApp, map);
    }

    private List<UpOpPermission> getRoleOpList(String tenantCode, Integer opPermissionApp, String roleCode, String proappCode) {
        if (StringUtils.isBlank((String)roleCode)) {
            return null;
        }
        ArrayList<UpOpPermission> rolePermisList = new ArrayList<UpOpPermission>();
        String[] roleStr = roleCode.split(",");
        if (null != roleStr && roleStr.length > 0) {
            Map pmap = null;
            Map tpmap = null;
            for (String string : roleStr) {
                if (StringUtils.isBlank((String)proappCode)) {
                    pmap = this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_ROLE, string});
                    tpmap = this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode", new Object[]{"00000000", opPermissionApp, PermisConstants.PERMIS_TYPE_ROLE, string});
                } else {
                    pmap = this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode,appmanageIcode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_ROLE, string, proappCode});
                    tpmap = this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode,appmanageIcode", new Object[]{"00000000", opPermissionApp, PermisConstants.PERMIS_TYPE_ROLE, string, proappCode});
                }
                List<UpOpPermission> rolePermisList1 = this.upOpPermissionMapper.query(pmap);
                if (rolePermisList1 == null || rolePermisList1.isEmpty()) {
                    rolePermisList1 = this.upOpPermissionMapper.query(tpmap);
                }
                if (!ListUtil.isNotEmpty(rolePermisList1)) continue;
                rolePermisList.addAll(rolePermisList1);
            }
        }
        return rolePermisList;
    }

    private Map<String, String> permissionHandlerByTenant(String tenantCode, Integer opPermissionApp, Map<String, String> map) {
        List<UpOpPermission> tenantPermisList = null;
        if (StringUtils.isNotBlank((String)tenantCode)) {
            tenantPermisList = this.upOpPermissionMapper.query(this.getQueryParamMap("tenantCode,opPermissionApp,opPermissionType,opPermissionCode", new Object[]{tenantCode, opPermissionApp, PermisConstants.PERMIS_TYPE_TENANT, tenantCode}));
        }
        if (tenantPermisList == null || tenantPermisList.isEmpty()) {
            return map;
        }
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (UpOpPermission upOpPermission : tenantPermisList) {
            String menuCode = upOpPermission.getMenuCode();
            Integer opPermissionState = upOpPermission.getOpPermissionState();
            if (opPermissionState != PermisConstants.USER_STATE_ON) continue;
            newMap.put(menuCode, map.get(menuCode));
        }
        return newMap;
    }

    private Map<String, String> permissionHandler(List<UpOpPermission> muserPermisList, List<UpOpPermission> rolePermisList, String valueKey) {
        Map<String, Object> muserPermis = this.setMuserPermis(muserPermisList, rolePermisList);
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : muserPermis.entrySet()) {
            String[] valueKeys = valueKey.split(",");
            StringBuffer returnSb = new StringBuffer("");
            for (String key : valueKeys) {
                if (entry.getValue() == null) continue;
                Map map = (Map)entry.getValue();
                String value = (String)map.get(key);
                returnSb.append(value);
                returnSb.append("-");
            }
            if (returnSb.length() <= 0) continue;
            retMap.put(entry.getKey(), returnSb.substring(0, returnSb.lastIndexOf("-")));
        }
        return retMap;
    }

    private Map<String, Object> setMuserPermis(List<UpOpPermission> muserPermisList, List<UpOpPermission> rolePermisList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != muserPermisList && !muserPermisList.isEmpty()) {
            Map<String, UpOpPermission> roleMap = this.getRoleMap(rolePermisList);
            this.setMuserPermission(map, muserPermisList, roleMap);
        }
        if (null != rolePermisList && !rolePermisList.isEmpty()) {
            for (UpOpPermission mod : rolePermisList) {
                if (null == mod.getOpPermissionState()) {
                    mod.setOpPermissionState(PermisConstants.USER_STATE_ROLE);
                }
                if (!PermisConstants.USER_STATE_ON.equals(mod.getOpPermissionState()) || map.get(mod.getMenuCode()) != null) continue;
                String permissionAttach = mod.getPermissionAttach();
                if (StringUtils.isBlank((String)permissionAttach)) {
                    permissionAttach = "";
                }
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("permissionAttach", permissionAttach);
                param.put("menuCode", mod.getMenuCode());
                map.put(mod.getMenuCode(), param);
            }
        }
        return map;
    }

    private Map<String, UpOpPermission> getRoleMap(List<UpOpPermission> roleList) {
        HashMap<String, UpOpPermission> roleMap = new HashMap<String, UpOpPermission>();
        if (null != roleList && !roleList.isEmpty()) {
            for (UpOpPermission permission : roleList) {
                roleMap.put(permission.getMenuCode(), permission);
            }
        }
        return roleMap;
    }

    private void setMuserPermission(Map<String, Object> map, List<UpOpPermission> muserPermisList, Map<String, UpOpPermission> roleMap) {
        UpOpPermission roleMod = null;
        for (UpOpPermission mod : muserPermisList) {
            if (null != roleMap) {
                roleMod = roleMap.get(mod.getMenuCode());
            }
            if (null == mod.getOpPermissionState()) {
                mod.setOpPermissionState(PermisConstants.USER_STATE_ROLE);
            }
            if (null != roleMod && PermisConstants.USER_STATE_ROLE.equals(mod.getOpPermissionState()) && PermisConstants.USER_STATE_ON.equals(roleMod.getOpPermissionState()) || PermisConstants.USER_STATE_ON.equals(mod.getOpPermissionState())) {
                String permissionAttach = mod.getPermissionAttach();
                if (StringUtils.isBlank((String)permissionAttach)) {
                    permissionAttach = "";
                }
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("permissionAttach", permissionAttach);
                param.put("menuCode", mod.getMenuCode());
                map.put(mod.getMenuCode(), param);
            }
            if (null == roleMod) continue;
            roleMod.setOpPermissionState(mod.getOpPermissionState());
        }
    }

    @Override
    public void saveOpPermission(List<UpOpPermission> upOpPermissionList) {
        if (upOpPermissionList == null || upOpPermissionList.isEmpty()) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String key = "";
        for (UpOpPermission upOpPermission : upOpPermissionList) {
            this.saveOpPermission(upOpPermission);
            key = upOpPermission.getTenantCode() + "-" + upOpPermission.getOpPermissionType() + "-" + upOpPermission.getOpPermissionCode();
            if (map.containsKey(map)) continue;
            map.put(key, key);
        }
        if (MapUtil.isNotEmpty(map)) {
            int xu = 0;
            for (String upkey : map.keySet()) {
                String xustr = DisUtil.getRemot((String)(this.cachekey + "_" + upkey));
                if (StringUtils.isBlank((String)xustr)) {
                    xustr = "0";
                }
                xu = Integer.valueOf(xustr) + 1;
                DisUtil.set((String)(this.cachekey + "_" + upkey), (String)String.valueOf(xu));
            }
        }
    }

    @Override
    public void updateOpPermission(List<UpOpPermission> upOpPermissionList) {
        if (upOpPermissionList == null || upOpPermissionList.isEmpty()) {
            return;
        }
        for (UpOpPermission upOpPermission : upOpPermissionList) {
            this.updateOpPermission(upOpPermission);
        }
    }

    @Override
    public Map<String, String> queryMuserPermissionDetail(String proappCode, String roleCode, String userCode) {
        return this.queryMuserPermissionDetailWrapper(proappCode, PermisConstants.PERMIS_APP_UM, roleCode, userCode, "");
    }

    public List<Map<String, Object>> makeChildren(List<UpMenuDomainBean> menuDomainList, Map<String, String> permisMap, Map<String, Object> paramMap) {
        if (ListUtil.isEmpty(menuDomainList)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> menuShowList = new ArrayList<Map<String, Object>>();
        boolean flag = true;
        for (UpMenuDomainBean menu : menuDomainList) {
            Permisson permisson;
            String perStr;
            List<Map<String, Object>> childList;
            HashMap<String, Object> returnMenu = new HashMap<String, Object>();
            String permisValue = "";
            flag = true;
            if (ListUtil.isNotEmpty(menu.getChildren()) && null != (childList = this.makeChildren(menu.getChildren(), permisMap, paramMap)) && !childList.isEmpty()) {
                returnMenu.put("children", childList);
                this.makeMenu(paramMap, menu, returnMenu, permisValue);
                menuShowList.add(returnMenu);
                flag = false;
            }
            if (!flag || StringUtils.isBlank((String)menu.getPermissionCode()) || StringUtils.isBlank((String)(perStr = SupDisUtil.getMap((String)"UpPermission-permission", (String)(menu.getPermissionCode() + "-" + "00000000")))) || null == (permisson = (Permisson)JsonUtil.buildNormalBinder().getJsonToObject(perStr, Permisson.class)) || !"0".equals(permisson.getPermissionSort()) && (null == menu.getChildren() || menu.getChildren().isEmpty()) || "0".equals(permisson.getPermissionSort()) && StringUtils.isEmpty((String)(permisValue = permisMap.get(menu.getMenuCode()))) && (null == menu.getChildren() || menu.getChildren().isEmpty())) continue;
            this.makeMenu(paramMap, menu, returnMenu, permisValue);
            menuShowList.add(returnMenu);
        }
        return menuShowList;
    }

    private void makeMenu(Map<String, Object> paramMap, UpMenuDomainBean menu, Map<String, Object> returnMenu, String permisValue) {
        if (StringUtils.isBlank((String)menu.getMenuDetailsCode())) {
            menu.setMenuDetailsCode(menu.getMenuCode());
        }
        try {
            BeanUtils.copyAllPropertys(returnMenu, (Object)menu);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        returnMenu.put("proappMenuPcode", menu.getProappMenuPcode());
        returnMenu.put("proappMenuCode", menu.getProappMenuCode());
        returnMenu.put("proappCode", menu.getProappCode());
        returnMenu.put("proappMenuRemark", menu.getProappMenuRemark());
        returnMenu.put("proappMenuOrder", menu.getProappMenuOrder());
        returnMenu.put("menuCode", menu.getMenuCode());
        returnMenu.put("menuName", menu.getMenuName());
        returnMenu.put("menuShow", menu.getMenuShow());
        returnMenu.put("menuOrder", menu.getProappMenuOrder());
        returnMenu.put("menuAction", menu.getMenuAction());
        returnMenu.put("menuDetailsCode", menu.getMenuDetailsCode());
        returnMenu.put("menuIcon", menu.getMenuJspath());
        String menuActionParam = "";
        try {
            String[] attachs;
            BeanUtils.copyAllPropertysNotNull(paramMap, (Object)menu);
            if (StringUtils.isNotBlank((String)permisValue) && (attachs = permisValue.split("-")) != null && attachs.length > 1 && StringUtils.isNotBlank((String)attachs[1])) {
                HashMap<String, Object> amap = new HashMap<String, Object>();
                menuActionParam = OpPermissionServiceImpl.getContent(amap, paramMap, attachs[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        returnMenu.put("menuActionParam", menuActionParam);
    }

    private static String getContent(Map<String, Object> amap, Map<String, Object> paramMap, String manualContent) {
        if (MapUtil.isNotEmpty(paramMap)) {
            for (String key : paramMap.keySet()) {
                amap.put(key, paramMap.get(key));
            }
        }
        return FreeMarkerTemplateUtils.getContent(amap, (String)manualContent);
    }

    @Override
    public Map<String, String> queryMuserPermissionDetailMap(Map<String, Object> map) {
        if (map == null || map.get("proappCode") == null || map.get("userCode") == null || map.get("tenantCode") == null) {
            return null;
        }
        String roleCode = String.valueOf(map.get("roleCode"));
        String userCode = String.valueOf(map.get("userCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        String proappCode = String.valueOf(map.get("proappCode"));
        return this.queryMuserPermissionDetailWrapper(proappCode, PermisConstants.PERMIS_APP_UM, roleCode, userCode, tenantCode);
    }

    @Override
    public Map<String, String> queryMuserPermissionDetailMapTm(Map<String, Object> map) {
        if (map == null || map.get("proappCode") == null || map.get("userCode") == null || map.get("tenantCode") == null) {
            return null;
        }
        String roleCode = String.valueOf(map.get("roleCode"));
        String userCode = String.valueOf(map.get("userCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        String proappCode = String.valueOf(map.get("proappCode"));
        return this.queryMuserPermissionDetailWrapper(proappCode, PermisConstants.PERMIS_APP_MM, roleCode, userCode, tenantCode);
    }

    private Map<String, String> queryMuserPermissionDetailWrapper(String proappCode, Integer opPermissionApp, String roleCode, String userCode, String tenantCode) {
        Map<String, String> permisMap = this.queryMuserPermissionTm(tenantCode, opPermissionApp, roleCode, userCode, proappCode);
        return permisMap;
    }

    @Override
    public void updateUserPermission(List<UpOpPermission> upOpPermissionList) {
        String opPermissionCode = upOpPermissionList.get(0).getOpPermissionCode();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("opPermissionCode", opPermissionCode);
        List<UpOpPermission> upOpPermissions = this.queryOpPermission(parammap);
        for (UpOpPermission upOpPermission : upOpPermissions) {
            this.deleteOpPermission(upOpPermission.getOpPermissionId());
        }
        this.saveOpPermission(upOpPermissionList);
    }

    @Override
    public void deleteOpPermissionList(List<UpOpPermission> upOpPermissionList) {
        if (upOpPermissionList == null || upOpPermissionList.isEmpty()) {
            return;
        }
        for (UpOpPermission upOpPermission : upOpPermissionList) {
            this.deleteOpPermission(upOpPermission.getOpPermissionId());
        }
    }

    @Override
    public void saveOpPermissionInit(String tenantCode, String proappCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String inittenantCode = "00000000";
        List<UpRole> listRole = this.queryOpRule(this.getQueryParamMap("tenantCode", new Object[]{inittenantCode}));
        if (ListUtil.isEmpty(listRole)) {
            return;
        }
        ArrayList<UpRole> newRolelist = new ArrayList<UpRole>();
        for (UpRole upRole : listRole) {
            List<UpRole> oldRolelist = this.queryOpRule(this.getQueryParamMap("tenantCode,roleCode,roleType,roleName,", new Object[]{tenantCode, upRole.getRoleCode(), upRole.getRoleType(), upRole.getRoleName()}));
            if (!ListUtil.isEmpty(oldRolelist)) continue;
            upRole.setTenantCode(tenantCode);
            upRole.setRoleId(null);
            newRolelist.add(upRole);
        }
        for (UpRole upRole : newRolelist) {
            this.upRoleMapper.insert(upRole);
        }
        List<UpOpPermission> list = this.queryOpPermission(this.getQueryParamMap("tenantCode,appmanageIcode", new Object[]{inittenantCode, proappCode}));
        if (ListUtil.isEmpty(list)) {
            return;
        }
        ArrayList<UpOpPermission> newlist = new ArrayList<UpOpPermission>();
        for (UpOpPermission upOpPermission : list) {
            List<UpOpPermission> oldlist = this.queryOpPermission(this.getQueryParamMap("tenantCode,appmanageIcode,menuCode,opPermissionApp,opPermissionCode,opPermissionType", new Object[]{tenantCode, upOpPermission.getAppmanageIcode(), upOpPermission.getMenuCode(), upOpPermission.getOpPermissionApp(), upOpPermission.getOpPermissionCode(), upOpPermission.getOpPermissionType()}));
            if (!ListUtil.isEmpty(oldlist)) continue;
            upOpPermission.setTenantCode(tenantCode);
            upOpPermission.setOpPermissionId(null);
            newlist.add(upOpPermission);
        }
        this.saveOpPermission(newlist);
    }
}

