/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgProductCdlMapper;
import com.yqbsoft.laser.service.pg.domain.PgProductCdlDomain;
import com.yqbsoft.laser.service.pg.domain.PgProductCdlReDomain;
import com.yqbsoft.laser.service.pg.domain.RsBrandDomain;
import com.yqbsoft.laser.service.pg.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.pg.model.PgLabel;
import com.yqbsoft.laser.service.pg.model.PgProductCdl;
import com.yqbsoft.laser.service.pg.model.PgProductPriceCdl;
import com.yqbsoft.laser.service.pg.service.PgLabelService;
import com.yqbsoft.laser.service.pg.service.PgProductCdlService;
import com.yqbsoft.laser.service.pg.service.PgProductPriceCdlService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PgProductCdlServiceImpl
extends BaseServiceImpl
implements PgProductCdlService {
    private static final String SYS_CODE = "pg.PICK.PgProductCdlServiceImpl";
    private PgProductCdlMapper pgProductCdlMapper;
    private PgLabelService pgLabelService;
    private PgProductPriceCdlService pgProductPriceCdlService;

    public void setPgProductCdlMapper(PgProductCdlMapper pgProductCdlMapper) {
        this.pgProductCdlMapper = pgProductCdlMapper;
    }

    public void setPgProductPriceCdlService(PgProductPriceCdlService pgProductPriceCdlService) {
        this.pgProductPriceCdlService = pgProductPriceCdlService;
    }

    public void setPgLabelService(PgLabelService pgLabelService) {
        this.pgLabelService = pgLabelService;
    }

    private Date getSysDate() {
        try {
            return this.pgProductCdlMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductCdlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProductCdl(PgProductCdlDomain pgProductCdlDomain) {
        if (null == pgProductCdlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgProductCdlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProductCdlDefault(PgProductCdl pgProductCdl) {
        if (null == pgProductCdl) {
            return;
        }
        if (null == pgProductCdl.getDataState()) {
            pgProductCdl.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgProductCdl.getGmtCreate()) {
            pgProductCdl.setGmtCreate(date);
        }
        pgProductCdl.setGmtModified(date);
        if (StringUtils.isBlank((String)pgProductCdl.getCode())) {
            pgProductCdl.setCode(this.getNo(null, "PgProductCdl", "pgProductCdl", pgProductCdl.getTenantCode()));
        }
    }

    private int getProductCdlMaxCode() {
        int code = 0;
        try {
            return this.pgProductCdlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductCdlServiceImpl.getProductCdlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProductCdlUpdataDefault(PgProductCdl pgProductCdl) {
        if (null == pgProductCdl) {
            return;
        }
        pgProductCdl.setGmtModified(this.getSysDate());
    }

    private void saveProductCdlModel(PgProductCdl pgProductCdl) throws ApiException {
        if (null == pgProductCdl) {
            return;
        }
        try {
            this.pgProductCdlMapper.insert(pgProductCdl);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.saveProductCdlModel.ex", (Throwable)e);
        }
    }

    private void saveProductCdlBatchModel(List<PgProductCdl> pgProductCdlList) throws ApiException {
        if (null == pgProductCdlList || pgProductCdlList.isEmpty()) {
            return;
        }
        try {
            this.pgProductCdlMapper.insertBatch(pgProductCdlList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.saveProductCdlBatchModel.ex", (Throwable)e);
        }
    }

    private PgProductCdl getProductCdlModelById(Integer id) {
        if (null == id) {
            return null;
        }
        try {
            return this.pgProductCdlMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductCdlServiceImpl.getProductCdlModelById", (Throwable)e);
            return null;
        }
    }

    private PgProductCdl getProductCdlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgProductCdlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductCdlServiceImpl.getProductCdlModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProductCdlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgProductCdlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.delProductCdlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.delProductCdlModelByCode.num");
        }
    }

    private void deleteProductCdlModel(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.pgProductCdlMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.deleteProductCdlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.deleteProductCdlModel.num");
        }
    }

    private void updateProductCdlModel(PgProductCdl pgProductCdl) throws ApiException {
        if (null == pgProductCdl) {
            return;
        }
        int i = 0;
        try {
            i = this.pgProductCdlMapper.updateByPrimaryKey(pgProductCdl);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.updateProductCdlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.updateProductCdlModel.num");
        }
    }

    private void updateStateProductCdlModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgProductCdlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.updateStateProductCdlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.updateStateProductCdlModel.null");
        }
    }

    private void updateStateProductCdlModelByCode(String tenantCode, String code, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)code) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("code", code);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgProductCdlMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.updateStateProductCdlModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.updateStateProductCdlModelByCode.null");
        }
    }

    private PgProductCdl makeProductCdl(PgProductCdlDomain pgProductCdlDomain, PgProductCdl pgProductCdl) {
        if (null == pgProductCdlDomain) {
            return null;
        }
        if (null == pgProductCdl) {
            pgProductCdl = new PgProductCdl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgProductCdl, (Object)pgProductCdlDomain);
            return pgProductCdl;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductCdlServiceImpl.makeProductCdl", (Throwable)e);
            return null;
        }
    }

    private PgProductCdlReDomain makePgProductCdlReDomain(PgProductCdl pgProductCdl) {
        if (null == pgProductCdl) {
            return null;
        }
        PgProductCdlReDomain pgProductCdlReDomain = new PgProductCdlReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgProductCdlReDomain, (Object)pgProductCdl);
            return pgProductCdlReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductCdlServiceImpl.makePgProductCdlReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgProductCdl> queryProductCdlModelPage(Map<String, Object> parammap) {
        try {
            return this.pgProductCdlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductCdlServiceImpl.queryProductCdlModel", (Throwable)e);
            return null;
        }
    }

    private int countProductCdl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgProductCdlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductCdlServiceImpl.countProductCdl", (Throwable)e);
        }
        return i;
    }

    private PgProductCdl createPgProductCdl(PgProductCdlDomain pgProductCdlDomain) {
        String msg = this.checkProductCdl(pgProductCdlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.saveProductCdl.checkProductCdl", msg);
        }
        PgProductCdl pgProductCdl = this.makeProductCdl(pgProductCdlDomain, null);
        this.setProductCdlDefault(pgProductCdl);
        return pgProductCdl;
    }

    @Override
    public String saveProductCdl(PgProductCdlDomain pgProductCdlDomain) throws ApiException {
        PgProductCdl pgProductCdl = this.createPgProductCdl(pgProductCdlDomain);
        this.saveProductCdlModel(pgProductCdl);
        return pgProductCdl.getCode();
    }

    @Override
    public String saveProductCdlBatch(List<PgProductCdlDomain> pgProductCdlDomainList) throws ApiException {
        if (null == pgProductCdlDomainList || pgProductCdlDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgProductCdl> pgProductCdlList = new ArrayList<PgProductCdl>();
        String code = "";
        for (PgProductCdlDomain pgProductCdlDomain : pgProductCdlDomainList) {
            PgProductCdl pgProductCdl = this.createPgProductCdl(pgProductCdlDomain);
            code = pgProductCdl.getCode();
            pgProductCdlList.add(pgProductCdl);
        }
        this.saveProductCdlBatchModel(pgProductCdlList);
        return code;
    }

    @Override
    public void updateProductCdlState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateProductCdlModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateProductCdlStateByCode(String tenantCode, String code, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateProductCdlModelByCode(tenantCode, code, dataState, oldDataState, map);
    }

    @Override
    public void updateProductCdl(PgProductCdlDomain pgProductCdlDomain) throws ApiException {
        String msg = this.checkProductCdl(pgProductCdlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.updateProductCdl.checkProductCdl", msg);
        }
        PgProductCdl oldPgProductCdl = this.getProductCdlModelById(pgProductCdlDomain.getId());
        if (null == oldPgProductCdl) {
            throw new ApiException("pg.PICK.PgProductCdlServiceImpl.updateProductCdl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgProductCdl pgProductCdl = this.makeProductCdl(pgProductCdlDomain, oldPgProductCdl);
        this.setProductCdlUpdataDefault(pgProductCdl);
        this.updateProductCdlModel(pgProductCdl);
    }

    @Override
    public PgProductCdl getProductCdl(Integer id) {
        if (null == id) {
            return null;
        }
        return this.getProductCdlModelById(id);
    }

    @Override
    public void deleteProductCdl(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteProductCdlModel(id);
    }

    @Override
    public QueryResult<PgProductCdl> queryProductCdlPage(Map<String, Object> map) {
        List<PgProductCdl> pgProductCdlList = this.queryProductCdlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProductCdl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgProductCdlList);
        return queryResult;
    }

    @Override
    public PgProductCdl getProductCdlByCode(String tenantCode, String code) throws ApiException {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("code", code);
        return this.getProductCdlModelByCode(map);
    }

    @Override
    public void deleteProductCdlByCode(String tenantCode, String code) throws ApiException {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("code", code);
        this.delProductCdlModelByCode(map);
    }

    @Override
    public void updatePgLabelByCdl() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", PgProductCdlServiceImpl.getCode());
        List<PgProductCdl> productCdlList = this.queryProductCdlModelPage(map);
        this.logger.info("pg.PICK.PgProductCdlServiceImpl.updatePgLabelByCdl", (Object)("productCdlList.size:" + productCdlList.size()));
        List<PgProductPriceCdl> pgProductPriceCdlList = this.pgProductPriceCdlService.queryProductPriceCdlModelPage(map);
        this.logger.info("pg.PICK.PgProductCdlServiceImpl.updatePgLabelByCdl", (Object)("pgProductPriceCdlList.size:" + pgProductPriceCdlList.size()));
        ArrayList pgProductCdls = new ArrayList();
        Map<String, List<PgProductCdl>> productListMap = productCdlList.parallelStream().collect(Collectors.groupingBy(p -> p.getSellBarcode()));
        Map<String, PgProductPriceCdl> compareCdlPriceListMap = pgProductPriceCdlList.stream().collect(Collectors.toMap(PgProductPriceCdl::getFpcCode, PgProductPriceCdl2 -> PgProductPriceCdl2));
        ArrayList<PgProductPriceCdl> filterPgProductPriceCdlList = new ArrayList<PgProductPriceCdl>(compareCdlPriceListMap.values());
        productListMap.forEach((k, v) -> {
            List cdlProductList = v.stream().filter(p -> compareCdlPriceListMap.containsKey(p.getFpcCode())).collect(Collectors.toList());
            Map<String, PgProductCdl> getProductCdlMap = cdlProductList.stream().collect(Collectors.toMap(PgProductCdl::getFpcCode, PgProductCdl2 -> PgProductCdl2));
            List comparePriceList = filterPgProductPriceCdlList.stream().filter(ppc -> getProductCdlMap.containsKey(ppc.getFpcCode())).collect(Collectors.toList());
            Map compareCdlPriceMap = comparePriceList.parallelStream().collect(Collectors.toMap(PgProductPriceCdl::getItemBarcode, Function.identity(), (c1, c2) -> PgProductCdlServiceImpl.toBigDecimal(c1.getListPriceForSalesUnitVat200()).compareTo(PgProductCdlServiceImpl.toBigDecimal(c2.getListPriceForSalesUnitVat200())) > 0 ? c1 : (Integer.valueOf(c1.getFpcCode()) > Integer.valueOf(c2.getFpcCode()) ? c1 : c2)));
            compareCdlPriceMap.forEach((pk, pv) -> {
                PgProductCdl pgProductCdl = (PgProductCdl)getProductCdlMap.get(pv.getFpcCode());
                if (null != pgProductCdl) {
                    pgProductCdls.add(pgProductCdl);
                }
            });
        });
        List collectPriceFpcCode = pgProductPriceCdlList.stream().map(p -> p.getFpcCode()).collect(Collectors.toList());
        List collectProduct = pgProductCdls.stream().filter(p -> collectPriceFpcCode.contains(p.getFpcCode())).collect(Collectors.toList());
        Map<String, PgProductPriceCdl> productPriceCdlMap = pgProductPriceCdlList.stream().collect(Collectors.toMap(PgProductPriceCdl::getFpcCode, PgProductPriceCdl2 -> PgProductPriceCdl2));
        Map<String, PgProductCdl> productCdlMap = collectProduct.stream().collect(Collectors.toMap(PgProductCdl::getFpcCode, PgProductCdl2 -> PgProductCdl2));
        List<PgLabel> pgLabelList = this.pgLabelService.queryLabelModelPage(null);
        this.logger.info("pg.PICK.PgProductCdlServiceImpl.updatePgLabelByCdl", (Object)("pgLabelList.size:" + pgLabelList.size()));
        Map<String, String> classTreeMap = pgLabelList.parallelStream().collect(Collectors.toMap(PgLabel::getClasstreeName, PgLabel::getClasstreeCode, (item1, item2) -> item1));
        Map<String, String> brandMap = pgLabelList.parallelStream().collect(Collectors.toMap(PgLabel::getBrandName, PgLabel::getBrandCode, (item1, item2) -> item1));
        List collectProductFpcCode = collectProduct.stream().map(p -> p.getFpcCode()).collect(Collectors.toList());
        List collectLabelSkuCode = pgLabelList.stream().map(p -> p.getSkuCode()).collect(Collectors.toList());
        HashMap rsClasstreeMap = new HashMap();
        HashMap rsBrandList = new HashMap();
        HashMap brandClassTree = new HashMap();
        List collectDiff = collectProduct.stream().filter(p -> !collectLabelSkuCode.contains(p.getFpcCode()) && (!StringUtils.isNotBlank((String)p.getBrandCn()) || !p.getBrandCn().equals("\u6c99\u5ba3"))).map(p -> {
            String classTreeCode;
            if ("\u7535\u52a8\u7259\u5237".equals(p.getProductFormCn()) && p.getProductNameCn() != null && p.getProductNameCn().indexOf("\u5237\u5934") >= 0) {
                p.setProductFormCn("\u5237\u5934");
            }
            if ("\u5468\u8fb9".equals(p.getProductFormCn()) && p.getProductNameCn() != null && p.getProductNameCn().indexOf("\u6f31\u53e3\u6c34") >= 0) {
                p.setProductFormCn("\u6f31\u53e3\u6c34");
            }
            if ("\u5468\u8fb9".equals(p.getProductFormCn()) && p.getProductNameCn() != null && p.getProductNameCn().indexOf("\u7259\u7ebf") >= 0) {
                p.setProductFormCn("\u7259\u7ebf");
            }
            if ((classTreeCode = (String)classTreeMap.get(p.getProductFormCn())) != null) {
                p.setProductFormCode(classTreeCode);
            } else {
                rsClasstreeMap.put(p.getProductFormCode(), this.setClassTree((PgProductCdl)p));
            }
            String brandCode = (String)brandMap.get(p.getBrandCn());
            if (brandCode != null) {
                p.setBrandCode(brandCode);
            } else {
                rsBrandList.put(p.getBrandCode(), this.setBrand((PgProductCdl)p, brandClassTree));
            }
            return p;
        }).collect(Collectors.toList());
        this.rsClasstreeSaveBatch(rsClasstreeMap.values());
        this.logger.info("pg.PICK.PgProductCdlServiceImpl.updatePgLabelByCdl", (Object)("rsClasstreeList.size:" + rsClasstreeMap.values().size()));
        List<RsBrandDomain> collectRsBrand = rsBrandList.values().stream().map(p -> {
            List strings = (List)brandClassTree.get(p.getBrandCode());
            p.setMemberName(String.join((CharSequence)",", strings));
            return p;
        }).collect(Collectors.toList());
        this.rsBrandSaveBatch(collectRsBrand);
        this.logger.info("pg.PICK.PgProductCdlServiceImpl.updatePgLabelByCdl", (Object)("rsBrandList.size:" + rsClasstreeMap.values().size()));
        List<PgLabel> collectLabelAdd = collectDiff.stream().map(p -> this.toPgLabel(null, (PgProductCdl)p, (PgProductPriceCdl)productPriceCdlMap.get(p.getFpcCode()))).collect(Collectors.toList());
        this.pgLabelService.saveLabelBatchModel(collectLabelAdd);
        this.logger.info("pg.PICK.PgProductCdlServiceImpl.updatePgLabelByCdl", (Object)("collectLabelAdd.size:" + collectLabelAdd.size()));
        List<PgLabel> collectUpd = pgLabelList.stream().filter(p -> collectProductFpcCode.contains(p.getSkuCode())).map(p -> this.toPgLabel((PgLabel)p, (PgProductCdl)productCdlMap.get(p.getSkuCode()), (PgProductPriceCdl)productPriceCdlMap.get(p.getSkuCode()))).collect(Collectors.toList());
        this.pgLabelService.updateLabelBatchForPrice(collectUpd);
        this.logger.info("pg.PICK.PgProductCdlServiceImpl.updatePgLabelByCdl", (Object)("collectUpd.size:" + collectUpd.size()));
    }

    private void rsBrandSaveBatch(List<RsBrandDomain> collectRsBrand) {
        for (RsBrandDomain brandDomain : collectRsBrand) {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)brandDomain));
                this.internalInvoke("rs.resource.sendSaveBrand", params);
            }
            catch (Exception e) {
                this.logger.error("pg.PICK.PgProductCdlServiceImpl.rsBrandSaveBatch", (Throwable)e);
            }
        }
    }

    private void rsClasstreeSaveBatch(Collection<RsClasstreeDomain> values) {
        for (RsClasstreeDomain classtreeDomain : values) {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)classtreeDomain));
                this.internalInvoke("rs.resource.sendSaveClasstree", params);
            }
            catch (Exception e) {
                this.logger.error("pg.PICK.PgProductCdlServiceImpl.rsClasstreeSaveBatch", (Throwable)e);
            }
        }
    }

    private RsBrandDomain setBrand(PgProductCdl p, Map<String, List<String>> brandClassTree) {
        String brandCode = p.getBrandCode();
        String productFormCn = p.getProductFormCn();
        List<String> stringList = brandClassTree.get(brandCode);
        if (stringList == null) {
            stringList = new ArrayList<String>();
        }
        if (!stringList.contains(productFormCn)) {
            stringList.add(productFormCn);
        }
        brandClassTree.put(p.getBrandCode(), stringList);
        RsBrandDomain brand = new RsBrandDomain();
        brand.setChannelName("B2C\u6e20\u9053");
        brand.setChannelCode("B2Cchannel");
        brand.setMemberCode("20000210397082");
        brand.setMemberName(String.join((CharSequence)",", stringList));
        brand.setBrandCode(p.getBrandCode());
        brand.setBrandName(p.getBrandCn());
        brand.setBrandLogo("https://qjstatic.oss-cn-shanghai.aliyuncs.com/error.jpg");
        brand.setTenantCode("2022011000000021");
        return brand;
    }

    private RsClasstreeDomain setClassTree(PgProductCdl p) {
        RsClasstreeDomain classTree = new RsClasstreeDomain();
        classTree.setClasstreeCode(p.getProductFormCode());
        classTree.setClasstreeName(p.getProductFormCn());
        classTree.setClasstreeParentcode("-1");
        classTree.setClasstreeType("0");
        classTree.setClasstreeLast("1");
        classTree.setMemberCode("20000210397082");
        classTree.setMemberName("\u5e73\u53f0");
        classTree.setMemo(this.toMemo(p.getCategoryCn()));
        classTree.setTenantCode("2022011000000021");
        return classTree;
    }

    private PgLabel toPgLabel(PgLabel pgLabel, PgProductCdl p, PgProductPriceCdl pgProductPriceCdl) {
        PgLabel goods = pgLabel;
        if (pgLabel == null) {
            goods = new PgLabel();
            goods.setClasstreeCode(p.getProductFormCode());
            goods.setBrandCode(p.getBrandCode());
            goods.setLabelCode(p.getItemBarcode());
            goods.setGoodsName(p.getProductNameCn());
            goods.setSkuCode(p.getFpcCode());
            goods.setClasstreeName(p.getProductFormCn());
            goods.setBrandName(p.getBrandCn());
            goods.setLabelSize(PgProductCdlServiceImpl.toBigDecimal(p.getCnSizeTotal()));
            goods.setLabelSizeUnit(p.getCnSizeUnit());
            goods.setLabelSizeMl(PgProductCdlServiceImpl.toSizeMl(goods.getLabelSize(), goods.getLabelSizeUnit()));
            goods.setLabelPspnf("P/SP/NF".equals(p.getFlag()) ? "Y" : "N");
            goods.setProductVariant(p.getFullVariantCn());
            goods.setSellBarcode(p.getSellBarcode());
            goods.setMemo(this.toMemo(p.getCategoryCn()));
            goods.setLabelGflabel(BigDecimal.ZERO);
            goods.setLabelTtlabel(BigDecimal.ZERO);
            goods.setTenantCode("2022011000000021");
            goods.setDataState(2);
            goods.setGmtCreate(new Date());
        }
        goods.setLabelLength(PgProductCdlServiceImpl.toBigDecimal(p.getLength(), p.getDimUnit()));
        goods.setLabelWide(PgProductCdlServiceImpl.toBigDecimal(p.getWidth(), p.getDimUnit()));
        goods.setLabelHigh(PgProductCdlServiceImpl.toBigDecimal(p.getHeight(), p.getDimUnit()));
        goods.setGoodsSpec(goods.getLabelLength() + "cm*" + goods.getLabelWide() + "cm*" + goods.getLabelHigh() + "cm");
        goods.setPricesetNprice(PgProductCdlServiceImpl.toBigDecimal(pgProductPriceCdl.getSrp()));
        goods.setLabelPrefprice(PgProductCdlServiceImpl.toBigDecimal(pgProductPriceCdl.getTopDmSppTax()));
        goods.setLabelInsideprice(PgProductCdlServiceImpl.toBigDecimal(pgProductPriceCdl.getListPriceForSalesUnitVat200()));
        goods.setGmtModified(new Date());
        goods.setLabelNature(PgProductCdlServiceImpl.toNature(pgProductPriceCdl.getProductNature1()));
        return goods;
    }

    private String toMemo(String categoryCn) {
        HashMap<String, Integer> memoMap = new HashMap<String, Integer>(12);
        memoMap.put("\u6d17\u53d1\u62a4\u53d1", 1);
        memoMap.put("\u4e2a\u4eba\u6e05\u6d01", 2);
        memoMap.put("\u7ec7\u7269\u62a4\u7406", 3);
        memoMap.put("\u53e3\u8154\u62a4\u7406", 4);
        memoMap.put("\u62a4\u80a4\u54c1\u7c7b", 5);
        memoMap.put("\u65b0\u54c1\u724c\u62a4\u80a4\u54c1\u7c7b", 6);
        memoMap.put("\u9ad8\u7aef\u62a4\u80a4", 7);
        memoMap.put("\u5243\u987b\u62a4\u7406", 8);
        memoMap.put("\u5987\u5973\u536b\u751f", 9);
        memoMap.put("\u5a74\u513f\u62a4\u7406", 10);
        memoMap.put("\u5bb6\u5c45\u62a4\u7406", 11);
        memoMap.put("\u5bb6\u5ead\u62a4\u7406", 12);
        return memoMap.get(categoryCn) + "-" + categoryCn;
    }

    private static BigDecimal toSizeMl(BigDecimal labelSize, String labelSizeUnit) {
        HashMap<String, Integer> unitMap = new HashMap<String, Integer>(8);
        unitMap.put("KG", 1000);
        unitMap.put("M", 1000);
        unitMap.put("G", 1);
        unitMap.put("ML", 1);
        Integer a = (Integer)unitMap.get(labelSizeUnit);
        return labelSize.multiply(new BigDecimal(a == null ? 0 : a));
    }

    private static String toNature(String itemNature) {
        if ("Normal Pack".equals(itemNature)) {
            return itemNature + "\u6b63\u5e38\u88c5";
        }
        if ("Promotion Pack".equals(itemNature)) {
            return itemNature + "\u4fc3\u9500\u88c5";
        }
        return null;
    }

    private static BigDecimal toBigDecimal(String str, String unit) {
        if ("MM".equals(unit) || "mm".equals(unit)) {
            return PgProductCdlServiceImpl.toBigDecimal(str).divide(new BigDecimal(10), 2, 4);
        }
        return PgProductCdlServiceImpl.toBigDecimal(str);
    }

    private static BigDecimal toBigDecimal(String str) {
        return new BigDecimal(NumberUtil.isNumber((CharSequence)str) ? str : "0");
    }

    private static String getCode() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        return format.format(date);
    }
}

