/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgGpacksizeMapper;
import com.yqbsoft.laser.service.pg.domain.PgGpacksizeDomain;
import com.yqbsoft.laser.service.pg.domain.PgGpacksizeReDomain;
import com.yqbsoft.laser.service.pg.model.PgGpacksize;
import com.yqbsoft.laser.service.pg.service.PgGpacksizeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgGpacksizeServiceImpl
extends BaseServiceImpl
implements PgGpacksizeService {
    private static final String SYS_CODE = "pg.PICK.PgGpacksizeServiceImpl";
    private PgGpacksizeMapper pgGpacksizeMapper;

    public void setPgGpacksizeMapper(PgGpacksizeMapper pgGpacksizeMapper) {
        this.pgGpacksizeMapper = pgGpacksizeMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgGpacksizeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGpacksizeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGpacksize(PgGpacksizeDomain pgGpacksizeDomain) {
        if (null == pgGpacksizeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgGpacksizeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGpacksizeDefault(PgGpacksize pgGpacksize) {
        if (null == pgGpacksize) {
            return;
        }
        if (null == pgGpacksize.getDataState()) {
            pgGpacksize.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgGpacksize.getGmtCreate()) {
            pgGpacksize.setGmtCreate(date);
        }
        pgGpacksize.setGmtModified(date);
        if (StringUtils.isBlank((String)pgGpacksize.getGpacksizeCode())) {
            pgGpacksize.setGpacksizeCode(this.getNo(null, "PgGpacksize", "pgGpacksize", pgGpacksize.getTenantCode()));
        }
    }

    private int getGpacksizeMaxCode() {
        int code = 0;
        try {
            return this.pgGpacksizeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGpacksizeServiceImpl.getGpacksizeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGpacksizeUpdataDefault(PgGpacksize pgGpacksize) {
        if (null == pgGpacksize) {
            return;
        }
        pgGpacksize.setGmtModified(this.getSysDate());
    }

    private void saveGpacksizeModel(PgGpacksize pgGpacksize) throws ApiException {
        if (null == pgGpacksize) {
            return;
        }
        try {
            this.pgGpacksizeMapper.insert(pgGpacksize);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.saveGpacksizeModel.ex", (Throwable)e);
        }
    }

    private void saveGpacksizeBatchModel(List<PgGpacksize> pgGpacksizeList) throws ApiException {
        if (null == pgGpacksizeList || pgGpacksizeList.isEmpty()) {
            return;
        }
        try {
            this.pgGpacksizeMapper.insertBatch(pgGpacksizeList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.saveGpacksizeBatchModel.ex", (Throwable)e);
        }
    }

    private PgGpacksize getGpacksizeModelById(Integer gpacksizeId) {
        if (null == gpacksizeId) {
            return null;
        }
        try {
            return this.pgGpacksizeMapper.selectByPrimaryKey(gpacksizeId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGpacksizeServiceImpl.getGpacksizeModelById", (Throwable)e);
            return null;
        }
    }

    private PgGpacksize getGpacksizeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgGpacksizeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGpacksizeServiceImpl.getGpacksizeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGpacksizeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGpacksizeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.delGpacksizeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.delGpacksizeModelByCode.num");
        }
    }

    private void deleteGpacksizeModel(Integer gpacksizeId) throws ApiException {
        if (null == gpacksizeId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGpacksizeMapper.deleteByPrimaryKey(gpacksizeId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.deleteGpacksizeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.deleteGpacksizeModel.num");
        }
    }

    private void updateGpacksizeModel(PgGpacksize pgGpacksize) throws ApiException {
        if (null == pgGpacksize) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGpacksizeMapper.updateByPrimaryKey(pgGpacksize);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.updateGpacksizeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.updateGpacksizeModel.num");
        }
    }

    private void updateStateGpacksizeModel(Integer gpacksizeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == gpacksizeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gpacksizeId", gpacksizeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGpacksizeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.updateStateGpacksizeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.updateStateGpacksizeModel.null");
        }
    }

    private void updateStateGpacksizeModelByCode(String tenantCode, String gpacksizeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)gpacksizeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("gpacksizeCode", gpacksizeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGpacksizeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.updateStateGpacksizeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.updateStateGpacksizeModelByCode.null");
        }
    }

    private PgGpacksize makeGpacksize(PgGpacksizeDomain pgGpacksizeDomain, PgGpacksize pgGpacksize) {
        if (null == pgGpacksizeDomain) {
            return null;
        }
        if (null == pgGpacksize) {
            pgGpacksize = new PgGpacksize();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgGpacksize, (Object)pgGpacksizeDomain);
            return pgGpacksize;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGpacksizeServiceImpl.makeGpacksize", (Throwable)e);
            return null;
        }
    }

    private PgGpacksizeReDomain makePgGpacksizeReDomain(PgGpacksize pgGpacksize) {
        if (null == pgGpacksize) {
            return null;
        }
        PgGpacksizeReDomain pgGpacksizeReDomain = new PgGpacksizeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgGpacksizeReDomain, (Object)pgGpacksize);
            return pgGpacksizeReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGpacksizeServiceImpl.makePgGpacksizeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgGpacksize> queryGpacksizeModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGpacksizeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGpacksizeServiceImpl.queryGpacksizeModel", (Throwable)e);
            return null;
        }
    }

    private int countGpacksize(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgGpacksizeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGpacksizeServiceImpl.countGpacksize", (Throwable)e);
        }
        return i;
    }

    private PgGpacksize createPgGpacksize(PgGpacksizeDomain pgGpacksizeDomain) {
        String msg = this.checkGpacksize(pgGpacksizeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.saveGpacksize.checkGpacksize", msg);
        }
        PgGpacksize pgGpacksize = this.makeGpacksize(pgGpacksizeDomain, null);
        this.setGpacksizeDefault(pgGpacksize);
        return pgGpacksize;
    }

    @Override
    public String saveGpacksize(PgGpacksizeDomain pgGpacksizeDomain) throws ApiException {
        PgGpacksize pgGpacksize = this.createPgGpacksize(pgGpacksizeDomain);
        this.saveGpacksizeModel(pgGpacksize);
        return pgGpacksize.getGpacksizeCode();
    }

    @Override
    public String saveGpacksizeBatch(List<PgGpacksizeDomain> pgGpacksizeDomainList) throws ApiException {
        if (null == pgGpacksizeDomainList || pgGpacksizeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgGpacksize> pgGpacksizeList = new ArrayList<PgGpacksize>();
        String code = "";
        for (PgGpacksizeDomain pgGpacksizeDomain : pgGpacksizeDomainList) {
            PgGpacksize pgGpacksize = this.createPgGpacksize(pgGpacksizeDomain);
            code = pgGpacksize.getGpacksizeCode();
            pgGpacksizeList.add(pgGpacksize);
        }
        this.saveGpacksizeBatchModel(pgGpacksizeList);
        return code;
    }

    @Override
    public void updateGpacksizeState(Integer gpacksizeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == gpacksizeId) {
            return;
        }
        this.updateStateGpacksizeModel(gpacksizeId, dataState, oldDataState, map);
    }

    @Override
    public void updateGpacksizeStateByCode(String tenantCode, String gpacksizeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)gpacksizeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGpacksizeModelByCode(tenantCode, gpacksizeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGpacksize(PgGpacksizeDomain pgGpacksizeDomain) throws ApiException {
        String msg = this.checkGpacksize(pgGpacksizeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.updateGpacksize.checkGpacksize", msg);
        }
        PgGpacksize oldPgGpacksize = this.getGpacksizeModelById(pgGpacksizeDomain.getGpacksizeId());
        if (null == oldPgGpacksize) {
            throw new ApiException("pg.PICK.PgGpacksizeServiceImpl.updateGpacksize.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgGpacksize pgGpacksize = this.makeGpacksize(pgGpacksizeDomain, oldPgGpacksize);
        this.setGpacksizeUpdataDefault(pgGpacksize);
        this.updateGpacksizeModel(pgGpacksize);
    }

    @Override
    public PgGpacksize getGpacksize(Integer gpacksizeId) {
        if (null == gpacksizeId) {
            return null;
        }
        return this.getGpacksizeModelById(gpacksizeId);
    }

    @Override
    public void deleteGpacksize(Integer gpacksizeId) throws ApiException {
        if (null == gpacksizeId) {
            return;
        }
        this.deleteGpacksizeModel(gpacksizeId);
    }

    @Override
    public QueryResult<PgGpacksize> queryGpacksizePage(Map<String, Object> map) {
        List<PgGpacksize> pgGpacksizeList = this.queryGpacksizeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGpacksize(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgGpacksizeList);
        return queryResult;
    }

    @Override
    public PgGpacksize getGpacksizeByCode(String tenantCode, String gpacksizeCode) throws ApiException {
        if (StringUtils.isBlank((String)gpacksizeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("gpacksizeCode", gpacksizeCode);
        return this.getGpacksizeModelByCode(map);
    }

    @Override
    public void deleteGpacksizeByCode(String tenantCode, String gpacksizeCode) throws ApiException {
        if (StringUtils.isBlank((String)gpacksizeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("gpacksizeCode", gpacksizeCode);
        this.delGpacksizeModelByCode(map);
    }
}

