/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPtaskMapper;
import com.yqbsoft.laser.service.pm.domain.PmChannelsendDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionReDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskConfigDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskDiscountDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmPtask;
import com.yqbsoft.laser.service.pm.model.PmPtaskConfig;
import com.yqbsoft.laser.service.pm.service.PmChannelsendBaseService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmPtaskConfigService;
import com.yqbsoft.laser.service.pm.service.PmPtaskDiscountService;
import com.yqbsoft.laser.service.pm.service.PmPtaskService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPtaskServiceImpl
extends BaseServiceImpl
implements PmPtaskService {
    private static final String SYS_CODE = "pm.PmPtaskServiceImpl";
    private PmPtaskMapper pmPtaskMapper;
    PmPtaskConfigService pmPtaskConfigService;
    PmPtaskDiscountService pmPtaskDiscountService;
    PmChannelsendBaseService pmChannelsendBaseService;
    PmPromotionService pmPromotionService;

    public void setPmPtaskMapper(PmPtaskMapper pmPtaskMapper) {
        this.pmPtaskMapper = pmPtaskMapper;
    }

    public void setPmPromotionService(PmPromotionService pmPromotionService) {
        this.pmPromotionService = pmPromotionService;
    }

    public void setPmChannelsendBaseService(PmChannelsendBaseService pmChannelsendBaseService) {
        this.pmChannelsendBaseService = pmChannelsendBaseService;
    }

    public void setPmPtaskConfigService(PmPtaskConfigService pmPtaskConfigService) {
        this.pmPtaskConfigService = pmPtaskConfigService;
    }

    public void setPmPtaskDiscountService(PmPtaskDiscountService pmPtaskDiscountService) {
        this.pmPtaskDiscountService = pmPtaskDiscountService;
    }

    private Date getSysDate() {
        try {
            return this.pmPtaskMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtask(PmPtaskDomain pmPtaskDomain) {
        if (null == pmPtaskDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPtaskDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtaskDefault(PmPtask pmPtask) {
        if (null == pmPtask) {
            return;
        }
        if (null == pmPtask.getDataState()) {
            pmPtask.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPtask.getGmtCreate()) {
            pmPtask.setGmtCreate(date);
        }
        pmPtask.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPtask.getPtaskCode())) {
            pmPtask.setPtaskCode(this.getNo(null, "PmPtask", "pmPtask", pmPtask.getTenantCode()));
        }
    }

    private int getPtaskMaxCode() {
        int code = 0;
        try {
            return this.pmPtaskMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskServiceImpl.getPtaskMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtaskUpdataDefault(PmPtask pmPtask) {
        if (null == pmPtask) {
            return;
        }
        pmPtask.setGmtModified(this.getSysDate());
    }

    private void savePtaskModel(PmPtask pmPtask) throws ApiException {
        if (null == pmPtask) {
            return;
        }
        try {
            this.pmPtaskMapper.insert(pmPtask);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskServiceImpl.savePtaskModel.ex", (Throwable)e);
        }
    }

    private void savePtaskBatchModel(List<PmPtask> pmPtaskList) throws ApiException {
        if (null == pmPtaskList || pmPtaskList.isEmpty()) {
            return;
        }
        try {
            this.pmPtaskMapper.insertBatch(pmPtaskList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskServiceImpl.savePtaskBatchModel.ex", (Throwable)e);
        }
    }

    private PmPtask getPtaskModelById(Integer ptaskId) {
        if (null == ptaskId) {
            return null;
        }
        try {
            return this.pmPtaskMapper.selectByPrimaryKey(ptaskId);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskServiceImpl.getPtaskModelById", (Throwable)e);
            return null;
        }
    }

    private PmPtask getPtaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPtaskMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskServiceImpl.getPtaskModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskServiceImpl.delPtaskModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtaskServiceImpl.delPtaskModelByCode.num");
        }
    }

    private void deletePtaskModel(Integer ptaskId) throws ApiException {
        if (null == ptaskId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.deleteByPrimaryKey(ptaskId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskServiceImpl.deletePtaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtaskServiceImpl.deletePtaskModel.num");
        }
    }

    private void updatePtaskModel(PmPtask pmPtask) throws ApiException {
        if (null == pmPtask) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.updateByPrimaryKey(pmPtask);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskServiceImpl.updatePtaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtaskServiceImpl.updatePtaskModel.num");
        }
    }

    private void updateStatePtaskModel(Integer ptaskId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ptaskId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptaskId", ptaskId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskServiceImpl.updateStatePtaskModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPtaskServiceImpl.updateStatePtaskModel.null");
        }
    }

    private void updateStatePtaskModelByCode(String tenantCode, String ptaskCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskCode", ptaskCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskServiceImpl.updateStatePtaskModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPtaskServiceImpl.updateStatePtaskModelByCode.null");
        }
    }

    private PmPtask makePtask(PmPtaskDomain pmPtaskDomain, PmPtask pmPtask) {
        if (null == pmPtaskDomain) {
            return null;
        }
        if (null == pmPtask) {
            pmPtask = new PmPtask();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPtask, (Object)pmPtaskDomain);
            return pmPtask;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskServiceImpl.makePtask", (Throwable)e);
            return null;
        }
    }

    private PmPtaskReDomain makePmPtaskReDomain(PmPtask pmPtask) {
        if (null == pmPtask) {
            return null;
        }
        PmPtaskReDomain pmPtaskReDomain = new PmPtaskReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskReDomain, (Object)pmPtask);
            QueryResult<PmPtaskConfig> qlist = this.pmPtaskConfigService.queryPtaskConfigPage(this.getQueryMapParam("ptaskCode,tenantCode", new Object[]{pmPtask.getPtaskCode(), pmPtask.getTenantCode()}));
            pmPtaskReDomain.setPmPtaskConfigDomainList(this.makeConfigDomain(qlist.getList()));
            return pmPtaskReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskServiceImpl.makePmPtaskReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPtaskConfigDomain> makeConfigDomain(List<PmPtaskConfig> pmPtaskConfigList) {
        if (ListUtil.isEmpty(pmPtaskConfigList)) {
            return null;
        }
        ArrayList<PmPtaskConfigDomain> dlist = new ArrayList<PmPtaskConfigDomain>();
        for (PmPtaskConfig pmPtaskConfig : pmPtaskConfigList) {
            dlist.add(this.makePmPtaskConfigDomain(pmPtaskConfig));
        }
        return dlist;
    }

    private PmPtaskConfigDomain makePmPtaskConfigDomain(PmPtaskConfig pmPtaskConfig) {
        if (null == pmPtaskConfig) {
            return null;
        }
        PmPtaskConfigDomain pmPtaskConfigDomain = new PmPtaskConfigDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskConfigDomain, (Object)pmPtaskConfig);
            return pmPtaskConfigDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskServiceImpl.makePmPtaskConfigDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPtask> queryPtaskModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPtaskMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskServiceImpl.queryPtaskModel", (Throwable)e);
            return null;
        }
    }

    private int countPtask(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPtaskMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskServiceImpl.countPtask", (Throwable)e);
        }
        return i;
    }

    private PmPtask createPmPtask(PmPtaskDomain pmPtaskDomain) {
        String msg = this.checkPtask(pmPtaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPtaskServiceImpl.savePtask.checkPtask", msg);
        }
        PmPtask pmPtask = this.makePtask(pmPtaskDomain, null);
        this.setPtaskDefault(pmPtask);
        return pmPtask;
    }

    @Override
    public String savePtask(PmPtaskDomain pmPtaskDomain) throws ApiException {
        PmPtask pmPtask = this.createPmPtask(pmPtaskDomain);
        this.savePtaskModel(pmPtask);
        if (ListUtil.isNotEmpty(pmPtaskDomain.getPmPtaskConfigDomainList())) {
            this.savePtaskConfig(pmPtaskDomain.getPmPtaskConfigDomainList(), pmPtask);
        }
        if (ListUtil.isNotEmpty(pmPtaskDomain.getPmPtaskDiscountDomainList())) {
            this.savePtaskDiscount(pmPtaskDomain.getPmPtaskDiscountDomainList(), pmPtask);
        }
        return pmPtask.getPtaskCode();
    }

    private void savePtaskConfig(List<PmPtaskConfigDomain> pmPtaskConfigDomainList, PmPtask pmPtask) {
        if (ListUtil.isEmpty(pmPtaskConfigDomainList) || null == pmPtask) {
            return;
        }
        for (PmPtaskConfigDomain pmPtaskConfigDomain : pmPtaskConfigDomainList) {
            pmPtaskConfigDomain.setAppmanageIcode(pmPtask.getAppmanageIcode());
            pmPtaskConfigDomain.setCouponBatchCode(pmPtask.getCouponBatchCode());
            pmPtaskConfigDomain.setPbCode(pmPtask.getPbCode());
            pmPtaskConfigDomain.setPromotionCode(pmPtask.getPromotionCode());
            pmPtaskConfigDomain.setPromotionName(pmPtask.getPromotionName());
            pmPtaskConfigDomain.setPromotionOrgin(pmPtask.getPromotionOrgin());
            pmPtaskConfigDomain.setPromotionType(pmPtask.getPromotionType());
            pmPtaskConfigDomain.setPtaskCode(pmPtask.getPtaskCode());
        }
        this.pmPtaskConfigService.savePtaskConfigBatch(pmPtaskConfigDomainList);
    }

    private void savePtaskDiscount(List<PmPtaskDiscountDomain> pmPtaskDiscountDomainList, PmPtask pmPtask) {
        if (ListUtil.isEmpty(pmPtaskDiscountDomainList) || null == pmPtask) {
            return;
        }
        for (PmPtaskDiscountDomain pmPtaskDiscountDomain : pmPtaskDiscountDomainList) {
            pmPtaskDiscountDomain.setAppmanageIcode(pmPtask.getAppmanageIcode());
            pmPtaskDiscountDomain.setPromotionCode(pmPtask.getPromotionCode());
            pmPtaskDiscountDomain.setPtaskCode(pmPtask.getPtaskCode());
        }
        this.pmPtaskDiscountService.savePtaskDiscountBatch(pmPtaskDiscountDomainList);
    }

    @Override
    public String savePtaskBatch(List<PmPtaskDomain> pmPtaskDomainList) throws ApiException {
        if (null == pmPtaskDomainList || pmPtaskDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (PmPtaskDomain pmPtaskDomain : pmPtaskDomainList) {
            code = this.savePtask(pmPtaskDomain);
        }
        return code;
    }

    @Override
    public void updatePtaskState(Integer ptaskId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ptaskId) {
            return;
        }
        this.updateStatePtaskModel(ptaskId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtaskStateByCode(String tenantCode, String ptaskCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtaskModelByCode(tenantCode, ptaskCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtask(PmPtaskDomain pmPtaskDomain) throws ApiException {
        String msg = this.checkPtask(pmPtaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPtaskServiceImpl.updatePtask.checkPtask", msg);
        }
        PmPtask oldPmPtask = this.getPtaskModelById(pmPtaskDomain.getPtaskId());
        if (null == oldPmPtask) {
            throw new ApiException("pm.PmPtaskServiceImpl.updatePtask.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPtask pmPtask = this.makePtask(pmPtaskDomain, oldPmPtask);
        this.setPtaskUpdataDefault(pmPtask);
        this.updatePtaskModel(pmPtask);
    }

    @Override
    public PmPtask getPtask(Integer ptaskId) {
        if (null == ptaskId) {
            return null;
        }
        return this.getPtaskModelById(ptaskId);
    }

    @Override
    public void deletePtask(Integer ptaskId) throws ApiException {
        if (null == ptaskId) {
            return;
        }
        this.deletePtaskModel(ptaskId);
    }

    @Override
    public QueryResult<PmPtask> queryPtaskPage(Map<String, Object> map) {
        this.logger.error("pm.PmPtaskServiceImpl.queryPtaskPage", (Object)JsonUtil.buildNormalBinder().toJson(map));
        List<PmPtask> pmPtaskList = this.queryPtaskModelPage(map);
        this.logger.error("pm.PmPtaskServiceImpl.queryPtaskPageend", (Object)JsonUtil.buildNormalBinder().toJson(pmPtaskList));
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        int count = 0;
        if (ListUtil.isNotEmpty(pmPtaskList)) {
            count = this.countPtask(map);
        }
        this.logger.error("pm.PmPtaskServiceImpl.queryPtaskPagelast", (Object)count);
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtaskList);
        return queryResult;
    }

    @Override
    public QueryResult<PmPtask> queryPtaskPageCJ(Map<String, Object> map) {
        this.logger.error("pm.PmPtaskServiceImpl.queryPtaskPage", (Object)JsonUtil.buildNormalBinder().toJson(map));
        List<PmPtask> pmPtaskList = this.queryPtaskModelPage(map);
        this.logger.error("pm.PmPtaskServiceImpl.queryPtaskPageend", (Object)JsonUtil.buildNormalBinder().toJson(pmPtaskList));
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        int count = 0;
        if (ListUtil.isNotEmpty(pmPtaskList)) {
            count = this.countPtask(map);
        }
        this.logger.error("pm.PmPtaskServiceImpl.queryPtaskPagelast", (Object)count);
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtaskList);
        return queryResult;
    }

    @Override
    public List<PmPtaskReDomain> queryPtaskReDomain(Map<String, Object> map) {
        this.logger.info("pm.PmPtaskServiceImpl.queryPtaskReDomain", (Object)"start...........");
        if (MapUtil.isNotEmpty(map)) {
            return null;
        }
        this.logger.info("pm.PmPtaskServiceImpl.queryPtaskReDomain", (Object)JsonUtil.buildNormalBinder().toJson(map));
        List<PmPtask> pmPtaskList = this.queryPtaskModelPage(map);
        this.logger.info("pm.PmPtaskServiceImpl.queryPtaskReDomain", (Object)ListUtil.isEmpty(pmPtaskList));
        if (ListUtil.isEmpty(pmPtaskList)) {
            return null;
        }
        ArrayList<PmPtaskReDomain> pmPtaskReDomainList = new ArrayList<PmPtaskReDomain>();
        for (PmPtask pmPtask : pmPtaskList) {
            pmPtaskReDomainList.add(this.makePmPtaskReDomain(pmPtask));
        }
        return pmPtaskReDomainList;
    }

    @Override
    public PmPtask getPtaskByCode(String tenantCode, String ptaskCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskCode", ptaskCode);
        return this.getPtaskModelByCode(map);
    }

    @Override
    public void deletePtaskByCode(String tenantCode, String ptaskCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskCode", ptaskCode);
        this.delPtaskModelByCode(map);
    }

    @Override
    public String sendPtask(PmPtaskDomain pmPtaskDomain) throws ApiException {
        String code = this.savePtask(pmPtaskDomain);
        if (StringUtils.isNotBlank((String)code)) {
            this.pmChannelsendBaseService.sendChannelsendBatch(this.buildChannelSend(pmPtaskDomain));
        }
        return code;
    }

    private List<PmChannelsendDomain> buildChannelSend(PmPtaskDomain pmPtaskDomain) {
        ArrayList<PmChannelsendDomain> disChannelsendDomainList = new ArrayList<PmChannelsendDomain>();
        PmChannelsendDomain pmChannelsendDomain = new PmChannelsendDomain();
        pmChannelsendDomain.setChannelsendOpcode(pmPtaskDomain.getPromotionCode());
        pmChannelsendDomain.setChannelsendType("pmPromotionReDomain");
        pmChannelsendDomain.setChannelsendDir("addBList");
        pmChannelsendDomain.setMemberCode(pmPtaskDomain.getPtaskName());
        String sendTxt = JsonUtil.buildNormalBinder().toJson((Object)this.makePmPromotionReDomainDomain(pmPtaskDomain));
        pmChannelsendDomain.setChannelsendTxt(sendTxt);
        pmChannelsendDomain.setTenantCode(pmPtaskDomain.getTenantCode());
        disChannelsendDomainList.add(pmChannelsendDomain);
        PmChannelsendDomain pmChannelsendDomain1 = new PmChannelsendDomain();
        pmChannelsendDomain1.setChannelsendOpcode(pmPtaskDomain.getPromotionCode());
        pmChannelsendDomain1.setChannelsendType("pmPromotionReDomain");
        pmChannelsendDomain1.setChannelsendDir("addBaList");
        pmChannelsendDomain1.setMemberCode(pmPtaskDomain.getPtaskName());
        pmChannelsendDomain1.setChannelsendTxt(sendTxt);
        pmChannelsendDomain1.setTenantCode(pmPtaskDomain.getTenantCode());
        disChannelsendDomainList.add(pmChannelsendDomain1);
        PmChannelsendDomain pmChannelsendDomain2 = new PmChannelsendDomain();
        pmChannelsendDomain2.setChannelsendOpcode(pmPtaskDomain.getPromotionCode());
        pmChannelsendDomain2.setChannelsendType("pmPromotionReDomain");
        pmChannelsendDomain2.setChannelsendDir("addBa");
        pmChannelsendDomain2.setMemberCode(pmPtaskDomain.getPtaskName());
        pmChannelsendDomain2.setChannelsendTxt(sendTxt);
        pmChannelsendDomain2.setTenantCode(pmPtaskDomain.getTenantCode());
        disChannelsendDomainList.add(pmChannelsendDomain2);
        return disChannelsendDomainList;
    }

    private PmPromotionReDomain makePmPromotionReDomainDomain(PmPtaskDomain pmPtaskDomain) {
        PmPromotion pmPromotion = this.pmPromotionService.getPromotionByCode(pmPtaskDomain.getTenantCode(), pmPtaskDomain.getPromotionCode());
        PmPromotionReDomain pmPromotionReDomain = new PmPromotionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionReDomain, (Object)pmPromotion);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<PmPtaskDomain> pmPtaskDomainList = new ArrayList<PmPtaskDomain>();
        pmPtaskDomainList.add(pmPtaskDomain);
        pmPromotionReDomain.setPmPtaskDomainList(pmPtaskDomainList);
        return pmPromotionReDomain;
    }
}

