/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPtaskConfigMapper;
import com.yqbsoft.laser.service.pm.domain.PmPtaskConfigDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskConfigReDomain;
import com.yqbsoft.laser.service.pm.model.PmPtaskConfig;
import com.yqbsoft.laser.service.pm.service.PmPtaskConfigService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPtaskConfigServiceImpl
extends BaseServiceImpl
implements PmPtaskConfigService {
    private static final String SYS_CODE = "pm.PmPtaskConfigServiceImpl";
    private PmPtaskConfigMapper pmPtaskConfigMapper;

    public void setPmPtaskConfigMapper(PmPtaskConfigMapper pmPtaskConfigMapper) {
        this.pmPtaskConfigMapper = pmPtaskConfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPtaskConfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskConfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtaskConfig(PmPtaskConfigDomain pmPtaskConfigDomain) {
        if (null == pmPtaskConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPtaskConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtaskConfigDefault(PmPtaskConfig pmPtaskConfig) {
        if (null == pmPtaskConfig) {
            return;
        }
        if (null == pmPtaskConfig.getDataState()) {
            pmPtaskConfig.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPtaskConfig.getGmtCreate()) {
            pmPtaskConfig.setGmtCreate(date);
        }
        pmPtaskConfig.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPtaskConfig.getPtaskConfigCode())) {
            pmPtaskConfig.setPtaskConfigCode(this.getNo(null, "PmPtaskConfig", "pmPtaskConfig", pmPtaskConfig.getTenantCode()));
        }
    }

    private int getPtaskConfigMaxCode() {
        int code = 0;
        try {
            return this.pmPtaskConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskConfigServiceImpl.getPtaskConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtaskConfigUpdataDefault(PmPtaskConfig pmPtaskConfig) {
        if (null == pmPtaskConfig) {
            return;
        }
        pmPtaskConfig.setGmtModified(this.getSysDate());
    }

    private void savePtaskConfigModel(PmPtaskConfig pmPtaskConfig) throws ApiException {
        if (null == pmPtaskConfig) {
            return;
        }
        try {
            this.pmPtaskConfigMapper.insert(pmPtaskConfig);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.savePtaskConfigModel.ex", (Throwable)e);
        }
    }

    private void savePtaskConfigBatchModel(List<PmPtaskConfig> pmPtaskConfigList) throws ApiException {
        if (null == pmPtaskConfigList || pmPtaskConfigList.isEmpty()) {
            return;
        }
        try {
            this.pmPtaskConfigMapper.insertBatch(pmPtaskConfigList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.savePtaskConfigBatchModel.ex", (Throwable)e);
        }
    }

    private PmPtaskConfig getPtaskConfigModelById(Integer ptaskConfigId) {
        if (null == ptaskConfigId) {
            return null;
        }
        try {
            return this.pmPtaskConfigMapper.selectByPrimaryKey(ptaskConfigId);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskConfigServiceImpl.getPtaskConfigModelById", (Throwable)e);
            return null;
        }
    }

    private PmPtaskConfig getPtaskConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPtaskConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskConfigServiceImpl.getPtaskConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtaskConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.delPtaskConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.delPtaskConfigModelByCode.num");
        }
    }

    private void deletePtaskConfigModel(Integer ptaskConfigId) throws ApiException {
        if (null == ptaskConfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskConfigMapper.deleteByPrimaryKey(ptaskConfigId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.deletePtaskConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.deletePtaskConfigModel.num");
        }
    }

    private void updatePtaskConfigModel(PmPtaskConfig pmPtaskConfig) throws ApiException {
        if (null == pmPtaskConfig) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskConfigMapper.updateByPrimaryKey(pmPtaskConfig);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.updatePtaskConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.updatePtaskConfigModel.num");
        }
    }

    private void updateStatePtaskConfigModel(Integer ptaskConfigId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ptaskConfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptaskConfigId", ptaskConfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.updateStatePtaskConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.updateStatePtaskConfigModel.null");
        }
    }

    private void updateStatePtaskConfigModelByCode(String tenantCode, String ptaskConfigCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ptaskConfigCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskConfigCode", ptaskConfigCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskConfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.updateStatePtaskConfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.updateStatePtaskConfigModelByCode.null");
        }
    }

    private PmPtaskConfig makePtaskConfig(PmPtaskConfigDomain pmPtaskConfigDomain, PmPtaskConfig pmPtaskConfig) {
        if (null == pmPtaskConfigDomain) {
            return null;
        }
        if (null == pmPtaskConfig) {
            pmPtaskConfig = new PmPtaskConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskConfig, (Object)pmPtaskConfigDomain);
            return pmPtaskConfig;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskConfigServiceImpl.makePtaskConfig", (Throwable)e);
            return null;
        }
    }

    private PmPtaskConfigReDomain makePmPtaskConfigReDomain(PmPtaskConfig pmPtaskConfig) {
        if (null == pmPtaskConfig) {
            return null;
        }
        PmPtaskConfigReDomain pmPtaskConfigReDomain = new PmPtaskConfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskConfigReDomain, (Object)pmPtaskConfig);
            return pmPtaskConfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskConfigServiceImpl.makePmPtaskConfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPtaskConfig> queryPtaskConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPtaskConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskConfigServiceImpl.queryPtaskConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countPtaskConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPtaskConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskConfigServiceImpl.countPtaskConfig", (Throwable)e);
        }
        return i;
    }

    private PmPtaskConfig createPmPtaskConfig(PmPtaskConfigDomain pmPtaskConfigDomain) {
        String msg = this.checkPtaskConfig(pmPtaskConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.savePtaskConfig.checkPtaskConfig", msg);
        }
        PmPtaskConfig pmPtaskConfig = this.makePtaskConfig(pmPtaskConfigDomain, null);
        this.setPtaskConfigDefault(pmPtaskConfig);
        return pmPtaskConfig;
    }

    @Override
    public String savePtaskConfig(PmPtaskConfigDomain pmPtaskConfigDomain) throws ApiException {
        PmPtaskConfig pmPtaskConfig = this.createPmPtaskConfig(pmPtaskConfigDomain);
        this.savePtaskConfigModel(pmPtaskConfig);
        return pmPtaskConfig.getPtaskConfigCode();
    }

    @Override
    public String savePtaskConfigBatch(List<PmPtaskConfigDomain> pmPtaskConfigDomainList) throws ApiException {
        if (null == pmPtaskConfigDomainList || pmPtaskConfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPtaskConfig> pmPtaskConfigList = new ArrayList<PmPtaskConfig>();
        String code = "";
        for (PmPtaskConfigDomain pmPtaskConfigDomain : pmPtaskConfigDomainList) {
            PmPtaskConfig pmPtaskConfig = this.createPmPtaskConfig(pmPtaskConfigDomain);
            code = pmPtaskConfig.getPtaskConfigCode();
            pmPtaskConfigList.add(pmPtaskConfig);
        }
        this.savePtaskConfigBatchModel(pmPtaskConfigList);
        return code;
    }

    @Override
    public void updatePtaskConfigState(Integer ptaskConfigId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ptaskConfigId) {
            return;
        }
        this.updateStatePtaskConfigModel(ptaskConfigId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtaskConfigStateByCode(String tenantCode, String ptaskConfigCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ptaskConfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtaskConfigModelByCode(tenantCode, ptaskConfigCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtaskConfig(PmPtaskConfigDomain pmPtaskConfigDomain) throws ApiException {
        String msg = this.checkPtaskConfig(pmPtaskConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.updatePtaskConfig.checkPtaskConfig", msg);
        }
        PmPtaskConfig oldPmPtaskConfig = this.getPtaskConfigModelById(pmPtaskConfigDomain.getPtaskConfigId());
        if (null == oldPmPtaskConfig) {
            throw new ApiException("pm.PmPtaskConfigServiceImpl.updatePtaskConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPtaskConfig pmPtaskConfig = this.makePtaskConfig(pmPtaskConfigDomain, oldPmPtaskConfig);
        this.setPtaskConfigUpdataDefault(pmPtaskConfig);
        this.updatePtaskConfigModel(pmPtaskConfig);
    }

    @Override
    public PmPtaskConfig getPtaskConfig(Integer ptaskConfigId) {
        if (null == ptaskConfigId) {
            return null;
        }
        return this.getPtaskConfigModelById(ptaskConfigId);
    }

    @Override
    public void deletePtaskConfig(Integer ptaskConfigId) throws ApiException {
        if (null == ptaskConfigId) {
            return;
        }
        this.deletePtaskConfigModel(ptaskConfigId);
    }

    @Override
    public QueryResult<PmPtaskConfig> queryPtaskConfigPage(Map<String, Object> map) {
        List<PmPtaskConfig> pmPtaskConfigList = this.queryPtaskConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtaskConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtaskConfigList);
        return queryResult;
    }

    @Override
    public PmPtaskConfig getPtaskConfigByCode(String tenantCode, String ptaskConfigCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskConfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskConfigCode", ptaskConfigCode);
        return this.getPtaskConfigModelByCode(map);
    }

    @Override
    public void deletePtaskConfigByCode(String tenantCode, String ptaskConfigCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskConfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskConfigCode", ptaskConfigCode);
        this.delPtaskConfigModelByCode(map);
    }
}

