/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.PromotionConstants;
import com.yqbsoft.laser.service.pm.dao.PmUserCouponMapper;
import com.yqbsoft.laser.service.pm.domain.OrderCallBackBean;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponReDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponsendDomain;
import com.yqbsoft.laser.service.pm.domain.UmUserinfo;
import com.yqbsoft.laser.service.pm.es.UpdateUserConDataStatePollThread;
import com.yqbsoft.laser.service.pm.es.UpdateUserConDataStatePutThread;
import com.yqbsoft.laser.service.pm.es.UpdateUserConDataStateService;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmUserCoupon;
import com.yqbsoft.laser.service.pm.msg.EsEnginePollThread;
import com.yqbsoft.laser.service.pm.msg.EsEnginePutThread;
import com.yqbsoft.laser.service.pm.msg.EsEngineService;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponlistService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponsendService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PmUserCouponServiceImpl
extends BaseServiceImpl
implements PmUserCouponService {
    private static final String SYS_CODE = "pm.PmUserCouponServiceImpl";
    private PmUserCouponMapper pmUserCouponMapper;
    private PmUserCouponsendService pmUserCouponsendService;
    PmUserCouponlistService pmUserCouponlistService;
    PmPromotionService pmPromotionService;
    private static final ExecutorService pool = Executors.newFixedThreadPool(20);
    public static final String PM_USERCOUPONSTATE_KEY = "pm-usercouponstate-key";
    private static Object msglock = new Object();
    private static EsEngineService esEngineService;
    private static Object UpdateUserConDataStatelock;
    private static UpdateUserConDataStateService updateUserConDataStateService;

    public void setPmUserCouponsendService(PmUserCouponsendService pmUserCouponsendService) {
        this.pmUserCouponsendService = pmUserCouponsendService;
    }

    public void setPmUserCouponMapper(PmUserCouponMapper pmUserCouponMapper) {
        this.pmUserCouponMapper = pmUserCouponMapper;
    }

    public PmUserCouponlistService getPmUserCouponlistService() {
        return this.pmUserCouponlistService;
    }

    public void setPmUserCouponlistService(PmUserCouponlistService pmUserCouponlistService) {
        this.pmUserCouponlistService = pmUserCouponlistService;
    }

    public PmPromotionService getPmPromotionService() {
        if (null == this.pmPromotionService) {
            this.pmPromotionService = (PmPromotionService)ApplicationContextUtil.getService((String)"pmPromotionService");
        }
        return this.pmPromotionService;
    }

    private Date getSysDate() {
        try {
            return this.pmUserCouponMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserCoupon(PmUserCouponDomain pmUserCouponDomain) {
        if (null == pmUserCouponDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmUserCouponDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserCouponDefault(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return;
        }
        if (null == pmUserCoupon.getDataState()) {
            pmUserCoupon.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmUserCoupon.getGmtCreate()) {
            pmUserCoupon.setGmtCreate(date);
        }
        pmUserCoupon.setGmtModified(date);
        if (StringUtils.isBlank((String)pmUserCoupon.getUsercouponCode())) {
            pmUserCoupon.setUsercouponCode(this.getNo(null, "PmUserCoupon", "usercouponCode", pmUserCoupon.getTenantCode()));
        }
        if (StringUtils.isBlank((String)pmUserCoupon.getCouponNo())) {
            pmUserCoupon.setCouponNo(this.getNo(null, "PmUserCoupon", "couponNo", pmUserCoupon.getTenantCode()));
        }
    }

    private int getUserCouponMaxCode() {
        int code = 0;
        try {
            return this.pmUserCouponMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.getUserCouponMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserCouponUpdataDefault(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return;
        }
        pmUserCoupon.setGmtModified(this.getSysDate());
    }

    private void saveUserCouponModel(PmUserCoupon pmUserCoupon) throws ApiException {
        if (null == pmUserCoupon) {
            return;
        }
        try {
            this.pmUserCouponMapper.insert(pmUserCoupon);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.saveUserCouponModel.ex", (Throwable)e);
        }
    }

    private void saveUserCouponBatchModel(List<PmUserCoupon> pmUserCouponList) throws ApiException {
        if (null == pmUserCouponList || pmUserCouponList.isEmpty()) {
            return;
        }
        try {
            this.pmUserCouponMapper.insertBatch(pmUserCouponList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.saveUserCouponBatchModel.ex", (Throwable)e);
        }
    }

    private PmUserCoupon getUserCouponModelById(Integer usercouponId) {
        if (null == usercouponId) {
            return null;
        }
        try {
            return this.pmUserCouponMapper.selectByPrimaryKey(usercouponId);
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.getUserCouponModelById", (Throwable)e);
            return null;
        }
    }

    private PmUserCoupon getUserCouponModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmUserCouponMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.getUserCouponModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserCouponModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserCouponMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.delUserCouponModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmUserCouponServiceImpl.delUserCouponModelByCode.num");
        }
    }

    private void deleteUserCouponModel(Integer usercouponId) throws ApiException {
        if (null == usercouponId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserCouponMapper.deleteByPrimaryKey(usercouponId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.deleteUserCouponModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmUserCouponServiceImpl.deleteUserCouponModel.num");
        }
    }

    private void updateUserCouponModel(PmUserCoupon pmUserCoupon) throws ApiException {
        if (null == pmUserCoupon) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateByPrimaryKeySelective(pmUserCoupon);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateUserCouponModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateUserCouponModel.num");
        }
    }

    private void updateStateUserCouponModel(Integer usercouponId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == usercouponId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usercouponId", usercouponId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateStateUserCouponModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateStateUserCouponModel.null");
        }
    }

    private void updateStateUserCouponModelByCode(String tenantCode, String usercouponCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)usercouponCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateStateUserCouponModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateStateUserCouponModelByCode.null");
        }
    }

    private PmUserCoupon makeUserCoupon(PmUserCouponDomain pmUserCouponDomain, PmUserCoupon pmUserCoupon) {
        if (null == pmUserCouponDomain) {
            return null;
        }
        if (null == pmUserCoupon) {
            pmUserCoupon = new PmUserCoupon();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCoupon, (Object)pmUserCouponDomain);
            return pmUserCoupon;
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.makeUserCoupon", (Throwable)e);
            return null;
        }
    }

    private PmUserCouponReDomain makePmUserCouponReDomain(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return null;
        }
        PmUserCouponReDomain pmUserCouponReDomain = new PmUserCouponReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCouponReDomain, (Object)pmUserCoupon);
            return pmUserCouponReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.makePmUserCouponReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmUserCoupon> queryUserCouponModelPage(Map<String, Object> parammap) {
        try {
            return this.pmUserCouponMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.queryUserCouponModel", (Throwable)e);
            return null;
        }
    }

    private int countUserCoupon(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmUserCouponMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.countUserCoupon", (Throwable)e);
        }
        return i;
    }

    private PmUserCoupon createPmUserCoupon(PmUserCouponDomain pmUserCouponDomain) {
        String msg = this.checkUserCoupon(pmUserCouponDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmUserCouponServiceImpl.saveUserCoupon.checkUserCoupon", msg);
        }
        PmUserCoupon pmUserCoupon = this.makeUserCoupon(pmUserCouponDomain, null);
        this.setUserCouponDefault(pmUserCoupon);
        return pmUserCoupon;
    }

    @Override
    public String saveUserCoupon(PmUserCouponDomain pmUserCouponDomain) throws ApiException {
        if (null == pmUserCouponDomain) {
            return null;
        }
        PmUserCoupon pmUserCoupon = this.createPmUserCoupon(pmUserCouponDomain);
        if (null == pmUserCoupon) {
            throw new ApiException("pm.PmUserCouponServiceImpl.saveUserCoupon.pmUserCoupon");
        }
        this.saveUserCouponModel(pmUserCoupon);
        return pmUserCoupon.getUsercouponCode();
    }

    private void updateCache(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return;
        }
        DisUtil.set((String)("PmUserCoupon-" + pmUserCoupon.getUsercouponCode() + "-" + pmUserCoupon.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)pmUserCoupon));
    }

    private void delCache(String usercouponCode, String tenantCode) {
        if (StringUtils.isBlank((String)usercouponCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        DisUtil.del((String)("PmUserCoupon-" + usercouponCode + "-" + tenantCode));
    }

    @Override
    public String saveUserCouponBatch(List<PmUserCouponDomain> pmUserCouponDomainList) throws ApiException {
        if (null == pmUserCouponDomainList || pmUserCouponDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (PmUserCouponDomain pmUserCouponDomain : pmUserCouponDomainList) {
            code = this.saveUserCoupon(pmUserCouponDomain);
        }
        return code;
    }

    @Override
    public void updateUserCouponState(Integer usercouponId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserCouponModel(usercouponId, dataState, oldDataState);
        PmUserCoupon pmUserCoupon = this.getUserCoupon(usercouponId);
        if (PromotionConstants.USERCOUPON_DATA_STATE_0.intValue() == dataState.intValue()) {
            this.updateCache(pmUserCoupon);
        } else {
            this.delCache(pmUserCoupon.getUsercouponCode(), pmUserCoupon.getTenantCode());
        }
    }

    @Override
    public void updateUserCouponStateByCode(String tenantCode, String usercouponCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)usercouponCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUserCouponModelByCode(tenantCode, usercouponCode, dataState, oldDataState);
        if (PromotionConstants.USERCOUPON_DATA_STATE_0.intValue() == dataState.intValue()) {
            PmUserCoupon pmUserCoupon = this.getUserCouponByCode(tenantCode, usercouponCode);
            this.updateCache(pmUserCoupon);
        } else {
            this.delCache(usercouponCode, tenantCode);
        }
    }

    @Override
    public void updateUserCoupon(PmUserCouponDomain pmUserCouponDomain) throws ApiException {
        String msg = this.checkUserCoupon(pmUserCouponDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateUserCoupon.checkUserCoupon", msg);
        }
        PmUserCoupon oldPmUserCoupon = this.getUserCouponModelById(pmUserCouponDomain.getUsercouponId());
        if (null == oldPmUserCoupon) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateUserCoupon.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmUserCoupon pmUserCoupon = this.makeUserCoupon(pmUserCouponDomain, oldPmUserCoupon);
        this.setUserCouponUpdataDefault(pmUserCoupon);
        this.updateUserCouponModel(pmUserCoupon);
    }

    @Override
    public PmUserCoupon getUserCoupon(Integer usercouponId) {
        return this.getUserCouponModelById(usercouponId);
    }

    @Override
    public void deleteUserCoupon(Integer usercouponId) throws ApiException {
        this.deleteUserCouponModel(usercouponId);
    }

    @Override
    public QueryResult<PmUserCoupon> queryUserCouponPage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("pm.PmUserCouponServiceImpl.queryUserCouponPage.null", (Object)map.toString());
            return new QueryResult();
        }
        this.logger.info("pm.PmUserCouponServiceImpl.queryuserCouponsendPage", (Object)"start select");
        this.logger.error("pm.PmUserCouponServiceImpl.queryuserCouponsendPage", (Object)("the parm is " + JSON.toJSONString(map)));
        List<PmUserCoupon> pmUserCouponList = this.queryUserCouponModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserCoupon(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmUserCouponList);
        return queryResult;
    }

    @Override
    public List<PmUserCoupon> queryUserCouponList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("pm.PmUserCouponServiceImpl.queryUserCouponPage.null", (Object)map.toString());
            return new ArrayList<PmUserCoupon>();
        }
        return this.queryUserCouponModelPage(map);
    }

    @Override
    public PmUserCoupon getUserCouponByCode(String tenantCode, String usercouponCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        PmUserCoupon pmUserCoupon = this.getUserCouponModelByCode(map);
        if (pmUserCoupon != null) {
            PmPromotionService pmPromotionService;
            PmPromotion promotion;
            if (pmUserCoupon.getDataState() == 1) {
                pmUserCoupon.setUseTime(DateUtils.parseDateTime((Date)pmUserCoupon.getGmtModified()));
            }
            if ((promotion = (pmPromotionService = this.getPmPromotionService()).getPromotionByCode(pmUserCoupon.getTenantCode(), pmUserCoupon.getPromotionCode())) != null) {
                pmUserCoupon.setTargetType(promotion.getTargetType());
                pmUserCoupon.setRangeType(promotion.getRangeType());
                pmUserCoupon.setPromotionFrequency(promotion.getPromotionFrequency());
                pmUserCoupon.setFixPeriod(promotion.getCouponOnceOdate());
            }
        }
        return pmUserCoupon;
    }

    @Override
    public void deleteUserCouponByCode(String tenantCode, String usercouponCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        this.delUserCouponModelByCode(map);
    }

    @Override
    public BigDecimal checkUseCoupon(String tenantCode, String couponNo, String memberBcode) throws ApiException {
        BigDecimal result = BigDecimal.ZERO;
        return result;
    }

    @Override
    public String updateUserCouponByOrderCallBack(List<OrderCallBackBean> orderCallBackBeanList) throws ApiException {
        String flag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"0108-mockCouponFlag-mockCouponFlag");
        if (StringUtils.isNotBlank((String)flag) && "1".equals(flag)) {
            this.logger.info("===mockCouponFlag open===");
            return "ERROR";
        }
        if (ListUtil.isEmpty(orderCallBackBeanList)) {
            return "ERROR";
        }
        this.logger.info("\u4f18\u60e0\u5238\u6838\u51cf\u5165\u53c2\uff1a", (Object)JSON.toJSONString(orderCallBackBeanList));
        try {
            if ("BCOP".equals(orderCallBackBeanList.get(0).getContractSettlBlance()) && !"8".equals(orderCallBackBeanList.get(0).getContractPmode())) {
                return "SUCCESS";
            }
            for (OrderCallBackBean orderCallBackBean : orderCallBackBeanList) {
                this.updateUserCouponStateByCode(orderCallBackBean.getTenantCode(), orderCallBackBean.getUsercouponCode(), PromotionConstants.USERCOUPON_DATA_STATE_1, PromotionConstants.USERCOUPON_DATA_STATE_0);
            }
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.updateUserCouponByOrderCallBack e" + orderCallBackBeanList.get(0).getContractBillcode(), (Throwable)e);
            return "ERROR";
        }
        return "SUCCESS";
    }

    @Override
    public void updateUsercouponDataStateJob() {
        HashMap<String, Object> parMap = new HashMap<String, Object>();
        parMap.put("couponType", 1);
        parMap.put("couponEndQend", this.getSysDate());
        parMap.put("dataState", 0);
        QueryResult<PmUserCoupon> pmUserCouponQueryResult = this.queryUserCouponPage(parMap);
        if (null != pmUserCouponQueryResult && ListUtil.isNotEmpty((Collection)pmUserCouponQueryResult.getList())) {
            for (PmUserCoupon pmUserCoupon : pmUserCouponQueryResult.getList()) {
                this.updateUserCouponStateByCode(pmUserCoupon.getTenantCode(), pmUserCoupon.getUsercouponCode(), PromotionConstants.USERCOUPON_DATA_STATE_2, PromotionConstants.USERCOUPON_DATA_STATE_0);
                this.getPmPromotionService().updateRecoverySendNum(pmUserCoupon.getTenantCode(), pmUserCoupon.getPromotionCode(), 1);
            }
        }
        this.updateUsercouponDataState();
    }

    @Override
    public void queryUsercouponCache() {
        HashMap<String, Object> parMap = new HashMap<String, Object>();
        parMap.put("dataState", 0);
        QueryResult<PmUserCoupon> pmUserCouponQueryResult = this.queryUserCouponPage(parMap);
        if (null != pmUserCouponQueryResult && ListUtil.isNotEmpty((Collection)pmUserCouponQueryResult.getList())) {
            for (PmUserCoupon pmUserCoupon : pmUserCouponQueryResult.getList()) {
                this.updateCache(pmUserCoupon);
            }
        }
    }

    @Override
    public void sendUpdateUserCouponStateByEndTime(final String promotionCode, final String tenantCode) {
        this.logger.info("pm.PmUserCouponServiceImpl.sendUpdateUserCouponStateByEndTime", (Object)"start");
        if (StringUtils.isBlank((String)tenantCode) && StringUtils.isBlank((String)promotionCode)) {
            this.logger.error("pm.PmUserCouponServiceImpl.sendUpdateUserCouponStateByEndTime", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01tenantCode\uff1a" + tenantCode));
            return;
        }
        pool.execute(new Runnable(){

            @Override
            public void run() {
                PmUserCouponServiceImpl.this.updateUserCouponStateByEndTime(promotionCode, tenantCode);
            }
        });
        this.logger.info("pm.PmUserCouponServiceImpl.sendUpdateUserCouponStateByEndTime", (Object)"end");
    }

    private void updateUserCouponStateByEndTime(String promotionCode, String tenantCode) {
        String key = "pm-usercouponstate-key_" + promotionCode + "_" + tenantCode;
        SupDisUtil.set((String)key, (String)"1", (int)86400);
        PmPromotion promotionByCode = this.pmPromotionService.getPromotionByCodeMain(tenantCode, promotionCode);
        if (null == promotionByCode) {
            this.logger.error("pm.PmUserCouponServiceImpl.updateUserCouponStateByEndTime promotionByCode is null", (Object)"\u6d3b\u52a8\u4fe1\u606f\u9519\u8bef");
            return;
        }
        if (1 == promotionByCode.getDataState()) {
            this.logger.error("pm.PmUserCouponServiceImpl.updateUserCouponStateByEndTime promotionByCode dataState error", (Object)"\u6d3b\u52a8\u672a\u8fc7\u671f");
            return;
        }
        if (promotionByCode.getPromotionEndtime().compareTo(this.getSysDate()) > 0) {
            this.logger.error("pm.PmUserCouponServiceImpl.updateUserCouponStateByEndTime promotionByCode getPromotionEndtime is error", (Object)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u672a\u5230");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        try {
            this.logger.info("pm.PmUserCouponServiceImpl.updateUserCouponStateByEndTime.start");
            int startRow = 0;
            int size = 1000;
            int page = 1;
            boolean flag = true;
            List<PmUserCoupon> result = null;
            do {
                startRow = (page - 1) * size;
                map.put("startRow", startRow);
                map.put("rows", size);
                result = this.queryUserCouponList(map);
                if (ListUtil.isNotEmpty(result)) {
                    PmUserCouponServiceImpl.getUpdateUserConDataStateService().addPutPool(new UpdateUserConDataStatePutThread(PmUserCouponServiceImpl.getUpdateUserConDataStateService(), result));
                    if (result.size() != size) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                ++page;
                Thread.sleep(1000L);
            } while (flag);
            this.getEsEngineService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateUserCouponStateByEndTime.an.e", (Throwable)e);
        }
        finally {
            SupDisUtil.del((String)key);
        }
        this.logger.info("pm.PmUserCouponServiceImpl.updateUserCouponStateByEndTime.end");
    }

    @Override
    public void saveUserCouponTime(PmUserCoupon pmUserCoupon) throws ApiException {
        if (null == pmUserCoupon) {
            return;
        }
        this.updateUserCouponStateByCode(pmUserCoupon.getTenantCode(), pmUserCoupon.getUsercouponCode(), PromotionConstants.USERCOUPON_DATA_STATE_2, PromotionConstants.USERCOUPON_DATA_STATE_0);
        this.getPmPromotionService().updateRecoverySendNum(pmUserCoupon.getTenantCode(), pmUserCoupon.getPromotionCode(), 1);
    }

    @Override
    public void updateUserCouponTimeBatch(List<PmUserCoupon> pmUserCouponList) throws ApiException {
        if (ListUtil.isEmpty(pmUserCouponList)) {
            return;
        }
        ArrayList<Integer> updatePmUserCouponIdsList = new ArrayList<Integer>();
        for (PmUserCoupon pmUserCoupon : pmUserCouponList) {
            if (0 != pmUserCoupon.getDataState()) continue;
            updatePmUserCouponIdsList.add(pmUserCoupon.getUsercouponId());
        }
        if (ListUtil.isNotEmpty(updatePmUserCouponIdsList)) {
            this.updateUsercouponDataStateBatchByIds(updatePmUserCouponIdsList);
        }
    }

    private void updateUsercouponDataStateBatchByIds(List<Integer> updatePmUserCouponIdsList) {
        if (ListUtil.isEmpty(updatePmUserCouponIdsList)) {
            return;
        }
        try {
            this.pmUserCouponMapper.updateDateStateByIds(updatePmUserCouponIdsList);
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.updateUsercouponDataState", (Throwable)e);
        }
    }

    @Override
    public int getCount(Map<String, Object> map) {
        map.put("dataStateEnd", -1);
        int res = this.countUserCoupon(map);
        return res;
    }

    private void updateUsercouponDataState() {
        try {
            this.pmUserCouponMapper.updateUsercouponDataState();
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.updateUsercouponDataState", (Throwable)e);
        }
    }

    private void updateUserCouponModelStateByPromotin(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            this.pmUserCouponMapper.updateUserCouponStateByPromotin(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.updateUserCouponModelStateByPromotin", (Throwable)e);
        }
    }

    @Override
    public void updateUserCouponStateByPromotin(String tenantCode, String promotionCode) throws ApiException {
        this.updateUserCouponModelStateByPromotin(tenantCode, promotionCode, 2, 0);
    }

    @Override
    public void updateUserCouponNump(String tenantCode, String usercouponCode, int num) throws ApiException {
        this.updateSendNumPromotionModel(tenantCode, usercouponCode, num);
    }

    @Override
    public void saveForwardUserCoupon(PmUserCouponDomain pmUserCouponDomain) throws ApiException {
        if (null == pmUserCouponDomain) {
            throw new ApiException("pm.PmUserCouponServiceImpl.saveForwardUserCoupon.null", "pmUserCouponDomain is null");
        }
        PmUserCoupon olduUserCouponByCode = this.getUserCouponByCode(pmUserCouponDomain.getTenantCode(), pmUserCouponDomain.getUsercouponCode());
        if (null == olduUserCouponByCode) {
            throw new ApiException("pm.PmUserCouponServiceImpl.saveForwardUserCoupon.userCouponByCode", "\u4f18\u60e0\u5377\u4e0d\u5b58\u5728");
        }
        if (PromotionConstants.USERCOUPON_DATA_STATE_0 != olduUserCouponByCode.getDataState()) {
            throw new ApiException("pm.PmUserCouponServiceImpl.saveForwardUserCoupon.userCouponByCode", "\u53ea\u6709\u672a\u4f7f\u7528\u7684\u4f18\u60e0\u5377\u53ef\u4ee5\u8f6c\u589e");
        }
        PmUserCouponDomain userCouponDomain = new PmUserCouponDomain();
        try {
            BeanUtils.copyAllPropertys((Object)userCouponDomain, (Object)olduUserCouponByCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        userCouponDomain.setUsercouponId(null);
        userCouponDomain.setUsercouponCode(null);
        userCouponDomain.setUsercouponOrgin("2");
        userCouponDomain.setUserCode(pmUserCouponDomain.getUserCode());
        userCouponDomain.setUserName(pmUserCouponDomain.getUserName());
        userCouponDomain.setMemberBcode(pmUserCouponDomain.getMemberBcode());
        userCouponDomain.setMemberBname(pmUserCouponDomain.getMemberBname());
        userCouponDomain.setMemberMcode(olduUserCouponByCode.getMemberBcode());
        userCouponDomain.setMemberMname(olduUserCouponByCode.getMemberBname());
        this.updateUserCouponStateByCode(olduUserCouponByCode.getTenantCode(), olduUserCouponByCode.getUsercouponCode(), PromotionConstants.USERCOUPON_DATA_STATE_DEL, PromotionConstants.USERCOUPON_DATA_STATE_0);
        this.saveUserCoupon(userCouponDomain);
    }

    @Override
    public String saveUserCouponByOrderCallBack(List<OrderCallBackBean> orderCallBackBeanList) {
        this.logger.error("pm.PmUserCouponServiceImpl.saveUserCouponByOrderCallBack.orderCallBackBeanList");
        if (ListUtil.isEmpty(orderCallBackBeanList)) {
            return "ERROR";
        }
        ArrayList<PmUserCouponsendDomain> pmUserCouponsendDomainList = new ArrayList<PmUserCouponsendDomain>();
        for (OrderCallBackBean orderCallBackBean : orderCallBackBeanList) {
            String contractBillcode = orderCallBackBean.getContractBillcode();
            String usercouponCode = orderCallBackBean.getUsercouponCode();
            String memberBcode = orderCallBackBean.getMemberBcode();
            String memberBname = orderCallBackBean.getMemberBname();
            PmUserCouponsendDomain pmUserCouponsendDomain = new PmUserCouponsendDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pmUserCouponsendDomain, (Object)orderCallBackBean);
            }
            catch (Exception e) {
                this.logger.error("pm.PmUserCouponServiceImpl.copyAllPropertys.e", (Throwable)e);
            }
            pmUserCouponsendDomain.setDiscType(6);
            pmUserCouponsendDomain.setUserCouponsendType(1);
            pmUserCouponsendDomain.setUserCouponsendDir(0);
            pmUserCouponsendDomain.setUsercouponOrgin("1");
            pmUserCouponsendDomain.setUsercouponCode(usercouponCode);
            pmUserCouponsendDomain.setMemberBcode(memberBcode);
            pmUserCouponsendDomain.setMemberBname(memberBname);
            pmUserCouponsendDomain.setUsercouponOcode(contractBillcode);
            pmUserCouponsendDomain.setUsercouponAmt(orderCallBackBean.getUserusecouponAmount());
            pmUserCouponsendDomainList.add(pmUserCouponsendDomain);
        }
        this.pmUserCouponsendService.saveuserCouponsendBatch(pmUserCouponsendDomainList);
        return "SUCCESS";
    }

    @Override
    public String updateUserCouponByOrderRefundBack(List<OrderCallBackBean> orderCallBackBeanList) {
        if (ListUtil.isEmpty(orderCallBackBeanList)) {
            return "ERROR";
        }
        try {
            if ("BCOP".equals(orderCallBackBeanList.get(0).getContractSettlBlance()) && !"8".equals(orderCallBackBeanList.get(0).getContractPmode())) {
                return "SUCCESS";
            }
            for (OrderCallBackBean orderCallBackBean : orderCallBackBeanList) {
                this.updateUserCouponStateByCode(orderCallBackBean.getTenantCode(), orderCallBackBean.getUsercouponCode(), PromotionConstants.USERCOUPON_DATA_STATE_0, PromotionConstants.USERCOUPON_DATA_STATE_1);
            }
        }
        catch (Exception e) {
            this.logger.error("pm.PmUserCouponServiceImpl.updateUserCouponByOrderRefundBack e " + orderCallBackBeanList.get(0).getContractBillcode(), (Throwable)e);
            return "ERROR";
        }
        return "SUCCESS";
    }

    @Override
    public void updateUserCouponEndStateByCode(String tenantCode, String usercouponCode) throws ApiException {
        this.updateUserCouponStateByCode(tenantCode, usercouponCode, PromotionConstants.USERCOUPON_DATA_STATE_DEL, PromotionConstants.DATA_STATE_0);
    }

    public void updateSendNumPromotionModel(String tenantCode, String usercouponCode, int num) {
        if (StringUtils.isBlank((String)usercouponCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        map.put("couponOnceNump", num);
        int i = 0;
        try {
            i = this.pmUserCouponMapper.updateSendNump(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateSendNumPromotionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmUserCouponServiceImpl.updateSendNumPromotionModel.null", "\u5df2\u53d1\u653e\u5b8c" + ((Object)map).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsEngineService getEsEngineService() {
        Object object = msglock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 150; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    @Override
    public void queryCouponSoonBeOverdueByMinute(String tenantCode, int minute) throws ApiException {
        if (StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("pm.PmUserCouponServiceImpl.queryCouponSoonBeOverdueByMinute", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01tenantCode\uff1a" + tenantCode));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponEndQstart", DateUtil.addMinutes((Date)new Date(), (int)minute));
        try {
            this.logger.debug("pm.PmUserCouponServiceImpl.queryCouponSoonBeOverdueByMinute.start");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<PmUserCoupon> result = null;
            int xh = 0;
            do {
                startRow = this.getEsEngineService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getEsEngineService().getPage());
                result = this.queryUserCouponPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), result.getRows()));
                    if (result.getRows().size() != this.getEsEngineService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(3000L);
                if (++xh <= 100) continue;
                flag = false;
            } while (flag);
            this.getEsEngineService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("pm.PmUserCouponServiceImpl.queryCouponSoonBeOverdueByMinute.an.e", (Throwable)e);
        }
        this.logger.debug("pm.PmUserCouponServiceImpl.queryCouponSoonBeOverdueByMinute.end");
    }

    @Override
    public void queryCouponSoonBeOverdue(String tenantCode) throws ApiException {
        this.logger.error("pm.PmUserCouponServiceImpl====================================\u4f18\u60e0\u5377\u5373\u5c06\u8fc7\u671f\u67e5\u8be2====================================");
        if (StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("pm.PmUserCouponServiceImpl.queryCouponSoonBeOverdue", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01tenantCode\uff1a" + tenantCode));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.putAll(this.getTimeMap());
        QueryResult<PmUserCoupon> pmUserCouponQueryResult = this.queryUserCouponPage(map);
        if (pmUserCouponQueryResult != null && pmUserCouponQueryResult.getList() != null) {
            List pmUserCouponList = pmUserCouponQueryResult.getList();
            for (PmUserCoupon pmUserCoupon : pmUserCouponList) {
                UmUserinfo umUserinfo = new UmUserinfo();
                umUserinfo.setUserinfoCode(pmUserCoupon.getMemberBcode());
                umUserinfo.setUserinfoCompname(pmUserCoupon.getMemberBname());
                umUserinfo.setTenantCode(pmUserCoupon.getTenantCode());
                try {
                    HashMap<String, String> mnsMap = new HashMap<String, String>();
                    mnsMap.put("umUserinfo", JsonUtil.buildNonDefaultBinder().toJson((Object)umUserinfo));
                    this.getInternalRouter().inInvoke("mns.mns.sendDiscountVolumeNotice", mnsMap);
                    this.logger.error("pm.PmUserCouponServiceImpl====================================\u7ad9\u5185\u4fe1\u53d1\u9001====================================");
                }
                catch (ApiException e) {
                    throw new ApiException("pm.PmUserCouponServiceImpl.queryCouponSoonBeOverdue", "\u7ad9\u5185\u4fe1\u53d1\u9001\u5f02\u5e38\uff01", (Throwable)e);
                }
            }
        } else {
            this.logger.error("pm.PmUserCouponServiceImpl.queryCouponSoonBeOverdue", (Object)("pmUserCouponQueryResult\u4e3anull\uff01pmUserCouponQueryResult\uff1a" + pmUserCouponQueryResult));
        }
    }

    public Map<String, String> getTimeMap() {
        Date now = new Date();
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(now);
        tempStart.add(10, 4);
        String startTime = time.format(tempStart.getTime());
        tempStart.add(10, 1);
        String endTime = time.format(tempStart.getTime());
        HashMap<String, String> timeMap = new HashMap<String, String>();
        timeMap.put("couponEndQstart", startTime);
        timeMap.put("couponEndQend", endTime);
        return timeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateUserConDataStateService getUpdateUserConDataStateService() {
        Object object = UpdateUserConDataStatelock;
        synchronized (object) {
            if (null == updateUserConDataStateService) {
                updateUserConDataStateService = new UpdateUserConDataStateService((PmUserCouponService)SpringApplicationContextUtil.getBean((String)"pmUserCouponService"));
                for (int i = 0; i < 100; ++i) {
                    updateUserConDataStateService.addPollPool(new UpdateUserConDataStatePollThread(updateUserConDataStateService));
                }
            }
            return updateUserConDataStateService;
        }
    }

    static {
        UpdateUserConDataStatelock = new Object();
    }
}

