/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPromotionMemMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionMemDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionMemReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotionMem;
import com.yqbsoft.laser.service.pm.service.PmPromotionMemService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionMemServiceImpl
extends BaseServiceImpl
implements PmPromotionMemService {
    private static final String SYS_CODE = "pm.PmPromotionMemServiceImpl";
    private PmPromotionMemMapper pmPromotionMemMapper;

    public void setPmPromotionMemMapper(PmPromotionMemMapper pmPromotionMemMapper) {
        this.pmPromotionMemMapper = pmPromotionMemMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionMemMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionMemServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotionMem(PmPromotionMemDomain pmPromotionMemDomain) {
        if (null == pmPromotionMemDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionMemDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionMemDefault(PmPromotionMem pmPromotionMem) {
        if (null == pmPromotionMem) {
            return;
        }
        if (null == pmPromotionMem.getDataState()) {
            pmPromotionMem.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPromotionMem.getGmtCreate()) {
            pmPromotionMem.setGmtCreate(date);
        }
        pmPromotionMem.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPromotionMem.getPpmemCode())) {
            pmPromotionMem.setPpmemCode(this.getNo(null, "PmPromotionMem", "pmPromotionMem", pmPromotionMem.getTenantCode()));
        }
    }

    private int getPromotionMemMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionMemMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionMemServiceImpl.getPromotionMemMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionMemUpdataDefault(PmPromotionMem pmPromotionMem) {
        if (null == pmPromotionMem) {
            return;
        }
        pmPromotionMem.setGmtModified(this.getSysDate());
    }

    private void savePromotionMemModel(PmPromotionMem pmPromotionMem) throws ApiException {
        if (null == pmPromotionMem) {
            return;
        }
        try {
            this.pmPromotionMemMapper.insert(pmPromotionMem);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.savePromotionMemModel.ex", (Throwable)e);
        }
    }

    private void savePromotionMemBatchModel(List<PmPromotionMem> pmPromotionMemList) throws ApiException {
        if (null == pmPromotionMemList || pmPromotionMemList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionMemMapper.insertBatch(pmPromotionMemList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.savePromotionMemBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotionMem getPromotionMemModelById(Integer ppmemId) {
        if (null == ppmemId) {
            return null;
        }
        try {
            return this.pmPromotionMemMapper.selectByPrimaryKey(ppmemId);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionMemServiceImpl.getPromotionMemModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotionMem getPromotionMemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionMemMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionMemServiceImpl.getPromotionMemModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionMemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMemMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.delPromotionMemModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.delPromotionMemModelByCode.num");
        }
    }

    private void delPromotionMemModelByPromotionCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionMemMapper.delByPromotionCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.delPromotionMemModelByPromotionCode.ex", (Throwable)e);
        }
    }

    private void deletePromotionMemModel(Integer ppmemId) throws ApiException {
        if (null == ppmemId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMemMapper.deleteByPrimaryKey(ppmemId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.deletePromotionMemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.deletePromotionMemModel.num");
        }
    }

    private void updatePromotionMemModel(PmPromotionMem pmPromotionMem) throws ApiException {
        if (null == pmPromotionMem) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionMemMapper.updateByPrimaryKey(pmPromotionMem);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.updatePromotionMemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.updatePromotionMemModel.num");
        }
    }

    private void updateStatePromotionMemModel(Integer ppmemId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ppmemId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ppmemId", ppmemId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPromotionMemMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.updateStatePromotionMemModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.updateStatePromotionMemModel.null");
        }
    }

    private void updateStatePromotionMemModelByCode(String tenantCode, String ppmemCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ppmemCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppmemCode", ppmemCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPromotionMemMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.updateStatePromotionMemModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.updateStatePromotionMemModelByCode.null");
        }
    }

    private PmPromotionMem makePromotionMem(PmPromotionMemDomain pmPromotionMemDomain, PmPromotionMem pmPromotionMem) {
        if (null == pmPromotionMemDomain) {
            return null;
        }
        if (null == pmPromotionMem) {
            pmPromotionMem = new PmPromotionMem();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionMem, (Object)pmPromotionMemDomain);
            return pmPromotionMem;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionMemServiceImpl.makePromotionMem", (Throwable)e);
            return null;
        }
    }

    private PmPromotionMemReDomain makePmPromotionMemReDomain(PmPromotionMem pmPromotionMem) {
        if (null == pmPromotionMem) {
            return null;
        }
        PmPromotionMemReDomain pmPromotionMemReDomain = new PmPromotionMemReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionMemReDomain, (Object)pmPromotionMem);
            return pmPromotionMemReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionMemServiceImpl.makePmPromotionMemReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotionMem> queryPromotionMemModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionMemMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionMemServiceImpl.queryPromotionMemModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionMem(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionMemMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionMemServiceImpl.countPromotionMem", (Throwable)e);
        }
        return i;
    }

    private PmPromotionMem createPmPromotionMem(PmPromotionMemDomain pmPromotionMemDomain) {
        String msg = this.checkPromotionMem(pmPromotionMemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.savePromotionMem.checkPromotionMem", msg);
        }
        PmPromotionMem pmPromotionMem = this.makePromotionMem(pmPromotionMemDomain, null);
        this.setPromotionMemDefault(pmPromotionMem);
        return pmPromotionMem;
    }

    @Override
    public String savePromotionMem(PmPromotionMemDomain pmPromotionMemDomain) throws ApiException {
        PmPromotionMem pmPromotionMem = this.createPmPromotionMem(pmPromotionMemDomain);
        this.savePromotionMemModel(pmPromotionMem);
        return pmPromotionMem.getPpmemCode();
    }

    @Override
    public String savePromotionMemBatch(List<PmPromotionMemDomain> pmPromotionMemDomainList) throws ApiException {
        if (null == pmPromotionMemDomainList || pmPromotionMemDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotionMem> pmPromotionMemList = new ArrayList<PmPromotionMem>();
        String code = "";
        for (PmPromotionMemDomain pmPromotionMemDomain : pmPromotionMemDomainList) {
            PmPromotionMem pmPromotionMem = this.createPmPromotionMem(pmPromotionMemDomain);
            code = pmPromotionMem.getPpmemCode();
            pmPromotionMemList.add(pmPromotionMem);
        }
        this.savePromotionMemBatchModel(pmPromotionMemList);
        return code;
    }

    @Override
    public void updatePromotionMemState(Integer ppmemId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePromotionMemModel(ppmemId, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionMemStateByCode(String tenantCode, String ppmemCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePromotionMemModelByCode(tenantCode, ppmemCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionMem(PmPromotionMemDomain pmPromotionMemDomain) throws ApiException {
        String msg = this.checkPromotionMem(pmPromotionMemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.updatePromotionMem.checkPromotionMem", msg);
        }
        PmPromotionMem oldPmPromotionMem = this.getPromotionMemModelById(pmPromotionMemDomain.getPpmemId());
        if (null == oldPmPromotionMem) {
            throw new ApiException("pm.PmPromotionMemServiceImpl.updatePromotionMem.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotionMem pmPromotionMem = this.makePromotionMem(pmPromotionMemDomain, oldPmPromotionMem);
        this.setPromotionMemUpdataDefault(pmPromotionMem);
        this.updatePromotionMemModel(pmPromotionMem);
    }

    @Override
    public PmPromotionMem getPromotionMem(Integer ppmemId) {
        return this.getPromotionMemModelById(ppmemId);
    }

    @Override
    public void deletePromotionMem(Integer ppmemId) throws ApiException {
        this.deletePromotionMemModel(ppmemId);
    }

    @Override
    public QueryResult<PmPromotionMem> queryPromotionMemPage(Map<String, Object> map) {
        List<PmPromotionMem> pmPromotionMemList = this.queryPromotionMemModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionMem(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionMemList);
        return queryResult;
    }

    @Override
    public PmPromotionMem getPromotionMemByCode(String tenantCode, String ppmemCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppmemCode", ppmemCode);
        return this.getPromotionMemModelByCode(map);
    }

    @Override
    public void deletePromotionMemByCode(String tenantCode, String ppmemCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppmemCode", ppmemCode);
        this.delPromotionMemModelByCode(map);
    }

    @Override
    public void deletePromotionMemByPromotionCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionMemModelByPromotionCode(map);
    }
}

