/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsTginfoMenuMapper;
import com.yqbsoft.laser.service.portal.dao.CmsTginfoRmenuMapper;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoMenuDomain;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoMenuReDomain;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoRmenuDomain;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoRmenuReDomain;
import com.yqbsoft.laser.service.portal.model.CmsTginfoMenu;
import com.yqbsoft.laser.service.portal.model.CmsTginfoRmenu;
import com.yqbsoft.laser.service.portal.service.CmsTginfoMenuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsTginfoMenuServiceImpl
extends BaseServiceImpl
implements CmsTginfoMenuService {
    private static final String SYS_CODE = "cms.CmsTginfoMenuServiceImpl";
    private CmsTginfoMenuMapper cmsTginfoMenuMapper;
    private CmsTginfoRmenuMapper cmsTginfoRmenuMapper;
    private String cachekey = "cms_tginfo_rmenu_cache";

    public void setCmsTginfoMenuMapper(CmsTginfoMenuMapper cmsTginfoMenuMapper) {
        this.cmsTginfoMenuMapper = cmsTginfoMenuMapper;
    }

    public void setCmsTginfoRmenuMapper(CmsTginfoRmenuMapper cmsTginfoRmenuMapper) {
        this.cmsTginfoRmenuMapper = cmsTginfoRmenuMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsTginfoMenuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTginfoMenu(CmsTginfoMenuDomain cmsTginfoMenuDomain) {
        if (null == cmsTginfoMenuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsTginfoMenuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTginfoMenuDefault(CmsTginfoMenu cmsTginfoMenu) {
        if (null == cmsTginfoMenu) {
            return;
        }
        if (null == cmsTginfoMenu.getDataState()) {
            cmsTginfoMenu.setDataState(0);
        }
        if (null == cmsTginfoMenu.getGmtCreate()) {
            cmsTginfoMenu.setGmtCreate(this.getSysDate());
        }
        cmsTginfoMenu.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsTginfoMenu.getTginfoMenuCode())) {
            cmsTginfoMenu.setTginfoMenuCode(this.createUUIDString());
        }
    }

    private int getTginfoMenuMaxCode() {
        int code = 0;
        try {
            return this.cmsTginfoMenuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.getTginfoMenuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTginfoMenuUpdataDefault(CmsTginfoMenu cmsTginfoMenu) {
        if (null == cmsTginfoMenu) {
            return;
        }
        cmsTginfoMenu.setGmtModified(this.getSysDate());
    }

    private void saveTginfoMenuModel(CmsTginfoMenu cmsTginfoMenu) throws ApiException {
        if (null == cmsTginfoMenu) {
            return;
        }
        try {
            this.cmsTginfoMenuMapper.insert(cmsTginfoMenu);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.saveTginfoMenuModel.ex", (Throwable)e);
        }
    }

    public void saveTginfoMenuBatchModel(List<CmsTginfoMenu> cmsTginfoMenuList) throws ApiException {
        if (null == cmsTginfoMenuList || cmsTginfoMenuList.isEmpty()) {
            return;
        }
        try {
            this.cmsTginfoMenuMapper.insertBatch(cmsTginfoMenuList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.saveTginfoMenuBatchModel.ex", (Throwable)e);
        }
    }

    private CmsTginfoMenu getTginfoMenuModelById(Integer tginfoMenuId) {
        if (null == tginfoMenuId) {
            return null;
        }
        try {
            return this.cmsTginfoMenuMapper.selectByPrimaryKey(tginfoMenuId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.getTginfoMenuModelById", (Throwable)e);
            return null;
        }
    }

    private CmsTginfoMenu getTginfoMenuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsTginfoMenuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.getTginfoMenuModelByCode", (Object)map.toString(), (Throwable)e);
            return null;
        }
    }

    private void delTginfoMenuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoMenuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.delTginfoMenuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.delTginfoMenuModelByCode.num");
        }
    }

    private void deleteTginfoMenuModel(Integer tginfoMenuId) throws ApiException {
        if (null == tginfoMenuId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoMenuMapper.deleteByPrimaryKey(tginfoMenuId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.deleteTginfoMenuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.deleteTginfoMenuModel.num");
        }
    }

    private void updateTginfoMenuModel(CmsTginfoMenu cmsTginfoMenu) throws ApiException {
        if (null == cmsTginfoMenu) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoMenuMapper.updateByPrimaryKeySelective(cmsTginfoMenu);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateTginfoMenuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateTginfoMenuModel.num");
        }
    }

    private void updateStateTginfoMenuModel(Integer tginfoMenuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == tginfoMenuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tginfoMenuId", tginfoMenuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsTginfoMenuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateStateTginfoMenuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateStateTginfoMenuModel.null");
        }
    }

    private void updateStateTginfoMenuModelByCode(String tenantCode, String tginfoMenuCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)tginfoMenuCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoMenuCode", tginfoMenuCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsTginfoMenuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateStateTginfoMenuModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateStateTginfoMenuModelByCode.null");
        }
    }

    private CmsTginfoMenu makeTginfoMenu(CmsTginfoMenuDomain cmsTginfoMenuDomain, CmsTginfoMenu cmsTginfoMenu) {
        if (null == cmsTginfoMenuDomain) {
            return null;
        }
        if (null == cmsTginfoMenu) {
            cmsTginfoMenu = new CmsTginfoMenu();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoMenu, (Object)cmsTginfoMenuDomain);
            return cmsTginfoMenu;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.makeTginfoMenu", (Throwable)e);
            return null;
        }
    }

    private CmsTginfoMenuReDomain makeCmsTginfoMenuReDomain(CmsTginfoMenu cmsTginfoMenu) {
        if (null == cmsTginfoMenu) {
            return null;
        }
        CmsTginfoMenuReDomain cmsTginfoMenuReDomain = new CmsTginfoMenuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoMenuReDomain, (Object)cmsTginfoMenu);
            return cmsTginfoMenuReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.makeCmsTginfoMenuReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsTginfoMenu> queryTginfoMenuModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsTginfoMenuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.queryTginfoMenuModel", (Throwable)e);
            return null;
        }
    }

    private int countTginfoMenu(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsTginfoMenuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.countTginfoMenu", (Throwable)e);
        }
        return i;
    }

    private CmsTginfoMenu createCmsTginfoMenu(CmsTginfoMenuDomain cmsTginfoMenuDomain) {
        String msg = this.checkTginfoMenu(cmsTginfoMenuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.saveTginfoMenu.checkTginfoMenu", msg);
        }
        CmsTginfoMenu cmsTginfoMenu = this.makeTginfoMenu(cmsTginfoMenuDomain, null);
        this.setTginfoMenuDefault(cmsTginfoMenu);
        return cmsTginfoMenu;
    }

    private String checkTginfoRmenu(CmsTginfoRmenuDomain cmsTginfoRmenuDomain) {
        if (null == cmsTginfoRmenuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsTginfoRmenuDomain.getTginfoRmenuName())) {
            msg = msg + "TginfoRmenuName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmsTginfoRmenuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTginfoRmenuDefault(CmsTginfoRmenu cmsTginfoRmenu) {
        if (null == cmsTginfoRmenu) {
            return;
        }
        if (null == cmsTginfoRmenu.getDataState()) {
            cmsTginfoRmenu.setDataState(0);
        }
        if (null == cmsTginfoRmenu.getGmtCreate()) {
            cmsTginfoRmenu.setGmtCreate(this.getSysDate());
        }
        cmsTginfoRmenu.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsTginfoRmenu.getTginfoRmenuCode())) {
            cmsTginfoRmenu.setTginfoRmenuCode(this.createUUIDString());
        }
    }

    private int getTginfoRmenuMaxCode() {
        int code = 0;
        try {
            return this.cmsTginfoRmenuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.getTginfoRmenuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTginfoRmenuUpdataDefault(CmsTginfoRmenu cmsTginfoRmenu) {
        if (null == cmsTginfoRmenu) {
            return;
        }
        cmsTginfoRmenu.setGmtModified(this.getSysDate());
    }

    private void saveTginfoRmenuModel(CmsTginfoRmenu cmsTginfoRmenu) throws ApiException {
        if (null == cmsTginfoRmenu) {
            return;
        }
        try {
            this.cmsTginfoRmenuMapper.insert(cmsTginfoRmenu);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.saveTginfoRmenuModel.ex", (Throwable)e);
        }
    }

    private void saveTginfoRmenuBatchModel(List<CmsTginfoRmenu> cmsTginfoRmenuList) throws ApiException {
        if (null == cmsTginfoRmenuList || cmsTginfoRmenuList.isEmpty()) {
            return;
        }
        try {
            this.cmsTginfoRmenuMapper.insertBatch(cmsTginfoRmenuList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.saveTginfoRmenuBatchModel.ex", (Throwable)e);
        }
    }

    private CmsTginfoRmenu getTginfoRmenuModelById(Integer tginfoRmenuId) {
        if (null == tginfoRmenuId) {
            return null;
        }
        try {
            return this.cmsTginfoRmenuMapper.selectByPrimaryKey(tginfoRmenuId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.getTginfoRmenuModelById", (Throwable)e);
            return null;
        }
    }

    private CmsTginfoRmenu getTginfoRmenuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsTginfoRmenuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.getTginfoRmenuModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTginfoRmenuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.cmsTginfoRmenuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.delTginfoRmenuModelByCode.ex", (Throwable)e);
        }
    }

    private void deleteTginfoRmenuModel(Integer tginfoRmenuId) throws ApiException {
        if (null == tginfoRmenuId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoRmenuMapper.deleteByPrimaryKey(tginfoRmenuId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.deleteTginfoRmenuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.deleteTginfoRmenuModel.num");
        }
    }

    private void updateTginfoRmenuModel(CmsTginfoRmenu cmsTginfoRmenu) throws ApiException {
        if (null == cmsTginfoRmenu) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoRmenuMapper.updateByPrimaryKeySelective(cmsTginfoRmenu);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateTginfoRmenuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateTginfoRmenuModel.num");
        }
    }

    private void updateStateTginfoRmenuModel(Integer tginfoRmenuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == tginfoRmenuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tginfoRmenuId", tginfoRmenuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsTginfoRmenuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateStateTginfoRmenuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateStateTginfoRmenuModel.null");
        }
    }

    private void updateStateTginfoRmenuModelByCode(String tenantCode, String tginfoRmenuCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)tginfoRmenuCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoRmenuCode", tginfoRmenuCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsTginfoRmenuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateStateTginfoRmenuModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateStateTginfoRmenuModelByCode.null");
        }
    }

    private CmsTginfoRmenu makeTginfoRmenu(CmsTginfoRmenuDomain cmsTginfoRmenuDomain, CmsTginfoRmenu cmsTginfoRmenu) {
        if (null == cmsTginfoRmenuDomain) {
            return null;
        }
        if (null == cmsTginfoRmenu) {
            cmsTginfoRmenu = new CmsTginfoRmenu();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoRmenu, (Object)cmsTginfoRmenuDomain);
            return cmsTginfoRmenu;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.makeTginfoRmenu", (Throwable)e);
            return null;
        }
    }

    private CmsTginfoRmenuReDomain makeCmsTginfoRmenuReDomain(CmsTginfoRmenu cmsTginfoRmenu) {
        if (null == cmsTginfoRmenu) {
            return null;
        }
        CmsTginfoRmenuReDomain cmsTginfoRmenuReDomain = new CmsTginfoRmenuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoRmenuReDomain, (Object)cmsTginfoRmenu);
            return cmsTginfoRmenuReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.makeCmsTginfoRmenuReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsTginfoRmenu> queryTginfoRmenuModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsTginfoRmenuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.queryTginfoRmenuModel", (Throwable)e);
            return null;
        }
    }

    private int countTginfoRmenu(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsTginfoRmenuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoMenuServiceImpl.countTginfoRmenu", (Throwable)e);
        }
        return i;
    }

    private CmsTginfoRmenu createCmsTginfoRmenu(CmsTginfoRmenuDomain cmsTginfoRmenuDomain) {
        String msg = this.checkTginfoRmenu(cmsTginfoRmenuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.saveTginfoRmenu.checkTginfoRmenu", msg);
        }
        CmsTginfoRmenu cmsTginfoRmenu = this.makeTginfoRmenu(cmsTginfoRmenuDomain, null);
        this.setTginfoRmenuDefault(cmsTginfoRmenu);
        return cmsTginfoRmenu;
    }

    @Override
    public String saveTginfoMenu(CmsTginfoMenuDomain cmsTginfoMenuDomain) throws ApiException {
        CmsTginfoMenu cmsTginfoMenu = this.createCmsTginfoMenu(cmsTginfoMenuDomain);
        this.saveTginfoMenuModel(cmsTginfoMenu);
        this.saveTginfoMenuChildren(cmsTginfoMenu, cmsTginfoMenuDomain.getCmsTginfoMenuDomainList());
        return cmsTginfoMenu.getTginfoMenuCode();
    }

    @Override
    public String saveTginfoMenuMode(CmsTginfoMenu cmsTginfoMenu) throws ApiException {
        this.setTginfoMenuDefault(cmsTginfoMenu);
        this.saveTginfoMenuModel(cmsTginfoMenu);
        return cmsTginfoMenu.getTginfoMenuCode();
    }

    private void saveTginfoMenuChildren(CmsTginfoMenu cmsTginfoMenu, List<CmsTginfoMenuDomain> cmsTginfoMenuDomainList) {
        if (ListUtil.isEmpty(cmsTginfoMenuDomainList) || null == cmsTginfoMenu) {
            return;
        }
        for (CmsTginfoMenuDomain cmsTginfoMenuDomain : cmsTginfoMenuDomainList) {
            cmsTginfoMenuDomain.setTenantCode(cmsTginfoMenu.getTenantCode());
            cmsTginfoMenuDomain.setTginfoMenuPcode(cmsTginfoMenu.getTginfoMenuCode());
            this.saveTginfoMenu(cmsTginfoMenuDomain);
        }
    }

    @Override
    public String saveTginfoMenuBatch(List<CmsTginfoMenuDomain> cmsTginfoMenuDomainList) throws ApiException {
        if (null == cmsTginfoMenuDomainList || cmsTginfoMenuDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (CmsTginfoMenuDomain cmsTginfoMenuDomain : cmsTginfoMenuDomainList) {
            code = this.saveTginfoMenu(cmsTginfoMenuDomain);
            this.updateTginfoMenuStateByCode(cmsTginfoMenuDomain.getTenantCode(), code, 2, 0);
            CmsTginfoMenu cmsTginfoMenu = this.makeTginfoMenu(cmsTginfoMenuDomain, null);
            cmsTginfoMenu.setTginfoMenuCode(code);
            if (!StringUtils.isNotBlank((String)cmsTginfoMenu.getMenuCode()) || !StringUtils.isNotBlank((String)cmsTginfoMenu.getMenuDetailsCode()) && !StringUtils.isNotBlank((String)cmsTginfoMenu.getMenuIndexCode())) continue;
            this.updateReleaseHtml(cmsTginfoMenu);
        }
        return code;
    }

    @Override
    public void updateTginfoMenuState(Integer tginfoMenuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTginfoMenuModel(tginfoMenuId, dataState, oldDataState);
        if (2 == dataState) {
            CmsTginfoMenu cmsTginfoMenu = this.getTginfoMenu(tginfoMenuId);
            this.saveRmenu(cmsTginfoMenu);
        }
    }

    @Override
    public void updateTginfoMenuStateByCode(String tenantCode, String tginfoMenuCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTginfoMenuModelByCode(tenantCode, tginfoMenuCode, dataState, oldDataState);
        if (2 == dataState) {
            CmsTginfoMenu cmsTginfoMenu = this.getTginfoMenuByCode(tenantCode, tginfoMenuCode);
            this.saveRmenu(cmsTginfoMenu);
        }
    }

    private void saveRmenu(CmsTginfoMenu cmsTginfoMenu) {
        if (null == cmsTginfoMenu) {
            return;
        }
        CmsTginfoRmenuDomain cmsTginfoRmenuDomain = new CmsTginfoRmenuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoRmenuDomain, (Object)cmsTginfoMenu);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.saveRmenu.ex", (Throwable)e);
        }
        cmsTginfoRmenuDomain.setTginfoRmenuCode(cmsTginfoMenu.getTginfoMenuCode());
        cmsTginfoRmenuDomain.setTginfoRmenuPcode(cmsTginfoMenu.getTginfoMenuPcode());
        cmsTginfoRmenuDomain.setTginfoRmenuName(cmsTginfoMenu.getTginfoMenuName());
        cmsTginfoRmenuDomain.setTginfoRmenuOrder(cmsTginfoMenu.getTginfoMenuOrder());
        cmsTginfoRmenuDomain.setTginfoRmenuRemark(cmsTginfoMenu.getTginfoMenuRemark());
        this.deleteTginfoRmenuByCode(cmsTginfoRmenuDomain.getTenantCode(), cmsTginfoRmenuDomain.getTginfoRmenuCode());
        this.saveTginfoRmenu(cmsTginfoRmenuDomain);
    }

    @Override
    public void updateTginfoMenu(CmsTginfoMenuDomain cmsTginfoMenuDomain) throws ApiException {
        String msg = this.checkTginfoMenu(cmsTginfoMenuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateTginfoMenu.checkTginfoMenu", msg);
        }
        CmsTginfoMenu oldCmsTginfoMenu = this.getTginfoMenuModelById(cmsTginfoMenuDomain.getTginfoMenuId());
        if (null == oldCmsTginfoMenu) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateTginfoMenu.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsTginfoMenu cmsTginfoMenu = this.makeTginfoMenu(cmsTginfoMenuDomain, oldCmsTginfoMenu);
        this.setTginfoMenuUpdataDefault(cmsTginfoMenu);
        this.updateTginfoMenuModel(cmsTginfoMenu);
    }

    @Override
    public CmsTginfoMenu getTginfoMenu(Integer tginfoMenuId) {
        return this.getTginfoMenuModelById(tginfoMenuId);
    }

    @Override
    public void deleteTginfoMenu(Integer tginfoMenuId) throws ApiException {
        CmsTginfoMenu cmsTginfoMenu = this.getTginfoMenu(tginfoMenuId);
        if (null == cmsTginfoMenu) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.deleteTginfoMenu.cmsTginfoMenu", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteTginfoMenuModel(tginfoMenuId);
        this.updateDelCache(cmsTginfoMenu);
    }

    @Override
    public QueryResult<CmsTginfoMenu> queryTginfoMenuPage(Map<String, Object> map) {
        List<CmsTginfoMenu> cmsTginfoMenuList = this.queryTginfoMenuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTginfoMenu(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsTginfoMenuList);
        return queryResult;
    }

    @Override
    public CmsTginfoMenu getTginfoMenuByCode(String tenantCode, String tginfoMenuCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoMenuCode", tginfoMenuCode);
        return this.getTginfoMenuModelByCode(map);
    }

    @Override
    public void deleteTginfoMenuByCode(String tenantCode, String tginfoMenuCode) throws ApiException {
        CmsTginfoMenu cmsTginfoMenu = this.getTginfoMenuByCode(tenantCode, tginfoMenuCode);
        if (null == cmsTginfoMenu) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.deleteTginfoMenuByCode.cmsTginfoMenu", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoMenuCode", tginfoMenuCode);
        this.delTginfoMenuModelByCode(map);
        this.updateDelCache(cmsTginfoMenu);
    }

    private void updateDelCache(CmsTginfoMenu cmsTginfoMenu) {
        if (null == cmsTginfoMenu) {
            return;
        }
        CmsTginfoRmenu cmsTginfoRmenu = this.getTginfoRmenuByCode(cmsTginfoMenu.getTenantCode(), cmsTginfoMenu.getTginfoMenuCode());
        if (null == cmsTginfoRmenu) {
            return;
        }
        this.updateCache(cmsTginfoRmenu, true);
    }

    private void updateCache(CmsTginfoRmenu cmsTginfoRmenu, boolean del) {
        List cachermenuList;
        if (null == cmsTginfoRmenu) {
            return;
        }
        String json = DisUtil.getMap((String)this.cachekey, (String)(cmsTginfoRmenu.getTginfoCode() + "-" + cmsTginfoRmenu.getTenantCode()));
        if (StringUtils.isNotBlank((String)json) && null != (cachermenuList = JsonUtil.buildNormalBinder().getJsonToList(json, CmsTginfoRmenuReDomain.class)) && !cachermenuList.isEmpty()) {
            this.updateCache(cmsTginfoRmenu, cachermenuList, del);
            DisUtil.setMap((String)this.cachekey, (String)(cmsTginfoRmenu.getTginfoCode() + "-" + cmsTginfoRmenu.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)cachermenuList));
        }
    }

    @Override
    public String saveTginfoRmenu(CmsTginfoRmenuDomain cmsTginfoRmenuDomain) throws ApiException {
        CmsTginfoRmenu cmsTginfoRmenu = this.createCmsTginfoRmenu(cmsTginfoRmenuDomain);
        this.saveTginfoRmenuModel(cmsTginfoRmenu);
        this.updateCache(cmsTginfoRmenu, false);
        return cmsTginfoRmenu.getTginfoRmenuCode();
    }

    private void updateCache(CmsTginfoRmenu cmsTginfoRmenu, List<CmsTginfoRmenuReDomain> cachermenuList, boolean del) {
        if (null == cmsTginfoRmenu || null == cachermenuList || cachermenuList.isEmpty()) {
            return;
        }
        for (CmsTginfoRmenuReDomain cmsTginfoRmenuReDomain : cachermenuList) {
            if (cmsTginfoRmenuReDomain.getTginfoRmenuCode().equals(cmsTginfoRmenu.getTginfoRmenuCode()) && cmsTginfoRmenuReDomain.getTenantCode().equals(cmsTginfoRmenu.getTenantCode())) {
                if (del) {
                    cachermenuList.remove(cmsTginfoRmenuReDomain);
                } else {
                    try {
                        BeanUtils.copyAllPropertys((Object)cmsTginfoRmenuReDomain, (Object)cmsTginfoRmenu);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return;
            }
            this.updateCache(cmsTginfoRmenu, cmsTginfoRmenuReDomain.getChildren(), del);
        }
    }

    @Override
    public String saveTginfoRmenuBatch(List<CmsTginfoRmenuDomain> cmsTginfoRmenuDomainList) throws ApiException {
        if (null == cmsTginfoRmenuDomainList || cmsTginfoRmenuDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsTginfoRmenu> cmsTginfoRmenuList = new ArrayList<CmsTginfoRmenu>();
        String code = "";
        for (CmsTginfoRmenuDomain cmsTginfoRmenuDomain : cmsTginfoRmenuDomainList) {
            CmsTginfoRmenu cmsTginfoRmenu = this.createCmsTginfoRmenu(cmsTginfoRmenuDomain);
            code = cmsTginfoRmenu.getTginfoRmenuCode();
            cmsTginfoRmenuList.add(cmsTginfoRmenu);
        }
        this.saveTginfoRmenuBatchModel(cmsTginfoRmenuList);
        return code;
    }

    @Override
    public void updateTginfoRmenuState(Integer tginfoRmenuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTginfoRmenuModel(tginfoRmenuId, dataState, oldDataState);
    }

    @Override
    public void updateTginfoRmenuStateByCode(String tenantCode, String tginfoRmenuCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTginfoRmenuModelByCode(tenantCode, tginfoRmenuCode, dataState, oldDataState);
    }

    @Override
    public void updateTginfoRmenu(CmsTginfoRmenuDomain cmsTginfoRmenuDomain) throws ApiException {
        String msg = this.checkTginfoRmenu(cmsTginfoRmenuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateTginfoRmenu.checkTginfoRmenu", msg);
        }
        CmsTginfoRmenu oldCmsTginfoRmenu = this.getTginfoRmenuModelById(cmsTginfoRmenuDomain.getTginfoRmenuId());
        if (null == oldCmsTginfoRmenu) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateTginfoRmenu.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsTginfoRmenu cmsTginfoRmenu = this.makeTginfoRmenu(cmsTginfoRmenuDomain, oldCmsTginfoRmenu);
        this.setTginfoRmenuUpdataDefault(cmsTginfoRmenu);
        this.updateTginfoRmenuModel(cmsTginfoRmenu);
        this.updateCache(cmsTginfoRmenu, false);
    }

    @Override
    public CmsTginfoRmenu getTginfoRmenu(Integer tginfoRmenuId) {
        return this.getTginfoRmenuModelById(tginfoRmenuId);
    }

    @Override
    public void deleteTginfoRmenu(Integer tginfoRmenuId) throws ApiException {
        this.deleteTginfoRmenuModel(tginfoRmenuId);
    }

    @Override
    public QueryResult<CmsTginfoRmenu> queryTginfoRmenuPage(Map<String, Object> map) {
        List<CmsTginfoRmenu> cmsTginfoRmenuList = this.queryTginfoRmenuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTginfoRmenu(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsTginfoRmenuList);
        return queryResult;
    }

    @Override
    public CmsTginfoRmenu getTginfoRmenuByCode(String tenantCode, String tginfoRmenuCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoRmenuCode", tginfoRmenuCode);
        return this.getTginfoRmenuModelByCode(map);
    }

    @Override
    public void deleteTginfoRmenuByCode(String tenantCode, String tginfoRmenuCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoRmenuCode", tginfoRmenuCode);
        this.delTginfoRmenuModelByCode(map);
    }

    @Override
    public List<CmsTginfoMenuReDomain> queryTginfoMenuTree(String tenantCode, String tginfoCode) throws ApiException {
        if (StringUtils.isBlank((String)tginfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoCode", tginfoCode);
        map.put("tginfoMenuPcode", "-1");
        List<CmsTginfoMenu> menulist = this.queryTginfoMenuModelPage(map);
        if (ListUtil.isEmpty(menulist)) {
            return null;
        }
        ArrayList<CmsTginfoMenuReDomain> relist = new ArrayList<CmsTginfoMenuReDomain>();
        for (CmsTginfoMenu cmsTginfoMenu : menulist) {
            CmsTginfoMenuReDomain cmsTginfoMenuReDomain = this.makeMenu(cmsTginfoMenu);
            this.makeMenuChild(cmsTginfoMenuReDomain);
            relist.add(cmsTginfoMenuReDomain);
        }
        return relist;
    }

    @Override
    public void loadcache() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tginfoRmenuPcode", "-1");
        List<CmsTginfoRmenu> rmenulist = this.queryTginfoRmenuModelPage(map);
        if (rmenulist == null || rmenulist.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        HashMap menumap = new HashMap();
        for (CmsTginfoRmenu cmsTginfoRmenu : rmenulist) {
            String mkey = cmsTginfoRmenu.getTginfoCode() + "-" + cmsTginfoRmenu.getTenantCode();
            CmsTginfoRmenuReDomain cmsTginfoRmenuReDomain = this.make(cmsTginfoRmenu);
            this.makeChild(cmsTginfoRmenuReDomain);
            ArrayList<CmsTginfoRmenuReDomain> cachermenuList = (ArrayList<CmsTginfoRmenuReDomain>)menumap.get(mkey);
            if (null == cachermenuList) {
                cachermenuList = new ArrayList<CmsTginfoRmenuReDomain>();
                menumap.put(mkey, cachermenuList);
            }
            if (null == cmsTginfoRmenuReDomain) continue;
            cachermenuList.add(cmsTginfoRmenuReDomain);
        }
        if (null == menumap || menumap.isEmpty()) {
            return;
        }
        for (String key : menumap.keySet()) {
            mmap.put(key, JsonUtil.buildNormalBinder().toJson(menumap.get(key)));
        }
        DisUtil.setMap((String)this.cachekey, mmap);
    }

    private void makeChild(CmsTginfoRmenuReDomain cmsTginfoRmenuReDomain) {
        if (null == cmsTginfoRmenuReDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tginfoRmenuPcode", cmsTginfoRmenuReDomain.getTginfoRmenuCode());
        map.put("tenantCode", cmsTginfoRmenuReDomain.getTenantCode());
        List<CmsTginfoRmenu> rmenulist = this.queryTginfoRmenuModelPage(map);
        if (rmenulist == null || rmenulist.isEmpty()) {
            return;
        }
        cmsTginfoRmenuReDomain.setChildren(this.makeChildList(rmenulist));
    }

    private List<CmsTginfoMenuReDomain> makeMenuChildList(List<CmsTginfoMenu> rmenulist) {
        if (rmenulist == null || rmenulist.isEmpty()) {
            return null;
        }
        ArrayList<CmsTginfoMenuReDomain> cachermenuList = new ArrayList<CmsTginfoMenuReDomain>();
        for (CmsTginfoMenu cmsTginfoRmenu : rmenulist) {
            CmsTginfoMenuReDomain cmsTginfoRmenuReDomain = this.makeMenu(cmsTginfoRmenu);
            this.makeMenuChild(cmsTginfoRmenuReDomain);
            if (null == cmsTginfoRmenuReDomain) continue;
            cachermenuList.add(cmsTginfoRmenuReDomain);
        }
        return cachermenuList;
    }

    private void makeMenuChild(CmsTginfoMenuReDomain cmsTginfoMenuReDomain) {
        if (null == cmsTginfoMenuReDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tginfoMenuPcode", cmsTginfoMenuReDomain.getTginfoMenuCode());
        map.put("tenantCode", cmsTginfoMenuReDomain.getTenantCode());
        List<CmsTginfoMenu> rmenulist = this.queryTginfoMenuModelPage(map);
        if (rmenulist == null || rmenulist.isEmpty()) {
            return;
        }
        cmsTginfoMenuReDomain.setChildren(this.makeMenuChildList(rmenulist));
    }

    private List<CmsTginfoRmenuReDomain> makeChildList(List<CmsTginfoRmenu> rmenulist) {
        if (rmenulist == null || rmenulist.isEmpty()) {
            return null;
        }
        ArrayList<CmsTginfoRmenuReDomain> cachermenuList = new ArrayList<CmsTginfoRmenuReDomain>();
        for (CmsTginfoRmenu cmsTginfoRmenu : rmenulist) {
            CmsTginfoRmenuReDomain cmsTginfoRmenuReDomain = this.make(cmsTginfoRmenu);
            this.makeChild(cmsTginfoRmenuReDomain);
            if (null == cmsTginfoRmenuReDomain) continue;
            cachermenuList.add(cmsTginfoRmenuReDomain);
        }
        return cachermenuList;
    }

    private CmsTginfoRmenuReDomain make(CmsTginfoRmenu cmsTginfoRmenu) {
        if (null == cmsTginfoRmenu) {
            return null;
        }
        CmsTginfoRmenuReDomain cmsTginfoRmenuReDomain = new CmsTginfoRmenuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoRmenuReDomain, (Object)cmsTginfoRmenu);
            return cmsTginfoRmenuReDomain;
        }
        catch (Exception e) {
            return null;
        }
    }

    private CmsTginfoMenuReDomain makeMenu(CmsTginfoMenu cmsTginfoMenu) {
        if (null == cmsTginfoMenu) {
            return null;
        }
        CmsTginfoMenuReDomain cmsTginfoMenuReDomain = new CmsTginfoMenuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoMenuReDomain, (Object)cmsTginfoMenu);
            return cmsTginfoMenuReDomain;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void updateTginfoMenuRel(Integer tginfoMenuId) {
        CmsTginfoMenu cmsTginfoMenu = this.getTginfoMenuModelById(tginfoMenuId);
        if (null == cmsTginfoMenu) {
            throw new ApiException("cms.CmsTginfoMenuServiceImpl.updateTginfoMenuRel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateReleaseHtml(cmsTginfoMenu);
    }

    private void updateReleaseHtml(CmsTginfoMenu cmsTginfoMenu) {
        String[] atcionS;
        String[] atcionS2;
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("htmldataMenutype", "TGM");
        params.put("htmldataMenu", cmsTginfoMenu.getTginfoMenuCode());
        params.put("htmldataCode", "CmsTginfoMenu");
        params.put("tenantCode", cmsTginfoMenu.getTenantCode());
        String filename = "";
        if (StringUtils.isNotBlank((String)cmsTginfoMenu.getMenuAction()) && StringUtils.isNotBlank((String)(filename = (atcionS2 = cmsTginfoMenu.getMenuAction().split("/"))[atcionS2.length - 1])) && filename.indexOf("${htmldataFilename}") >= 0) {
            filename = filename.replace("${htmldataFilename}", cmsTginfoMenu.getMenuCode());
        }
        String filepath = "";
        if (StringUtils.isNotBlank((String)cmsTginfoMenu.getMenuJspath()) && StringUtils.isNotBlank((String)(filepath = (atcionS = cmsTginfoMenu.getMenuJspath().split("/"))[atcionS.length - 1])) && filepath.indexOf("${htmldataFilepath}") >= 0) {
            filepath = filepath.replace("${htmldataFilepath}", cmsTginfoMenu.getMenuCode());
        }
        if (StringUtils.isBlank((String)filename)) {
            return;
        }
        params.put("htmldataFilename", filename);
        params.put("htmlcontOpparam", JsonUtil.buildNormalBinder().toJson((Object)cmsTginfoMenu));
        params.put("htmldataFilepath", filepath);
        map.put("htmlRelease", JsonUtil.buildNormalBinder().toJson(params));
        this.internalInvoke("pfs.htmlcont.sendHtmlcontOpData", map);
    }

    @Override
    public List<CmsTginfoRmenu> queryTginfoRmenuByOpcode(String tenantCode, String menuOpcode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("menuOpcode", menuOpcode);
        map.put("tenantCode", tenantCode);
        List<CmsTginfoRmenu> rmenuList = this.queryTginfoRmenuModelPage(map);
        return rmenuList;
    }
}

