/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtPotentialFeeMapper;
import com.yqbsoft.laser.service.potential.domain.PtPotentialFeeDomain;
import com.yqbsoft.laser.service.potential.domain.PtPotentialFeeReDomain;
import com.yqbsoft.laser.service.potential.enums.PotentialCustomerStatus;
import com.yqbsoft.laser.service.potential.enums.PotentialLevel;
import com.yqbsoft.laser.service.potential.model.PtPotential;
import com.yqbsoft.laser.service.potential.model.PtPotentialFee;
import com.yqbsoft.laser.service.potential.service.PtPotentialFeeService;
import com.yqbsoft.laser.service.potential.service.PtPotentialService;
import com.yqbsoft.laser.service.potential.utils.NumberUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtPotentialFeeServiceImpl
extends BaseServiceImpl
implements PtPotentialFeeService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtPotentialFeeServiceImpl";
    private PtPotentialFeeMapper ptPotentialFeeMapper;
    private PtPotentialService ptPotentialService;

    public void setPtPotentialService(PtPotentialService ptPotentialService) {
        this.ptPotentialService = ptPotentialService;
    }

    public void setPtPotentialFeeMapper(PtPotentialFeeMapper ptPotentialFeeMapper) {
        this.ptPotentialFeeMapper = ptPotentialFeeMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptPotentialFeeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialFeeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtPotentialFee(PtPotentialFeeDomain ptPotentialFeeDomain) {
        if (null == ptPotentialFeeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ptPotentialFeeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtPotentialFeeDefault(PtPotentialFee ptPotentialFee) {
        if (null == ptPotentialFee) {
            return;
        }
        if (null == ptPotentialFee.getDataState()) {
            ptPotentialFee.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ptPotentialFee.getGmtCreate()) {
            ptPotentialFee.setGmtCreate(date);
        }
        ptPotentialFee.setGmtModified(date);
        if (StringUtils.isBlank((String)ptPotentialFee.getPotentialFeeCode())) {
            ptPotentialFee.setPotentialFeeCode(this.getNo(null, "PtPotentialFee", "ptPotentialFee", ptPotentialFee.getTenantCode()));
        }
    }

    private int getPtPotentialFeeMaxCode() {
        int code = 0;
        try {
            return this.ptPotentialFeeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialFeeServiceImpl.getPtPotentialFeeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtPotentialFeeUpdataDefault(PtPotentialFee ptPotentialFee) {
        if (null == ptPotentialFee) {
            return;
        }
        ptPotentialFee.setGmtModified(this.getSysDate());
    }

    private void savePtPotentialFeeModel(PtPotentialFee ptPotentialFee) throws ApiException {
        if (null == ptPotentialFee) {
            return;
        }
        try {
            int insertRow = this.ptPotentialFeeMapper.insert(ptPotentialFee);
            this.logger.error("savePtPotentialFeeModel, insertRow" + insertRow);
            if (PotentialLevel.LEVEL_TWO.getCode() != NumberUtil.intValue(ptPotentialFee.getPotentialLevel())) {
                return;
            }
            PtPotential ptPotential = this.ptPotentialService.getPtPotentialByCode(ptPotentialFee.getTenantCode(), ptPotentialFee.getPotentialCode());
            this.logger.error("savePtPotentialFeeModel, ptPotential" + JSON.toJSONString((Object)ptPotential));
            if (null != ptPotential && insertRow > 0) {
                this.logger.error("savePtPotentialFeeModel, updatePtPotentialCustomerStatus" + JSON.toJSONString((Object)ptPotential));
                this.ptPotentialService.updatePtPotentialCustomerStatus(ptPotential.getPotentialId(), PotentialCustomerStatus.PENDING_PAY_INTENT_DEPOSIT.getCode(), ptPotential.getDataState(), Maps.newHashMap());
            }
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.savePtPotentialFeeModel.ex", (Throwable)e);
        }
    }

    private void savePtPotentialFeeBatchModel(List<PtPotentialFee> ptPotentialFeeList) throws ApiException {
        if (null == ptPotentialFeeList || ptPotentialFeeList.isEmpty()) {
            return;
        }
        try {
            this.ptPotentialFeeMapper.insertBatch(ptPotentialFeeList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.savePtPotentialFeeBatchModel.ex", (Throwable)e);
        }
    }

    private PtPotentialFee getPtPotentialFeeModelById(Integer potentialFeeId) {
        if (null == potentialFeeId) {
            return null;
        }
        try {
            return this.ptPotentialFeeMapper.selectByPrimaryKey(potentialFeeId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialFeeServiceImpl.getPtPotentialFeeModelById", (Throwable)e);
            return null;
        }
    }

    private PtPotentialFee getPtPotentialFeeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptPotentialFeeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialFeeServiceImpl.getPtPotentialFeeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtPotentialFeeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptPotentialFeeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.delPtPotentialFeeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.delPtPotentialFeeModelByCode.num");
        }
    }

    private void deletePtPotentialFeeModel(Integer potentialFeeId) throws ApiException {
        if (null == potentialFeeId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptPotentialFeeMapper.deleteByPrimaryKey(potentialFeeId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.deletePtPotentialFeeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.deletePtPotentialFeeModel.num");
        }
    }

    private void updatePtPotentialFeeModel(PtPotentialFee ptPotentialFee) throws ApiException {
        if (null == ptPotentialFee) {
            return;
        }
        int i = 0;
        try {
            i = this.ptPotentialFeeMapper.updateByPrimaryKey(ptPotentialFee);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.updatePtPotentialFeeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.updatePtPotentialFeeModel.num");
        }
    }

    private void updateStatePtPotentialFeeModel(Integer potentialFeeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == potentialFeeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("potentialFeeId", potentialFeeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptPotentialFeeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.updateStatePtPotentialFeeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.updateStatePtPotentialFeeModel.null");
        }
    }

    private void updateStatePtPotentialFeeModelByCode(String tenantCode, String potentialFeeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)potentialFeeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("potentialFeeCode", potentialFeeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptPotentialFeeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.updateStatePtPotentialFeeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.updateStatePtPotentialFeeModelByCode.null");
        }
    }

    private PtPotentialFee makePtPotentialFee(PtPotentialFeeDomain ptPotentialFeeDomain, PtPotentialFee ptPotentialFee) {
        if (null == ptPotentialFeeDomain) {
            return null;
        }
        if (null == ptPotentialFee) {
            ptPotentialFee = new PtPotentialFee();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ptPotentialFee, (Object)ptPotentialFeeDomain);
            return ptPotentialFee;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialFeeServiceImpl.makePtPotentialFee", (Throwable)e);
            return null;
        }
    }

    private PtPotentialFeeReDomain makePtPotentialFeeReDomain(PtPotentialFee ptPotentialFee) {
        if (null == ptPotentialFee) {
            return null;
        }
        PtPotentialFeeReDomain ptPotentialFeeReDomain = new PtPotentialFeeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptPotentialFeeReDomain, (Object)ptPotentialFee);
            return ptPotentialFeeReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialFeeServiceImpl.makePtPotentialFeeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtPotentialFee> queryPtPotentialFeeModelPage(Map<String, Object> parammap) {
        try {
            return this.ptPotentialFeeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialFeeServiceImpl.queryPtPotentialFeeModel", (Throwable)e);
            return null;
        }
    }

    private int countPtPotentialFee(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptPotentialFeeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialFeeServiceImpl.countPtPotentialFee", (Throwable)e);
        }
        return i;
    }

    private PtPotentialFee createPtPotentialFee(PtPotentialFeeDomain ptPotentialFeeDomain) {
        String msg = this.checkPtPotentialFee(ptPotentialFeeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.savePtPotentialFee.checkPtPotentialFee", msg);
        }
        PtPotentialFee ptPotentialFee = this.makePtPotentialFee(ptPotentialFeeDomain, null);
        this.setPtPotentialFeeDefault(ptPotentialFee);
        return ptPotentialFee;
    }

    @Override
    public String savePtPotentialFee(PtPotentialFeeDomain ptPotentialFeeDomain) throws ApiException {
        PtPotentialFee ptPotentialFee = this.createPtPotentialFee(ptPotentialFeeDomain);
        this.savePtPotentialFeeModel(ptPotentialFee);
        return ptPotentialFee.getPotentialFeeCode();
    }

    @Override
    public String savePtPotentialFeeBatch(List<PtPotentialFeeDomain> ptPotentialFeeDomainList) throws ApiException {
        if (null == ptPotentialFeeDomainList || ptPotentialFeeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtPotentialFee> ptPotentialFeeList = new ArrayList<PtPotentialFee>();
        String code = "";
        for (PtPotentialFeeDomain ptPotentialFeeDomain : ptPotentialFeeDomainList) {
            PtPotentialFee ptPotentialFee = this.createPtPotentialFee(ptPotentialFeeDomain);
            code = ptPotentialFee.getPotentialFeeCode();
            ptPotentialFeeList.add(ptPotentialFee);
        }
        this.savePtPotentialFeeBatchModel(ptPotentialFeeList);
        return code;
    }

    @Override
    public void updatePtPotentialFeeState(Integer potentialFeeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == potentialFeeId) {
            return;
        }
        this.updateStatePtPotentialFeeModel(potentialFeeId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtPotentialFeeStateByCode(String tenantCode, String potentialFeeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)potentialFeeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtPotentialFeeModelByCode(tenantCode, potentialFeeCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtPotentialFee(PtPotentialFeeDomain ptPotentialFeeDomain) throws ApiException {
        String msg = this.checkPtPotentialFee(ptPotentialFeeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.updatePtPotentialFee.checkPtPotentialFee", msg);
        }
        PtPotentialFee oldPtPotentialFee = this.getPtPotentialFeeModelById(ptPotentialFeeDomain.getPotentialFeeId());
        if (null == oldPtPotentialFee) {
            throw new ApiException("pt.POTENTIAL.PtPotentialFeeServiceImpl.updatePtPotentialFee.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtPotentialFee ptPotentialFee = this.makePtPotentialFee(ptPotentialFeeDomain, oldPtPotentialFee);
        this.setPtPotentialFeeUpdataDefault(ptPotentialFee);
        this.updatePtPotentialFeeModel(ptPotentialFee);
    }

    @Override
    public PtPotentialFee getPtPotentialFee(Integer potentialFeeId) {
        if (null == potentialFeeId) {
            return null;
        }
        return this.getPtPotentialFeeModelById(potentialFeeId);
    }

    @Override
    public void deletePtPotentialFee(Integer potentialFeeId) throws ApiException {
        if (null == potentialFeeId) {
            return;
        }
        this.deletePtPotentialFeeModel(potentialFeeId);
    }

    @Override
    public QueryResult<PtPotentialFee> queryPtPotentialFeePage(Map<String, Object> map) {
        List<PtPotentialFee> ptPotentialFeeList = this.queryPtPotentialFeeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtPotentialFee(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptPotentialFeeList);
        return queryResult;
    }

    @Override
    public PtPotentialFee getPtPotentialFeeByCode(String tenantCode, String potentialFeeCode) throws ApiException {
        if (StringUtils.isBlank((String)potentialFeeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("potentialFeeCode", potentialFeeCode);
        return this.getPtPotentialFeeModelByCode(map);
    }

    @Override
    public void deletePtPotentialFeeByCode(String tenantCode, String potentialFeeCode) throws ApiException {
        if (StringUtils.isBlank((String)potentialFeeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("potentialFeeCode", potentialFeeCode);
        this.delPtPotentialFeeModelByCode(map);
    }
}

