/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtStoreCloseMapper;
import com.yqbsoft.laser.service.potential.domain.PtStoreCloseDomain;
import com.yqbsoft.laser.service.potential.domain.PtStoreCloseReDomain;
import com.yqbsoft.laser.service.potential.model.PtStoreClose;
import com.yqbsoft.laser.service.potential.model.UmUserinfo;
import com.yqbsoft.laser.service.potential.service.PtStoreCloseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;

public class PtStoreCloseServiceImpl
extends BaseServiceImpl
implements PtStoreCloseService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtStoreCloseServiceImpl";
    @Value(value="${spring.restTemp.isTest:false}")
    private boolean isTest;
    private PtStoreCloseMapper ptStoreCloseMapper;

    public void setPtStoreCloseMapper(PtStoreCloseMapper ptStoreCloseMapper) {
        this.ptStoreCloseMapper = ptStoreCloseMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptStoreCloseMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreCloseServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtStoreClose(PtStoreCloseDomain domain) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    private void setPtStoreCloseDefault(PtStoreClose ptStoreClose) {
        if (null == ptStoreClose) {
            return;
        }
        if (null == ptStoreClose.getDataState()) {
            ptStoreClose.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ptStoreClose.getGmtCreate()) {
            ptStoreClose.setGmtCreate(date);
        }
        ptStoreClose.setGmtModified(date);
        if (StringUtils.isBlank((String)ptStoreClose.getStoreCloseCode())) {
            ptStoreClose.setStoreCloseCode(this.getDefaultCode(ptStoreClose.getTenantCode()));
        }
    }

    private String getDefaultCode(String tenantCode) {
        if (this.isTest) {
            return this.createUUIDString();
        }
        return this.getNo(null, "PtStoreClose", "ptStoreClose", tenantCode);
    }

    private int getPtStoreCloseMaxCode() {
        int code = 0;
        try {
            return this.ptStoreCloseMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreCloseServiceImpl.getPtStoreCloseMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtStoreCloseUpdataDefault(PtStoreClose ptStoreClose) {
        if (null == ptStoreClose) {
            return;
        }
        ptStoreClose.setGmtModified(this.getSysDate());
    }

    private void savePtStoreCloseModel(PtStoreClose ptStoreClose) throws ApiException {
        if (null == ptStoreClose) {
            return;
        }
        try {
            this.ptStoreCloseMapper.insert(ptStoreClose);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.savePtStoreCloseModel.ex", (Throwable)e);
        }
    }

    private void savePtStoreCloseBatchModel(List<PtStoreClose> ptStoreCloseList) throws ApiException {
        if (null == ptStoreCloseList || ptStoreCloseList.isEmpty()) {
            return;
        }
        try {
            this.ptStoreCloseMapper.insertBatch(ptStoreCloseList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.savePtStoreCloseBatchModel.ex", (Throwable)e);
        }
    }

    private PtStoreClose getPtStoreCloseModelById(Integer storeCloseId) {
        if (null == storeCloseId) {
            return null;
        }
        try {
            return this.ptStoreCloseMapper.selectByPrimaryKey(storeCloseId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreCloseServiceImpl.getPtStoreCloseModelById", (Throwable)e);
            return null;
        }
    }

    private PtStoreClose getPtStoreCloseModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptStoreCloseMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreCloseServiceImpl.getPtStoreCloseModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtStoreCloseModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptStoreCloseMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.delPtStoreCloseModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.delPtStoreCloseModelByCode.num");
        }
    }

    private void deletePtStoreCloseModel(Integer storeCloseId) throws ApiException {
        if (null == storeCloseId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptStoreCloseMapper.deleteByPrimaryKey(storeCloseId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.deletePtStoreCloseModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.deletePtStoreCloseModel.num");
        }
    }

    private void updatePtStoreCloseModel(PtStoreClose ptStoreClose) throws ApiException {
        if (null == ptStoreClose) {
            return;
        }
        int i = 0;
        try {
            i = this.ptStoreCloseMapper.updateByPrimaryKeySelective(ptStoreClose);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.updatePtStoreCloseModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.updatePtStoreCloseModel.num");
        }
    }

    private void updateStatePtStoreCloseModel(Integer storeCloseId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeCloseId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeCloseId", storeCloseId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptStoreCloseMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.updateStatePtStoreCloseModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.updateStatePtStoreCloseModel.null");
        }
    }

    private void updateStatePtStoreCloseModelByCode(String tenantCode, String storeCloseCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeCloseCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeCloseCode", storeCloseCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptStoreCloseMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.updateStatePtStoreCloseModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.updateStatePtStoreCloseModelByCode.null");
        }
    }

    private PtStoreClose makePtStoreClose(PtStoreCloseDomain ptStoreCloseDomain, PtStoreClose ptStoreClose) {
        if (null == ptStoreCloseDomain) {
            return null;
        }
        if (null == ptStoreClose) {
            ptStoreClose = new PtStoreClose();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ptStoreClose, (Object)ptStoreCloseDomain);
            return ptStoreClose;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreCloseServiceImpl.makePtStoreClose", (Throwable)e);
            return null;
        }
    }

    private PtStoreCloseReDomain makePtStoreCloseReDomain(PtStoreClose ptStoreClose) {
        if (null == ptStoreClose) {
            return null;
        }
        PtStoreCloseReDomain ptStoreCloseReDomain = new PtStoreCloseReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptStoreCloseReDomain, (Object)ptStoreClose);
            return ptStoreCloseReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreCloseServiceImpl.makePtStoreCloseReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtStoreClose> queryPtStoreCloseModelPage(Map<String, Object> parammap) {
        try {
            return this.ptStoreCloseMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreCloseServiceImpl.queryPtStoreCloseModel", (Throwable)e);
            return null;
        }
    }

    private int countPtStoreClose(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptStoreCloseMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreCloseServiceImpl.countPtStoreClose", (Throwable)e);
        }
        return i;
    }

    private PtStoreClose createPtStoreClose(PtStoreCloseDomain ptStoreCloseDomain) {
        String msg = this.checkPtStoreClose(ptStoreCloseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.savePtStoreClose.checkPtStoreClose", msg);
        }
        PtStoreClose ptStoreClose = this.makePtStoreClose(ptStoreCloseDomain, null);
        this.setPtStoreCloseDefault(ptStoreClose);
        return ptStoreClose;
    }

    @Override
    public String savePtStoreClose(PtStoreCloseReDomain ptStoreCloseDomain) throws ApiException {
        PtStoreClose ptStoreClose = this.createPtStoreClose(ptStoreCloseDomain);
        this.savePtStoreCloseModel(ptStoreClose);
        return ptStoreClose.getStoreCloseCode();
    }

    @Override
    public String savePtStoreCloseBatch(List<PtStoreCloseReDomain> ptStoreCloseDomainList) throws ApiException {
        if (null == ptStoreCloseDomainList || ptStoreCloseDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtStoreClose> ptStoreCloseList = new ArrayList<PtStoreClose>();
        String code = "";
        for (PtStoreCloseDomain ptStoreCloseDomain : ptStoreCloseDomainList) {
            PtStoreClose ptStoreClose = this.createPtStoreClose(ptStoreCloseDomain);
            code = ptStoreClose.getStoreCloseCode();
            ptStoreCloseList.add(ptStoreClose);
        }
        this.savePtStoreCloseBatchModel(ptStoreCloseList);
        return code;
    }

    @Override
    public void updatePtStoreCloseState(Integer storeCloseId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeCloseId) {
            return;
        }
        this.updateStatePtStoreCloseModel(storeCloseId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtStoreCloseStateByCode(String tenantCode, String storeCloseCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeCloseCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtStoreCloseModelByCode(tenantCode, storeCloseCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtStoreClose(PtStoreCloseReDomain ptStoreCloseDomain) throws ApiException {
        String msg = this.checkPtStoreClose(ptStoreCloseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.updatePtStoreClose.checkPtStoreClose", msg);
        }
        PtStoreClose oldPtStoreClose = this.getPtStoreCloseModelById(ptStoreCloseDomain.getStoreCloseId());
        if (null == oldPtStoreClose) {
            throw new ApiException("pt.POTENTIAL.PtStoreCloseServiceImpl.updatePtStoreClose.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtStoreClose ptStoreClose = this.makePtStoreClose(ptStoreCloseDomain, oldPtStoreClose);
        this.setPtStoreCloseUpdataDefault(ptStoreClose);
        this.updatePtStoreCloseModel(ptStoreClose);
    }

    @Override
    public PtStoreCloseReDomain getPtStoreClose(Integer storeCloseId) {
        if (null == storeCloseId) {
            return null;
        }
        PtStoreClose storeClose = this.getPtStoreCloseModelById(storeCloseId);
        return this.makePtStoreCloseReDomain(storeClose);
    }

    @Override
    public void deletePtStoreClose(Integer storeCloseId) throws ApiException {
        if (null == storeCloseId) {
            return;
        }
        this.deletePtStoreCloseModel(storeCloseId);
    }

    @Override
    public QueryResult<PtStoreClose> queryPtStoreClosePage(Map<String, Object> map) {
        List<PtStoreClose> ptStoreCloseList = this.queryPtStoreCloseModelPage(map);
        if (ListUtil.isNotEmpty(ptStoreCloseList)) {
            String userinfoCodes = ptStoreCloseList.stream().map(PtStoreClose::getStoreCode).collect(Collectors.joining(","));
            final HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("userinfoCode", userinfoCodes);
            paramMap.put("tenantCode", ptStoreCloseList.get(0).getTenantCode());
            HashMap<String, Object> sendMap = new HashMap<String, Object>(){
                {
                    this.put("map", JsonUtil.buildNormalBinder().toJson((Object)paramMap));
                }
            };
            QueryResult userinfoQueryResult = this.getQueryResutl("um.user.queryUserinfoPage", sendMap, UmUserinfo.class);
            if (userinfoQueryResult != null && ListUtil.isNotEmpty((Collection)userinfoQueryResult.getList())) {
                Map<String, UmUserinfo> userinfoMap = userinfoQueryResult.getList().stream().collect(Collectors.toMap(UmUserinfo::getUserinfoCode, s -> s, (k1, k2) -> k1));
                ptStoreCloseList.forEach(p -> {
                    if (userinfoMap.containsKey(p.getStoreCode())) {
                        p.setUmUserinfo((UmUserinfo)userinfoMap.get(p.getStoreCode()));
                    }
                });
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtStoreClose(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptStoreCloseList);
        return queryResult;
    }

    @Override
    public PtStoreCloseReDomain getPtStoreCloseByCode(String tenantCode, String storeCloseCode) throws ApiException {
        if (StringUtils.isBlank((String)storeCloseCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeCloseCode", storeCloseCode);
        PtStoreClose storeClose = this.getPtStoreCloseModelByCode(map);
        return this.makePtStoreCloseReDomain(storeClose);
    }

    @Override
    public void deletePtStoreCloseByCode(String tenantCode, String storeCloseCode) throws ApiException {
        if (StringUtils.isBlank((String)storeCloseCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeCloseCode", storeCloseCode);
        this.delPtStoreCloseModelByCode(map);
    }
}

