/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.utils;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public final class MarginNoGenerator {
    private static final String PREFIX = "BZJ";
    private static final AtomicInteger SEQ = new AtomicInteger(0);
    private static volatile long LAST_MILLIS = -1L;
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");

    private MarginNoGenerator() {
    }

    public static synchronized String generate() {
        long now = System.currentTimeMillis();
        if (now != LAST_MILLIS) {
            SEQ.set(0);
            LAST_MILLIS = now;
        }
        int seq = SEQ.getAndIncrement() & 0xFFFF;
        int rnd = ThreadLocalRandom.current().nextInt(100, 1000);
        String timePart = Instant.ofEpochMilli(now).atZone(ZoneId.systemDefault()).toLocalDateTime().format(TIME_FORMAT);
        String seqPart = String.format("%04d", seq % 10000);
        return PREFIX + timePart + seqPart + rnd;
    }

    public static String generateUnique(Predicate<String> existsChecker, int maxAttempts) {
        if (existsChecker == null) {
            throw new IllegalArgumentException("existsChecker required");
        }
        int attempts = 0;
        while (attempts++ < Math.max(1, maxAttempts)) {
            String no = MarginNoGenerator.generate();
            try {
                if (!existsChecker.test(no)) {
                    return no;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("existsChecker error", e);
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        throw new IllegalStateException("cannot generate unique marginNo after " + maxAttempts + " attempts");
    }

    public static String generateUnique(Predicate<String> existsChecker) {
        return MarginNoGenerator.generateUnique(existsChecker, 50);
    }
}

