/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.producestaticfile.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.producestaticfile.dao.PfsHtmldataMapper;
import com.yqbsoft.laser.service.producestaticfile.domain.PfsHtmldataDomain;
import com.yqbsoft.laser.service.producestaticfile.model.PfsHtmldata;
import com.yqbsoft.laser.service.producestaticfile.model.PfsHtmldataConf;
import com.yqbsoft.laser.service.producestaticfile.service.PfsHtmldataConfService;
import com.yqbsoft.laser.service.producestaticfile.service.PfsHtmldataService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PfsHtmldataServiceImpl
extends BaseServiceImpl
implements PfsHtmldataService {
    private static final String SYS_CODE = "pfs.PfsHtmldataServiceImpl";
    private PfsHtmldataConfService pfsHtmldataConfService;
    private PfsHtmldataMapper pfsHtmldataMapper;

    public void setPfsHtmldataConfService(PfsHtmldataConfService pfsHtmldataConfService) {
        this.pfsHtmldataConfService = pfsHtmldataConfService;
    }

    public void setPfsHtmldataMapper(PfsHtmldataMapper pfsHtmldataMapper) {
        this.pfsHtmldataMapper = pfsHtmldataMapper;
    }

    private Date getSysDate() {
        try {
            return this.pfsHtmldataMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmldataServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkHtmldata(PfsHtmldataDomain pfsHtmldataDomain) {
        if (null == pfsHtmldataDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pfsHtmldataDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)pfsHtmldataDomain.getHtmldataCode())) {
            msg = msg + "HtmldataCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setHtmldataDefault(PfsHtmldata pfsHtmldata) {
        if (null == pfsHtmldata) {
            return;
        }
        if (null == pfsHtmldata.getDataState()) {
            pfsHtmldata.setDataState(0);
        }
        if (null == pfsHtmldata.getGmtCreate()) {
            pfsHtmldata.setGmtCreate(this.getSysDate());
        }
        pfsHtmldata.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pfsHtmldata.getHtmldataCode())) {
            pfsHtmldata.setHtmldataCode(this.createUUIDString());
        }
    }

    private int getHtmldataMaxCode() {
        int code = 0;
        try {
            return this.pfsHtmldataMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmldataServiceImpl.getHtmldataMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setHtmldataUpdataDefault(PfsHtmldata pfsHtmldata) {
        if (null == pfsHtmldata) {
            return;
        }
        pfsHtmldata.setGmtModified(this.getSysDate());
    }

    private void saveHtmldataModel(PfsHtmldata pfsHtmldata) throws ApiException {
        if (null == pfsHtmldata) {
            return;
        }
        try {
            this.pfsHtmldataMapper.insert(pfsHtmldata);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.saveHtmldataModel.ex", (Throwable)e);
        }
    }

    private PfsHtmldata getHtmldataModelById(Integer htmldataId) {
        if (null == htmldataId) {
            return null;
        }
        try {
            return this.pfsHtmldataMapper.selectByPrimaryKey(htmldataId);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmldataServiceImpl.getHtmldataModelById", (Throwable)e);
            return null;
        }
    }

    public PfsHtmldata getHtmldataModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pfsHtmldataMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmldataServiceImpl.getHtmldataModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delHtmldataModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsHtmldataMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.delHtmldataModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.delHtmldataModelByCode.num");
        }
    }

    private void deleteHtmldataModel(Integer htmldataId) throws ApiException {
        if (null == htmldataId) {
            return;
        }
        int i = 0;
        try {
            i = this.pfsHtmldataMapper.deleteByPrimaryKey(htmldataId);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.deleteHtmldataModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.deleteHtmldataModel.num");
        }
    }

    private void updateHtmldataModel(PfsHtmldata pfsHtmldata) throws ApiException {
        if (null == pfsHtmldata) {
            return;
        }
        try {
            this.pfsHtmldataMapper.updateByPrimaryKeySelective(pfsHtmldata);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.updateHtmldataModel.ex", (Throwable)e);
        }
    }

    private void updateStateHtmldataModel(Integer htmldataId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == htmldataId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("htmldataId", htmldataId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pfsHtmldataMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.updateStateHtmldataModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.updateStateHtmldataModel.null");
        }
    }

    private PfsHtmldata makeHtmldata(PfsHtmldataDomain pfsHtmldataDomain, PfsHtmldata pfsHtmldata) {
        if (null == pfsHtmldataDomain) {
            return null;
        }
        if (null == pfsHtmldata) {
            pfsHtmldata = new PfsHtmldata();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pfsHtmldata, (Object)pfsHtmldataDomain);
            return pfsHtmldata;
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmldataServiceImpl.makeHtmldata", (Throwable)e);
            return null;
        }
    }

    private List<PfsHtmldata> queryHtmldataModelPage(Map<String, Object> parammap) {
        try {
            return this.pfsHtmldataMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmldataServiceImpl.queryHtmldataModel", (Throwable)e);
            return null;
        }
    }

    private int countHtmldata(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pfsHtmldataMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pfs.PfsHtmldataServiceImpl.countHtmldata", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveHtmldata(PfsHtmldataDomain pfsHtmldataDomain) throws ApiException {
        String msg = this.checkHtmldata(pfsHtmldataDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.saveHtmldata.checkHtmldata", msg);
        }
        PfsHtmldata pfsHtmldata = this.makeHtmldata(pfsHtmldataDomain, null);
        this.setHtmldataDefault(pfsHtmldata);
        this.saveHtmldataModel(pfsHtmldata);
        return pfsHtmldata.getHtmldataCode();
    }

    @Override
    public void updateHtmldataState(Integer htmldataId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateHtmldataModel(htmldataId, dataState, oldDataState);
    }

    @Override
    public void updateHtmldata(PfsHtmldataDomain pfsHtmldataDomain) throws ApiException {
        String msg = this.checkHtmldata(pfsHtmldataDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.updateHtmldata.checkHtmldata", msg);
        }
        PfsHtmldata oldPfsHtmldata = this.getHtmldataModelById(pfsHtmldataDomain.getHtmldataId());
        if (null == oldPfsHtmldata) {
            throw new ApiException("pfs.PfsHtmldataServiceImpl.updateHtmldata.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PfsHtmldata pfsHtmldata = this.makeHtmldata(pfsHtmldataDomain, oldPfsHtmldata);
        this.setHtmldataUpdataDefault(pfsHtmldata);
        this.updateHtmldataModel(pfsHtmldata);
    }

    @Override
    public PfsHtmldata getHtmldata(Integer htmldataId) {
        return this.getHtmldataModelById(htmldataId);
    }

    @Override
    public void deleteHtmldata(Integer htmldataId) throws ApiException {
        this.deleteHtmldataModel(htmldataId);
    }

    @Override
    public QueryResult<PfsHtmldata> queryHtmldataPage(Map<String, Object> map) {
        List<PfsHtmldata> pfsHtmldataList = this.queryHtmldataModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countHtmldata(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pfsHtmldataList);
        return queryResult;
    }

    @Override
    public PfsHtmldata getHtmldataByCode(Map<String, Object> map) {
        return this.getHtmldataModelByCode(map);
    }

    @Override
    public void delHtmldataByCode(Map<String, Object> map) throws ApiException {
        this.delHtmldataModelByCode(map);
    }

    @Override
    public void queryLoadCache() {
        String cachekeydomain = "PfsHtmldata-code";
        this.logger.info("pfs.PfsHtmldataServiceImpl.queryLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<PfsHtmldata> htmldataList = this.queryHtmldataModelPage(parammap);
        if (null == htmldataList || htmldataList.isEmpty()) {
            DisUtil.delVer((String)cachekeydomain);
            this.logger.info("pfs.PfsHtmldataServiceImpl.queryLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> htmldataMap = new ConcurrentHashMap<String, String>();
        for (PfsHtmldata pfsHtmldata : htmldataList) {
            htmldataMap.put(pfsHtmldata.getHtmldataCode() + "-" + pfsHtmldata.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)pfsHtmldata));
        }
        DisUtil.setMapVer((String)cachekeydomain, htmldataMap);
        String cachekeycodfdomain = "PfsHtmldataConf-code";
        List<PfsHtmldataConf> confList = this.pfsHtmldataConfService.queryHtmldataConf(parammap);
        if (null == confList || confList.isEmpty()) {
            DisUtil.delVer((String)cachekeycodfdomain);
            this.logger.info("pfs.PfsHtmldataServiceImpl.queryConfLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> htmldataConfMap = new ConcurrentHashMap<String, String>();
        for (PfsHtmldataConf pfsHtmldataConf : confList) {
            List<PfsHtmldataConf> cacheConfList;
            String key = pfsHtmldataConf.getHtmldataCode() + "-" + pfsHtmldataConf.getTenantCode();
            String listStr = (String)htmldataConfMap.get(key);
            if (StringUtils.isNotBlank((String)listStr)) {
                cacheConfList = JsonUtil.buildNormalBinder().getJsonToList(listStr, PfsHtmldataConf.class);
                if (null == cacheConfList) {
                    cacheConfList = new ArrayList();
                }
            } else {
                cacheConfList = new ArrayList();
            }
            cacheConfList.add(pfsHtmldataConf);
            htmldataConfMap.put(key, JsonUtil.buildNormalBinder().toJson(cacheConfList));
        }
        DisUtil.setMapVer((String)cachekeycodfdomain, htmldataConfMap);
        this.logger.info("pfs.PfsHtmldataServiceImpl.queryConfLoadCache", (Object)"===========add-end==========");
    }
}

