/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebPointsUsersMapper;
import com.yqbsoft.laser.service.reb.domain.RebPointsUsersDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsUsersReDomain;
import com.yqbsoft.laser.service.reb.model.RebPointsUsers;
import com.yqbsoft.laser.service.reb.service.RebPointsUsersService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebPointsUsersServiceImpl
extends BaseServiceImpl
implements RebPointsUsersService {
    private static final String SYS_CODE = "reb.RebPointsUsersServiceImpl";
    private RebPointsUsersMapper rebPointsUsersMapper;

    public void setRebPointsUsersMapper(RebPointsUsersMapper rebPointsUsersMapper) {
        this.rebPointsUsersMapper = rebPointsUsersMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebPointsUsersMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsUsersServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRebPointsUsers(RebPointsUsersDomain rebPointsUsersDomain) {
        if (null == rebPointsUsersDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsUsersDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRebPointsUsersDefault(RebPointsUsers rebPointsUsers) {
        if (null == rebPointsUsers) {
            return;
        }
        if (null == rebPointsUsers.getDataState()) {
            rebPointsUsers.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPointsUsers.getGmtCreate()) {
            rebPointsUsers.setGmtCreate(date);
        }
        rebPointsUsers.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPointsUsers.getPointsUserCode())) {
            rebPointsUsers.setPointsUserCode(this.getNo(null, "RebPointsUsers", "rebPointsUsers", rebPointsUsers.getTenantCode()));
        }
    }

    private int getRebPointsUsersMaxCode() {
        int code = 0;
        try {
            return this.rebPointsUsersMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsUsersServiceImpl.getRebPointsUsersMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRebPointsUsersUpdataDefault(RebPointsUsers rebPointsUsers) {
        if (null == rebPointsUsers) {
            return;
        }
        rebPointsUsers.setGmtModified(this.getSysDate());
    }

    private void saveRebPointsUsersModel(RebPointsUsers rebPointsUsers) throws ApiException {
        if (null == rebPointsUsers) {
            return;
        }
        try {
            this.rebPointsUsersMapper.insert(rebPointsUsers);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.saveRebPointsUsersModel.ex", (Throwable)e);
        }
    }

    private void saveRebPointsUsersBatchModel(List<RebPointsUsers> rebPointsUsersList) throws ApiException {
        if (null == rebPointsUsersList || rebPointsUsersList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsUsersMapper.insertBatch(rebPointsUsersList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.saveRebPointsUsersBatchModel.ex", (Throwable)e);
        }
    }

    private RebPointsUsers getRebPointsUsersModelById(Integer pointsUserId) {
        if (null == pointsUserId) {
            return null;
        }
        try {
            return this.rebPointsUsersMapper.selectByPrimaryKey(pointsUserId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsUsersServiceImpl.getRebPointsUsersModelById", (Throwable)e);
            return null;
        }
    }

    private RebPointsUsers getRebPointsUsersModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsUsersMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsUsersServiceImpl.getRebPointsUsersModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRebPointsUsersModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsUsersMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.delRebPointsUsersModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.delRebPointsUsersModelByCode.num");
        }
    }

    private void deleteRebPointsUsersModel(Integer pointsUserId) throws ApiException {
        if (null == pointsUserId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsUsersMapper.deleteByPrimaryKey(pointsUserId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.deleteRebPointsUsersModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.deleteRebPointsUsersModel.num");
        }
    }

    private void updateRebPointsUsersModel(RebPointsUsers rebPointsUsers) throws ApiException {
        if (null == rebPointsUsers) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsUsersMapper.updateByPrimaryKey(rebPointsUsers);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateRebPointsUsersModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateRebPointsUsersModel.num");
        }
    }

    private void updateRebPointsUsersDateModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsUsersMapper.updateDateByKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateRebPointsUsersDateModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateRebPointsUsersDateModel.num");
        }
    }

    private void updateStateRebPointsUsersModel(Integer pointsUserId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsUserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsUserId", pointsUserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsUsersMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateStateRebPointsUsersModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateStateRebPointsUsersModel.null");
        }
    }

    private void updateStateRebPointsUsersModelByCode(String tenantCode, String pointsUserCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsUserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsUserCode", pointsUserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsUsersMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateStateRebPointsUsersModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateStateRebPointsUsersModelByCode.null");
        }
    }

    private RebPointsUsers makeRebPointsUsers(RebPointsUsersDomain rebPointsUsersDomain, RebPointsUsers rebPointsUsers) {
        if (null == rebPointsUsersDomain) {
            return null;
        }
        if (null == rebPointsUsers) {
            rebPointsUsers = new RebPointsUsers();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsUsers, (Object)rebPointsUsersDomain);
            return rebPointsUsers;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsUsersServiceImpl.makeRebPointsUsers", (Throwable)e);
            return null;
        }
    }

    private RebPointsUsersReDomain makeRebPointsUsersReDomain(RebPointsUsers rebPointsUsers) {
        if (null == rebPointsUsers) {
            return null;
        }
        RebPointsUsersReDomain rebPointsUsersReDomain = new RebPointsUsersReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsUsersReDomain, (Object)rebPointsUsers);
            return rebPointsUsersReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsUsersServiceImpl.makeRebPointsUsersReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPointsUsers> queryRebPointsUsersModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsUsersMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsUsersServiceImpl.queryRebPointsUsersModel", (Throwable)e);
            return null;
        }
    }

    private int countRebPointsUsers(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsUsersMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsUsersServiceImpl.countRebPointsUsers", (Throwable)e);
        }
        return i;
    }

    private RebPointsUsers createRebPointsUsers(RebPointsUsersDomain rebPointsUsersDomain) {
        String msg = this.checkRebPointsUsers(rebPointsUsersDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.saveRebPointsUsers.checkRebPointsUsers", msg);
        }
        RebPointsUsers rebPointsUsers = this.makeRebPointsUsers(rebPointsUsersDomain, null);
        this.setRebPointsUsersDefault(rebPointsUsers);
        return rebPointsUsers;
    }

    @Override
    public String saveRebPointsUsers(RebPointsUsersDomain rebPointsUsersDomain) throws ApiException {
        RebPointsUsers rebPointsUsers = this.createRebPointsUsers(rebPointsUsersDomain);
        this.saveRebPointsUsersModel(rebPointsUsers);
        return rebPointsUsers.getPointsUserCode();
    }

    @Override
    public String saveRebPointsUsersBatch(List<RebPointsUsersDomain> rebPointsUsersDomainList) throws ApiException {
        if (null == rebPointsUsersDomainList || rebPointsUsersDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPointsUsers> rebPointsUsersList = new ArrayList<RebPointsUsers>();
        String code = "";
        for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
            RebPointsUsers rebPointsUsers = this.createRebPointsUsers(rebPointsUsersDomain);
            code = rebPointsUsers.getPointsUserCode();
            rebPointsUsersList.add(rebPointsUsers);
        }
        this.saveRebPointsUsersBatchModel(rebPointsUsersList);
        return code;
    }

    @Override
    public void updateRebPointsUsersState(Integer pointsUserId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsUserId) {
            return;
        }
        this.updateStateRebPointsUsersModel(pointsUserId, dataState, oldDataState, map);
    }

    @Override
    public void updateRebPointsUsersStateByCode(String tenantCode, String pointsUserCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsUserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRebPointsUsersModelByCode(tenantCode, pointsUserCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRebPointsUsers(RebPointsUsersDomain rebPointsUsersDomain) throws ApiException {
        String msg = this.checkRebPointsUsers(rebPointsUsersDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateRebPointsUsers.checkRebPointsUsers", msg);
        }
        RebPointsUsers oldRebPointsUsers = this.getRebPointsUsersModelById(rebPointsUsersDomain.getPointsUserId());
        if (null == oldRebPointsUsers) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateRebPointsUsers.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPointsUsers rebPointsUsers = this.makeRebPointsUsers(rebPointsUsersDomain, oldRebPointsUsers);
        this.setRebPointsUsersUpdataDefault(rebPointsUsers);
        this.updateRebPointsUsersModel(rebPointsUsers);
    }

    @Override
    public RebPointsUsers getRebPointsUsers(Integer pointsUserId) {
        if (null == pointsUserId) {
            return null;
        }
        return this.getRebPointsUsersModelById(pointsUserId);
    }

    @Override
    public void deleteRebPointsUsers(Integer pointsUserId) throws ApiException {
        if (null == pointsUserId) {
            return;
        }
        this.deleteRebPointsUsersModel(pointsUserId);
    }

    @Override
    public QueryResult<RebPointsUsers> queryRebPointsUsersPage(Map<String, Object> map) {
        List<RebPointsUsers> rebPointsUsersList = this.queryRebPointsUsersModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRebPointsUsers(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsUsersList);
        return queryResult;
    }

    @Override
    public RebPointsUsers getRebPointsUsersByCode(String tenantCode, String pointsUserCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsUserCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsUserCode", pointsUserCode);
        return this.getRebPointsUsersModelByCode(map);
    }

    @Override
    public void deleteRebPointsUsersByCode(String tenantCode, String pointsUserCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsUserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsUserCode", pointsUserCode);
        this.delRebPointsUsersModelByCode(map);
    }

    @Override
    public void updateRebPointsUsersDate(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || EmptyUtil.isEmpty((Object)map.get("pointsUserId"))) {
            throw new ApiException("reb.RebPointsUsersServiceImpl.updateRebPointsUsersDate.map");
        }
        this.updateRebPointsUsersDateModel(map);
    }
}

