/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.annotation.ApiMethod;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.reb.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.reb.domain.OcContractReDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobListDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsOpDomain;
import com.yqbsoft.laser.service.reb.es.RebChannelSendPutThread;
import com.yqbsoft.laser.service.reb.model.RebChannelsend;
import com.yqbsoft.laser.service.reb.model.RebUpointsOp;
import com.yqbsoft.laser.service.reb.service.RebUpointsOpBaseService;
import com.yqbsoft.laser.service.reb.service.RebUpointsOpService;
import com.yqbsoft.laser.service.reb.service.impl.RebChannelsendServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebUpointsOpBaseServiceImpl
extends BaseServiceImpl
implements RebUpointsOpBaseService {
    private static final String SYS_CODE = "reb.RebUpointsOpBaseServiceImpl";
    private RebUpointsOpService rebUpointsOpService;

    public void setRebUpointsOpService(RebUpointsOpService rebUpointsOpService) {
        this.rebUpointsOpService = rebUpointsOpService;
    }

    @Override
    public String saveUpointsOpToPoints(RebUpointsOpDomain rebUpointsOpDomain) throws ApiException {
        if (null == rebUpointsOpDomain) {
            this.logger.error("reb.RebUpointsOpBaseServiceImpl.saveUpointsOpToPoints", (Object)"rebUpointsOpDomain is null");
            return "error";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", rebUpointsOpDomain.getUpointsListExcode());
        paramMap.put("tenantCode", rebUpointsOpDomain.getTenantCode());
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        OcContractReDomain ocContractReDomain = (OcContractReDomain)this.getForObject("oc.contract.getContractByCode", OcContractReDomain.class, sendMap);
        this.logger.info("ocContractReDomain====1", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractReDomain));
        if (null == ocContractReDomain || ListUtil.isEmpty(ocContractReDomain.getGoodsList())) {
            this.logger.error("reb.RebUpointsOpBaseServiceImpl.saveUpointsOpToPoints", (Object)"ocContractReDomain is null");
            return "error";
        }
        ArrayList<OcContractGoodsDomain> goodsDomainList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoodsDomain goodsDomain : ocContractReDomain.getGoodsList()) {
            if (!"17".equals(goodsDomain.getGoodsType())) continue;
            goodsDomainList.add(goodsDomain);
        }
        if (ListUtil.isEmpty(goodsDomainList)) {
            this.logger.error("reb.RebUpointsOpBaseServiceImpl.saveUpointsOpToPoints", (Object)"ocContractReDomain is null");
            return "error";
        }
        List<RebChannelsend> list = this.rebUpointsOpService.saveSendUpointsOpToPoints(rebUpointsOpDomain);
        if (null == list) {
            this.logger.error("reb.RebUpointsOpBaseServiceImpl.saveUpointsOpToPoints.list");
            return "error";
        }
        if (!ListUtil.isNotEmpty(list)) {
            this.logger.error("reb.RebUpointsOpBaseServiceImpl.saveUpointsOpToPoints.list");
            return "error";
        }
        RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), list));
        return "success";
    }

    @Override
    public String saveUpointsOp(RebUpointsOpDomain rebUpointsOpDomain) throws ApiException {
        List<RebChannelsend> list = this.rebUpointsOpService.saveSendUpointsOp(rebUpointsOpDomain);
        if (null == list) {
            this.logger.error("reb.RebUpointsOpBaseServiceImpl.sendUpointsClear.list");
            return "error";
        }
        if (!ListUtil.isNotEmpty(list)) {
            this.logger.error("reb.RebUpointsOpBaseServiceImpl.syncShsettlOplistBatch.list");
            return "error";
        }
        RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), list));
        return "success";
    }

    @Override
    public String sendUpointsOpToPoints(RebUpointsOp rebUpointsOp) throws ApiException {
        List<RebChannelsend> rebUpointsList = this.rebUpointsOpService.saveSendUpointsOpToPointsNew(rebUpointsOp);
        if (null == rebUpointsList) {
            return "error";
        }
        if (null != rebUpointsList) {
            ArrayList<RebChannelsend> channelsendArrayList = new ArrayList<RebChannelsend>();
            channelsendArrayList.addAll(rebUpointsList);
            RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), channelsendArrayList));
        }
        return "success";
    }

    @Override
    @ApiMethod(code="reb.upointsOpBase.sendUpointsOpByMemjobList", name="\u7ed3\u7b97\u5355\u751f\u6210", paramStr="rebMemjobListDomain", description="\u7ed3\u7b97\u5355\u751f\u6210")
    public String sendUpointsOpByMemjobList(RebMemjobListDomain rebMemjobListDomain) throws ApiException {
        List<RebChannelsend> rebUpointsList = this.rebUpointsOpService.saveSendUpointsOpByMemjob(rebMemjobListDomain);
        if (null == rebUpointsList) {
            return "error";
        }
        if (null != rebUpointsList) {
            ArrayList<RebChannelsend> channelsendArrayList = new ArrayList<RebChannelsend>();
            channelsendArrayList.addAll(rebUpointsList);
            RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), channelsendArrayList));
        }
        return "success";
    }

    @Override
    public String sendUpointsOpAudit(Integer upointsOpId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        this.logger.error("reb.RebUpointsOpBaseServiceImpl.sendUpointsOpAudit.upointsOpId", (Object)upointsOpId);
        List<RebChannelsend> rebUpointsList = this.rebUpointsOpService.saveUpointsOpAudit(upointsOpId, dataState, oldDataState, expmap);
        if (null == rebUpointsList) {
            return "error";
        }
        if (null != rebUpointsList) {
            ArrayList<RebChannelsend> channelsendArrayList = new ArrayList<RebChannelsend>();
            channelsendArrayList.addAll(rebUpointsList);
            RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), channelsendArrayList));
        }
        return "success";
    }
}

