/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebMemjobMapper;
import com.yqbsoft.laser.service.reb.domain.RebChannelsendDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemJobByMonthDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobListDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobListReDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobReDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsClearDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsListDomain;
import com.yqbsoft.laser.service.reb.es.RebChannelSendPutThread;
import com.yqbsoft.laser.service.reb.model.RebChannelsend;
import com.yqbsoft.laser.service.reb.model.RebMemjob;
import com.yqbsoft.laser.service.reb.model.RebMemjobList;
import com.yqbsoft.laser.service.reb.service.RebChannelsendService;
import com.yqbsoft.laser.service.reb.service.RebMemjobListService;
import com.yqbsoft.laser.service.reb.service.RebMemjobService;
import com.yqbsoft.laser.service.reb.service.RebUpointsService;
import com.yqbsoft.laser.service.reb.service.impl.RebChannelsendServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;

public class RebMemjobServiceImpl
extends BaseServiceImpl
implements RebMemjobService {
    private static final String SYS_CODE = "reb.RebMemjobServiceImpl";
    private RebMemjobMapper rebMemjobMapper;
    @Autowired
    private RebMemjobListService rebMemjobListService;
    private RebChannelsendService rebChannelsendService;
    private RebUpointsService rebUpointsService;
    private static final Pattern DATE_PATTERN = Pattern.compile("([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8])))");

    public void setRebMemjobMapper(RebMemjobMapper rebMemjobMapper) {
        this.rebMemjobMapper = rebMemjobMapper;
    }

    public void setRebChannelsendService(RebChannelsendService rebChannelsendService) {
        this.rebChannelsendService = rebChannelsendService;
    }

    public RebUpointsService getRebUpointsService() {
        return this.rebUpointsService;
    }

    public void setRebUpointsService(RebUpointsService rebUpointsService) {
        this.rebUpointsService = rebUpointsService;
    }

    private Date getSysDate() {
        try {
            return this.rebMemjobMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMemjob(RebMemjobDomain rebMemjobDomain) {
        if (null == rebMemjobDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebMemjobDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMemjobDefault(RebMemjob rebMemjob) {
        if (null == rebMemjob) {
            return;
        }
        if (null == rebMemjob.getDataState()) {
            rebMemjob.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebMemjob.getGmtCreate()) {
            rebMemjob.setGmtCreate(date);
        }
        rebMemjob.setGmtModified(date);
        if (StringUtils.isBlank((String)rebMemjob.getMemjobCode())) {
            rebMemjob.setMemjobCode(this.getNo(null, "RebMemjob", "rebMemjob", rebMemjob.getTenantCode()));
        }
    }

    private int getMemjobMaxCode() {
        int code = 0;
        try {
            return this.rebMemjobMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getMemjobMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMemjobUpdataDefault(RebMemjob rebMemjob) {
        if (null == rebMemjob) {
            return;
        }
        rebMemjob.setGmtModified(this.getSysDate());
    }

    private void saveMemjobModel(RebMemjob rebMemjob) throws ApiException {
        if (null == rebMemjob) {
            return;
        }
        try {
            this.rebMemjobMapper.insert(rebMemjob);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.saveMemjobModel.ex", (Throwable)e);
        }
    }

    private void saveMemjobBatchModel(List<RebMemjob> rebMemjobList) throws ApiException {
        if (null == rebMemjobList || rebMemjobList.isEmpty()) {
            return;
        }
        try {
            this.rebMemjobMapper.insertBatch(rebMemjobList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.saveMemjobBatchModel.ex", (Throwable)e);
        }
    }

    private RebMemjob getMemjobModelById(Integer memjobId) {
        if (null == memjobId) {
            return null;
        }
        try {
            return this.rebMemjobMapper.selectByPrimaryKey(memjobId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getMemjobModelById", (Throwable)e);
            return null;
        }
    }

    private RebMemjob getMemjobModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebMemjobMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getMemjobModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMemjobModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.delMemjobModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobServiceImpl.delMemjobModelByCode.num");
        }
    }

    private void deleteMemjobModel(Integer memjobId) throws ApiException {
        if (null == memjobId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.deleteByPrimaryKey(memjobId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.deleteMemjobModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobServiceImpl.deleteMemjobModel.num");
        }
    }

    private void updateMemjobModel(RebMemjob rebMemjob) throws ApiException {
        if (null == rebMemjob) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.updateByPrimaryKey(rebMemjob);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjobModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjobModel.num");
        }
    }

    private void updateStateMemjobModel(Integer memjobId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == memjobId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memjobId", memjobId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModel.null");
        }
    }

    private void updateStateMemjobModelByCode(String tenantCode, String memjobCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobCode", memjobCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModelByCode.null");
        }
    }

    private RebMemjob makeMemjob(RebMemjobDomain rebMemjobDomain, RebMemjob rebMemjob) {
        if (null == rebMemjobDomain) {
            return null;
        }
        if (null == rebMemjob) {
            rebMemjob = new RebMemjob();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjob, (Object)rebMemjobDomain);
            return rebMemjob;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.makeMemjob", (Throwable)e);
            return null;
        }
    }

    private RebMemjobReDomain makeRebMemjobReDomain(RebMemjob rebMemjob) {
        if (null == rebMemjob) {
            return null;
        }
        RebMemjobReDomain rebMemjobReDomain = new RebMemjobReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjobReDomain, (Object)rebMemjob);
            return rebMemjobReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.makeRebMemjobReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebMemjob> queryMemjobModelPage(Map<String, Object> parammap) {
        try {
            return this.rebMemjobMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.queryMemjobModel", (Throwable)e);
            return null;
        }
    }

    private int countMemjob(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebMemjobMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.countMemjob", (Throwable)e);
        }
        return i;
    }

    private RebMemjob createRebMemjob(RebMemjobDomain rebMemjobDomain) {
        String msg = this.checkMemjob(rebMemjobDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebMemjobServiceImpl.saveMemjob.checkMemjob", msg);
        }
        RebMemjob rebMemjob = this.makeMemjob(rebMemjobDomain, null);
        this.setMemjobDefault(rebMemjob);
        return rebMemjob;
    }

    @Override
    public String saveMemjob(RebMemjobDomain rebMemjobDomain) throws ApiException {
        RebMemjob rebMemjob = this.createRebMemjob(rebMemjobDomain);
        this.saveMemjobModel(rebMemjob);
        if (ListUtil.isNotEmpty(rebMemjobDomain.getRebMemjobListDomainList())) {
            for (RebMemjobListDomain rebMemjobListDomain : rebMemjobDomain.getRebMemjobListDomainList()) {
                rebMemjobListDomain.setMemjobCode(rebMemjob.getMemjobCode());
                rebMemjobListDomain.setMemberCode(rebMemjob.getMemberCode());
                rebMemjobListDomain.setTenantCode(rebMemjob.getTenantCode());
            }
            this.rebMemjobListService.saveMemjobListBatch(rebMemjobDomain.getRebMemjobListDomainList());
        }
        return rebMemjob.getMemjobCode();
    }

    @Override
    public String saveMemjobBatch(List<RebMemjobDomain> rebMemjobDomainList) throws ApiException {
        if (null == rebMemjobDomainList || rebMemjobDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (RebMemjobDomain rebMemjobDomain : rebMemjobDomainList) {
            code = this.saveMemjob(rebMemjobDomain);
        }
        return code;
    }

    @Override
    public String updateMemjobBatch(List<RebMemjobDomain> rebMemjobDomainList) throws ApiException {
        if (null == rebMemjobDomainList || rebMemjobDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (RebMemjobDomain rebMemjobDomain : rebMemjobDomainList) {
            this.updateMemjob(rebMemjobDomain);
        }
        return code;
    }

    @Override
    public void updateMemjobState(Integer memjobId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == memjobId) {
            return;
        }
        this.updateStateMemjobModel(memjobId, dataState, oldDataState, map);
    }

    @Override
    public void updateMemjobStateByCode(String tenantCode, String memjobCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMemjobModelByCode(tenantCode, memjobCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMemjob(RebMemjobDomain rebMemjobDomain) throws ApiException {
        String msg = this.checkMemjob(rebMemjobDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjob.checkMemjob", msg);
        }
        RebMemjob oldRebMemjob = this.getMemjobModelById(rebMemjobDomain.getMemjobId());
        if (null == oldRebMemjob) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjob.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebMemjob rebMemjob = this.makeMemjob(rebMemjobDomain, oldRebMemjob);
        this.setMemjobUpdataDefault(rebMemjob);
        this.updateMemjobModel(rebMemjob);
        if (ListUtil.isNotEmpty(rebMemjobDomain.getRebMemjobListDomainList())) {
            for (RebMemjobListDomain rebMemjobListDomain : rebMemjobDomain.getRebMemjobListDomainList()) {
                if (null != rebMemjobListDomain.getMemjobListId()) {
                    this.rebMemjobListService.updateMemjobList(rebMemjobListDomain);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)rebMemjobListDomain.getMemjobCode()) || !StringUtils.isNotBlank((String)rebMemjobListDomain.getMemjobListDatatype())) continue;
                this.deleteMemJobList(rebMemjobListDomain.getMemjobCode(), rebMemjobListDomain.getMemjobListDatatype());
                this.rebMemjobListService.saveMemjobList(rebMemjobListDomain);
            }
        }
    }

    private void deleteMemJobList(String memjobCode, String memjobListDatatype) {
        QueryResult<RebMemjobList> result = this.rebMemjobListService.queryMemjobListPage(this.getQueryParamMap("memjobCode,memjobListDatatype", new Object[]{memjobCode, memjobListDatatype}));
        if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
            for (RebMemjobList rebMemjobList : result.getList()) {
                this.rebMemjobListService.deleteMemjobList(rebMemjobList.getMemjobListId());
            }
        }
    }

    @Override
    public RebMemjob getMemjob(Integer memjobId) {
        if (null == memjobId) {
            return null;
        }
        return this.getMemjobModelById(memjobId);
    }

    @Override
    public void deleteMemjob(Integer memjobId) throws ApiException {
        if (null == memjobId) {
            return;
        }
        this.deleteMemjobModel(memjobId);
    }

    @Override
    public QueryResult<RebMemjob> queryMemjobPage(Map<String, Object> map) {
        List<RebMemjob> rebMemjobList = this.queryMemjobModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMemjob(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebMemjobList);
        return queryResult;
    }

    @Override
    public QueryResult<RebMemjobReDomain> queryMemjobReDomainPage(Map<String, Object> map) {
        List<RebMemjob> rebMemjobList = this.queryMemjobModelPage(map);
        List<RebMemjobReDomain> rebMemjobReDomainList = this.assRebMemjobReDomainList(rebMemjobList);
        if (ListUtil.isNotEmpty(rebMemjobReDomainList) && MapUtil.isNotEmpty(map) && map.containsKey("childFlag")) {
            this.queryMemjobList(rebMemjobReDomainList);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMemjob(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebMemjobReDomainList);
        return queryResult;
    }

    private List<RebMemjobReDomain> assRebMemjobReDomainList(List<RebMemjob> rebMemjobList) {
        ArrayList<RebMemjobReDomain> rebMemjobReDomainList = new ArrayList<RebMemjobReDomain>();
        if (ListUtil.isNotEmpty(rebMemjobList)) {
            for (RebMemjob rebMemjob : rebMemjobList) {
                RebMemjobReDomain rebMemjobReDomain = this.makeRebMemjobReDomain(rebMemjob);
                rebMemjobReDomainList.add(rebMemjobReDomain);
            }
        }
        return rebMemjobReDomainList;
    }

    private void queryMemjobList(List<RebMemjobReDomain> rebMemjobReDomainList) {
        if (ListUtil.isNotEmpty(rebMemjobReDomainList)) {
            for (final RebMemjobReDomain rebMemjobReDomain : rebMemjobReDomainList) {
                final HashMap<String, Object> paramsMap = new HashMap<String, Object>(){
                    {
                        this.put("memjobCode", rebMemjobReDomain.getMemjobCode());
                        this.put("tenantCode", rebMemjobReDomain.getTenantCode());
                    }
                };
                HashMap<String, Object> sendMap = new HashMap<String, Object>(){
                    {
                        this.put("map", JsonUtil.buildNormalBinder().toJson((Object)paramsMap));
                    }
                };
                QueryResult queryResutl = this.getQueryResutl("reb.memjobList.queryMemjobListPage", sendMap, RebMemjobListDomain.class);
                if (EmptyUtil.isEmpty((Object)queryResutl) || !ListUtil.isNotEmpty((Collection)queryResutl.getList())) continue;
                rebMemjobReDomain.setRebMemjobListDomainList(queryResutl.getList());
            }
        }
    }

    @Override
    public RebMemjob getMemjobByCode(String tenantCode, String memjobCode) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobCode", memjobCode);
        return this.getMemjobModelByCode(map);
    }

    @Override
    public void deleteMemjobByCode(String tenantCode, String memjobCode) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobCode", memjobCode);
        this.delMemjobModelByCode(map);
    }

    @Override
    public List<RebChannelsend> saveSendMemjob(RebUpointsClearDomain rebUpointsClearDomain) throws ApiException {
        if (null == rebUpointsClearDomain) {
            this.logger.error("reb.RebMemjobServiceImpl.saveSendMemjob", (Object)"rebUpointsClearDomain is null");
            return null;
        }
        if (StringUtils.isBlank((String)rebUpointsClearDomain.getUpointsClearOpcode1()) || StringUtils.isBlank((String)rebUpointsClearDomain.getMemberCode())) {
            this.logger.error("reb.RebMemjobServiceImpl.saveSendMemjob", (Object)"upointsClearOpcode1 is null");
            return null;
        }
        Date da = null;
        try {
            da = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(rebUpointsClearDomain.getUpointsClearOpcode1());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList memjobsList = new ArrayList();
        Integer month = da.getMonth();
        Integer year = da.getYear();
        if (null == month || null == year) {
            this.logger.error("reb.RebMemjobServiceImpl.saveSendMemjob", (Object)"year or month is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", "0");
        map.put("memjobDatatype", month.toString());
        map.put("memjobDatetype", "1");
        map.put("memberCode", rebUpointsClearDomain.getMemberCode());
        map.put("memjobListDatetype", "3");
        map.put("memjobListDatatype", year.toString());
        QueryResult<RebMemjobList> monthMemjobs = this.rebMemjobListService.queryMemjobListPage(map);
        if (null != monthMemjobs && ListUtil.isNotEmpty((Collection)monthMemjobs.getList())) {
            memjobsList.addAll(monthMemjobs.getList());
        }
        map.put("memjobDatatype", year.toString());
        map.put("memjobDatetype", "3");
        QueryResult<RebMemjobList> yearMemjobs = this.rebMemjobListService.queryMemjobListPage(map);
        if (null != yearMemjobs && ListUtil.isNotEmpty((Collection)yearMemjobs.getList())) {
            memjobsList.addAll(yearMemjobs.getList());
        }
        if (ListUtil.isEmpty(memjobsList)) {
            this.logger.error("reb.RebMemjobServiceImpl.saveSendMemjob", (Object)"memjobsList is null");
            return null;
        }
        RebMemjobListDomain memjobListDomain = null;
        ArrayList<RebMemjobListDomain> joblistList = new ArrayList<RebMemjobListDomain>();
        for (RebMemjobList mem : memjobsList) {
            memjobListDomain = this.makeMemjobListDomain(null, mem);
            if (null == memjobListDomain) {
                this.logger.error("reb.RebMemjobServiceImpl.saveSendMemjob", (Object)"memjobListDomain is null");
                return null;
            }
            memjobListDomain.setMemjobListLimit(rebUpointsClearDomain.getUpointsClearNum2());
            memjobListDomain.setMemjobListExlimit(rebUpointsClearDomain.getUpointsClearNum2());
            memjobListDomain.setMemjobListExnum(rebUpointsClearDomain.getUpointsClearNum1());
            this.rebMemjobListService.updateMemjobListNum(memjobListDomain);
            joblistList.add(memjobListDomain);
        }
        return this.buidChannelsendList(joblistList, "insert");
    }

    private RebMemjobListDomain makeMemjobListDomain(RebMemjobListDomain rebMemjobListDomain, RebMemjobList rebMemjobList) {
        if (null == rebMemjobList) {
            return null;
        }
        if (null == rebMemjobListDomain) {
            rebMemjobListDomain = new RebMemjobListDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjobListDomain, (Object)rebMemjobList);
            return rebMemjobListDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.makeMemjobListDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebChannelsend> buidChannelsendList(List<RebMemjobListDomain> rebUpointsOpList, String dri) {
        if (ListUtil.isEmpty(rebUpointsOpList)) {
            return null;
        }
        ArrayList<RebChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<RebChannelsendDomain> disChannelsendDomainList = new ArrayList<RebChannelsendDomain>();
        for (RebMemjobListDomain rebUpointsOp : rebUpointsOpList) {
            RebChannelsendDomain pmChannelsendDomain = new RebChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(rebUpointsOp.getMemjobListCode());
            pmChannelsendDomain.setChannelsendType("rebMemjobListDomain");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)rebUpointsOp));
            pmChannelsendDomain.setTenantCode(rebUpointsOp.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.rebChannelsendService.saveSendRebChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<RebChannelsend> updateMemjobDate(Integer memjobListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == memjobListId || null == dataState || null == oldDataState) {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobDate", (Object)"pointsId is null");
            return null;
        }
        RebMemjobList rebMemjobList = this.rebMemjobListService.getMemjobList(memjobListId);
        if (null == rebMemjobList || !oldDataState.equals(rebMemjobList.getDataState())) {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobDate", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rebMemjobList));
            return null;
        }
        this.rebMemjobListService.updateMemjobListState(memjobListId, dataState, null, null);
        RebMemjobListDomain rebMemjobListDomain = this.makeMemjobListDomain(null, rebMemjobList);
        if (null == rebMemjobListDomain) {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobDate", (Object)"rebMemjobListDomain is null");
            return null;
        }
        ArrayList<RebMemjobListDomain> list = new ArrayList<RebMemjobListDomain>();
        list.add(rebMemjobListDomain);
        return this.buidChannelsendList(list, "newUpdate");
    }

    @Override
    public void updateMemjobStr(Integer pointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<RebChannelsend> list;
        if (null == pointsId) {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobStr", (Object)"pointsId is null");
        }
        if (ListUtil.isNotEmpty(list = this.updateMemjobDate(pointsId, dataState, oldDataState, map))) {
            RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), list));
        } else {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobStr.list");
        }
    }

    @Override
    public String updateMemjobDetail(RebMemjobListReDomain rebMemjobListReDomain) throws ApiException {
        if (null == rebMemjobListReDomain) {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobDetail", (Object)"rebMemjobListReDomain is null");
            return "error";
        }
        if (StringUtils.isNotBlank((String)rebMemjobListReDomain.getMemjobListCode()) || null == rebMemjobListReDomain.getDataState()) {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobDetail", (Object)"memjobListCode is null");
            return "error";
        }
        RebMemjobList rebMemjobList = this.rebMemjobListService.getMemjobListByCode(rebMemjobListReDomain.getTenantCode(), rebMemjobListReDomain.getMemjobListCode());
        if (rebMemjobList == null) {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobDetail", (Object)"rebMemjobList is null");
            return "error";
        }
        if (!"1".equals(rebMemjobList.getDataState())) {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobDetail", (Object)("\u72b6\u6001\u9519\u8bef" + rebMemjobList.getDataState()));
            return "error";
        }
        this.rebMemjobListService.updateMemjobListState(rebMemjobList.getMemjobListId(), rebMemjobListReDomain.getDataState(), Integer.valueOf("1"), null);
        if ("3".equals(rebMemjobListReDomain.getDataState())) {
            this.makeUpointList(rebMemjobList);
        }
        return "success";
    }

    public void makeUpointList(RebMemjobList rebMemjobList) {
        if (null == rebMemjobList) {
            this.logger.error("reb.RebMemjobServiceImpl.updateMemjobDetail", (Object)"rebMemjobList is null");
            return;
        }
        RebUpointsListDomain rebUpointsListDomain = new RebUpointsListDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsListDomain, (Object)rebMemjobList);
            rebUpointsListDomain.setUpointsListNum(rebMemjobList.getMemjobListExlimit());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rebUpointsService.saveUpointsListDemail(rebUpointsListDomain);
    }

    @Override
    public RebMemJobByMonthDomain queryMemJobByMonth(Map<String, Object> map) {
        if (map.get("memberCode") == null || map.get("tenantCode") == null) {
            return null;
        }
        RebMemJobByMonthDomain rebMemJobByMonthDomain = new RebMemJobByMonthDomain();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH");
        String gmtCreate = dateFormat.format(calendar.getTime()).substring(0, 10);
        String create = (String)map.get("gmtCreate");
        if (StringUtils.isNotBlank((String)create) && create.length() >= 10 && DATE_PATTERN.matcher(create.substring(0, 10)).matches()) {
            gmtCreate = create;
        }
        String gmtMo = String.valueOf(Integer.parseInt(gmtCreate.substring(5, 7)));
        String gmtYear = String.valueOf(Integer.parseInt(gmtCreate.substring(0, 4)));
        HashMap<String, Object> mapTem = new HashMap<String, Object>();
        mapTem.put("memberCode", map.get("memberCode"));
        mapTem.put("tenantCode", map.get("tenantCode"));
        HashMap<String, Object> ma = new HashMap<String, Object>();
        ma.put("map", JsonUtil.buildNormalBinder().toJson(mapTem));
        List<RebMemjob> o = this.queryMemjobModelPage(ma);
        HashMap<String, Object> mapTemp = new HashMap<String, Object>();
        mapTemp.put("memberCode", map.get("memberCode"));
        mapTemp.put("tenantCode", map.get("tenantCode"));
        mapTemp.put("memjobListName", gmtMo + "\u6708\u4efb\u52a1");
        mapTemp.put("memjobName", gmtYear + "\u5e74\u5ea6");
        HashMap<String, String> mapx = new HashMap<String, String>();
        mapx.put("map", JsonUtil.buildNormalBinder().toJson(mapTemp));
        String O = this.internalInvoke("reb.memjobList.queryMemjobListPage", mapx);
        QueryResult jsonToObject = (QueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(O, QueryResult.class);
        List rows = jsonToObject.getRows();
        double memjobListNum = rows.stream().mapToDouble(p -> (Double)((LinkedHashMap)p).get("memjobListNum")).sum();
        memjobListNum *= 10000.0;
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("memberCode", map.get("memberCode"));
        pmap.put("tenantCode", map.get("tenantCode"));
        pmap.put("gmtCreate", gmtCreate);
        String str = this.internalInvoke("sg.sendgoods.queryStatistical", pmap);
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToObject(str, List.class);
        HashMap mapNum = new HashMap();
        for (int i = 0; i < jsonToList.size(); ++i) {
            mapNum.put(String.valueOf(((Map)jsonToList.get(i)).get("DataState")), ((Map)jsonToList.get(i)).get("SumTotals"));
        }
        if (mapNum.get("9") != null) {
            rebMemJobByMonthDomain.setDeliveryAmount(String.valueOf(mapNum.get("9")));
        } else {
            rebMemJobByMonthDomain.setDeliveryAmount("0.000");
        }
        if (mapNum.get("8") != null) {
            rebMemJobByMonthDomain.setWaitDeliveryAmount(String.valueOf(mapNum.get("8")));
        } else {
            rebMemJobByMonthDomain.setWaitDeliveryAmount("0.000");
        }
        if (mapNum.get("10") != null) {
            rebMemJobByMonthDomain.setAuditAmount(String.valueOf(mapNum.get("10")));
        } else {
            rebMemJobByMonthDomain.setAuditAmount("0.000");
        }
        double SumTotals = jsonToList.stream().mapToDouble(p -> (Double)((LinkedHashMap)p).get("SumTotals")).sum();
        Double v = SumTotals / memjobListNum * 100.0;
        String Over = v > 0.0 && v < 10000.0 ? String.format("%.2f", v) + "%" : "0%";
        int ContinueRefueling = 0;
        int TempContinueRefueling = (int)(memjobListNum - SumTotals);
        if (TempContinueRefueling > 0) {
            ContinueRefueling = TempContinueRefueling;
        }
        int nowDate = Integer.parseInt(dateFormat.format(calendar.getTime()).substring(8, 10)) - 1;
        int nowHour = Integer.parseInt(dateFormat.format(calendar.getTime()).substring(11, 13));
        int lastDate = Integer.parseInt(DateUtils.lastDate().substring(8, 10));
        DecimalFormat df = new DecimalFormat("0");
        String Plan = df.format((float)nowDate / (float)lastDate * 100.0f + (float)(nowHour / 8)) + "%";
        rebMemJobByMonthDomain.setThisMonthTask(String.valueOf((int)memjobListNum));
        rebMemJobByMonthDomain.setContinueRefueling(String.valueOf(ContinueRefueling));
        rebMemJobByMonthDomain.setThisMonthTotal(String.valueOf((int)SumTotals));
        rebMemJobByMonthDomain.setCompletedProgress(Over);
        rebMemJobByMonthDomain.setTimeProgress(Plan);
        return rebMemJobByMonthDomain;
    }
}

