/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.reb.domain.OcContractReDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsClearDomain;
import com.yqbsoft.laser.service.reb.es.RebChannelSendPutThread;
import com.yqbsoft.laser.service.reb.model.RebChannelsend;
import com.yqbsoft.laser.service.reb.model.RebPoints;
import com.yqbsoft.laser.service.reb.model.RebUpointsClear;
import com.yqbsoft.laser.service.reb.model.RebUpointsOp;
import com.yqbsoft.laser.service.reb.service.RebPointsService;
import com.yqbsoft.laser.service.reb.service.RebUpointsClearBaseService;
import com.yqbsoft.laser.service.reb.service.RebUpointsClearService;
import com.yqbsoft.laser.service.reb.service.impl.RebChannelsendServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class RebUpointsClearBaseServiceImpl
extends BaseServiceImpl
implements RebUpointsClearBaseService {
    private static final String SYS_CODE = "reb.RebUpointsClearBaseServiceImpl";
    private RebUpointsClearService rebUpointsClearService;
    private RebPointsService rebPointsService;

    public RebPointsService getRebPointsService() {
        return this.rebPointsService;
    }

    public void setRebPointsService(RebPointsService rebPointsService) {
        this.rebPointsService = rebPointsService;
    }

    public RebUpointsClearService getRebUpointsClearService() {
        return this.rebUpointsClearService;
    }

    public void setRebUpointsClearService(RebUpointsClearService rebUpointsClearService) {
        this.rebUpointsClearService = rebUpointsClearService;
    }

    @Override
    public String sendUpointsClear(RebUpointsClearDomain rebUpointsClearDomain) throws ApiException {
        List<RebChannelsend> list = this.rebUpointsClearService.savesendUpointsClear(rebUpointsClearDomain);
        if (null == list) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClear.list");
            return "error";
        }
        if (!ListUtil.isNotEmpty(list)) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.syncShsettlOplistBatch.list");
            return "error";
        }
        RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), list));
        return "success";
    }

    @Override
    public String sendUpointsClearToPoints(RebUpointsClear rebUpointsClear) throws ApiException {
        List<RebChannelsend> rebUpointsList = this.rebUpointsClearService.saveSendUpointsClearToPoints(rebUpointsClear);
        if (null == rebUpointsList) {
            return "error";
        }
        if (null != rebUpointsList) {
            ArrayList<RebChannelsend> channelsendArrayList = new ArrayList<RebChannelsend>();
            channelsendArrayList.addAll(rebUpointsList);
            RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), channelsendArrayList));
        }
        return "success";
    }

    @Override
    public String sendUpointsClearForOp(RebUpointsOp rebUpointsOp) throws ApiException {
        if (null == rebUpointsOp) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsOpToClear", (Object)"rebUpointsOp is null");
            return "error";
        }
        RebUpointsClearDomain rebUpointsClearDomain = new RebUpointsClearDomain();
        rebUpointsClearDomain.setTenantCode(rebUpointsOp.getTenantCode());
        rebUpointsClearDomain.setUpointsType(rebUpointsOp.getUpointsType());
        rebUpointsClearDomain.setMemberCode(rebUpointsOp.getMemberCode());
        rebUpointsClearDomain.setMemberName(rebUpointsOp.getMemberName());
        rebUpointsClearDomain.setMemberMcode(rebUpointsOp.getMemberMcode());
        rebUpointsClearDomain.setMemberMname(rebUpointsOp.getMemberMname());
        rebUpointsClearDomain.setUpointsListExcode(rebUpointsOp.getUpointsListExcode());
        rebUpointsClearDomain.setUpointsListExname(rebUpointsOp.getUpointsListExname());
        rebUpointsClearDomain.setUpointsClearNum(rebUpointsOp.getUpointsOpNum());
        rebUpointsClearDomain.setUpointsClearOpcode(rebUpointsOp.getUpointsOpCode());
        rebUpointsClearDomain.setUpointsClearDirection("7");
        rebUpointsClearDomain.setPointsRuleApi("reb.upointsClearBase.sendUpointsClearForOp");
        rebUpointsClearDomain.setUpointsClearOpmark(rebUpointsOp.getUpointsOpType());
        return this.sendUpointsClear(rebUpointsClearDomain);
    }

    @Override
    public String sendUpointsClearForOpToUpoints(RebUpointsOp rebUpointsOp) throws ApiException {
        if (null == rebUpointsOp) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsOpToClear", (Object)"rebUpointsOp is null");
            return "error";
        }
        if (StringUtils.isBlank((String)rebUpointsOp.getChannelCode()) || StringUtils.isBlank((String)rebUpointsOp.getUpointsOpCode())) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearForOpToUpoints", (Object)"channelCode is null");
            return "error";
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("channelCode", rebUpointsOp.getChannelCode());
        objectMap.put("tenantCode", rebUpointsOp.getTenantCode());
        QueryResult<RebPoints> queryResultPoints = this.rebPointsService.queryPointsPage(objectMap);
        if (null == queryResultPoints || ListUtil.isEmpty((Collection)queryResultPoints.getList())) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearForOpToUpoints", (Object)"queryResultPoints is null");
            return "error";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", rebUpointsOp.getUpointsListExcode());
        paramMap.put("tenantCode", rebUpointsOp.getTenantCode());
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        OcContractReDomain ocContractReDomain = (OcContractReDomain)this.getForObject("oc.contract.getContractByCode", OcContractReDomain.class, sendMap);
        this.logger.info("ocContractReDomain====", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractReDomain));
        if (null == ocContractReDomain || ListUtil.isEmpty(ocContractReDomain.getGoodsList())) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearForOpToUpoints", (Object)"ocContractReDomain is null");
            return "error";
        }
        ArrayList<OcContractGoodsDomain> goodsDomainList = new ArrayList<OcContractGoodsDomain>();
        BigDecimal goodsMoery = BigDecimal.ZERO;
        for (OcContractGoodsDomain goodsDomain : ocContractReDomain.getGoodsList()) {
            if (!"17".equals(goodsDomain.getGoodsType())) continue;
            if (null == goodsDomain.getContractGoodsMoney() || "".equals(goodsDomain.getContractGoodsMoney())) {
                goodsDomain.setContractGoodsMoney(new BigDecimal(0));
            }
            goodsMoery = goodsMoery.add(goodsDomain.getContractGoodsMoney());
            goodsDomainList.add(goodsDomain);
        }
        if (ListUtil.isEmpty(goodsDomainList)) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearForOpToUpoints", (Object)"goodsDomainList is null");
            return "error";
        }
        if (goodsMoery.compareTo(new BigDecimal(0)) <= 0) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearForOpToUpoints.goodsMoery", (Object)goodsMoery);
            return "error";
        }
        RebPoints rebUpoints = (RebPoints)queryResultPoints.getList().get(0);
        BigDecimal pointsRatio = rebUpoints.getPointsRatio();
        if (null == pointsRatio || "".equals(pointsRatio)) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearForOpToUpoints.pointsRatio", (Object)pointsRatio);
            return "error";
        }
        BigDecimal flMonery = pointsRatio.divide(new BigDecimal("100")).multiply(goodsMoery);
        RebUpointsClearDomain rebUpointsClearDomain = new RebUpointsClearDomain();
        rebUpointsClearDomain.setTenantCode(rebUpointsOp.getTenantCode());
        rebUpointsClearDomain.setUpointsType(rebUpointsOp.getUpointsType());
        rebUpointsClearDomain.setMemberCode(rebUpointsOp.getMemberCode());
        rebUpointsClearDomain.setMemberName(rebUpointsOp.getMemberName());
        rebUpointsClearDomain.setMemberMcode(rebUpointsOp.getMemberMcode());
        rebUpointsClearDomain.setMemberMname(rebUpointsOp.getMemberMname());
        rebUpointsClearDomain.setUpointsListExcode(rebUpointsOp.getUpointsListExcode());
        rebUpointsClearDomain.setUpointsListExname(rebUpointsOp.getUpointsListExname());
        rebUpointsClearDomain.setUpointsClearOpcode1(rebUpointsOp.getUpointsListExname());
        rebUpointsClearDomain.setUpointsClearNum(rebUpointsOp.getUpointsOpNum());
        rebUpointsClearDomain.setUpointsClearNum1(ocContractReDomain.getDataBmoney());
        rebUpointsClearDomain.setUpointsClearNum2(flMonery);
        rebUpointsClearDomain.setUpointsClearOpcode(rebUpointsOp.getUpointsOpCode());
        rebUpointsClearDomain.setUpointsClearDirection("7");
        rebUpointsClearDomain.setPointsRuleApi("reb.upointsClearBase.sendUpointsClearForOp");
        rebUpointsClearDomain.setUpointsClearOpmark(rebUpointsOp.getUpointsOpType());
        return this.sendUpointsClearToUpoints(rebUpointsClearDomain);
    }

    @Override
    public String sendUpointsClearToUpoints(RebUpointsClearDomain rebUpointsClearDomain) throws ApiException {
        List<RebChannelsend> list = this.rebUpointsClearService.saveSendUpointsClearToUpoints(rebUpointsClearDomain);
        if (null == list) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearToUpoints.list");
            return "error";
        }
        if (!ListUtil.isNotEmpty(list)) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearToUpoints.list");
            return "error";
        }
        RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), list));
        return "success";
    }

    @Override
    public String sendUpointsClearToContract(RebUpointsClearDomain rebUpointsClearDomain) throws ApiException {
        List<RebChannelsend> list = this.rebUpointsClearService.saveSendUpointsClearToContract(rebUpointsClearDomain);
        if (null == list) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearToUpoints.list");
            return "error";
        }
        if (!ListUtil.isNotEmpty(list)) {
            this.logger.error("reb.RebUpointsClearBaseServiceImpl.sendUpointsClearToUpoints.list");
            return "error";
        }
        RebChannelsendServiceImpl.getSendService().addPutPool(new RebChannelSendPutThread(RebChannelsendServiceImpl.getSendService(), list));
        return "success";
    }
}

