/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebMemjobListMapper;
import com.yqbsoft.laser.service.reb.domain.RebMemjobListDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobListReDomain;
import com.yqbsoft.laser.service.reb.model.RebMemjobList;
import com.yqbsoft.laser.service.reb.service.RebMemjobListService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebMemjobListServiceImpl
extends BaseServiceImpl
implements RebMemjobListService {
    private static final String SYS_CODE = "reb.RebMemjobListServiceImpl";
    private RebMemjobListMapper rebMemjobListMapper;

    public void setRebMemjobListMapper(RebMemjobListMapper rebMemjobListMapper) {
        this.rebMemjobListMapper = rebMemjobListMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebMemjobListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMemjobList(RebMemjobListDomain rebMemjobListDomain) {
        if (null == rebMemjobListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebMemjobListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMemjobListDefault(RebMemjobList rebMemjobList) {
        if (null == rebMemjobList) {
            return;
        }
        if (null == rebMemjobList.getDataState()) {
            rebMemjobList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebMemjobList.getGmtCreate()) {
            rebMemjobList.setGmtCreate(date);
        }
        rebMemjobList.setGmtModified(date);
        if (StringUtils.isBlank((String)rebMemjobList.getMemjobListCode())) {
            rebMemjobList.setMemjobListCode(this.getNo(null, "RebMemjobList", "rebMemjobList", rebMemjobList.getTenantCode()));
        }
    }

    private int getMemjobListMaxCode() {
        int code = 0;
        try {
            return this.rebMemjobListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobListServiceImpl.getMemjobListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMemjobListUpdataDefault(RebMemjobList rebMemjobList) {
        if (null == rebMemjobList) {
            return;
        }
        rebMemjobList.setGmtModified(this.getSysDate());
    }

    private void saveMemjobListModel(RebMemjobList rebMemjobList) throws ApiException {
        if (null == rebMemjobList) {
            return;
        }
        try {
            this.rebMemjobListMapper.insert(rebMemjobList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobListServiceImpl.saveMemjobListModel.ex", (Throwable)e);
        }
    }

    private void saveMemjobListBatchModel(List<RebMemjobList> rebMemjobListList) throws ApiException {
        if (null == rebMemjobListList || rebMemjobListList.isEmpty()) {
            return;
        }
        try {
            this.rebMemjobListMapper.insertBatch(rebMemjobListList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobListServiceImpl.saveMemjobListBatchModel.ex", (Throwable)e);
        }
    }

    private RebMemjobList getMemjobListModelById(Integer memjobListId) {
        if (null == memjobListId) {
            return null;
        }
        try {
            return this.rebMemjobListMapper.selectByPrimaryKey(memjobListId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobListServiceImpl.getMemjobListModelById", (Throwable)e);
            return null;
        }
    }

    private RebMemjobList getMemjobListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebMemjobListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobListServiceImpl.getMemjobListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMemjobListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobListServiceImpl.delMemjobListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobListServiceImpl.delMemjobListModelByCode.num");
        }
    }

    private void deleteMemjobListModel(Integer memjobListId) throws ApiException {
        if (null == memjobListId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobListMapper.deleteByPrimaryKey(memjobListId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobListServiceImpl.deleteMemjobListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobListServiceImpl.deleteMemjobListModel.num");
        }
    }

    private void updateMemjobListModel(RebMemjobList rebMemjobList) throws ApiException {
        if (null == rebMemjobList) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobListMapper.updateByPrimaryKey(rebMemjobList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateMemjobListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateMemjobListModel.num");
        }
    }

    private void updateStateMemjobListModel(Integer memjobListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == memjobListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memjobListId", memjobListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebMemjobListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateStateMemjobListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateStateMemjobListModel.null");
        }
    }

    private void updateStateMemjobListModelByCode(String tenantCode, String memjobListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)memjobListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobListCode", memjobListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebMemjobListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateStateMemjobListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateStateMemjobListModelByCode.null");
        }
    }

    private RebMemjobList makeMemjobList(RebMemjobListDomain rebMemjobListDomain, RebMemjobList rebMemjobList) {
        if (null == rebMemjobListDomain) {
            return null;
        }
        if (null == rebMemjobList) {
            rebMemjobList = new RebMemjobList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjobList, (Object)rebMemjobListDomain);
            return rebMemjobList;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobListServiceImpl.makeMemjobList", (Throwable)e);
            return null;
        }
    }

    private RebMemjobListReDomain makeRebMemjobListReDomain(RebMemjobList rebMemjobList) {
        if (null == rebMemjobList) {
            return null;
        }
        RebMemjobListReDomain rebMemjobListReDomain = new RebMemjobListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjobListReDomain, (Object)rebMemjobList);
            return rebMemjobListReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobListServiceImpl.makeRebMemjobListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebMemjobList> queryMemjobListModelPage(Map<String, Object> parammap) {
        try {
            return this.rebMemjobListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobListServiceImpl.queryMemjobListModel", (Throwable)e);
            return null;
        }
    }

    private int countMemjobList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebMemjobListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobListServiceImpl.countMemjobList", (Throwable)e);
        }
        return i;
    }

    private RebMemjobList createRebMemjobList(RebMemjobListDomain rebMemjobListDomain) {
        String msg = this.checkMemjobList(rebMemjobListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebMemjobListServiceImpl.saveMemjobList.checkMemjobList", msg);
        }
        RebMemjobList rebMemjobList = this.makeMemjobList(rebMemjobListDomain, null);
        this.setMemjobListDefault(rebMemjobList);
        return rebMemjobList;
    }

    @Override
    public String saveMemjobList(RebMemjobListDomain rebMemjobListDomain) throws ApiException {
        RebMemjobList rebMemjobList = this.createRebMemjobList(rebMemjobListDomain);
        this.saveMemjobListModel(rebMemjobList);
        return rebMemjobList.getMemjobListCode();
    }

    @Override
    public String saveMemjobListBatch(List<RebMemjobListDomain> rebMemjobListDomainList) throws ApiException {
        if (null == rebMemjobListDomainList || rebMemjobListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebMemjobList> rebMemjobListList = new ArrayList<RebMemjobList>();
        String code = "";
        for (RebMemjobListDomain rebMemjobListDomain : rebMemjobListDomainList) {
            RebMemjobList rebMemjobList = this.createRebMemjobList(rebMemjobListDomain);
            code = rebMemjobList.getMemjobListCode();
            rebMemjobListList.add(rebMemjobList);
        }
        this.saveMemjobListBatchModel(rebMemjobListList);
        return code;
    }

    @Override
    public void updateMemjobListState(Integer memjobListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == memjobListId) {
            return;
        }
        this.updateStateMemjobListModel(memjobListId, dataState, oldDataState, map);
    }

    @Override
    public void updateMemjobListStateByCode(String tenantCode, String memjobListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)memjobListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMemjobListModelByCode(tenantCode, memjobListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMemjobList(RebMemjobListDomain rebMemjobListDomain) throws ApiException {
        String msg = this.checkMemjobList(rebMemjobListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateMemjobList.checkMemjobList", msg);
        }
        RebMemjobList oldRebMemjobList = this.getMemjobListModelById(rebMemjobListDomain.getMemjobListId());
        if (null == oldRebMemjobList) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateMemjobList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebMemjobList rebMemjobList = this.makeMemjobList(rebMemjobListDomain, oldRebMemjobList);
        this.setMemjobListUpdataDefault(rebMemjobList);
        this.updateMemjobListModel(rebMemjobList);
    }

    @Override
    public RebMemjobList getMemjobList(Integer memjobListId) {
        if (null == memjobListId) {
            return null;
        }
        return this.getMemjobListModelById(memjobListId);
    }

    @Override
    public void deleteMemjobList(Integer memjobListId) throws ApiException {
        if (null == memjobListId) {
            return;
        }
        this.deleteMemjobListModel(memjobListId);
    }

    @Override
    public QueryResult<RebMemjobList> queryMemjobListPage(Map<String, Object> map) {
        List<RebMemjobList> rebMemjobListList = this.queryMemjobListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMemjobList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebMemjobListList);
        return queryResult;
    }

    @Override
    public RebMemjobList getMemjobListByCode(String tenantCode, String memjobListCode) throws ApiException {
        if (StringUtils.isBlank((String)memjobListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobListCode", memjobListCode);
        return this.getMemjobListModelByCode(map);
    }

    @Override
    public void deleteMemjobListByCode(String tenantCode, String memjobListCode) throws ApiException {
        if (StringUtils.isBlank((String)memjobListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobListCode", memjobListCode);
        this.delMemjobListModelByCode(map);
    }

    @Override
    public void updateMemjobListNum(RebMemjobListDomain rebMemjobListDomain) throws ApiException {
        String msg = this.checkMemjobList(rebMemjobListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateMemjobList.checkMemjobList", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", rebMemjobListDomain.getTenantCode());
        map.put("memjobListId", rebMemjobListDomain.getMemjobListId());
        map.put("memjobListExnum", rebMemjobListDomain.getMemjobListExnum());
        map.put("memjobListExlimit", rebMemjobListDomain.getMemjobListExlimit());
        map.put("memjobListLimit", rebMemjobListDomain.getMemjobListLimit());
        this.updateMemjobListNumModel(map);
    }

    private void updateMemjobListNumModel(Map map) throws ApiException {
        if (MapUtil.isEmpty((Map)map)) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobListMapper.updateNumByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateMemjobListNumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobListServiceImpl.updateMemjobListNumModel.num", JsonUtil.buildNonNullBinder().toJson((Object)map));
        }
    }
}

