/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.channeles.ChannelGoodsBean;
import com.yqbsoft.laser.service.resources.domain.ChannelScopeDomain;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisDgnumDomain;
import com.yqbsoft.laser.service.resources.domain.DisDgnumList;
import com.yqbsoft.laser.service.resources.domain.DisDgoods;
import com.yqbsoft.laser.service.resources.domain.DisDgoodsScopelistDomain;
import com.yqbsoft.laser.service.resources.domain.DisDpriceConfDomain;
import com.yqbsoft.laser.service.resources.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.EditSkuDomain;
import com.yqbsoft.laser.service.resources.domain.GoodsBean;
import com.yqbsoft.laser.service.resources.domain.OcReorderDomain;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.domain.RsBrandDomain;
import com.yqbsoft.laser.service.resources.domain.RsBrandauDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.resources.domain.RsDisListDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRtagDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsShopDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.StockDomain;
import com.yqbsoft.laser.service.resources.enumc.ResourcesStartCon;
import com.yqbsoft.laser.service.resources.model.RsChannlSku;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.service.RsBrandService;
import com.yqbsoft.laser.service.resources.service.RsBrandauService;
import com.yqbsoft.laser.service.resources.service.RsChannelgoodsService;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsDisListService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassService;
import com.yqbsoft.laser.service.resources.service.RsGoodsRtagService;
import com.yqbsoft.laser.service.resources.service.RsGoodsShopService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsResourceListService;
import com.yqbsoft.laser.service.resources.service.RsResourceService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class RsResourceServiceImpl
extends BaseServiceImpl
implements RsResourceService {
    public static final String SYS_CODE = "rs.RsResourceServiceImpl";
    private RsResourceGoodsService rsResourceGoodsService;
    private RsResourceListService rsResourceListService;
    private RsSenddataBaseService rsSenddataBaseService;
    private RsGoodsClassService rsGoodsClassService;
    private RsBrandService rsBrandService;
    private RsBrandauService rsBrandauService;
    private RsClasstreeService rsClasstreeService;
    private RsSkuService rsSkuService;
    private RsGoodsShopService rsGoodsShopService;
    RsGoodsRtagService rsGoodsRtagService;
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";
    RsChannelgoodsService rsChannelgoodsService;
    RsDisListService rsDisListService;

    public RsGoodsRtagService getRsGoodsRtagService() {
        return this.rsGoodsRtagService;
    }

    public void setRsGoodsRtagService(RsGoodsRtagService rsGoodsRtagService) {
        this.rsGoodsRtagService = rsGoodsRtagService;
    }

    public RsGoodsShopService getRsGoodsShopService() {
        return this.rsGoodsShopService;
    }

    public void setRsGoodsShopService(RsGoodsShopService rsGoodsShopService) {
        this.rsGoodsShopService = rsGoodsShopService;
    }

    public void setRsSkuService(RsSkuService rsSkuService) {
        this.rsSkuService = rsSkuService;
    }

    public void setRsGoodsClassService(RsGoodsClassService rsGoodsClassService) {
        this.rsGoodsClassService = rsGoodsClassService;
    }

    public RsClasstreeService getRsClasstreeService() {
        if (null == this.rsClasstreeService) {
            this.rsClasstreeService = (RsClasstreeService)ApplicationContextUtil.getService((String)"rsClasstreeService");
        }
        if (null == this.rsClasstreeService) {
            this.logger.error("rs.RsResourceServiceImpl.getRsClasstreeService.null");
        }
        return this.rsClasstreeService;
    }

    public RsBrandService getRsBrandService() {
        if (null == this.rsBrandService) {
            this.rsBrandService = (RsBrandService)ApplicationContextUtil.getService((String)"rsBrandService");
        }
        return this.rsBrandService;
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public RsResourceListService getRsResourceListService() {
        return this.rsResourceListService;
    }

    public void setRsResourceListService(RsResourceListService rsResourceListService) {
        this.rsResourceListService = rsResourceListService;
    }

    public RsResourceGoodsService getRsResourceGoodsService() {
        return this.rsResourceGoodsService;
    }

    public void setRsResourceGoodsService(RsResourceGoodsService rsResourceGoodsService) {
        this.rsResourceGoodsService = rsResourceGoodsService;
    }

    public RsBrandauService getRsBrandauService() {
        return this.rsBrandauService;
    }

    public void setRsBrandauService(RsBrandauService rsBrandauService) {
        this.rsBrandauService = rsBrandauService;
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), true);
    }

    private OcReorderDomain sendSaveResources(List<ResourceStockDomain> resourceGoodsList, String type, boolean channelflag) {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (ListUtil.isEmpty(resourceGoodsList)) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        String key = resourceGoodsList.get(0).getContractBillcode() + "-" + resourceGoodsList.get(0).getTenantCode();
        try {
            List<RsSenddata> rsSenddataList = channelflag ? this.rsResourceGoodsService.updateResourceChannleStock(resourceGoodsList, type) : this.rsResourceGoodsService.updateResourceStock(resourceGoodsList, type);
            ocReorderDomain.setOrderState("2");
            this.getRsSenddataBaseService().sendData(rsSenddataList);
            this.logger.info("rs.RsResourceServiceImpl.sendSaveResources.sendSaveResources", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocReorderDomain));
            return ocReorderDomain;
        }
        catch (ApiException e) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveResources.apierror", (Object)e.getMessage());
            ocReorderDomain.setOrderState("3");
            DisUtil.set((String)("goods-" + key), (String)(e.getErrCode() + "-" + e.getErrMsg()), (int)7200);
            return ocReorderDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveResources.error", (Object)e.getMessage());
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), true);
    }

    @Override
    public String updateResourceStockByOrderJst(List<ResourceStockDomain> resourceGoodsList) {
        return this.rsResourceGoodsService.updateResourceStockJst(resourceGoodsList);
    }

    @Override
    public String updateResourceStockByOrderJstByBack(List<ResourceStockDomain> resourceGoodsList) {
        return this.rsResourceGoodsService.updateResourceStockBackJst(resourceGoodsList);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByPayBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAYBACK.getCode(), true);
    }

    @Override
    public String sendUpdateResourceStockByPayBackNode(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        OcReorderDomain ocReorderDomain = this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAYBACK.getCode(), true);
        if ("2".equals(ocReorderDomain.getOrderState())) {
            return "success";
        }
        return "fail";
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByPayBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAYBACK.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByCom(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (ListUtil.isEmpty(resourceGoodsList)) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        return this.sendSaveResources(resourceGoodsList, resourceGoodsList.get(0).getType(), true);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByCom(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (ListUtil.isEmpty(resourceGoodsList)) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        return this.sendSaveResources(resourceGoodsList, resourceGoodsList.get(0).getType(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), true);
    }

    @Override
    public String sendSaveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        this.logger.debug("========================>1", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain));
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveResourceGoods(rsResourceGoodsDomain);
        this.logger.debug("========================>2", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain));
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsResourceGoodsDomain.getGoodsCode();
    }

    @Override
    public void sendSavePassResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.savePassResourceGoodsBatch(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendSavePassResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.savePassResourceGoods(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsResourceGoodsDomain.getGoodsCode();
    }

    @Override
    public void sendSaveResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveResourceGoodsBatch(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        this.rsResourceGoodsService.updateResourceGoods(rsResourceGoodsDomain);
    }

    @Override
    public void sendDelResourceGoodsByCode(Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.delResourceGoodsByCode(map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateShelveGoods(List<Integer> goodsIds) throws ApiException {
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        ArrayList<RsResourceGoods> goodsList = new ArrayList<RsResourceGoods>();
        for (Integer goodsId : goodsIds) {
            RsResourceGoods rsResourceGoods = this.rsResourceGoodsService.getResourceGoodsModel(goodsId);
            goodsList.add(rsResourceGoods);
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveGoodList(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutGoods(List<Integer> goodsIds) throws ApiException {
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        ArrayList<RsResourceGoods> goodsList = new ArrayList<RsResourceGoods>();
        for (Integer goodsId : goodsIds) {
            RsResourceGoods rsResourceGoods = this.rsResourceGoodsService.getResourceGoodsModel(goodsId);
            goodsList.add(rsResourceGoods);
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutGoodsList(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendStopShopAndSoldOutGoods(String memberCode, String tenentCode, String channelCode) throws ApiException {
        int page = 1;
        int rows = 300;
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenentCode)) {
            this.logger.error("rs.RsResourceServiceImpl.sendStopShopAndSoldOutGoods param is null", (Object)(memberCode + "--" + tenentCode));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenentCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            param.put("channelCode", channelCode);
        }
        param.put("rows", rows);
        while (true) {
            param.put("page", page);
            this.makeDefPage(param);
            List<RsResourceGoods> rsResourceGoods = this.rsResourceGoodsService.queryResourceGoodsReModePage(param);
            if (ListUtil.isEmpty(rsResourceGoods)) {
                return;
            }
            List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutGoodsList(rsResourceGoods);
            if (ListUtil.isNotEmpty(rsSenddataList)) {
                this.getRsSenddataBaseService().sendOpData(rsSenddataList);
            }
            ++page;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected void makeDefPage(Map<String, Object> param) {
        if (null == param) {
            return;
        }
        int page = 1;
        int rows = 10;
        if (null == param.get("page")) {
            param.put("page", page);
            param.put("rows", rows);
            param.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
            param.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            return;
        }
        rows = Integer.valueOf(String.valueOf(param.get("rows")));
        page = Integer.valueOf(String.valueOf(param.get("page")));
        if (rows > 100) {
            rows = 100;
            param.put("rows", rows);
        }
        param.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
        param.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
    }

    @Override
    public String sendDeletePromotione(String tenantCode, String channelCode, String promotionCode) throws ApiException {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        Map map = new HashMap();
        map = this.getQueryMapParam("dataOpbillstate,ginfoCode,tenantCode", new Object[]{1, promotionCode, tenantCode});
        List<RsResourceGoods> rlist = this.rsResourceGoodsService.queryResourceGoodsReModePage(map);
        if (ListUtil.isEmpty(rlist)) {
            return "success";
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutGoodsList(rlist);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public void sendUpdateAuditResource(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResource(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateCanlAuditResource(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditCanlResource(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResourcePass(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResourcePass(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResourceNoPass(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResourceNoPass(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateGoodsStateByIdForMemo(Integer goodsId, Integer dataState, Integer oldDataState, Map<String, Object> paramMap) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateGoodsStateByIdForMemo(goodsId, dataState, oldDataState, paramMap);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateGoodsStateById(Integer goodsId, Integer dataState, Integer oldDataState) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateGoodsStateById(goodsId, dataState, oldDataState);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuStateById(Integer skuId, Integer dataState, Integer oldDataState) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuStateById(skuId, dataState, oldDataState);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteGoodsById(Integer goodsId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteGoodsById(goodsId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteResourceGoodsList(List<Integer> goodsIds) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteResourceGoodsList(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutSku(Integer skuId) throws ApiException {
        RsSku rsSku = this.rsSkuService.getSku(skuId);
        if (rsSku == null) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateSoldOutSku.null", "rsSku is null");
        }
        if (ResourcesConstants.DATA_OPBILLSTATE_0.intValue() == rsSku.getDataOpbillstate().intValue()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateSoldOutSku.null", "\u72b6\u6001\u9519\u8bef");
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutSkuModel(rsSku);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateShelveSku(Integer skuId) {
        RsSku rsSku = this.rsSkuService.getSku(skuId);
        if (rsSku == null) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateShelveSku.null", "rsSku is null");
        }
        if (ResourcesConstants.DATA_OPBILLSTATE_1.intValue() == rsSku.getDataOpbillstate().intValue()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateShelveSku.null", "\u72b6\u6001\u9519\u8bef");
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveSkuModel(rsSku);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuEdit(EditSkuDomain editSkuDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuEdit(editSkuDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateBatchSkuEdit(List<EditSkuDomain> editSkuDomainList) throws ApiException {
        if (ListUtil.isEmpty(editSkuDomainList)) {
            return null;
        }
        String msg = "";
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuBatchEdit(editSkuDomainList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return msg;
    }

    @Override
    public void sendUpdateSkuEditErp(EditSkuDomain editSkuDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuErpEdit(editSkuDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuChannel(String goodsCode, String skuCode, String skuOldcode, String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuChannel(goodsCode, skuCode, skuOldcode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendChData(rsSenddataList);
        }
    }

    @Override
    public List<RsSenddata> sendSaveDisResourceGoods(List<DisRsResourceGoodsDomain> disRsResourceGoodsList) throws ApiException {
        return this.rsResourceGoodsService.saveDisResourceGoods(disRsResourceGoodsList);
    }

    @Override
    public List<RsSenddata> sendSaveDisSku(List<DisRsSkuDomain> disRsSkuList) throws ApiException {
        return this.rsResourceGoodsService.saveDisSku(disRsSkuList);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuOldcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateDisCannelSku", "param is null");
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("skuOldcode", skuOldcode);
        parammap.put("tenantCode", tenantCode);
        parammap.put("channelCode", channelCode);
        parammap.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
        QueryResult<RsSku> qllist = this.rsSkuService.querySkuOnePage(parammap);
        if (null == qllist || ListUtil.isEmpty((Collection)qllist.getList())) {
            return null;
        }
        return this.rsResourceGoodsService.updateDisCannelSkuModel(qllist.getList());
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelGoods(String goodsOldcode, String channelCode, String tenantCode) throws ApiException {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("goodsOldcode", goodsOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        parammap.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
        List<RsResourceGoods> goodsList = this.rsResourceGoodsService.queryResourceGoodsReModePage(parammap);
        if (null == goodsList || goodsList.isEmpty()) {
            return null;
        }
        return this.rsResourceGoodsService.updateDisCannelGoodsModel(goodsList);
    }

    @Override
    public List<RsSenddata> sendDeleteDisSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        QueryResult<RsSku> qllist;
        if (StringUtils.isBlank((String)skuOldcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("skuOldcode", skuOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (qllist = this.rsSkuService.querySkuOnePage(parammap)) || ListUtil.isEmpty((Collection)qllist.getList())) {
            return null;
        }
        return this.rsResourceGoodsService.deleteDisSkuModel(qllist.getList());
    }

    @Override
    public List<RsSenddata> sendDeleteDisGoods(String goodsOldcode, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsOldcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("goodsOldcode", goodsOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        List<RsResourceGoods> goodsList = this.rsResourceGoodsService.queryResourceGoodsReModePage(parammap);
        return this.rsResourceGoodsService.deleteDisGoodsModel(goodsList);
    }

    @Override
    public List<RsSenddata> sendSaveDisSkuEdit(List<DisRsSkuDomain> disRsSkuList) {
        List<EditSkuDomain> list = this.rsResourceGoodsService.getMakeDisSkuEdit(disRsSkuList);
        return this.rsResourceGoodsService.updateSkuBatchEdit(list);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelGoodsState(Map<String, Object> map) {
        return this.rsResourceGoodsService.updateDisCannelGoodsState(map);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelSkuState(Map<String, Object> map) {
        return this.rsResourceGoodsService.updateDisCannelSkuState(map);
    }

    @Override
    public void sendDeleteSkuBySkuId(Integer skuId) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteSkuBySkuId(skuId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateChannelGoods(String channelCode, String tenantCode) {
        this.rsResourceGoodsService.updateChannelGoods(channelCode, tenantCode);
        return "success";
    }

    @Override
    public void sendUpdateChannelScope(String channelCode, String tenantCode, ChannelScopeDomain channelScopeDomain) throws ApiException {
        Map<String, String> tmap;
        HashMap<String, Object> map;
        this.logger.debug("rs.RsResourceServiceImpl.=======sendUpdateChannelScope=======>", (Object)("tenantCode" + tenantCode + "channelCode" + channelCode + "channelScopeDomain" + JsonUtil.buildNormalBinder().toJson((Object)channelScopeDomain)));
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode) || null == channelScopeDomain) {
            return;
        }
        Map<String, Map<String, String>> delMap = channelScopeDomain.getDelmap();
        Map<String, Map<String, String>> updateMap = channelScopeDomain.getUpdatemap();
        if (MapUtil.isNotEmpty(delMap)) {
            map = new HashMap<String, Object>();
            map.put("channelCode", channelCode);
            map.put("tenantCode", tenantCode);
            map.put("updateType", channelScopeDomain.getUpdateType());
            for (String key : delMap.keySet()) {
                tmap = delMap.get(key);
                if (MapUtil.isEmpty(tmap)) continue;
                for (String term : tmap.keySet()) {
                    if ("=".equals(term)) {
                        map.put(key, tmap.get(term));
                        continue;
                    }
                    map.put(key + "not", tmap.get(term));
                }
            }
            this.rsResourceGoodsService.deleteChannelGoods(channelCode, tenantCode, map);
        }
        if (MapUtil.isNotEmpty(updateMap)) {
            map = new HashMap();
            map.put("channelCode", channelCode);
            map.put("tenantCode", tenantCode);
            map.put("updateType", channelScopeDomain.getUpdateType());
            for (String key : updateMap.keySet()) {
                tmap = updateMap.get(key);
                if (MapUtil.isEmpty(tmap)) continue;
                for (String term : tmap.keySet()) {
                    if ("=".equals(term)) {
                        map.put(key, tmap.get(term));
                        continue;
                    }
                    map.put(key + "not", tmap.get(term));
                }
            }
            this.sendUpdateChannelQuwey(map);
        }
    }

    @Override
    public String sendUpdateChannelQuwey(Map<String, Object> map) {
        this.logger.debug("=======sendUpdateChannelQuwey=======>", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isNotEmpty(map) && null != map.get("skuNo") && StringUtils.isNotBlank((String)String.valueOf(map.get("skuNo")))) {
            this.rsResourceGoodsService.updateChannelSkuQuwey(map);
        } else if (MapUtil.isNotEmpty(map) && null != map.get("goodsNo") && StringUtils.isNotBlank((String)String.valueOf(map.get("goodsNo")))) {
            this.rsResourceGoodsService.updateChannelSkuQuwey(map);
        } else {
            this.rsResourceGoodsService.updateChannelQuwey(map);
        }
        return "";
    }

    @Override
    public String sendUpdateChannelSkuQuwey(Map<String, Object> map) {
        this.rsResourceGoodsService.updateChannelSkuQuwey(map);
        return "";
    }

    @Override
    public void sendSaveChannelGoods(ChannelGoodsBean channelGoodsBean) {
        if (null == channelGoodsBean) {
            return;
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveChannelGoods(channelGoodsBean);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendChData(rsSenddataList);
        }
    }

    @Override
    public void sendDelChannelGoods(ChannelGoodsBean channelGoodsBean) {
        if (null == channelGoodsBean) {
            return;
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteChannelGoods(channelGoodsBean);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendChData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateSkuNum(String skuNo, BigDecimal goodsNum, BigDecimal goodsWeight, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuNum(skuNo, goodsNum, goodsWeight, memberCode, memberCcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public String sendToUpdateSkuNum(String skuNo, BigDecimal goodsNum, String tenantCode, String type) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuNumTwo(skuNo, goodsNum, tenantCode, type);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public String sendToUpdateSkuNumAndHouse(String skuNo, BigDecimal goodsNum, String tenantCode, String type, Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuNumThree(skuNo, goodsNum, tenantCode, type, map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public String beforeSendUpdateSkuNum(String skuNo, String goodsNum, String goodsWeight, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        BigDecimal bigDecimalNum = new BigDecimal(goodsNum);
        BigDecimal bigDecimalWeight = new BigDecimal(goodsWeight);
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuNum(skuNo, bigDecimalNum, bigDecimalWeight, memberCode, memberCcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public String sendUpdateSkuLockNum(StockDomain stockDomain) {
        return this.rsResourceGoodsService.updateSkuLockNum(stockDomain);
    }

    @Override
    public String sendSaveGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.saveGoodsClass(rsGoodsClassDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
            return rsSenddataList.get(0).getFdBizcode();
        }
        return null;
    }

    @Override
    public void sendUpdateGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.updateGoodsClass(rsGoodsClassDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteGoodsClass(Integer goodsClassId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.deleteGoodsClass(goodsClassId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDelGoodsClassByCode(Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.delGoodsClassByCode(map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public void sendSaveGoodsClassInit(String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.saveGoodsClassInit(tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateGoodsClassChannelInit(String tenantCode) {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.updateGoodsClassChannelInit(tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
        return "";
    }

    @Override
    public void sendUpdateGoodsEocode(String goodsCode, String goodsEocode, String tenantCode) throws ApiException {
        this.rsResourceGoodsService.updateGoodsEocode(goodsCode, goodsEocode, tenantCode);
    }

    @Override
    public void sendUpdateSkuEocode(String skuCode, String skuEocode, String tenantCode) throws ApiException {
        this.rsResourceGoodsService.updateSkuEocode(skuCode, skuEocode, tenantCode);
    }

    @Override
    public void sendUpdateShelveBatchSku(List<Integer> skuIdList) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveBatchSku(skuIdList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutBatchSku(List<Integer> skuIdList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutBatchSku(skuIdList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteBatchSkuBySkuId(List<Integer> skuIdList) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteBatchSkuBySkuId(skuIdList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendSaveBrand(RsBrandDomain rsBrandDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandService().saveBrand(rsBrandDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsBrandDomain.getBrandCode();
    }

    @Override
    public void sendUpdateBrand(RsBrandDomain rsBrandDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandService().updateBrand(rsBrandDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateBrandau(RsBrandauDomain rsBrandauDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandauService().sendUpdateBrandau(rsBrandauDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteBrand(Integer brandId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandService().deleteBrand(brandId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendSaveClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        if (null == rsClasstreeDomain) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveClasstree.null");
            return "";
        }
        RsClasstree rsClasstree = this.getRsClasstreeService().checkClasstreeNameByChannelCode(rsClasstreeDomain.getClasstreeName(), rsClasstreeDomain.getTenantCode(), rsClasstreeDomain.getChannelCode());
        if (null == rsClasstree) {
            List<RsSenddata> rsSenddataList = this.getRsClasstreeService().saveClasstree(rsClasstreeDomain);
            if (ListUtil.isNotEmpty(rsSenddataList)) {
                this.getRsSenddataBaseService().sendOpData(rsSenddataList);
            }
        } else {
            return rsClasstree.getClasstreeCode();
        }
        return rsClasstreeDomain.getClasstreeCode();
    }

    @Override
    public String sendSaveClasstreeTow(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsClasstreeService().saveClasstree(rsClasstreeDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsClasstreeDomain.getClasstreeCode();
    }

    @Override
    public void sendUpdateClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsClasstreeService().updateClasstree(rsClasstreeDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteClasstree(Integer classtreeId) throws ApiException {
        List<RsSenddata> rsSenddataList;
        if (StringUtils.isBlank((Integer)classtreeId)) {
            this.logger.error("rs.RsResourceServiceImpl.sendDeleteClasstree", (Object)classtreeId);
        }
        if (ListUtil.isNotEmpty(rsSenddataList = this.getRsClasstreeService().deleteClasstree(classtreeId))) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendupdateOrder(List<RsGoodsClassDomain> rsGoodsClassDomains) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsClassDomains)) {
            this.logger.error("rs.RsResourceServiceImpl.sendupdateOrder", rsGoodsClassDomains);
            return;
        }
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.updateOrderBatch(rsGoodsClassDomains);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public RsResourceGoodsReDomain getResourceGoodsReDomain(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("rs.RsResourceServiceImpl.getResourceGoodsReDomain");
            return null;
        }
        String skuNo = (String)map.get("skuNo");
        String goodsType = (String)map.get("goodsType");
        String memberCode = (String)map.get("memberCode");
        String memberCcode = (String)map.get("memberCcode");
        String channelCode = (String)map.get("channelCode");
        String tenantCode = (String)map.get("tenantCode");
        String goodsPro = null == map.get("goodsPro") ? null : (String)map.get("goodsPro");
        boolean flag = false;
        if (StringUtils.isBlank((String)goodsType) && StringUtils.isNotBlank((String)goodsPro) && "6".equals(goodsPro)) {
            goodsType = "06,28";
        } else if (StringUtils.isBlank((String)goodsType)) {
            goodsType = "26";
            flag = true;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuNo, memberCode, memberCcode, channelCode, goodsType, tenantCode);
        if (null == goodsBean && flag) {
            goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuNo, memberCode, memberCcode, channelCode, "00", tenantCode);
        }
        if (null == goodsBean) {
            this.logger.error("rs.RsResourceServiceImpl.getResourceBySkuNoType.", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.makeReDomain(goodsBean.getRsResourceGoods(), false);
        return rsResourceGoodsReDomain;
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByOrderStr(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResourcesStr(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), false);
    }

    private OcReorderDomain sendSaveResourcesStr(List<ResourceStockDomain> resourceGoodsList, String type, boolean channelflag) {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (null == resourceGoodsList || resourceGoodsList.isEmpty()) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        try {
            List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateResourceStockStr(resourceGoodsList, type);
            ocReorderDomain.setOrderState("2");
            this.getRsSenddataBaseService().sendData(rsSenddataList);
            return ocReorderDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveResources.error", (Object)e.getMessage());
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByBackStr(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResourcesStr(resourceGoodsList, ResourcesStartCon.BACK.getCode(), false);
    }

    @Override
    public void sendDeleteSku(String skuEcode, String goodsType, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuEcode, null, null, channelCode, goodsType, tenantCode);
        if (null == goodsBean || null == goodsBean.getRsSku()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendDeleteSku.goodsBean", skuEcode + "=" + goodsType + "=" + channelCode + "=" + tenantCode);
        }
        ArrayList<Integer> skuIdList = new ArrayList<Integer>();
        skuIdList.add(goodsBean.getRsSku().getSkuId());
        this.sendDeleteBatchSkuBySkuId(skuIdList);
    }

    @Override
    public void sendUpdateShelveSku(String skuEcode, String goodsType, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuEcode, null, null, channelCode, goodsType, tenantCode);
        if (null == goodsBean || null == goodsBean.getRsSku()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateShelveSku.goodsBean", skuEcode + "=" + goodsType + "=" + channelCode + "=" + tenantCode);
        }
        this.sendUpdateShelveSku(goodsBean.getRsSku().getSkuId());
    }

    @Override
    public void sendUpdateSoldOutSku(String skuEcode, String goodsType, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuEcode, null, null, channelCode, goodsType, tenantCode);
        if (null == goodsBean || null == goodsBean.getRsSku()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateSoldOutSku.goodsBean", skuEcode + "=" + goodsType + "=" + channelCode + "=" + tenantCode);
        }
        ArrayList<Integer> skuIdList = new ArrayList<Integer>();
        skuIdList.add(goodsBean.getRsSku().getSkuId());
        this.sendUpdateSoldOutBatchSku(skuIdList);
    }

    @Override
    public void updateBrandauState(Integer brandauId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        List<RsSenddata> list = this.rsBrandauService.updateBrandauState(brandauId, dataState, oldDataState, memo);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendOpData(list);
        }
    }

    @Override
    public void updateBrandauStateByCode(String tenantCode, String brandauCode, Integer dataState, Integer oldDataState) throws ApiException {
        List<RsSenddata> list = this.rsBrandauService.updateBrandauStateByCode(tenantCode, brandauCode, dataState, oldDataState);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendOpData(list);
        }
    }

    @Override
    public void updateGoodsRelNum(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        List<RsSenddata> list = this.rsResourceGoodsService.updateGoodsRelNum(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendDeleteGoodsRtag(Integer goodsRtagId) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.deleteGoodsRtag(goodsRtagId);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public String sendSaveGoodsRtag(RsGoodsRtagDomain rsGoodsRtagDomain) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.saveGoodsRtag(rsGoodsRtagDomain);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
            return list.get(0).getFdBizcode();
        }
        return null;
    }

    @Override
    public String sendSaveGoodsRtagBatch(List<RsGoodsRtagDomain> rsGoodsRtagDomainList) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.saveGoodsRtagBatch(rsGoodsRtagDomainList);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
            return list.get(0).getFdBizcode();
        }
        return null;
    }

    @Override
    public void sendUpdateGoodsRtagState(Integer goodsRtagId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateGoodsRtagState(goodsRtagId, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendUpdateGoodsRtagStateByCode(String tenantCode, String goodsRtagCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateGoodsRtagStateByCode(tenantCode, goodsRtagCode, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendUpdateGoodsRtag(RsGoodsRtagDomain rsGoodsRtagDomain) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateGoodsRtag(rsGoodsRtagDomain);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendDeleteGoodsRtagByCode(String tenantCode, String goodsRtagCode) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.deleteGoodsRtagByCode(tenantCode, goodsRtagCode);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendUpdateByRtagCode(RsGoodsRtagDomain rsGoodsRtagDomain) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateByRtagCode(rsGoodsRtagDomain);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendDeleteGoodsRtagList(List<RsGoodsRtagDomain> rsGoodsRtagDomainList) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.deleteGoodsRtagList(rsGoodsRtagDomainList);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendUpdateStateList(String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateStateList(tenantCode, dataState, oldDataState);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public String sendSaveGoodsShopBatchByGoodsCode(List<RsGoodsShopDomain> rsGoodsShopDomainList) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsShopDomainList)) {
            return null;
        }
        String goodsNoStr = this.rsGoodsShopService.saveGoodsShopBatchByGoodsCode(rsGoodsShopDomainList);
        if (StringUtils.isBlank((String)goodsNoStr)) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelCode", rsGoodsShopDomainList.get(0).getChannelCode());
        param.put("goodsNo", goodsNoStr);
        param.put("tenantCode", rsGoodsShopDomainList.get(0).getTenantCode());
        this.sendUpdateChannelQuwey(param);
        return null;
    }

    @Override
    public void sendDgoodsRelease(String channelCode, String tenantCode, String reqBody) {
        this.logger.info("=======sendDgoodsRelease=======>\uff1achannelCode = " + channelCode + "\uff1btenantCode = " + tenantCode + "\uff1breqBody = " + reqBody);
        JSONObject req = JSON.parseObject((String)reqBody);
        String batchCode = req.getString("batchCode");
        DisChannel disChannel = (DisChannel)JSON.parseObject((String)req.getString("disChannel"), DisChannel.class);
        DisDgoods disDgoods = (DisDgoods)JSON.parseObject((String)req.getString("disDgoods"), DisDgoods.class);
        String disDgoodsScopelistStr = req.getString("disDgoodsScopelist");
        List<String> skus = this.getSkus(disChannel.getMemberCode(), channelCode, tenantCode, reqBody, disDgoodsScopelistStr);
        this.logger.info("=======sendDgoodsRelease=======>\uff1a=====skus\uff1a" + JsonUtil.buildNormalBinder().toJson(skus));
        this.createRsDisList(disChannel, disDgoods, batchCode, skus, new JSONObject());
    }

    private List<String> getSkus(String memberCode, String channelCode, String tenantCode, String reqBody, String disDgoodsScopelistStr) {
        if (StringUtils.isBlank((String)disDgoodsScopelistStr)) {
            this.logger.info("=======getSkus=======>\uff1achannelCode = " + channelCode + "\uff1btenantCode = " + tenantCode + "\uff1breqBody = " + reqBody + "=====\u5546\u54c1\u8303\u56f4\u89c4\u5219\u6761\u4ef6\u4e3a\u7a7a");
            return new ArrayList<String>();
        }
        List list = JSON.parseArray((String)disDgoodsScopelistStr, DisDgoodsScopelistDomain.class);
        if (list.isEmpty()) {
            this.logger.info("=======getSkus=======>\uff1achannelCode = " + channelCode + "\uff1btenantCode = " + tenantCode + "\uff1breqBody = " + reqBody + "=====\u5546\u54c1\u8303\u56f4\u89c4\u5219\u6761\u4ef6\u4e3a\u7a7a");
            return new ArrayList<String>();
        }
        Map<String, List<DisDgoodsScopelistDomain>> map = list.stream().collect(Collectors.groupingBy(DisDgoodsScopelistDomain::getDgoodsScopelistType));
        List<Object> skus = new ArrayList();
        Boolean flag = true;
        for (Map.Entry<String, List<DisDgoodsScopelistDomain>> next : map.entrySet()) {
            String dgoodsScopelistType = next.getKey();
            List<DisDgoodsScopelistDomain> value = next.getValue();
            if (dgoodsScopelistType.equals("skuNo") || dgoodsScopelistType.equals("classtreeCode") || dgoodsScopelistType.equals("brandCode")) {
                List<String> skusTemp = this.getSkus(memberCode, tenantCode, value, dgoodsScopelistType);
                if (flag.booleanValue()) {
                    skus = skusTemp;
                    flag = false;
                    continue;
                }
                skus = this.getIntersection(skus, skusTemp);
                continue;
            }
            this.logger.error("=======getSkus=======>\uff1a=====dgoodsScopelistType\uff0c\u672a\u77e5\u7c7b\u578b\uff1a" + dgoodsScopelistType);
        }
        return new ArrayList<String>(new TreeSet(skus));
    }

    private List<String> getSkus(String memberCode, String tenantCode, List<DisDgoodsScopelistDomain> list, String dgoodsScopelistType) {
        List<String> skus = new ArrayList<String>();
        Boolean flag = true;
        Map<String, List<DisDgoodsScopelistDomain>> map = list.stream().collect(Collectors.groupingBy(disDgoodsScopelist -> disDgoodsScopelist.getDgoodsScopelistTerm()));
        for (Map.Entry<String, List<DisDgoodsScopelistDomain>> next : map.entrySet()) {
            String dgoodsScopelistTerm = next.getKey();
            List<DisDgoodsScopelistDomain> dgoodsScopelistValue = next.getValue();
            List collect = dgoodsScopelistValue.stream().map(DisDgoodsScopelistDomain::getDgoodsScopelistValue).distinct().collect(Collectors.toList());
            if (dgoodsScopelistTerm.equals("=") || dgoodsScopelistTerm.equals("!=")) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("dgoodsScopelistType", dgoodsScopelistType);
                param.put("dgoodsScopelistTerm", dgoodsScopelistTerm);
                param.put("dgoodsScopelistValue", collect);
                param.put("tenantCode", tenantCode);
                param.put("memberCode", memberCode);
                List<String> skusTemp = this.rsSkuService.querySkuByRule(param);
                this.logger.info("=======getSkus=======>\uff1a=====skusTemp\uff1a" + JsonUtil.buildNormalBinder().toJson(skusTemp));
                if (flag.booleanValue()) {
                    skus = skusTemp;
                    flag = false;
                    continue;
                }
                skus = this.getIntersection(skus, skusTemp);
                continue;
            }
            this.logger.error("=======getSkus=======>\uff1a=====dgoodsScopelistTerm\uff0c\u672a\u77e5\u7c7b\u578b\uff1a" + dgoodsScopelistTerm);
        }
        return skus;
    }

    private void createRsDisList(DisChannel disChannel, DisDgoods disDgoods, String batchCode, List<String> skus, JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelCode", disChannel.getChannelCode());
        map.put("tenantCode", disChannel.getTenantCode());
        QueryResult<RsChannlSku> result = this.getRsChannelgoodsService().queryChannlSkuPage(map);
        if (result == null || result.getList().isEmpty()) {
            this.addRsDisList(disChannel, disDgoods, skus, batchCode, "DisDgoodsScopelist", "add", new JSONObject());
        } else {
            List<String> list = result.getList().stream().map(RsChannlSku::getSkuNo).distinct().collect(Collectors.toList());
            this.addRsDisList(disChannel, disDgoods, this.getDifference(skus, list), batchCode, "DisDgoodsScopelist", "add", json);
            this.addRsDisList(disChannel, disDgoods, this.getDifference(list, skus), batchCode, "DisDgoodsScopelist", "del", json);
        }
    }

    @Override
    public void sendDpriceRelease(String channelCode, String tenantCode, String reqBody) {
        this.logger.info("=======sendDpriceRelease=======>\uff1achannelCode = " + channelCode + "\uff1btenantCode = " + tenantCode + "\uff1breqBody = " + reqBody);
        JSONObject req = JSON.parseObject((String)reqBody);
        String batchCode = req.getString("batchCode");
        DisChannel disChannel = (DisChannel)JSON.parseObject((String)req.getString("disChannel"), DisChannel.class);
        DisDgoods disDgoods = (DisDgoods)JSON.parseObject((String)req.getString("disDgoods"), DisDgoods.class);
        DisDpriceDomain disDprice = (DisDpriceDomain)JSON.parseObject((String)req.getString("disDprice"), DisDpriceDomain.class);
        String disDpriceConf = req.getString("disDpriceConf");
        List<String> skus = this.getSkusByprice(channelCode, tenantCode, reqBody, disDpriceConf);
        this.logger.info("=======sendDpriceRelease=======>\uff1a=====skus\uff1a" + JsonUtil.buildNormalBinder().toJson(skus));
        JSONObject json = new JSONObject();
        json.put("druleCode", (Object)disDprice.getDpriceCode());
        json.put("druleName", (Object)disDprice.getDpriceName());
        json.put("druleSort", (Object)disDprice.getDpriceWeight());
        json.put("druleTermCode", null);
        this.createRsDisListByPrice(disChannel, disDgoods, batchCode, skus, json);
    }

    private List<String> getSkusByprice(String channelCode, String tenantCode, String reqBody, String disDpriceConf) {
        if (StringUtils.isBlank((String)disDpriceConf)) {
            this.logger.info("=======getSkusByprice=======>\uff1achannelCode = " + channelCode + "\uff1btenantCode = " + tenantCode + "\uff1breqBody = " + reqBody + "=====\u5546\u54c1\u4ef7\u683c\u89c4\u5219\u6761\u4ef6\u4e3a\u7a7a");
            return new ArrayList<String>();
        }
        List list = JSON.parseArray((String)disDpriceConf, DisDpriceConfDomain.class);
        if (list.isEmpty()) {
            this.logger.info("=======getSkusByprice=======>\uff1achannelCode = " + channelCode + "\uff1btenantCode = " + tenantCode + "\uff1breqBody = " + reqBody + "======\u5546\u54c1\u4ef7\u683c\u89c4\u5219\u6761\u4ef6\u4e3a\u7a7a");
            return new ArrayList<String>();
        }
        Map<String, List<DisDpriceConfDomain>> map = list.stream().collect(Collectors.groupingBy(DisDpriceConfDomain::getDpriceConfType));
        List<String> skus = new ArrayList<String>();
        Boolean flag = true;
        for (Map.Entry<String, List<DisDpriceConfDomain>> next : map.entrySet()) {
            String dpriceConfType = next.getKey();
            List<DisDpriceConfDomain> value = next.getValue();
            if (dpriceConfType.equals("skuNo") || dpriceConfType.equals("classtreeCode") || dpriceConfType.equals("brandCode")) {
                List<String> skusTemp = this.getSkusByprice(channelCode, value, dpriceConfType);
                if (flag.booleanValue()) {
                    skus = skusTemp;
                    flag = false;
                    continue;
                }
                skus = this.getIntersection(skus, skusTemp);
                continue;
            }
            this.logger.error("=======getSkusByprice=======>\uff1a=====dpriceConfType\uff0c\u672a\u77e5\u7c7b\u578b\uff1a" + dpriceConfType);
        }
        return skus;
    }

    private List<String> getSkusByprice(String channelCode, List<DisDpriceConfDomain> list, String dpriceConfType) {
        List<String> skus = new ArrayList<String>();
        Boolean flag = true;
        Map<String, List<DisDpriceConfDomain>> map = list.stream().collect(Collectors.groupingBy(disDpriceConfDomain -> disDpriceConfDomain.getDpriceConfTerm()));
        for (Map.Entry<String, List<DisDpriceConfDomain>> next : map.entrySet()) {
            String dpriceConfTerm = next.getKey();
            List<DisDpriceConfDomain> dpriceConfValue = next.getValue();
            List collect = dpriceConfValue.stream().map(DisDpriceConfDomain::getDpriceConfValue).distinct().collect(Collectors.toList());
            if (dpriceConfTerm.equals("=") || dpriceConfTerm.equals("!=")) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("dpriceConfType", dpriceConfType);
                param.put("dpriceConfTerm", dpriceConfTerm);
                param.put("dpriceConfValue", collect);
                param.put("channelCode", channelCode);
                List<String> skusTemp = this.getRsChannelgoodsService().querySkuByRule(param);
                this.logger.info("=======getSkusByprice=======>\uff1a=====skusTemp\uff1a" + JsonUtil.buildNormalBinder().toJson(skusTemp));
                if (flag.booleanValue()) {
                    skus = skusTemp;
                    flag = false;
                    continue;
                }
                skus = this.getIntersection(skus, skusTemp);
                continue;
            }
            this.logger.error("=======getSkusByprice=======>\uff1a=====dpriceConfTerm\uff0c\u672a\u77e5\u7c7b\u578b\uff1a" + dpriceConfTerm);
        }
        return skus;
    }

    private void createRsDisListByPrice(DisChannel disChannel, DisDgoods disDgoods, String batchCode, List<String> skus, JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelCode", disChannel.getChannelCode());
        map.put("tenantCode", disChannel.getTenantCode());
        QueryResult<RsChannlSku> result = this.getRsChannelgoodsService().queryChannlSkuPage(map);
        if (result == null || result.getList().isEmpty()) {
            this.logger.info("=======createRsDisListByPrice=======>=====\u5546\u54c1\u8303\u56f4\u4e3a\u7a7a\uff0c\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e\u65e0\u6548");
        } else {
            List<String> list = result.getList().stream().map(RsChannlSku::getSkuNo).distinct().collect(Collectors.toList());
            this.addRsDisList(disChannel, disDgoods, this.getDifference(skus, list), batchCode, "DisDprice", "add", json);
            this.addRsDisList(disChannel, disDgoods, this.getDifference(list, skus), batchCode, "DisDprice", "del", json);
            this.addRsDisList(disChannel, disDgoods, this.getIntersection(list, skus), batchCode, "DisDprice", "edit", json);
        }
    }

    @Override
    public void sendDnumRelease(String channelCode, String tenantCode, String reqBody) {
        this.logger.info("=======sendDnumRelease=======>\uff1achannelCode = " + channelCode + "\uff1btenantCode = " + tenantCode + "\uff1breqBody = " + reqBody);
        JSONObject req = JSON.parseObject((String)reqBody);
        String batchCode = req.getString("batchCode");
        DisChannel disChannel = (DisChannel)JSON.parseObject((String)req.getString("disChannel"), DisChannel.class);
        DisDgoods disDgoods = (DisDgoods)JSON.parseObject((String)req.getString("disDgoods"), DisDgoods.class);
        DisDgnumDomain disDgnum = (DisDgnumDomain)JSON.parseObject((String)req.getString("disDgnum"), DisDgnumDomain.class);
        String disDgnumList = req.getString("disDgnumList");
        List<String> skus = this.getSkusBynum(channelCode, tenantCode, reqBody, disDgnumList);
        this.logger.info("=======sendDnumRelease=======>\uff1a=====skus\uff1a" + JsonUtil.buildNormalBinder().toJson(skus));
        JSONObject json = new JSONObject();
        json.put("druleCode", (Object)disDgnum.getDgnumCode());
        json.put("druleName", (Object)disDgnum.getDgnumName());
        json.put("druleSort", (Object)disDgnum.getDgnumWeight());
        json.put("druleTermCode", null);
        this.createRsDisListByNum(disChannel, disDgoods, batchCode, skus, json);
    }

    private List<String> getSkusBynum(String channelCode, String tenantCode, String reqBody, String disDgnumList) {
        if (StringUtils.isBlank((String)disDgnumList)) {
            this.logger.info("=======getSkusBynum=======>\uff1achannelCode = " + channelCode + "\uff1btenantCode = " + tenantCode + "\uff1breqBody = " + reqBody + "=====\u5546\u54c1\u5e93\u5b58\u89c4\u5219\u6761\u4ef6\u4e3a\u7a7a");
            return new ArrayList<String>();
        }
        List list = JSON.parseArray((String)disDgnumList, DisDgnumList.class);
        if (list.isEmpty()) {
            this.logger.info("=======getSkusBynum=======>\uff1achannelCode = " + channelCode + "\uff1btenantCode = " + tenantCode + "\uff1breqBody = " + reqBody + "======\u5546\u54c1\u5e93\u5b58\u89c4\u5219\u6761\u4ef6\u4e3a\u7a7a");
            return new ArrayList<String>();
        }
        Map<String, List<DisDgnumList>> map = list.stream().collect(Collectors.groupingBy(DisDgnumList::getDgnumListType));
        List<String> skus = new ArrayList<String>();
        Boolean flag = true;
        for (Map.Entry<String, List<DisDgnumList>> next : map.entrySet()) {
            String dgnumListType = next.getKey();
            List<DisDgnumList> value = next.getValue();
            if (dgnumListType.equals("skuNo") || dgnumListType.equals("classtreeCode") || dgnumListType.equals("brandCode")) {
                List<String> skusTemp = this.getSkusBynum(channelCode, value, dgnumListType);
                if (flag.booleanValue()) {
                    skus = skusTemp;
                    flag = false;
                    continue;
                }
                skus = this.getIntersection(skus, skusTemp);
                continue;
            }
            this.logger.error("=======getSkusBynum=======>\uff1a=====dgnumListType\uff0c\u672a\u77e5\u7c7b\u578b\uff1a" + dgnumListType);
        }
        return skus;
    }

    private List<String> getSkusBynum(String channelCode, List<DisDgnumList> list, String dgnumListType) {
        List<String> skus = new ArrayList<String>();
        Boolean flag = true;
        Map<String, List<DisDgnumList>> map = list.stream().collect(Collectors.groupingBy(disDgnumList -> disDgnumList.getDgnumListTerm()));
        for (Map.Entry<String, List<DisDgnumList>> next : map.entrySet()) {
            String dgnumListTerm = next.getKey();
            List<DisDgnumList> dgnumListValue = next.getValue();
            List collect = dgnumListValue.stream().map(DisDgnumList::getDgnumListValue).distinct().collect(Collectors.toList());
            if (dgnumListTerm.equals("=") || dgnumListTerm.equals("!=")) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("dgnumListType", dgnumListType);
                param.put("dgnumListTerm", dgnumListTerm);
                param.put("dgnumListValue", collect);
                param.put("channelCode", channelCode);
                List<String> skusTemp = this.getRsChannelgoodsService().querySkuByRule(param);
                this.logger.info("=======getSkusBynum=======>\uff1a=====skusTemp\uff1a" + JsonUtil.buildNormalBinder().toJson(skusTemp));
                if (flag.booleanValue()) {
                    skus = skusTemp;
                    flag = false;
                    continue;
                }
                skus = this.getIntersection(skus, skusTemp);
                continue;
            }
            this.logger.error("=======getSkusBynum=======>\uff1a=====dgnumListTerm\uff0c\u672a\u77e5\u7c7b\u578b\uff1a" + dgnumListTerm);
        }
        return skus;
    }

    private void createRsDisListByNum(DisChannel disChannel, DisDgoods disDgoods, String batchCode, List<String> skus, JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelCode", disChannel.getChannelCode());
        map.put("tenantCode", disChannel.getTenantCode());
        QueryResult<RsChannlSku> result = this.getRsChannelgoodsService().queryChannlSkuPage(map);
        if (result == null || result.getList().isEmpty()) {
            this.logger.info("=======createRsDisListByNum=======>=====\u5546\u54c1\u8303\u56f4\u4e3a\u7a7a\uff0c\u5546\u54c1\u5e93\u5b58\u8bbe\u7f6e\u65e0\u6548");
        } else {
            List<String> list = result.getList().stream().map(RsChannlSku::getSkuNo).distinct().collect(Collectors.toList());
            this.addRsDisList(disChannel, disDgoods, this.getDifference(skus, list), batchCode, "DisDgnum", "add", json);
            this.addRsDisList(disChannel, disDgoods, this.getDifference(list, skus), batchCode, "DisDgnum", "del", json);
            this.addRsDisList(disChannel, disDgoods, this.getIntersection(list, skus), batchCode, "DisDgnum", "edit", json);
        }
    }

    private void addRsDisList(DisChannel disChannel, DisDgoods disDgoods, List<String> skus, String batchCode, String disListType, String disListFlag, JSONObject json) {
        ArrayList<RsDisListDomain> list = new ArrayList<RsDisListDomain>();
        for (int i = 0; i < skus.size(); ++i) {
            RsDisListDomain rsDisListDomain = new RsDisListDomain();
            rsDisListDomain.setSkuNo(skus.get(i));
            rsDisListDomain.setChannelCode(disChannel.getChannelCode());
            rsDisListDomain.setChannelName(disChannel.getChannelName());
            rsDisListDomain.setTenantCode(disChannel.getTenantCode());
            rsDisListDomain.setBatchCode(batchCode);
            rsDisListDomain.setDisListType(disListType);
            rsDisListDomain.setDisListFlag(disListFlag);
            rsDisListDomain.setDruleCode(json.getString("druleCode"));
            rsDisListDomain.setDruleName(json.getString("druleName"));
            rsDisListDomain.setDruleSort(json.getInteger("druleSort"));
            rsDisListDomain.setDruleTermCode(json.getString("druleTermCode"));
            list.add(rsDisListDomain);
        }
        this.getRsDisListService().saveRsDisListBatch(list);
    }

    public RsChannelgoodsService getRsChannelgoodsService() {
        if (null == this.rsChannelgoodsService) {
            this.rsChannelgoodsService = (RsChannelgoodsService)SpringApplicationContextUtil.getBean((String)"rsChannelgoodsService");
        }
        return this.rsChannelgoodsService;
    }

    public RsDisListService getRsDisListService() {
        if (null == this.rsDisListService) {
            this.rsDisListService = (RsDisListService)SpringApplicationContextUtil.getBean((String)"rsDisListService");
        }
        return this.rsDisListService;
    }

    private List<String> getIntersection(List<String> a, List<String> b) {
        ArrayList<String> intersection = new ArrayList<String>();
        for (String s : a) {
            if (!b.contains(s)) continue;
            intersection.add(s);
        }
        return intersection;
    }

    private List<String> getDifference(List<String> a, List<String> b) {
        ArrayList<String> difference = new ArrayList<String>();
        for (String s : a) {
            if (b.contains(s)) continue;
            difference.add(s);
        }
        return difference;
    }
}

