/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.channeles;

import com.yqbsoft.laser.service.resources.channeles.ChannelGoodsBean;
import com.yqbsoft.laser.service.resources.channeles.SendService;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.suppercore.sync.AbstractEtcInfoThread;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class SendChannelSkuPutThread
extends AbstractEtcInfoThread {
    public static final String SYS_CODE = "rs.SendPutThread";
    private SendService sendService;
    private List<RsSku> rsSkuList;
    private DisChannel disChannel;
    private boolean flag;
    private RsResourceGoodsService rsResourceGoodsService;

    public SendChannelSkuPutThread(SendService sendService, List<RsSku> rsSkuList, DisChannel disChannel, boolean flag, RsResourceGoodsService rsResourceGoodsService) {
        this.sendService = sendService;
        this.rsSkuList = rsSkuList;
        this.disChannel = disChannel;
        this.flag = flag;
        this.rsResourceGoodsService = rsResourceGoodsService;
    }

    public void run() {
        try {
            this.off(this.rsSkuList, this.disChannel);
        }
        catch (Exception e) {
            this.logger.error("rs.SendPutThread.run.e", (Throwable)e);
        }
    }

    public void off(List<RsSku> rsSkuList, DisChannel disChannel) {
        if (null == rsSkuList || rsSkuList.isEmpty()) {
            return;
        }
        HashMap<String, String> parentMap = new HashMap<String, String>();
        for (RsSku rsSku : rsSkuList) {
            try {
                ChannelGoodsBean channelGoodsBean = new ChannelGoodsBean();
                channelGoodsBean.setFlag(this.flag);
                channelGoodsBean.setDisChannel(disChannel);
                RsResourceGoods rsResourceGoods = this.rsResourceGoodsService.getResourceGoodsByCodeStr(rsSku.getGoodsCode(), rsSku.getTenantCode());
                channelGoodsBean.setRsResourceGoods(rsResourceGoods);
                channelGoodsBean.setRsSku(rsSku);
                String senddataParentcode = (String)parentMap.get(rsSku.getGoodsCode());
                if (StringUtils.isBlank((String)senddataParentcode)) {
                    senddataParentcode = UUID.randomUUID().toString().replace("-", "");
                    parentMap.put(rsSku.getGoodsCode(), senddataParentcode);
                    channelGoodsBean.setSenddataCode(senddataParentcode);
                } else {
                    channelGoodsBean.setSenddataParentcode(senddataParentcode);
                }
                this.sendService.putQueue(channelGoodsBean);
            }
            catch (Exception e) {
                this.logger.error("rs.SendPutThread.off.e", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(UUID.randomUUID().toString().replace("-", ""));
        System.out.println(UUID.randomUUID().toString().replace("-", ""));
    }
}

