/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisDgnumDomain;
import com.yqbsoft.laser.service.resources.domain.DisDgnumList;
import com.yqbsoft.laser.service.resources.domain.DisDgoods;
import com.yqbsoft.laser.service.resources.domain.DisDgoodsScopelist;
import com.yqbsoft.laser.service.resources.domain.DisDpriceConf;
import com.yqbsoft.laser.service.resources.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class RsBaseServiceImpl
extends BaseServiceImpl {
    public static final String SYS_CODE = "rs.RsBaseServiceImpl";
    protected String cacheScopelist = "DisDgoodsScopelist-DgoodsCode";
    protected String cacheScopelistkey = "DisDgoodsScopelist-DgoodsCode-key";

    protected DisDgoods getDgoods(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsBaseServiceImpl.checkDgoods.isnull", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        DisDgoods disDgoods = (DisDgoods)DisUtil.getMapJson((String)"DisDgoods-channelCode", (String)(channelCode + "-" + tenantCode), DisDgoods.class);
        if (null == disDgoods) {
            this.logger.error("rs.RsBaseServiceImpl.checkDgoods.disDgoods", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        return disDgoods;
    }

    protected DisDgoods checkDgoods(String channelCode, String tenantCode) {
        DisDgoods disDgoods = this.getDgoods(channelCode, tenantCode);
        if (null == disDgoods) {
            return null;
        }
        if (!"1".equals(disDgoods.getDgoodsSync())) {
            this.logger.error("rs.RsBaseServiceImpl.checkDgoods.dgoodsSync", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        return disDgoods;
    }

    protected DisDgoods checkDisGoodsChannel(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, DisChannel disChannel, String esrequestType) {
        Map<String, Object> obj;
        if (null == disChannel) {
            this.logger.error("rs.RsBaseServiceImpl.checkDisGoodsChannel.disChannel");
            return null;
        }
        DisDgoods disDgoods = this.checkDgoods(disChannel.getChannelCode(), disChannel.getTenantCode());
        if (null == disDgoods) {
            this.logger.error("rs.RsBaseServiceImpl.checkDisGoodsChannel.disDgoods", (Object)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()));
            return null;
        }
        if (StringUtils.isBlank((String)disDgoods.getDgoodsEdit())) {
            disDgoods.setDgoodsEdit("1");
        }
        if ("edit".equals(esrequestType) && "0".equals(disDgoods.getDgoodsEdit())) {
            this.logger.error("rs.RsBaseServiceImpl.checkDisGoodsChannel.edit", (Object)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()));
            return null;
        }
        if (StringUtils.isBlank((String)disDgoods.getDgoodsPut())) {
            disDgoods.setDgoodsPut("1");
        }
        if (StringUtils.isBlank((String)disDgoods.getDgoodsUnum())) {
            disDgoods.setDgoodsUnum("1");
        }
        if (StringUtils.isBlank((String)disDgoods.getDgoodsUprice())) {
            disDgoods.setDgoodsUprice("1");
        }
        if (!this.checkDgoodsScopelist(disDgoods, obj = this.makeObject(rsResourceGoodsReDomain, rsSkuDomain))) {
            return null;
        }
        return disDgoods;
    }

    protected Map<String, Object> makeObject(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (null != rsResourceGoodsReDomain) {
            obj.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain), String.class, Object.class));
        }
        if (null != rsSkuDomain) {
            obj.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)rsSkuDomain), String.class, Object.class));
        }
        return obj;
    }

    protected boolean checkDgoodsScopelist(DisDgoods disDgoods, Map<String, Object> obj) {
        String vaulemap;
        if (null == disDgoods || MapUtil.isEmpty(obj)) {
            return false;
        }
        Map keymap = DisUtil.getMapAll((String)(this.cacheScopelistkey + "-all-" + disDgoods.getDgoodsCode() + "-" + disDgoods.getTenantCode()));
        if (!this.checkConf(keymap, vaulemap = this.cacheScopelist + "-all-" + disDgoods.getDgoodsCode() + "-" + disDgoods.getTenantCode(), obj, disDgoods)) {
            return false;
        }
        keymap = DisUtil.getMapAll((String)(this.cacheScopelistkey + "-child-" + disDgoods.getDgoodsCode() + "-" + disDgoods.getTenantCode()));
        vaulemap = this.cacheScopelist + "-child-" + disDgoods.getDgoodsCode() + "-" + disDgoods.getTenantCode();
        if (MapUtil.isNotEmpty((Map)keymap)) {
            return this.checkConf(keymap, vaulemap, obj, disDgoods);
        }
        keymap = DisUtil.getMapAll((String)(this.cacheScopelistkey + "-" + disDgoods.getDgoodsCode() + "-" + disDgoods.getTenantCode()));
        return this.checkConf(keymap, vaulemap = this.cacheScopelist + "-" + disDgoods.getDgoodsCode() + "-" + disDgoods.getTenantCode(), obj, disDgoods);
    }

    protected boolean checkConf(Map<String, String> keymap, String valuemap, Object obj, Object mainObj) {
        if (MapUtil.isEmpty(keymap) || StringUtils.isBlank((String)valuemap)) {
            return true;
        }
        this.logger.error("=============", (Object)(keymap.toString() + "=" + valuemap + "=" + mainObj + "=" + obj));
        boolean flag = true;
        String term = "";
        String key = "";
        block0: for (String keys : keymap.keySet()) {
            Object objValue;
            String[] keyStr = keys.split("\\-");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            if ((objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key)) instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs = objValue.toString().split("\\,");
                flag = false;
                for (String o : otrs) {
                    if (!this.cond(keys, valuemap, term, o, mainObj)) continue;
                    flag = true;
                    continue block0;
                }
                continue;
            }
            if (this.cond(keys, valuemap, term, objValue, mainObj)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    protected boolean cond(String keys, String valuemap, String term, Object objValue, Object mainObj) {
        if (StringUtils.isBlank((String)valuemap)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        if (term.equals("=") || term.equals("!=")) {
            keys = keys + "-" + objValue;
        }
        String value = DisUtil.getMap((String)valuemap, (String)keys);
        Serializable confObj = null;
        if (mainObj instanceof DisDpriceDomain) {
            DisDpriceConf disDpriceConf = null;
            if (StringUtils.isNotBlank((String)value)) {
                disDpriceConf = (DisDpriceConf)JsonUtil.buildNormalBinder().getJsonToObject(value, DisDpriceConf.class);
                value = disDpriceConf.getDpriceConfValue();
                confObj = disDpriceConf;
            }
        } else if (mainObj instanceof DisDgoods) {
            if (StringUtils.isNotBlank((String)value)) {
                DisDgoodsScopelist disDgoodsScopelist = (DisDgoodsScopelist)JsonUtil.buildNormalBinder().getJsonToObject(value, DisDgoodsScopelist.class);
                value = disDgoodsScopelist.getDgoodsScopelistValue();
                confObj = disDgoodsScopelist;
            }
        } else if (mainObj instanceof DisDgnumDomain) {
            DisDgnumList disDgnumList = null;
            if (StringUtils.isNotBlank((String)value)) {
                disDgnumList = (DisDgnumList)JsonUtil.buildNormalBinder().getJsonToObject(value, DisDgnumList.class);
                value = disDgnumList.getDgnumListValue();
                confObj = disDgnumList;
            }
        } else if (mainObj instanceof DisDgoodsScopelist) {
            DisDgoodsScopelist disDgoodsScopelist = null;
            if (StringUtils.isNotBlank((String)value)) {
                disDgoodsScopelist = (DisDgoodsScopelist)JsonUtil.buildNormalBinder().getJsonToObject(value, DisDgoodsScopelist.class);
                value = disDgoodsScopelist.getDgoodsScopelistValue();
                confObj = disDgoodsScopelist;
            }
        }
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (StringUtils.isNotBlank((String)value)) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (StringUtils.isBlank((String)value)) {
                flag = false;
            }
        }
        if (null != mainObj && flag && null != confObj) {
            RsBaseServiceImpl.setReturn(mainObj, confObj);
        }
        return flag;
    }

    protected static void setReturn(Object mainObj, Object obj) {
        if (null == mainObj || null == obj) {
            return;
        }
        if (mainObj instanceof DisDpriceDomain && obj instanceof DisDpriceConf) {
            DisDpriceDomain disDpriceDomain = (DisDpriceDomain)mainObj;
            DisDpriceConf disDpriceConf = (DisDpriceConf)obj;
            if ("2".equals(disDpriceDomain.getDpricePro()) || "goodsNo".equals(disDpriceConf.getDpriceConfType()) || "skuNo".equals(disDpriceConf.getDpriceConfType())) {
                if (null != disDpriceConf.getDpriceConfPrice() && disDpriceConf.getDpriceConfPrice().compareTo(BigDecimal.ZERO) > 0) {
                    disDpriceDomain.setDpricePrice(disDpriceConf.getDpriceConfPrice());
                }
                if (null != disDpriceConf.getDpriceConfMprice() && disDpriceConf.getDpriceConfMprice().compareTo(BigDecimal.ZERO) > 0) {
                    disDpriceDomain.setDpriceMprice(disDpriceConf.getDpriceConfMprice());
                }
                if (null != disDpriceConf.getDpriceConfPricedef() && disDpriceConf.getDpriceConfPricedef().compareTo(BigDecimal.ZERO) > 0) {
                    disDpriceDomain.setDpricePricedef(disDpriceConf.getDpriceConfPricedef());
                }
                if (null != disDpriceConf.getDpriceConfMpricedef() && disDpriceConf.getDpriceConfMpricedef().compareTo(BigDecimal.ZERO) > 0) {
                    disDpriceDomain.setDpriceMpricedef(disDpriceConf.getDpriceConfMpricedef());
                }
            }
        } else if (mainObj instanceof DisDgnumDomain && obj instanceof DisDgnumList) {
            DisDgnumDomain disDgnumDomain = (DisDgnumDomain)mainObj;
            DisDgnumList disDgnumList = (DisDgnumList)obj;
            if ("2".equals(disDgnumDomain.getDgnumPro()) || "goodsNo".equals(disDgnumList.getDgnumListType()) || "skuNo".equals(disDgnumList.getDgnumListType())) {
                if (null != disDgnumList.getDgnumListPrice() && disDgnumList.getDgnumListPrice().compareTo(BigDecimal.ZERO) > 0) {
                    disDgnumDomain.setDgnumPrice(disDgnumList.getDgnumListPrice());
                } else if (StringUtils.isNotBlank((String)disDgnumList.getDgnumListValuename())) {
                    try {
                        disDgnumDomain.setDgnumPrice(new BigDecimal(disDgnumList.getDgnumListValuename()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (null != disDgnumList.getDgnumListMax() && disDgnumList.getDgnumListMax().compareTo(BigDecimal.ZERO) > 0) {
                    disDgnumDomain.setDgnumMax(disDgnumList.getDgnumListMax());
                }
                if (null != disDgnumList.getDgnumListMinx() && disDgnumList.getDgnumListMinx().compareTo(BigDecimal.ZERO) > 0) {
                    disDgnumDomain.setDgnumMin(disDgnumList.getDgnumListMinx());
                }
            }
        }
    }
}

