/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsDiscgoodsMapper;
import com.yqbsoft.laser.service.resources.domain.RsDiscgoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsDiscgoodsReDomain;
import com.yqbsoft.laser.service.resources.model.RsDiscgoods;
import com.yqbsoft.laser.service.resources.service.RsDiscgoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsDiscgoodsServiceImpl
extends BaseServiceImpl
implements RsDiscgoodsService {
    private static final String SYS_CODE = "rs.RsDiscgoodsServiceImpl";
    private RsDiscgoodsMapper rsDiscgoodsMapper;

    public void setRsDiscgoodsMapper(RsDiscgoodsMapper rsDiscgoodsMapper) {
        this.rsDiscgoodsMapper = rsDiscgoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsDiscgoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsDiscgoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDiscgoods(RsDiscgoodsDomain rsDiscgoodsDomain) {
        if (null == rsDiscgoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsDiscgoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDiscgoodsDefault(RsDiscgoods rsDiscgoods) {
        if (null == rsDiscgoods) {
            return;
        }
        if (null == rsDiscgoods.getDataState()) {
            rsDiscgoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsDiscgoods.getGmtCreate()) {
            rsDiscgoods.setGmtCreate(date);
        }
        rsDiscgoods.setGmtModified(date);
        if (StringUtils.isBlank((String)rsDiscgoods.getDiscgoodsCode())) {
            rsDiscgoods.setDiscgoodsCode(this.getNo(null, "RsDiscgoods", "rsDiscgoods", rsDiscgoods.getTenantCode()));
        }
    }

    private int getDiscgoodsMaxCode() {
        int code = 0;
        try {
            return this.rsDiscgoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsDiscgoodsServiceImpl.getDiscgoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDiscgoodsUpdataDefault(RsDiscgoods rsDiscgoods) {
        if (null == rsDiscgoods) {
            return;
        }
        rsDiscgoods.setGmtModified(this.getSysDate());
    }

    private void saveDiscgoodsModel(RsDiscgoods rsDiscgoods) throws ApiException {
        if (null == rsDiscgoods) {
            return;
        }
        try {
            this.rsDiscgoodsMapper.insert(rsDiscgoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.saveDiscgoodsModel.ex", (Throwable)e);
        }
    }

    private void saveDiscgoodsBatchModel(List<RsDiscgoods> rsDiscgoodsList) throws ApiException {
        if (null == rsDiscgoodsList || rsDiscgoodsList.isEmpty()) {
            return;
        }
        try {
            this.rsDiscgoodsMapper.insertBatch(rsDiscgoodsList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.saveDiscgoodsBatchModel.ex", (Throwable)e);
        }
    }

    private RsDiscgoods getDiscgoodsModelById(Integer discgoodsId) {
        if (null == discgoodsId) {
            return null;
        }
        try {
            return this.rsDiscgoodsMapper.selectByPrimaryKey(discgoodsId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDiscgoodsServiceImpl.getDiscgoodsModelById", (Throwable)e);
            return null;
        }
    }

    private RsDiscgoods getDiscgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsDiscgoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDiscgoodsServiceImpl.getDiscgoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDiscgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDiscgoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.delDiscgoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.delDiscgoodsModelByCode.num");
        }
    }

    private void deleteDiscgoodsModel(Integer discgoodsId) throws ApiException {
        if (null == discgoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDiscgoodsMapper.deleteByPrimaryKey(discgoodsId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.deleteDiscgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.deleteDiscgoodsModel.num");
        }
    }

    private void updateDiscgoodsModel(RsDiscgoods rsDiscgoods) throws ApiException {
        if (null == rsDiscgoods) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDiscgoodsMapper.updateByPrimaryKey(rsDiscgoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.updateDiscgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.updateDiscgoodsModel.num");
        }
    }

    private void updateStateDiscgoodsModel(Integer discgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == discgoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("discgoodsId", discgoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsDiscgoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.updateStateDiscgoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.updateStateDiscgoodsModel.null");
        }
    }

    private void updateStateDiscgoodsModelByCode(String tenantCode, String discgoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)discgoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("discgoodsCode", discgoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsDiscgoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.updateStateDiscgoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.updateStateDiscgoodsModelByCode.null");
        }
    }

    private RsDiscgoods makeDiscgoods(RsDiscgoodsDomain rsDiscgoodsDomain, RsDiscgoods rsDiscgoods) {
        if (null == rsDiscgoodsDomain) {
            return null;
        }
        if (null == rsDiscgoods) {
            rsDiscgoods = new RsDiscgoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsDiscgoods, (Object)rsDiscgoodsDomain);
            return rsDiscgoods;
        }
        catch (Exception e) {
            this.logger.error("rs.RsDiscgoodsServiceImpl.makeDiscgoods", (Throwable)e);
            return null;
        }
    }

    private RsDiscgoodsReDomain makeRsDiscgoodsReDomain(RsDiscgoods rsDiscgoods) {
        if (null == rsDiscgoods) {
            return null;
        }
        RsDiscgoodsReDomain rsDiscgoodsReDomain = new RsDiscgoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsDiscgoodsReDomain, (Object)rsDiscgoods);
            return rsDiscgoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsDiscgoodsServiceImpl.makeRsDiscgoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsDiscgoods> queryDiscgoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rsDiscgoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDiscgoodsServiceImpl.queryDiscgoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countDiscgoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsDiscgoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDiscgoodsServiceImpl.countDiscgoods", (Throwable)e);
        }
        return i;
    }

    private RsDiscgoods createRsDiscgoods(RsDiscgoodsDomain rsDiscgoodsDomain) {
        String msg = this.checkDiscgoods(rsDiscgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.saveDiscgoods.checkDiscgoods", msg);
        }
        RsDiscgoods rsDiscgoods = this.makeDiscgoods(rsDiscgoodsDomain, null);
        this.setDiscgoodsDefault(rsDiscgoods);
        return rsDiscgoods;
    }

    @Override
    public String saveDiscgoods(RsDiscgoodsDomain rsDiscgoodsDomain) throws ApiException {
        RsDiscgoods rsDiscgoods = this.createRsDiscgoods(rsDiscgoodsDomain);
        this.saveDiscgoodsModel(rsDiscgoods);
        return rsDiscgoods.getDiscgoodsCode();
    }

    @Override
    public String saveDiscgoodsBatch(List<RsDiscgoodsDomain> rsDiscgoodsDomainList) throws ApiException {
        if (null == rsDiscgoodsDomainList || rsDiscgoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsDiscgoods> rsDiscgoodsList = new ArrayList<RsDiscgoods>();
        String code = "";
        for (RsDiscgoodsDomain rsDiscgoodsDomain : rsDiscgoodsDomainList) {
            RsDiscgoods rsDiscgoods = this.createRsDiscgoods(rsDiscgoodsDomain);
            code = rsDiscgoods.getDiscgoodsCode();
            rsDiscgoodsList.add(rsDiscgoods);
        }
        this.saveDiscgoodsBatchModel(rsDiscgoodsList);
        return code;
    }

    @Override
    public void updateDiscgoodsState(Integer discgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == discgoodsId) {
            return;
        }
        this.updateStateDiscgoodsModel(discgoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateDiscgoodsStateByCode(String tenantCode, String discgoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)discgoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDiscgoodsModelByCode(tenantCode, discgoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDiscgoods(RsDiscgoodsDomain rsDiscgoodsDomain) throws ApiException {
        String msg = this.checkDiscgoods(rsDiscgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.updateDiscgoods.checkDiscgoods", msg);
        }
        RsDiscgoods oldRsDiscgoods = this.getDiscgoodsModelById(rsDiscgoodsDomain.getDiscgoodsId());
        if (null == oldRsDiscgoods) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.updateDiscgoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsDiscgoods rsDiscgoods = this.makeDiscgoods(rsDiscgoodsDomain, oldRsDiscgoods);
        this.setDiscgoodsUpdataDefault(rsDiscgoods);
        this.updateDiscgoodsModel(rsDiscgoods);
    }

    @Override
    public RsDiscgoods getDiscgoods(Integer discgoodsId) {
        if (null == discgoodsId) {
            return null;
        }
        return this.getDiscgoodsModelById(discgoodsId);
    }

    @Override
    public void deleteDiscgoods(Integer discgoodsId) throws ApiException {
        if (null == discgoodsId) {
            return;
        }
        this.deleteDiscgoodsModel(discgoodsId);
    }

    @Override
    public QueryResult<RsDiscgoods> queryDiscgoodsPage(Map<String, Object> map) {
        List<RsDiscgoods> rsDiscgoodsList = this.queryDiscgoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDiscgoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsDiscgoodsList);
        return queryResult;
    }

    @Override
    public RsDiscgoods getDiscgoodsByCode(String tenantCode, String discgoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)discgoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("discgoodsCode", discgoodsCode);
        return this.getDiscgoodsModelByCode(map);
    }

    @Override
    public void deleteDiscgoodsByCode(String tenantCode, String discgoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)discgoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("discgoodsCode", discgoodsCode);
        this.delDiscgoodsModelByCode(map);
    }

    @Override
    public void deleteDiscgoodsByUnique(String goodsOldcode, String tenantCode, String channelCode, String memberCode, String memberCcode, String goodsPro, String goodsType) {
        if (StringUtils.isBlank((String)goodsOldcode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)goodsPro) || StringUtils.isBlank((String)goodsType)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsOldcode", goodsOldcode);
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        map.put("memberCode", memberCode);
        map.put("memberCcode", memberCcode);
        map.put("goodsPro", goodsPro);
        map.put("goodsType", goodsType);
        this.delDiscgoodsModelByUnique(map);
    }

    private void delDiscgoodsModelByUnique(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDiscgoodsMapper.delByUnique(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.delDiscgoodsModelByUnique.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDiscgoodsServiceImpl.delDiscgoodsModelByUnique.num");
        }
    }
}

