/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsGoodsSynMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsSynDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsSynReDomain;
import com.yqbsoft.laser.service.resources.model.RsGoodsSyn;
import com.yqbsoft.laser.service.resources.service.RsGoodsSynService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsSynServiceImpl
extends BaseServiceImpl
implements RsGoodsSynService {
    private static final String SYS_CODE = "rs.RsGoodsSynServiceImpl";
    private RsGoodsSynMapper rsGoodsSynMapper;

    public void setRsGoodsSynMapper(RsGoodsSynMapper rsGoodsSynMapper) {
        this.rsGoodsSynMapper = rsGoodsSynMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsGoodsSynMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSynServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkgoodsSyn(RsGoodsSynDomain rsGoodsSynDomain) {
        if (null == rsGoodsSynDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsGoodsSynDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setgoodsSynDefault(RsGoodsSyn rsGoodsSyn) {
        if (null == rsGoodsSyn) {
            return;
        }
        if (null == rsGoodsSyn.getDataState()) {
            rsGoodsSyn.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsGoodsSyn.getGmtCreate()) {
            rsGoodsSyn.setGmtCreate(date);
        }
        rsGoodsSyn.setGmtModified(date);
        if (StringUtils.isBlank((String)rsGoodsSyn.getSynCode())) {
            rsGoodsSyn.setSynCode(this.getNo(null, "RsGoodsSyn", "rsGoodsSyn", rsGoodsSyn.getTenantCode()));
        }
    }

    private int getgoodsSynMaxCode() {
        int code = 0;
        try {
            return this.rsGoodsSynMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSynServiceImpl.getgoodsSynMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setgoodsSynUpdataDefault(RsGoodsSyn rsGoodsSyn) {
        if (null == rsGoodsSyn) {
            return;
        }
        rsGoodsSyn.setGmtModified(this.getSysDate());
    }

    private void savegoodsSynModel(RsGoodsSyn rsGoodsSyn) throws ApiException {
        if (null == rsGoodsSyn) {
            return;
        }
        try {
            this.rsGoodsSynMapper.insert(rsGoodsSyn);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.savegoodsSynModel.ex", (Throwable)e);
        }
    }

    private void savegoodsSynBatchModel(List<RsGoodsSyn> rsGoodsSynList) throws ApiException {
        if (null == rsGoodsSynList || rsGoodsSynList.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsSynMapper.insertBatch(rsGoodsSynList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.savegoodsSynBatchModel.ex", (Throwable)e);
        }
    }

    private RsGoodsSyn getgoodsSynModelById(Integer goodsSynId) {
        if (null == goodsSynId) {
            return null;
        }
        try {
            return this.rsGoodsSynMapper.selectByPrimaryKey(goodsSynId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSynServiceImpl.getgoodsSynModelById", (Throwable)e);
            return null;
        }
    }

    private RsGoodsSyn getgoodsSynModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsSynMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSynServiceImpl.getgoodsSynModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delgoodsSynModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsSynMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.delgoodsSynModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.delgoodsSynModelByCode.num");
        }
    }

    private void deletegoodsSynModel(Integer goodsSynId) throws ApiException {
        if (null == goodsSynId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsSynMapper.deleteByPrimaryKey(goodsSynId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.deletegoodsSynModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.deletegoodsSynModel.num");
        }
    }

    private void updategoodsSynModel(RsGoodsSyn rsGoodsSyn) throws ApiException {
        if (null == rsGoodsSyn) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsSynMapper.updateByPrimaryKey(rsGoodsSyn);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.updategoodsSynModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.updategoodsSynModel.num");
        }
    }

    private void updateStategoodsSynModel(Integer goodsSynId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == goodsSynId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsSynId", goodsSynId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsSynMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.updateStategoodsSynModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.updateStategoodsSynModel.null");
        }
    }

    private void updateStategoodsSynModelByCode(String tenantCode, String goodsSynCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)goodsSynCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsSynCode", goodsSynCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsSynMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.updateStategoodsSynModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.updateStategoodsSynModelByCode.null");
        }
    }

    private RsGoodsSyn makegoodsSyn(RsGoodsSynDomain rsGoodsSynDomain, RsGoodsSyn rsGoodsSyn) {
        if (null == rsGoodsSynDomain) {
            return null;
        }
        if (null == rsGoodsSyn) {
            rsGoodsSyn = new RsGoodsSyn();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsSyn, (Object)rsGoodsSynDomain);
            return rsGoodsSyn;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSynServiceImpl.makegoodsSyn", (Throwable)e);
            return null;
        }
    }

    private RsGoodsSynReDomain makeRsGoodsSynReDomain(RsGoodsSyn rsGoodsSyn) {
        if (null == rsGoodsSyn) {
            return null;
        }
        RsGoodsSynReDomain rsGoodsSynReDomain = new RsGoodsSynReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsSynReDomain, (Object)rsGoodsSyn);
            return rsGoodsSynReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSynServiceImpl.makeRsGoodsSynReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsGoodsSyn> querygoodsSynModelPage(Map<String, Object> parammap) {
        try {
            return this.rsGoodsSynMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSynServiceImpl.querygoodsSynModel", (Throwable)e);
            return null;
        }
    }

    private int countgoodsSyn(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsGoodsSynMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSynServiceImpl.countgoodsSyn", (Throwable)e);
        }
        return i;
    }

    private RsGoodsSyn createRsGoodsSyn(RsGoodsSynDomain rsGoodsSynDomain) {
        String msg = this.checkgoodsSyn(rsGoodsSynDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.savegoodsSyn.checkgoodsSyn", msg);
        }
        RsGoodsSyn rsGoodsSyn = this.makegoodsSyn(rsGoodsSynDomain, null);
        this.setgoodsSynDefault(rsGoodsSyn);
        return rsGoodsSyn;
    }

    @Override
    public String savegoodsSyn(RsGoodsSynDomain rsGoodsSynDomain) throws ApiException {
        RsGoodsSyn rsGoodsSyn = this.createRsGoodsSyn(rsGoodsSynDomain);
        this.savegoodsSynModel(rsGoodsSyn);
        return rsGoodsSyn.getSynCode();
    }

    @Override
    public String savegoodsSynBatch(List<RsGoodsSynDomain> rsGoodsSynDomainList) throws ApiException {
        if (null == rsGoodsSynDomainList || rsGoodsSynDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsGoodsSyn> rsGoodsSynList = new ArrayList<RsGoodsSyn>();
        String code = "";
        for (RsGoodsSynDomain rsGoodsSynDomain : rsGoodsSynDomainList) {
            RsGoodsSyn rsGoodsSyn = this.createRsGoodsSyn(rsGoodsSynDomain);
            code = rsGoodsSyn.getSynCode();
            rsGoodsSynList.add(rsGoodsSyn);
        }
        this.savegoodsSynBatchModel(rsGoodsSynList);
        return code;
    }

    @Override
    public void updategoodsSynState(Integer goodsSynId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == goodsSynId) {
            return;
        }
        this.updateStategoodsSynModel(goodsSynId, dataState, oldDataState, map);
    }

    @Override
    public void updategoodsSynStateByCode(String tenantCode, String goodsSynCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)goodsSynCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStategoodsSynModelByCode(tenantCode, goodsSynCode, dataState, oldDataState, map);
    }

    @Override
    public void updategoodsSyn(RsGoodsSynDomain rsGoodsSynDomain) throws ApiException {
        String msg = this.checkgoodsSyn(rsGoodsSynDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.updategoodsSyn.checkgoodsSyn", msg);
        }
        RsGoodsSyn oldRsGoodsSyn = this.getgoodsSynModelById(rsGoodsSynDomain.getSynId());
        if (null == oldRsGoodsSyn) {
            throw new ApiException("rs.RsGoodsSynServiceImpl.updategoodsSyn.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsGoodsSyn rsGoodsSyn = this.makegoodsSyn(rsGoodsSynDomain, oldRsGoodsSyn);
        this.setgoodsSynUpdataDefault(rsGoodsSyn);
        this.updategoodsSynModel(rsGoodsSyn);
    }

    @Override
    public RsGoodsSyn getgoodsSyn(Integer goodsSynId) {
        if (null == goodsSynId) {
            return null;
        }
        return this.getgoodsSynModelById(goodsSynId);
    }

    @Override
    public void deletegoodsSyn(Integer goodsSynId) throws ApiException {
        if (null == goodsSynId) {
            return;
        }
        this.deletegoodsSynModel(goodsSynId);
    }

    @Override
    public QueryResult<RsGoodsSyn> querygoodsSynPage(Map<String, Object> map) {
        List<RsGoodsSyn> rsGoodsSynList = this.querygoodsSynModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countgoodsSyn(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsGoodsSynList);
        return queryResult;
    }

    @Override
    public RsGoodsSyn getgoodsSynByCode(String tenantCode, String goodsSynCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsSynCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsSynCode", goodsSynCode);
        return this.getgoodsSynModelByCode(map);
    }

    @Override
    public void deletegoodsSynByCode(String tenantCode, String goodsSynCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsSynCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsSynCode", goodsSynCode);
        this.delgoodsSynModelByCode(map);
    }
}

