/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.BaseAuth;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsOrdskuMapper;
import com.yqbsoft.laser.service.resources.domain.RsOrdskuDomain;
import com.yqbsoft.laser.service.resources.domain.RsOrdskuReDomain;
import com.yqbsoft.laser.service.resources.model.RsOrdsku;
import com.yqbsoft.laser.service.resources.service.RsOrdskuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RsOrdskuServiceImpl
extends BaseServiceImpl
implements RsOrdskuService {
    private static final String SYS_CODE = "rs.RsOrdskuServiceImpl";
    private RsOrdskuMapper rsOrdskuMapper;

    public void setRsOrdskuMapper(RsOrdskuMapper rsOrdskuMapper) {
        this.rsOrdskuMapper = rsOrdskuMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsOrdskuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsOrdskuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrdsku(RsOrdskuDomain rsOrdskuDomain) {
        if (null == rsOrdskuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsOrdskuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOrdskuDefault(RsOrdsku rsOrdsku) {
        if (null == rsOrdsku) {
            return;
        }
        if (null == rsOrdsku.getDataState()) {
            rsOrdsku.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsOrdsku.getGmtCreate()) {
            rsOrdsku.setGmtCreate(date);
        }
        rsOrdsku.setGmtModified(date);
        if (StringUtils.isBlank((String)rsOrdsku.getOrdskuCode())) {
            rsOrdsku.setOrdskuCode(this.getNo(null, "RsOrdsku", "rsOrdsku", rsOrdsku.getTenantCode()));
        }
    }

    private int getOrdskuMaxCode() {
        int code = 0;
        try {
            return this.rsOrdskuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsOrdskuServiceImpl.getOrdskuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrdskuUpdataDefault(RsOrdsku rsOrdsku) {
        if (null == rsOrdsku) {
            return;
        }
        rsOrdsku.setGmtModified(this.getSysDate());
    }

    private void saveOrdskuModel(RsOrdsku rsOrdsku) throws ApiException {
        if (null == rsOrdsku) {
            return;
        }
        try {
            this.rsOrdskuMapper.insert(rsOrdsku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOrdskuServiceImpl.saveOrdskuModel.ex", (Throwable)e);
        }
    }

    private void saveOrdskuBatchModel(List<RsOrdsku> rsOrdskuList) throws ApiException {
        if (null == rsOrdskuList || rsOrdskuList.isEmpty()) {
            return;
        }
        try {
            this.rsOrdskuMapper.insertBatch(rsOrdskuList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOrdskuServiceImpl.saveOrdskuBatchModel.ex", (Throwable)e);
        }
    }

    private RsOrdsku getOrdskuModelById(Integer ORDSKU_ID) {
        if (null == ORDSKU_ID) {
            return null;
        }
        try {
            return this.rsOrdskuMapper.selectByPrimaryKey(ORDSKU_ID);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOrdskuServiceImpl.getOrdskuModelById", (Throwable)e);
            return null;
        }
    }

    private RsOrdsku getOrdskuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsOrdskuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOrdskuServiceImpl.getOrdskuModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOrdskuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOrdskuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOrdskuServiceImpl.delOrdskuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOrdskuServiceImpl.delOrdskuModelByCode.num");
        }
    }

    private void delOrdskuModelByNo(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOrdskuMapper.delByNo(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOrdskuServiceImpl.delOrdskuModelByNo.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOrdskuServiceImpl.delOrdskuModelByNo.num");
        }
    }

    private void deleteOrdskuModel(Integer ORDSKU_ID) throws ApiException {
        if (null == ORDSKU_ID) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOrdskuMapper.deleteByPrimaryKey(ORDSKU_ID);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOrdskuServiceImpl.deleteOrdskuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOrdskuServiceImpl.deleteOrdskuModel.num");
        }
    }

    private void updateOrdskuModel(RsOrdsku rsOrdsku) throws ApiException {
        if (null == rsOrdsku) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOrdskuMapper.updateByPrimaryKey(rsOrdsku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOrdskuServiceImpl.updateOrdskuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOrdskuServiceImpl.updateOrdskuModel.num");
        }
    }

    private void updateStateOrdskuModel(Integer ORDSKU_ID, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ORDSKU_ID || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ORDSKU_ID", ORDSKU_ID);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsOrdskuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOrdskuServiceImpl.updateStateOrdskuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsOrdskuServiceImpl.updateStateOrdskuModel.null");
        }
    }

    private void updateStateOrdskuModelByCode(String tenantCode, String ORDSKU_CODE, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ORDSKU_CODE) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ORDSKU_CODE", ORDSKU_CODE);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsOrdskuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOrdskuServiceImpl.updateStateOrdskuModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsOrdskuServiceImpl.updateStateOrdskuModelByCode.null");
        }
    }

    private RsOrdsku makeOrdsku(RsOrdskuDomain rsOrdskuDomain, RsOrdsku rsOrdsku) {
        if (null == rsOrdskuDomain) {
            return null;
        }
        if (null == rsOrdsku) {
            rsOrdsku = new RsOrdsku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsOrdsku, (Object)rsOrdskuDomain);
            return rsOrdsku;
        }
        catch (Exception e) {
            this.logger.error("rs.RsOrdskuServiceImpl.makeOrdsku", (Throwable)e);
            return null;
        }
    }

    private RsOrdskuReDomain makeRsOrdskuReDomain(RsOrdsku rsOrdsku) {
        if (null == rsOrdsku) {
            return null;
        }
        RsOrdskuReDomain rsOrdskuReDomain = new RsOrdskuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsOrdskuReDomain, (Object)rsOrdsku);
            return rsOrdskuReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsOrdskuServiceImpl.makeRsOrdskuReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsOrdsku> queryOrdskuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsOrdskuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOrdskuServiceImpl.queryOrdskuModel", (Throwable)e);
            return null;
        }
    }

    private int countOrdsku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsOrdskuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOrdskuServiceImpl.countOrdsku", (Throwable)e);
        }
        return i;
    }

    private RsOrdsku createRsOrdsku(RsOrdskuDomain rsOrdskuDomain) {
        String msg = this.checkOrdsku(rsOrdskuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsOrdskuServiceImpl.saveOrdsku.checkOrdsku", msg);
        }
        RsOrdsku rsOrdsku = this.makeOrdsku(rsOrdskuDomain, null);
        this.setOrdskuDefault(rsOrdsku);
        return rsOrdsku;
    }

    @Override
    public String saveOrdsku(RsOrdskuDomain rsOrdskuDomain) throws ApiException {
        RsOrdsku rsOrdsku = this.createRsOrdsku(rsOrdskuDomain);
        this.saveOrdskuModel(rsOrdsku);
        return rsOrdsku.getOrdskuCode();
    }

    @Override
    public String saveOrdskuBatch(List<RsOrdskuDomain> rsOrdskuDomainList) throws ApiException {
        if (null == rsOrdskuDomainList || rsOrdskuDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsOrdsku> rsOrdskuList = new ArrayList<RsOrdsku>();
        String code = "";
        for (RsOrdskuDomain rsOrdskuDomain : rsOrdskuDomainList) {
            RsOrdsku rsOrdsku = this.createRsOrdsku(rsOrdskuDomain);
            code = rsOrdsku.getOrdskuCode();
            rsOrdskuList.add(rsOrdsku);
        }
        this.saveOrdskuBatchModel(rsOrdskuList);
        return code;
    }

    @Override
    public void updateOrdskuState(Integer ORDSKU_ID, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ORDSKU_ID) {
            return;
        }
        this.updateStateOrdskuModel(ORDSKU_ID, dataState, oldDataState, map);
    }

    @Override
    public void updateOrdskuStateByCode(String tenantCode, String ORDSKU_CODE, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ORDSKU_CODE) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOrdskuModelByCode(tenantCode, ORDSKU_CODE, dataState, oldDataState, map);
    }

    @Override
    public void updateOrdsku(RsOrdskuDomain rsOrdskuDomain) throws ApiException {
        String msg = this.checkOrdsku(rsOrdskuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsOrdskuServiceImpl.updateOrdsku.checkOrdsku", msg);
        }
        RsOrdsku oldRsOrdsku = this.getOrdskuModelById(rsOrdskuDomain.getOrdskuId());
        if (null == oldRsOrdsku) {
            throw new ApiException("rs.RsOrdskuServiceImpl.updateOrdsku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsOrdsku rsOrdsku = this.makeOrdsku(rsOrdskuDomain, oldRsOrdsku);
        this.setOrdskuUpdataDefault(rsOrdsku);
        this.updateOrdskuModel(rsOrdsku);
    }

    @Override
    public RsOrdsku getOrdsku(Integer ORDSKU_ID) {
        if (null == ORDSKU_ID) {
            return null;
        }
        return this.getOrdskuModelById(ORDSKU_ID);
    }

    @Override
    public void deleteOrdsku(Integer ORDSKU_ID) throws ApiException {
        if (null == ORDSKU_ID) {
            return;
        }
        this.deleteOrdskuModel(ORDSKU_ID);
    }

    @Override
    public QueryResult<RsOrdsku> queryOrdskuPage(Map<String, Object> map) {
        List<RsOrdsku> rsOrdskuList = this.queryOrdskuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrdsku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsOrdskuList);
        return queryResult;
    }

    @Override
    public RsOrdsku getOrdskuByCode(String tenantCode, String ORDSKU_CODE) throws ApiException {
        if (StringUtils.isBlank((String)ORDSKU_CODE) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ORDSKU_CODE", ORDSKU_CODE);
        return this.getOrdskuModelByCode(map);
    }

    @Override
    public void deleteOrdskuByCode(String tenantCode, String ORDSKU_CODE) throws ApiException {
        if (StringUtils.isBlank((String)ORDSKU_CODE) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ORDSKU_CODE", ORDSKU_CODE);
        this.delOrdskuModelByCode(map);
    }

    @Override
    public void deleteOrdskuByNo(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        this.delOrdskuModelByNo(map);
    }

    @Override
    public RsOrdsku getOrdskuBySkuNoAndMemCode(Map<String, Object> map) throws ApiException {
        RsOrdsku ordskuBySkuNoAndMemCode = this.rsOrdskuMapper.getOrdskuBySkuNoAndMemCode(map);
        return ordskuBySkuNoAndMemCode;
    }

    @Override
    public void sendOrdSkuByStock(Map<String, Object> map, String tenantCode) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("rs.RsOrdskuServiceImpl.sendOrdSkuByStock", "map == null");
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsOrdskuServiceImpl.sendOrdSkuByStock", "tenantCode == null");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("dataState", 0);
        Set<String> skuCodeSet = map.keySet();
        for (String skuCode : skuCodeSet) {
            param.put("goodsNo", skuCode);
            List<RsOrdsku> rsOrdskuList = this.queryOrdskuModelPage(param);
            if (!ListUtil.isNotEmpty(rsOrdskuList)) continue;
            for (RsOrdsku rsOrdsku : rsOrdskuList) {
                rsOrdsku.setOrdskuDate(new Date());
                HashMap<String, String> pmap = new HashMap<String, String>();
                pmap.put("rsOrdsku", JsonUtil.buildNormalBinder().toJson((Object)rsOrdsku));
                this.logger.error("rs.RsOrdskuServiceImpl.sendOrdSkuByStock.pmap == ", pmap);
                BaseAuth.internalRouter.inInvoke("mns.ser.sendGoodsDomain", "1.0", "0", pmap);
                rsOrdsku.setDataState(1);
                this.updateOrdskuModel(rsOrdsku);
            }
        }
    }
}

