/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsWhsetMapper;
import com.yqbsoft.laser.service.resources.domain.RsWhsetDomain;
import com.yqbsoft.laser.service.resources.domain.RsWhsetReDomain;
import com.yqbsoft.laser.service.resources.model.RsWhset;
import com.yqbsoft.laser.service.resources.service.RsWhsetService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsWhsetServiceImpl
extends BaseServiceImpl
implements RsWhsetService {
    private static final String SYS_CODE = "rs.RsWhsetServiceImpl";
    private RsWhsetMapper rsWhsetMapper;

    public void setRsWhsetMapper(RsWhsetMapper rsWhsetMapper) {
        this.rsWhsetMapper = rsWhsetMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsWhsetMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsWhsetServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkWhset(RsWhsetDomain rsWhsetDomain) {
        if (null == rsWhsetDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsWhsetDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setWhsetDefault(RsWhset rsWhset) {
        if (null == rsWhset) {
            return;
        }
        if (null == rsWhset.getDataState()) {
            rsWhset.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsWhset.getGmtCreate()) {
            rsWhset.setGmtCreate(date);
        }
        rsWhset.setGmtModified(date);
        if (StringUtils.isBlank((String)rsWhset.getWhsetCode())) {
            rsWhset.setWhsetCode(this.getNo(null, "RsWhset", "rsWhset", rsWhset.getTenantCode()));
        }
    }

    private int getWhsetMaxCode() {
        int code = 0;
        try {
            return this.rsWhsetMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsWhsetServiceImpl.getWhsetMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setWhsetUpdataDefault(RsWhset rsWhset) {
        if (null == rsWhset) {
            return;
        }
        rsWhset.setGmtModified(this.getSysDate());
    }

    private void saveWhsetModel(RsWhset rsWhset) throws ApiException {
        if (null == rsWhset) {
            return;
        }
        try {
            this.rsWhsetMapper.insert(rsWhset);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsWhsetServiceImpl.saveWhsetModel.ex", (Throwable)e);
        }
    }

    private void saveWhsetBatchModel(List<RsWhset> rsWhsetList) throws ApiException {
        if (null == rsWhsetList || rsWhsetList.isEmpty()) {
            return;
        }
        try {
            this.rsWhsetMapper.insertBatch(rsWhsetList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsWhsetServiceImpl.saveWhsetBatchModel.ex", (Throwable)e);
        }
    }

    private RsWhset getWhsetModelById(Integer whsetId) {
        if (null == whsetId) {
            return null;
        }
        try {
            return this.rsWhsetMapper.selectByPrimaryKey(whsetId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsWhsetServiceImpl.getWhsetModelById", (Throwable)e);
            return null;
        }
    }

    private RsWhset getWhsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsWhsetMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsWhsetServiceImpl.getWhsetModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delWhsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsWhsetMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsWhsetServiceImpl.delWhsetModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsWhsetServiceImpl.delWhsetModelByCode.num");
        }
    }

    private void deleteWhsetModel(Integer whsetId) throws ApiException {
        if (null == whsetId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsWhsetMapper.deleteByPrimaryKey(whsetId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsWhsetServiceImpl.deleteWhsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsWhsetServiceImpl.deleteWhsetModel.num");
        }
    }

    private void updateWhsetModel(RsWhset rsWhset) throws ApiException {
        if (null == rsWhset) {
            return;
        }
        int i = 0;
        try {
            i = this.rsWhsetMapper.updateByPrimaryKey(rsWhset);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsWhsetServiceImpl.updateWhsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsWhsetServiceImpl.updateWhsetModel.num");
        }
    }

    private void updateStateWhsetModel(Integer whsetId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == whsetId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("whsetId", whsetId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsWhsetMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsWhsetServiceImpl.updateStateWhsetModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsWhsetServiceImpl.updateStateWhsetModel.null");
        }
    }

    private void updateStateWhsetModelByCode(String tenantCode, String whsetCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)whsetCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("whsetCode", whsetCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsWhsetMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsWhsetServiceImpl.updateStateWhsetModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsWhsetServiceImpl.updateStateWhsetModelByCode.null");
        }
    }

    private RsWhset makeWhset(RsWhsetDomain rsWhsetDomain, RsWhset rsWhset) {
        if (null == rsWhsetDomain) {
            return null;
        }
        if (null == rsWhset) {
            rsWhset = new RsWhset();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsWhset, (Object)rsWhsetDomain);
            return rsWhset;
        }
        catch (Exception e) {
            this.logger.error("rs.RsWhsetServiceImpl.makeWhset", (Throwable)e);
            return null;
        }
    }

    private RsWhsetReDomain makeRsWhsetReDomain(RsWhset rsWhset) {
        if (null == rsWhset) {
            return null;
        }
        RsWhsetReDomain rsWhsetReDomain = new RsWhsetReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsWhsetReDomain, (Object)rsWhset);
            return rsWhsetReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsWhsetServiceImpl.makeRsWhsetReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsWhset> queryWhsetModelPage(Map<String, Object> parammap) {
        try {
            return this.rsWhsetMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsWhsetServiceImpl.queryWhsetModel", (Throwable)e);
            return null;
        }
    }

    private int countWhset(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsWhsetMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsWhsetServiceImpl.countWhset", (Throwable)e);
        }
        return i;
    }

    private RsWhset createRsWhset(RsWhsetDomain rsWhsetDomain) {
        String msg = this.checkWhset(rsWhsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsWhsetServiceImpl.saveWhset.checkWhset", msg);
        }
        RsWhset rsWhset = this.makeWhset(rsWhsetDomain, null);
        this.setWhsetDefault(rsWhset);
        return rsWhset;
    }

    @Override
    public String saveWhset(RsWhsetDomain rsWhsetDomain) throws ApiException {
        RsWhset rsWhset = this.createRsWhset(rsWhsetDomain);
        this.saveWhsetModel(rsWhset);
        return rsWhset.getWhsetCode();
    }

    @Override
    public String saveWhsetBatch(List<RsWhsetDomain> rsWhsetDomainList) throws ApiException {
        if (null == rsWhsetDomainList || rsWhsetDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsWhset> rsWhsetList = new ArrayList<RsWhset>();
        String code = "";
        for (RsWhsetDomain rsWhsetDomain : rsWhsetDomainList) {
            RsWhset rsWhset = this.createRsWhset(rsWhsetDomain);
            code = rsWhset.getWhsetCode();
            rsWhsetList.add(rsWhset);
        }
        this.saveWhsetBatchModel(rsWhsetList);
        return code;
    }

    @Override
    public void updateWhsetState(Integer whsetId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == whsetId) {
            return;
        }
        this.updateStateWhsetModel(whsetId, dataState, oldDataState, map);
    }

    @Override
    public void updateWhsetStateByCode(String tenantCode, String whsetCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)whsetCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateWhsetModelByCode(tenantCode, whsetCode, dataState, oldDataState, map);
    }

    @Override
    public void updateWhset(RsWhsetDomain rsWhsetDomain) throws ApiException {
        String msg = this.checkWhset(rsWhsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsWhsetServiceImpl.updateWhset.checkWhset", msg);
        }
        RsWhset oldRsWhset = this.getWhsetModelById(rsWhsetDomain.getWhsetId());
        if (null == oldRsWhset) {
            throw new ApiException("rs.RsWhsetServiceImpl.updateWhset.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsWhset rsWhset = this.makeWhset(rsWhsetDomain, oldRsWhset);
        this.setWhsetUpdataDefault(rsWhset);
        this.updateWhsetModel(rsWhset);
    }

    @Override
    public RsWhset getWhset(Integer whsetId) {
        if (null == whsetId) {
            return null;
        }
        return this.getWhsetModelById(whsetId);
    }

    @Override
    public void deleteWhset(Integer whsetId) throws ApiException {
        if (null == whsetId) {
            return;
        }
        this.deleteWhsetModel(whsetId);
    }

    @Override
    public QueryResult<RsWhset> queryWhsetPage(Map<String, Object> map) {
        List<RsWhset> rsWhsetList = this.queryWhsetModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countWhset(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsWhsetList);
        return queryResult;
    }

    @Override
    public RsWhset getWhsetByCode(String tenantCode, String whsetCode) throws ApiException {
        if (StringUtils.isBlank((String)whsetCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("whsetCode", whsetCode);
        return this.getWhsetModelByCode(map);
    }

    @Override
    public void deleteWhsetByCode(String tenantCode, String whsetCode) throws ApiException {
        if (StringUtils.isBlank((String)whsetCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("whsetCode", whsetCode);
        this.delWhsetModelByCode(map);
    }
}

