/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsGoodsRtagMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRtagDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRtagReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddataDomain;
import com.yqbsoft.laser.service.resources.model.RsGoodsRtag;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.service.RsGoodsRtagService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsRtagServiceImpl
extends BaseServiceImpl
implements RsGoodsRtagService {
    private static final String SYS_CODE = "rs.RsGoodsRtagServiceImpl";
    private RsGoodsRtagMapper rsGoodsRtagMapper;
    private RsSenddataBaseService rsSenddataBaseService;

    public void setRsGoodsRtagMapper(RsGoodsRtagMapper rsGoodsRtagMapper) {
        this.rsGoodsRtagMapper = rsGoodsRtagMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsGoodsRtagMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsRtagServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGoodsRtag(RsGoodsRtagDomain rsGoodsRtagDomain) {
        if (null == rsGoodsRtagDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsGoodsRtagDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGoodsRtagDefault(RsGoodsRtag rsGoodsRtag) {
        if (null == rsGoodsRtag) {
            return;
        }
        if (null == rsGoodsRtag.getDataState()) {
            rsGoodsRtag.setDataState(0);
        }
        if (null == rsGoodsRtag.getGmtCreate()) {
            rsGoodsRtag.setGmtCreate(this.getSysDate());
        }
        rsGoodsRtag.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsGoodsRtag.getGoodsRtagCode())) {
            rsGoodsRtag.setGoodsRtagCode(this.getNo(null, "RsGoodsRtag", "rsGoodsRtag", rsGoodsRtag.getTenantCode()));
        }
    }

    private int getGoodsRtagMaxCode() {
        int code = 0;
        try {
            return this.rsGoodsRtagMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsRtagServiceImpl.getGoodsRtagMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsRtagUpdataDefault(RsGoodsRtag rsGoodsRtag) {
        if (null == rsGoodsRtag) {
            return;
        }
        rsGoodsRtag.setGmtModified(this.getSysDate());
    }

    private void saveGoodsRtagModel(RsGoodsRtag rsGoodsRtag) throws ApiException {
        if (null == rsGoodsRtag) {
            return;
        }
        try {
            this.rsGoodsRtagMapper.insert(rsGoodsRtag);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.saveGoodsRtagModel.ex", (Throwable)e);
        }
    }

    private void saveGoodsRtagBatchModel(List<RsGoodsRtag> rsGoodsRtagList) throws ApiException {
        if (null == rsGoodsRtagList || rsGoodsRtagList.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsRtagMapper.insertBatch(rsGoodsRtagList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.saveGoodsRtagBatchModel.ex", (Throwable)e);
        }
    }

    private RsGoodsRtag getGoodsRtagModelById(Integer goodsRtagId) {
        if (null == goodsRtagId) {
            return null;
        }
        try {
            return this.rsGoodsRtagMapper.selectByPrimaryKey(goodsRtagId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsRtagServiceImpl.getGoodsRtagModelById", (Throwable)e);
            return null;
        }
    }

    private RsGoodsRtag getGoodsRtagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsRtagMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsRtagServiceImpl.getGoodsRtagModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGoodsRtagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsRtagMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.delGoodsRtagModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.delGoodsRtagModelByCode.num");
        }
    }

    private void deleteGoodsRtagModel(Integer goodsRtagId) throws ApiException {
        if (null == goodsRtagId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsRtagMapper.deleteByPrimaryKey(goodsRtagId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.deleteGoodsRtagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.deleteGoodsRtagModel.num");
        }
    }

    private void updateGoodsRtagModel(RsGoodsRtag rsGoodsRtag) throws ApiException {
        if (null == rsGoodsRtag) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsRtagMapper.updateByPrimaryKey(rsGoodsRtag);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateGoodsRtagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateGoodsRtagModel.num");
        }
    }

    private void updateStateGoodsRtagModel(Integer goodsRtagId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == goodsRtagId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsRtagId", goodsRtagId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsRtagMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateStateGoodsRtagModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateStateGoodsRtagModel.null");
        }
    }

    private void updateStateGoodsRtagModelByCode(String tenantCode, String goodsRtagCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)goodsRtagCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsRtagCode", goodsRtagCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsRtagMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateStateGoodsRtagModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateStateGoodsRtagModelByCode.null");
        }
    }

    private RsGoodsRtag makeGoodsRtag(RsGoodsRtagDomain rsGoodsRtagDomain, RsGoodsRtag rsGoodsRtag) {
        if (null == rsGoodsRtagDomain) {
            return null;
        }
        if (null == rsGoodsRtag) {
            rsGoodsRtag = new RsGoodsRtag();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsRtag, (Object)rsGoodsRtagDomain);
            return rsGoodsRtag;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsRtagServiceImpl.makeGoodsRtag", (Throwable)e);
            return null;
        }
    }

    private RsGoodsRtagReDomain makeRsGoodsRtagReDomain(RsGoodsRtag rsGoodsRtag) {
        if (null == rsGoodsRtag) {
            return null;
        }
        RsGoodsRtagReDomain rsGoodsRtagReDomain = new RsGoodsRtagReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsRtagReDomain, (Object)rsGoodsRtag);
            return rsGoodsRtagReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsRtagServiceImpl.makeRsGoodsRtagReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsGoodsRtag> queryGoodsRtagModelPage(Map<String, Object> parammap) {
        try {
            return this.rsGoodsRtagMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsRtagServiceImpl.queryGoodsRtagModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsRtag(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsGoodsRtagMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsRtagServiceImpl.countGoodsRtag", (Throwable)e);
        }
        return i;
    }

    private RsGoodsRtag createRsGoodsRtag(RsGoodsRtagDomain rsGoodsRtagDomain) {
        String msg = this.checkGoodsRtag(rsGoodsRtagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.saveGoodsRtag.checkGoodsRtag", msg);
        }
        RsGoodsRtag rsGoodsRtag = this.makeGoodsRtag(rsGoodsRtagDomain, null);
        this.setGoodsRtagDefault(rsGoodsRtag);
        return rsGoodsRtag;
    }

    @Override
    public List<RsSenddata> saveGoodsRtag(RsGoodsRtagDomain rsGoodsRtagDomain) throws ApiException {
        RsGoodsRtag rsGoodsRtag = this.createRsGoodsRtag(rsGoodsRtagDomain);
        this.saveGoodsRtagModel(rsGoodsRtag);
        ArrayList<RsGoodsRtag> rsGoodsRtagList = new ArrayList<RsGoodsRtag>();
        rsGoodsRtagList.add(rsGoodsRtag);
        return this.saveRsSenddataDomain("add", rsGoodsRtagList);
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    private List<RsSenddata> saveRsSenddataDomain(String requestType, List<RsGoodsRtag> rsGoodsRtagList) {
        if (ListUtil.isEmpty(rsGoodsRtagList)) {
            return null;
        }
        ArrayList<RsSenddataDomain> rsSenddataDomainList = new ArrayList<RsSenddataDomain>();
        for (RsGoodsRtag rsGoodsRtag : rsGoodsRtagList) {
            RsSenddataDomain rsSenddataDomain = new RsSenddataDomain();
            rsSenddataDomain.setEsrequestType(requestType);
            rsSenddataDomain.setMemberCode(rsGoodsRtag.getMemberCode());
            rsSenddataDomain.setChannelCode(rsGoodsRtag.getChannelCode());
            rsSenddataDomain.setTenantCode(rsGoodsRtag.getTenantCode());
            rsSenddataDomain.setAppmanageIcode(rsGoodsRtag.getAppmanageIcode());
            rsSenddataDomain.setFdBizcode(rsGoodsRtag.getGoodsCode());
            rsSenddataDomain.setFdBiztype("RsGoodsRtag");
            rsSenddataDomain.setFdBizcodestr(JsonUtil.buildNormalBinder().toJson((Object)rsGoodsRtag));
            rsSenddataDomain.setFdBizid(rsGoodsRtag.getGoodsRtagId());
            rsSenddataDomain.setFdState(rsGoodsRtag.getDataState());
            rsSenddataDomainList.add(rsSenddataDomain);
        }
        return this.getRsSenddataBaseService().saveDatasendBatch(rsSenddataDomainList);
    }

    @Override
    public List<RsSenddata> saveGoodsRtagBatch(List<RsGoodsRtagDomain> rsGoodsRtagDomainList) throws ApiException {
        if (null == rsGoodsRtagDomainList || rsGoodsRtagDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsGoodsRtag> rsGoodsRtagList = new ArrayList<RsGoodsRtag>();
        for (RsGoodsRtagDomain rsGoodsRtagDomain : rsGoodsRtagDomainList) {
            RsGoodsRtag rsGoodsRtag = this.createRsGoodsRtag(rsGoodsRtagDomain);
            rsGoodsRtagList.add(rsGoodsRtag);
        }
        this.saveGoodsRtagBatchModel(rsGoodsRtagList);
        return this.saveRsSenddataDomain("add", rsGoodsRtagList);
    }

    @Override
    public List<RsSenddata> updateGoodsRtagState(Integer goodsRtagId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGoodsRtagModel(goodsRtagId, dataState, oldDataState, map);
        RsGoodsRtag rsGoodsRtag = this.getGoodsRtag(goodsRtagId);
        if (null == rsGoodsRtag) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateGoodsRtagState.null", goodsRtagId.toString());
        }
        ArrayList<RsGoodsRtag> rsGoodsRtagList = new ArrayList<RsGoodsRtag>();
        rsGoodsRtagList.add(rsGoodsRtag);
        return this.saveRsSenddataDomain("update", rsGoodsRtagList);
    }

    @Override
    public List<RsSenddata> updateGoodsRtagStateByCode(String tenantCode, String goodsRtagCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGoodsRtagModelByCode(tenantCode, goodsRtagCode, dataState, oldDataState, map);
        RsGoodsRtag rsGoodsRtag = this.getGoodsRtagByCode(tenantCode, goodsRtagCode);
        if (null == rsGoodsRtag) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateGoodsRtagStateByCode.null", goodsRtagCode);
        }
        ArrayList<RsGoodsRtag> rsGoodsRtagList = new ArrayList<RsGoodsRtag>();
        rsGoodsRtagList.add(rsGoodsRtag);
        return this.saveRsSenddataDomain("update", rsGoodsRtagList);
    }

    @Override
    public List<RsSenddata> updateGoodsRtag(RsGoodsRtagDomain rsGoodsRtagDomain) throws ApiException {
        String msg = this.checkGoodsRtag(rsGoodsRtagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateGoodsRtag.checkGoodsRtag", msg);
        }
        RsGoodsRtag oldRsGoodsRtag = this.getGoodsRtagModelById(rsGoodsRtagDomain.getGoodsRtagId());
        if (null == oldRsGoodsRtag) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateGoodsRtag.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsGoodsRtag rsGoodsRtag = this.makeGoodsRtag(rsGoodsRtagDomain, oldRsGoodsRtag);
        this.setGoodsRtagUpdataDefault(rsGoodsRtag);
        this.updateGoodsRtagModel(rsGoodsRtag);
        ArrayList<RsGoodsRtag> rsGoodsRtagList = new ArrayList<RsGoodsRtag>();
        rsGoodsRtagList.add(rsGoodsRtag);
        return this.saveRsSenddataDomain("edit", rsGoodsRtagList);
    }

    @Override
    public RsGoodsRtag getGoodsRtag(Integer goodsRtagId) {
        return this.getGoodsRtagModelById(goodsRtagId);
    }

    @Override
    public List<RsSenddata> deleteGoodsRtag(Integer goodsRtagId) throws ApiException {
        RsGoodsRtag rsGoodsRtag = this.getGoodsRtag(goodsRtagId);
        if (null == rsGoodsRtag) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.deleteGoodsRtag.null", goodsRtagId.toString());
        }
        this.deleteGoodsRtagModel(goodsRtagId);
        ArrayList<RsGoodsRtag> rsGoodsRtagList = new ArrayList<RsGoodsRtag>();
        rsGoodsRtagList.add(rsGoodsRtag);
        return this.saveRsSenddataDomain("delete", rsGoodsRtagList);
    }

    @Override
    public QueryResult<RsGoodsRtag> queryGoodsRtagPage(Map<String, Object> map) {
        List<RsGoodsRtag> rsGoodsRtagList = this.queryGoodsRtagModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsRtag(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsGoodsRtagList);
        return queryResult;
    }

    @Override
    public RsGoodsRtag getGoodsRtagByCode(String tenantCode, String goodsRtagCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsRtagCode", goodsRtagCode);
        return this.getGoodsRtagModelByCode(map);
    }

    @Override
    public List<RsSenddata> deleteGoodsRtagByCode(String tenantCode, String goodsRtagCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsRtagCode", goodsRtagCode);
        RsGoodsRtag rsGoodsRtag = this.getGoodsRtagModelByCode(map);
        this.delGoodsRtagModelByCode(map);
        ArrayList<RsGoodsRtag> rsGoodsRtagList = new ArrayList<RsGoodsRtag>();
        rsGoodsRtagList.add(rsGoodsRtag);
        return this.saveRsSenddataDomain("delete", rsGoodsRtagList);
    }

    @Override
    public List<RsSenddata> updateByRtagCode(RsGoodsRtagDomain rsGoodsRtagDomain) throws ApiException {
        if (null == rsGoodsRtagDomain) {
            return null;
        }
        RsGoodsRtag rsGoodsRtag = this.makeGoodsRtag(rsGoodsRtagDomain, null);
        int i = 0;
        try {
            i = this.rsGoodsRtagMapper.updateByRtagCode(rsGoodsRtag);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateByRtagCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateByRtagCode.num");
        }
        if (StringUtils.isNotBlank((String)rsGoodsRtag.getGoodsRtagCode())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", rsGoodsRtag.getTenantCode());
            map.put("goodsRtagCode", rsGoodsRtag.getGoodsRtagCode());
            rsGoodsRtag = this.getGoodsRtagModelByCode(map);
        } else {
            rsGoodsRtag = this.getGoodsRtagModelById(rsGoodsRtag.getGoodsRtagId());
        }
        ArrayList<RsGoodsRtag> rsGoodsRtagList = new ArrayList<RsGoodsRtag>();
        rsGoodsRtagList.add(rsGoodsRtag);
        return this.saveRsSenddataDomain("edit", rsGoodsRtagList);
    }

    @Override
    public List<RsSenddata> deleteGoodsRtagList(List<RsGoodsRtagDomain> rsGoodsRtagDomainList) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsRtagDomainList)) {
            return null;
        }
        ArrayList<RsSenddata> rslist = new ArrayList<RsSenddata>();
        for (RsGoodsRtagDomain rsGoodsRtagDomain : rsGoodsRtagDomainList) {
            if (StringUtils.isBlank((String)rsGoodsRtagDomain.getGoodsCode()) || StringUtils.isBlank((String)rsGoodsRtagDomain.getRtagCode()) || StringUtils.isBlank((String)rsGoodsRtagDomain.getTenantCode())) continue;
            RsGoodsRtag rsGoodsRtag = this.makeGoodsRtag(rsGoodsRtagDomain, null);
            Map qmap = this.getQueryParamMap("goodsCode,rtagCode,tenantCode", new Object[]{rsGoodsRtag.getGoodsCode(), rsGoodsRtag.getRtagCode(), rsGoodsRtag.getTenantCode()});
            this.deleteGoodsRtagBatchModel(qmap);
            List<RsGoodsRtag> rlist = this.queryGoodsRtagModelPage(qmap);
            List<RsSenddata> temprslist = this.saveRsSenddataDomain("delete", rlist);
            if (!ListUtil.isEmpty(temprslist)) continue;
            rslist.addAll(temprslist);
        }
        return rslist;
    }

    @Override
    public List<RsSenddata> updateStateList(String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == tenantCode || null == dataState || null == oldDataState) {
            return null;
        }
        this.updateStateListModel(tenantCode, dataState, oldDataState);
        List<RsGoodsRtag> rlist = this.queryGoodsRtagModelPage(this.getQueryParamMap("oldDataState,tenantCode", new Object[]{oldDataState, tenantCode}));
        return this.saveRsSenddataDomain("update", rlist);
    }

    public void updateStateListModel(String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == tenantCode || null == dataState || null == oldDataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsGoodsRtagMapper.updateStateBatch(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateStateList.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.updateStateList.null");
        }
    }

    public void deleteGoodsRtagBatchModel(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsRtagMapper.deleteByGoodsCodeAndRtagCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsRtagServiceImpl.deleteGoodsRtagBatchModel.ex", (Throwable)e);
        }
    }
}

