/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.channeles.ChannelGoodsBean;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisRsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.EditSkuDomain;
import com.yqbsoft.laser.service.resources.domain.GoodsBean;
import com.yqbsoft.laser.service.resources.domain.OcReorderDomain;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.domain.RsBrandDomain;
import com.yqbsoft.laser.service.resources.domain.RsBrandauDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRtagDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.StockDomain;
import com.yqbsoft.laser.service.resources.domain.StoreSkuSumBean;
import com.yqbsoft.laser.service.resources.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.resources.domain.WhUserwhDomain;
import com.yqbsoft.laser.service.resources.domain.WhUserwhMemDomain;
import com.yqbsoft.laser.service.resources.enumc.ResourcesStartCon;
import com.yqbsoft.laser.service.resources.es.EsWhUserwhPollThread;
import com.yqbsoft.laser.service.resources.es.EsWhUserwhPutThread;
import com.yqbsoft.laser.service.resources.es.EsWhUserwhService;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.service.RsBrandService;
import com.yqbsoft.laser.service.resources.service.RsBrandauService;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassService;
import com.yqbsoft.laser.service.resources.service.RsGoodsRtagService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsResourceListService;
import com.yqbsoft.laser.service.resources.service.RsResourceService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.util.WarehouseUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;

public class RsResourceServiceImpl
extends BaseServiceImpl
implements RsResourceService {
    public static final String SYS_CODE = "rs.RsResourceServiceImpl";
    private RsResourceGoodsService rsResourceGoodsService;
    private RsResourceListService rsResourceListService;
    private RsSenddataBaseService rsSenddataBaseService;
    private RsGoodsClassService rsGoodsClassService;
    private RsBrandService rsBrandService;
    private RsBrandauService rsBrandauService;
    private RsClasstreeService rsClasstreeService;
    private RsSkuService rsSkuService;
    RsGoodsRtagService rsGoodsRtagService;
    private String cachekey = "UmUserinfo-userinfoCode";
    private static EsWhUserwhService esWhUserwhService;
    private static Object lock;

    public RsGoodsRtagService getRsGoodsRtagService() {
        return this.rsGoodsRtagService;
    }

    public void setRsGoodsRtagService(RsGoodsRtagService rsGoodsRtagService) {
        this.rsGoodsRtagService = rsGoodsRtagService;
    }

    public void setRsSkuService(RsSkuService rsSkuService) {
        this.rsSkuService = rsSkuService;
    }

    public void setRsGoodsClassService(RsGoodsClassService rsGoodsClassService) {
        this.rsGoodsClassService = rsGoodsClassService;
    }

    public RsClasstreeService getRsClasstreeService() {
        if (null == this.rsClasstreeService) {
            this.rsClasstreeService = (RsClasstreeService)ApplicationContextUtil.getService((String)"rsClasstreeService");
        }
        if (null == this.rsClasstreeService) {
            this.logger.error("rs.RsResourceServiceImpl.getRsClasstreeService.null");
        }
        return this.rsClasstreeService;
    }

    public RsBrandService getRsBrandService() {
        if (null == this.rsBrandService) {
            this.rsBrandService = (RsBrandService)ApplicationContextUtil.getService((String)"rsBrandService");
        }
        return this.rsBrandService;
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public RsResourceListService getRsResourceListService() {
        return this.rsResourceListService;
    }

    public void setRsResourceListService(RsResourceListService rsResourceListService) {
        this.rsResourceListService = rsResourceListService;
    }

    public RsResourceGoodsService getRsResourceGoodsService() {
        return this.rsResourceGoodsService;
    }

    public void setRsResourceGoodsService(RsResourceGoodsService rsResourceGoodsService) {
        this.rsResourceGoodsService = rsResourceGoodsService;
    }

    public RsBrandauService getRsBrandauService() {
        return this.rsBrandauService;
    }

    public void setRsBrandauService(RsBrandauService rsBrandauService) {
        this.rsBrandauService = rsBrandauService;
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), true);
    }

    private OcReorderDomain sendSaveResources(List<ResourceStockDomain> resourceGoodsList, String type, boolean channelflag) {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (ListUtil.isEmpty(resourceGoodsList)) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        String key = resourceGoodsList.get(0).getContractBillcode() + "-" + resourceGoodsList.get(0).getTenantCode();
        try {
            List<RsSenddata> rsSenddataList = channelflag ? this.rsResourceGoodsService.updateResourceChannleStock(resourceGoodsList, type) : this.rsResourceGoodsService.updateResourceStock(resourceGoodsList, type);
            ocReorderDomain.setOrderState("2");
            this.getRsSenddataBaseService().sendData(rsSenddataList);
            return ocReorderDomain;
        }
        catch (ApiException e) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveResources.apierror", (Object)e.getMessage());
            ocReorderDomain.setOrderState("3");
            DisUtil.set((String)("goods-" + key), (String)(e.getErrCode() + "-" + e.getErrMsg()), (int)7200);
            return ocReorderDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveResources.error", (Object)e.getMessage());
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), true);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByPayBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAYBACK.getCode(), true);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByPayBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAYBACK.getCode(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockByCom(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (ListUtil.isEmpty(resourceGoodsList)) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        return this.sendSaveResources(resourceGoodsList, resourceGoodsList.get(0).getType(), true);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByCom(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (ListUtil.isEmpty(resourceGoodsList)) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        return this.sendSaveResources(resourceGoodsList, resourceGoodsList.get(0).getType(), false);
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), true);
    }

    @Override
    public String sendSaveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveResourceGoods(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsResourceGoodsDomain.getGoodsCode();
    }

    @Override
    public void sendSavePassResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.savePassResourceGoodsBatch(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendSavePassResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.savePassResourceGoods(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsResourceGoodsDomain.getGoodsCode();
    }

    @Override
    public void sendSaveResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveResourceGoodsBatch(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        this.rsResourceGoodsService.updateResourceGoods(rsResourceGoodsDomain);
    }

    @Override
    public void sendDelResourceGoodsByCode(Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.delResourceGoodsByCode(map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateShelveGoods(List<Integer> goodsIds) throws ApiException {
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        ArrayList<RsResourceGoods> goodsList = new ArrayList<RsResourceGoods>();
        for (Integer goodsId : goodsIds) {
            RsResourceGoods rsResourceGoods = this.rsResourceGoodsService.getResourceGoodsModel(goodsId);
            goodsList.add(rsResourceGoods);
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveGoodList(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutGoods(List<Integer> goodsIds) throws ApiException {
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        ArrayList<RsResourceGoods> goodsList = new ArrayList<RsResourceGoods>();
        for (Integer goodsId : goodsIds) {
            RsResourceGoods rsResourceGoods = this.rsResourceGoodsService.getResourceGoodsModel(goodsId);
            goodsList.add(rsResourceGoods);
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutGoodsList(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendDeletePromotione(String tenantCode, String channelCode, String promotionCode) throws ApiException {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        Map map = new HashMap();
        map = this.getQueryMapParam("dataOpbillstate,ginfoCode,tenantCode", new Object[]{1, promotionCode, tenantCode});
        List<RsResourceGoods> rlist = this.rsResourceGoodsService.queryResourceGoodsReModePage(map);
        if (ListUtil.isEmpty(rlist)) {
            return "success";
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutGoodsList(rlist);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public void sendUpdateAuditResource(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResource(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateCanlAuditResource(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditCanlResource(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResourcePass(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResourcePass(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResourceNoPass(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResourceNoPass(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateGoodsStateByIdForMemo(Integer goodsId, Integer dataState, Integer oldDataState, Map<String, Object> paramMap) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateGoodsStateByIdForMemo(goodsId, dataState, oldDataState, paramMap);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateGoodsStateById(Integer goodsId, Integer dataState, Integer oldDataState) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateGoodsStateById(goodsId, dataState, oldDataState);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuStateById(Integer skuId, Integer dataState, Integer oldDataState) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuStateById(skuId, dataState, oldDataState);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteGoodsById(Integer goodsId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteGoodsById(goodsId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteResourceGoodsList(List<Integer> goodsIds) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteResourceGoodsList(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutSku(Integer skuId) throws ApiException {
        RsSku rsSku = this.rsSkuService.getSku(skuId);
        if (rsSku == null) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateSoldOutSku.null", "rsSku is null");
        }
        if (ResourcesConstants.DATA_OPBILLSTATE_0.intValue() == rsSku.getDataOpbillstate().intValue()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateSoldOutSku.null", "\u72b6\u6001\u9519\u8bef");
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutSkuModel(rsSku);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateShelveSku(Integer skuId) {
        RsSku rsSku = this.rsSkuService.getSku(skuId);
        if (rsSku == null) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateShelveSku.null", "rsSku is null");
        }
        if (ResourcesConstants.DATA_OPBILLSTATE_1.intValue() == rsSku.getDataOpbillstate().intValue()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateShelveSku.null", "\u72b6\u6001\u9519\u8bef");
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveSkuModel(rsSku);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuEdit(EditSkuDomain editSkuDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuEdit(editSkuDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateBatchSkuEdit(List<EditSkuDomain> editSkuDomainList) throws ApiException {
        if (ListUtil.isEmpty(editSkuDomainList)) {
            return null;
        }
        String msg = "";
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuBatchEdit(editSkuDomainList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return msg;
    }

    @Override
    public void sendUpdateSkuEditErp(EditSkuDomain editSkuDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuErpEdit(editSkuDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuChannel(String goodsCode, String skuCode, String skuOldcode, String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuChannel(goodsCode, skuCode, skuOldcode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendChData(rsSenddataList);
        }
    }

    @Override
    public List<RsSenddata> sendSaveDisResourceGoods(List<DisRsResourceGoodsDomain> disRsResourceGoodsList) throws ApiException {
        return this.rsResourceGoodsService.saveDisResourceGoods(disRsResourceGoodsList);
    }

    @Override
    public List<RsSenddata> sendSaveDisSku(List<DisRsSkuDomain> disRsSkuList) throws ApiException {
        return this.rsResourceGoodsService.saveDisSku(disRsSkuList);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuOldcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateDisCannelSku", "param is null");
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("skuOldcode", skuOldcode);
        parammap.put("tenantCode", tenantCode);
        parammap.put("channelCode", channelCode);
        parammap.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
        QueryResult<RsSku> qllist = this.rsSkuService.querySkuOnePage(parammap);
        if (null == qllist || ListUtil.isEmpty((Collection)qllist.getList())) {
            return null;
        }
        return this.rsResourceGoodsService.updateDisCannelSkuModel(qllist.getList());
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelGoods(String goodsOldcode, String channelCode, String tenantCode) throws ApiException {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("goodsOldcode", goodsOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        parammap.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
        List<RsResourceGoods> goodsList = this.rsResourceGoodsService.queryResourceGoodsReModePage(parammap);
        if (null == goodsList || goodsList.isEmpty()) {
            return null;
        }
        return this.rsResourceGoodsService.updateDisCannelGoodsModel(goodsList);
    }

    @Override
    public List<RsSenddata> sendDeleteDisSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        QueryResult<RsSku> qllist;
        if (StringUtils.isBlank((String)skuOldcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("skuOldcode", skuOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (qllist = this.rsSkuService.querySkuOnePage(parammap)) || ListUtil.isEmpty((Collection)qllist.getList())) {
            return null;
        }
        return this.rsResourceGoodsService.deleteDisSkuModel(qllist.getList());
    }

    @Override
    public List<RsSenddata> sendDeleteDisGoods(String goodsOldcode, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsOldcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("goodsOldcode", goodsOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        List<RsResourceGoods> goodsList = this.rsResourceGoodsService.queryResourceGoodsReModePage(parammap);
        return this.rsResourceGoodsService.deleteDisGoodsModel(goodsList);
    }

    @Override
    public List<RsSenddata> sendSaveDisSkuEdit(List<DisRsSkuDomain> disRsSkuList) {
        List<EditSkuDomain> list = this.rsResourceGoodsService.getMakeDisSkuEdit(disRsSkuList);
        return this.rsResourceGoodsService.updateSkuBatchEdit(list);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelGoodsState(Map<String, Object> map) {
        return this.rsResourceGoodsService.updateDisCannelGoodsState(map);
    }

    @Override
    public List<RsSenddata> sendUpdateDisCannelSkuState(Map<String, Object> map) {
        return this.rsResourceGoodsService.updateDisCannelSkuState(map);
    }

    @Override
    public void sendDeleteSkuBySkuId(Integer skuId) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteSkuBySkuId(skuId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateChannelGoods(String channelCode, String tenantCode) {
        this.rsResourceGoodsService.updateChannelGoods(channelCode, tenantCode);
        return "success";
    }

    @Override
    public String sendUpdateChannelQuwey(Map<String, Object> map) {
        if (MapUtil.isNotEmpty(map) && null != map.get("skuNo") && StringUtils.isNotBlank((String)String.valueOf(map.get("skuNo")))) {
            this.rsResourceGoodsService.updateChannelSkuQuwey(map);
        } else {
            this.rsResourceGoodsService.updateChannelQuwey(map);
        }
        return "";
    }

    @Override
    public String sendUpdateChannelSkuQuwey(Map<String, Object> map) {
        this.rsResourceGoodsService.updateChannelSkuQuwey(map);
        return "";
    }

    @Override
    public void sendSaveChannelGoods(ChannelGoodsBean channelGoodsBean) {
        if (null == channelGoodsBean) {
            return;
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveChannelGoods(channelGoodsBean);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendChData(rsSenddataList);
        }
    }

    @Override
    public void sendDelChannelGoods(ChannelGoodsBean channelGoodsBean) {
        if (null == channelGoodsBean) {
            return;
        }
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteChannelGoods(channelGoodsBean);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendChData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateSkuNum(String skuNo, BigDecimal goodsNum, BigDecimal goodsWeight, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuNum(skuNo, goodsNum, goodsWeight, memberCode, memberCcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public String beforeSendUpdateSkuNum(String skuNo, String goodsNum, String goodsWeight, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        BigDecimal bigDecimalNum = new BigDecimal(goodsNum);
        BigDecimal bigDecimalWeight = new BigDecimal(goodsWeight);
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuNum(skuNo, bigDecimalNum, bigDecimalWeight, memberCode, memberCcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendNumData(rsSenddataList);
        }
        return "success";
    }

    @Override
    public String sendUpdateSkuLockNum(StockDomain stockDomain) {
        return this.rsResourceGoodsService.updateSkuLockNum(stockDomain);
    }

    @Override
    public String sendSaveGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.saveGoodsClass(rsGoodsClassDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
            return rsSenddataList.get(0).getFdBizcode();
        }
        return null;
    }

    @Override
    public void sendUpdateGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.updateGoodsClass(rsGoodsClassDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteGoodsClass(Integer goodsClassId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.deleteGoodsClass(goodsClassId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDelGoodsClassByCode(Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.delGoodsClassByCode(map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public void sendSaveGoodsClassInit(String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.saveGoodsClassInit(tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
    }

    @Override
    public String sendUpdateGoodsClassChannelInit(String tenantCode) {
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.updateGoodsClassChannelInit(tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendData(rsSenddataList);
        }
        return "";
    }

    @Override
    public void sendUpdateGoodsEocode(String goodsCode, String goodsEocode, String tenantCode) throws ApiException {
        this.rsResourceGoodsService.updateGoodsEocode(goodsCode, goodsEocode, tenantCode);
    }

    @Override
    public void sendUpdateSkuEocode(String skuCode, String skuEocode, String tenantCode) throws ApiException {
        this.rsResourceGoodsService.updateSkuEocode(skuCode, skuEocode, tenantCode);
    }

    @Override
    public void sendUpdateShelveBatchSku(List<Integer> skuIdList) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveBatchSku(skuIdList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutBatchSku(List<Integer> skuIdList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutBatchSku(skuIdList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteBatchSkuBySkuId(List<Integer> skuIdList) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteBatchSkuBySkuId(skuIdList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendSaveBrand(RsBrandDomain rsBrandDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandService().saveBrand(rsBrandDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsBrandDomain.getBrandCode();
    }

    @Override
    public void sendUpdateBrand(RsBrandDomain rsBrandDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandService().updateBrand(rsBrandDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateBrandau(RsBrandauDomain rsBrandauDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandauService().sendUpdateBrandau(rsBrandauDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteBrand(Integer brandId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsBrandService().deleteBrand(brandId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public String sendSaveClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        if (null == rsClasstreeDomain) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveClasstree.null");
            return "";
        }
        RsClasstree rsClasstree = this.getRsClasstreeService().checkClasstreeNameByChannelCode(rsClasstreeDomain.getClasstreeName(), rsClasstreeDomain.getTenantCode(), rsClasstreeDomain.getChannelCode());
        if (null == rsClasstree) {
            List<RsSenddata> rsSenddataList = this.getRsClasstreeService().saveClasstree(rsClasstreeDomain);
            if (ListUtil.isNotEmpty(rsSenddataList)) {
                this.getRsSenddataBaseService().sendOpData(rsSenddataList);
            }
        } else {
            return rsClasstree.getClasstreeCode();
        }
        return rsClasstreeDomain.getClasstreeCode();
    }

    @Override
    public String sendSaveClasstreeTow(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsClasstreeService().saveClasstree(rsClasstreeDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
        return rsClasstreeDomain.getClasstreeCode();
    }

    @Override
    public void sendUpdateClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.getRsClasstreeService().updateClasstree(rsClasstreeDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteClasstree(Integer classtreeId) throws ApiException {
        List<RsSenddata> rsSenddataList;
        if (StringUtils.isBlank((Integer)classtreeId)) {
            this.logger.error("rs.RsResourceServiceImpl.sendDeleteClasstree", (Object)classtreeId);
        }
        if (ListUtil.isNotEmpty(rsSenddataList = this.getRsClasstreeService().deleteClasstree(classtreeId))) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public void sendupdateOrder(List<RsGoodsClassDomain> rsGoodsClassDomains) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsClassDomains)) {
            this.logger.error("rs.RsResourceServiceImpl.sendupdateOrder", rsGoodsClassDomains);
            return;
        }
        List<RsSenddata> rsSenddataList = this.rsGoodsClassService.updateOrderBatch(rsGoodsClassDomains);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.getRsSenddataBaseService().sendOpData(rsSenddataList);
        }
    }

    @Override
    public RsResourceGoodsReDomain getResourceGoodsReDomain(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("rs.RsResourceServiceImpl.getResourceGoodsReDomain");
            return null;
        }
        String skuNo = (String)map.get("skuNo");
        String goodsType = (String)map.get("goodsType");
        String memberCode = (String)map.get("memberCode");
        String memberCcode = (String)map.get("memberCcode");
        String channelCode = (String)map.get("channelCode");
        String tenantCode = (String)map.get("tenantCode");
        String goodsPro = null == map.get("goodsPro") ? null : (String)map.get("goodsPro");
        boolean flag = false;
        if (StringUtils.isBlank((String)goodsType) && StringUtils.isNotBlank((String)goodsPro) && "6".equals(goodsPro)) {
            goodsType = "06,28";
        } else if (StringUtils.isBlank((String)goodsType) || goodsType.equals("00")) {
            goodsType = "26";
            flag = true;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuNo, memberCode, memberCcode, channelCode, goodsType, tenantCode);
        if (null == goodsBean && flag) {
            goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuNo, memberCode, memberCcode, channelCode, "00", tenantCode);
        }
        if (null == goodsBean) {
            this.logger.error("rs.RsResourceServiceImpl.getResourceBySkuNoType.", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.makeReDomain(goodsBean.getRsResourceGoods(), false);
        return rsResourceGoodsReDomain;
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByOrderStr(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResourcesStr(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), false);
    }

    private OcReorderDomain sendSaveResourcesStr(List<ResourceStockDomain> resourceGoodsList, String type, boolean channelflag) {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (null == resourceGoodsList || resourceGoodsList.isEmpty()) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        try {
            List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateResourceStockStr(resourceGoodsList, type);
            ocReorderDomain.setOrderState("2");
            this.getRsSenddataBaseService().sendData(rsSenddataList);
            return ocReorderDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceServiceImpl.sendSaveResources.error", (Object)e.getMessage());
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
    }

    @Override
    public OcReorderDomain sendUpdateResourceStockChannelByBackStr(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.sendSaveResourcesStr(resourceGoodsList, ResourcesStartCon.BACK.getCode(), false);
    }

    @Override
    public void sendDeleteSku(String skuEcode, String goodsType, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuEcode, null, null, channelCode, goodsType, tenantCode);
        if (null == goodsBean || null == goodsBean.getRsSku()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendDeleteSku.goodsBean", skuEcode + "=" + goodsType + "=" + channelCode + "=" + tenantCode);
        }
        ArrayList<Integer> skuIdList = new ArrayList<Integer>();
        skuIdList.add(goodsBean.getRsSku().getSkuId());
        this.sendDeleteBatchSkuBySkuId(skuIdList);
    }

    @Override
    public void sendUpdateShelveSku(String skuEcode, String goodsType, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuEcode, null, null, channelCode, goodsType, tenantCode);
        if (null == goodsBean || null == goodsBean.getRsSku()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateShelveSku.goodsBean", skuEcode + "=" + goodsType + "=" + channelCode + "=" + tenantCode);
        }
        this.sendUpdateShelveSku(goodsBean.getRsSku().getSkuId());
    }

    @Override
    public void sendUpdateSoldOutSku(String skuEcode, String goodsType, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GoodsBean goodsBean = this.rsResourceGoodsService.getResourceBySkuNoType(skuEcode, null, null, channelCode, goodsType, tenantCode);
        if (null == goodsBean || null == goodsBean.getRsSku()) {
            throw new ApiException("rs.RsResourceServiceImpl.sendUpdateSoldOutSku.goodsBean", skuEcode + "=" + goodsType + "=" + channelCode + "=" + tenantCode);
        }
        ArrayList<Integer> skuIdList = new ArrayList<Integer>();
        skuIdList.add(goodsBean.getRsSku().getSkuId());
        this.sendUpdateSoldOutBatchSku(skuIdList);
    }

    @Override
    public void updateBrandauState(Integer brandauId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        List<RsSenddata> list = this.rsBrandauService.updateBrandauState(brandauId, dataState, oldDataState, memo);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendOpData(list);
        }
    }

    @Override
    public void updateBrandauStateByCode(String tenantCode, String brandauCode, Integer dataState, Integer oldDataState) throws ApiException {
        List<RsSenddata> list = this.rsBrandauService.updateBrandauStateByCode(tenantCode, brandauCode, dataState, oldDataState);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendOpData(list);
        }
    }

    @Override
    public void updateGoodsRelNum(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        List<RsSenddata> list = this.rsResourceGoodsService.updateGoodsRelNum(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendDeleteGoodsRtag(Integer goodsRtagId) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.deleteGoodsRtag(goodsRtagId);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public String sendSaveGoodsRtag(RsGoodsRtagDomain rsGoodsRtagDomain) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.saveGoodsRtag(rsGoodsRtagDomain);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
            return list.get(0).getFdBizcode();
        }
        return null;
    }

    @Override
    public String sendSaveGoodsRtagBatch(List<RsGoodsRtagDomain> rsGoodsRtagDomainList) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.saveGoodsRtagBatch(rsGoodsRtagDomainList);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
            return list.get(0).getFdBizcode();
        }
        return null;
    }

    @Override
    public void sendUpdateGoodsRtagState(Integer goodsRtagId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateGoodsRtagState(goodsRtagId, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendUpdateGoodsRtagStateByCode(String tenantCode, String goodsRtagCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateGoodsRtagStateByCode(tenantCode, goodsRtagCode, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendUpdateGoodsRtag(RsGoodsRtagDomain rsGoodsRtagDomain) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateGoodsRtag(rsGoodsRtagDomain);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendDeleteGoodsRtagByCode(String tenantCode, String goodsRtagCode) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.deleteGoodsRtagByCode(tenantCode, goodsRtagCode);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendUpdateByRtagCode(RsGoodsRtagDomain rsGoodsRtagDomain) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateByRtagCode(rsGoodsRtagDomain);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendDeleteGoodsRtagList(List<RsGoodsRtagDomain> rsGoodsRtagDomainList) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.deleteGoodsRtagList(rsGoodsRtagDomainList);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    @Override
    public void sendUpdateRuleSkuNum(String memberCode, String tenantCode) throws ApiException {
        ConcurrentHashMap<String, String> ddMap;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelCode", "B2Bchannel");
        QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.rsSkuService.querySkuPage(map);
        if (ListUtil.isEmpty((Collection)rsSkuDomainQueryResult.getList())) {
            return;
        }
        UmUserinfoDomainBean umUserinfoDomainBean = this.makeUmuserinfo(memberCode, tenantCode);
        if (null != umUserinfoDomainBean) {
            ddMap = new ConcurrentHashMap<String, String>();
            Map ddMapJson = DisUtil.getMapAll((String)this.cachekey);
            if (MapUtils.isNotEmpty((Map)ddMapJson)) {
                DisUtil.delVer((String)this.cachekey);
            }
        } else {
            return;
        }
        ddMap.put(this.cachekey, JsonUtil.buildNonDefaultBinder().toJson((Object)umUserinfoDomainBean));
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        RsResourceServiceImpl.getEsWhUserwhService().addPutPool(new EsWhUserwhPutThread(RsResourceServiceImpl.getEsWhUserwhService(), rsSkuDomainQueryResult.getList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsWhUserwhService getEsWhUserwhService() {
        Object object = lock;
        synchronized (object) {
            if (null == esWhUserwhService) {
                esWhUserwhService = new EsWhUserwhService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 100; ++i) {
                    esWhUserwhService.addPollPool(new EsWhUserwhPollThread(esWhUserwhService));
                }
            }
            return esWhUserwhService;
        }
    }

    @Override
    public void makeWhUserRsSku(RsSkuDomain rsSkuDomain) {
        WarehouseUtil warehouseUtil = new WarehouseUtil();
        Map ddMap = DisUtil.getMapAll((String)this.cachekey);
        UmUserinfoDomainBean umUserinfoDomainBean = null;
        for (String key : ddMap.keySet()) {
            umUserinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject((String)ddMap.get(key), UmUserinfoDomainBean.class);
        }
        if (null == umUserinfoDomainBean) {
            this.logger.error("rs.RsResourceServiceImpl.makeWhUserRsSku\u7528\u6237\u4e0d\u5b58\u5728");
            return;
        }
        WhUserwhDomain whUserwhDomain = warehouseUtil.makeWhUserwh(rsSkuDomain, umUserinfoDomainBean);
        if (null == whUserwhDomain) {
            return;
        }
        this.logger.error("rs.RsResourceServiceImpl.makeWhUserRsSku.whUserwhDomain" + JsonUtil.buildNonDefaultBinder().toJson((Object)whUserwhDomain));
        String userwhUpro = whUserwhDomain.getUserwhUpro();
        String channelSort = null;
        if (StringUtils.isNotBlank((String)userwhUpro) && "all".equals(userwhUpro)) {
            StoreSkuSumBean storeSkuSumBean;
            if (null == (umUserinfoDomainBean = this.getPlatCode(umUserinfoDomainBean.getTenantCode()))) {
                this.logger.error("rs.RsResourceServiceImplqueryBywhUserwhDomain.getPlatCode", (Object)umUserinfoDomainBean.getTenantCode());
                return;
            }
            channelSort = "0";
            DisChannel disChannel = this.getChannel(umUserinfoDomainBean.getUserinfoCode(), channelSort, whUserwhDomain.getTenantCode());
            if (null == disChannel) {
                this.logger.error("rs.RsResourceServiceImplqueryBywhUserwhDomain.disChannel.1", (Object)(umUserinfoDomainBean.getUserinfoCode() + "=" + channelSort + "=" + whUserwhDomain.getTenantCode()));
            }
            if (BigDecimal.ZERO.compareTo((storeSkuSumBean = this.storeSkuSum(whUserwhDomain, rsSkuDomain)).getGoodsSupplynum()) == -1) {
                this.beforeSendUpdateSkuNum(rsSkuDomain.getSkuNo(), storeSkuSumBean.getGoodsSupplynum().toString(), storeSkuSumBean.getGoodsSupplyweight().toString(), umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getUserinfoCode(), disChannel.getChannelCcode(), umUserinfoDomainBean.getTenantCode());
            }
        }
        if (StringUtils.isNotBlank((String)userwhUpro) && "areaCode".equals(userwhUpro)) {
            String userwhUprovalue = whUserwhDomain.getUserwhUprovalue();
            umUserinfoDomainBean = this.getUmUserinfoDomainBean(whUserwhDomain.getTenantCode(), userwhUprovalue, null);
            if (null == umUserinfoDomainBean) {
                this.logger.error("rs.RsResourceServiceImplqueryBywhUserwhDomain.getCompname", (Object)(umUserinfoDomainBean.getTenantCode() + "=" + userwhUprovalue));
                return;
            }
            channelSort = "5";
            DisChannel disChannel = this.getChannel(umUserinfoDomainBean.getUserinfoCode(), channelSort, whUserwhDomain.getTenantCode());
            if (null == disChannel) {
                this.logger.error("rs.RsResourceServiceImplqueryBywhUserwhDomain.disChannel.2", (Object)(umUserinfoDomainBean.getUserinfoCode() + "=" + channelSort + "=" + whUserwhDomain.getTenantCode()));
                return;
            }
            StoreSkuSumBean storeSkuSumBean = this.storeSkuSum(whUserwhDomain, rsSkuDomain);
            if (BigDecimal.ZERO.compareTo(storeSkuSumBean.getGoodsSupplynum()) == -1) {
                this.beforeSendUpdateSkuNum(rsSkuDomain.getSkuNo(), storeSkuSumBean.getGoodsSupplynum().toString(), storeSkuSumBean.getGoodsSupplyweight().toString(), umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getUserinfoCode(), disChannel.getChannelCcode(), umUserinfoDomainBean.getTenantCode());
            }
        }
        if (StringUtils.isNotBlank((String)userwhUpro) && "memberCode".equals(userwhUpro)) {
            channelSort = "6";
            List<WhUserwhMemDomain> whUserwhMemDomainList = whUserwhDomain.getWhUserwhMemDomainList();
            if (ListUtil.isNotEmpty(whUserwhMemDomainList)) {
                for (WhUserwhMemDomain whUserwhMemDomain : whUserwhMemDomainList) {
                    umUserinfoDomainBean = this.getUmUserinfoDomainBean(whUserwhDomain.getTenantCode(), null, whUserwhMemDomain.getUserwhMemValue());
                    if (null == umUserinfoDomainBean) {
                        this.logger.error("rs.RsResourceServiceImplqueryBywhUserwhDomain.umUserinfoDomainBean", (Object)(umUserinfoDomainBean.getTenantCode() + "=" + channelSort + "=" + umUserinfoDomainBean.getTenantCode()));
                        continue;
                    }
                    DisChannel disChannel = this.getChannel(umUserinfoDomainBean.getUserinfoCode(), channelSort, umUserinfoDomainBean.getTenantCode());
                    if (null == disChannel) {
                        this.logger.error("rs.RsResourceServiceImplqueryBywhUserwhDomain.disChannel.3", (Object)(umUserinfoDomainBean.getUserinfoCode() + "=" + channelSort + "=" + whUserwhDomain.getTenantCode()));
                        continue;
                    }
                    StoreSkuSumBean storeSkuSumBean = this.storeSkuSum(whUserwhDomain, rsSkuDomain);
                    if (BigDecimal.ZERO.compareTo(storeSkuSumBean.getGoodsSupplynum()) != -1) continue;
                    this.beforeSendUpdateSkuNum(rsSkuDomain.getSkuNo(), storeSkuSumBean.getGoodsSupplynum().toString(), storeSkuSumBean.getGoodsSupplyweight().toString(), umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getUserinfoCode(), disChannel.getChannelCcode(), umUserinfoDomainBean.getTenantCode());
                }
            }
        }
    }

    public StoreSkuSumBean storeSkuSum(WhUserwhDomain whUserwhDomain, RsSkuDomain rsSkuDomain) {
        StoreSkuSumBean storeSkuSumBean = new StoreSkuSumBean();
        HashMap<String, String> storeSkuMap = new HashMap<String, String>();
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        storeSkuMap.put("tenantCode", whUserwhDomain.getTenantCode());
        storeSkuMap.put("skuNo", rsSkuDomain.getSkuNo());
        storeSkuMap.put("storeType", "0");
        storeSkuMap.put("warehouseCode", whUserwhDomain.getWarehouseCode());
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(storeSkuMap));
        Map storeSkuSum = (Map)this.getForObject("wh.whStoreGoods.querySumStoreSku", Map.class, invokeMap);
        if (MapUtils.isEmpty((Map)storeSkuSum) && null == storeSkuSum.get("goodsSupplynum")) {
            return null;
        }
        BigDecimal goodsSupplynum = storeSkuSum.get("goodsSupplynum") == null ? new BigDecimal(0) : new BigDecimal(storeSkuSum.get("goodsSupplynum").toString());
        BigDecimal goodsSupplyweight = storeSkuSum.get("goodsSupplyweight") == null ? new BigDecimal(0) : new BigDecimal(storeSkuSum.get("goodsSupplyweight").toString());
        BigDecimal goodsNum = storeSkuSum.get("goodsNum") == null ? new BigDecimal(0) : new BigDecimal(storeSkuSum.get("goodsNum").toString());
        BigDecimal goodsWeight = storeSkuSum.get("goodsWeight") == null ? new BigDecimal(0) : new BigDecimal(storeSkuSum.get("goodsWeight").toString());
        storeSkuSumBean.setGoodsSupplynum(goodsSupplynum);
        storeSkuSumBean.setGoodsSupplyweight(goodsSupplyweight);
        storeSkuSumBean.setGoodsNum(goodsNum);
        storeSkuSumBean.setGoodsWeight(goodsWeight);
        return storeSkuSumBean;
    }

    public UmUserinfoDomainBean getUmUserinfoDomainBean(String tenantCode, String userinfoCompname, String userinfoCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)userinfoCompname)) {
            paramMap.put("userinfoCompname", userinfoCompname);
        }
        if (StringUtils.isNotBlank((String)userinfoCode)) {
            paramMap.put("userinfoCode", userinfoCode);
        }
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl("um.user.queryUserinfoPage", invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error("rs.RsResourceServiceImpl.getCompname", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    protected DisChannel getChannel(String memberCode, String channelSort, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelSort)) {
            return null;
        }
        DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-" + channelSort + "-" + tenantCode), DisChannel.class);
        return disChannel;
    }

    public UmUserinfoDomainBean getPlatCode(String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoQuality", "plat");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl("um.user.queryUserinfoPage", invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            this.logger.error("rs.RsResourceServiceImpl.getPlatCode", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    private UmUserinfoDomainBean makeUmuserinfo(String userinfoCode, String tenantCode) {
        UmUserinfoDomainBean userinfoDomainBean = null;
        if (!EmptyUtil.isEmpty((Object)userinfoCode)) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("userinfoCode", userinfoCode);
            userMap.put("tenantCode", tenantCode);
            String UmUserJson = this.internalInvoke("um.userbase.getUserinfoByCode", userMap);
            if (StringUtils.isBlank((String)UmUserJson)) {
                return null;
            }
            userinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(UmUserJson, UmUserinfoDomainBean.class);
        }
        return userinfoDomainBean;
    }

    @Override
    public void sendUpdateStateList(String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        List<RsSenddata> list = this.rsGoodsRtagService.updateStateList(tenantCode, dataState, oldDataState);
        if (ListUtil.isNotEmpty(list)) {
            this.getRsSenddataBaseService().sendData(list);
        }
    }

    static {
        lock = new Object();
    }
}

