/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsResourceListMapper;
import com.yqbsoft.laser.service.resources.domain.RsResourceListDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceListReDomain;
import com.yqbsoft.laser.service.resources.model.RsResourceList;
import com.yqbsoft.laser.service.resources.service.RsResourceListService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsResourceListServiceImpl
extends BaseServiceImpl
implements RsResourceListService {
    private static final String SYS_CODE = "rs.RsResourceListServiceImpl";
    private RsResourceListMapper rsResourceListMapper;

    public void setRsResourceListMapper(RsResourceListMapper rsResourceListMapper) {
        this.rsResourceListMapper = rsResourceListMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsResourceListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkResourceList(RsResourceListDomain rsResourceListDomain) {
        if (null == rsResourceListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsResourceListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setResourceListDefault(RsResourceList rsResourceList) {
        if (null == rsResourceList) {
            return;
        }
        if (null == rsResourceList.getDataState()) {
            rsResourceList.setDataState(0);
        }
        if (null == rsResourceList.getGmtCreate()) {
            rsResourceList.setGmtCreate(this.getSysDate());
        }
        rsResourceList.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsResourceList.getResourceListCode())) {
            rsResourceList.setResourceListCode(this.createUUIDString());
        }
    }

    private int getResourceListMaxCode() {
        int code = 0;
        try {
            return this.rsResourceListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceListServiceImpl.getResourceListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setResourceListUpdataDefault(RsResourceList rsResourceList) {
        if (null == rsResourceList) {
            return;
        }
        rsResourceList.setGmtModified(this.getSysDate());
    }

    private void saveResourceListModel(RsResourceList rsResourceList) throws ApiException {
        if (null == rsResourceList) {
            return;
        }
        try {
            this.rsResourceListMapper.insert(rsResourceList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceListServiceImpl.saveResourceListModel.ex", (Throwable)e);
        }
    }

    private void saveResourceListBatchModel(List<RsResourceList> rsResourceListList) throws ApiException {
        if (null == rsResourceListList || rsResourceListList.isEmpty()) {
            return;
        }
        try {
            this.rsResourceListMapper.insertBatch(rsResourceListList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceListServiceImpl.saveResourceListBatchModel.ex", (Throwable)e);
        }
    }

    private RsResourceList getResourceListModelById(Integer resourceListId) {
        if (null == resourceListId) {
            return null;
        }
        try {
            return this.rsResourceListMapper.selectByPrimaryKey(resourceListId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceListServiceImpl.getResourceListModelById", (Throwable)e);
            return null;
        }
    }

    public RsResourceList getResourceListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsResourceListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceListServiceImpl.getResourceListModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delResourceListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceListServiceImpl.delResourceListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsResourceListServiceImpl.delResourceListModelByCode.num");
        }
    }

    private void deleteResourceListModel(Integer resourceListId) throws ApiException {
        if (null == resourceListId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceListMapper.deleteByPrimaryKey(resourceListId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceListServiceImpl.deleteResourceListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsResourceListServiceImpl.deleteResourceListModel.num");
        }
    }

    private void updateResourceListModel(RsResourceList rsResourceList) throws ApiException {
        if (null == rsResourceList) {
            return;
        }
        int i = 0;
        try {
            i = this.rsResourceListMapper.updateByPrimaryKeySelective(rsResourceList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceListServiceImpl.updateResourceListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsResourceListServiceImpl.updateResourceListModel.num");
        }
    }

    private void updateStateResourceListModel(Integer resourceListId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == resourceListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceListId", resourceListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsResourceListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceListServiceImpl.updateStateResourceListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsResourceListServiceImpl.updateStateResourceListModel.null");
        }
    }

    private void updateStateResourceListModelByCode(String tenantCode, String resourceListCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)resourceListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("resourceListCode", resourceListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsResourceListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceListServiceImpl.updateStateResourceListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsResourceListServiceImpl.updateStateResourceListModelByCode.null");
        }
    }

    private RsResourceList makeResourceList(RsResourceListDomain rsResourceListDomain, RsResourceList rsResourceList) {
        if (null == rsResourceListDomain) {
            return null;
        }
        if (null == rsResourceList) {
            rsResourceList = new RsResourceList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsResourceList, (Object)rsResourceListDomain);
            return rsResourceList;
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceListServiceImpl.makeResourceList", (Throwable)e);
            return null;
        }
    }

    private RsResourceListReDomain makeRsResourceListReDomain(RsResourceList rsResourceList) {
        if (null == rsResourceList) {
            return null;
        }
        RsResourceListReDomain rsResourceListReDomain = new RsResourceListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsResourceListReDomain, (Object)rsResourceList);
            return rsResourceListReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceListServiceImpl.makeRsResourceListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsResourceList> queryResourceListModelPage(Map<String, Object> parammap) {
        try {
            return this.rsResourceListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceListServiceImpl.queryResourceListModel", (Throwable)e);
            return null;
        }
    }

    private int countResourceList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceListServiceImpl.countResourceList", (Throwable)e);
        }
        return i;
    }

    private RsResourceList createRsResourceList(RsResourceListDomain rsResourceListDomain) {
        String msg = this.checkResourceList(rsResourceListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsResourceListServiceImpl.saveResourceList.checkResourceList", msg);
        }
        RsResourceList rsResourceList = this.makeResourceList(rsResourceListDomain, null);
        this.setResourceListDefault(rsResourceList);
        return rsResourceList;
    }

    @Override
    public String saveResourceList(RsResourceListDomain rsResourceListDomain) throws ApiException {
        RsResourceList rsResourceList = this.createRsResourceList(rsResourceListDomain);
        this.saveResourceListModel(rsResourceList);
        return rsResourceList.getResourceListCode();
    }

    @Override
    public String saveResourceListBatch(List<RsResourceListDomain> rsResourceListDomainList) throws ApiException {
        if (null == rsResourceListDomainList || rsResourceListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsResourceList> rsResourceListList = new ArrayList<RsResourceList>();
        String code = "";
        for (RsResourceListDomain rsResourceListDomain : rsResourceListDomainList) {
            RsResourceList rsResourceList = this.createRsResourceList(rsResourceListDomain);
            code = rsResourceList.getResourceListCode();
            rsResourceListList.add(rsResourceList);
        }
        this.saveResourceListBatchModel(rsResourceListList);
        return code;
    }

    @Override
    public void updateResourceListState(Integer resourceListId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateResourceListModel(resourceListId, dataState, oldDataState);
    }

    @Override
    public void updateResourceListStateByCode(String tenantCode, String resourceListCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateResourceListModelByCode(tenantCode, resourceListCode, dataState, oldDataState);
    }

    @Override
    public void updateResourceList(RsResourceListDomain rsResourceListDomain) throws ApiException {
        String msg = this.checkResourceList(rsResourceListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsResourceListServiceImpl.updateResourceList.checkResourceList", msg);
        }
        RsResourceList oldRsResourceList = this.getResourceListModelById(rsResourceListDomain.getResourceListId());
        if (null == oldRsResourceList) {
            throw new ApiException("rs.RsResourceListServiceImpl.updateResourceList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsResourceList rsResourceList = this.makeResourceList(rsResourceListDomain, oldRsResourceList);
        this.setResourceListUpdataDefault(rsResourceList);
        this.updateResourceListModel(rsResourceList);
    }

    @Override
    public RsResourceList getResourceList(Integer resourceListId) {
        return this.getResourceListModelById(resourceListId);
    }

    @Override
    public void deleteResourceList(Integer resourceListId) throws ApiException {
        this.deleteResourceListModel(resourceListId);
    }

    @Override
    public QueryResult<RsResourceList> queryResourceListPage(Map<String, Object> map) {
        List<RsResourceList> rsResourceListList = this.queryResourceListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countResourceList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceListList);
        return queryResult;
    }

    @Override
    public RsResourceList getResourceListByCode(String tenantCode, String resourceListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("resourceListCode", resourceListCode);
        return this.getResourceListModelByCode(map);
    }

    @Override
    public void delResourceListByCode(String tenantCode, String resourceListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("resourceListCode", resourceListCode);
        this.delResourceListModelByCode(map);
    }
}

