/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsPropertiesMapper;
import com.yqbsoft.laser.service.resources.dao.RsPropertiesOptionMapper;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesDomain;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesOptionDomain;
import com.yqbsoft.laser.service.resources.enums.ChannelCodeEnum;
import com.yqbsoft.laser.service.resources.model.RsProperties;
import com.yqbsoft.laser.service.resources.model.RsPropertiesOption;
import com.yqbsoft.laser.service.resources.service.RsPropertiesService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsPropertiesServiceImpl
extends BaseServiceImpl
implements RsPropertiesService {
    public static final String SYS_CODE = "rs.RsPropertiesServiceImpl";
    private RsPropertiesMapper rsPropertiesMapper;
    private RsPropertiesOptionMapper rsPropertiesOptionMapper;

    public void setRsPropertiesMapper(RsPropertiesMapper rsPropertiesMapper) {
        this.rsPropertiesMapper = rsPropertiesMapper;
    }

    public void setRsPropertiesOptionMapper(RsPropertiesOptionMapper rsPropertiesOptionMapper) {
        this.rsPropertiesOptionMapper = rsPropertiesOptionMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsPropertiesMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProperties(RsPropertiesDomain rsPropertiesDomain) {
        if (null == rsPropertiesDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsPropertiesDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsPropertiesDomain.getPntreeCode())) {
            msg = msg + "\u5206\u7c7b\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsPropertiesDomain.getPropertiesName())) {
            msg = msg + "\u5c5e\u6027\u540d\u79f0\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPropertiesDefault(RsProperties rsProperties) {
        if (null == rsProperties) {
            return;
        }
        if (null == rsProperties.getDataState()) {
            rsProperties.setDataState(0);
        }
        if (null == rsProperties.getGmtCreate()) {
            rsProperties.setGmtCreate(this.getSysDate());
        }
        rsProperties.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsProperties.getPropertiesCode())) {
            rsProperties.setPropertiesCode(this.createUUIDString());
        }
    }

    private int getPropertiesMaxCode() {
        int code = 0;
        try {
            return this.rsPropertiesMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.getPropertiesMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPropertiesUpdataDefault(RsProperties rsProperties) {
        if (null == rsProperties) {
            return;
        }
        rsProperties.setGmtModified(this.getSysDate());
    }

    private void savePropertiesModel(RsProperties rsProperties) throws ApiException {
        if (null == rsProperties) {
            return;
        }
        try {
            this.rsPropertiesMapper.insert(rsProperties);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.savePropertiesModel.ex", (Throwable)e);
        }
    }

    private RsProperties getPropertiesModelById(Integer propertiesId) {
        if (null == propertiesId) {
            return null;
        }
        try {
            return this.rsPropertiesMapper.selectByPrimaryKey(propertiesId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.getPropertiesModelById", (Throwable)e);
            return null;
        }
    }

    public RsProperties getPropertiesModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsPropertiesMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.getPropertiesModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPropertiesModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPropertiesMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.delPropertiesModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPropertiesServiceImpl.delPropertiesModelByCode.num");
        }
    }

    private void deletePropertiesModel(Integer propertiesId) throws ApiException {
        if (null == propertiesId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPropertiesMapper.deleteByPrimaryKey(propertiesId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.deletePropertiesModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPropertiesServiceImpl.deletePropertiesModel.num");
        }
    }

    private void updatePropertiesModel(RsProperties rsProperties) throws ApiException {
        if (null == rsProperties) {
            return;
        }
        try {
            this.rsPropertiesMapper.updateByPrimaryKeySelective(rsProperties);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updatePropertiesModel.ex", (Throwable)e);
        }
    }

    private void updateStatePropertiesModel(Integer propertiesId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == propertiesId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propertiesId", propertiesId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsPropertiesMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updateStatePropertiesModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updateStatePropertiesModel.null");
        }
    }

    private RsProperties makeProperties(RsPropertiesDomain rsPropertiesDomain, RsProperties rsProperties) {
        if (null == rsPropertiesDomain) {
            return null;
        }
        if (null == rsProperties) {
            rsProperties = new RsProperties();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsProperties, (Object)rsPropertiesDomain);
            return rsProperties;
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.makeProperties", (Throwable)e);
            return null;
        }
    }

    private List<RsProperties> queryPropertiesModelPage(Map<String, Object> parammap) {
        try {
            return this.rsPropertiesMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.queryPropertiesModel", (Throwable)e);
            return null;
        }
    }

    private int countProperties(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsPropertiesMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.countProperties", (Throwable)e);
        }
        return i;
    }

    private String checkPropertiesOption(RsPropertiesOptionDomain rsPropertiesOptionDomain) {
        if (null == rsPropertiesOptionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsPropertiesOptionDomain.getPropertiesOptionName())) {
            msg = msg + "\u9009\u9879\u540d\u79f0\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsPropertiesOptionDomain.getPropertiesCode())) {
            msg = msg + "\u5c5e\u6027\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPropertiesOptionDefault(RsPropertiesOption rsPropertiesOption) {
        if (null == rsPropertiesOption) {
            return;
        }
        if (null == rsPropertiesOption.getDataState()) {
            rsPropertiesOption.setDataState(0);
        }
        if (null == rsPropertiesOption.getGmtCreate()) {
            rsPropertiesOption.setGmtCreate(this.getSysDate());
        }
        rsPropertiesOption.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsPropertiesOption.getPropertiesOptionCode())) {
            rsPropertiesOption.setPropertiesOptionCode(this.createUUIDString());
        }
    }

    private int getPropertiesOptionMaxCode() {
        int code = 0;
        try {
            return this.rsPropertiesOptionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.getPropertiesOptionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPropertiesOptionUpdataDefault(RsPropertiesOption rsPropertiesOption) {
        if (null == rsPropertiesOption) {
            return;
        }
        rsPropertiesOption.setGmtModified(this.getSysDate());
    }

    private void savePropertiesOptionModel(RsPropertiesOption rsPropertiesOption) throws ApiException {
        if (null == rsPropertiesOption) {
            return;
        }
        try {
            this.rsPropertiesOptionMapper.insert(rsPropertiesOption);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.savePropertiesOptionModel.ex", (Throwable)e);
        }
    }

    private RsPropertiesOption getPropertiesOptionModelById(Integer propertiesOptionId) {
        if (null == propertiesOptionId) {
            return null;
        }
        try {
            return this.rsPropertiesOptionMapper.selectByPrimaryKey(propertiesOptionId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.getPropertiesOptionModelById", (Throwable)e);
            return null;
        }
    }

    public RsPropertiesOption getPropertiesOptionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsPropertiesOptionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.getPropertiesOptionModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPropertiesOptionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPropertiesOptionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.delPropertiesOptionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPropertiesServiceImpl.delPropertiesOptionModelByCode.num");
        }
    }

    private void deletePropertiesOptionModel(Integer propertiesOptionId) throws ApiException {
        if (null == propertiesOptionId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPropertiesOptionMapper.deleteByPrimaryKey(propertiesOptionId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.deletePropertiesOptionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPropertiesServiceImpl.deletePropertiesOptionModel.num");
        }
    }

    private void updatePropertiesOptionModel(RsPropertiesOption rsPropertiesOption) throws ApiException {
        if (null == rsPropertiesOption) {
            return;
        }
        try {
            this.rsPropertiesOptionMapper.updateByPrimaryKeySelective(rsPropertiesOption);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updatePropertiesOptionModel.ex", (Throwable)e);
        }
    }

    private void updateStatePropertiesOptionModel(Integer propertiesOptionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == propertiesOptionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propertiesOptionId", propertiesOptionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsPropertiesOptionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updateStatePropertiesOptionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updateStatePropertiesOptionModel.null");
        }
    }

    private RsPropertiesOption makePropertiesOption(RsPropertiesOptionDomain rsPropertiesOptionDomain, RsPropertiesOption rsPropertiesOption) {
        if (null == rsPropertiesOptionDomain) {
            return null;
        }
        if (null == rsPropertiesOption) {
            rsPropertiesOption = new RsPropertiesOption();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsPropertiesOption, (Object)rsPropertiesOptionDomain);
            return rsPropertiesOption;
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.makePropertiesOption", (Throwable)e);
            return null;
        }
    }

    private List<RsPropertiesOption> queryPropertiesOptionModelPage(Map<String, Object> parammap) {
        try {
            return this.rsPropertiesOptionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.queryPropertiesOptionModel", (Throwable)e);
            return null;
        }
    }

    private int countPropertiesOption(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsPropertiesOptionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.countPropertiesOption", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveProperties(RsPropertiesDomain rsPropertiesDomain) throws ApiException {
        String msg = this.checkProperties(rsPropertiesDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPropertiesServiceImpl.saveProperties.checkProperties", msg);
        }
        RsProperties rsProperties = this.makeProperties(rsPropertiesDomain, null);
        this.setPropertiesDefault(rsProperties);
        this.savePropertiesModel(rsProperties);
    }

    @Override
    public void updatePropertiesState(Integer propertiesId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePropertiesModel(propertiesId, dataState, oldDataState);
    }

    @Override
    public void updateProperties(RsPropertiesDomain rsPropertiesDomain) throws ApiException {
        String msg = this.checkProperties(rsPropertiesDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updateProperties.checkProperties", msg);
        }
        RsProperties oldRsProperties = this.getPropertiesModelById(rsPropertiesDomain.getPropertiesId());
        if (null == oldRsProperties) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updateProperties.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsProperties rsProperties = this.makeProperties(rsPropertiesDomain, oldRsProperties);
        this.setPropertiesUpdataDefault(rsProperties);
        this.updatePropertiesModel(rsProperties);
    }

    @Override
    public RsProperties getProperties(Integer propertiesId) {
        return this.getPropertiesModelById(propertiesId);
    }

    @Override
    public void deleteProperties(Integer propertiesId) throws ApiException {
        this.deletePropertiesModel(propertiesId);
    }

    @Override
    public QueryResult<RsProperties> queryPropertiesPage(Map<String, Object> map) {
        List<RsProperties> rsPropertiesList = this.queryPropertiesModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProperties(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsPropertiesList);
        return queryResult;
    }

    @Override
    public RsProperties getPropertiesByCode(Map<String, Object> map) {
        return this.getPropertiesModelByCode(map);
    }

    @Override
    public void delPropertiesByCode(Map<String, Object> map) throws ApiException {
        this.delPropertiesModelByCode(map);
    }

    @Override
    public void savePropertiesOption(RsPropertiesOptionDomain rsPropertiesOptionDomain) throws ApiException {
        String msg = this.checkPropertiesOption(rsPropertiesOptionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPropertiesServiceImpl.savePropertiesOption.checkPropertiesOption", msg);
        }
        RsPropertiesOption rsPropertiesOption = this.makePropertiesOption(rsPropertiesOptionDomain, null);
        this.setPropertiesOptionDefault(rsPropertiesOption);
        this.savePropertiesOptionModel(rsPropertiesOption);
    }

    @Override
    public void updatePropertiesOptionState(Integer propertiesOptionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePropertiesOptionModel(propertiesOptionId, dataState, oldDataState);
    }

    @Override
    public void updatePropertiesOption(RsPropertiesOptionDomain rsPropertiesOptionDomain) throws ApiException {
        String msg = this.checkPropertiesOption(rsPropertiesOptionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updatePropertiesOption.checkPropertiesOption", msg);
        }
        RsPropertiesOption oldRsPropertiesOption = this.getPropertiesOptionModelById(rsPropertiesOptionDomain.getPropertiesOptionId());
        if (null == oldRsPropertiesOption) {
            throw new ApiException("rs.RsPropertiesServiceImpl.updatePropertiesOption.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsPropertiesOption rsPropertiesOption = this.makePropertiesOption(rsPropertiesOptionDomain, oldRsPropertiesOption);
        this.setPropertiesOptionUpdataDefault(rsPropertiesOption);
        this.updatePropertiesOptionModel(rsPropertiesOption);
    }

    @Override
    public RsPropertiesOption getPropertiesOption(Integer propertiesOptionId) {
        return this.getPropertiesOptionModelById(propertiesOptionId);
    }

    @Override
    public void deletePropertiesOption(Integer propertiesOptionId) throws ApiException {
        this.deletePropertiesOptionModel(propertiesOptionId);
    }

    @Override
    public QueryResult<RsPropertiesOption> queryPropertiesOptionPage(Map<String, Object> map) {
        List<RsPropertiesOption> rsPropertiesOptionList = this.queryPropertiesOptionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPropertiesOption(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsPropertiesOptionList);
        return queryResult;
    }

    @Override
    public RsPropertiesOption getPropertiesOptionByCode(Map<String, Object> map) {
        return this.getPropertiesOptionModelByCode(map);
    }

    @Override
    public void delPropertiesOptionByCode(Map<String, Object> map) throws ApiException {
        this.delPropertiesOptionModelByCode(map);
    }

    @Override
    public List<RsPropertiesDomain> queryPropertiesByPntree(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsPropertiesMapper.selectByPntree(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.queryPropertiesByPntree", (Throwable)e);
            return null;
        }
    }

    @Override
    public void savePropertiesInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "00000000");
        this.propertiesInit(map, tenantCode);
        this.propertiesOptionInit(map, tenantCode);
    }

    @Override
    public void savePropertiesByChannelInit(Map<String, Object> param) throws ApiException {
        this.logger.info("rs.RsPropertiesServiceImpl.savePropertiesByChannelInit param\uff1a", param);
        String tenantCode = String.valueOf(param.get("tenantCode"));
        String channelCode = String.valueOf(param.get("channelCode"));
        String goodClass = String.valueOf(param.get("goodClass"));
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        if (StringUtils.isBlank((String)channelCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "00000000");
        map.put("channelCode", ChannelCodeEnum.getChannelCode(goodClass));
        this.propertiesByChannelInit(map, param);
    }

    private void propertiesInit(Map<String, Object> map, String tenantCode) {
        QueryResult<RsProperties> rsPropertiesQueryResult = this.queryPropertiesPage(map);
        if (null == rsPropertiesQueryResult) {
            return;
        }
        List rsPropertiesList = rsPropertiesQueryResult.getList();
        if (ListUtil.isEmpty((Collection)rsPropertiesList)) {
            return;
        }
        for (RsProperties rsProperties : rsPropertiesList) {
            RsProperties propertiesByCode = this.getPropertiesByCode(this.getQueryMapParam("propertiesCode,tenantCode", new Object[]{rsProperties.getPropertiesCode(), tenantCode}));
            if (null != propertiesByCode) continue;
            RsPropertiesDomain rsPropertiesDomain = this.makeRsPropertiesDomain(rsProperties);
            rsPropertiesDomain.setPropertiesId(null);
            rsPropertiesDomain.setTenantCode(tenantCode);
            this.saveProperties(rsPropertiesDomain);
        }
    }

    private void propertiesOptionInit(Map<String, Object> map, String tenantCode) {
        QueryResult<RsPropertiesOption> rsPropertiesOptionQueryResult = this.queryPropertiesOptionPage(map);
        if (null == rsPropertiesOptionQueryResult) {
            return;
        }
        List rsPropertiesOptionList = rsPropertiesOptionQueryResult.getList();
        if (ListUtil.isEmpty((Collection)rsPropertiesOptionList)) {
            return;
        }
        for (RsPropertiesOption rsPropertiesOption : rsPropertiesOptionList) {
            RsPropertiesOption propertiesOptionByCode = this.getPropertiesOptionByCode(this.getQueryMapParam("propertiesOptionCode,tenantCode", new Object[]{rsPropertiesOption.getPropertiesOptionCode(), tenantCode}));
            if (null != propertiesOptionByCode) continue;
            RsPropertiesOptionDomain rsPropertiesOptionDomain = this.makeRsPropertiesOptionDomain(rsPropertiesOption);
            rsPropertiesOptionDomain.setPropertiesOptionId(null);
            rsPropertiesOptionDomain.setTenantCode(tenantCode);
            this.savePropertiesOption(rsPropertiesOptionDomain);
        }
    }

    private void propertiesByChannelInit(Map<String, Object> map, Map<String, Object> param) {
        String tenantCode = String.valueOf(param.get("tenantCode"));
        String channelCode = String.valueOf(param.get("channelCode"));
        String channelName = String.valueOf(param.get("channelName"));
        QueryResult<RsProperties> rsPropertiesQueryResult = this.queryPropertiesPage(map);
        if (null == rsPropertiesQueryResult) {
            return;
        }
        List rsPropertiesList = rsPropertiesQueryResult.getList();
        if (ListUtil.isEmpty((Collection)rsPropertiesList)) {
            return;
        }
        for (RsProperties rsProperties : rsPropertiesList) {
            RsProperties propertiesByCode = this.getPropertiesByCode(this.getQueryMapParam("propertiesCode,tenantCode,channelCode", new Object[]{rsProperties.getPropertiesCode(), tenantCode, channelCode}));
            if (null != propertiesByCode) continue;
            String propertiesCode = this.createUUIDString();
            RsPropertiesDomain rsPropertiesDomain = this.makeRsPropertiesDomain(rsProperties);
            rsPropertiesDomain.setPropertiesId(null);
            rsPropertiesDomain.setTenantCode(tenantCode);
            rsPropertiesDomain.setPropertiesCode(propertiesCode);
            rsPropertiesDomain.setChannelCode(channelCode);
            rsPropertiesDomain.setChannelName(channelName);
            this.saveProperties(rsPropertiesDomain);
            param.put("propertiesCode", propertiesCode);
            map.put("propertiesCode", rsProperties.getPropertiesCode());
            this.propertiesOptionByChannelInit(map, param);
        }
    }

    private void propertiesOptionByChannelInit(Map<String, Object> map, Map<String, Object> param) {
        String tenantCode = String.valueOf(param.get("tenantCode"));
        QueryResult<RsPropertiesOption> rsPropertiesOptionQueryResult = this.queryPropertiesOptionPage(map);
        if (null == rsPropertiesOptionQueryResult) {
            return;
        }
        List rsPropertiesOptionList = rsPropertiesOptionQueryResult.getList();
        if (ListUtil.isEmpty((Collection)rsPropertiesOptionList)) {
            return;
        }
        for (RsPropertiesOption rsPropertiesOption : rsPropertiesOptionList) {
            RsPropertiesOption propertiesOptionByCode = this.getPropertiesOptionByCode(this.getQueryMapParam("propertiesOptionCode,tenantCode,propertiesCode", new Object[]{rsPropertiesOption.getPropertiesOptionCode(), tenantCode, param.get("propertiesCode").toString()}));
            if (null != propertiesOptionByCode) continue;
            RsPropertiesOptionDomain rsPropertiesOptionDomain = this.makeRsPropertiesOptionDomain(rsPropertiesOption);
            rsPropertiesOptionDomain.setPropertiesOptionId(null);
            rsPropertiesOptionDomain.setPropertiesOptionCode(this.createUUIDString());
            rsPropertiesOptionDomain.setPropertiesCode(param.get("propertiesCode").toString());
            rsPropertiesOptionDomain.setTenantCode(tenantCode);
            this.savePropertiesOption(rsPropertiesOptionDomain);
        }
    }

    private RsPropertiesDomain makeRsPropertiesDomain(RsProperties rsProperties) {
        if (null == rsProperties) {
            return null;
        }
        RsPropertiesDomain rsPropertiesDomain = new RsPropertiesDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsPropertiesDomain, (Object)rsProperties);
            return rsPropertiesDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.makeRsPropertiesDomain", (Throwable)e);
            return null;
        }
    }

    private RsPropertiesOptionDomain makeRsPropertiesOptionDomain(RsPropertiesOption rsPropertiesOption) {
        if (null == rsPropertiesOption) {
            return null;
        }
        RsPropertiesOptionDomain rsPropertiesOptionDomain = new RsPropertiesOptionDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsPropertiesOptionDomain, (Object)rsPropertiesOption);
            return rsPropertiesOptionDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsPropertiesServiceImpl.makeRsPropertiesOptionDomain", (Throwable)e);
            return null;
        }
    }
}

