/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsFlowdataMapper;
import com.yqbsoft.laser.service.resources.dao.RsResourceGoodsMapper;
import com.yqbsoft.laser.service.resources.dao.RsSkuMapper;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.EditSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsBuyDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsPriceDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsShopDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsWhDomain;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddataDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.domain.SendData;
import com.yqbsoft.laser.service.resources.model.RsFlowdata;
import com.yqbsoft.laser.service.resources.model.RsGoodsFile;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsPntree;
import com.yqbsoft.laser.service.resources.model.RsProperties;
import com.yqbsoft.laser.service.resources.model.RsPropertiesValue;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.model.RsSenddataLog;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSpec;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.send.OpEsEnginePollThread;
import com.yqbsoft.laser.service.resources.send.OpEsEnginePutThread;
import com.yqbsoft.laser.service.resources.send.OpEsEngineService;
import com.yqbsoft.laser.service.resources.send.OpSendPollThread;
import com.yqbsoft.laser.service.resources.send.OpSendPutThread;
import com.yqbsoft.laser.service.resources.send.OpSendService;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsGoodsBuyService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassconfService;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsGoodsPriceService;
import com.yqbsoft.laser.service.resources.service.RsGoodsSendService;
import com.yqbsoft.laser.service.resources.service.RsGoodsShopService;
import com.yqbsoft.laser.service.resources.service.RsGoodsWhService;
import com.yqbsoft.laser.service.resources.service.RsPntreeService;
import com.yqbsoft.laser.service.resources.service.RsPropertiesService;
import com.yqbsoft.laser.service.resources.service.RsPropertiesValueService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsNewService;
import com.yqbsoft.laser.service.resources.service.RsResourceListService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.resources.service.RsSkuNewService;
import com.yqbsoft.laser.service.resources.service.RsSkuOneService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.resources.service.RsSpuService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.FileType;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsResourceGoodsNewServiceImpl
extends BaseServiceImpl
implements RsResourceGoodsNewService {
    public static final String SYS_CODE = "rs.RsResourceGoodsNewServiceImpl";
    private RsResourceGoodsMapper rsResourceGoodsMapper;
    private RsSkuMapper rsSkuMapper;
    private RsResourceListService rsResourceListService;
    private RsSpuService rsSpuService;
    private RsPntreeService rsPntreeService;
    private RsSkuService rsSkuService;
    private RsPropertiesService rsPropertiesService;
    private RsSpecValueService rsSpecValueService;
    private RsPropertiesValueService rsPropertiesValueService;
    private RsGoodsOtherService rsGoodsOtherService;
    private RsSenddataBaseService rsSenddataBaseService;
    private RsGoodsShopService rsGoodsShopService;
    private RsGoodsBuyService rsGoodsBuyService;
    private RsGoodsPriceService rsGoodsPriceService;
    private RsSkuOneService rsSkuOneService;
    private RsClasstreeService rsClasstreeService;
    private RsSpecService rsSpecService;
    private RsGoodsClassconfService rsGoodsClassconfService;
    private RsGoodsClassService rsGoodsClassService;
    private RsGoodsWhService rsGoodsWhService;
    private RsSkuNewService rsSkuNewService;
    private RsFlowdataMapper rsFlowdataMapper;
    private static OpSendService opSendService;
    private static Object oplock;
    private static OpEsEngineService opEsEngineService;

    public RsFlowdataMapper getRsFlowdataMapper() {
        return this.rsFlowdataMapper;
    }

    public void setRsFlowdataMapper(RsFlowdataMapper rsFlowdataMapper) {
        this.rsFlowdataMapper = rsFlowdataMapper;
    }

    public RsSkuNewService getRsSkuNewService() {
        return this.rsSkuNewService;
    }

    public void setRsSkuNewService(RsSkuNewService rsSkuNewService) {
        this.rsSkuNewService = rsSkuNewService;
    }

    public RsSkuMapper getRsSkuMapper() {
        return this.rsSkuMapper;
    }

    public void setRsSkuMapper(RsSkuMapper rsSkuMapper) {
        this.rsSkuMapper = rsSkuMapper;
    }

    public RsResourceGoodsMapper getRsResourceGoodsMapper() {
        return this.rsResourceGoodsMapper;
    }

    public void setRsResourceGoodsMapper(RsResourceGoodsMapper rsResourceGoodsMapper) {
        this.rsResourceGoodsMapper = rsResourceGoodsMapper;
    }

    public RsResourceListService getRsResourceListService() {
        return this.rsResourceListService;
    }

    public void setRsResourceListService(RsResourceListService rsResourceListService) {
        this.rsResourceListService = rsResourceListService;
    }

    public RsSpuService getRsSpuService() {
        return this.rsSpuService;
    }

    public void setRsSpuService(RsSpuService rsSpuService) {
        this.rsSpuService = rsSpuService;
    }

    public RsPntreeService getRsPntreeService() {
        return this.rsPntreeService;
    }

    public void setRsPntreeService(RsPntreeService rsPntreeService) {
        this.rsPntreeService = rsPntreeService;
    }

    public RsSkuService getRsSkuService() {
        return this.rsSkuService;
    }

    public void setRsSkuService(RsSkuService rsSkuService) {
        this.rsSkuService = rsSkuService;
    }

    public RsPropertiesService getRsPropertiesService() {
        return this.rsPropertiesService;
    }

    public void setRsPropertiesService(RsPropertiesService rsPropertiesService) {
        this.rsPropertiesService = rsPropertiesService;
    }

    public RsSpecValueService getRsSpecValueService() {
        return this.rsSpecValueService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public RsPropertiesValueService getRsPropertiesValueService() {
        return this.rsPropertiesValueService;
    }

    public void setRsPropertiesValueService(RsPropertiesValueService rsPropertiesValueService) {
        this.rsPropertiesValueService = rsPropertiesValueService;
    }

    public RsGoodsOtherService getRsGoodsOtherService() {
        return this.rsGoodsOtherService;
    }

    public void setRsGoodsOtherService(RsGoodsOtherService rsGoodsOtherService) {
        this.rsGoodsOtherService = rsGoodsOtherService;
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        return this.rsSenddataBaseService;
    }

    public void setRsSenddataBaseService(RsSenddataBaseService rsSenddataBaseService) {
        this.rsSenddataBaseService = rsSenddataBaseService;
    }

    public RsGoodsShopService getRsGoodsShopService() {
        return this.rsGoodsShopService;
    }

    public void setRsGoodsShopService(RsGoodsShopService rsGoodsShopService) {
        this.rsGoodsShopService = rsGoodsShopService;
    }

    public RsGoodsBuyService getRsGoodsBuyService() {
        return this.rsGoodsBuyService;
    }

    public void setRsGoodsBuyService(RsGoodsBuyService rsGoodsBuyService) {
        this.rsGoodsBuyService = rsGoodsBuyService;
    }

    public RsGoodsPriceService getRsGoodsPriceService() {
        return this.rsGoodsPriceService;
    }

    public void setRsGoodsPriceService(RsGoodsPriceService rsGoodsPriceService) {
        this.rsGoodsPriceService = rsGoodsPriceService;
    }

    public RsSkuOneService getRsSkuOneService() {
        return this.rsSkuOneService;
    }

    public void setRsSkuOneService(RsSkuOneService rsSkuOneService) {
        this.rsSkuOneService = rsSkuOneService;
    }

    public RsClasstreeService getRsClasstreeService() {
        return this.rsClasstreeService;
    }

    public void setRsClasstreeService(RsClasstreeService rsClasstreeService) {
        this.rsClasstreeService = rsClasstreeService;
    }

    public RsSpecService getRsSpecService() {
        return this.rsSpecService;
    }

    public void setRsSpecService(RsSpecService rsSpecService) {
        this.rsSpecService = rsSpecService;
    }

    public RsGoodsClassconfService getRsGoodsClassconfService() {
        return this.rsGoodsClassconfService;
    }

    public void setRsGoodsClassconfService(RsGoodsClassconfService rsGoodsClassconfService) {
        this.rsGoodsClassconfService = rsGoodsClassconfService;
    }

    public RsGoodsClassService getRsGoodsClassService() {
        return this.rsGoodsClassService;
    }

    public void setRsGoodsClassService(RsGoodsClassService rsGoodsClassService) {
        this.rsGoodsClassService = rsGoodsClassService;
    }

    public RsGoodsWhService getRsGoodsWhService() {
        return this.rsGoodsWhService;
    }

    public void setRsGoodsWhService(RsGoodsWhService rsGoodsWhService) {
        this.rsGoodsWhService = rsGoodsWhService;
    }

    private RsResourceGoods makeResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain, RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoodsDomain) {
            return null;
        }
        if (null == rsResourceGoods) {
            rsResourceGoods = new RsResourceGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsResourceGoods, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.makeResourceGoods", (Throwable)e);
            return null;
        }
        return rsResourceGoods;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void setResourceGoodsDefault(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        if (null == rsResourceGoods.getDataState()) {
            rsResourceGoods.setDataState(0);
        }
        if (null == rsResourceGoods.getDataOpnextbillstate()) {
            rsResourceGoods.setDataOpnextbillstate(0);
        }
        Date date = this.getSysDate();
        if (null == rsResourceGoods.getGmtCreate()) {
            rsResourceGoods.setGmtCreate(date);
        }
        rsResourceGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)rsResourceGoods.getGoodsCode())) {
            rsResourceGoods.setGoodsCode(this.getNo(null, RsResourceGoods.class.getSimpleName(), "goodsCode", rsResourceGoods.getTenantCode()));
        }
        if (StringUtils.isBlank((String)rsResourceGoods.getGoodsShowname())) {
            rsResourceGoods.setGoodsShowname(rsResourceGoods.getGoodsName());
        }
        if (StringUtils.isBlank((String)rsResourceGoods.getGoodsShowno())) {
            rsResourceGoods.setGoodsShowno(rsResourceGoods.getGoodsNo());
        }
        if (null == rsResourceGoods.getPricesetChannenprice()) {
            rsResourceGoods.setPricesetChannenprice(rsResourceGoods.getPricesetNprice1());
        }
        if (StringUtils.isBlank((String)rsResourceGoods.getGoodsOldcode())) {
            rsResourceGoods.setGoodsOldcode("-1");
        }
        if (null == rsResourceGoods.getChannelCode()) {
            rsResourceGoods.setChannelCode("");
        }
        if (null == rsResourceGoods.getGoodsType()) {
            rsResourceGoods.setGoodsType("");
        }
        if (null == rsResourceGoods.getGoodsPro()) {
            rsResourceGoods.setGoodsPro("");
        }
        if (StringUtils.isNotBlank((String)rsResourceGoods.getPntreeCode()) && StringUtils.isBlank((String)rsResourceGoods.getPntreeName())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("pntreeCode", rsResourceGoods.getPntreeCode());
            map.put("tenantCode", rsResourceGoods.getTenantCode());
            RsPntree rsPntree = this.rsPntreeService.getPntreeByCode(map);
            if (null == rsPntree) {
                throw new ApiException("rs.RsResourceGoodsNewServiceImpl.saveResourceGoods.getPntreeByCode", "\u7c7b\u578b\u4fe1\u606f\u4e3a\u7a7a" + map);
            }
            rsResourceGoods.setPntreeName(rsPntree.getPntreeName());
        }
    }

    private void saveResourceGoodsModel(RsResourceGoods rsResourceGoods) throws ApiException {
        if (null == rsResourceGoods) {
            return;
        }
        try {
            this.rsResourceGoodsMapper.insert(rsResourceGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.saveResourceGoodsModel.ex", (Throwable)e);
        }
    }

    private void savePropertiesList(List<RsPropertiesValueDomain> valueList, String spuCode, String goodsCode, String tenantCode) {
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        for (RsPropertiesValueDomain rsPropertiesValueDomain : valueList) {
            rsPropertiesValueDomain.setPropertiesValueId(null);
            rsPropertiesValueDomain.setSpuCode(spuCode);
            rsPropertiesValueDomain.setGoodsCode(goodsCode);
            rsPropertiesValueDomain.setTenantCode(tenantCode);
        }
        this.rsPropertiesValueService.savePropertiesValueList(valueList);
    }

    private void makeSKu(RsResourceGoods rsResourceGoods, RsSkuDomain sku) {
        if (null == rsResourceGoods || null == sku) {
            return;
        }
        sku.setSkuId(null);
        sku.setSkuCode(null);
        sku.setGoodsNo(rsResourceGoods.getGoodsNo());
        sku.setGoodsPro(rsResourceGoods.getGoodsPro());
        if (StringUtils.isBlank((String)sku.getGoodsName())) {
            sku.setGoodsName(rsResourceGoods.getGoodsName());
        }
        sku.setGoodsShowname(rsResourceGoods.getGoodsShowname());
        sku.setPntreeCode(rsResourceGoods.getPntreeCode());
        sku.setPntreeName(rsResourceGoods.getPntreeName());
        sku.setBrandCode(rsResourceGoods.getBrandCode());
        sku.setBrandName(rsResourceGoods.getBrandName());
        sku.setGoodsCode(rsResourceGoods.getGoodsCode());
        sku.setGoodsOldcode(rsResourceGoods.getGoodsOldcode());
        sku.setGoodsOrigin(rsResourceGoods.getGoodsOrigin());
        sku.setGoodsType(rsResourceGoods.getGoodsType());
        sku.setAppmanageIcode(rsResourceGoods.getAppmanageIcode());
        sku.setTenantCode(rsResourceGoods.getTenantCode());
        sku.setSpuCode(rsResourceGoods.getSpuCode());
        sku.setFreightTemCode(rsResourceGoods.getFreightTemCode());
        sku.setGoodsShowno(rsResourceGoods.getGoodsShowno());
        sku.setMemberCcode(rsResourceGoods.getMemberCcode());
        sku.setMemberCname(rsResourceGoods.getMemberCname());
        sku.setMemberCode(rsResourceGoods.getMemberCode());
        sku.setMemberName(rsResourceGoods.getMemberName());
        sku.setChannelCode(rsResourceGoods.getChannelCode());
        sku.setChannelName(rsResourceGoods.getChannelName());
        sku.setMschannelCode(rsResourceGoods.getMschannelCode());
        sku.setMschannelName(rsResourceGoods.getMschannelName());
        sku.setMemberMcode(rsResourceGoods.getMemberMcode());
        sku.setMemberMname(rsResourceGoods.getMemberMname());
        sku.setGoodsClass(rsResourceGoods.getGoodsClass());
        if (StringUtils.isBlank((String)sku.getPartsnameNumunit())) {
            sku.setPartsnameNumunit(rsResourceGoods.getPartsnameNumunit());
        }
        if (StringUtils.isBlank((String)sku.getPartsnameWeightunit())) {
            sku.setPartsnameWeightunit(rsResourceGoods.getPartsnameWeightunit());
        }
        if (null == sku.getGoodsMinnum()) {
            sku.setGoodsMinnum(rsResourceGoods.getGoodsMinnum());
        }
        if (null == sku.getGoodsOneweight()) {
            sku.setGoodsOneweight(rsResourceGoods.getGoodsOneweight());
        }
        sku.setClasstreeShopcode(rsResourceGoods.getClasstreeShopcode());
        sku.setClasstreeShopname(rsResourceGoods.getClasstreeShopname());
        sku.setGoodsEocode(rsResourceGoods.getGoodsEocode());
        sku.setGinfoCode(rsResourceGoods.getGinfoCode());
        sku.setClasstreeCode(rsResourceGoods.getClasstreeCode());
        sku.setClasstreeName(rsResourceGoods.getClasstreeName());
        sku.setGoodsPro(rsResourceGoods.getGoodsPro());
        sku.setSaleChannel(rsResourceGoods.getSaleChannel());
        if (null == sku.getSkuOdate()) {
            sku.setSkuOdate(rsResourceGoods.getGoodsOdate());
        }
    }

    private String checkResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (null == rsResourceGoodsDomain.getPricesetNprice() || rsResourceGoodsDomain.getPricesetNprice().compareTo(BigDecimal.ZERO) < 0) {
            return "\u4ef7\u683c\u4fe1\u606f\u6709\u8bef";
        }
        if (null == rsResourceGoodsDomain.getGoodsNum() || rsResourceGoodsDomain.getGoodsNum().compareTo(BigDecimal.ZERO) < 0) {
            return "\u5e93\u5b58\u4fe1\u606f\u6709\u8bef";
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsPro()) && "5".equals(rsResourceGoodsDomain.getGoodsPro()) && ListUtil.isEmpty(rsResourceGoodsDomain.getRsGoodsRelDomainList())) {
            return "\u7ec4\u5408\u5546\u54c1\u5185\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private void updateFile(RsResourceGoods rsResourceGoods, RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsGoodsFileDomainList())) {
            this.rsGoodsOtherService.delGoodsFileByGoodsCode(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode()}));
        }
        this.makeFile(rsResourceGoods, rsResourceGoodsDomain);
    }

    private void makeFile(RsResourceGoods rsResourceGoods, RsResourceGoodsDomain rsResourceGoodsDomain) {
        List<RsGoodsFileDomain> rsGoodsFileDomainList = rsResourceGoodsDomain.getRsGoodsFileDomainList();
        String dataPic = "";
        String dataPicpath = "";
        if (ListUtil.isNotEmpty(rsGoodsFileDomainList) && null != rsGoodsFileDomainList.get(0)) {
            ArrayList<RsGoodsFileDomain> rsskuGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
            dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
            dataPicpath = rsGoodsFileDomainList.get(0).getGoodsFileName();
            boolean picflag = false;
            if (!FileType.fileTypepic((String)dataPic)) {
                picflag = true;
            }
            for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
                if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
                rsGoodsFileDomain.setGoodsFileId(null);
                rsGoodsFileDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
                rsGoodsFileDomain.setTenantCode(rsResourceGoods.getTenantCode());
                rsGoodsFileDomain.setMemberCode(rsResourceGoods.getMemberCode());
                rsGoodsFileDomain.setMemberName(rsResourceGoods.getMemberName());
                rsskuGoodsFileDomainList.add(rsGoodsFileDomain);
                if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                    dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                    dataPicpath = rsGoodsFileDomain.getGoodsFileName();
                    picflag = false;
                }
                if (rsGoodsFileDomain.getDefaultState() == null || rsGoodsFileDomain.getDefaultState() != 1) continue;
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                dataPicpath = rsGoodsFileDomain.getGoodsFileName();
                break;
            }
            if (ListUtil.isNotEmpty(rsskuGoodsFileDomainList)) {
                this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
            }
        }
        rsResourceGoods.setDataPic(dataPic);
        rsResourceGoods.setDataPicpath(dataPicpath);
    }

    private void makeRsSpecValue(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("specValueBillno", rsResourceGoodsDomain.getGoodsCode());
            map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
            this.rsSpecValueService.deleteSpecValueBySpu(map);
            List<RsSpecValueDomain> rsSpecValueDomainList = rsResourceGoodsDomain.getRsSpecValueDomainList();
            for (RsSpecValueDomain rsSpecValueDomain : rsSpecValueDomainList) {
                rsSpecValueDomain.setSpecValueBillno(rsResourceGoodsDomain.getGoodsCode());
                rsSpecValueDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            }
            this.rsSpecValueService.saveSpecValueList(rsResourceGoodsDomain.getRsSpecValueDomainList());
        }
    }

    private void updatemakeRsPropertiesValue(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsPropertiesValueDomainList())) {
            this.rsPropertiesValueService.deletePropertiesValueByGoods(rsResourceGoodsDomain.getGoodsCode(), rsResourceGoodsDomain.getTenantCode());
            this.makeRsPropertiesValue(rsResourceGoodsDomain);
        }
    }

    private void makeRsPropertiesValue(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsPropertiesValueDomainList())) {
            this.savePropertiesList(rsResourceGoodsDomain.getRsPropertiesValueDomainList(), rsResourceGoodsDomain.getSpuCode(), rsResourceGoodsDomain.getGoodsCode(), rsResourceGoodsDomain.getTenantCode());
        }
    }

    private void makeRsGoodsRel(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null != rsResourceGoodsDomain.getRsGoodsRelDomainList() && rsResourceGoodsDomain.getRsGoodsRelDomainList().size() > 0) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsRelCode(null);
                rsGoodsRelDomain.setGoodsRelId(null);
                rsGoodsRelDomain.setGoodsCode(rsResourceGoodsDomain.getGoodsCode());
                rsGoodsRelDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
                rsGoodsRelDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
                rsGoodsRelDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
                rsGoodsRelDomain.setMemberCcode(rsResourceGoodsDomain.getMemberCcode());
                rsGoodsRelDomain.setMemberCname(rsResourceGoodsDomain.getMemberCname());
                rsGoodsRelDomain.setMemberMcode(rsResourceGoodsDomain.getMemberMcode());
                rsGoodsRelDomain.setMemberMname(rsResourceGoodsDomain.getMemberMname());
                rsGoodsRelDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
                rsGoodsRelDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
                rsGoodsRelDomain.setGoodsClass(rsResourceGoodsDomain.getGoodsClass());
            }
            this.rsGoodsOtherService.saveGoodsRelList(rsResourceGoodsDomain.getRsGoodsRelDomainList());
        }
    }

    private void makeRsGoodsPrice(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsGoodsPriceDomainList())) {
            for (RsGoodsPriceDomain rsGoodsPriceDomain : rsResourceGoodsDomain.getRsGoodsPriceDomainList()) {
                rsGoodsPriceDomain.setGoodsNo(rsResourceGoodsDomain.getGoodsNo());
                rsGoodsPriceDomain.setGoodsCode(rsResourceGoodsDomain.getGoodsCode());
                rsGoodsPriceDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
                rsGoodsPriceDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
                rsGoodsPriceDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
                rsGoodsPriceDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
                rsGoodsPriceDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
            }
            this.rsGoodsPriceService.saveRsGoodsPriceBatch(rsResourceGoodsDomain.getRsGoodsPriceDomainList());
        }
    }

    private void makeRsGoodsBuy(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsGoodsBuyDomainList())) {
            for (RsGoodsBuyDomain rsGoodsBuyDomain : rsResourceGoodsDomain.getRsGoodsBuyDomainList()) {
                rsGoodsBuyDomain.setGoodsNo(rsResourceGoodsDomain.getGoodsNo());
                rsGoodsBuyDomain.setGoodsCode(rsResourceGoodsDomain.getGoodsCode());
                rsGoodsBuyDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
                rsGoodsBuyDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
                rsGoodsBuyDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
                rsGoodsBuyDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
                rsGoodsBuyDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
                rsGoodsBuyDomain.setGoodsClass(rsResourceGoodsDomain.getGoodsClass());
            }
            this.rsGoodsBuyService.saveGoodsBuyBatch(rsResourceGoodsDomain.getRsGoodsBuyDomainList());
        }
    }

    private void makeRsSku(RsResourceGoodsDomain rsResourceGoodsDomain, RsResourceGoods rsResourceGoods) {
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSkuDomainList())) {
            for (RsSkuDomain sku : rsResourceGoodsDomain.getRsSkuDomainList()) {
                this.makeSKu(rsResourceGoods, sku);
            }
            this.rsSkuNewService.saveSkuBatch(rsResourceGoodsDomain.getRsSkuDomainList());
        }
    }

    private void makeRsGoodsShop(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsGoodsShopDomainList())) {
            for (RsGoodsShopDomain rsGoodsShopDomain : rsResourceGoodsDomain.getRsGoodsShopDomainList()) {
                rsGoodsShopDomain.setGoodsNo(rsResourceGoodsDomain.getGoodsNo());
                rsGoodsShopDomain.setGoodsCode(rsResourceGoodsDomain.getGoodsCode());
                rsGoodsShopDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
                rsGoodsShopDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
                rsGoodsShopDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
                rsGoodsShopDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
                rsGoodsShopDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
            }
            this.rsGoodsShopService.saveGoodsShopBatch(rsResourceGoodsDomain.getRsGoodsShopDomainList());
        }
    }

    private void makeRsGoodsWh(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsGoodsWhDomainList())) {
            for (RsGoodsWhDomain rsGoodsWhDomain : rsResourceGoodsDomain.getRsGoodsWhDomainList()) {
                rsGoodsWhDomain.setGoodsNo(rsResourceGoodsDomain.getGoodsNo());
                rsGoodsWhDomain.setGoodsCode(rsResourceGoodsDomain.getGoodsCode());
                rsGoodsWhDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
                rsGoodsWhDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
                rsGoodsWhDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
                rsGoodsWhDomain.setChannelCode(rsResourceGoodsDomain.getChannelCode());
                rsGoodsWhDomain.setChannelName(rsResourceGoodsDomain.getChannelName());
            }
            this.rsGoodsWhService.saveGoodsWhBatch(rsResourceGoodsDomain.getRsGoodsWhDomainList());
        }
    }

    @Override
    public void savePassResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        for (RsResourceGoodsDomain rsResourceGoodsDomain : goodsList) {
            this.saveResourceGoodsRe(rsResourceGoodsDomain);
        }
    }

    @Override
    public String sendSaveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        this.saveResourceGoodsRe(rsResourceGoodsDomain);
        return rsResourceGoodsDomain.getGoodsCode();
    }

    public RsResourceGoods saveResourceGoodsRe(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        if (null == rsResourceGoodsDomain) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.saveResourceGoods", "rsResourceGoodsDomain is null");
        }
        String msg = this.checkResourceGoods(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.saveResourceGoods.checkResourceGoods", msg);
        }
        RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, null);
        this.setResourceGoodsDefault(rsResourceGoods);
        this.makeFile(rsResourceGoods, rsResourceGoodsDomain);
        this.saveResourceGoodsModel(rsResourceGoods);
        rsResourceGoodsDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
        this.makeRsSpecValue(rsResourceGoodsDomain);
        this.makeRsPropertiesValue(rsResourceGoodsDomain);
        this.makeRsGoodsRel(rsResourceGoodsDomain);
        this.makeRsSku(rsResourceGoodsDomain, rsResourceGoods);
        if (ResourcesConstants.DATA_OPBILLSTATE_1.equals(rsResourceGoods.getDataOpbillstate())) {
            ArrayList<String> goodsCodes = new ArrayList<String>();
            goodsCodes.add(rsResourceGoods.getGoodsCode());
            this.sendESGoods(goodsCodes, rsResourceGoods.getTenantCode(), "insert");
        }
        return rsResourceGoods;
    }

    private List<RsSpecValueDomain> processSpecValue(List<RsSpecValueDomain> rsSpecValueDomainList, String spuCode, String goodsCode, String tenantCode) {
        if (ListUtil.isEmpty(rsSpecValueDomainList)) {
            return null;
        }
        HashMap<String, String> specNameMap = new HashMap<String, String>();
        HashMap<String, String> specCodeMap = new HashMap<String, String>();
        ArrayList<RsSpecValueDomain> newRsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
        for (RsSpecValueDomain specValue : rsSpecValueDomainList) {
            RsSpec rsSpec;
            if (null != specCodeMap.get(specValue.getSpecCode() + "-" + specValue.getSpecValueValue())) continue;
            newRsSpecValueDomainList.add(specValue);
            specValue.setSpecValueId(null);
            specValue.setSpecValueBillno(goodsCode);
            specValue.setSpuCode(spuCode);
            if (StringUtils.isBlank((String)specValue.getSpecValueValue())) {
                specValue.setSpecValueType("0");
            }
            if (StringUtils.isBlank((String)specValue.getSpecValueFlag())) {
                specValue.setSpecValueFlag("1");
            }
            specValue.setTenantCode(tenantCode);
            specCodeMap.put(specValue.getSpecCode() + "-" + specValue.getSpecValueValue(), specValue.getSpecCode());
            if (!StringUtils.isBlank((String)specValue.getSpecName())) continue;
            String specCode = specValue.getSpecCode();
            String specName = (String)specNameMap.get(specCode);
            if (StringUtils.isBlank((String)specName) && null != (rsSpec = this.rsSpecService.getSpecByCode(this.getQueryParamMap("specCode,tenantCode", new Object[]{specCode, tenantCode})))) {
                specName = rsSpec.getSpecName();
                specNameMap.put(specCode, specName);
            }
            specValue.setSpecName(specName);
        }
        return newRsSpecValueDomainList;
    }

    private boolean lockGoodsData(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.lockDataByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.lockGoodsData", map.toString(), (Throwable)e);
        }
        return i > 0;
    }

    public RsResourceGoods getResourceGoodsModelByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.getResourceGoodsModelByCode.map");
            return null;
        }
        try {
            return this.rsResourceGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.getResourceGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public RsResourceGoods getResourceGoodsModelByCode(String goodsCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("goodsCode", goodsCode);
            map.put("tenantCode", tenantCode);
            return this.rsResourceGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.getResourceGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    protected void updateStateResourceGoodsModel(Integer goodsId, Integer dataState, Integer oldDataState, Integer dataOpbillstate) throws ApiException {
        if (null == goodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsId", goodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("dataOpbillstate", dataOpbillstate);
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateStateResourceGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.updateStateResourceGoodsModel", (Object)JsonUtil.buildNormalBinder().toJson(map));
        }
    }

    private RsResourceGoods getResourceGoodsModelById(Integer goodsId) {
        if (null == goodsId) {
            return null;
        }
        try {
            return this.rsResourceGoodsMapper.selectByPrimaryKey(goodsId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.getResourceGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private List<RsResourceGoods> queryResourceGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rsResourceGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.queryResourceGoodsModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public void sendUpdateSoldOutGoods(List<Integer> goodsIds) throws ApiException {
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        ArrayList<String> goodsCodes = new ArrayList<String>();
        RsResourceGoods resourceGoods = null;
        for (Integer goodsId : goodsIds) {
            resourceGoods = this.getResourceGoodsModelById(goodsId);
            if (null == resourceGoods) continue;
            this.updateSoldOutGoods(resourceGoods, ResourcesConstants.GOODS_DATA_STATE_0, ResourcesConstants.DATA_OPBILLSTATE_0);
            goodsCodes.add(resourceGoods.getGoodsCode());
        }
        this.sendGoods(goodsCodes, resourceGoods.getTenantCode(), "down");
    }

    @Override
    public void updateSoldOutGoodsByCode(String goodsCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)goodsCode)) {
            return;
        }
        ArrayList<String> goodsCodes = new ArrayList<String>();
        RsResourceGoods resourceGoods = this.getResourceGoodsModelByCode(this.getQueryParamMap("tenantCode,goodsCode", new Object[]{tenantCode, goodsCode}));
        if (null == resourceGoods) {
            return;
        }
        this.updateSoldOutGoods(resourceGoods, ResourcesConstants.GOODS_DATA_STATE_0, ResourcesConstants.DATA_OPBILLSTATE_0);
        goodsCodes.add(resourceGoods.getGoodsCode());
        this.sendGoods(goodsCodes, resourceGoods.getTenantCode(), "down");
    }

    @Override
    public void sendUpdateShelveGoods(List<Integer> goodsIds) throws ApiException {
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        ArrayList<String> goodsCodes = new ArrayList<String>();
        RsResourceGoods resourceGoods = null;
        for (Integer goodsId : goodsIds) {
            resourceGoods = this.getResourceGoodsModelById(goodsId);
            if (null == resourceGoods) continue;
            this.updateShelveGoods(resourceGoods, ResourcesConstants.GOODS_DATA_STATE_2, ResourcesConstants.DATA_OPBILLSTATE_1, true);
            goodsCodes.add(resourceGoods.getGoodsCode());
        }
        this.sendSku(goodsCodes, resourceGoods.getTenantCode(), "insert");
    }

    private void sendGoods(List<String> goodsCodes, String tenantCode, String type) {
        this.sendDisGoods(goodsCodes, tenantCode, type);
        this.sendESGoods(goodsCodes, tenantCode, type);
    }

    private void sendDisGoods(List<String> goodsCodes, String tenantCode, String type) {
        if (ListUtil.isEmpty(goodsCodes) || null == tenantCode) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.sendSoldOutGoods is null");
            return;
        }
        ArrayList<RsSenddataDomain> rsSenddataDomainList = new ArrayList<RsSenddataDomain>();
        RsSenddataDomain rsSenddataDomain = new RsSenddataDomain();
        rsSenddataDomain.setEsrequestType(type);
        rsSenddataDomain.setTenantCode(tenantCode);
        rsSenddataDomain.setFdBiztype("DisRsResourceGoodsNew");
        rsSenddataDomain.setFdBizcodestr(JsonUtil.buildNormalBinder().toJson(goodsCodes));
        rsSenddataDomainList.add(rsSenddataDomain);
        List<RsSenddata> rsSenddata = this.getRsSenddataBaseService().saveDatasendBatch(rsSenddataDomainList);
        if (ListUtil.isNotEmpty(rsSenddata)) {
            RsResourceGoodsNewServiceImpl.getOpSendService().addPutPool(new OpSendPutThread(RsResourceGoodsNewServiceImpl.getOpSendService(), rsSenddata));
        }
    }

    private void sendESGoods(List<String> goodsCodes, String tenantCode, String type) {
        if (ListUtil.isEmpty(goodsCodes) || null == tenantCode) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.sendSoldOutGoods is null");
            return;
        }
        ArrayList<RsFlowdata> rsFlowdataList = new ArrayList<RsFlowdata>();
        RsFlowdata flowdata = new RsFlowdata();
        flowdata.setTenantCode(tenantCode);
        flowdata.setEsrequestType(type);
        flowdata.setChannelsendApiApicode("RsResourceGoodsEsNew");
        flowdata.setFdBizcodestr(JsonUtil.buildNormalBinder().toJson(goodsCodes));
        rsFlowdataList.add(flowdata);
        List<RsFlowdata> rsFlowdata = this.getRsSenddataBaseService().sendFlowdataBatch(rsFlowdataList);
        if (ListUtil.isNotEmpty(rsFlowdata)) {
            RsResourceGoodsNewServiceImpl.getOpEsEngineService().addPutPool(new OpEsEnginePutThread(RsResourceGoodsNewServiceImpl.getOpEsEngineService(), rsFlowdata));
        }
    }

    private void sendSku(List<String> skuCodes, String tenantCode, String type) {
        if (ListUtil.isEmpty(skuCodes) || null == tenantCode) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.sendSoldOutGoods is null");
            return;
        }
        ArrayList<RsSenddataDomain> rsSenddataDomainList = new ArrayList<RsSenddataDomain>();
        RsSenddataDomain rsSenddataDomain = new RsSenddataDomain();
        rsSenddataDomain.setEsrequestType(type);
        rsSenddataDomain.setTenantCode(tenantCode);
        rsSenddataDomain.setFdBiztype("DisRsSkuNew");
        rsSenddataDomain.setFdBizcodestr(JsonUtil.buildNormalBinder().toJson(skuCodes));
        rsSenddataDomainList.add(rsSenddataDomain);
        List<RsSenddata> rsSenddata = this.getRsSenddataBaseService().saveDatasendBatch(rsSenddataDomainList);
        if (ListUtil.isNotEmpty(rsSenddata)) {
            RsResourceGoodsNewServiceImpl.getOpSendService().addPutPool(new OpSendPutThread(RsResourceGoodsNewServiceImpl.getOpSendService(), rsSenddata));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpSendService getOpSendService() {
        Object object = oplock;
        synchronized (object) {
            if (null == opSendService) {
                opSendService = new OpSendService((RsGoodsSendService)SpringApplicationContextUtil.getBean((String)"rsGoodsSendService"));
                for (int i = 0; i < 60; ++i) {
                    opSendService.addPollPool(new OpSendPollThread(opSendService));
                }
            }
            return opSendService;
        }
    }

    public void updateSoldOutGoods(RsResourceGoods resourceGoods, Integer dataState, Integer dataOpbillstate) throws ApiException {
        this.updateStateResourceGoodsModel(resourceGoods.getGoodsId(), dataState, resourceGoods.getDataState(), dataOpbillstate);
        this.nextUpdateSoldOutGoods(resourceGoods, dataState, dataOpbillstate);
    }

    public void updateSoldOutSku(RsSku sku, Integer dataState, Integer dataOpbillstate) throws ApiException {
        ArrayList<RsSku> rsSkus = new ArrayList<RsSku>();
        rsSkus.add(sku);
        this.updateSku(rsSkus, "down", dataState, dataOpbillstate);
    }

    public void updateShelveGoods(RsResourceGoods resourceGoods, Integer dataState, Integer dataOpbillstate, Boolean type) throws ApiException {
        this.updateStateResourceGoodsModel(resourceGoods.getGoodsId(), dataState, resourceGoods.getDataState(), dataOpbillstate);
        this.nextUpdateShelveGoods(resourceGoods, dataState, dataOpbillstate, type);
    }

    public void updateShelveSku(RsSku sku, Integer dataState, Integer dataOpbillstate) throws ApiException {
        ArrayList<RsSku> rsSkus = new ArrayList<RsSku>();
        rsSkus.add(sku);
        this.updateSku(rsSkus, "insert", dataState, dataOpbillstate);
    }

    @Override
    public String updateNextSoldOutGoods(List<String> goodsCodes, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(goodsCodes)) {
            return "goodsCodes is null";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> nextGoodsCodes = new ArrayList<String>();
        for (String goodsCode : goodsCodes) {
            map.put("tenantCode", tenantCode);
            map.put("goodsOldcode", goodsCode);
            map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
            List<RsResourceGoods> rsResourceGoods = this.queryResourceGoodsModelPage(map);
            for (RsResourceGoods goods : rsResourceGoods) {
                this.updateSoldOutGoods(goods, ResourcesConstants.GOODS_DATA_STATE_3, ResourcesConstants.DATA_OPBILLSTATE_0);
                nextGoodsCodes.add(goods.getGoodsCode());
            }
        }
        this.sendGoods(nextGoodsCodes, tenantCode, "down");
        return "success";
    }

    @Override
    public String updateNextSoldOutSku(List<String> skuCodes, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(skuCodes)) {
            return "skuCodes is null";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> nextskuCodes = new ArrayList<String>();
        for (String skuCode : skuCodes) {
            map.put("tenantCode", tenantCode);
            map.put("skuOldcode", skuCode);
            map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
            List<RsSku> rsSkuList = this.querySkuModelPage(map);
            for (RsSku sku : rsSkuList) {
                this.updateSoldOutSku(sku, ResourcesConstants.GOODS_DATA_STATE_3, ResourcesConstants.DATA_OPBILLSTATE_0);
                nextskuCodes.add(sku.getSkuCode());
            }
        }
        this.sendSku(nextskuCodes, tenantCode, "down");
        return "success";
    }

    @Override
    public String updateNextUpdateShelveGoods(List<String> goodsCodes, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(goodsCodes)) {
            return "goodsCodes is null";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> nextGoodsCodes = new ArrayList<String>();
        for (String goodsCode : goodsCodes) {
            map.put("tenantCode", tenantCode);
            map.put("goodsOldcode", goodsCode);
            map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
            map.put("dataState", ResourcesConstants.GOODS_DATA_STATE_3);
            List<RsResourceGoods> rsResourceGoods = this.queryResourceGoodsModelPage(map);
            for (RsResourceGoods goods : rsResourceGoods) {
                this.updateShelveGoods(goods, ResourcesConstants.GOODS_DATA_STATE_2, ResourcesConstants.DATA_OPBILLSTATE_1, false);
                nextGoodsCodes.add(goods.getGoodsCode());
            }
        }
        this.sendGoods(nextGoodsCodes, tenantCode, "insert");
        return "success";
    }

    @Override
    public String updateNextUpdateShelveSku(List<String> skuCodes, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(skuCodes)) {
            return "skuCodes is null";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> nextSkuCodes = new ArrayList<String>();
        for (String skuCode : skuCodes) {
            map.put("tenantCode", tenantCode);
            map.put("skuOldcode", skuCode);
            map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
            map.put("dataState", ResourcesConstants.GOODS_DATA_STATE_3);
            List<RsSku> rsSkuList = this.querySkuModelPage(map);
            for (RsSku sku : rsSkuList) {
                this.updateShelveSku(sku, ResourcesConstants.GOODS_DATA_STATE_2, ResourcesConstants.DATA_OPBILLSTATE_1);
                nextSkuCodes.add(sku.getSkuCode());
            }
        }
        this.sendSku(nextSkuCodes, tenantCode, "insert");
        return "success";
    }

    private void setResourceGoodsUpdataDefault(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        rsResourceGoods.setGmtModified(this.getSysDate());
        if (null == rsResourceGoods.getChannelCode()) {
            rsResourceGoods.setChannelCode("");
        }
        if (null == rsResourceGoods.getGoodsType()) {
            rsResourceGoods.setGoodsType("");
        }
        if (null == rsResourceGoods.getGoodsPro()) {
            rsResourceGoods.setGoodsPro("");
        }
    }

    private void updateResourceGoodsModel(RsResourceGoods rsResourceGoods) throws ApiException {
        if (null == rsResourceGoods) {
            return;
        }
        try {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.updateResourceGoodsModel." + rsResourceGoods.getGoodsCode() + ".2" + rsResourceGoods.getDataOpbillstate());
            this.rsResourceGoodsMapper.updateByPrimaryKeySelective(rsResourceGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateResourceGoodsModel.ex", (Throwable)e);
        }
    }

    @Override
    public void sendUpdateResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        this.updateResourceGoods(rsResourceGoodsDomain);
    }

    private void updateResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        if (null == rsResourceGoodsDomain) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateResourceGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String msg = this.checkResourceGoods(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.saveResourceGoods.checkResourceGoods", msg);
        }
        RsResourceGoods resourceGoods = null;
        if (null != rsResourceGoodsDomain.getGoodsId()) {
            resourceGoods = this.getResourceGoodsModelById(rsResourceGoodsDomain.getGoodsId());
        }
        if (null == resourceGoods && StringUtils.isNotBlank((String)rsResourceGoodsDomain.getTenantCode()) && StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsCode())) {
            resourceGoods = this.getResourceGoodsModelByCode(this.getQueryParamMap("tenantCode,goodsCode", new Object[]{rsResourceGoodsDomain.getTenantCode(), rsResourceGoodsDomain.getGoodsCode()}));
        }
        if (null == resourceGoods) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateResourceGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setGoodsId(resourceGoods.getGoodsId());
        rsResourceGoodsDomain.setGoodsCode(resourceGoods.getGoodsCode());
        rsResourceGoodsDomain.setGoodsOldcode(resourceGoods.getGoodsOldcode());
        RsResourceGoods rsResourceGoods = this.makeResourceGoods(rsResourceGoodsDomain, null);
        this.setResourceGoodsDefault(rsResourceGoods);
        this.updateFile(rsResourceGoods, rsResourceGoodsDomain);
        this.updateResourceGoodsModel(rsResourceGoods);
        this.makeRsSpecValue(rsResourceGoodsDomain);
        this.updatemakeRsPropertiesValue(rsResourceGoodsDomain);
        this.makeRsGoodsRel(rsResourceGoodsDomain);
        this.rsSkuNewService.updateSkuList(rsResourceGoodsDomain.getRsSkuDomainList(), rsResourceGoods);
    }

    private List<RsSenddataDomain> delGoodsData(RsResourceGoods rsResourceGoods, Map<String, String> skuCodeMap) {
        if (null == rsResourceGoods) {
            return null;
        }
        String spuCode = rsResourceGoods.getSpuCode();
        String goodsCode = rsResourceGoods.getGoodsCode();
        String tenantCode = rsResourceGoods.getTenantCode();
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spuCode", spuCode);
        map.put("goodsCode", goodsCode);
        map.put("specValueBillno", goodsCode);
        map.put("tenantCode", tenantCode);
        List<RsSenddataDomain> relist = null;
        this.rsSkuService.deleteSkuByGoodsCodeNoNew(goodsCode, tenantCode, rsResourceGoods.getGoodsEocode(), skuCodeMap);
        return relist;
    }

    public RsSku getSkuModelByCode(String skuCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuCode", skuCode);
        try {
            return this.rsSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.getSkuModelByCode", (Object)((Object)map).toString(), (Throwable)e);
            return null;
        }
    }

    private List<RsSku> querySkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private void nextUpdateSoldOutGoods(RsResourceGoods resourceGoods, Integer dataState, Integer dataOpbillstate) {
        HashMap<String, Object> skumap = new HashMap<String, Object>();
        skumap.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
        skumap.put("tenantCode", resourceGoods.getTenantCode());
        skumap.put("goodsCode", resourceGoods.getGoodsCode());
        List<RsSku> rsSkus = this.querySkuModelPage(skumap);
        this.updateSku(rsSkus, "down", dataState, dataOpbillstate);
    }

    private void nextUpdateShelveGoods(RsResourceGoods resourceGoods, Integer dataState, Integer dataOpbillstate, Boolean type) {
        HashMap<String, Object> skumap = new HashMap<String, Object>();
        skumap.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        if (!type.booleanValue()) {
            skumap.put("dataState", ResourcesConstants.GOODS_DATA_STATE_3);
        }
        skumap.put("tenantCode", resourceGoods.getTenantCode());
        skumap.put("goodsCode", resourceGoods.getGoodsCode());
        List<RsSku> rsSkus = this.querySkuModelPage(skumap);
        this.updateSku(rsSkus, "insert", dataState, dataOpbillstate);
    }

    private void updateStateSkuModel(Integer skuId, Integer dataState, Integer oldDataState, Integer dataOpbillstate) throws ApiException {
        if (null == skuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuId", skuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("dataOpbillstate", dataOpbillstate);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateStateSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.updateStateSkuModel", (Object)JsonUtil.buildNormalBinder().toJson(map));
        }
    }

    private void updateSku(List<RsSku> rsSkus, String type, Integer dataState, Integer dataOpbillstate) throws ApiException {
        if (ListUtil.isEmpty(rsSkus)) {
            return;
        }
        RsFlowdata flowdata = null;
        ArrayList<RsFlowdata> rsFlowdataList = new ArrayList<RsFlowdata>();
        for (RsSku sku : rsSkus) {
            this.updateStateSkuModel(sku.getSkuId(), dataState, sku.getDataState(), dataOpbillstate);
            flowdata = new RsFlowdata();
            flowdata.setTenantCode(sku.getTenantCode());
            flowdata.setEsrequestType(type);
            flowdata.setChannelsendApiApicode("dataUpdateNew");
            flowdata.setFdBizcode(sku.getSkuCode());
            rsFlowdataList.add(flowdata);
        }
        List<RsFlowdata> rsFlowdata = this.getRsSenddataBaseService().sendFlowdataBatch(rsFlowdataList);
        if (ListUtil.isNotEmpty(rsFlowdata)) {
            RsResourceGoodsNewServiceImpl.getOpEsEngineService().addPutPool(new OpEsEnginePutThread(RsResourceGoodsNewServiceImpl.getOpEsEngineService(), rsFlowdata));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpEsEngineService getOpEsEngineService() {
        Object object = oplock;
        synchronized (object) {
            if (null == opEsEngineService) {
                opEsEngineService = new OpEsEngineService((RsGoodsSendService)SpringApplicationContextUtil.getBean((String)"rsGoodsSendService"));
                for (int i = 0; i < 100; ++i) {
                    opEsEngineService.addPollPool(new OpEsEnginePollThread(opEsEngineService));
                }
            }
            return opEsEngineService;
        }
    }

    @Override
    public void sendUpdateShelveSku(Integer skuId) {
        RsSku rsSku = this.rsSkuService.getSku(skuId);
        if (rsSku == null) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.sendUpdateShelveSku.null", "rsSku is null");
        }
        if (ResourcesConstants.DATA_OPBILLSTATE_1.intValue() == rsSku.getDataOpbillstate().intValue()) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.sendUpdateShelveSku.null", "\u72b6\u6001\u9519\u8bef");
        }
        this.updateShelveSkuState(rsSku, ResourcesConstants.GOODS_DATA_STATE_2, ResourcesConstants.DATA_OPBILLSTATE_1, rsSku.getDataState());
    }

    @Override
    public void sendUpdateSoldOutSku(Integer skuId) {
        RsSku rsSku = this.rsSkuService.getSku(skuId);
        if (rsSku == null) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.sendUpdateShelveSku.null", "rsSku is null");
        }
        if (ResourcesConstants.DATA_OPBILLSTATE_0.intValue() == rsSku.getDataOpbillstate().intValue()) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.sendUpdateShelveSku.null", "\u72b6\u6001\u9519\u8bef");
        }
        this.updateSoldOutSkuState(rsSku, ResourcesConstants.GOODS_DATA_STATE_0, ResourcesConstants.DATA_OPBILLSTATE_0, rsSku.getDataState());
    }

    private void updateSoldOutSkuState(RsSku rsSku, Integer dataState, Integer dataOpbillstate, Integer oldDataState) {
        if (null == rsSku || null == dataState) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuState", " param is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", rsSku.getTenantCode());
        map.put("goodsCode", rsSku.getGoodsCode());
        if (!this.lockGoodsData(map)) {
            return;
        }
        ArrayList<RsSku> rsSkus = new ArrayList<RsSku>();
        rsSkus.add(rsSku);
        this.updateSku(rsSkus, "down", dataState, dataOpbillstate);
        HashMap<String, Object> skuMap = new HashMap<String, Object>();
        skuMap.put("tenantCode", rsSku.getTenantCode());
        skuMap.put("goodsCode", rsSku.getGoodsCode());
        skuMap.put("dataState", oldDataState);
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (ListUtil.isEmpty(rsSkuList)) {
            this.updateSoldOutGoodsByCode(rsSku.getGoodsCode(), rsSku.getTenantCode());
        } else {
            ArrayList<String> skuCodes = new ArrayList<String>();
            skuCodes.add(rsSku.getSkuCode());
            this.sendSku(skuCodes, rsSku.getTenantCode(), "down");
        }
    }

    private void updateShelveSkuState(RsSku rsSku, Integer dataState, Integer dataOpbillstate, Integer oldDataState) {
        if (null == rsSku || null == dataState) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuState", " param is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", rsSku.getTenantCode());
        map.put("goodsCode", rsSku.getGoodsCode());
        if (!this.lockGoodsData(map)) {
            return;
        }
        ArrayList<RsSku> rsSkus = new ArrayList<RsSku>();
        rsSkus.add(rsSku);
        RsResourceGoods resourceGoods = this.getResourceGoodsModelByCode(map);
        if (null == resourceGoods) {
            return;
        }
        if (ResourcesConstants.DATA_OPBILLSTATE_0.equals(resourceGoods.getDataOpbillstate())) {
            this.updateStateResourceGoodsModel(resourceGoods.getGoodsId(), dataState, resourceGoods.getDataState(), dataOpbillstate);
            ArrayList<String> goodsCodes = new ArrayList<String>();
            goodsCodes.add(resourceGoods.getGoodsCode());
            this.sendESGoods(goodsCodes, resourceGoods.getTenantCode(), "insert");
        }
        this.updateSku(rsSkus, "insert", dataState, dataOpbillstate);
        ArrayList<String> skuCodes = new ArrayList<String>();
        skuCodes.add(rsSku.getSkuCode());
        this.sendSku(skuCodes, resourceGoods.getTenantCode(), "insert");
    }

    @Override
    public void sendUpdateSoldOutBatchSku(List<Integer> skuIds) throws ApiException {
        if (ListUtil.isEmpty(skuIds)) {
            return;
        }
        for (Integer skuId : skuIds) {
            RsSku rsSku = this.rsSkuService.getSku(skuId);
            if (rsSku == null) {
                throw new ApiException("rs.RsResourceGoodsNewServiceImpl.sendUpdateShelveSku.null", "rsSku is null");
            }
            if (ResourcesConstants.DATA_OPBILLSTATE_0.intValue() == rsSku.getDataOpbillstate().intValue()) {
                throw new ApiException("rs.RsResourceGoodsNewServiceImpl.sendUpdateShelveSku.null", "\u72b6\u6001\u9519\u8bef");
            }
            this.updateSoldOutSkuState(rsSku, ResourcesConstants.GOODS_DATA_STATE_0, ResourcesConstants.DATA_OPBILLSTATE_0, rsSku.getDataState());
        }
    }

    @Override
    public void sendUpdateGoodsStateById(Integer goodsId, Integer dataState, Integer oldDataState) {
        if (null != goodsId) {
            return;
        }
        RsResourceGoods resourceGoods = this.getResourceGoodsModelById(goodsId);
        if (null == resourceGoods) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.sendUpdateGoodsStateById.null", "resourceGoods is null");
        }
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        goodsIds.add(resourceGoods.getGoodsId());
        if (dataState.equals(ResourcesConstants.GOODS_DATA_STATE_0)) {
            this.sendUpdateSoldOutGoods(goodsIds);
        } else if (dataState.equals(ResourcesConstants.GOODS_DATA_STATE_2)) {
            this.sendUpdateShelveGoods(goodsIds);
        }
    }

    public RsResourceGoods getResourceGoodsModelByOldCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsResourceGoodsMapper.getByOldCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.getResourceGoodsModelByOldCode", (Object)map.toString(), (Throwable)e);
            return null;
        }
    }

    private String checkSkuEdit(EditSkuDomain editSkuDomain) {
        if (null == editSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (null == editSkuDomain.getSkuId() && StringUtils.isBlank((String)editSkuDomain.getSkuNo())) {
            msg = msg + "SkuNo\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getSkuCode()) && StringUtils.isBlank((String)editSkuDomain.getSkuNo())) {
            msg = msg + "skuCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getGoodsCode()) && StringUtils.isBlank((String)editSkuDomain.getSkuNo())) {
            msg = msg + "goodsCode\u4e3a\u7a7a;";
        }
        if (null != editSkuDomain.getGoodsSupplynum() && null == editSkuDomain.getGoodsNum()) {
            editSkuDomain.setGoodsNum(editSkuDomain.getGoodsSupplynum());
        }
        if (null != editSkuDomain.getGoodsSupplyweight() && null == editSkuDomain.getGoodsWeight()) {
            editSkuDomain.setGoodsWeight(editSkuDomain.getGoodsSupplyweight());
        }
        if (null == editSkuDomain.getGoodsSupplynum() && null != editSkuDomain.getGoodsNum()) {
            editSkuDomain.setGoodsSupplynum(editSkuDomain.getGoodsNum());
        }
        if (null == editSkuDomain.getGoodsSupplyweight() && null != editSkuDomain.getGoodsWeight()) {
            editSkuDomain.setGoodsSupplyweight(editSkuDomain.getGoodsWeight());
        }
        if (null != editSkuDomain.getGoodsSupplynum() && editSkuDomain.getGoodsSupplynum().compareTo(editSkuDomain.getGoodsNum()) != 0) {
            editSkuDomain.setGoodsNum(editSkuDomain.getGoodsSupplynum());
        }
        if (null != editSkuDomain.getGoodsSupplyweight() && editSkuDomain.getGoodsSupplyweight().compareTo(editSkuDomain.getGoodsWeight()) != 0) {
            editSkuDomain.setGoodsWeight(editSkuDomain.getGoodsSupplyweight());
        }
        return msg;
    }

    private boolean updateGoods(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return false;
        }
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.updateGoodsNumByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateGoods", map.toString(), (Throwable)e);
        }
        return i > 0;
    }

    @Override
    public void sendUpdateSkuEdit(EditSkuDomain editSkuDomain) throws ApiException {
        if (null == editSkuDomain) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuEdit", "editSkuDomain = null");
        }
        String msg = this.checkSkuEdit(editSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuEdit.checkSku", msg);
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getSkuNo()) && StringUtils.isBlank((String)editSkuDomain.getSkuCode()) && null == editSkuDomain.getSkuId()) {
            RsSku oldRsSku = this.rsSkuService.getSkuBySkuNo(editSkuDomain.getSkuNo(), editSkuDomain.getMemberCode(), editSkuDomain.getMemberCcode(), editSkuDomain.getChannelCode(), editSkuDomain.getTenantCode());
            if (null == oldRsSku) {
                throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuEdit.oldRsSku3", editSkuDomain.getSkuNo() + "=" + editSkuDomain.getMemberCode() + "=" + editSkuDomain.getMemberCcode() + "=" + editSkuDomain.getChannelCode() + "=" + editSkuDomain.getTenantCode());
            }
            editSkuDomain.setChannelCode(oldRsSku.getChannelCode());
            editSkuDomain.setSkuCode(oldRsSku.getSkuCode());
            editSkuDomain.setGoodsCode(oldRsSku.getGoodsCode());
            editSkuDomain.setSkuId(oldRsSku.getSkuId());
        }
        if (StringUtils.isBlank((String)editSkuDomain.getGoodsCode())) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuEdit.goodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", editSkuDomain.getGoodsCode());
        map.put("tenantCode", editSkuDomain.getTenantCode());
        if (!this.lockGoodsData(map)) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuEdit.lockGoodsData", ((Object)map).toString());
        }
        RsResourceGoods rsResourceGoods = this.getResourceGoodsModelByCode(map);
        if (null == rsResourceGoods) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuEdit.rsResourceGoods", ((Object)map).toString());
        }
        RsSku oldRsSku = null;
        oldRsSku = StringUtils.isBlank((String)editSkuDomain.getSkuCode()) ? this.rsSkuService.getSku(editSkuDomain.getSkuId()) : this.rsSkuService.getSkuByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{editSkuDomain.getSkuCode(), editSkuDomain.getTenantCode()}));
        if (null == oldRsSku) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuEdit.oldRsSku1", editSkuDomain.getSkuId() + "");
        }
        this.saveSkuEdit(editSkuDomain, rsResourceGoods, oldRsSku);
    }

    private void updateEditSku(EditSkuDomain editSkuDomain) throws ApiException {
        if (null == editSkuDomain) {
            return;
        }
        try {
            this.rsSkuMapper.updateEditSku(editSkuDomain);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateEditSku.ex", (Throwable)e);
        }
    }

    private void saveSkuEdit(EditSkuDomain editSkuDomain, RsResourceGoods rsResourceGoods, RsSku oldRsSku) {
        if (null == oldRsSku || null == editSkuDomain || null == rsResourceGoods) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)editSkuDomain.getType())) {
            editSkuDomain.setType("0");
        }
        if ("0".equals(editSkuDomain.getDgoodsPic())) {
            editSkuDomain.setRsGoodsFileDomainList(null);
            if (StringUtils.isNotBlank((String)rsResourceGoods.getDataPic())) {
                editSkuDomain.setDataPic(rsResourceGoods.getDataPic());
            }
        }
        if (null == oldRsSku.getGoodsOrdnum()) {
            oldRsSku.setGoodsOrdnum(BigDecimal.ZERO);
        }
        if (null == oldRsSku.getGoodsOrdweight()) {
            oldRsSku.setGoodsOrdweight(BigDecimal.ZERO);
        }
        if (oldRsSku.getGoodsOrdnum().compareTo(BigDecimal.ZERO) < 0) {
            oldRsSku.setGoodsOrdnum(BigDecimal.ZERO);
        }
        if (oldRsSku.getGoodsOrdweight().compareTo(BigDecimal.ZERO) < 0) {
            oldRsSku.setGoodsOrdweight(BigDecimal.ZERO);
        }
        if ("1".equals(editSkuDomain.getType())) {
            if (null != editSkuDomain.getGoodsNum() && editSkuDomain.getGoodsNum().compareTo(BigDecimal.ZERO) > 0) {
                if (editSkuDomain.getGoodsNum().compareTo(oldRsSku.getGoodsOrdnum()) > 0) {
                    editSkuDomain.setGoodsNum(editSkuDomain.getGoodsNum().subtract(oldRsSku.getGoodsOrdnum()));
                    editSkuDomain.setGoodsWeight(editSkuDomain.getGoodsWeight().subtract(oldRsSku.getGoodsOrdweight()));
                } else {
                    editSkuDomain.setGoodsNum(BigDecimal.ZERO);
                    editSkuDomain.setGoodsWeight(BigDecimal.ZERO);
                }
            }
            if (null != editSkuDomain.getGoodsSupplynum() && editSkuDomain.getGoodsSupplynum().compareTo(BigDecimal.ZERO) > 0) {
                if (editSkuDomain.getGoodsSupplynum().compareTo(oldRsSku.getGoodsOrdnum()) > 0) {
                    editSkuDomain.setGoodsSupplynum(editSkuDomain.getGoodsSupplynum().subtract(oldRsSku.getGoodsOrdnum()));
                    editSkuDomain.setGoodsSupplyweight(editSkuDomain.getGoodsSupplyweight().subtract(oldRsSku.getGoodsOrdweight()));
                } else {
                    editSkuDomain.setGoodsSupplynum(BigDecimal.ZERO);
                    editSkuDomain.setGoodsSupplyweight(BigDecimal.ZERO);
                }
            }
        }
        map.put("goodsCode", rsResourceGoods.getGoodsCode());
        map.put("tenantCode", rsResourceGoods.getTenantCode());
        if (StringUtils.isNotBlank((String)editSkuDomain.getGinfoCode())) {
            map.put("ginfoCode", editSkuDomain.getGinfoCode());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsSpec())) {
            map.put("goodsSpec", editSkuDomain.getGoodsSpec());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsSpec1())) {
            map.put("goodsSpec1", editSkuDomain.getGoodsSpec1());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsSpec2())) {
            map.put("goodsSpec2", editSkuDomain.getGoodsSpec2());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsSpec3())) {
            map.put("goodsSpec3", editSkuDomain.getGoodsSpec3());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsSpec4())) {
            map.put("goodsSpec4", editSkuDomain.getGoodsSpec4());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsSpec5())) {
            map.put("goodsSpec5", editSkuDomain.getGoodsSpec5());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsProperty())) {
            map.put("goodsProperty", editSkuDomain.getGoodsProperty());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsProperty1())) {
            map.put("goodsProperty1", editSkuDomain.getGoodsProperty1());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsProperty2())) {
            map.put("goodsProperty2", editSkuDomain.getGoodsProperty2());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsProperty3())) {
            map.put("goodsProperty3", editSkuDomain.getGoodsProperty3());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsProperty4())) {
            map.put("goodsProperty4", editSkuDomain.getGoodsProperty4());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsProperty5())) {
            map.put("goodsProperty5", editSkuDomain.getGoodsProperty5());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsUnitstr())) {
            map.put("goodsUnitstr", editSkuDomain.getGoodsUnitstr());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsWeightstr())) {
            map.put("goodsWeightstr", editSkuDomain.getGoodsWeightstr());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getClasstreeShopcode())) {
            map.put("classtreeShopcode", editSkuDomain.getClasstreeShopcode());
        } else if (ListUtil.isNotEmpty(editSkuDomain.getRsGoodsShopDomainList())) {
            map.put("classtreeShopcode", editSkuDomain.getRsGoodsShopDomainList().get(0).getGoodsClassCode());
            map.put("classtreeShopname", editSkuDomain.getRsGoodsShopDomainList().get(0).getGoodsClassName());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getClasstreeShopname())) {
            map.put("classtreeShopname", editSkuDomain.getClasstreeShopname());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsPro())) {
            map.put("goodsPro", editSkuDomain.getGoodsPro());
            rsResourceGoods.setGoodsPro(editSkuDomain.getGoodsPro());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getSaleChannel())) {
            map.put("saleChannel", editSkuDomain.getSaleChannel());
        }
        if (null != editSkuDomain.getGoodsSdate()) {
            map.put("goodsSdate", editSkuDomain.getGoodsSdate());
        }
        if (null != editSkuDomain.getGoodsEdate()) {
            map.put("goodsEdate", editSkuDomain.getGoodsEdate());
        }
        if (null != editSkuDomain.getSkuOdate()) {
            map.put("skuOdate", editSkuDomain.getSkuOdate());
            map.put("goodsOdate", editSkuDomain.getSkuOdate());
        }
        if (null != editSkuDomain.getSkuHdate()) {
            map.put("skuHdate", editSkuDomain.getSkuHdate());
            map.put("goodsHdate", editSkuDomain.getSkuHdate());
        }
        if (null != editSkuDomain.getWarehouseCode()) {
            map.put("warehouseCode", editSkuDomain.getWarehouseCode());
            rsResourceGoods.setWarehouseCode(editSkuDomain.getWarehouseCode());
        }
        if (null != editSkuDomain.getWarehouseName()) {
            map.put("warehouseName", editSkuDomain.getWarehouseName());
            rsResourceGoods.setWarehouseName(editSkuDomain.getWarehouseName());
        }
        this.updateGoodsNum(oldRsSku, editSkuDomain, rsResourceGoods, map);
        String msg = this.checkSkuEdit(editSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateSkuEdit.checkSku", msg);
        }
        this.updateEditSku(editSkuDomain);
        ArrayList<String> skuCodes = new ArrayList<String>();
        skuCodes.add(editSkuDomain.getSkuCode());
        this.sendSku(skuCodes, editSkuDomain.getTenantCode(), "edit");
        ArrayList<RsFlowdata> rsFlowdataList = new ArrayList<RsFlowdata>();
        RsFlowdata flowdata = new RsFlowdata();
        flowdata.setTenantCode(editSkuDomain.getTenantCode());
        flowdata.setEsrequestType("edit");
        flowdata.setChannelsendApiApicode("dataUpdateNew");
        flowdata.setFdBizcode(editSkuDomain.getSkuCode());
        rsFlowdataList.add(flowdata);
        List<RsFlowdata> rsFlowdata = this.getRsSenddataBaseService().sendFlowdataBatch(rsFlowdataList);
        if (ListUtil.isNotEmpty(rsFlowdata)) {
            RsResourceGoodsNewServiceImpl.getOpEsEngineService().addPutPool(new OpEsEnginePutThread(RsResourceGoodsNewServiceImpl.getOpEsEngineService(), rsFlowdata));
        }
    }

    private void updateGoodsNum(RsSku oldRsSku, EditSkuDomain editSkuDomain, RsResourceGoods rsResourceGoods, Map<String, Object> map) {
        if (null == oldRsSku || null == editSkuDomain || null == map) {
            throw new ApiException("rs.RsResourceGoodsNewServiceImpl.updateGoodsNum.param");
        }
        if (null == rsResourceGoods.getGoodsSupplynum()) {
            rsResourceGoods.setGoodsSupplynum(BigDecimal.ZERO);
        }
        if (null == rsResourceGoods.getGoodsSupplyweight()) {
            rsResourceGoods.setGoodsSupplyweight(BigDecimal.ZERO);
        }
        if (null == oldRsSku.getGoodsSupplynum()) {
            oldRsSku.setGoodsSupplynum(BigDecimal.ZERO);
        }
        if (null == oldRsSku.getGoodsSupplyweight()) {
            oldRsSku.setGoodsSupplyweight(BigDecimal.ZERO);
        }
        if (null != editSkuDomain.getGoodsSupplynum()) {
            BigDecimal supplyNum = rsResourceGoods.getGoodsSupplynum().subtract(oldRsSku.getGoodsSupplynum()).add(editSkuDomain.getGoodsSupplynum());
            map.put("goodsSupplynum", supplyNum);
            map.put("goodsNum", supplyNum);
            rsResourceGoods.setGoodsSupplynum(editSkuDomain.getGoodsSupplynum());
            rsResourceGoods.setGoodsNum(editSkuDomain.getGoodsNum());
        }
        if (null != editSkuDomain.getGoodsSupplyweight()) {
            BigDecimal goodsSupplyweight = rsResourceGoods.getGoodsSupplyweight().subtract(oldRsSku.getGoodsSupplyweight()).add(editSkuDomain.getGoodsSupplyweight());
            map.put("goodsSupplyweight", goodsSupplyweight);
            map.put("goodsWeight", goodsSupplyweight);
        }
        if (null != editSkuDomain.getPricesetNprice()) {
            map.put("pricesetNprice", editSkuDomain.getPricesetNprice());
        }
        if (null != editSkuDomain.getPricesetMakeprice()) {
            map.put("pricesetMakeprice", editSkuDomain.getPricesetMakeprice());
        }
        if (null != editSkuDomain.getPricesetAsprice()) {
            map.put("pricesetAsprice", editSkuDomain.getPricesetAsprice());
        }
        if (null != editSkuDomain.getGoodsType()) {
            map.put("goodsType", editSkuDomain.getGoodsType());
        }
        if (null != editSkuDomain.getPricesetType()) {
            map.put("pricesetType", editSkuDomain.getPricesetType());
        }
        if (null != editSkuDomain.getGoodsTopnum()) {
            map.put("goodsTopnum", editSkuDomain.getGoodsTopnum());
        }
        if (null != editSkuDomain.getGoodsMinnum()) {
            map.put("goodsMinnum", editSkuDomain.getGoodsMinnum());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsRemark())) {
            map.put("goodsRemark", editSkuDomain.getGoodsRemark());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsWebremark())) {
            map.put("goodsWebremark", editSkuDomain.getGoodsWebremark());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsName())) {
            map.put("goodsName", editSkuDomain.getGoodsName());
        }
        if (null != editSkuDomain.getGoodsSort()) {
            map.put("goodsSort", editSkuDomain.getGoodsSort());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getGoodsDayinfo())) {
            map.put("goodsDayinfo", editSkuDomain.getGoodsDayinfo());
        }
        if (null != editSkuDomain.getGoodsOneweight()) {
            map.put("goodsOneweight", editSkuDomain.getGoodsOneweight());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getSaleChannel())) {
            map.put("saleChannel", editSkuDomain.getSaleChannel());
        }
        if (null != editSkuDomain.getPricesetMakeshow()) {
            map.put("pricesetMakeshow", editSkuDomain.getPricesetMakeshow());
        }
        if (null != editSkuDomain.getPartsnameName()) {
            map.put("partsnameName", editSkuDomain.getPartsnameName());
        }
        if (null != editSkuDomain.getClasstreeCode()) {
            map.put("classtreeCode", editSkuDomain.getClasstreeCode());
        }
        if (StringUtils.isNotBlank((String)editSkuDomain.getAreaCode())) {
            map.put("areaCode", editSkuDomain.getAreaCode());
        }
        if (null != editSkuDomain.getClasstreeName()) {
            map.put("classtreeName", editSkuDomain.getClasstreeName());
        }
        if (null == editSkuDomain.getGoodsEdit() || !editSkuDomain.getGoodsEdit().booleanValue()) {
            this.updateGoods(map);
        }
    }

    @Override
    public String sendGoodsByLog(RsSenddataLog rsSenddataLog) throws ApiException {
        if (null == rsSenddataLog) {
            return "\u63a8\u9001\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        if (StringUtils.isBlank((String)rsSenddataLog.getFdBizcodestr())) {
            return "\u63a8\u9001\u5185\u5bb9\u4e0d\u5b58\u5728";
        }
        SendData sendData = (SendData)JsonUtil.buildNormalBinder().getJsonToObject(rsSenddataLog.getFdBizcodestr(), SendData.class);
        if (null == sendData) {
            return "\u63a8\u9001\u5185\u5bb9\u9519\u8bef";
        }
        RsResourceGoods resourceGoods = this.getResourceGoodsModelByCode(rsSenddataLog.getGoodsOldcode(), rsSenddataLog.getTenantCode());
        if (null == resourceGoods) {
            return "\u63a8\u9001\u5546\u54c1\u4e0d\u5b58\u5728";
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("goodsOldcode", resourceGoods.getGoodsCode());
        parammap.put("tenantCode", resourceGoods.getTenantCode());
        parammap.put("channelCode", rsSenddataLog.getChannelCode());
        parammap.put("goodsType", resourceGoods.getGoodsType());
        parammap.put("goodsNo", resourceGoods.getGoodsNo());
        List<RsResourceGoods> rsResourceGoodsList = this.queryResourceGoodsModelPage(parammap);
        DisChannel channel = this.getChannel(rsSenddataLog.getChannelCode(), rsSenddataLog.getTenantCode());
        if (null == channel) {
            return "\u63a8\u9001\u5546\u54c1\u6e20\u9053\u4e0d\u5b58\u5728";
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.makeReDoamin(resourceGoods);
        if (ListUtil.isEmpty(rsResourceGoodsList)) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.sendGoodsByLog goods is null");
            RsResourceGoodsDomain rsResourceGoodsDomain = this.makeDisGoods(rsResourceGoodsReDomain, channel);
            if (null == rsResourceGoodsDomain) {
                return "\u63a8\u9001\u5546\u54c1\u6570\u636e\u5f02\u5e38";
            }
            rsResourceGoodsDomain.setGoodsId(null);
            rsResourceGoodsDomain.setGoodsCode(null);
            this.saveResourceGoodsRe(rsResourceGoodsDomain);
        } else {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.sendGoodsByLog goods");
            RsResourceGoods resourceGoodsOld = rsResourceGoodsList.get(0);
            RsResourceGoodsReDomain rsResourceGoodsRe = this.makeReDomian(resourceGoodsOld);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsResourceGoodsRe.getGoodsCode());
            map.put("tenantCode", rsResourceGoodsRe.getTenantCode());
            QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.rsSkuNewService.querySkuPage(map);
            if (ListUtil.isEmpty((Collection)rsSkuDomainQueryResult.getList())) {
                return "\u63a8\u9001\u8d27\u54c1\u4e0d\u5b58\u5728";
            }
            HashMap<String, RsSkuDomain> skuDomainMap = new HashMap<String, RsSkuDomain>();
            for (Object rsSkuDomain : rsSkuDomainQueryResult.getList()) {
                skuDomainMap.put(((RsSkuDomain)rsSkuDomain).getSkuNo(), (RsSkuDomain)rsSkuDomain);
            }
            rsResourceGoodsRe.setGoodsCode(resourceGoods.getGoodsCode());
            rsResourceGoodsRe.setChannelCode(resourceGoods.getChannelCode());
            if (sendData.isFreightTem()) {
                rsResourceGoodsRe.setFreightTemCode(resourceGoods.getFreightTemCode());
            }
            if (sendData.isTitle()) {
                rsResourceGoodsRe.setGoodsName(resourceGoods.getGoodsName());
                rsResourceGoodsRe.setGoodsProperty(resourceGoods.getGoodsProperty());
            }
            ArrayList<RsSkuDomain> skuDomainList = new ArrayList<RsSkuDomain>();
            for (RsSkuDomain rsSkuDomain : rsResourceGoodsReDomain.getRsSkuDomainList()) {
                RsSkuDomain rsSkuDomainOld = (RsSkuDomain)skuDomainMap.get(rsSkuDomain.getSkuNo());
                if (null == rsSkuDomainOld) {
                    rsSkuDomain.setSkuCode(null);
                    rsSkuDomain.setSkuId(null);
                    skuDomainList.add(rsSkuDomain);
                    continue;
                }
                if (sendData.isGoodsNum()) {
                    rsSkuDomainOld.setGoodsNum(rsSkuDomain.getGoodsNum());
                    rsSkuDomainOld.setGoodsSupplynum(rsSkuDomain.getGoodsSupplynum());
                }
                if (sendData.isGoodsWeight()) {
                    rsSkuDomainOld.setGoodsWeight(rsSkuDomain.getGoodsWeight());
                    rsSkuDomainOld.setGoodsOneweight(rsSkuDomain.getGoodsOneweight());
                    rsSkuDomainOld.setGoodsSupplyweight(rsSkuDomain.getGoodsSupplyweight());
                }
                if (sendData.isMinNum()) {
                    rsSkuDomainOld.setGoodsMinnum(rsSkuDomain.getGoodsMinnum());
                }
                if (sendData.isPic()) {
                    rsSkuDomainOld.setDataPic(rsSkuDomain.getDataPic());
                    rsSkuDomainOld.setRsGoodsFileDomainList(rsSkuDomain.getRsGoodsFileDomainList());
                }
                if (sendData.isPrice()) {
                    rsSkuDomainOld.setPricesetNprice(rsSkuDomain.getPricesetNprice());
                    rsSkuDomainOld.setPricesetPrefprice(rsSkuDomain.getPricesetPrefprice());
                    rsSkuDomainOld.setPricesetMakeprice(rsSkuDomain.getPricesetMakeprice());
                    rsSkuDomainOld.setPricesetAsprice(rsSkuDomain.getPricesetAsprice());
                    rsSkuDomainOld.setPricesetAllprice(rsSkuDomain.getPricesetAllprice());
                    rsSkuDomainOld.setPricesetInsideprice(rsSkuDomain.getPricesetInsideprice());
                    rsSkuDomainOld.setPricesetRefrice(rsSkuDomain.getPricesetRefrice());
                }
                if (sendData.isUnit()) {
                    rsResourceGoodsRe.setPartsnameNumunit(rsSkuDomain.getPartsnameNumunit());
                    rsResourceGoodsRe.setPartsnameNumunit1(rsSkuDomain.getPartsnameNumunit1());
                }
                rsSkuDomainOld.setRsGoodsRelDomainList(rsSkuDomain.getRsGoodsRelDomainList());
                skuDomainList.add(rsSkuDomainOld);
            }
            rsResourceGoodsRe.setRsSkuDomainList(skuDomainList);
            rsResourceGoodsRe.setPropertiesValueList(rsResourceGoodsReDomain.getPropertiesValueList());
            rsResourceGoodsRe.setRsSpecValueList(rsResourceGoodsReDomain.getRsSpecValueList());
            rsResourceGoodsRe.setRsGoodsFileDomainList(rsResourceGoodsReDomain.getRsGoodsFileDomainList());
            rsResourceGoodsRe.setRsGoodsRelDomainList(rsResourceGoodsReDomain.getRsGoodsRelDomainList());
            if (sendData.isGoodsNum()) {
                rsResourceGoodsRe.setGoodsNum(resourceGoods.getGoodsNum());
                rsResourceGoodsRe.setGoodsSupplynum(resourceGoods.getGoodsSupplynum());
            }
            if (sendData.isGoodsWeight()) {
                rsResourceGoodsRe.setGoodsWeight(resourceGoods.getGoodsWeight());
                rsResourceGoodsRe.setGoodsOneweight(resourceGoods.getGoodsOneweight());
                rsResourceGoodsRe.setGoodsSupplyweight(resourceGoods.getGoodsSupplyweight());
            }
            if (sendData.isMinNum()) {
                rsResourceGoodsRe.setGoodsMinnum(resourceGoods.getGoodsMinnum());
            }
            if (sendData.isPic()) {
                rsResourceGoodsRe.setDataPic(resourceGoods.getDataPic());
                rsResourceGoodsRe.setDataPicpath(resourceGoods.getDataPicpath());
                rsResourceGoodsRe.setGoodsRemark(resourceGoods.getGoodsRemark());
            }
            if (sendData.isPrice()) {
                rsResourceGoodsRe.setPricesetNprice(resourceGoods.getPricesetNprice());
                rsResourceGoodsRe.setPricesetPrefprice(resourceGoods.getPricesetPrefprice());
                rsResourceGoodsRe.setPricesetMakeprice(resourceGoods.getPricesetMakeprice());
                rsResourceGoodsRe.setPricesetAsprice(resourceGoods.getPricesetAsprice());
                rsResourceGoodsRe.setPricesetAllprice(resourceGoods.getPricesetAllprice());
                rsResourceGoodsRe.setPricesetInsideprice(resourceGoods.getPricesetInsideprice());
                rsResourceGoodsRe.setPricesetRefrice(resourceGoods.getPricesetRefrice());
            }
            if (sendData.isUnit()) {
                rsResourceGoodsRe.setPartsnameNumunit(resourceGoods.getPartsnameNumunit());
                rsResourceGoodsRe.setPartsnameNumunit1(resourceGoods.getPartsnameNumunit1());
            }
            RsResourceGoodsDomain rsResourceGoods = this.makeDisGoods(rsResourceGoodsRe, channel);
            rsResourceGoods.setGoodsId(resourceGoodsOld.getGoodsId());
            rsResourceGoods.setGoodsCode(resourceGoodsOld.getGoodsCode());
            this.sendUpdateResourceGoods(rsResourceGoods);
        }
        return "success";
    }

    private RsResourceGoodsReDomain makeReDoamin(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.makeReDoamin.rsResourceGoods");
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.makeReDomain(rsResourceGoods);
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        return rsResourceGoodsReDomain;
    }

    private RsResourceGoodsReDomain makeReDomian(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        try {
            BeanUtils.copyImplPropertys((Object)rsResourceGoodsReDomain, (Object)rsResourceGoods);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.makeReDomian", (Throwable)e);
        }
        return rsResourceGoodsReDomain;
    }

    public RsResourceGoodsReDomain makeReDomain(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.makeReDomian(rsResourceGoods);
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsResourceGoods.getGoodsCode());
        map.put("tenantCode", rsResourceGoods.getTenantCode());
        this.getGoodsRelationInfo(rsResourceGoodsReDomain, map);
        return rsResourceGoodsReDomain;
    }

    private List<RsGoodsFileDomain> makeFileDomainList(List<RsGoodsFile> rsGoodsFileList) {
        if (ListUtil.isEmpty(rsGoodsFileList)) {
            return null;
        }
        ArrayList<RsGoodsFileDomain> rsGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
        for (RsGoodsFile rsGoodsFile : rsGoodsFileList) {
            rsGoodsFileDomainList.add(this.makeRsGoodsFileDomain(rsGoodsFile));
        }
        return rsGoodsFileDomainList;
    }

    private RsGoodsFileDomain makeRsGoodsFileDomain(RsGoodsFile rsGoodsFile) {
        if (null == rsGoodsFile) {
            return null;
        }
        RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsFileDomain;
    }

    private List<RsGoodsRelDomain> makeRsGoodsRelDomainList(List<RsGoodsRel> rsGoodsRelList) {
        if (ListUtil.isEmpty(rsGoodsRelList)) {
            return null;
        }
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        for (RsGoodsRel rsGoodsRel : rsGoodsRelList) {
            rsGoodsRelDomainList.add(this.makeRsGoodsRelDomain(rsGoodsRel));
        }
        return rsGoodsRelDomainList;
    }

    private List<RsPropertiesValueDomain> makeRsPropertiesValueList(List<RsPropertiesValue> rsPropertiesValueList) {
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomainList = new ArrayList<RsPropertiesValueDomain>();
        for (RsPropertiesValue rsPropertiesValue : rsPropertiesValueList) {
            RsPropertiesValueDomain rsPropertiesValueDomain = this.makeRsPropertiesValueDomain(rsPropertiesValue);
            rsPropertiesValueDomainList.add(rsPropertiesValueDomain);
            if (!StringUtils.isBlank((String)rsPropertiesValueDomain.getPropertiesName())) continue;
            pmap.put("propertiesCode", rsPropertiesValue.getPropertiesCode());
            pmap.put("tenantCode", rsPropertiesValue.getTenantCode());
            RsProperties rsProperties = this.rsPropertiesService.getPropertiesByCode(pmap);
            if (null == rsProperties) continue;
            rsPropertiesValueDomain.setPropertiesName(rsProperties.getPropertiesName());
        }
        return rsPropertiesValueDomainList;
    }

    private RsGoodsRelDomain makeRsGoodsRelDomain(RsGoodsRel rsGoodsRel) {
        if (null == rsGoodsRel) {
            return null;
        }
        RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain, (Object)rsGoodsRel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsRelDomain;
    }

    private RsPropertiesValueDomain makeRsPropertiesValueDomain(RsPropertiesValue rsPropertiesValue) {
        if (null == rsPropertiesValue) {
            return null;
        }
        RsPropertiesValueDomain rsPropertiesValueDomain = new RsPropertiesValueDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain, (Object)rsPropertiesValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsPropertiesValueDomain;
    }

    private List<RsSpecValueDomain> makeRsSpecValueDomainList(List<RsSpecValue> rsSpecValueList) {
        if (ListUtil.isEmpty(rsSpecValueList)) {
            return null;
        }
        ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
        for (RsSpecValue rsSpecValue : rsSpecValueList) {
            rsSpecValueDomainList.add(this.makeRsSpecValueDomain(rsSpecValue));
        }
        return rsSpecValueDomainList;
    }

    private RsSpecValueDomain makeRsSpecValueDomain(RsSpecValue rsSpecValue) {
        if (null == rsSpecValue) {
            return null;
        }
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecValueDomain, (Object)rsSpecValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsSpecValueDomain;
    }

    private void getGoodsRelationInfo(RsResourceGoodsReDomain rsResourceGoodsReDomain, Map<String, Object> map) {
        if (null == rsResourceGoodsReDomain || MapUtil.isEmpty(map)) {
            return;
        }
        map.put("order", true);
        map.put("orderStr", "GOODS_FILE_ID asc");
        QueryResult<RsGoodsFile> rsGoodsFileList = this.rsGoodsOtherService.queryGoodsFilePage(map);
        if (null != rsGoodsFileList) {
            rsResourceGoodsReDomain.setRsGoodsFileDomainList(this.makeFileDomainList(rsGoodsFileList.getList()));
        }
        map.remove("order");
        map.remove("orderStr");
        QueryResult<RsGoodsRel> rsGoodsRelList = this.rsGoodsOtherService.queryGoodsRelPage(map);
        if (null != rsGoodsRelList) {
            rsResourceGoodsReDomain.setRsGoodsRelDomainList(this.makeRsGoodsRelDomainList(rsGoodsRelList.getList()));
        }
        map.put("validFlag", "true");
        QueryResult<RsSkuDomain> rsSkuList = this.rsSkuService.querySkuPage(map);
        if (null != rsSkuList.getList() && rsSkuList.getList().size() > 0) {
            rsResourceGoodsReDomain.setRsSkuDomainList(rsSkuList.getList());
        }
        map.remove("validFlag");
        QueryResult<RsPropertiesValue> rsPropertiesValueList = this.rsPropertiesValueService.queryPropertiesValuePage(map);
        if (null != rsPropertiesValueList && !rsPropertiesValueList.getRows().isEmpty()) {
            rsResourceGoodsReDomain.setRsPropertiesValueDomainList(this.makeRsPropertiesValueList(rsPropertiesValueList.getList()));
        }
        map.put("specValueBillno", rsResourceGoodsReDomain.getGoodsCode());
        QueryResult<RsSpecValue> rsSpecValueList = this.rsSpecValueService.querySpecValuePage(map);
        if (null != rsSpecValueList) {
            rsResourceGoodsReDomain.setRsSpecValueDomainList(this.makeRsSpecValueDomainList(rsSpecValueList.getList()));
        }
    }

    private DisChannel getChannel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisChannel memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        return memchannel;
    }

    private RsResourceGoodsDomain makeDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.makeDisGoods.param", (Object)"param is null");
            return null;
        }
        String nowChannelCode = rsResourceGoodsReDomain.getChannelCode();
        if (null == nowChannelCode) {
            nowChannelCode = "";
        }
        if (nowChannelCode.equals(disChannel.getChannelCode())) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.makeDisGoods.nowChannelCode", (Object)nowChannelCode);
            return null;
        }
        RsResourceGoodsDomain disRsResourceGoodsDomain = new RsResourceGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsResourceGoodsDomain, (Object)rsResourceGoodsReDomain);
            disRsResourceGoodsDomain.setGoodsCodeOld(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setChannelCode(disChannel.getChannelCode());
            disRsResourceGoodsDomain.setChannelName(disChannel.getChannelName());
            disRsResourceGoodsDomain.setMemberCode(disChannel.getMemberCode());
            disRsResourceGoodsDomain.setMemberName(disChannel.getMemberName());
            if (StringUtils.isNotBlank((String)disChannel.getGoodsClass())) {
                disRsResourceGoodsDomain.setGoodsClass(disChannel.getGoodsClass());
            }
            disRsResourceGoodsDomain.setMemberMcode(disChannel.getMemberMcode());
            disRsResourceGoodsDomain.setMemberMname(disChannel.getMemberMname());
            disRsResourceGoodsDomain.setMemberCcode(disChannel.getMemberCcode());
            disRsResourceGoodsDomain.setMemberCname(disChannel.getMemberCname());
            disRsResourceGoodsDomain.setGoodsOrigin("11");
            if (null == disChannel.getChannelVer()) {
                disChannel.setChannelVer(0);
            }
            if (null == disRsResourceGoodsDomain.getChannelVer()) {
                disRsResourceGoodsDomain.setChannelVer(0);
            }
            if (disChannel.getChannelVer() - disRsResourceGoodsDomain.getChannelVer() > 0) {
                disRsResourceGoodsDomain.setChannelVer(disChannel.getChannelVer());
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsSpecValueDomainList())) {
                ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
                for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsReDomain.getRsSpecValueDomainList()) {
                    RsSpecValueDomain rsSpecValueDomain1 = new RsSpecValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsSpecValueDomain1, (Object)rsSpecValueDomain);
                    rsSpecValueDomain1.setSpecValueId(null);
                    rsSpecValueDomain1.setSpecValueCode(this.createUUIDString());
                    rsSpecValueDomainList.add(rsSpecValueDomain1);
                }
                disRsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsFileDomainList())) {
                ArrayList<RsGoodsFileDomain> rsGoodsFileDomains = new ArrayList<RsGoodsFileDomain>();
                for (RsGoodsFileDomain rsGoodsFileDomain : rsResourceGoodsReDomain.getRsGoodsFileDomainList()) {
                    RsGoodsFileDomain rsGoodsFileDomain1 = new RsGoodsFileDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain1, (Object)rsGoodsFileDomain);
                    rsGoodsFileDomain1.setGoodsFileId(null);
                    rsGoodsFileDomain1.setGoodsFileCode(this.createUUIDString());
                    rsGoodsFileDomain1.setGoodsCode(null);
                    rsGoodsFileDomain1.setSkuCode(null);
                    rsGoodsFileDomains.add(rsGoodsFileDomain1);
                }
                disRsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileDomains);
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsRelDomainList())) {
                ArrayList<RsGoodsRelDomain> rsGoodsRelDomains = new ArrayList<RsGoodsRelDomain>();
                for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                    RsGoodsRelDomain rsGoodsRelDomain1 = new RsGoodsRelDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain1, (Object)rsGoodsRelDomain);
                    rsGoodsRelDomain1.setGoodsRelId(null);
                    rsGoodsRelDomain1.setGoodsRelCode(this.createUUIDString());
                    rsGoodsRelDomains.add(rsGoodsRelDomain1);
                }
                disRsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomains);
            }
            if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsPropertiesValueDomainList())) {
                ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomains = new ArrayList<RsPropertiesValueDomain>();
                for (RsPropertiesValueDomain rsPropertiesValueDomain : rsResourceGoodsReDomain.getRsPropertiesValueDomainList()) {
                    RsPropertiesValueDomain rsPropertiesValueDomain1 = new RsPropertiesValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain1, (Object)rsPropertiesValueDomain);
                    rsPropertiesValueDomain1.setPropertiesValueId(null);
                    rsPropertiesValueDomain1.setPropertiesValueCode(this.createUUIDString());
                    rsPropertiesValueDomains.add(rsPropertiesValueDomain1);
                }
                disRsResourceGoodsDomain.setRsPropertiesValueDomainList(rsPropertiesValueDomains);
            }
            disRsResourceGoodsDomain.setRsSkuDomainList(this.makeDisSkuList(rsResourceGoodsReDomain.getRsSkuDomainList(), rsResourceGoodsReDomain, disChannel, disRsResourceGoodsDomain));
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.makeDisGoods.e", (Object)(rsResourceGoodsReDomain.getGoodsCode() + "=" + disChannel.getChannelCode() + "=" + disChannel.getChannelName()), (Throwable)e);
            return null;
        }
        return disRsResourceGoodsDomain;
    }

    private List<RsSkuDomain> makeDisSkuList(List<RsSkuDomain> rsSkuDomainList, RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel, RsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (ListUtil.isEmpty(rsSkuDomainList) || null == disChannel || null == disRsResourceGoodsDomain) {
            return null;
        }
        ArrayList<RsSkuDomain> disRsSkuDomainList = new ArrayList<RsSkuDomain>();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            RsSkuDomain disRsSkuDomain = this.makeDisSku(rsResourceGoodsReDomain, rsSkuDomain, disChannel, disRsResourceGoodsDomain);
            if (null == disRsSkuDomain) continue;
            disRsSkuDomainList.add(disRsSkuDomain);
        }
        return disRsSkuDomainList;
    }

    private RsSkuDomain makeDisSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, DisChannel disChannel, RsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (null == rsResourceGoodsReDomain || null == disChannel || null == disRsResourceGoodsDomain) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.makeDisSku.param.");
            return null;
        }
        rsSkuDomain.setMemberCcode(rsResourceGoodsReDomain.getMemberCcode());
        rsSkuDomain.setMemberCname(rsResourceGoodsReDomain.getMemberCname());
        rsSkuDomain.setMemberMcode(disRsResourceGoodsDomain.getMemberMcode());
        rsSkuDomain.setMemberMname(disRsResourceGoodsDomain.getMemberMname());
        rsSkuDomain.setGoodsOrigin(rsResourceGoodsReDomain.getGoodsOrigin());
        RsSkuDomain disRsSkuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsSkuDomain);
            disRsSkuDomain.setMemberBcode(disRsResourceGoodsDomain.getMemberBcode());
            disRsSkuDomain.setMemberBname(disRsResourceGoodsDomain.getMemberBname());
            disRsSkuDomain.setSkuCodeOld(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setSkuOldcode(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsSkuDomain.setChannelCode(disChannel.getChannelCode());
            disRsSkuDomain.setChannelName(disChannel.getChannelName());
            disRsSkuDomain.setMemberCode(disChannel.getMemberCode());
            disRsSkuDomain.setMemberName(disChannel.getMemberName());
            if (StringUtils.isNotBlank((String)disChannel.getGoodsClass())) {
                disRsSkuDomain.setGoodsClass(disChannel.getGoodsClass());
            }
            if (null == disChannel.getChannelVer()) {
                disChannel.setChannelVer(0);
            }
            disRsSkuDomain.setChannelVer(disChannel.getChannelVer());
            if (null == disRsResourceGoodsDomain.getChannelVer()) {
                disRsResourceGoodsDomain.setChannelVer(0);
            }
            if (disChannel.getChannelVer() - disRsResourceGoodsDomain.getChannelVer() > 0) {
                disRsSkuDomain.setChannelVer(disChannel.getChannelVer());
            }
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.makeDisSku.e", (Throwable)e);
            return null;
        }
        disRsSkuDomain.setPricesetPro(rsSkuDomain.getPricesetPro());
        try {
            ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomains = new ArrayList<RsPropertiesValueDomain>();
            if (null != rsSkuDomain.getPropertiesList() && rsSkuDomain.getPropertiesList().size() > 0) {
                for (RsPropertiesValueDomain rsPropertiesValueDomain : rsSkuDomain.getPropertiesList()) {
                    RsPropertiesValueDomain rsPropertiesValueDomain2 = new RsPropertiesValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain2, (Object)rsPropertiesValueDomain);
                    rsPropertiesValueDomain2.setPropertiesValueId(null);
                    rsPropertiesValueDomain2.setPropertiesValueCode(this.createUUIDString());
                    rsPropertiesValueDomains.add(rsPropertiesValueDomain2);
                }
            }
            disRsSkuDomain.setPropertiesList(rsPropertiesValueDomains);
            ArrayList<RsSpecValueDomain> rsSpecValueDomains = new ArrayList<RsSpecValueDomain>();
            if (null != rsSkuDomain.getSpecList() && rsSkuDomain.getSpecList().size() > 0) {
                for (RsSpecValueDomain rsSpecValueDomain : rsSkuDomain.getSpecList()) {
                    RsSpecValueDomain rsSpecValueDomain1 = new RsSpecValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsSpecValueDomain1, (Object)rsSpecValueDomain);
                    rsSpecValueDomain1.setSpecValueId(null);
                    rsSpecValueDomain1.setSpecValueCode(this.createUUIDString());
                    rsSpecValueDomains.add(rsSpecValueDomain1);
                }
            }
            disRsSkuDomain.setSpecList(rsSpecValueDomains);
            ArrayList<RsGoodsFileDomain> arrayList = new ArrayList<RsGoodsFileDomain>();
            if (null != rsSkuDomain.getRsGoodsFileDomainList() && rsSkuDomain.getRsGoodsFileDomainList().size() > 0) {
                for (RsGoodsFileDomain rsGoodsFileDomain : rsSkuDomain.getRsGoodsFileDomainList()) {
                    RsGoodsFileDomain rsGoodsFileDomain1 = new RsGoodsFileDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain1, (Object)rsGoodsFileDomain);
                    rsGoodsFileDomain1.setGoodsFileId(null);
                    rsGoodsFileDomain1.setGoodsFileCode(this.createUUIDString());
                    rsGoodsFileDomain1.setGoodsCode(null);
                    rsGoodsFileDomain1.setSkuCode(null);
                    arrayList.add(rsGoodsFileDomain1);
                }
            }
            disRsSkuDomain.setRsGoodsFileDomainList(arrayList);
            ArrayList<RsGoodsRelDomain> arrayList2 = new ArrayList<RsGoodsRelDomain>();
            if (null != rsSkuDomain.getRsGoodsRelDomainList() && rsSkuDomain.getRsGoodsRelDomainList().size() > 0) {
                for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
                    RsGoodsRelDomain rsGoodsRelDomain1 = new RsGoodsRelDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain1, (Object)rsGoodsRelDomain);
                    rsGoodsRelDomain1.setGoodsRelId(null);
                    rsGoodsRelDomain1.setGoodsRelCode(this.createUUIDString());
                    arrayList2.add(rsGoodsRelDomain1);
                }
            }
            disRsSkuDomain.setRsGoodsRelDomainList(arrayList2);
        }
        catch (Exception e) {
            this.logger.error("rs.RsResourceGoodsNewServiceImpl.makeDisSku.e", (Object)(disChannel.getChannelCode() + "=" + disChannel.getChannelName()), (Throwable)e);
            return null;
        }
        return disRsSkuDomain;
    }

    static {
        oplock = new Object();
    }
}

