/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsSkuMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsBuyDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsPriceDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.model.RsFlowdata;
import com.yqbsoft.laser.service.resources.model.RsGoodsFile;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.send.OpEsEnginePutThread;
import com.yqbsoft.laser.service.resources.service.RsGoodsBuyService;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsGoodsPriceService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.resources.service.RsSkuNewService;
import com.yqbsoft.laser.service.resources.service.RsSkuOneService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.resources.service.impl.RsResourceGoodsNewServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.FileType;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class RsSkuNewServiceImpl
extends BaseServiceImpl
implements RsSkuNewService {
    public static final String SYS_CODE = "rs.RsSkuNewServiceImpl";
    private RsSkuMapper rsSkuMapper;
    private RsSpecValueService rsSpecValueService;
    private RsGoodsOtherService rsGoodsOtherService;
    private RsSenddataBaseService rsSenddataBaseService;
    private RsSkuOneService rsSkuOneService;
    private RsGoodsBuyService rsGoodsBuyService;
    private RsGoodsPriceService rsGoodsPriceService;
    private RsSkuService rsSkuService;

    public RsSkuService getRsSkuService() {
        return this.rsSkuService;
    }

    public void setRsSkuService(RsSkuService rsSkuService) {
        this.rsSkuService = rsSkuService;
    }

    public RsSkuMapper getRsSkuMapper() {
        return this.rsSkuMapper;
    }

    public void setRsSkuMapper(RsSkuMapper rsSkuMapper) {
        this.rsSkuMapper = rsSkuMapper;
    }

    public RsSpecValueService getRsSpecValueService() {
        return this.rsSpecValueService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public RsGoodsOtherService getRsGoodsOtherService() {
        return this.rsGoodsOtherService;
    }

    public void setRsGoodsOtherService(RsGoodsOtherService rsGoodsOtherService) {
        this.rsGoodsOtherService = rsGoodsOtherService;
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        return this.rsSenddataBaseService;
    }

    public void setRsSenddataBaseService(RsSenddataBaseService rsSenddataBaseService) {
        this.rsSenddataBaseService = rsSenddataBaseService;
    }

    public RsSkuOneService getRsSkuOneService() {
        return this.rsSkuOneService;
    }

    public void setRsSkuOneService(RsSkuOneService rsSkuOneService) {
        this.rsSkuOneService = rsSkuOneService;
    }

    public RsGoodsBuyService getRsGoodsBuyService() {
        return this.rsGoodsBuyService;
    }

    public void setRsGoodsBuyService(RsGoodsBuyService rsGoodsBuyService) {
        this.rsGoodsBuyService = rsGoodsBuyService;
    }

    public RsGoodsPriceService getRsGoodsPriceService() {
        return this.rsGoodsPriceService;
    }

    public void setRsGoodsPriceService(RsGoodsPriceService rsGoodsPriceService) {
        this.rsGoodsPriceService = rsGoodsPriceService;
    }

    private String checkSku(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (null == rsSkuDomain.getPricesetNprice() || rsSkuDomain.getPricesetNprice().compareTo(BigDecimal.ZERO) < 0) {
            return "\u4ef7\u683c\u4fe1\u606f\u6709\u8bef";
        }
        if (null == rsSkuDomain.getGoodsNum() || rsSkuDomain.getGoodsNum().compareTo(BigDecimal.ZERO) < 0) {
            return "\u5e93\u5b58\u4fe1\u606f\u6709\u8bef";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSkuName())) {
            msg = msg + "sku\u540d\u79f0\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getGoodsCode())) {
            msg = msg + "\u5546\u54c1\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isNotBlank((String)rsSkuDomain.getGoodsPro()) && "5".equals(rsSkuDomain.getGoodsPro()) && ListUtil.isEmpty(rsSkuDomain.getRsGoodsRelDomainList())) {
            msg = msg + "\u7ec4\u5408\u5546\u54c1\u5185\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return msg;
    }

    private RsSku makeSku(RsSkuDomain rsSkuDomain, RsSku rsSku) {
        if (null == rsSkuDomain) {
            return null;
        }
        if (null == rsSku) {
            rsSku = new RsSku();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSku, (Object)rsSkuDomain);
            return rsSku;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuNewServiceImpl.makeSku", (Throwable)e);
            if (null == rsSku.getGoodsNum()) {
                rsSku.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsWeight()) {
                rsSku.setGoodsWeight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsSupplynum()) {
                rsSku.setGoodsSupplynum(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsSupplyweight()) {
                rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsOneweight()) {
                rsSku.setGoodsOneweight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsMinnum() || rsSku.getGoodsMinnum().compareTo(BigDecimal.ZERO) == 0) {
                rsSku.setGoodsMinnum(new BigDecimal("1"));
            }
            if (rsSku.getGoodsNum().compareTo(BigDecimal.ZERO) != 0 && rsSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) == 0) {
                rsSku.setGoodsSupplynum(rsSku.getGoodsNum());
                rsSku.setGoodsSupplyweight(rsSku.getGoodsWeight());
            }
            if (rsSku.getGoodsNum().compareTo(BigDecimal.ZERO) == 0 && rsSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) != 0) {
                rsSku.setGoodsNum(rsSku.getGoodsSupplynum());
                rsSku.setGoodsWeight(rsSku.getGoodsSupplyweight());
            }
            if (rsSku.getGoodsWeight().compareTo(BigDecimal.ZERO) == 0 && rsSku.getGoodsOneweight().compareTo(BigDecimal.ZERO) != 0) {
                rsSku.setGoodsWeight(rsSku.getGoodsNum().multiply(rsSku.getGoodsOneweight()));
                rsSku.setGoodsSupplyweight(rsSku.getGoodsWeight());
            }
            return null;
        }
    }

    private Date getSysDate() {
        try {
            return this.rsSkuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuNewServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void makeDefSku(RsSku rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        BigDecimal goodsNum = rsResourceGoods.getGoodsNum();
        BigDecimal goodsWeight = rsResourceGoods.getGoodsWeight();
        BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
        BigDecimal goodsAhweight = rsResourceGoods.getGoodsAhweight();
        BigDecimal goodsSupplynum = rsResourceGoods.getGoodsSupplynum();
        BigDecimal goodsSupplyweight = rsResourceGoods.getGoodsSupplyweight();
        BigDecimal goodsHangnum = rsResourceGoods.getGoodsHangnum();
        BigDecimal goodsHangweight = rsResourceGoods.getGoodsHangweight();
        rsResourceGoods.setPricesetMakeprice(rsResourceGoods.getPricesetMakeprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetMakeprice());
        rsResourceGoods.setPricesetBaseprice(rsResourceGoods.getPricesetBaseprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetBaseprice());
        rsResourceGoods.setPricesetAsprice(rsResourceGoods.getPricesetAsprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetAsprice());
        rsResourceGoods.setPricesetPrefprice(rsResourceGoods.getPricesetPrefprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetPrefprice());
        rsResourceGoods.setPricesetRefrice(rsResourceGoods.getPricesetRefrice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetRefrice());
        rsResourceGoods.setPricesetInsideprice(rsResourceGoods.getPricesetInsideprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetInsideprice());
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
        rsResourceGoods.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
        rsResourceGoods.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
        rsResourceGoods.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
        rsResourceGoods.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
        rsResourceGoods.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
        rsResourceGoods.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
    }

    public RsSku getSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuNewServiceImpl.getSkuModelByCode", (Object)map.toString(), (Throwable)e);
            return null;
        }
    }

    private void setSkuDefault(RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        if (null == rsSku.getDataState()) {
            rsSku.setDataState(0);
        }
        if (null == rsSku.getDataOpbillstate()) {
            rsSku.setDataOpbillstate(0);
        }
        if (null == rsSku.getDataOpnextbillstate()) {
            rsSku.setDataOpnextbillstate(0);
        }
        Date date = this.getSysDate();
        if (null == rsSku.getGmtCreate()) {
            rsSku.setGmtCreate(date);
        }
        if (null == rsSku.getGoodsNum()) {
            rsSku.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == rsSku.getGoodsWeight()) {
            rsSku.setGoodsWeight(BigDecimal.ZERO);
        }
        rsSku.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSku.getSkuCode())) {
            String skuCode = this.getNo(null, RsSku.class.getSimpleName(), "skuCode", rsSku.getTenantCode());
            rsSku.setSkuCode(skuCode);
        }
        if (StringUtils.isBlank((String)rsSku.getSkuShowno())) {
            rsSku.setSkuShowno(rsSku.getSkuNo());
        }
        this.makeDefSku(rsSku);
        if (ResourcesConstants.DATA_OPBILLSTATE_1.intValue() == rsSku.getDataOpbillstate().intValue()) {
            rsSku.setSkuHdate(this.getSysDate());
        }
        if (null == rsSku.getPricesetChannenprice()) {
            rsSku.setPricesetChannenprice(rsSku.getPricesetNprice1());
        }
        if (StringUtils.isBlank((String)rsSku.getGoodsOldcode())) {
            rsSku.setGoodsOldcode("-1");
        }
        if (StringUtils.isBlank((String)rsSku.getSkuOldcode())) {
            rsSku.setSkuOldcode("-1");
        }
    }

    private void updateSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            this.rsSkuMapper.updateByPrimaryKeySelective(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuNewServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private void saveSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            this.rsSkuMapper.insert(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuNewServiceImpl.saveSkuModel.ex", (Throwable)e);
        }
    }

    private void saveSpecList(RsSkuDomain rsSkuDomain) {
        if (ListUtil.isEmpty(rsSkuDomain.getSpecList())) {
            return;
        }
        for (RsSpecValueDomain rsSpecValueDomain : rsSkuDomain.getSpecList()) {
            rsSpecValueDomain.setSpecValueBillno(rsSkuDomain.getGoodsCode());
        }
        this.rsSpecValueService.saveSpecValueList(rsSkuDomain.getSpecList());
    }

    private void saveSkufile(RsSku rsSku) {
        if (null == rsSku || ListUtil.isEmpty(rsSku.getRsGoodsFileDomainList())) {
            return;
        }
        ArrayList<RsGoodsFileDomain> rsskuGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
        for (RsGoodsFileDomain rsGoodsFileDomain : rsSku.getRsGoodsFileDomainList()) {
            if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            rsGoodsFileDomain.setSkuCode(rsSku.getSkuCode());
            rsGoodsFileDomain.setGoodsCode(null);
            rsGoodsFileDomain.setTenantCode(rsSku.getTenantCode());
            rsGoodsFileDomain.setMemberCode(rsSku.getMemberCode());
            rsGoodsFileDomain.setMemberName(rsSku.getMemberName());
            rsGoodsFileDomain.setGoodsFileCode(null);
            rsskuGoodsFileDomainList.add(rsGoodsFileDomain);
            rsGoodsFileDomain.setGoodsFileId(null);
        }
        this.rsGoodsOtherService.saveGoodsFileList(rsskuGoodsFileDomainList);
    }

    private RsSku saveSkuMode(RsSkuDomain rsSkuDomain) {
        RsSku oldRsSku;
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuNewServiceImpl.saveSku.checkSku", msg);
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, null);
        if (null != rsSkuDomain.getOldDataState()) {
            rsSku.setDataState(rsSkuDomain.getOldDataState());
        }
        this.setSkuDefault(rsSku);
        if (StringUtils.isNotBlank((String)rsSkuDomain.getSkuCode()) && null != (oldRsSku = this.getSkuModelByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{rsSkuDomain.getSkuCode(), rsSkuDomain.getTenantCode()})))) {
            rsSku.setSkuId(oldRsSku.getSkuId());
        }
        if (null != rsSku.getSkuId()) {
            this.updateSkuModel(rsSku);
        } else {
            this.saveSkuModel(rsSku);
        }
        return rsSku;
    }

    private void saveSkuBuy(RsSkuDomain rsSkuDomain) {
        if (!rsSkuDomain.isRsGoodsBuyDomainFlag()) {
            return;
        }
        if (ListUtil.isEmpty(rsSkuDomain.getRsGoodsBuyDomainList())) {
            return;
        }
        if (ListUtil.isNotEmpty(rsSkuDomain.getRsGoodsBuyDomainList())) {
            ArrayList<RsGoodsBuyDomain> rsskuGoodsBuyDomainList = new ArrayList<RsGoodsBuyDomain>();
            for (RsGoodsBuyDomain rsGoodsBuyDomain : rsSkuDomain.getRsGoodsBuyDomainList()) {
                rsGoodsBuyDomain.setSkuCode(rsSkuDomain.getSkuCode());
                rsGoodsBuyDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
                rsGoodsBuyDomain.setTenantCode(rsSkuDomain.getTenantCode());
                rsGoodsBuyDomain.setMemberCode(rsSkuDomain.getMemberCode());
                rsGoodsBuyDomain.setMemberName(rsSkuDomain.getMemberName());
                rsGoodsBuyDomain.setGoodsBuyCode(null);
                rsskuGoodsBuyDomainList.add(rsGoodsBuyDomain);
                rsGoodsBuyDomain.setGoodsBuyId(null);
                rsGoodsBuyDomain.setMemberCode(rsSkuDomain.getMemberCode());
                rsGoodsBuyDomain.setMemberName(rsSkuDomain.getMemberName());
                rsGoodsBuyDomain.setChannelCode(rsSkuDomain.getChannelCode());
                rsGoodsBuyDomain.setChannelName(rsSkuDomain.getChannelName());
                rsGoodsBuyDomain.setGoodsClass(rsSkuDomain.getGoodsClass());
            }
            this.rsGoodsBuyService.saveGoodsBuyBatch(rsskuGoodsBuyDomainList);
        }
    }

    private void saveSkuPrice(RsSkuDomain rsSkuDomain) {
        if (ListUtil.isEmpty(rsSkuDomain.getRsGoodsPriceDomainList())) {
            return;
        }
        ArrayList<RsGoodsPriceDomain> rsskuGoodsPriceDomainList = new ArrayList<RsGoodsPriceDomain>();
        for (RsGoodsPriceDomain rsGoodsPriceDomain : rsSkuDomain.getRsGoodsPriceDomainList()) {
            rsGoodsPriceDomain.setSkuCode(rsSkuDomain.getSkuCode());
            rsGoodsPriceDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
            rsGoodsPriceDomain.setTenantCode(rsSkuDomain.getTenantCode());
            rsGoodsPriceDomain.setMemberCode(rsSkuDomain.getMemberCode());
            rsGoodsPriceDomain.setMemberName(rsSkuDomain.getMemberName());
            rsGoodsPriceDomain.setGoodsPriceCode(null);
            rsskuGoodsPriceDomainList.add(rsGoodsPriceDomain);
            rsGoodsPriceDomain.setGoodsPriceId(null);
            rsGoodsPriceDomain.setMemberCode(rsSkuDomain.getMemberCode());
            rsGoodsPriceDomain.setMemberName(rsSkuDomain.getMemberName());
            rsGoodsPriceDomain.setChannelCode(rsSkuDomain.getChannelCode());
            rsGoodsPriceDomain.setChannelName(rsSkuDomain.getChannelName());
        }
        this.rsGoodsPriceService.saveRsGoodsPriceBatch(rsskuGoodsPriceDomainList);
    }

    private void saveSkuRel(RsSkuDomain rsSkuDomain) {
        if (ListUtil.isEmpty(rsSkuDomain.getRsGoodsRelDomainList())) {
            return;
        }
        for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
            rsGoodsRelDomain.setGoodsCode("");
            rsGoodsRelDomain.setGoodsRelId(null);
            rsGoodsRelDomain.setGoodsRelCode(null);
            rsGoodsRelDomain.setGoodsSkuCode(rsSkuDomain.getSkuCode());
            rsGoodsRelDomain.setTenantCode(rsSkuDomain.getTenantCode());
            rsGoodsRelDomain.setMemberCode(rsSkuDomain.getMemberCode());
            rsGoodsRelDomain.setMemberName(rsSkuDomain.getMemberName());
            rsGoodsRelDomain.setMemberCcode(rsSkuDomain.getMemberCcode());
            rsGoodsRelDomain.setMemberCname(rsSkuDomain.getMemberCname());
            rsGoodsRelDomain.setMemberMcode(rsSkuDomain.getMemberMcode());
            rsGoodsRelDomain.setMemberMname(rsSkuDomain.getMemberMname());
            rsGoodsRelDomain.setChannelCode(rsSkuDomain.getChannelCode());
            rsGoodsRelDomain.setChannelName(rsSkuDomain.getChannelName());
            rsGoodsRelDomain.setGoodsClass(rsSkuDomain.getGoodsClass());
        }
        this.rsGoodsOtherService.saveGoodsRelList(rsSkuDomain.getRsGoodsRelDomainList());
    }

    private void saveSkuOne(RsSkuDomain rsSkuDomain) {
        if (ListUtil.isEmpty(rsSkuDomain.getRsGoodsRelDomainList())) {
            return;
        }
        if (null != rsSkuDomain.getRsSkuOneDomain()) {
            rsSkuDomain.getRsSkuOneDomain().setTenantCode(rsSkuDomain.getTenantCode());
            rsSkuDomain.getRsSkuOneDomain().setGoodsName(rsSkuDomain.getGoodsName());
            rsSkuDomain.getRsSkuOneDomain().setGoodsNo(rsSkuDomain.getGoodsNo());
            rsSkuDomain.getRsSkuOneDomain().setChannelCode(rsSkuDomain.getChannelCode());
            rsSkuDomain.getRsSkuOneDomain().setChannelName(rsSkuDomain.getChannelName());
            rsSkuDomain.getRsSkuOneDomain().setSkuOneValueno(rsSkuDomain.getSkuCode());
            rsSkuDomain.getRsSkuOneDomain().setSkuNo(rsSkuDomain.getSkuNo());
            this.rsSkuOneService.saveOrUpdateSkuOneAndSkuOneList(rsSkuDomain.getRsSkuOneDomain());
        }
    }

    private RsSku saveSkuDomain(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return null;
        }
        this.makePic(rsSkuDomain);
        RsSku rsSku = this.saveSkuMode(rsSkuDomain);
        rsSkuDomain.setSkuCode(rsSku.getSkuCode());
        this.saveSkufile(rsSku);
        this.saveSpecList(rsSkuDomain);
        this.saveSkuRel(rsSkuDomain);
        return rsSku;
    }

    private void makePic(RsSkuDomain rsSkuDomain) {
        if (ListUtil.isEmpty(rsSkuDomain.getRsGoodsFileDomainList())) {
            return;
        }
        String dataPic = rsSkuDomain.getRsGoodsFileDomainList().get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsSkuDomain.getRsGoodsFileDomainList()) {
            if (null == rsGoodsFileDomain || StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            if (rsGoodsFileDomain.getDefaultState() == null || rsGoodsFileDomain.getDefaultState() != 1) continue;
            dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            break;
        }
        rsSkuDomain.setDataPic(dataPic);
    }

    @Override
    public void saveSkuBatch(List<RsSkuDomain> rsSkuList) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty()) {
            throw new ApiException("rs.RsSkuNewServiceImpl.saveSkuListRe.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            this.saveSkuDomain(rsSkuDomain);
        }
    }

    @Override
    public void updateSkuList(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods) throws ApiException {
        this.saveSkuListRe(rsSkuList, rsResourceGoods);
    }

    public void saveSkuListRe(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods) throws ApiException {
        if (ListUtil.isEmpty(rsSkuList) || null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuNewServiceImpl.saveSkuListRe.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, String> skuCodeMap = new HashMap<String, String>();
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            if (!StringUtils.isNotBlank((String)rsSkuDomain.getSkuCode())) continue;
            skuCodeMap.put(rsSkuDomain.getSkuCode(), rsSkuDomain.getSkuCode());
        }
        this.deleteSkuByGoodsCode(rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode(), skuCodeMap);
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            this.saveSkuDomain(rsSkuDomain);
        }
    }

    private List<RsSku> querySkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuNewServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuNewServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    private List<RsSkuDomain> makeRsSkuDomainList(List<RsSku> rsSkuList) {
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        for (RsSku rsSku : rsSkuList) {
            RsSkuDomain rsSkuDomain = this.makeRsSkuDomain(rsSku);
            rsSkuDomainList.add(rsSkuDomain);
        }
        return rsSkuDomainList;
    }

    private RsSkuDomain makeRsSkuDomain(RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rsSkuDomain.setOldDataState(rsSku.getDataState());
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("skuCode", rsSku.getSkuCode());
        map1.put("tenantCode", rsSku.getTenantCode());
        map1.put("order", true);
        map1.put("orderStr", "GOODS_FILE_ID asc");
        QueryResult<RsGoodsFile> rsSkuFileList = this.rsGoodsOtherService.queryGoodsFilePage(map1);
        if (null != rsSkuFileList) {
            rsSkuDomain.setRsGoodsFileDomainList(this.makeFileDomainList(rsSkuFileList.getList()));
        }
        map1.remove("order");
        map1.remove("orderStr");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("goodsSkuCode", rsSku.getSkuCode());
        map2.put("tenantCode", rsSku.getTenantCode());
        QueryResult<RsGoodsRel> rsSkuRelList = this.rsGoodsOtherService.queryGoodsRelPage(map2);
        if (null != rsSkuRelList) {
            rsSkuDomain.setRsGoodsRelDomainList(this.makeRsGoodsRelDomainList(rsSkuRelList.getList()));
        }
        return rsSkuDomain;
    }

    private List<RsGoodsRelDomain> makeRsGoodsRelDomainList(List<RsGoodsRel> rsGoodsRelList) {
        if (ListUtil.isEmpty(rsGoodsRelList)) {
            return null;
        }
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        for (RsGoodsRel rsGoodsRel : rsGoodsRelList) {
            rsGoodsRelDomainList.add(this.makeRsGoodsRelDomain(rsGoodsRel));
        }
        return rsGoodsRelDomainList;
    }

    private RsGoodsRelDomain makeRsGoodsRelDomain(RsGoodsRel rsGoodsRel) {
        if (null == rsGoodsRel) {
            return null;
        }
        RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain, (Object)rsGoodsRel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsRelDomain;
    }

    @Override
    public QueryResult<RsSkuDomain> querySkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        List<RsSkuDomain> rsSkuDomainList = this.makeRsSkuDomainList(rsSkuList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(ListUtil.isEmpty(rsSkuList) ? 0 : this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuDomainList);
        return queryResult;
    }

    private void deleteSkuModel(Integer skuId) throws ApiException {
        if (null == skuId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.deleteByPrimaryKey(skuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuNewServiceImpl.deleteSkuModel.ex", skuId + "", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuNewServiceImpl.deleteSkuModel.num");
        }
    }

    private void deleteSkuData(String skuCode, String tenantCode) {
        if (StringUtil.isBlank((String)skuCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        map.put("goodsSkuCode", skuCode);
        map.remove("skuCode");
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
    }

    @Override
    public void deleteSkuByGoodsCode(String goodsCode, String tenantCode, Map<String, String> skuCodeMap) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (ListUtil.isEmpty(rsSkuList)) {
            return;
        }
        RsFlowdata flowdata = null;
        ArrayList<RsFlowdata> rsFlowdataList = new ArrayList<RsFlowdata>();
        for (RsSku rsSku : rsSkuList) {
            if (MapUtil.isNotEmpty(skuCodeMap) && StringUtils.isNotBlank((String)skuCodeMap.get(rsSku.getSkuCode()))) continue;
            this.deleteSkuModel(rsSku.getSkuId());
            this.deleteSkuData(rsSku.getSkuCode(), rsSku.getTenantCode());
            flowdata = new RsFlowdata();
            flowdata.setTenantCode(rsSku.getTenantCode());
            flowdata.setEsrequestType("delete");
            flowdata.setChannelsendApiApicode("dataUpdateNew");
            flowdata.setFdBizcode(rsSku.getSkuCode());
            rsFlowdataList.add(flowdata);
        }
        List<RsFlowdata> rsFlowdata = this.getRsSenddataBaseService().sendFlowdataBatch(rsFlowdataList);
        if (ListUtil.isNotEmpty(rsFlowdata)) {
            RsResourceGoodsNewServiceImpl.getOpEsEngineService().addPutPool(new OpEsEnginePutThread(RsResourceGoodsNewServiceImpl.getOpEsEngineService(), rsFlowdata));
        }
    }

    private List<RsGoodsFileDomain> makeFileDomainList(List<RsGoodsFile> rsGoodsFileList) {
        if (ListUtil.isEmpty(rsGoodsFileList)) {
            return null;
        }
        ArrayList<RsGoodsFileDomain> rsGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
        for (RsGoodsFile rsGoodsFile : rsGoodsFileList) {
            rsGoodsFileDomainList.add(this.makeRsGoodsFileDomain(rsGoodsFile));
        }
        return rsGoodsFileDomainList;
    }

    private RsGoodsFileDomain makeRsGoodsFileDomain(RsGoodsFile rsGoodsFile) {
        if (null == rsGoodsFile) {
            return null;
        }
        RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsFileDomain;
    }
}

