/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsFlowdataFinishMapper;
import com.yqbsoft.laser.service.resources.dao.RsFlowdataMapper;
import com.yqbsoft.laser.service.resources.dao.RsResourceGoodsMapper;
import com.yqbsoft.laser.service.resources.dao.RsSenddataMapper;
import com.yqbsoft.laser.service.resources.dao.RsSkuMapper;
import com.yqbsoft.laser.service.resources.domain.FlowReBean;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddatabakDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsDisflowdata;
import com.yqbsoft.laser.service.resources.model.RsFlowdata;
import com.yqbsoft.laser.service.resources.model.RsFlowdataFinish;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.service.RsGoodsSendService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsNewService;
import com.yqbsoft.laser.service.resources.service.RsSenddataService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsSendServiceImpl
extends BaseServiceImpl
implements RsGoodsSendService {
    public static final String SYS_CODE = "rs.RsGoodsSendServiceImpl";
    private RsFlowdataMapper rsFlowdataMapper;
    private RsSenddataMapper rsSenddataMapper;
    private RsSkuMapper rsSkuMapper;
    private RsResourceGoodsMapper rsResourceGoodsMapper;
    private RsResourceGoodsNewService rsResourceGoodsNewService;
    private RsSenddataService rsSenddataService;
    private RsFlowdataFinishMapper rsFlowdataFinishMapper;

    public RsSenddataService getRsSenddataService() {
        return this.rsSenddataService;
    }

    public void setRsSenddataService(RsSenddataService rsSenddataService) {
        this.rsSenddataService = rsSenddataService;
    }

    public RsSenddataMapper getRsSenddataMapper() {
        return this.rsSenddataMapper;
    }

    public void setRsSenddataMapper(RsSenddataMapper rsSenddataMapper) {
        this.rsSenddataMapper = rsSenddataMapper;
    }

    public RsResourceGoodsNewService getRsResourceGoodsNewService() {
        return this.rsResourceGoodsNewService;
    }

    public void setRsResourceGoodsNewService(RsResourceGoodsNewService rsResourceGoodsNewService) {
        this.rsResourceGoodsNewService = rsResourceGoodsNewService;
    }

    public RsResourceGoodsMapper getRsResourceGoodsMapper() {
        return this.rsResourceGoodsMapper;
    }

    public void setRsResourceGoodsMapper(RsResourceGoodsMapper rsResourceGoodsMapper) {
        this.rsResourceGoodsMapper = rsResourceGoodsMapper;
    }

    public RsSkuMapper getRsSkuMapper() {
        return this.rsSkuMapper;
    }

    public void setRsSkuMapper(RsSkuMapper rsSkuMapper) {
        this.rsSkuMapper = rsSkuMapper;
    }

    public RsFlowdataMapper getRsFlowdataMapper() {
        return this.rsFlowdataMapper;
    }

    public void setRsFlowdataMapper(RsFlowdataMapper rsFlowdataMapper) {
        this.rsFlowdataMapper = rsFlowdataMapper;
    }

    private void updateStateFlowdataModel(String fdCode, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        if (null == fdCode || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fdCode", fdCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.rsFlowdataMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSendServiceImpl.updateStateDisSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsSendServiceImpl.updateStateDisSkuModel.null", JsonUtil.buildNonDefaultBinder().toJson(map));
        }
    }

    private int deleteFlowData(String fdCode, String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)fdCode) || StringUtils.isEmpty((String)tenantCode)) {
            return 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fdCode", fdCode);
        map.put("tenantCode", tenantCode);
        try {
            int i = this.rsFlowdataMapper.delByCode(map);
            if (i < 0) {
                this.logger.error("rs.RsGoodsSendServiceImpl.deleteFlowData.i", (Object)((Object)map).toString());
            }
            return i;
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSendServiceImpl.deleteFlowData.ex", (Throwable)e);
        }
    }

    private void deleteStateSenddataModel(String senddataCode, String tenantCode) throws ApiException {
        if (null == senddataCode || null == tenantCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("senddataCode", senddataCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.rsSenddataMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSendServiceImpl.deleteStateSenddataModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsSendServiceImpl.deleteStateSenddataModel.null", JsonUtil.buildNonDefaultBinder().toJson(map));
        }
    }

    @Override
    public String sendSaveRsFlowdata(RsFlowdata rsFlowData) {
        return this.saveRsToEsAndStatic(rsFlowData);
    }

    @Override
    public void deleteFlowDataModel(String fdCode, String tenantCode) throws ApiException {
        this.deleteFlowData(fdCode, tenantCode);
    }

    @Override
    public void deleteStateSenddata(String senddataCode, String tenantCode) throws ApiException {
        this.deleteStateSenddataModel(senddataCode, tenantCode);
    }

    @Override
    public String sendSaveRsSenddata(RsSenddata rsSenddata) {
        return this.saveRsSenddata(rsSenddata);
    }

    private String saveRsSenddata(RsSenddata rsSenddata) {
        if (null == rsSenddata) {
            return "rsSenddata\u53c2\u6570\u4e3a\u7a7a";
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        ArrayList<RsDisflowdata> rsDisflowdataList = new ArrayList<RsDisflowdata>();
        if (null == rsSenddata.getFdBiztype()) {
            rsSenddata.setFdBiztype("");
        }
        FlowReBean flowReBean = new FlowReBean();
        flowReBean.setRsDisflowdataList(rsDisflowdataList);
        flowReBean.setRsSenddataList(rsSenddataList);
        if (rsSenddata.getFdBiztype().equals("DisRsResourceGoodsNew")) {
            if (rsSenddata.getEsrequestType().equals("down")) {
                if (!this.sendGoodsDown(rsSenddata)) {
                    this.logger.error("rs.RsGoodsSendServiceImpl.saveRsToEsAndStatic.sendGoodsDown.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSenddata));
                    return "goods\u5546\u54c1\u63a8\u9001\u5931\u8d25";
                }
            } else if (rsSenddata.getEsrequestType().equals("insert") && !this.sendGoodsInsert(rsSenddata)) {
                this.logger.error("rs.RsGoodsSendServiceImpl.saveRsToEsAndStatic.sendGoodsInsert.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSenddata));
                return "goods\u5546\u54c1\u63a8\u9001\u5931\u8d25";
            }
        }
        if (rsSenddata.getFdBiztype().equals("DisRsSkuNew")) {
            if (rsSenddata.getEsrequestType().equals("down")) {
                if (!this.sendSkuDown(rsSenddata)) {
                    this.logger.error("rs.RsGoodsSendServiceImpl.saveRsToEsAndStatic.sendSkuDown.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSenddata));
                    return "sku\u5546\u54c1\u63a8\u9001\u5931\u8d25";
                }
            } else if (rsSenddata.getEsrequestType().equals("insert") && !this.sendSkuInsert(rsSenddata)) {
                this.logger.error("rs.RsGoodsSendServiceImpl.saveRsToEsAndStatic.sendSkuInsert.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSenddata));
                return "sku\u5546\u54c1\u63a8\u9001\u5931\u8d25";
            }
        }
        RsSenddatabakDomain rsSenddatabakDomain = this.makeDomain(rsSenddata);
        this.rsSenddataService.saveSenddatabak(rsSenddatabakDomain);
        return "success";
    }

    private RsSenddatabakDomain makeDomain(RsSenddata rsSenddata) {
        if (null == rsSenddata) {
            return null;
        }
        RsSenddatabakDomain rsSenddatabakDomain = new RsSenddatabakDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSenddatabakDomain, (Object)rsSenddata);
            return rsSenddatabakDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSendServiceImpl.makeDomain", (Throwable)e);
            return null;
        }
    }

    private String saveRsToEsAndStatic(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return "rsFlowData\u53c2\u6570\u4e3a\u7a7a";
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        ArrayList<RsDisflowdata> rsDisflowdataList = new ArrayList<RsDisflowdata>();
        if (null == rsFlowData.getChannelsendApiApicode()) {
            rsFlowData.setChannelsendApiApicode("");
        }
        FlowReBean flowReBean = new FlowReBean();
        flowReBean.setRsDisflowdataList(rsDisflowdataList);
        flowReBean.setRsSenddataList(rsSenddataList);
        if (rsFlowData.getChannelsendApiApicode().equals("RsResourceGoodsEsNew") && !this.sendGoodsEs(rsFlowData)) {
            this.logger.error("rs.RsGoodsSendServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "RsResourceGoods"));
            return "goods\u5546\u54c1\u63a8\u9001\u5931\u8d25";
        }
        if (rsFlowData.getChannelsendApiApicode().equals("RsSkuEsNew")) {
            if (!this.sendSkuEs(rsFlowData)) {
                this.logger.error("rs.RsGoodsSendServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "RsResourceGoods"));
                return "goods\u5546\u54c1\u63a8\u9001\u5931\u8d25";
            }
        } else if (rsFlowData.getChannelsendApiApicode().equals("dataUpdateNew") && !this.updateData(rsFlowData)) {
            this.logger.error("rs.RsGoodsSendServiceImpl.saveRsToEsAndStatic.end.null", (Object)(rsFlowData.getFdCode() + "=" + "dataUpdateNew"));
            return "sku\u6570\u636e\u540c\u6b65\u5931\u8d25";
        }
        RsFlowdataFinish rsFlowDataFinish = new RsFlowdataFinish();
        try {
            BeanUtils.copyAllPropertys((Object)rsFlowDataFinish, (Object)rsFlowData);
            rsFlowDataFinish.setFdId(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveRsFlowdataFinishModel(rsFlowDataFinish);
        this.logger.debug("rs.RsGoodsSendServiceImpl.saveRsToEsAndStatic.end", (Object)rsFlowData.getFdCode());
        return "success";
    }

    private void saveRsFlowdataFinishModel(RsFlowdataFinish rsFlowDataFinish) throws ApiException {
        if (null == rsFlowDataFinish) {
            return;
        }
        try {
            this.rsFlowdataFinishMapper.insert(rsFlowDataFinish);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsSendServiceImpl.saveRsFlowdataFinishModel.ex", (Throwable)e);
        }
    }

    public RsFlowdataFinishMapper getRsFlowdataFinishMapper() {
        return this.rsFlowdataFinishMapper;
    }

    public void setRsFlowdataFinishMapper(RsFlowdataFinishMapper rsFlowdataFinishMapper) {
        this.rsFlowdataFinishMapper = rsFlowdataFinishMapper;
    }

    public RsSku getSkuModelByCode(String skuCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuCode", skuCode);
        try {
            return this.rsSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSendServiceImpl.getSkuModelByCode", (Object)((Object)map).toString(), (Throwable)e);
            return null;
        }
    }

    private boolean updateData(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            this.logger.error("rs.RsGoodsSendServiceImpl.updateData.", (Object)"param is null");
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizcode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        Integer dataState = 0;
        if (rsFlowData.getEsrequestType().equals("skudown") || rsFlowData.getEsrequestType().equals("down") || rsFlowData.getEsrequestType().equals("delete") || rsFlowData.getEsrequestType().equals("deleteop")) {
            dataState = rsFlowData.getEsrequestType().equals("skudown") || rsFlowData.getEsrequestType().equals("down") ? 2 : 3;
        } else {
            RsSku sku = this.getSkuModelByCode(rsFlowData.getFdBizcode(), rsFlowData.getTenantCode());
            if (sku.getGoodsSupplynum().intValue() <= 0) {
                dataState = 1;
            }
            map.put("goodsCode", sku.getGoodsCode());
            map.put("dataState", dataState);
            String goodsName = sku.getGoodsName();
            if (StringUtils.isBlank((String)goodsName)) {
                this.logger.error("rs.RsGoodsSendServiceImpl.updateData.", (Object)"goodsName is null");
                return false;
            }
            map.put("pricesetNprice", sku.getPricesetNprice());
            map.put("goodsSupplynum", sku.getGoodsSupplynum());
            map.put("goodsSupplyweight", sku.getGoodsSupplyweight());
            map.put("dataPic", sku.getDataPic());
            map.put("goodsName", goodsName);
            map.put("partsnameNumunit", sku.getPartsnameNumunit());
            map.put("partsnameWeightunit", sku.getPartsnameWeightunit());
            map.put("goodsMinnum", sku.getGoodsMinnum());
            map.put("goodsOneweight", sku.getGoodsOneweight());
            map.put("goodsType", sku.getGoodsType());
            map.put("goodsPro", sku.getGoodsPro());
        }
        map.put("dataState", dataState);
        if (!this.sendDataUpdateGood(map, "um.collect.updateCollectByOpCode").booleanValue()) {
            this.logger.error("rs.RsGoodsSendServiceImpl.updateData.updateCollectByOpCode", map);
            return false;
        }
        if (!this.sendDataUpdateGood(map, "um.footprint.updateFootprintByOpCode").booleanValue()) {
            this.logger.error("rs.RsGoodsSendServiceImpl.updateData.updateFootprintByOpCode", map);
            return false;
        }
        if (!this.sendDataUpdateGood(map, "oc.shopping.updateShopGoodsBySkuCode").booleanValue()) {
            this.logger.error("rs.RsGoodsSendServiceImpl.updateData.updateShopGoodsBySkuCode", map);
            return false;
        }
        if (!this.sendDataUpdateGood(map, "oc.regular.updateGoodsBySkuCode").booleanValue()) {
            this.logger.error("rs.RsGoodsSendServiceImpl.updateData.updateGoodsBySkuCode", map);
            return false;
        }
        return true;
    }

    private Boolean sendDataUpdateGood(Map<String, Object> paramMap, String api) {
        if (null == paramMap || null == api) {
            return false;
        }
        HashMap<String, String> paramMapStr = new HashMap<String, String>();
        paramMapStr.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        try {
            this.getInternalRouter().inInvoke(api, paramMapStr);
        }
        catch (ApiException e) {
            this.logger.error("rsFlowDataServiceImpl.sendDataUpdateGood.ex", (Throwable)e);
            return false;
        }
        return true;
    }

    private RsResourceGoodsReDomain makeReDomian(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        try {
            BeanUtils.copyImplPropertys((Object)rsResourceGoodsReDomain, (Object)rsResourceGoods);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSendServiceImpl.makeReDomian", (Throwable)e);
        }
        return rsResourceGoodsReDomain;
    }

    private boolean sendGoodsEs(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        List goodsList = JsonUtil.buildNonDefaultBinder().getJsonToList(rsFlowData.getFdBizcodestr(), String.class);
        ArrayList<StoreDomain> storeDomains = new ArrayList<StoreDomain>();
        for (String goodsCode : goodsList) {
            StoreDomain storeDomain = new StoreDomain();
            storeDomain.setBizType("goods");
            storeDomain.setRequestType(rsFlowData.getEsrequestType());
            storeDomain.setBizId(rsFlowData.getTenantCode() + goodsCode);
            storeDomain.setTenantCode(rsFlowData.getTenantCode());
            if (rsFlowData.getEsrequestType().equals("insert") || rsFlowData.getEsrequestType().equals("update")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("goodsCode", goodsCode);
                map.put("tenantCode", rsFlowData.getTenantCode());
                RsResourceGoods resourceGoods = this.getResourceGoodsModelByCode(map);
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.makeReDomian(resourceGoods);
                map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
                List<RsSku> rsSkus = this.querySkuModelPage(map);
                ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
                for (RsSku rsSku : rsSkus) {
                    RsSkuDomain rsSkuDomain = new RsSkuDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rsSkuDomainList.add(rsSkuDomain);
                }
                rsResourceGoodsReDomain.setRsSkuDomainList(rsSkuDomainList);
                this.makeEsSku(rsResourceGoodsReDomain, storeDomain);
            }
            storeDomains.add(storeDomain);
        }
        return this.sendEsList(storeDomains);
    }

    private boolean sendSkuEs(RsFlowdata rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        ArrayList<StoreDomain> storeDomains = new ArrayList<StoreDomain>();
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setBizType("sku");
        storeDomain.setRequestType(rsFlowData.getEsrequestType());
        storeDomain.setBizId(rsFlowData.getTenantCode() + rsFlowData.getFdBizcode());
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        if (!(rsFlowData.getEsrequestType().equals("delete") || rsFlowData.getEsrequestType().equals("deleteop") || "skudelete".equals(rsFlowData.getEsrequestType()) || "skudeleteop".equals(rsFlowData.getEsrequestType()))) {
            RsSku rsSku = this.getSkuModelByCode(rsFlowData.getFdBizcode(), rsFlowData.getTenantCode());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsSku.getGoodsCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoods resourceGoods = this.getResourceGoodsModelByCode(map);
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.makeReDomian(resourceGoods);
            ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
            RsSkuDomain rsSkuDomain = new RsSkuDomain();
            try {
                BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rsSkuDomainList.add(rsSkuDomain);
            rsResourceGoodsReDomain.setRsSkuDomainList(rsSkuDomainList);
            this.makeEsSku(rsResourceGoodsReDomain, storeDomain);
        }
        storeDomains.add(storeDomain);
        return this.sendEsList(storeDomains);
    }

    private void makeEsSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, StoreDomain storeDomain, RsSkuDomain rsSkuDomain) {
        if (null == rsResourceGoodsReDomain || null == storeDomain || null == rsSkuDomain) {
            return;
        }
        EsSku esSku = new EsSku();
        List<RsGoodsRelDomain> goodsrelist = rsResourceGoodsReDomain.getRsGoodsRelDomainList();
        List<RsGoodsRelDomain> skurelist = rsSkuDomain.getRsGoodsRelDomainList();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)esSku, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertysNotNull((Object)esSku, (Object)rsSkuDomain);
            if (ListUtil.isNotEmpty(skurelist)) {
                esSku.setRsGoodsRelDomainList(skurelist);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank((String)esSku.getGoodsClass()) && StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getGoodsClass())) {
            esSku.setGoodsClass(rsResourceGoodsReDomain.getGoodsClass());
        }
        esSku.setSpecList(rsResourceGoodsReDomain.getRsSpecValueDomainList());
        if ("goods".equals(storeDomain.getBizType())) {
            if (ListUtil.isNotEmpty(goodsrelist)) {
                esSku.setRsGoodsRelDomainList(goodsrelist);
            }
            esSku.setGoodsNum(rsResourceGoodsReDomain.getGoodsNum());
            esSku.setGoodsSupplynum(rsResourceGoodsReDomain.getGoodsSupplynum());
            esSku.setStoreNum(0);
            if (null == esSku.getGoodsSupplynum() || esSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) <= 0) {
                esSku.setStoreNum(1);
            }
            esSku.setDataPic(rsResourceGoodsReDomain.getDataPic());
            esSku.setDataOpbillstate(rsResourceGoodsReDomain.getDataOpbillstate());
            esSku.setDataOpnextbillstate(rsResourceGoodsReDomain.getDataOpnextbillstate());
            esSku.setDataPicpath(rsResourceGoodsReDomain.getDataPicpath());
            esSku.setDataState(rsResourceGoodsReDomain.getDataState());
            if (null != rsResourceGoodsReDomain.getPricesetNprice()) {
                esSku.setPricesetNprice(rsResourceGoodsReDomain.getPricesetNprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetAsprice()) {
                esSku.setPricesetAsprice(rsResourceGoodsReDomain.getPricesetAsprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetBaseprice()) {
                esSku.setPricesetBaseprice(rsResourceGoodsReDomain.getPricesetBaseprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetInsideprice()) {
                esSku.setPricesetInsideprice(rsResourceGoodsReDomain.getPricesetInsideprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetMakeprice()) {
                esSku.setPricesetMakeprice(rsResourceGoodsReDomain.getPricesetMakeprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetMakeshow()) {
                esSku.setPricesetMakeshow(rsResourceGoodsReDomain.getPricesetMakeshow());
            }
            if (null != rsResourceGoodsReDomain.getPricesetPrefprice()) {
                esSku.setPricesetPrefprice(rsResourceGoodsReDomain.getPricesetPrefprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetType()) {
                esSku.setPricesetType(rsResourceGoodsReDomain.getPricesetType());
            }
        }
        esSku.setGoodsRemark(rsResourceGoodsReDomain.getGoodsRemark());
        esSku.setRsGoodsFileDomainList(rsSkuDomain.getRsGoodsFileDomainList());
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsFileDomainList())) {
            esSku.setRsGoodsFileDomainList(rsResourceGoodsReDomain.getRsGoodsFileDomainList());
        }
        if (StringUtils.isBlank((String)esSku.getDataPic())) {
            esSku.setDataPic(rsResourceGoodsReDomain.getDataPic());
        }
        esSku.setRsSpecValueMap(rsSkuDomain.getRsSpecValueMap());
        esSku.setGoodsNo(rsResourceGoodsReDomain.getGoodsNo());
        esSku.setPntreeCode(rsResourceGoodsReDomain.getPntreeCode());
        esSku.setMemberName(rsResourceGoodsReDomain.getMemberName());
        esSku.setClasstreeName(rsResourceGoodsReDomain.getClasstreeName());
        esSku.setClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode());
        esSku.setPntreeName(rsResourceGoodsReDomain.getPntreeName());
        esSku.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
        esSku.setGoodsProperty(rsResourceGoodsReDomain.getGoodsProperty());
        esSku.setBrandCode(rsResourceGoodsReDomain.getBrandCode());
        esSku.setBrandName(rsResourceGoodsReDomain.getBrandName());
        esSku.setOldPricesetNprice(esSku.getPricesetNprice());
        esSku.setGoodsSpec(null == rsResourceGoodsReDomain.getGoodsSpec() ? "" : rsResourceGoodsReDomain.getGoodsSpec());
        if (null == esSku.getGoodsSalesvolume()) {
            esSku.setGoodsSalesvolume(BigDecimal.ZERO);
        }
        if (ListUtil.isNotEmpty(esSku.getRsSkuDomainList())) {
            ArrayList<RsSkuDomain> rsSkuDomainList1 = new ArrayList<RsSkuDomain>();
            for (RsSkuDomain rsSkuDomain1 : esSku.getRsSkuDomainList()) {
                if (ResourcesConstants.DATA_OPBILLSTATE_1.intValue() != rsSkuDomain1.getDataOpbillstate().intValue()) continue;
                rsSkuDomainList1.add(rsSkuDomain1);
            }
            esSku.setRsSkuDomainList(rsSkuDomainList1);
        }
        Map specCodeMap = null;
        String esSkuStr = JsonUtil.buildNormalBinder().toJson((Object)esSku);
        if (MapUtil.isNotEmpty(specCodeMap)) {
            HashMap remap = JsonUtil.buildNormalBinder().getJsonToMap(esSkuStr, String.class, Object.class);
            if (null == remap) {
                remap = new HashMap();
            }
            remap.putAll(specCodeMap);
            esSkuStr = JsonUtil.buildNormalBinder().toJson(remap);
        }
        storeDomain.setStoreObj((Object)esSkuStr);
    }

    private void makeEsSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, StoreDomain storeDomain) {
        if (null == rsResourceGoodsReDomain || null == storeDomain) {
            return;
        }
        EsSku esSku = new EsSku();
        List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)esSku, (Object)rsResourceGoodsReDomain);
            esSku.setRsSkuDomainList(rsSkuDomainList);
            if (ListUtil.isNotEmpty(rsSkuDomainList)) {
                RsSkuDomain rsSkuDomain = rsSkuDomainList.get(0);
                BeanUtils.copyAllPropertysNotNull((Object)esSku, (Object)rsSkuDomain);
            }
        }
        catch (Exception rsSkuDomain) {
            // empty catch block
        }
        if (StringUtils.isBlank((String)esSku.getGoodsClass()) && StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getGoodsClass())) {
            esSku.setGoodsClass(rsResourceGoodsReDomain.getGoodsClass());
        }
        if ("goods".equals(storeDomain.getBizType())) {
            esSku.setGoodsNum(rsResourceGoodsReDomain.getGoodsNum());
            esSku.setGoodsSupplynum(rsResourceGoodsReDomain.getGoodsSupplynum());
            esSku.setStoreNum(0);
            if (null == esSku.getGoodsSupplynum() || esSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) <= 0) {
                esSku.setStoreNum(1);
            }
            esSku.setDataPic(rsResourceGoodsReDomain.getDataPic());
            esSku.setDataOpbillstate(rsResourceGoodsReDomain.getDataOpbillstate());
            esSku.setDataOpnextbillstate(rsResourceGoodsReDomain.getDataOpnextbillstate());
            esSku.setDataPicpath(rsResourceGoodsReDomain.getDataPicpath());
            esSku.setDataState(rsResourceGoodsReDomain.getDataState());
            if (null != rsResourceGoodsReDomain.getPricesetNprice()) {
                esSku.setPricesetNprice(rsResourceGoodsReDomain.getPricesetNprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetAsprice()) {
                esSku.setPricesetAsprice(rsResourceGoodsReDomain.getPricesetAsprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetBaseprice()) {
                esSku.setPricesetBaseprice(rsResourceGoodsReDomain.getPricesetBaseprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetInsideprice()) {
                esSku.setPricesetInsideprice(rsResourceGoodsReDomain.getPricesetInsideprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetMakeprice()) {
                esSku.setPricesetMakeprice(rsResourceGoodsReDomain.getPricesetMakeprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetMakeshow()) {
                esSku.setPricesetMakeshow(rsResourceGoodsReDomain.getPricesetMakeshow());
            }
            if (null != rsResourceGoodsReDomain.getPricesetPrefprice()) {
                esSku.setPricesetPrefprice(rsResourceGoodsReDomain.getPricesetPrefprice());
            }
            if (null != rsResourceGoodsReDomain.getPricesetType()) {
                esSku.setPricesetType(rsResourceGoodsReDomain.getPricesetType());
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsFileDomainList())) {
            esSku.setRsGoodsFileDomainList(rsResourceGoodsReDomain.getRsGoodsFileDomainList());
        }
        if (StringUtils.isBlank((String)esSku.getDataPic())) {
            esSku.setDataPic(rsResourceGoodsReDomain.getDataPic());
        }
        esSku.setGoodsNo(rsResourceGoodsReDomain.getGoodsNo());
        esSku.setPntreeCode(rsResourceGoodsReDomain.getPntreeCode());
        esSku.setMemberName(rsResourceGoodsReDomain.getMemberName());
        esSku.setClasstreeName(rsResourceGoodsReDomain.getClasstreeName());
        esSku.setClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode());
        esSku.setPntreeName(rsResourceGoodsReDomain.getPntreeName());
        esSku.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
        esSku.setGoodsProperty(rsResourceGoodsReDomain.getGoodsProperty());
        esSku.setBrandCode(rsResourceGoodsReDomain.getBrandCode());
        esSku.setBrandName(rsResourceGoodsReDomain.getBrandName());
        esSku.setOldPricesetNprice(esSku.getPricesetNprice());
        esSku.setGoodsSpec(null == rsResourceGoodsReDomain.getGoodsSpec() ? "" : rsResourceGoodsReDomain.getGoodsSpec());
        if (null == esSku.getGoodsSalesvolume()) {
            esSku.setGoodsSalesvolume(BigDecimal.ZERO);
        }
        String esSkuStr = JsonUtil.buildNormalBinder().toJson((Object)esSku);
        storeDomain.setStoreObj((Object)esSkuStr);
    }

    private boolean sendGoodsDown(RsSenddata rsSenddata) {
        if (null == rsSenddata) {
            return false;
        }
        List goodsList = JsonUtil.buildNonDefaultBinder().getJsonToList(rsSenddata.getFdBizcodestr(), String.class);
        String mns = this.rsResourceGoodsNewService.updateNextSoldOutGoods(goodsList, rsSenddata.getTenantCode());
        return StringUtils.isNotBlank((String)mns) && "success".equals(mns);
    }

    private boolean sendSkuDown(RsSenddata rsSenddata) {
        if (null == rsSenddata) {
            return false;
        }
        List skuList = JsonUtil.buildNonDefaultBinder().getJsonToList(rsSenddata.getFdBizcodestr(), String.class);
        String mns = this.rsResourceGoodsNewService.updateNextSoldOutSku(skuList, rsSenddata.getTenantCode());
        return StringUtils.isNotBlank((String)mns) && "success".equals(mns);
    }

    private boolean sendGoodsInsert(RsSenddata rsSenddata) {
        if (null == rsSenddata) {
            return false;
        }
        List goodsList = JsonUtil.buildNonDefaultBinder().getJsonToList(rsSenddata.getFdBizcodestr(), String.class);
        String mns = this.rsResourceGoodsNewService.updateNextUpdateShelveGoods(goodsList, rsSenddata.getTenantCode());
        return StringUtils.isNotBlank((String)mns) && "success".equals(mns);
    }

    private boolean sendSkuInsert(RsSenddata rsSenddata) {
        if (null == rsSenddata) {
            return false;
        }
        List skuList = JsonUtil.buildNonDefaultBinder().getJsonToList(rsSenddata.getFdBizcodestr(), String.class);
        String mns = this.rsResourceGoodsNewService.updateNextUpdateShelveSku(skuList, rsSenddata.getTenantCode());
        return StringUtils.isNotBlank((String)mns) && "success".equals(mns);
    }

    private boolean sendEsList(List<StoreDomain> storeDomainList) {
        if (ListUtil.isEmpty(storeDomainList)) {
            return false;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomainList", JsonUtil.buildNormalBinder().toJson(storeDomainList));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.storeBatch", "1.0", "0", paramMap);
        if (StringUtils.isEmpty((String)result) || "false".equals(result)) {
            this.logger.error("rs.RsGoodsSendServiceImpl.sendEs.result", (Object)result);
            return false;
        }
        return true;
    }

    public RsResourceGoods getResourceGoodsModelByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("rs.RsGoodsSendServiceImpl.getResourceGoodsModelByCode.map");
            return null;
        }
        try {
            return this.rsResourceGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSendServiceImpl.getResourceGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private List<RsSku> querySkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsSendServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }
}

