/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsSenddataLogMapper;
import com.yqbsoft.laser.service.resources.domain.Channel;
import com.yqbsoft.laser.service.resources.domain.Goods;
import com.yqbsoft.laser.service.resources.domain.RsSenddataLogDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddataLogReDomain;
import com.yqbsoft.laser.service.resources.domain.SendLog;
import com.yqbsoft.laser.service.resources.model.RsSenddataLog;
import com.yqbsoft.laser.service.resources.service.RsSenddataLogService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsSenddataLogServiceImpl
extends BaseServiceImpl
implements RsSenddataLogService {
    private static final String SYS_CODE = "rs.RsSenddataLogServiceImpl";
    private RsSenddataLogMapper rsSenddataLogMapper;

    public void setRsSenddataLogMapper(RsSenddataLogMapper rsSenddataLogMapper) {
        this.rsSenddataLogMapper = rsSenddataLogMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSenddataLogMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSenddataLogServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checksenddataLog(RsSenddataLogDomain rsSenddataLogDomain) {
        if (null == rsSenddataLogDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSenddataLogDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setsenddataLogDefault(RsSenddataLog rsSenddataLog) {
        if (null == rsSenddataLog) {
            return;
        }
        if (null == rsSenddataLog.getDataState()) {
            rsSenddataLog.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsSenddataLog.getGmtCreate()) {
            rsSenddataLog.setGmtCreate(date);
        }
        rsSenddataLog.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSenddataLog.getSenddataLogCode())) {
            rsSenddataLog.setSenddataLogCode(this.createUUIDString());
        }
    }

    private int getsenddataLogMaxCode() {
        int code = 0;
        try {
            return this.rsSenddataLogMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSenddataLogServiceImpl.getsenddataLogMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setsenddataLogUpdataDefault(RsSenddataLog rsSenddataLog) {
        if (null == rsSenddataLog) {
            return;
        }
        rsSenddataLog.setGmtModified(this.getSysDate());
    }

    private void savesenddataLogModel(RsSenddataLog rsSenddataLog) throws ApiException {
        if (null == rsSenddataLog) {
            return;
        }
        try {
            this.rsSenddataLogMapper.insert(rsSenddataLog);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.savesenddataLogModel.ex", (Throwable)e);
        }
    }

    private void savesenddataLogBatchModel(List<RsSenddataLog> rsSenddataLogList) throws ApiException {
        if (null == rsSenddataLogList || rsSenddataLogList.isEmpty()) {
            return;
        }
        try {
            this.rsSenddataLogMapper.insertBatch(rsSenddataLogList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.savesenddataLogBatchModel.ex", (Throwable)e);
        }
    }

    private RsSenddataLog getsenddataLogModelById(Integer senddataLogId) {
        if (null == senddataLogId) {
            return null;
        }
        try {
            return this.rsSenddataLogMapper.selectByPrimaryKey(senddataLogId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSenddataLogServiceImpl.getsenddataLogModelById", (Throwable)e);
            return null;
        }
    }

    private RsSenddataLog getsenddataLogModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSenddataLogMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSenddataLogServiceImpl.getsenddataLogModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delsenddataLogModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSenddataLogMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.delsenddataLogModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.delsenddataLogModelByCode.num");
        }
    }

    private void deletesenddataLogModel(Integer senddataLogId) throws ApiException {
        if (null == senddataLogId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSenddataLogMapper.deleteByPrimaryKey(senddataLogId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.deletesenddataLogModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.deletesenddataLogModel.num");
        }
    }

    private void updatesenddataLogModel(RsSenddataLog rsSenddataLog) throws ApiException {
        if (null == rsSenddataLog) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSenddataLogMapper.updateByPrimaryKey(rsSenddataLog);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.updatesenddataLogModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.updatesenddataLogModel.num");
        }
    }

    private void updateStatesenddataLogModel(Integer senddataLogId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == senddataLogId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("senddataLogId", senddataLogId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSenddataLogMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.updateStatesenddataLogModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.updateStatesenddataLogModel.null");
        }
    }

    private void updateStatesenddataLogModelByCode(String tenantCode, String senddataLogCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)senddataLogCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("senddataLogCode", senddataLogCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSenddataLogMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.updateStatesenddataLogModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.updateStatesenddataLogModelByCode.null");
        }
    }

    private RsSenddataLog makesenddataLog(RsSenddataLogDomain rsSenddataLogDomain, RsSenddataLog rsSenddataLog) {
        if (null == rsSenddataLogDomain) {
            return null;
        }
        if (null == rsSenddataLog) {
            rsSenddataLog = new RsSenddataLog();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSenddataLog, (Object)rsSenddataLogDomain);
            return rsSenddataLog;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSenddataLogServiceImpl.makesenddataLog", (Throwable)e);
            return null;
        }
    }

    private RsSenddataLogReDomain makeRsSenddataLogReDomain(RsSenddataLog rsSenddataLog) {
        if (null == rsSenddataLog) {
            return null;
        }
        RsSenddataLogReDomain rsSenddataLogReDomain = new RsSenddataLogReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSenddataLogReDomain, (Object)rsSenddataLog);
            return rsSenddataLogReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSenddataLogServiceImpl.makeRsSenddataLogReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsSenddataLog> querysenddataLogModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSenddataLogMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSenddataLogServiceImpl.querysenddataLogModel", (Throwable)e);
            return null;
        }
    }

    private int countsenddataLog(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSenddataLogMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSenddataLogServiceImpl.countsenddataLog", (Throwable)e);
        }
        return i;
    }

    private RsSenddataLog createRsSenddataLog(RsSenddataLogDomain rsSenddataLogDomain) {
        String msg = this.checksenddataLog(rsSenddataLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.savesenddataLog.checksenddataLog", msg);
        }
        RsSenddataLog rsSenddataLog = this.makesenddataLog(rsSenddataLogDomain, null);
        this.setsenddataLogDefault(rsSenddataLog);
        return rsSenddataLog;
    }

    @Override
    public String savesenddataLog(RsSenddataLogDomain rsSenddataLogDomain) throws ApiException {
        RsSenddataLog rsSenddataLog = this.createRsSenddataLog(rsSenddataLogDomain);
        this.savesenddataLogModel(rsSenddataLog);
        return rsSenddataLog.getSenddataLogCode();
    }

    @Override
    public String savesenddataLogByPcode(RsSenddataLog rsSenddataLog) throws ApiException {
        SendLog sendLog = (SendLog)JsonUtil.buildNormalBinder().getJsonToObject(rsSenddataLog.getFdBizcodestr(), SendLog.class);
        if (null == sendLog || ListUtil.isEmpty(sendLog.getChannelList()) || ListUtil.isEmpty(sendLog.getGoodsList())) {
            return "\u53c2\u6570\u9519\u8bef\uff01";
        }
        rsSenddataLog.setSenddataLogCode(null);
        rsSenddataLog.setSenddataLogId(null);
        rsSenddataLog.setFdBizcodestr(JsonUtil.buildNormalBinder().toJson((Object)sendLog.getSendData()));
        for (Channel channel : sendLog.getChannelList()) {
            rsSenddataLog.setChannelCode(channel.getChannelCode());
            rsSenddataLog.setChannelName(channel.getChannelName());
            for (Goods goods : sendLog.getGoodsList()) {
                rsSenddataLog.setGoodsNo(goods.getGoodsNo());
                rsSenddataLog.setGoodsName(goods.getGoodsName());
                this.setsenddataLogDefault(rsSenddataLog);
                this.savesenddataLogModel(rsSenddataLog);
            }
        }
        return "success";
    }

    @Override
    public String savesenddataLogBatch(List<RsSenddataLogDomain> rsSenddataLogDomainList) throws ApiException {
        if (null == rsSenddataLogDomainList || rsSenddataLogDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsSenddataLog> rsSenddataLogList = new ArrayList<RsSenddataLog>();
        String code = "";
        for (RsSenddataLogDomain rsSenddataLogDomain : rsSenddataLogDomainList) {
            RsSenddataLog rsSenddataLog = this.createRsSenddataLog(rsSenddataLogDomain);
            code = rsSenddataLog.getSenddataLogCode();
            rsSenddataLogList.add(rsSenddataLog);
        }
        this.savesenddataLogBatchModel(rsSenddataLogList);
        return code;
    }

    @Override
    public void updatesenddataLogState(Integer senddataLogId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == senddataLogId) {
            return;
        }
        this.updateStatesenddataLogModel(senddataLogId, dataState, oldDataState, map);
    }

    @Override
    public void updatesenddataLogStateByCode(String tenantCode, String senddataLogCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)senddataLogCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatesenddataLogModelByCode(tenantCode, senddataLogCode, dataState, oldDataState, map);
    }

    @Override
    public void updatesenddataLog(RsSenddataLogDomain rsSenddataLogDomain) throws ApiException {
        String msg = this.checksenddataLog(rsSenddataLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.updatesenddataLog.checksenddataLog", msg);
        }
        RsSenddataLog oldRsSenddataLog = this.getsenddataLogModelById(rsSenddataLogDomain.getSenddataLogId());
        if (null == oldRsSenddataLog) {
            throw new ApiException("rs.RsSenddataLogServiceImpl.updatesenddataLog.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSenddataLog rsSenddataLog = this.makesenddataLog(rsSenddataLogDomain, oldRsSenddataLog);
        this.setsenddataLogUpdataDefault(rsSenddataLog);
        this.updatesenddataLogModel(rsSenddataLog);
    }

    @Override
    public RsSenddataLog getsenddataLog(Integer senddataLogId) {
        if (null == senddataLogId) {
            return null;
        }
        return this.getsenddataLogModelById(senddataLogId);
    }

    @Override
    public void deletesenddataLog(Integer senddataLogId) throws ApiException {
        if (null == senddataLogId) {
            return;
        }
        this.deletesenddataLogModel(senddataLogId);
    }

    @Override
    public QueryResult<RsSenddataLog> querysenddataLogPage(Map<String, Object> map) {
        List<RsSenddataLog> rsSenddataLogList = this.querysenddataLogModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countsenddataLog(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSenddataLogList);
        return queryResult;
    }

    @Override
    public RsSenddataLog getsenddataLogByCode(String tenantCode, String senddataLogCode) throws ApiException {
        if (StringUtils.isBlank((String)senddataLogCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("senddataLogCode", senddataLogCode);
        return this.getsenddataLogModelByCode(map);
    }

    @Override
    public void deletesenddataLogByCode(String tenantCode, String senddataLogCode) throws ApiException {
        if (StringUtils.isBlank((String)senddataLogCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("senddataLogCode", senddataLogCode);
        this.delsenddataLogModelByCode(map);
    }
}

