/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.saleforecast.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.saleforecast.dao.StSaleforecastMapper;
import com.yqbsoft.laser.service.saleforecast.domain.StChannelsendDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSaleforecastDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSaleforecastListDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSaleforecastReDomain;
import com.yqbsoft.laser.service.saleforecast.model.StChannelsend;
import com.yqbsoft.laser.service.saleforecast.model.StSaleforecast;
import com.yqbsoft.laser.service.saleforecast.service.StChannelsendService;
import com.yqbsoft.laser.service.saleforecast.service.StSaleforecastListService;
import com.yqbsoft.laser.service.saleforecast.service.StSaleforecastService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StSaleforecastServiceImpl
extends BaseServiceImpl
implements StSaleforecastService {
    private static final String SYS_CODE = "st.StSaleforecastServiceImpl";
    private StSaleforecastMapper stSaleforecastMapper;
    private StSaleforecastListService stSaleforecastListService;
    private StChannelsendService stChannelsendService;

    public StSaleforecastListService getStSaleforecastListService() {
        return this.stSaleforecastListService;
    }

    public void setStSaleforecastListService(StSaleforecastListService stSaleforecastListService) {
        this.stSaleforecastListService = stSaleforecastListService;
    }

    public void setStSaleforecastMapper(StSaleforecastMapper stSaleforecastMapper) {
        this.stSaleforecastMapper = stSaleforecastMapper;
    }

    public StSaleforecastMapper getStSaleforecastMapper() {
        return this.stSaleforecastMapper;
    }

    public StChannelsendService getStChannelsendService() {
        return this.stChannelsendService;
    }

    public void setStChannelsendService(StChannelsendService stChannelsendService) {
        this.stChannelsendService = stChannelsendService;
    }

    private Date getSysDate() {
        try {
            return this.stSaleforecastMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("st.StSaleforecastServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSaleforecast(StSaleforecastDomain stSaleforecastDomain) {
        if (null == stSaleforecastDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)stSaleforecastDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSaleforecastDefault(StSaleforecast stSaleforecast) {
        if (null == stSaleforecast) {
            return;
        }
        if (null == stSaleforecast.getDataState()) {
            stSaleforecast.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == stSaleforecast.getGmtCreate()) {
            stSaleforecast.setGmtCreate(date);
        }
        stSaleforecast.setGmtModified(date);
        if (StringUtils.isBlank((String)stSaleforecast.getSaleforecastCode())) {
            stSaleforecast.setSaleforecastCode(this.getNo(null, "StSaleforecast", "stSaleforecast", stSaleforecast.getTenantCode()));
        }
    }

    private int getSaleforecastMaxCode() {
        int code = 0;
        try {
            return this.stSaleforecastMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("st.StSaleforecastServiceImpl.getSaleforecastMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSaleforecastUpdataDefault(StSaleforecast stSaleforecast) {
        if (null == stSaleforecast) {
            return;
        }
        stSaleforecast.setGmtModified(this.getSysDate());
    }

    private void saveSaleforecastModel(StSaleforecast stSaleforecast) throws ApiException {
        if (null == stSaleforecast) {
            return;
        }
        try {
            this.stSaleforecastMapper.insert(stSaleforecast);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleforecastServiceImpl.saveSaleforecastModel.ex", (Throwable)e);
        }
    }

    private void saveSaleforecastBatchModel(List<StSaleforecast> stSaleforecastList) throws ApiException {
        if (null == stSaleforecastList || stSaleforecastList.isEmpty()) {
            return;
        }
        try {
            this.stSaleforecastMapper.insertBatch(stSaleforecastList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleforecastServiceImpl.saveSaleforecastBatchModel.ex", (Throwable)e);
        }
    }

    private StSaleforecast getSaleforecastModelById(Integer saleforecastId) {
        if (null == saleforecastId) {
            return null;
        }
        try {
            return this.stSaleforecastMapper.selectByPrimaryKey(saleforecastId);
        }
        catch (Exception e) {
            this.logger.error("st.StSaleforecastServiceImpl.getSaleforecastModelById", (Throwable)e);
            return null;
        }
    }

    private StSaleforecast getSaleforecastModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.stSaleforecastMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSaleforecastServiceImpl.getSaleforecastModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSaleforecastModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.stSaleforecastMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleforecastServiceImpl.delSaleforecastModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSaleforecastServiceImpl.delSaleforecastModelByCode.num");
        }
    }

    private void deleteSaleforecastModel(Integer saleforecastId) throws ApiException {
        if (null == saleforecastId) {
            return;
        }
        int i = 0;
        try {
            i = this.stSaleforecastMapper.deleteByPrimaryKey(saleforecastId);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleforecastServiceImpl.deleteSaleforecastModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSaleforecastServiceImpl.deleteSaleforecastModel.num");
        }
    }

    private void updateSaleforecastModel(StSaleforecast stSaleforecast) throws ApiException {
        if (null == stSaleforecast) {
            return;
        }
        int i = 0;
        try {
            i = this.stSaleforecastMapper.updateByPrimaryKey(stSaleforecast);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleforecastServiceImpl.updateSaleforecastModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSaleforecastServiceImpl.updateSaleforecastModel.num");
        }
    }

    private void updateStateSaleforecastModel(Integer saleforecastId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == saleforecastId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("saleforecastId", saleforecastId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSaleforecastMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleforecastServiceImpl.updateStateSaleforecastModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSaleforecastServiceImpl.updateStateSaleforecastModel.null");
        }
    }

    private void updateStateSaleforecastModelByCode(String tenantCode, String saleforecastCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)saleforecastCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("saleforecastCode", saleforecastCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSaleforecastMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleforecastServiceImpl.updateStateSaleforecastModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSaleforecastServiceImpl.updateStateSaleforecastModelByCode.null");
        }
    }

    private StSaleforecast makeSaleforecast(StSaleforecastDomain stSaleforecastDomain, StSaleforecast stSaleforecast) {
        if (null == stSaleforecastDomain) {
            return null;
        }
        if (null == stSaleforecast) {
            stSaleforecast = new StSaleforecast();
        }
        try {
            BeanUtils.copyAllPropertys((Object)stSaleforecast, (Object)stSaleforecastDomain);
            return stSaleforecast;
        }
        catch (Exception e) {
            this.logger.error("st.StSaleforecastServiceImpl.makeSaleforecast", (Throwable)e);
            return null;
        }
    }

    private StSaleforecastReDomain makeStSaleforecastReDomain(StSaleforecast stSaleforecast) {
        if (null == stSaleforecast) {
            return null;
        }
        StSaleforecastReDomain stSaleforecastReDomain = new StSaleforecastReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)stSaleforecastReDomain, (Object)stSaleforecast);
            return stSaleforecastReDomain;
        }
        catch (Exception e) {
            this.logger.error("st.StSaleforecastServiceImpl.makeStSaleforecastReDomain", (Throwable)e);
            return null;
        }
    }

    private List<StSaleforecast> querySaleforecastModelPage(Map<String, Object> parammap) {
        try {
            return this.stSaleforecastMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("st.StSaleforecastServiceImpl.querySaleforecastModel", (Throwable)e);
            return null;
        }
    }

    private int countSaleforecast(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.stSaleforecastMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSaleforecastServiceImpl.countSaleforecast", (Throwable)e);
        }
        return i;
    }

    private StSaleforecast createStSaleforecast(StSaleforecastDomain stSaleforecastDomain) {
        String msg = this.checkSaleforecast(stSaleforecastDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSaleforecastServiceImpl.saveSaleforecast.checkSaleforecast", msg);
        }
        StSaleforecast stSaleforecast = this.makeSaleforecast(stSaleforecastDomain, null);
        this.setSaleforecastDefault(stSaleforecast);
        return stSaleforecast;
    }

    @Override
    public List<StChannelsend> saveSaleforecast(StSaleforecastDomain stSaleforecastDomain) throws ApiException {
        StSaleforecast stSaleforecast = this.createStSaleforecast(stSaleforecastDomain);
        this.saveSaleforecastModel(stSaleforecast);
        if (ListUtil.isNotEmpty(stSaleforecastDomain.getStSaleforecastListDomainList())) {
            ArrayList<StSaleforecastListDomain> saleforecastListDomainList = new ArrayList<StSaleforecastListDomain>();
            for (StSaleforecastListDomain stSaleforecastListDomain : stSaleforecastDomain.getStSaleforecastListDomainList()) {
                stSaleforecastListDomain.setSaleforecastCode(stSaleforecast.getSaleforecastCode());
                stSaleforecastListDomain.setTenantCode(stSaleforecast.getTenantCode());
                saleforecastListDomainList.add(stSaleforecastListDomain);
            }
            this.stSaleforecastListService.saveSaleforecastListBatch(saleforecastListDomainList);
        }
        ArrayList<StSaleforecast> list = new ArrayList<StSaleforecast>();
        list.add(stSaleforecast);
        return this.buidPmChannelsend(list, "insert");
    }

    private List<StChannelsend> buidPmChannelsend(List<StSaleforecast> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<StChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<StChannelsendDomain> disChannelsendDomainList = new ArrayList<StChannelsendDomain>();
        for (StSaleforecast promotion : pmPromotionList) {
            StChannelsendDomain pmChannelsendDomain = new StChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getCompanyCode());
            pmChannelsendDomain.setChannelsendType("stSaleforecast");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.stChannelsendService.saveSendOrgChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<StChannelsend> saveSaleforecastBatch(List<StSaleforecastDomain> stSaleforecastDomainList) throws ApiException {
        if (null == stSaleforecastDomainList || stSaleforecastDomainList.isEmpty()) {
            return null;
        }
        ArrayList<StSaleforecast> stSaleforecastList = new ArrayList<StSaleforecast>();
        for (StSaleforecastDomain stSaleforecastDomain : stSaleforecastDomainList) {
            StSaleforecast stSaleforecast = this.createStSaleforecast(stSaleforecastDomain);
            stSaleforecast.getSaleforecastCode();
            stSaleforecastList.add(stSaleforecast);
        }
        this.saveSaleforecastBatchModel(stSaleforecastList);
        return this.buidPmChannelsend(stSaleforecastList, "update");
    }

    @Override
    public List<StChannelsend> updateSaleforecastState(Integer saleforecastId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateSaleforecastModel(saleforecastId, dataState, oldDataState, map);
        StSaleforecast saleforecast = this.getSaleforecast(saleforecastId);
        ArrayList<StSaleforecast> list = new ArrayList<StSaleforecast>();
        list.add(saleforecast);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<StChannelsend> updateSaleforecastStateByCode(String tenantCode, String saleforecastCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateSaleforecastModelByCode(tenantCode, saleforecastCode, dataState, oldDataState, map);
        StSaleforecast saleforecast = this.getSaleforecastByCode(tenantCode, saleforecastCode);
        ArrayList<StSaleforecast> list = new ArrayList<StSaleforecast>();
        list.add(saleforecast);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<StChannelsend> updateSaleforecast(StSaleforecastDomain stSaleforecastDomain) throws ApiException {
        String msg = this.checkSaleforecast(stSaleforecastDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSaleforecastServiceImpl.updateSaleforecast.checkSaleforecast", msg);
        }
        StSaleforecast oldStSaleforecast = this.getSaleforecastModelById(stSaleforecastDomain.getSaleforecastId());
        if (null == oldStSaleforecast) {
            throw new ApiException("st.StSaleforecastServiceImpl.updateSaleforecast.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        StSaleforecast stSaleforecast = this.makeSaleforecast(stSaleforecastDomain, oldStSaleforecast);
        this.setSaleforecastUpdataDefault(stSaleforecast);
        this.updateSaleforecastModel(stSaleforecast);
        if (ListUtil.isNotEmpty(stSaleforecastDomain.getStSaleforecastListDomainList())) {
            for (StSaleforecastListDomain saleforecastListDomain : stSaleforecastDomain.getStSaleforecastListDomainList()) {
                this.stSaleforecastListService.updateSaleforecastList(saleforecastListDomain);
            }
        }
        ArrayList<StSaleforecast> list = new ArrayList<StSaleforecast>();
        list.add(stSaleforecast);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public StSaleforecast getSaleforecast(Integer saleforecastId) {
        if (null == saleforecastId) {
            return null;
        }
        this.logger.error("st.StSaleforecastServiceImpl.getSaleforecastNew", (Object)"============================");
        return this.getSaleforecastModelById(saleforecastId);
    }

    @Override
    public List<StChannelsend> deleteSaleforecast(Integer saleforecastId) throws ApiException {
        StSaleforecast saleforecast = this.getSaleforecast(saleforecastId);
        this.deleteSaleforecastModel(saleforecastId);
        ArrayList<StSaleforecast> list = new ArrayList<StSaleforecast>();
        list.add(saleforecast);
        return this.buidPmChannelsend(list, "insert");
    }

    @Override
    public QueryResult<StSaleforecast> querySaleforecastPage(Map<String, Object> map) {
        List<StSaleforecast> stSaleforecastList = this.querySaleforecastModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSaleforecast(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(stSaleforecastList);
        return queryResult;
    }

    @Override
    public StSaleforecast getSaleforecastByCode(String tenantCode, String saleforecastCode) throws ApiException {
        if (StringUtils.isBlank((String)saleforecastCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("saleforecastCode", saleforecastCode);
        return this.getSaleforecastModelByCode(map);
    }

    @Override
    public List<StChannelsend> deleteSaleforecastByCode(String tenantCode, String saleforecastCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("saleforecastCode", saleforecastCode);
        StSaleforecast saleforecast = this.getSaleforecastByCode(tenantCode, saleforecastCode);
        this.delSaleforecastModelByCode(map);
        ArrayList<StSaleforecast> list = new ArrayList<StSaleforecast>();
        list.add(saleforecast);
        return this.buidPmChannelsend(list, "deleteop");
    }
}

