/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.saleforecast.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.saleforecast.SaleforecastConstants;
import com.yqbsoft.laser.service.saleforecast.dao.StSalequotaMapper;
import com.yqbsoft.laser.service.saleforecast.domain.OcContractDomain;
import com.yqbsoft.laser.service.saleforecast.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaListDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaReDomain;
import com.yqbsoft.laser.service.saleforecast.domain.UmGroupListReDomain;
import com.yqbsoft.laser.service.saleforecast.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.saleforecast.model.StSalequota;
import com.yqbsoft.laser.service.saleforecast.model.StSalequotaList;
import com.yqbsoft.laser.service.saleforecast.model.UserSession;
import com.yqbsoft.laser.service.saleforecast.service.StSalequotaListService;
import com.yqbsoft.laser.service.saleforecast.service.StSalequotaService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StSalequotaServiceImpl
extends BaseServiceImpl
implements StSalequotaService {
    private static final String SYS_CODE = "st.StSalequotaServiceImpl";
    private StSalequotaMapper stSalequotaMapper;
    private StSalequotaListService stSalequotaListService;
    private String cachekey = "Salequota-ChannelCode-TenantCode";

    public void setStSalequotaMapper(StSalequotaMapper stSalequotaMapper) {
        this.stSalequotaMapper = stSalequotaMapper;
    }

    public StSalequotaListService getStSalequotaListService() {
        return this.stSalequotaListService;
    }

    public void setStSalequotaListService(StSalequotaListService stSalequotaListService) {
        this.stSalequotaListService = stSalequotaListService;
    }

    private Date getSysDate() {
        try {
            return this.stSalequotaMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSalequota(StSalequotaDomain stSalequotaDomain) {
        if (null == stSalequotaDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)stSalequotaDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSalequotaDefault(StSalequota stSalequota) {
        if (null == stSalequota) {
            return;
        }
        if (null == stSalequota.getDataState()) {
            stSalequota.setDataState(0);
        }
        if (this.checkStart(stSalequota)) {
            stSalequota.setDataState(2);
        }
        Date date = this.getSysDate();
        if (null == stSalequota.getGmtCreate()) {
            stSalequota.setGmtCreate(date);
        }
        stSalequota.setGmtModified(date);
        if (StringUtils.isBlank((String)stSalequota.getSalequotaCode())) {
            stSalequota.setSalequotaCode(this.getNo(null, "StSalequota", "stSalequota", stSalequota.getTenantCode()));
        }
    }

    private int getSalequotaMaxCode() {
        int code = 0;
        try {
            return this.stSalequotaMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSalequotaMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSalequotaUpdataDefault(StSalequota stSalequota) {
        if (null == stSalequota) {
            return;
        }
        stSalequota.setGmtModified(this.getSysDate());
    }

    private void saveSalequotaModel(StSalequota stSalequota) throws ApiException {
        if (null == stSalequota) {
            return;
        }
        try {
            this.stSalequotaMapper.insert(stSalequota);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.saveSalequotaModel.ex", (Throwable)e);
        }
    }

    private void saveSalequotaBatchModel(List<StSalequota> stSalequotaList) throws ApiException {
        if (null == stSalequotaList || stSalequotaList.isEmpty()) {
            return;
        }
        try {
            this.stSalequotaMapper.insertBatch(stSalequotaList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.saveSalequotaBatchModel.ex", (Throwable)e);
        }
    }

    private StSalequota getSalequotaModelById(Integer salequotaId) {
        if (null == salequotaId) {
            return null;
        }
        try {
            return this.stSalequotaMapper.selectByPrimaryKey(salequotaId);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSalequotaModelById", (Throwable)e);
            return null;
        }
    }

    private StSalequota getSalequotaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.stSalequotaMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSalequotaModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSalequotaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.delSalequotaModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaServiceImpl.delSalequotaModelByCode.num");
        }
    }

    private void deleteSalequotaModel(Integer salequotaId) throws ApiException {
        if (null == salequotaId) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.deleteByPrimaryKey(salequotaId);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.deleteSalequotaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaServiceImpl.deleteSalequotaModel.num");
        }
    }

    private void updateSalequotaModel(StSalequota stSalequota) throws ApiException {
        if (null == stSalequota) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.updateByPrimaryKey(stSalequota);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequotaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequotaModel.num");
        }
    }

    private void updateStateSalequotaModel(Integer salequotaId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == salequotaId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salequotaId", salequotaId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModel.null");
        }
    }

    private void updateStateSalequotaModelByCode(String tenantCode, String salequotaCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModelByCode.null");
        }
    }

    private StSalequota makeSalequota(StSalequotaDomain stSalequotaDomain, StSalequota stSalequota) {
        if (null == stSalequotaDomain) {
            return null;
        }
        if (null == stSalequota) {
            stSalequota = new StSalequota();
        }
        try {
            BeanUtils.copyAllPropertys((Object)stSalequota, (Object)stSalequotaDomain);
            return stSalequota;
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.makeSalequota", (Throwable)e);
            return null;
        }
    }

    private StSalequotaDomain makeStSalequotaDomain(StSalequota stSalequota, StSalequotaDomain stSalequotaDomain) {
        if (null == stSalequota) {
            return null;
        }
        if (null == stSalequotaDomain) {
            stSalequotaDomain = new StSalequotaDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)stSalequotaDomain, (Object)stSalequota);
            return stSalequotaDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private StSalequotaReDomain makeStSalequotaReDomain(StSalequota stSalequota) {
        if (null == stSalequota) {
            return null;
        }
        StSalequotaReDomain stSalequotaReDomain = new StSalequotaReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)stSalequotaReDomain, (Object)stSalequota);
            return stSalequotaReDomain;
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.makeStSalequotaReDomain", (Throwable)e);
            return null;
        }
    }

    private List<StSalequota> querySalequotaModelPage(Map<String, Object> parammap) {
        try {
            return this.stSalequotaMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.querySalequotaModel", (Throwable)e);
            return null;
        }
    }

    private int countSalequota(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.stSalequotaMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.countSalequota", (Throwable)e);
        }
        return i;
    }

    private StSalequota createStSalequota(StSalequotaDomain stSalequotaDomain) {
        String msg = this.checkSalequota(stSalequotaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaServiceImpl.saveSalequota.checkSalequota", msg);
        }
        StSalequota stSalequota = this.makeSalequota(stSalequotaDomain, null);
        this.setSalequotaDefault(stSalequota);
        return stSalequota;
    }

    @Override
    public String saveSalequota(StSalequotaDomain stSalequotaDomain) throws ApiException {
        StSalequota stSalequota = this.createStSalequota(stSalequotaDomain);
        this.saveSalequotaModel(stSalequota);
        this.saveSalequotaList(stSalequota);
        if (null != stSalequota && SaleforecastConstants.dataState_start.intValue() == stSalequota.getDataState().intValue()) {
            this.updateStSalequotaCache(null, stSalequota);
        }
        return stSalequota.getSalequotaCode();
    }

    @Override
    public String saveSalequotaBatch(List<StSalequotaDomain> stSalequotaDomainList) throws ApiException {
        if (null == stSalequotaDomainList || stSalequotaDomainList.isEmpty()) {
            return null;
        }
        ArrayList<StSalequota> stSalequotaList = new ArrayList<StSalequota>();
        String code = "";
        for (StSalequotaDomain stSalequotaDomain : stSalequotaDomainList) {
            StSalequota stSalequota = this.createStSalequota(stSalequotaDomain);
            code = stSalequota.getSalequotaCode();
            stSalequotaList.add(stSalequota);
        }
        this.saveSalequotaBatchModel(stSalequotaList);
        for (StSalequota salequota : stSalequotaList) {
            if (SaleforecastConstants.dataState_start.intValue() != salequota.getDataState().intValue()) continue;
            this.updateStSalequotaCache(null, salequota);
        }
        return code;
    }

    @Override
    public void updateSalequotaState(Integer salequotaId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == salequotaId) {
            return;
        }
        StSalequota salequota = this.getSalequota(salequotaId);
        this.updateStateSalequotaModel(salequotaId, dataState, oldDataState, map);
        if (SaleforecastConstants.dataState_start.intValue() != dataState.intValue()) {
            this.deleteStSalequotaCache(null, salequota);
        } else if (SaleforecastConstants.dataState_start.intValue() == dataState.intValue()) {
            this.updateStSalequotaCache(null, salequota);
        }
    }

    @Override
    public void updateSalequotaStateByCode(String tenantCode, String salequotaCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        StSalequota salequota = this.getSalequotaByCode(tenantCode, salequotaCode);
        this.updateStateSalequotaModelByCode(tenantCode, salequotaCode, dataState, oldDataState, map);
        if (SaleforecastConstants.dataState_start.intValue() != dataState.intValue()) {
            this.deleteStSalequotaCache(null, salequota);
        } else if (SaleforecastConstants.dataState_start.intValue() == dataState.intValue()) {
            this.updateStSalequotaCache(null, salequota);
        }
    }

    @Override
    public void updateSalequota(StSalequotaDomain stSalequotaDomain) throws ApiException {
        String msg = this.checkSalequota(stSalequotaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequota.checkSalequota", msg);
        }
        StSalequota oldStSalequota = this.getSalequotaModelById(stSalequotaDomain.getSalequotaId());
        if (null == oldStSalequota) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequota.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        StSalequota stSalequota = this.makeSalequota(stSalequotaDomain, oldStSalequota);
        String oldKey = this.getSalequotaKey(stSalequota.getChannelCode(), stSalequota.getGoodsClass(), stSalequota.getTenantCode());
        this.setSalequotaUpdataDefault(stSalequota);
        this.updateSalequotaModel(stSalequota);
        this.saveSalequotaList(stSalequota);
        if (SaleforecastConstants.dataState_start.intValue() != stSalequota.getDataState().intValue()) {
            this.deleteStSalequotaCache(oldKey, stSalequota);
        } else if (SaleforecastConstants.dataState_start.intValue() == stSalequota.getDataState().intValue()) {
            this.updateStSalequotaCache(oldKey, stSalequota);
        }
    }

    private void saveSalequotaList(StSalequota stSalequota) {
        if (null == stSalequota || ListUtil.isEmpty(stSalequota.getStSalequotaListDomainList())) {
            return;
        }
        for (StSalequotaListDomain stSalequotaListDomain : stSalequota.getStSalequotaListDomainList()) {
            try {
                BeanUtils.copyAllPropertysNotNull((Object)stSalequotaListDomain, (Object)stSalequota);
            }
            catch (Exception e) {
                this.logger.error("st.StSalequotaServiceImpl.saveStSalequotaList", (Throwable)e);
            }
            this.stSalequotaListService.saveSalequotaList(stSalequotaListDomain);
        }
    }

    @Override
    public StSalequota getSalequota(Integer salequotaId) {
        if (null == salequotaId) {
            return null;
        }
        return this.getSalequotaModelById(salequotaId);
    }

    @Override
    public void deleteSalequota(Integer salequotaId) throws ApiException {
        if (null == salequotaId) {
            return;
        }
        StSalequota salequota = this.getSalequota(salequotaId);
        this.deleteStSalequotaCache(null, salequota);
        this.deleteSalequotaModel(salequotaId);
    }

    @Override
    public QueryResult<StSalequota> querySalequotaPage(Map<String, Object> map) {
        List<StSalequota> stSalequotaList = this.querySalequotaModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSalequota(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(stSalequotaList);
        return queryResult;
    }

    @Override
    public StSalequota getSalequotaByCode(String tenantCode, String salequotaCode) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        return this.getSalequotaModelByCode(map);
    }

    @Override
    public void deleteSalequotaByCode(String tenantCode, String salequotaCode) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        StSalequota salequota = this.getSalequotaByCode(tenantCode, salequotaCode);
        this.deleteStSalequotaCache(null, salequota);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        this.delSalequotaModelByCode(map);
    }

    private String getSalequotaKey(String channelCode, String goodsClass, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("st.StSalequotaServiceImpl.getSaleminnumKey.tenantCode", "tenantCode is null");
        }
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "all";
        }
        if (StringUtils.isBlank((String)goodsClass)) {
            goodsClass = "all";
        }
        return channelCode + "-" + goodsClass + "-" + tenantCode;
    }

    private void deleteStSalequotaCache(String oldKey, StSalequota stSalequota) {
        String json;
        if (null == stSalequota) {
            return;
        }
        String key = this.getSalequotaKey(stSalequota.getChannelCode(), stSalequota.getGoodsClass(), stSalequota.getTenantCode());
        if (StringUtils.isNotBlank((String)oldKey) && !oldKey.equals(key)) {
            key = oldKey;
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cachekey, (String)key)))) {
            return;
        }
        List mlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, StSalequotaDomain.class);
        ArrayList<StSalequotaDomain> mlist2 = new ArrayList<StSalequotaDomain>();
        if (ListUtil.isNotEmpty((Collection)mlist)) {
            for (StSalequotaDomain stSalequotaDomain : mlist) {
                if (stSalequotaDomain.getSalequotaCode().equals(stSalequota.getSalequotaCode())) continue;
                mlist2.add(stSalequotaDomain);
            }
        }
        DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(this.salequotasort(mlist2)));
    }

    private void updateStSalequotaCache(String oldKey, StSalequota stSalequota) {
        if (null == stSalequota) {
            return;
        }
        String key = this.getSalequotaKey(stSalequota.getChannelCode(), stSalequota.getGoodsClass(), stSalequota.getTenantCode());
        if (StringUtils.isNotBlank((String)oldKey) && !oldKey.equals(key)) {
            this.deleteStSalequotaCache(oldKey, stSalequota);
        }
        StSalequotaDomain salequotaDomain = this.makeStSalequotaDomain(stSalequota, null);
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)key);
        if (StringUtils.isBlank((String)json)) {
            ArrayList<StSalequotaDomain> mlist = new ArrayList<StSalequotaDomain>();
            mlist.add(salequotaDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(this.salequotasort(mlist)));
        } else {
            List mlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, StSalequotaDomain.class);
            ArrayList<StSalequotaDomain> mprlist = new ArrayList<StSalequotaDomain>();
            if (ListUtil.isNotEmpty((Collection)mlist)) {
                boolean flag = false;
                for (StSalequotaDomain stSalequotaDomain : mlist) {
                    if (stSalequotaDomain.getSalequotaCode().equals(stSalequota.getSalequotaCode())) {
                        flag = true;
                        mprlist.add(salequotaDomain);
                        continue;
                    }
                    mprlist.add(stSalequotaDomain);
                }
                if (!flag) {
                    mprlist.add(salequotaDomain);
                }
            } else {
                mprlist.add(salequotaDomain);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(this.salequotasort(mprlist)));
        }
    }

    @Override
    public void querySalequotaLoadCache() {
        this.logger.info("StSalequotaServiceImpl.querySalequotaLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_start);
        List<StSalequota> salequotaList = this.querySalequotaModelPage(parammap);
        if (null == salequotaList || salequotaList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("StSalequotaServiceImpl.querySalequotaLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, ArrayList<StSalequotaDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<StSalequotaDomain>>();
        for (StSalequota stSalequota : salequotaList) {
            String key = this.getSalequotaKey(stSalequota.getChannelCode(), stSalequota.getGoodsClass(), stSalequota.getTenantCode());
            StSalequotaDomain stSalequotaDomain = this.makeStSalequotaDomain(stSalequota, null);
            ArrayList<StSalequotaDomain> slist = (ArrayList<StSalequotaDomain>)ddListMap.get(key);
            if (null == slist) {
                slist = new ArrayList<StSalequotaDomain>();
                ddListMap.put(key, slist);
            }
            slist.add(stSalequotaDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.salequotasort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("StSalequotaServiceImpl.querySalequotaLoadCache", (Object)"===========add-end==========");
    }

    private List<StSalequotaDomain> salequotasort(List<StSalequotaDomain> mlist) {
        if (ListUtil.isEmpty(mlist)) {
            return null;
        }
        Collections.sort(mlist, new Comparator<StSalequotaDomain>(){

            @Override
            public int compare(StSalequotaDomain arg0, StSalequotaDomain arg1) {
                if (arg0.getSalequotaWeight() > arg1.getSalequotaWeight()) {
                    return 1;
                }
                if (arg0.getSalequotaWeight() < arg1.getSalequotaWeight()) {
                    return -1;
                }
                return arg0.getSalequotaWeight().compareTo(arg0.getSalequotaWeight());
            }
        });
        return mlist;
    }

    @Override
    public void makeSalequotaCache() {
        this.saveStart();
        this.saveEnd();
        this.saveDel();
    }

    @Override
    public String sendUpdateSalequota(OcContractDomain ocContractDomain) throws ApiException {
        List salequotaList;
        String goodsClass;
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return "error";
        }
        String channelCode = ocContractDomain.getChannelCode();
        String tenantCode = ocContractDomain.getTenantCode();
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "all";
        }
        if (StringUtils.isBlank((String)(goodsClass = ocContractDomain.getGoodsList().get(0).getGoodsClass()))) {
            goodsClass = "all";
        }
        if (ListUtil.isEmpty((Collection)(salequotaList = SupDisUtil.getMapListJson((String)this.cachekey, (String)(channelCode + "-" + goodsClass + "-" + tenantCode), StSalequotaDomain.class)))) {
            if (!"all".equals(channelCode)) {
                salequotaList = SupDisUtil.getMapListJson((String)this.cachekey, (String)("all-" + goodsClass + "-" + tenantCode), StSalequotaDomain.class);
            }
            if (!"all".equals(goodsClass)) {
                salequotaList = SupDisUtil.getMapListJson((String)this.cachekey, (String)("all-all-" + tenantCode), StSalequotaDomain.class);
            }
            if (ListUtil.isEmpty((Collection)salequotaList)) {
                return "success";
            }
        }
        UserSession userSession = this.getUserSession(ocContractDomain.getMemberBcode(), tenantCode);
        Map<String, Object> objMap = this.makeObject(userSession);
        Map<Object, Object> contractGoodsMap = new HashMap();
        HashMap<String, Object> salequotaMap = new HashMap<String, Object>();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        HashMap<String, List<String>> memberMap = new HashMap<String, List<String>>();
        this.makeMem(salequotaList, salequotaMap, map, memberMap);
        HashMap returnMap = new HashMap();
        ArrayList stSalequotaDomainList = new ArrayList();
        BigDecimal num = BigDecimal.valueOf(0L);
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            contractGoodsMap = this.makeContractGoods(ocContractGoodsDomain);
            StSalequotaDomain stSalequotaDomain = this.checkSalequota(map, memberMap, contractGoodsMap, salequotaMap, objMap);
            if (null == stSalequotaDomain) continue;
            if ("0".equals(stSalequotaDomain.getSalequotaNumtype())) {
                num = ocContractGoodsDomain.getGoodsCweight().multiply(ocContractGoodsDomain.getGoodsCamount());
            } else if ("1".equals(stSalequotaDomain.getSalequotaNumtype())) {
                num = ocContractGoodsDomain.getPricesetNprice().multiply(ocContractGoodsDomain.getGoodsCamount());
            }
            if (num.compareTo(stSalequotaDomain.getSalequotaNums()) < 1) {
                stSalequotaDomain.setSalequotaNums(stSalequotaDomain.getSalequotaNums().subtract(num));
                stSalequotaDomain.setSalequotaNumu(stSalequotaDomain.getSalequotaNumu().add(num));
                this.saveStSalequotaList(stSalequotaDomain, ocContractGoodsDomain);
                continue;
            }
            return "error";
        }
        return "success";
    }

    @Override
    public String sendBackSalequota(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return "error";
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            this.saveBackStSalequotaList(ocContractGoodsDomain);
        }
        return "success";
    }

    private void saveStSalequotaList(StSalequotaDomain stSalequotaDomain, OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salequotaListOpno", ocContractGoodsDomain.getContractBillcode());
        map.put("salequotaListOpno1", ocContractGoodsDomain.getContractGoodsCode());
        map.put("salequotaListOpno2", "1");
        map.put("salequotaListOpuser", ocContractGoodsDomain.getMemberBcode());
        map.put("tenantCode", ocContractGoodsDomain.getTenantCode());
        QueryResult<StSalequotaList> stSalequotaListQueryResult = this.stSalequotaListService.querySalequotaListPage(map);
        if (null != stSalequotaListQueryResult && ListUtil.isNotEmpty((Collection)stSalequotaListQueryResult.getList())) {
            return;
        }
        StSalequotaListDomain stSalequotaListDomain = new StSalequotaListDomain();
        stSalequotaListDomain.setSalequotaListOpno(ocContractGoodsDomain.getContractBillcode());
        stSalequotaListDomain.setSalequotaListOpno1(ocContractGoodsDomain.getContractGoodsCode());
        stSalequotaListDomain.setSalequotaListOpno2("1");
        stSalequotaListDomain.setSalequotaListOpuser(ocContractGoodsDomain.getMemberBcode());
        stSalequotaListDomain.setSalequotaListOpuserinfo(ocContractGoodsDomain.getMemberBname());
        BigDecimal num = "0".equals(stSalequotaDomain.getSalequotaNumtype()) ? ocContractGoodsDomain.getGoodsCweight() : ocContractGoodsDomain.getPricesetNprice();
        stSalequotaListDomain.setSalequotaListNum(num.multiply(ocContractGoodsDomain.getGoodsCamount()));
        stSalequotaListDomain.setSalequotaListMoney(ocContractGoodsDomain.getPricesetNprice());
        ArrayList<StSalequotaListDomain> listDomainList = new ArrayList<StSalequotaListDomain>();
        listDomainList.add(stSalequotaListDomain);
        StSalequota salequota = this.getSalequotaByCode(stSalequotaDomain.getTenantCode(), stSalequotaDomain.getSalequotaCode());
        StSalequotaDomain salequotaDomain = this.makeStSalequotaDomain(salequota, null);
        salequotaDomain.setStSalequotaListDomainList(listDomainList);
        salequotaDomain.setSalequotaNums(stSalequotaDomain.getSalequotaNums());
        salequotaDomain.setSalequotaNumu(stSalequotaDomain.getSalequotaNumu());
        this.updateSalequota(salequotaDomain);
    }

    private void saveBackStSalequotaList(OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salequotaListOpno", ocContractGoodsDomain.getContractBillcode());
        map.put("salequotaListOpno1", ocContractGoodsDomain.getContractGoodsCode());
        map.put("salequotaListOpno2", "-1");
        map.put("salequotaListOpuser", ocContractGoodsDomain.getMemberBcode());
        map.put("tenantCode", ocContractGoodsDomain.getTenantCode());
        QueryResult<StSalequotaList> stSalequotaListQueryResult = this.stSalequotaListService.querySalequotaListPage(map);
        if (null != stSalequotaListQueryResult && ListUtil.isNotEmpty((Collection)stSalequotaListQueryResult.getList())) {
            return;
        }
        map.put("salequotaListOpno2", "1");
        QueryResult<StSalequotaList> queryResult = this.stSalequotaListService.querySalequotaListPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return;
        }
        StSalequotaList stSalequotaList = (StSalequotaList)queryResult.getList().get(0);
        StSalequota salequota = this.getSalequotaByCode(stSalequotaList.getSalequotaCode(), ocContractGoodsDomain.getTenantCode());
        if (null == salequota) {
            return;
        }
        salequota.setSalequotaNums(salequota.getSalequotaNums().add(stSalequotaList.getSalequotaListNum()));
        salequota.setSalequotaNumu(salequota.getSalequotaNumu().subtract(stSalequotaList.getSalequotaListNum()));
        StSalequotaListDomain stSalequotaListDomain = new StSalequotaListDomain();
        try {
            BeanUtils.copyAllPropertys((Object)stSalequotaListDomain, (Object)salequota);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.saveStSalequotaList", (Throwable)e);
        }
        stSalequotaListDomain.setSalequotaListOpno(ocContractGoodsDomain.getContractBillcode());
        stSalequotaListDomain.setSalequotaListOpno1(ocContractGoodsDomain.getContractGoodsCode());
        stSalequotaListDomain.setSalequotaListOpno2("-1");
        stSalequotaListDomain.setSalequotaListOpuser(ocContractGoodsDomain.getMemberBcode());
        stSalequotaListDomain.setSalequotaListOpuserinfo(ocContractGoodsDomain.getMemberBname());
        BigDecimal num = "0".equals(salequota.getSalequotaNumtype()) ? ocContractGoodsDomain.getGoodsCweight() : ocContractGoodsDomain.getPricesetNprice();
        stSalequotaListDomain.setSalequotaListNum(num.multiply(ocContractGoodsDomain.getGoodsCamount()));
        stSalequotaListDomain.setSalequotaListMoney(ocContractGoodsDomain.getPricesetNprice());
        ArrayList<StSalequotaListDomain> listDomainList = new ArrayList<StSalequotaListDomain>();
        listDomainList.add(stSalequotaListDomain);
        StSalequotaDomain stSalequotaDomain = this.makeStSalequotaDomain(salequota, null);
        stSalequotaDomain.setStSalequotaListDomainList(listDomainList);
        stSalequotaDomain.setSalequotaNums(salequota.getSalequotaNums());
        stSalequotaDomain.setSalequotaNumu(salequota.getSalequotaNumu());
        this.updateSalequota(stSalequotaDomain);
    }

    private UserSession getUserSession(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        String result = this.internalInvoke("um.user.getUserinfoByCode", this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{userinfoCode, tenantCode}));
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(result, UmUserinfoReDomainBean.class);
        if (null == umUserinfoReDomainBean) {
            this.logger.error("st.StSalequotaServiceImpl.getUserSession", (Object)(userinfoCode + "," + tenantCode));
            return null;
        }
        UserSession reuserSession = new UserSession();
        try {
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)umUserinfoReDomainBean);
            reuserSession.setUserPcode(umUserinfoReDomainBean.getUserinfoCode());
            reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        }
        catch (Exception exception) {
            // empty catch block
        }
        reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        String groupResult = this.internalInvoke("um.group.queryGroupListPage", this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{userinfoCode, tenantCode}));
        SupQueryResult qmem = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(groupResult, SupQueryResult.class);
        if (null != qmem && ListUtil.isNotEmpty((Collection)qmem.getList())) {
            List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)qmem.getList()), UmGroupListReDomain.class);
            if (ListUtil.isEmpty((Collection)pList)) {
                return reuserSession;
            }
            reuserSession.setGroupCode(((UmGroupListReDomain)pList.get(0)).getGroupCode());
            reuserSession.setGroupName(((UmGroupListReDomain)pList.get(0)).getGroupName());
        }
        return reuserSession;
    }

    private StSalequotaDomain checkSalequota(Map<String, List<String>> map, Map<String, List<String>> memberMap, Map<String, Object> contractGoodsMap, Map<String, Object> salequotaMap, Map<String, Object> objMap) {
        if (null == map || null == salequotaMap || null == contractGoodsMap || null == objMap) {
            return null;
        }
        String key = this.checkConf(map, contractGoodsMap);
        this.logger.error("\u5546\u54c1\u9650\u989dkey", (Object)key);
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        String memberkey = this.checkConf(memberMap, objMap);
        if (StringUtils.isBlank((String)key)) {
            memberkey = "all-all";
        }
        this.logger.error("\u5546\u54c1\u9650\u989dmemberkey", (Object)memberkey);
        return (StSalequotaDomain)salequotaMap.get(key + "-" + memberkey);
    }

    private void makeMem(List<StSalequotaDomain> salequotaList, Map<String, Object> salequotaMap, Map<String, List<String>> map, Map<String, List<String>> memberMap) {
        if (ListUtil.isEmpty(salequotaList)) {
            return;
        }
        Object object = null;
        String key = null;
        for (StSalequotaDomain stSalequotaDomain : salequotaList) {
            List<String> list = map.get(stSalequotaDomain.getSalequotaSpro());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(stSalequotaDomain.getSalequotaSpro(), list);
            }
            list.add(stSalequotaDomain.getSalequotaSprovalue());
            List<String> memberList = memberMap.get(stSalequotaDomain.getSalequotaUpro());
            if (null == memberList) {
                memberList = new ArrayList<String>();
                memberMap.put(stSalequotaDomain.getSalequotaUpro(), memberList);
            }
            memberList.add(stSalequotaDomain.getSalequotaUprovalue());
            key = stSalequotaDomain.getSalequotaSpro() + "-" + stSalequotaDomain.getSalequotaSprovalue() + "-" + stSalequotaDomain.getSalequotaUpro() + "-" + stSalequotaDomain.getSalequotaUprovalue();
            object = salequotaMap.get(key);
            if (null != object) continue;
            salequotaMap.put(key, stSalequotaDomain);
        }
    }

    private Map<String, Object> makeObject(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        Map obj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)userSession), String.class, Object.class);
        return obj;
    }

    private Map<String, Object> makeContractGoods(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return null;
        }
        Map obj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain), String.class, Object.class);
        return obj;
    }

    private String checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        String flag = null;
        block0: for (String keys : map.keySet()) {
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)keys);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs = objValue.toString().split("\\,");
                flag = null;
                for (String o : otrs) {
                    String cond = this.cond(valueList, o);
                    if (null == cond) continue;
                    flag = keys + "-" + cond;
                    continue block0;
                }
                continue;
            }
            String cond = this.cond(valueList, objValue);
            if (null == cond) continue;
            flag = keys + "-" + cond;
            break;
        }
        return flag;
    }

    private String cond(List<String> valueList, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return null;
        }
        String flag = null;
        if (null == objValue) {
            objValue = "";
        }
        for (String value : valueList) {
            if (!value.contains(objValue.toString())) continue;
            flag = value;
            return flag;
        }
        return flag;
    }

    private void saveDel() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_del);
        List<StSalequota> stSalequotas = this.querySalequotaModelPage(parammap);
        if (null == stSalequotas || stSalequotas.isEmpty()) {
            return;
        }
        for (StSalequota stSalequota : stSalequotas) {
            try {
                this.updateSalequotaState(stSalequota.getSalequotaId(), SaleforecastConstants.dataState_no, SaleforecastConstants.dataState_del, null);
            }
            catch (Exception e) {
                this.logger.error("st.StSalequotaServiceImpl.saveEnd.e", (Object)stSalequota.getSalequotaCode(), (Throwable)e);
            }
        }
    }

    private void saveEnd() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_start);
        List<StSalequota> stSalequotas = this.querySalequotaModelPage(parammap);
        if (null == stSalequotas || stSalequotas.isEmpty()) {
            return;
        }
        for (StSalequota stSalequota : stSalequotas) {
            if (null == stSalequota.getSalequotaEnd() || stSalequota.getSalequotaEnd().getTime() > this.getSysDate().getTime()) continue;
            try {
                this.updateSalequotaState(stSalequota.getSalequotaId(), SaleforecastConstants.dataState_no, SaleforecastConstants.dataState_start, null);
            }
            catch (Exception e) {
                this.logger.error("st.StSalequotaServiceImpl.saveEnd.e", (Object)stSalequota.getSalequotaCode(), (Throwable)e);
            }
        }
    }

    private void saveStart() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_add);
        List<StSalequota> stSalequotas = this.querySalequotaModelPage(parammap);
        if (null == stSalequotas || stSalequotas.isEmpty()) {
            return;
        }
        for (StSalequota stSalequota : stSalequotas) {
            if (!this.checkStart(stSalequota)) continue;
            try {
                this.updateSalequotaState(stSalequota.getSalequotaId(), SaleforecastConstants.dataState_start, SaleforecastConstants.dataState_add, null);
            }
            catch (Exception e) {
                this.logger.error("st.StSalequotaServiceImpl.saveStart.e", (Object)stSalequota.getSalequotaCode(), (Throwable)e);
            }
        }
    }

    private boolean checkStart(StSalequota stSalequota) {
        boolean startDate = false;
        boolean endDate = false;
        if (null == stSalequota.getSalequotaStart()) {
            startDate = true;
        }
        if (null != stSalequota.getSalequotaStart() && stSalequota.getSalequotaStart().getTime() < this.getSysDate().getTime()) {
            startDate = true;
        }
        if (null == stSalequota.getSalequotaEnd()) {
            endDate = true;
        }
        if (null != stSalequota.getSalequotaEnd() && stSalequota.getSalequotaEnd().getTime() > this.getSysDate().getTime()) {
            endDate = true;
        }
        return startDate && endDate;
    }
}

