/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.saleforecast.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.saleforecast.SaleforecastConstants;
import com.yqbsoft.laser.service.saleforecast.dao.StSalequotaMapper;
import com.yqbsoft.laser.service.saleforecast.domain.GoodsDomain;
import com.yqbsoft.laser.service.saleforecast.domain.OcContractDomain;
import com.yqbsoft.laser.service.saleforecast.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.saleforecast.domain.SalequotaGoods;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaListDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaReDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaUserlistDomain;
import com.yqbsoft.laser.service.saleforecast.domain.UmGroupListReDomain;
import com.yqbsoft.laser.service.saleforecast.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.saleforecast.model.StSalequota;
import com.yqbsoft.laser.service.saleforecast.model.StSalequotaList;
import com.yqbsoft.laser.service.saleforecast.model.UserSession;
import com.yqbsoft.laser.service.saleforecast.service.StSalequotaListService;
import com.yqbsoft.laser.service.saleforecast.service.StSalequotaService;
import com.yqbsoft.laser.service.saleforecast.service.StSalequotaUserlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StSalequotaServiceImpl
extends BaseServiceImpl
implements StSalequotaService {
    private static final String SYS_CODE = "st.StSalequotaServiceImpl";
    private StSalequotaMapper stSalequotaMapper;
    private StSalequotaListService stSalequotaListService;
    StSalequotaUserlistService stSalequotaUserlistService;
    private String cachekey = "Salequota-";
    private String cachekey_main = "Salequota-";
    private String cachekey_list = "Salequota-";

    public void setStSalequotaMapper(StSalequotaMapper stSalequotaMapper) {
        this.stSalequotaMapper = stSalequotaMapper;
    }

    public void setStSalequotaUserlistService(StSalequotaUserlistService stSalequotaUserlistService) {
        this.stSalequotaUserlistService = stSalequotaUserlistService;
    }

    public StSalequotaListService getStSalequotaListService() {
        return this.stSalequotaListService;
    }

    public void setStSalequotaListService(StSalequotaListService stSalequotaListService) {
        this.stSalequotaListService = stSalequotaListService;
    }

    private Date getSysDate() {
        try {
            return this.stSalequotaMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSalequota(StSalequotaDomain stSalequotaDomain) {
        if (null == stSalequotaDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)stSalequotaDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSalequotaDefault(StSalequota stSalequota) {
        if (null == stSalequota) {
            return;
        }
        if (null == stSalequota.getDataState()) {
            stSalequota.setDataState(0);
        }
        if (this.checkStart(stSalequota)) {
            stSalequota.setDataState(2);
        }
        Date date = this.getSysDate();
        if (null == stSalequota.getGmtCreate()) {
            stSalequota.setGmtCreate(date);
        }
        stSalequota.setGmtModified(date);
        if (StringUtils.isBlank((String)stSalequota.getSalequotaCode())) {
            stSalequota.setSalequotaCode(this.getNo(null, "StSalequota", "stSalequota", stSalequota.getTenantCode()));
        }
    }

    private int getSalequotaMaxCode() {
        int code = 0;
        try {
            return this.stSalequotaMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSalequotaMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSalequotaUpdataDefault(StSalequota stSalequota) {
        if (null == stSalequota) {
            return;
        }
        stSalequota.setGmtModified(this.getSysDate());
    }

    private void saveSalequotaModel(StSalequota stSalequota) throws ApiException {
        if (null == stSalequota) {
            return;
        }
        try {
            this.stSalequotaMapper.insert(stSalequota);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.saveSalequotaModel.ex", (Throwable)e);
        }
    }

    private void saveSalequotaBatchModel(List<StSalequota> stSalequotaList) throws ApiException {
        if (null == stSalequotaList || stSalequotaList.isEmpty()) {
            return;
        }
        try {
            this.stSalequotaMapper.insertBatch(stSalequotaList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.saveSalequotaBatchModel.ex", (Throwable)e);
        }
    }

    private StSalequota getSalequotaModelById(Integer salequotaId) {
        if (null == salequotaId) {
            return null;
        }
        try {
            return this.stSalequotaMapper.selectByPrimaryKey(salequotaId);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSalequotaModelById", (Throwable)e);
            return null;
        }
    }

    private StSalequota getSalequotaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.stSalequotaMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.getSalequotaModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSalequotaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.delSalequotaModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaServiceImpl.delSalequotaModelByCode.num");
        }
    }

    private void deleteSalequotaModel(Integer salequotaId) throws ApiException {
        if (null == salequotaId) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.deleteByPrimaryKey(salequotaId);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.deleteSalequotaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaServiceImpl.deleteSalequotaModel.num");
        }
    }

    private void updateSalequotaModel(StSalequota stSalequota) throws ApiException {
        if (null == stSalequota) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.updateByPrimaryKey(stSalequota);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequotaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequotaModel.num");
        }
    }

    private void updateStateSalequotaModel(Integer salequotaId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == salequotaId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salequotaId", salequotaId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModel.null");
        }
    }

    private void updateStateSalequotaModelByCode(String tenantCode, String salequotaCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSalequotaMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSalequotaServiceImpl.updateStateSalequotaModelByCode.null");
        }
    }

    private StSalequota makeSalequota(StSalequotaDomain stSalequotaDomain, StSalequota stSalequota) {
        if (null == stSalequotaDomain) {
            return null;
        }
        if (null == stSalequota) {
            stSalequota = new StSalequota();
        }
        try {
            BeanUtils.copyAllPropertys((Object)stSalequota, (Object)stSalequotaDomain);
            return stSalequota;
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.makeSalequota", (Throwable)e);
            return null;
        }
    }

    private StSalequotaDomain makeStSalequotaDomain(StSalequota stSalequota, StSalequotaDomain stSalequotaDomain) {
        if (null == stSalequota) {
            return null;
        }
        if (null == stSalequotaDomain) {
            stSalequotaDomain = new StSalequotaDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)stSalequotaDomain, (Object)stSalequota);
            return stSalequotaDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private StSalequotaReDomain makeStSalequotaReDomain(StSalequota stSalequota) {
        if (null == stSalequota) {
            return null;
        }
        StSalequotaReDomain stSalequotaReDomain = new StSalequotaReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)stSalequotaReDomain, (Object)stSalequota);
            return stSalequotaReDomain;
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.makeStSalequotaReDomain", (Throwable)e);
            return null;
        }
    }

    private List<StSalequota> querySalequotaModelPage(Map<String, Object> parammap) {
        try {
            return this.stSalequotaMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.querySalequotaModel", (Throwable)e);
            return null;
        }
    }

    private int countSalequota(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.stSalequotaMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.countSalequota", (Throwable)e);
        }
        return i;
    }

    private StSalequota createStSalequota(StSalequotaDomain stSalequotaDomain) {
        String msg = this.checkSalequota(stSalequotaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaServiceImpl.saveSalequota.checkSalequota", msg);
        }
        StSalequota stSalequota = this.makeSalequota(stSalequotaDomain, null);
        this.setSalequotaDefault(stSalequota);
        return stSalequota;
    }

    @Override
    public String saveSalequota(StSalequotaDomain stSalequotaDomain) throws ApiException {
        StSalequota stSalequota = this.createStSalequota(stSalequotaDomain);
        this.saveSalequotaModel(stSalequota);
        this.saveSalequotaList(stSalequota);
        if (null != stSalequota && SaleforecastConstants.dataState_start.intValue() == stSalequota.getDataState().intValue()) {
            this.updateStSalequotaCache(null, stSalequota);
        }
        return stSalequota.getSalequotaCode();
    }

    @Override
    public String saveSalequotaBatch(List<StSalequotaDomain> stSalequotaDomainList) throws ApiException {
        if (null == stSalequotaDomainList || stSalequotaDomainList.isEmpty()) {
            return null;
        }
        ArrayList<StSalequota> stSalequotaList = new ArrayList<StSalequota>();
        String code = "";
        for (StSalequotaDomain stSalequotaDomain : stSalequotaDomainList) {
            StSalequota stSalequota = this.createStSalequota(stSalequotaDomain);
            code = stSalequota.getSalequotaCode();
            stSalequotaList.add(stSalequota);
        }
        this.saveSalequotaBatchModel(stSalequotaList);
        for (StSalequota salequota : stSalequotaList) {
            if (SaleforecastConstants.dataState_start.intValue() != salequota.getDataState().intValue()) continue;
            this.updateStSalequotaCache(null, salequota);
        }
        return code;
    }

    @Override
    public void updateSalequotaState(Integer salequotaId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == salequotaId) {
            return;
        }
        StSalequota salequota = this.getSalequota(salequotaId);
        this.updateStateSalequotaModel(salequotaId, dataState, oldDataState, map);
        if (SaleforecastConstants.dataState_start.intValue() != dataState.intValue()) {
            this.deleteStSalequotaCache(null, salequota);
        } else if (SaleforecastConstants.dataState_start.intValue() == dataState.intValue()) {
            this.updateStSalequotaCache(null, salequota);
        }
    }

    @Override
    public void updateSalequotaStateByCode(String tenantCode, String salequotaCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        StSalequota salequota = this.getSalequotaByCode(tenantCode, salequotaCode);
        this.updateStateSalequotaModelByCode(tenantCode, salequotaCode, dataState, oldDataState, map);
        if (SaleforecastConstants.dataState_start.intValue() != dataState.intValue()) {
            this.deleteStSalequotaCache(null, salequota);
        } else if (SaleforecastConstants.dataState_start.intValue() == dataState.intValue()) {
            this.updateStSalequotaCache(null, salequota);
        }
    }

    @Override
    public void updateSalequota(StSalequotaDomain stSalequotaDomain) throws ApiException {
        String msg = this.checkSalequota(stSalequotaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequota.checkSalequota", msg);
        }
        StSalequota oldStSalequota = this.getSalequotaModelById(stSalequotaDomain.getSalequotaId());
        if (null == oldStSalequota) {
            throw new ApiException("st.StSalequotaServiceImpl.updateSalequota.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        StSalequota stSalequota = this.makeSalequota(stSalequotaDomain, oldStSalequota);
        String oldKey = this.getSalequotaKey(stSalequota.getChannelCode(), stSalequota.getGoodsClass(), stSalequota.getTenantCode());
        this.setSalequotaUpdataDefault(stSalequota);
        this.updateSalequotaModel(stSalequota);
        this.saveSalequotaList(stSalequota);
        if (SaleforecastConstants.dataState_start.intValue() != stSalequota.getDataState().intValue()) {
            this.deleteStSalequotaCache(oldKey, stSalequota);
        } else if (SaleforecastConstants.dataState_start.intValue() == stSalequota.getDataState().intValue()) {
            this.updateStSalequotaCache(oldKey, stSalequota);
        }
    }

    private void saveSalequotaList(StSalequota stSalequota) {
        if (null == stSalequota || ListUtil.isEmpty(stSalequota.getStSalequotaListDomainList())) {
            return;
        }
        for (StSalequotaListDomain stSalequotaListDomain : stSalequota.getStSalequotaListDomainList()) {
            try {
                BeanUtils.copyAllPropertysNotNull((Object)stSalequotaListDomain, (Object)stSalequota);
            }
            catch (Exception e) {
                this.logger.error("st.StSalequotaServiceImpl.saveStSalequotaList", (Throwable)e);
            }
            this.stSalequotaListService.saveSalequotaList(stSalequotaListDomain);
        }
    }

    @Override
    public StSalequota getSalequota(Integer salequotaId) {
        if (null == salequotaId) {
            return null;
        }
        return this.getSalequotaModelById(salequotaId);
    }

    @Override
    public void deleteSalequota(Integer salequotaId) throws ApiException {
        if (null == salequotaId) {
            return;
        }
        StSalequota salequota = this.getSalequota(salequotaId);
        this.deleteStSalequotaCache(null, salequota);
        this.deleteSalequotaModel(salequotaId);
    }

    @Override
    public QueryResult<StSalequota> querySalequotaPage(Map<String, Object> map) {
        List<StSalequota> stSalequotaList = this.querySalequotaModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSalequota(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(stSalequotaList);
        return queryResult;
    }

    @Override
    public StSalequota getSalequotaByCode(String tenantCode, String salequotaCode) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        return this.getSalequotaModelByCode(map);
    }

    @Override
    public void deleteSalequotaByCode(String tenantCode, String salequotaCode) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        StSalequota salequota = this.getSalequotaByCode(tenantCode, salequotaCode);
        this.deleteStSalequotaCache(null, salequota);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        this.delSalequotaModelByCode(map);
    }

    private String getSalequotaKey(String channelCode, String goodsClass, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("st.StSalequotaServiceImpl.getSaleminnumKey.tenantCode", "tenantCode is null");
        }
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "all";
        }
        if (StringUtils.isBlank((String)goodsClass)) {
            goodsClass = "all";
        }
        return channelCode + "-" + goodsClass + "-" + tenantCode;
    }

    private Map<String, String> getCacheKey(String channelCode, String goodsClass, String tenantCode) {
        String cachechannelkey = this.getSalequotaKey(channelCode, goodsClass, tenantCode);
        Map promap = DisUtil.getMapAll((String)(this.cachekey + cachechannelkey));
        if (MapUtil.isEmpty((Map)promap)) {
            cachechannelkey = this.getSalequotaKey("all", goodsClass, tenantCode);
            promap = DisUtil.getMapAll((String)(this.cachekey + cachechannelkey));
        }
        if (MapUtil.isEmpty((Map)promap)) {
            cachechannelkey = this.getSalequotaKey("all", "all", tenantCode);
            promap = DisUtil.getMapAll((String)(this.cachekey + cachechannelkey));
        }
        return promap;
    }

    @Override
    public SalequotaGoods checkSalequota(SalequotaGoods salequotaGoods) throws ApiException {
        if (null == salequotaGoods || ListUtil.isEmpty(salequotaGoods.getGoodsDomainList())) {
            return null;
        }
        salequotaGoods.setFlag(true);
        Map<String, String> promap = this.getCacheKey(salequotaGoods.getChannelCode(), salequotaGoods.getGoodsClass(), salequotaGoods.getTenantCode());
        if (MapUtil.isEmpty(promap)) {
            salequotaGoods.setQuotaflag(false);
            return salequotaGoods;
        }
        for (GoodsDomain goodsDomain : salequotaGoods.getGoodsDomainList()) {
            this.checkGoodsDomain(goodsDomain, salequotaGoods.getMemberBcode(), salequotaGoods.getTenantCode(), promap);
        }
        return salequotaGoods;
    }

    private void checkGoodsDomain(GoodsDomain goodsDomain, String userinfoCode, String tenantCode, Map<String, String> promap) {
        if (null == goodsDomain || MapUtil.isEmpty(promap)) {
            return;
        }
        Object obj = null;
        StSalequotaDomain stSalequotaDomain = null;
        StSalequotaListDomain stSalequotaListDomain = null;
        List<StSalequotaDomain> stSalequotaDomainList = new ArrayList<StSalequotaDomain>();
        for (String key : promap.keySet()) {
            obj = BeanUtils.newForceGetProperty((Object)goodsDomain, (String)key);
            Map codemap = DisUtil.getRemotMapAll((String)(this.cachekey_main + key + "-" + key + "-" + obj));
            List<StSalequotaDomain> reList = this.getList(codemap);
            if (!ListUtil.isNotEmpty(reList)) continue;
            stSalequotaDomainList.addAll(reList);
        }
        if (ListUtil.isEmpty(stSalequotaDomainList)) {
            goodsDomain.setQuotaflag(false);
            return;
        }
        stSalequotaDomain = this.checkQuotaUm(userinfoCode, tenantCode, stSalequotaDomainList = this.salequotasort(stSalequotaDomainList));
        if (null == stSalequotaDomain) {
            goodsDomain.setQuotaflag(false);
            return;
        }
        goodsDomain.setSalequotaCode(stSalequotaDomain.getSalequotaCode());
        goodsDomain.setQuotaflag(true);
        if (null == stSalequotaDomain.getSalequotaNuma()) {
            stSalequotaDomain.setSalequotaNuma(BigDecimal.ZERO);
        }
        if (null == stSalequotaDomain.getSalequotaNumu()) {
            stSalequotaDomain.setSalequotaNumu(BigDecimal.ZERO);
        }
        if (null == stSalequotaDomain.getSalequotaNums()) {
            stSalequotaDomain.setSalequotaNums(BigDecimal.ZERO);
        }
        String salequotaSort = stSalequotaDomain.getSalequotaSort();
        goodsDomain.setSalequotaNumtype(stSalequotaDomain.getSalequotaNumtype());
        goodsDomain.setSalequotaNuma(stSalequotaDomain.getSalequotaNuma());
        goodsDomain.setSalequotaNumu(stSalequotaDomain.getSalequotaNumu());
        goodsDomain.setSalequotaNums(stSalequotaDomain.getSalequotaNums());
        String json = DisUtil.getRemot((String)(this.cachekey_list + stSalequotaDomain.getSalequotaCode() + "-" + userinfoCode + "-" + tenantCode));
        if (StringUtils.isNotBlank((String)json)) {
            stSalequotaListDomain = (StSalequotaListDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, StSalequotaListDomain.class);
        }
        if (null != stSalequotaListDomain) {
            goodsDomain.setSalequotaListCode(stSalequotaListDomain.getSalequotaListCode());
        }
        if (!"0".equals(salequotaSort) && null != stSalequotaListDomain) {
            if (null == stSalequotaListDomain.getSalequotaNuma()) {
                stSalequotaListDomain.setSalequotaNuma(BigDecimal.ZERO);
            }
            if (null == stSalequotaListDomain.getSalequotaNumu()) {
                stSalequotaListDomain.setSalequotaNumu(BigDecimal.ZERO);
            }
            if (null == stSalequotaListDomain.getSalequotaNums()) {
                stSalequotaListDomain.setSalequotaNums(BigDecimal.ZERO);
            }
            if ("2".equals(salequotaSort)) {
                goodsDomain.setSalequotaNumtype(stSalequotaListDomain.getSalequotaNumtype());
                goodsDomain.setSalequotaNuma(stSalequotaListDomain.getSalequotaNuma());
                goodsDomain.setSalequotaNumu(stSalequotaListDomain.getSalequotaNumu());
                goodsDomain.setSalequotaNums(stSalequotaDomain.getSalequotaNums().compareTo(stSalequotaListDomain.getSalequotaNums()) <= 0 ? stSalequotaDomain.getSalequotaNums() : stSalequotaListDomain.getSalequotaNums());
            } else {
                goodsDomain.setSalequotaNumtype(stSalequotaListDomain.getSalequotaNumtype());
                goodsDomain.setSalequotaNuma(stSalequotaListDomain.getSalequotaNuma());
                goodsDomain.setSalequotaNumu(stSalequotaListDomain.getSalequotaNumu());
                goodsDomain.setSalequotaNums(stSalequotaListDomain.getSalequotaNums());
            }
        }
        BigDecimal num = BigDecimal.ZERO;
        num = "0".equals(goodsDomain.getSalequotaNumtype()) ? goodsDomain.getGoodsCweight() : ("1".equals(goodsDomain.getSalequotaNumtype()) ? goodsDomain.getContractGoodsMoney() : goodsDomain.getGoodsCamount());
        if (null == num) {
            num = BigDecimal.ZERO;
        }
        if (goodsDomain.getSalequotaNums().compareTo(num) >= 0) {
            goodsDomain.setQuotaOkflag(true);
        } else {
            goodsDomain.setQuotaOkflag(false);
        }
        goodsDomain.setNum(num);
    }

    private StSalequotaDomain checkQuotaUm(String userinfoCode, String tenantCode, List<StSalequotaDomain> stSalequotaDomainList) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode) || ListUtil.isEmpty(stSalequotaDomainList)) {
            return null;
        }
        String json = DisUtil.get((String)("UmUserinfo-" + userinfoCode + "-" + tenantCode));
        UmUserinfoReDomainBean umUserinfoReDomainBean = null;
        if (StringUtils.isNotBlank((String)json)) {
            umUserinfoReDomainBean = (UmUserinfoReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(json, UmUserinfoReDomainBean.class);
        }
        for (StSalequotaDomain stSalequotaDomain : stSalequotaDomainList) {
            Object obj = BeanUtils.newForceGetProperty((Object)umUserinfoReDomainBean, (String)stSalequotaDomain.getSalequotaUpro());
            if (null == obj || !stSalequotaDomain.getSalequotaUprovalue().equals(obj.toString())) continue;
            return stSalequotaDomain;
        }
        return null;
    }

    private List<StSalequotaDomain> getList(Map<String, String> codemap) {
        if (MapUtil.isEmpty(codemap)) {
            return null;
        }
        ArrayList<StSalequotaDomain> stSalequotaDomainList = new ArrayList<StSalequotaDomain>();
        for (String key : codemap.keySet()) {
            stSalequotaDomainList.add((StSalequotaDomain)JsonUtil.buildNormalBinder().getJsonToObject(codemap.get(key), StSalequotaDomain.class));
        }
        return stSalequotaDomainList;
    }

    private void deleteStSalequotaCache(String oldKey, StSalequota stSalequota) {
        if (null == stSalequota) {
            return;
        }
        String key = this.getSalequotaKey(stSalequota.getChannelCode(), stSalequota.getGoodsClass(), stSalequota.getTenantCode());
        if (StringUtils.isNotBlank((String)oldKey) && !oldKey.equals(key)) {
            key = oldKey;
        }
        DisUtil.delMap((String)(this.cachekey + key), (String[])new String[]{stSalequota.getSalequotaSpro()});
        DisUtil.delMap((String)(this.cachekey_main + key + "-" + stSalequota.getSalequotaSpro() + "-" + stSalequota.getSalequotaSprovalue()), (String[])new String[]{stSalequota.getSalequotaCode()});
        QueryResult<StSalequotaList> qlist = this.stSalequotaListService.querySalequotaListPage(this.getQueryMapParam("salequotaCode,tenantCode", new Object[]{stSalequota.getSalequotaCode(), stSalequota.getTenantCode()}));
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return;
        }
        for (StSalequotaList stSalequotaList : qlist.getList()) {
            DisUtil.del((String)(this.cachekey_list + stSalequotaList.getSalequotaCode() + "-" + stSalequotaList.getMemberCode() + "-" + stSalequotaList.getTenantCode()));
        }
    }

    private void updateStSalequotaCache(String oldKey, StSalequota stSalequota) {
        if (null == stSalequota) {
            return;
        }
        String key = this.getSalequotaKey(stSalequota.getChannelCode(), stSalequota.getGoodsClass(), stSalequota.getTenantCode());
        if (StringUtils.isNotBlank((String)oldKey) && !oldKey.equals(key)) {
            this.deleteStSalequotaCache(oldKey, stSalequota);
        }
        DisUtil.setMap((String)(this.cachekey + key), (String)stSalequota.getSalequotaSpro(), (String)stSalequota.getSalequotaSpro());
        DisUtil.setMap((String)(this.cachekey_main + key + "-" + stSalequota.getSalequotaSpro() + "-" + stSalequota.getSalequotaSprovalue()), (String)stSalequota.getSalequotaCode(), (String)JsonUtil.buildNormalBinder().toJson((Object)stSalequota));
        QueryResult<StSalequotaList> qlist = this.stSalequotaListService.querySalequotaListPage(this.getQueryMapParam("salequotaCode,tenantCode", new Object[]{stSalequota.getSalequotaCode(), stSalequota.getTenantCode()}));
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return;
        }
        for (StSalequotaList stSalequotaList : qlist.getList()) {
            DisUtil.set((String)(this.cachekey_list + stSalequotaList.getSalequotaCode() + "-" + stSalequotaList.getMemberCode() + "-" + stSalequotaList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)stSalequotaList));
        }
    }

    @Override
    public void querySalequotaLoadCache() {
        this.logger.info("StSalequotaServiceImpl.querySalequotaLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_start);
        List<StSalequota> salequotaList = this.querySalequotaModelPage(parammap);
        if (null == salequotaList || salequotaList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("StSalequotaServiceImpl.querySalequotaLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, ArrayList<StSalequotaDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<StSalequotaDomain>>();
        for (StSalequota stSalequota : salequotaList) {
            String key = this.getSalequotaKey(stSalequota.getChannelCode(), stSalequota.getGoodsClass(), stSalequota.getTenantCode());
            StSalequotaDomain stSalequotaDomain = this.makeStSalequotaDomain(stSalequota, null);
            ArrayList<StSalequotaDomain> slist = (ArrayList<StSalequotaDomain>)ddListMap.get(key);
            if (null == slist) {
                slist = new ArrayList<StSalequotaDomain>();
                ddListMap.put(key, slist);
            }
            slist.add(stSalequotaDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.salequotasort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("StSalequotaServiceImpl.querySalequotaLoadCache", (Object)"===========add-end==========");
    }

    private List<StSalequotaDomain> salequotasort(List<StSalequotaDomain> mlist) {
        if (ListUtil.isEmpty(mlist)) {
            return null;
        }
        Collections.sort(mlist, new Comparator<StSalequotaDomain>(){

            @Override
            public int compare(StSalequotaDomain arg0, StSalequotaDomain arg1) {
                if (arg0.getSalequotaWeight() > arg1.getSalequotaWeight()) {
                    return 1;
                }
                if (arg0.getSalequotaWeight() < arg1.getSalequotaWeight()) {
                    return -1;
                }
                return arg0.getSalequotaWeight().compareTo(arg0.getSalequotaWeight());
            }
        });
        return mlist;
    }

    @Override
    public void makeSalequotaCache() {
        this.saveStart();
        this.saveEnd();
        this.saveDel();
    }

    @Override
    public String sendUpdateSalequota(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("st.StSalequotaServiceImpl.sendUpdateSalequota.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            return "error";
        }
        return this.updateSalequotaOc(ocContractDomain);
    }

    @Override
    public String updateBackSalequotaOc(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("st.StSalequotaServiceImpl.updateBackSalequotaOc.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            return "error";
        }
        return this.updateSalequotaMode(ocContractDomain, true);
    }

    @Override
    public String updateSalequotaOc(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("st.StSalequotaServiceImpl.updateSalequotaOc.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            return "error";
        }
        return this.updateSalequotaMode(ocContractDomain, false);
    }

    public String updateSalequotaMode(OcContractDomain ocContractDomain, boolean back) throws ApiException {
        Map<String, String> promap;
        String goodsClass;
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("st.StSalequotaServiceImpl.updateSalequotaMode.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            return "error";
        }
        String channelCode = ocContractDomain.getChannelCode();
        String tenantCode = ocContractDomain.getTenantCode();
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "all";
        }
        if (StringUtils.isBlank((String)(goodsClass = ocContractDomain.getGoodsList().get(0).getGoodsClass()))) {
            goodsClass = "all";
        }
        if (MapUtil.isEmpty(promap = this.getCacheKey(channelCode, goodsClass, tenantCode))) {
            this.logger.error("st.StSalequotaServiceImpl.updateSalequotaMode.promap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            return "error";
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            if (!"0".equals(ocContractGoodsDomain.getContractGoodsGtype())) continue;
            GoodsDomain goodsDomain = new GoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)goodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.checkGoodsDomain(goodsDomain, ocContractDomain.getMemberBcode(), tenantCode, promap);
            if (!goodsDomain.isQuotaflag()) continue;
            if (!goodsDomain.isQuotaOkflag()) {
                throw new ApiException("st.StSalequotaServiceImpl.updateSalequotaMode.quotaOkflag", ocContractGoodsDomain.getContractGoodsCode());
            }
            StSalequota salequota = this.getSalequotaByCode(goodsDomain.getTenantCode(), goodsDomain.getSalequotaCode());
            StSalequotaDomain salequotaDomain = this.makeStSalequotaDomain(salequota, null);
            if (null == salequotaDomain.getSalequotaNums()) {
                salequotaDomain.setSalequotaNums(BigDecimal.ZERO);
            }
            if (null == salequotaDomain.getSalequotaNumu()) {
                salequotaDomain.setSalequotaNumu(BigDecimal.ZERO);
            }
            if (null == goodsDomain.getNum()) {
                goodsDomain.setNum(BigDecimal.ZERO);
            }
            salequotaDomain.setSalequotaNums(salequotaDomain.getSalequotaNums().subtract(goodsDomain.getNum()));
            salequotaDomain.setSalequotaNumu(salequotaDomain.getSalequotaNumu().add(goodsDomain.getNum()));
            this.updateSalequota(salequotaDomain);
            StSalequotaListDomain stSalequotaListDomain = new StSalequotaListDomain();
            if (null == goodsDomain.getNum()) {
                goodsDomain.setNum(BigDecimal.ZERO);
            }
            if (back) {
                goodsDomain.setNum(goodsDomain.getNum().multiply(new BigDecimal("-1")));
            }
            if (StringUtils.isNotBlank((String)goodsDomain.getSalequotaListCode())) {
                StSalequotaList stSalequotaList = this.stSalequotaListService.getSalequotaListByCode(tenantCode, goodsDomain.getSalequotaListCode());
                if (null == stSalequotaList) {
                    throw new ApiException("st.StSalequotaServiceImpl.updateSalequotaMode.stSalequotaList", ocContractGoodsDomain.getContractGoodsCode() + "=" + goodsDomain.getSalequotaListCode());
                }
                try {
                    BeanUtils.copyAllPropertys((Object)stSalequotaListDomain, (Object)stSalequotaList);
                }
                catch (Exception e) {
                    this.logger.error("st.StSalequotaServiceImpl.updateSalequotaMode.stSalequotaList", (Throwable)e);
                }
                if (null == stSalequotaListDomain.getSalequotaNums()) {
                    stSalequotaListDomain.setSalequotaNums(BigDecimal.ZERO);
                }
                if (null == stSalequotaListDomain.getSalequotaNumu()) {
                    stSalequotaListDomain.setSalequotaNumu(BigDecimal.ZERO);
                }
                stSalequotaListDomain.setSalequotaNums(stSalequotaListDomain.getSalequotaNums().subtract(goodsDomain.getNum()));
                stSalequotaListDomain.setSalequotaNumu(stSalequotaListDomain.getSalequotaNumu().add(goodsDomain.getNum()));
                this.stSalequotaListService.updateSalequotaList(stSalequotaListDomain);
            } else {
                try {
                    BeanUtils.copyAllPropertys((Object)stSalequotaListDomain, (Object)salequotaDomain);
                }
                catch (Exception e) {
                    this.logger.error("st.StSalequotaServiceImpl.updateSalequotaMode.salequotaDomain", (Throwable)e);
                }
                stSalequotaListDomain.setMemberCode(ocContractDomain.getMemberCode());
                stSalequotaListDomain.setMemberName(ocContractDomain.getMemberName());
                this.stSalequotaListService.saveSalequotaList(stSalequotaListDomain);
            }
            StSalequotaUserlistDomain stSalequotaUserlistDomain = new StSalequotaUserlistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)stSalequotaUserlistDomain, (Object)stSalequotaListDomain);
            }
            catch (Exception e) {
                this.logger.error("st.StSalequotaServiceImpl.updateSalequotaMode.stSalequotaUserlistDomain", (Throwable)e);
            }
            stSalequotaUserlistDomain.setSalequotaListNum(goodsDomain.getNum());
            stSalequotaUserlistDomain.setSalequotaListOpno(ocContractGoodsDomain.getContractBillcode());
            stSalequotaUserlistDomain.setSalequotaListOpno1(ocContractGoodsDomain.getContractGoodsCode());
            stSalequotaUserlistDomain.setSalequotaListOpno2(ocContractGoodsDomain.getSkuCode());
            this.stSalequotaUserlistService.saveSalequotaUserlist(stSalequotaUserlistDomain);
        }
        return "success";
    }

    @Override
    public String sendBackSalequota(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return "error";
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            this.saveBackStSalequotaList(ocContractGoodsDomain);
        }
        return "success";
    }

    private void saveStSalequotaList(StSalequotaDomain stSalequotaDomain, OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salequotaListOpno", ocContractGoodsDomain.getContractBillcode());
        map.put("salequotaListOpno1", ocContractGoodsDomain.getContractGoodsCode());
        map.put("salequotaListOpno2", "1");
        map.put("salequotaListOpuser", ocContractGoodsDomain.getMemberBcode());
        map.put("tenantCode", ocContractGoodsDomain.getTenantCode());
        QueryResult<StSalequotaList> stSalequotaListQueryResult = this.stSalequotaListService.querySalequotaListPage(map);
        if (null != stSalequotaListQueryResult && ListUtil.isNotEmpty((Collection)stSalequotaListQueryResult.getList())) {
            return;
        }
        StSalequotaListDomain stSalequotaListDomain = new StSalequotaListDomain();
        stSalequotaListDomain.setSalequotaListOpno(ocContractGoodsDomain.getContractBillcode());
        stSalequotaListDomain.setSalequotaListOpno1(ocContractGoodsDomain.getContractGoodsCode());
        stSalequotaListDomain.setSalequotaListOpno2("1");
        stSalequotaListDomain.setSalequotaListOpuser(ocContractGoodsDomain.getMemberBcode());
        stSalequotaListDomain.setSalequotaListOpuserinfo(ocContractGoodsDomain.getMemberBname());
        BigDecimal num = "0".equals(stSalequotaDomain.getSalequotaNumtype()) ? ocContractGoodsDomain.getGoodsCweight() : ocContractGoodsDomain.getPricesetNprice();
        stSalequotaListDomain.setSalequotaListNum(num.multiply(ocContractGoodsDomain.getGoodsCamount()));
        stSalequotaListDomain.setSalequotaListMoney(ocContractGoodsDomain.getPricesetNprice());
        ArrayList<StSalequotaListDomain> listDomainList = new ArrayList<StSalequotaListDomain>();
        listDomainList.add(stSalequotaListDomain);
        StSalequota salequota = this.getSalequotaByCode(stSalequotaDomain.getTenantCode(), stSalequotaDomain.getSalequotaCode());
        StSalequotaDomain salequotaDomain = this.makeStSalequotaDomain(salequota, null);
        salequotaDomain.setStSalequotaListDomainList(listDomainList);
        salequotaDomain.setSalequotaNums(stSalequotaDomain.getSalequotaNums());
        salequotaDomain.setSalequotaNumu(stSalequotaDomain.getSalequotaNumu());
        this.updateSalequota(salequotaDomain);
    }

    private void saveBackStSalequotaList(OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salequotaListOpno", ocContractGoodsDomain.getContractBillcode());
        map.put("salequotaListOpno1", ocContractGoodsDomain.getContractGoodsCode());
        map.put("salequotaListOpno2", "-1");
        map.put("salequotaListOpuser", ocContractGoodsDomain.getMemberBcode());
        map.put("tenantCode", ocContractGoodsDomain.getTenantCode());
        QueryResult<StSalequotaList> stSalequotaListQueryResult = this.stSalequotaListService.querySalequotaListPage(map);
        if (null != stSalequotaListQueryResult && ListUtil.isNotEmpty((Collection)stSalequotaListQueryResult.getList())) {
            return;
        }
        map.put("salequotaListOpno2", "1");
        QueryResult<StSalequotaList> queryResult = this.stSalequotaListService.querySalequotaListPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return;
        }
        StSalequotaList stSalequotaList = (StSalequotaList)queryResult.getList().get(0);
        StSalequota salequota = this.getSalequotaByCode(stSalequotaList.getSalequotaCode(), ocContractGoodsDomain.getTenantCode());
        if (null == salequota) {
            return;
        }
        salequota.setSalequotaNums(salequota.getSalequotaNums().add(stSalequotaList.getSalequotaListNum()));
        salequota.setSalequotaNumu(salequota.getSalequotaNumu().subtract(stSalequotaList.getSalequotaListNum()));
        StSalequotaListDomain stSalequotaListDomain = new StSalequotaListDomain();
        try {
            BeanUtils.copyAllPropertys((Object)stSalequotaListDomain, (Object)salequota);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaServiceImpl.saveStSalequotaList", (Throwable)e);
        }
        stSalequotaListDomain.setSalequotaListOpno(ocContractGoodsDomain.getContractBillcode());
        stSalequotaListDomain.setSalequotaListOpno1(ocContractGoodsDomain.getContractGoodsCode());
        stSalequotaListDomain.setSalequotaListOpno2("-1");
        stSalequotaListDomain.setSalequotaListOpuser(ocContractGoodsDomain.getMemberBcode());
        stSalequotaListDomain.setSalequotaListOpuserinfo(ocContractGoodsDomain.getMemberBname());
        BigDecimal num = "0".equals(salequota.getSalequotaNumtype()) ? ocContractGoodsDomain.getGoodsCweight() : ocContractGoodsDomain.getPricesetNprice();
        stSalequotaListDomain.setSalequotaListNum(num.multiply(ocContractGoodsDomain.getGoodsCamount()));
        stSalequotaListDomain.setSalequotaListMoney(ocContractGoodsDomain.getPricesetNprice());
        ArrayList<StSalequotaListDomain> listDomainList = new ArrayList<StSalequotaListDomain>();
        listDomainList.add(stSalequotaListDomain);
        StSalequotaDomain stSalequotaDomain = this.makeStSalequotaDomain(salequota, null);
        stSalequotaDomain.setStSalequotaListDomainList(listDomainList);
        stSalequotaDomain.setSalequotaNums(salequota.getSalequotaNums());
        stSalequotaDomain.setSalequotaNumu(salequota.getSalequotaNumu());
        this.updateSalequota(stSalequotaDomain);
    }

    private UserSession getUserSession(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        String result = this.internalInvoke("um.user.getUserinfoByCode", this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{userinfoCode, tenantCode}));
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(result, UmUserinfoReDomainBean.class);
        if (null == umUserinfoReDomainBean) {
            this.logger.error("st.StSalequotaServiceImpl.getUserSession", (Object)(userinfoCode + "," + tenantCode));
            return null;
        }
        UserSession reuserSession = new UserSession();
        try {
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)umUserinfoReDomainBean);
            reuserSession.setUserPcode(umUserinfoReDomainBean.getUserinfoCode());
            reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        }
        catch (Exception exception) {
            // empty catch block
        }
        reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        String groupResult = this.internalInvoke("um.group.queryGroupListPage", this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{userinfoCode, tenantCode}));
        SupQueryResult qmem = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(groupResult, SupQueryResult.class);
        if (null != qmem && ListUtil.isNotEmpty((Collection)qmem.getList())) {
            List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)qmem.getList()), UmGroupListReDomain.class);
            if (ListUtil.isEmpty((Collection)pList)) {
                return reuserSession;
            }
            reuserSession.setGroupCode(((UmGroupListReDomain)pList.get(0)).getGroupCode());
            reuserSession.setGroupName(((UmGroupListReDomain)pList.get(0)).getGroupName());
        }
        return reuserSession;
    }

    private StSalequotaDomain checkSalequota(Map<String, List<String>> map, Map<String, List<String>> memberMap, Map<String, Object> contractGoodsMap, Map<String, Object> salequotaMap, Map<String, Object> objMap) {
        if (null == map || null == salequotaMap || null == contractGoodsMap || null == objMap) {
            return null;
        }
        String key = this.checkConf(map, contractGoodsMap);
        this.logger.error("\u5546\u54c1\u9650\u989dkey", (Object)key);
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        String memberkey = this.checkConf(memberMap, objMap);
        if (StringUtils.isBlank((String)key)) {
            memberkey = "all-all";
        }
        this.logger.error("\u5546\u54c1\u9650\u989dmemberkey", (Object)memberkey);
        return (StSalequotaDomain)salequotaMap.get(key + "-" + memberkey);
    }

    private void makeMem(List<StSalequotaDomain> salequotaList, Map<String, Object> salequotaMap, Map<String, List<String>> map, Map<String, List<String>> memberMap) {
        if (ListUtil.isEmpty(salequotaList)) {
            return;
        }
        Object object = null;
        String key = null;
        for (StSalequotaDomain stSalequotaDomain : salequotaList) {
            List<String> list = map.get(stSalequotaDomain.getSalequotaSpro());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(stSalequotaDomain.getSalequotaSpro(), list);
            }
            list.add(stSalequotaDomain.getSalequotaSprovalue());
            List<String> memberList = memberMap.get(stSalequotaDomain.getSalequotaUpro());
            if (null == memberList) {
                memberList = new ArrayList<String>();
                memberMap.put(stSalequotaDomain.getSalequotaUpro(), memberList);
            }
            memberList.add(stSalequotaDomain.getSalequotaUprovalue());
            key = stSalequotaDomain.getSalequotaSpro() + "-" + stSalequotaDomain.getSalequotaSprovalue() + "-" + stSalequotaDomain.getSalequotaUpro() + "-" + stSalequotaDomain.getSalequotaUprovalue();
            object = salequotaMap.get(key);
            if (null != object) continue;
            salequotaMap.put(key, stSalequotaDomain);
        }
    }

    private Map<String, Object> makeObject(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        Map obj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)userSession), String.class, Object.class);
        return obj;
    }

    private Map<String, Object> makeContractGoods(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return null;
        }
        Map obj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain), String.class, Object.class);
        return obj;
    }

    private String checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        String flag = null;
        block0: for (String keys : map.keySet()) {
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)keys);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs = objValue.toString().split("\\,");
                flag = null;
                for (String o : otrs) {
                    String cond = this.cond(valueList, o);
                    if (null == cond) continue;
                    flag = keys + "-" + cond;
                    continue block0;
                }
                continue;
            }
            String cond = this.cond(valueList, objValue);
            if (null == cond) continue;
            flag = keys + "-" + cond;
            break;
        }
        return flag;
    }

    private String cond(List<String> valueList, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return null;
        }
        String flag = null;
        if (null == objValue) {
            objValue = "";
        }
        for (String value : valueList) {
            if (!value.contains(objValue.toString())) continue;
            flag = value;
            return flag;
        }
        return flag;
    }

    private void saveDel() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_del);
        List<StSalequota> stSalequotas = this.querySalequotaModelPage(parammap);
        if (null == stSalequotas || stSalequotas.isEmpty()) {
            return;
        }
        for (StSalequota stSalequota : stSalequotas) {
            try {
                this.updateSalequotaState(stSalequota.getSalequotaId(), SaleforecastConstants.dataState_no, SaleforecastConstants.dataState_del, null);
            }
            catch (Exception e) {
                this.logger.error("st.StSalequotaServiceImpl.saveEnd.e", (Object)stSalequota.getSalequotaCode(), (Throwable)e);
            }
        }
    }

    private void saveEnd() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_start);
        List<StSalequota> stSalequotas = this.querySalequotaModelPage(parammap);
        if (null == stSalequotas || stSalequotas.isEmpty()) {
            return;
        }
        for (StSalequota stSalequota : stSalequotas) {
            if (null == stSalequota.getSalequotaEnd() || stSalequota.getSalequotaEnd().getTime() > this.getSysDate().getTime()) continue;
            try {
                this.updateSalequotaState(stSalequota.getSalequotaId(), SaleforecastConstants.dataState_no, SaleforecastConstants.dataState_start, null);
            }
            catch (Exception e) {
                this.logger.error("st.StSalequotaServiceImpl.saveEnd.e", (Object)stSalequota.getSalequotaCode(), (Throwable)e);
            }
        }
    }

    private void saveStart() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_add);
        List<StSalequota> stSalequotas = this.querySalequotaModelPage(parammap);
        if (null == stSalequotas || stSalequotas.isEmpty()) {
            return;
        }
        for (StSalequota stSalequota : stSalequotas) {
            if (!this.checkStart(stSalequota)) continue;
            try {
                this.updateSalequotaState(stSalequota.getSalequotaId(), SaleforecastConstants.dataState_start, SaleforecastConstants.dataState_add, null);
            }
            catch (Exception e) {
                this.logger.error("st.StSalequotaServiceImpl.saveStart.e", (Object)stSalequota.getSalequotaCode(), (Throwable)e);
            }
        }
    }

    private boolean checkStart(StSalequota stSalequota) {
        boolean startDate = false;
        boolean endDate = false;
        if (null == stSalequota.getSalequotaStart()) {
            startDate = true;
        }
        if (null != stSalequota.getSalequotaStart() && stSalequota.getSalequotaStart().getTime() < this.getSysDate().getTime()) {
            startDate = true;
        }
        if (null == stSalequota.getSalequotaEnd()) {
            endDate = true;
        }
        if (null != stSalequota.getSalequotaEnd() && stSalequota.getSalequotaEnd().getTime() > this.getSysDate().getTime()) {
            endDate = true;
        }
        return startDate && endDate;
    }
}

