/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.saleforecast.util;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;

public class DateWeekUtil {
    public static LocalDateTime getFirstLocalDayOfMonth(LocalDateTime localDateTime) {
        return localDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
    }

    private static LocalDateTime getFirstMonday(LocalDateTime sourceTime) {
        DayOfWeek dayOfWeekTemp;
        LocalDateTime firstMondayOfMonth = DateWeekUtil.getFirstLocalDayOfMonth(sourceTime);
        for (int i = 0; i < 6 && !(dayOfWeekTemp = firstMondayOfMonth.getDayOfWeek()).equals(DayOfWeek.MONDAY); ++i) {
            firstMondayOfMonth = firstMondayOfMonth.plusDays(1L);
        }
        return firstMondayOfMonth;
    }

    public static String getMonthNoAndWeekNo(LocalDateTime sourceTime) {
        String monthNoAndWeekNo;
        LocalDateTime firstMondayOfMonth = DateWeekUtil.getFirstMonday(sourceTime);
        if (firstMondayOfMonth.isBefore(sourceTime) || firstMondayOfMonth.isEqual(sourceTime)) {
            int dayOfMonthFirstMonday = firstMondayOfMonth.getDayOfMonth();
            int dayOfMonthSourceTime = sourceTime.getDayOfMonth();
            int diffDays = dayOfMonthSourceTime - dayOfMonthFirstMonday;
            int weekNo = diffDays / 7 + 1;
            int monthNo = sourceTime.getMonth().getValue();
            int year = firstMondayOfMonth.getYear();
            monthNoAndWeekNo = year + "-" + monthNo + "-" + weekNo;
        } else {
            LocalDateTime lastMontLocalDateTime = sourceTime.minusMonths(1L);
            LocalDateTime firstMondayOfMonthLast = DateWeekUtil.getFirstMonday(lastMontLocalDateTime);
            Duration duration = Duration.between(firstMondayOfMonthLast, sourceTime);
            long diffDays = duration.toDays();
            long weekNo = diffDays / 7L + 1L;
            int monthNo = firstMondayOfMonthLast.getMonth().getValue();
            int year = firstMondayOfMonthLast.getYear();
            monthNoAndWeekNo = year + "-" + monthNo + "-" + weekNo;
        }
        return monthNoAndWeekNo;
    }

    public static String getYearAndMonthNo(LocalDateTime date) {
        int year = date.getYear();
        Month month = date.getMonth();
        int monthNum = month.getValue();
        String monthNoAndWeekNo = year + "-" + monthNum;
        return monthNoAndWeekNo;
    }

    public static void main(String[] args) {
        LocalDateTime localDateTime = LocalDateTime.now();
        String monthNoAndWeekNo = DateWeekUtil.getMonthNoAndWeekNo(localDateTime);
        System.out.println(monthNoAndWeekNo);
    }
}

