/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.saleforecast.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.saleforecast.SaleforecastConstants;
import com.yqbsoft.laser.service.saleforecast.dao.StSaleminnumMapper;
import com.yqbsoft.laser.service.saleforecast.domain.StSaleminnumDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSaleminnumReDomain;
import com.yqbsoft.laser.service.saleforecast.model.StSaleminnum;
import com.yqbsoft.laser.service.saleforecast.service.StSaleminnumService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StSaleminnumServiceImpl
extends BaseServiceImpl
implements StSaleminnumService {
    private static final String SYS_CODE = "st.StSaleminnumServiceImpl";
    private StSaleminnumMapper stSaleminnumMapper;
    private String cachekey = "Saleminnum-ChannelCode-TenantCode";
    private String uprovalueKey = "Saleminnum-saleminnumUpro-saleminnumUprovalue-TenantCode";

    public void setStSaleminnumMapper(StSaleminnumMapper stSaleminnumMapper) {
        this.stSaleminnumMapper = stSaleminnumMapper;
    }

    private Date getSysDate() {
        try {
            return this.stSaleminnumMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("st.StSaleminnumServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSaleminnum(StSaleminnumDomain stSaleminnumDomain) {
        if (null == stSaleminnumDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)stSaleminnumDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSaleminnumDefault(StSaleminnum stSaleminnum) {
        if (null == stSaleminnum) {
            return;
        }
        if (null == stSaleminnum.getDataState()) {
            stSaleminnum.setDataState(0);
        }
        if (this.checkStart(stSaleminnum)) {
            stSaleminnum.setDataState(2);
        }
        if (StringUtils.isBlank((String)stSaleminnum.getSaleminnumUpro())) {
            stSaleminnum.setSaleminnumUpro("all");
        }
        if (StringUtils.isBlank((String)stSaleminnum.getSaleminnumUprovalue())) {
            stSaleminnum.setSaleminnumUprovalue("all");
        }
        Date date = this.getSysDate();
        if (null == stSaleminnum.getGmtCreate()) {
            stSaleminnum.setGmtCreate(date);
        }
        stSaleminnum.setGmtModified(date);
        if (StringUtils.isBlank((String)stSaleminnum.getSaleminnumCode())) {
            stSaleminnum.setSaleminnumCode(this.getNo(null, "StSaleminnum", "stSaleminnum", stSaleminnum.getTenantCode()));
        }
    }

    private int getSaleminnumMaxCode() {
        int code = 0;
        try {
            return this.stSaleminnumMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("st.StSaleminnumServiceImpl.getSaleminnumMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSaleminnumUpdataDefault(StSaleminnum stSaleminnum) {
        if (null == stSaleminnum) {
            return;
        }
        stSaleminnum.setGmtModified(this.getSysDate());
    }

    private void saveSaleminnumModel(StSaleminnum stSaleminnum) throws ApiException {
        if (null == stSaleminnum) {
            return;
        }
        try {
            this.stSaleminnumMapper.insert(stSaleminnum);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleminnumServiceImpl.saveSaleminnumModel.ex", (Throwable)e);
        }
    }

    private void saveSaleminnumBatchModel(List<StSaleminnum> stSaleminnumList) throws ApiException {
        if (null == stSaleminnumList || stSaleminnumList.isEmpty()) {
            return;
        }
        try {
            this.stSaleminnumMapper.insertBatch(stSaleminnumList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleminnumServiceImpl.saveSaleminnumBatchModel.ex", (Throwable)e);
        }
    }

    private StSaleminnum getSaleminnumModelById(Integer saleminnumId) {
        if (null == saleminnumId) {
            return null;
        }
        try {
            return this.stSaleminnumMapper.selectByPrimaryKey(saleminnumId);
        }
        catch (Exception e) {
            this.logger.error("st.StSaleminnumServiceImpl.getSaleminnumModelById", (Throwable)e);
            return null;
        }
    }

    private StSaleminnum getSaleminnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.stSaleminnumMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSaleminnumServiceImpl.getSaleminnumModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSaleminnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.stSaleminnumMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleminnumServiceImpl.delSaleminnumModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSaleminnumServiceImpl.delSaleminnumModelByCode.num");
        }
    }

    private void deleteSaleminnumModel(Integer saleminnumId) throws ApiException {
        if (null == saleminnumId) {
            return;
        }
        int i = 0;
        try {
            i = this.stSaleminnumMapper.deleteByPrimaryKey(saleminnumId);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleminnumServiceImpl.deleteSaleminnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSaleminnumServiceImpl.deleteSaleminnumModel.num");
        }
    }

    private void updateSaleminnumModel(StSaleminnum stSaleminnum) throws ApiException {
        if (null == stSaleminnum) {
            return;
        }
        int i = 0;
        try {
            i = this.stSaleminnumMapper.updateByPrimaryKey(stSaleminnum);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleminnumServiceImpl.updateSaleminnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSaleminnumServiceImpl.updateSaleminnumModel.num");
        }
    }

    private void updateStateSaleminnumModel(Integer saleminnumId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == saleminnumId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("saleminnumId", saleminnumId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSaleminnumMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleminnumServiceImpl.updateStateSaleminnumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSaleminnumServiceImpl.updateStateSaleminnumModel.null");
        }
    }

    private void updateStateSaleminnumModelByCode(String tenantCode, String saleminnumCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)saleminnumCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("saleminnumCode", saleminnumCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSaleminnumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSaleminnumServiceImpl.updateStateSaleminnumModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSaleminnumServiceImpl.updateStateSaleminnumModelByCode.null");
        }
    }

    private StSaleminnum makeSaleminnum(StSaleminnumDomain stSaleminnumDomain, StSaleminnum stSaleminnum) {
        if (null == stSaleminnumDomain) {
            return null;
        }
        if (null == stSaleminnum) {
            stSaleminnum = new StSaleminnum();
        }
        try {
            BeanUtils.copyAllPropertys((Object)stSaleminnum, (Object)stSaleminnumDomain);
            return stSaleminnum;
        }
        catch (Exception e) {
            this.logger.error("st.StSaleminnumServiceImpl.makeSaleminnum", (Throwable)e);
            return null;
        }
    }

    private StSaleminnumDomain makeStSaleminnumDomain(StSaleminnum stSaleminnum, StSaleminnumDomain stSaleminnumDomain) {
        if (null == stSaleminnum) {
            return null;
        }
        if (null == stSaleminnumDomain) {
            stSaleminnumDomain = new StSaleminnumDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)stSaleminnumDomain, (Object)stSaleminnum);
            return stSaleminnumDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private StSaleminnumReDomain makeStSaleminnumReDomain(StSaleminnum stSaleminnum) {
        if (null == stSaleminnum) {
            return null;
        }
        StSaleminnumReDomain stSaleminnumReDomain = new StSaleminnumReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)stSaleminnumReDomain, (Object)stSaleminnum);
            return stSaleminnumReDomain;
        }
        catch (Exception e) {
            this.logger.error("st.StSaleminnumServiceImpl.makeStSaleminnumReDomain", (Throwable)e);
            return null;
        }
    }

    private List<StSaleminnum> querySaleminnumModelPage(Map<String, Object> parammap) {
        try {
            return this.stSaleminnumMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("st.StSaleminnumServiceImpl.querySaleminnumModel", (Throwable)e);
            return null;
        }
    }

    private int countSaleminnum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.stSaleminnumMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSaleminnumServiceImpl.countSaleminnum", (Throwable)e);
        }
        return i;
    }

    private StSaleminnum createStSaleminnum(StSaleminnumDomain stSaleminnumDomain) {
        String msg = this.checkSaleminnum(stSaleminnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSaleminnumServiceImpl.saveSaleminnum.checkSaleminnum", msg);
        }
        StSaleminnum stSaleminnum = this.makeSaleminnum(stSaleminnumDomain, null);
        this.setSaleminnumDefault(stSaleminnum);
        return stSaleminnum;
    }

    @Override
    public String saveSaleminnum(StSaleminnumDomain stSaleminnumDomain) throws ApiException {
        StSaleminnum stSaleminnum = this.createStSaleminnum(stSaleminnumDomain);
        this.saveSaleminnumModel(stSaleminnum);
        if (SaleforecastConstants.dataState_start.intValue() == stSaleminnum.getDataState().intValue()) {
            this.updateStSaleminnumCache(null, stSaleminnum);
        }
        return stSaleminnum.getSaleminnumCode();
    }

    @Override
    public String saveSaleminnumBatch(List<StSaleminnumDomain> stSaleminnumDomainList) throws ApiException {
        if (null == stSaleminnumDomainList || stSaleminnumDomainList.isEmpty()) {
            return null;
        }
        ArrayList<StSaleminnum> stSaleminnumList = new ArrayList<StSaleminnum>();
        String code = "";
        for (StSaleminnumDomain stSaleminnumDomain : stSaleminnumDomainList) {
            StSaleminnum saleminnum = this.createStSaleminnum(stSaleminnumDomain);
            code = saleminnum.getSaleminnumCode();
            stSaleminnumList.add(saleminnum);
        }
        this.saveSaleminnumBatchModel(stSaleminnumList);
        for (StSaleminnum stSaleminnum : stSaleminnumList) {
            if (SaleforecastConstants.dataState_start.intValue() != stSaleminnum.getDataState().intValue()) continue;
            this.updateStSaleminnumCache(null, stSaleminnum);
        }
        return code;
    }

    @Override
    public void updateSaleminnumState(Integer saleminnumId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == saleminnumId) {
            return;
        }
        StSaleminnum stSaleminnum = this.getSaleminnumModelById(saleminnumId);
        this.updateStateSaleminnumModel(saleminnumId, dataState, oldDataState, map);
        if (SaleforecastConstants.dataState_start.intValue() != dataState.intValue()) {
            this.deleteStSaleminnumCache(null, stSaleminnum);
        } else if (SaleforecastConstants.dataState_start.intValue() == dataState.intValue()) {
            this.updateStSaleminnumCache(null, stSaleminnum);
        }
    }

    @Override
    public void updateSaleminnumStateByCode(String tenantCode, String saleminnumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)saleminnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        StSaleminnum stSaleminnum = this.getSaleminnumByCode(tenantCode, saleminnumCode);
        this.updateStateSaleminnumModelByCode(tenantCode, saleminnumCode, dataState, oldDataState, map);
        if (SaleforecastConstants.dataState_start.intValue() != dataState.intValue()) {
            this.deleteStSaleminnumCache(null, stSaleminnum);
        } else if (SaleforecastConstants.dataState_start.intValue() == dataState.intValue()) {
            this.updateStSaleminnumCache(null, stSaleminnum);
        }
    }

    @Override
    public void updateSaleminnum(StSaleminnumDomain stSaleminnumDomain) throws ApiException {
        String msg = this.checkSaleminnum(stSaleminnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSaleminnumServiceImpl.updateSaleminnum.checkSaleminnum", msg);
        }
        StSaleminnum oldStSaleminnum = this.getSaleminnumModelById(stSaleminnumDomain.getSaleminnumId());
        if (null == oldStSaleminnum) {
            throw new ApiException("st.StSaleminnumServiceImpl.updateSaleminnum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        StSaleminnum stSaleminnum = this.makeSaleminnum(stSaleminnumDomain, oldStSaleminnum);
        this.setSaleminnumUpdataDefault(stSaleminnum);
        this.updateSaleminnumModel(stSaleminnum);
        if (SaleforecastConstants.dataState_start.intValue() == stSaleminnum.getDataState().intValue()) {
            this.updateStSaleminnumCache(oldStSaleminnum, stSaleminnum);
        } else {
            this.deleteStSaleminnumCache(oldStSaleminnum, stSaleminnum);
        }
    }

    private String getUprovalueKey(StSaleminnum stSaleminnum) {
        if (null == stSaleminnum) {
            throw new ApiException("st.StSaleminnumServiceImpl.getSaleminnumKey.tenantCode", "tenantCode is null");
        }
        String key = "";
        if (StringUtils.isNotBlank((String)stSaleminnum.getSaleminnumUpro())) {
            key = stSaleminnum.getSaleminnumUpro();
        }
        if (StringUtils.isNotBlank((String)stSaleminnum.getSaleminnumUprovalue())) {
            key = key + "-" + stSaleminnum.getSaleminnumUprovalue();
        }
        key = key + "-" + stSaleminnum.getTenantCode();
        return key;
    }

    private String getSaleminnumKey(String channelCode, String goodsClass, String tenantCode, String memberCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("st.StSaleminnumServiceImpl.getSaleminnumKey.tenantCode", "tenantCode is null");
        }
        String key = null;
        if (StringUtils.isNotBlank((String)memberCode)) {
            key = memberCode;
        }
        if (StringUtils.isNotBlank((String)channelCode) && StringUtils.isBlank((String)key)) {
            key = channelCode;
        }
        if (StringUtils.isNotBlank((String)goodsClass) && StringUtils.isBlank((String)key)) {
            key = goodsClass;
        }
        if (StringUtils.isBlank((String)key)) {
            key = "all";
        }
        return key + "-" + tenantCode;
    }

    @Override
    public StSaleminnum getSaleminnum(Integer saleminnumId) {
        if (null == saleminnumId) {
            return null;
        }
        return this.getSaleminnumModelById(saleminnumId);
    }

    @Override
    public void deleteSaleminnum(Integer saleminnumId) throws ApiException {
        if (null == saleminnumId) {
            return;
        }
        StSaleminnum stSaleminnum = this.getSaleminnumModelById(saleminnumId);
        this.deleteSaleminnumModel(saleminnumId);
        this.deleteStSaleminnumCache(null, stSaleminnum);
    }

    @Override
    public QueryResult<StSaleminnum> querySaleminnumPage(Map<String, Object> map) {
        List<StSaleminnum> stSaleminnumList = this.querySaleminnumModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSaleminnum(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(stSaleminnumList);
        return queryResult;
    }

    @Override
    public StSaleminnum getSaleminnumByCode(String tenantCode, String saleminnumCode) throws ApiException {
        if (StringUtils.isBlank((String)saleminnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("saleminnumCode", saleminnumCode);
        return this.getSaleminnumModelByCode(map);
    }

    @Override
    public void deleteSaleminnumByCode(String tenantCode, String saleminnumCode) throws ApiException {
        if (StringUtils.isBlank((String)saleminnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("saleminnumCode", saleminnumCode);
        StSaleminnum stSaleminnum = this.getSaleminnumModelByCode(map);
        this.delSaleminnumModelByCode(map);
        this.deleteStSaleminnumCache(null, stSaleminnum);
    }

    private void deleteStSaleminnumCache(StSaleminnum oldStSaleminnum, StSaleminnum stSaleminnum) {
        String json;
        if (null == stSaleminnum) {
            return;
        }
        String oldKey = "";
        if (null != oldStSaleminnum) {
            oldKey = this.getSaleminnumKey(oldStSaleminnum.getChannelCode(), oldStSaleminnum.getGoodsClass(), oldStSaleminnum.getTenantCode(), oldStSaleminnum.getMemberCode());
        }
        String key = this.getSaleminnumKey(stSaleminnum.getChannelCode(), stSaleminnum.getGoodsClass(), stSaleminnum.getTenantCode(), stSaleminnum.getMemberCode());
        if (StringUtils.isNotBlank((String)oldKey) && !oldKey.equals(key)) {
            key = oldKey;
        }
        String uprovalueoneKey = this.getUprovalueKey(stSaleminnum);
        String oldUprovalueKey = "";
        if (null != oldStSaleminnum) {
            oldUprovalueKey = this.getUprovalueKey(oldStSaleminnum);
        }
        if (StringUtils.isNotBlank((String)oldUprovalueKey) && !oldUprovalueKey.equals(uprovalueoneKey)) {
            DisUtil.delMap((String)this.uprovalueKey, (String[])new String[]{oldUprovalueKey});
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cachekey, (String)key)))) {
            return;
        }
        List mlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, StSaleminnumDomain.class);
        ArrayList<StSaleminnumDomain> mlist2 = new ArrayList<StSaleminnumDomain>();
        if (ListUtil.isNotEmpty((Collection)mlist)) {
            for (StSaleminnumDomain stSaleminnumDomain : mlist) {
                if (stSaleminnumDomain.getSaleminnumCode().equals(stSaleminnum.getSaleminnumCode())) continue;
                mlist2.add(stSaleminnumDomain);
            }
        }
        DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(this.saleminnumsort(mlist2)));
    }

    private void updateStSaleminnumCache(StSaleminnum oldStSaleminnum, StSaleminnum stSaleminnum) {
        if (null == stSaleminnum) {
            return;
        }
        String falg = this.checkStSaleminnum(stSaleminnum.getTenantCode(), "checkSKSStSaleminnum", "checkSKSStSaleminnum");
        if (StringUtils.isNotBlank((String)falg)) {
            return;
        }
        String oldKey = "";
        if (null != oldStSaleminnum) {
            oldKey = this.getSaleminnumKey(oldStSaleminnum.getChannelCode(), oldStSaleminnum.getGoodsClass(), oldStSaleminnum.getTenantCode(), oldStSaleminnum.getMemberCode());
        }
        String key = this.getSaleminnumKey(stSaleminnum.getChannelCode(), stSaleminnum.getGoodsClass(), stSaleminnum.getTenantCode(), stSaleminnum.getMemberCode());
        if (StringUtils.isNotBlank((String)oldKey) && !oldKey.equals(key)) {
            this.deleteStSaleminnumCache(oldStSaleminnum, stSaleminnum);
        }
        StSaleminnumDomain saleminnumDomain = this.makeStSaleminnumDomain(stSaleminnum, null);
        String uprovalueoneKey = this.getUprovalueKey(stSaleminnum);
        String oldUprovalueKey = "";
        if (null != oldStSaleminnum) {
            oldUprovalueKey = this.getUprovalueKey(oldStSaleminnum);
        }
        if (StringUtils.isNotBlank((String)oldUprovalueKey) && !oldUprovalueKey.equals(uprovalueoneKey)) {
            DisUtil.delMap((String)this.uprovalueKey, (String[])new String[]{oldUprovalueKey});
        }
        DisUtil.setMap((String)this.uprovalueKey, (String)uprovalueoneKey, (String)JsonUtil.buildNormalBinder().toJson((Object)stSaleminnum));
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)key);
        if (StringUtils.isBlank((String)json)) {
            ArrayList<StSaleminnumDomain> mlist = new ArrayList<StSaleminnumDomain>();
            mlist.add(saleminnumDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(this.saleminnumsort(mlist)));
        } else {
            List mlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, StSaleminnumDomain.class);
            ArrayList<StSaleminnumDomain> mprlist = new ArrayList<StSaleminnumDomain>();
            if (ListUtil.isNotEmpty((Collection)mlist)) {
                boolean flag = false;
                for (StSaleminnumDomain stSaleminnumDomain : mlist) {
                    if (stSaleminnumDomain.getSaleminnumCode().equals(stSaleminnum.getSaleminnumCode())) {
                        flag = true;
                        mprlist.add(saleminnumDomain);
                        continue;
                    }
                    mprlist.add(stSaleminnumDomain);
                }
                if (!flag) {
                    mprlist.add(saleminnumDomain);
                }
            } else {
                mprlist.add(saleminnumDomain);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(this.saleminnumsort(mprlist)));
        }
    }

    protected String checkStSaleminnum(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    @Override
    public void querySaleminnumoadCache() {
        this.logger.info("StSaleminnumServiceImpl.querySaleminnumLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_start);
        List<StSaleminnum> saleminnumList = this.querySaleminnumModelPage(parammap);
        if (null == saleminnumList || saleminnumList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            DisUtil.delVer((String)this.uprovalueKey);
            this.logger.info("StSaleminnumServiceImpl.querySaleminnumLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, ArrayList<StSaleminnumDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<StSaleminnumDomain>>();
        HashMap<String, String> uproValueMap = new HashMap<String, String>();
        for (StSaleminnum stSaleminnum : saleminnumList) {
            String uprovalueKey = this.getUprovalueKey(stSaleminnum);
            uproValueMap.put(uprovalueKey, JsonUtil.buildNormalBinder().toJson((Object)stSaleminnum));
            this.logger.error("st.StSaleminnumServiceImpl.uprovalueKey.key", (Object)uprovalueKey);
            String key = this.getSaleminnumKey(stSaleminnum.getChannelCode(), stSaleminnum.getGoodsClass(), stSaleminnum.getTenantCode(), stSaleminnum.getMemberCode());
            StSaleminnumDomain stSaleminnumDomain = this.makeStSaleminnumDomain(stSaleminnum, null);
            ArrayList<StSaleminnumDomain> slist = (ArrayList<StSaleminnumDomain>)ddListMap.get(key);
            if (null == slist) {
                slist = new ArrayList<StSaleminnumDomain>();
                ddListMap.put(key, slist);
            }
            slist.add(stSaleminnumDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.saleminnumsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        DisUtil.setMap((String)this.uprovalueKey, uproValueMap);
        this.logger.error("st.StSaleminnumServiceImpl.StSaleminnumServiceImpl.uproValueMap.size", (Object)uproValueMap.size());
        this.logger.info("StSaleminnumServiceImpl.querySaleminnumLoadCache", (Object)"===========add-end==========");
    }

    private List<StSaleminnumDomain> saleminnumsort(List<StSaleminnumDomain> mlist) {
        if (ListUtil.isEmpty(mlist)) {
            return null;
        }
        Collections.sort(mlist, new Comparator<StSaleminnumDomain>(){

            @Override
            public int compare(StSaleminnumDomain arg0, StSaleminnumDomain arg1) {
                if (arg0.getSaleminnumWeight() > arg1.getSaleminnumWeight()) {
                    return -1;
                }
                if (arg0.getSaleminnumWeight() < arg1.getSaleminnumWeight()) {
                    return 1;
                }
                if (arg0.getSaleminnumId() > arg1.getSaleminnumId()) {
                    StSaleminnumServiceImpl.this.logger.info("st.StSaleminnumServiceImpl.saleminnumsort.\u8fdb\u5165\u6392\u5e8fID1", (Object)(arg0.getSaleminnumId() + "," + arg1.getSaleminnumId()));
                    return 1;
                }
                if (arg0.getSaleminnumId() < arg1.getSaleminnumId()) {
                    StSaleminnumServiceImpl.this.logger.info("st.StSaleminnumServiceImpl.saleminnumsort.\u8fdb\u5165\u6392\u5e8fID2", (Object)(arg0.getSaleminnumId() + "," + arg1.getSaleminnumId()));
                    return -1;
                }
                return arg0.getSaleminnumWeight().compareTo(arg0.getSaleminnumWeight());
            }
        });
        return mlist;
    }

    @Override
    public void makeSaleminnumCache() {
        this.saveStart();
        this.saveEnd();
        this.saveDel();
    }

    private void saveDel() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_del);
        List<StSaleminnum> stSaleminnums = this.querySaleminnumModelPage(parammap);
        if (null == stSaleminnums || stSaleminnums.isEmpty()) {
            return;
        }
        for (StSaleminnum stSaleminnum : stSaleminnums) {
            try {
                this.updateSaleminnumState(stSaleminnum.getSaleminnumId(), SaleforecastConstants.dataState_no, SaleforecastConstants.dataState_del, null);
            }
            catch (Exception e) {
                this.logger.error("st.StSaleminnumServiceImpl.saveEnd.e", (Object)stSaleminnum.getSaleminnumCode(), (Throwable)e);
            }
        }
    }

    private void saveEnd() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_start);
        List<StSaleminnum> stSaleminnums = this.querySaleminnumModelPage(parammap);
        if (null == stSaleminnums || stSaleminnums.isEmpty()) {
            return;
        }
        for (StSaleminnum stSaleminnum : stSaleminnums) {
            if (null == stSaleminnum.getSaleminnumEnd() || stSaleminnum.getSaleminnumEnd().getTime() > this.getSysDate().getTime()) continue;
            try {
                this.updateSaleminnumState(stSaleminnum.getSaleminnumId(), SaleforecastConstants.dataState_no, SaleforecastConstants.dataState_start, null);
            }
            catch (Exception e) {
                this.logger.error("st.StSaleminnumServiceImpl.saveEnd.e", (Object)stSaleminnum.getSaleminnumCode(), (Throwable)e);
            }
        }
    }

    private void saveStart() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", SaleforecastConstants.dataState_add);
        List<StSaleminnum> stSaleminnums = this.querySaleminnumModelPage(parammap);
        if (null == stSaleminnums || stSaleminnums.isEmpty()) {
            return;
        }
        for (StSaleminnum stSaleminnum : stSaleminnums) {
            if (!this.checkStart(stSaleminnum)) continue;
            try {
                this.updateSaleminnumState(stSaleminnum.getSaleminnumId(), SaleforecastConstants.dataState_start, SaleforecastConstants.dataState_add, null);
            }
            catch (Exception e) {
                this.logger.error("st.StSaleminnumServiceImpl.saveStart.e", (Object)stSaleminnum.getSaleminnumCode(), (Throwable)e);
            }
        }
    }

    private boolean checkStart(StSaleminnum stSaleminnum) {
        boolean startDate = false;
        boolean endDate = false;
        if (null == stSaleminnum.getSaleminnumStart()) {
            startDate = true;
        }
        if (null != stSaleminnum.getSaleminnumStart() && stSaleminnum.getSaleminnumStart().getTime() >= this.getSysDate().getTime()) {
            startDate = true;
        }
        if (null == stSaleminnum.getSaleminnumEnd()) {
            endDate = true;
        }
        if (null != stSaleminnum.getSaleminnumEnd() && stSaleminnum.getSaleminnumEnd().getTime() < this.getSysDate().getTime()) {
            endDate = true;
        }
        return startDate && endDate;
    }
}

