/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.saleforecast.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.saleforecast.dao.StSalequotaListMapper;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaListDomain;
import com.yqbsoft.laser.service.saleforecast.domain.StSalequotaListReDomain;
import com.yqbsoft.laser.service.saleforecast.model.StSalequotaList;
import com.yqbsoft.laser.service.saleforecast.service.StSalequotaListService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StSalequotaListServiceImpl
extends BaseServiceImpl
implements StSalequotaListService {
    private static final String SYS_CODE = "st.StSalequotaListServiceImpl";
    private StSalequotaListMapper stSalequotaListMapper;
    private String cachekey_list = "Salequota-";

    public void setStSalequotaListMapper(StSalequotaListMapper stSalequotaListMapper) {
        this.stSalequotaListMapper = stSalequotaListMapper;
    }

    private Date getSysDate() {
        try {
            return this.stSalequotaListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSalequotaList(StSalequotaListDomain stSalequotaListDomain) {
        if (null == stSalequotaListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)stSalequotaListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSalequotaListDefault(StSalequotaList stSalequotaList) {
        if (null == stSalequotaList) {
            return;
        }
        if (null == stSalequotaList.getDataState()) {
            stSalequotaList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == stSalequotaList.getGmtCreate()) {
            stSalequotaList.setGmtCreate(date);
        }
        stSalequotaList.setGmtModified(date);
        if (StringUtils.isBlank((String)stSalequotaList.getSalequotaListCode())) {
            stSalequotaList.setSalequotaListCode(this.getNo(null, "StSalequotaList", "stSalequotaList", stSalequotaList.getTenantCode()));
        }
    }

    private int getSalequotaListMaxCode() {
        int code = 0;
        try {
            return this.stSalequotaListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaListServiceImpl.getSalequotaListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSalequotaListUpdataDefault(StSalequotaList stSalequotaList) {
        if (null == stSalequotaList) {
            return;
        }
        stSalequotaList.setGmtModified(this.getSysDate());
    }

    private void saveSalequotaListModel(StSalequotaList stSalequotaList) throws ApiException {
        if (null == stSalequotaList) {
            return;
        }
        try {
            this.stSalequotaListMapper.insert(stSalequotaList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaListServiceImpl.saveSalequotaListModel.ex", (Throwable)e);
        }
    }

    private void saveSalequotaListBatchModel(List<StSalequotaList> stSalequotaListList) throws ApiException {
        if (null == stSalequotaListList || stSalequotaListList.isEmpty()) {
            return;
        }
        try {
            this.stSalequotaListMapper.insertBatch(stSalequotaListList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaListServiceImpl.saveSalequotaListBatchModel.ex", (Throwable)e);
        }
    }

    private StSalequotaList getSalequotaListModelById(Integer salequotaListId) {
        if (null == salequotaListId) {
            return null;
        }
        try {
            return this.stSalequotaListMapper.selectByPrimaryKey(salequotaListId);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaListServiceImpl.getSalequotaListModelById", (Throwable)e);
            return null;
        }
    }

    private StSalequotaList getSalequotaListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.stSalequotaListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaListServiceImpl.getSalequotaListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSalequotaListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaListServiceImpl.delSalequotaListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSalequotaListServiceImpl.delSalequotaListModelByCode.num");
        }
    }

    private void deleteSalequotaListModel(Integer salequotaListId) throws ApiException {
        if (null == salequotaListId) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaListMapper.deleteByPrimaryKey(salequotaListId);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaListServiceImpl.deleteSalequotaListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaListServiceImpl.deleteSalequotaListModel.num");
        }
    }

    private void updateSalequotaListModel(StSalequotaList stSalequotaList) throws ApiException {
        if (null == stSalequotaList) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaListMapper.updateByPrimaryKey(stSalequotaList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateSalequotaListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateSalequotaListModel.num");
        }
    }

    private void updateStateSalequotaListModel(Integer salequotaListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == salequotaListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salequotaListId", salequotaListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSalequotaListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateStateSalequotaListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateStateSalequotaListModel.null");
        }
    }

    private void updateStateSalequotaListModelByCode(String tenantCode, String salequotaListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)salequotaListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaListCode", salequotaListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.stSalequotaListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateStateSalequotaListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateStateSalequotaListModelByCode.null");
        }
    }

    private StSalequotaList makeSalequotaList(StSalequotaListDomain stSalequotaListDomain, StSalequotaList stSalequotaList) {
        if (null == stSalequotaListDomain) {
            return null;
        }
        if (null == stSalequotaList) {
            stSalequotaList = new StSalequotaList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)stSalequotaList, (Object)stSalequotaListDomain);
            return stSalequotaList;
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaListServiceImpl.makeSalequotaList", (Throwable)e);
            return null;
        }
    }

    private StSalequotaListReDomain makeStSalequotaListReDomain(StSalequotaList stSalequotaList) {
        if (null == stSalequotaList) {
            return null;
        }
        StSalequotaListReDomain stSalequotaListReDomain = new StSalequotaListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)stSalequotaListReDomain, (Object)stSalequotaList);
            return stSalequotaListReDomain;
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaListServiceImpl.makeStSalequotaListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<StSalequotaList> querySalequotaListModelPage(Map<String, Object> parammap) {
        try {
            return this.stSalequotaListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaListServiceImpl.querySalequotaListModel", (Throwable)e);
            return null;
        }
    }

    private int countSalequotaList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.stSalequotaListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("st.StSalequotaListServiceImpl.countSalequotaList", (Throwable)e);
        }
        return i;
    }

    private StSalequotaList createStSalequotaList(StSalequotaListDomain stSalequotaListDomain) {
        String msg = this.checkSalequotaList(stSalequotaListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaListServiceImpl.saveSalequotaList.checkSalequotaList", msg);
        }
        StSalequotaList stSalequotaList = this.makeSalequotaList(stSalequotaListDomain, null);
        this.setSalequotaListDefault(stSalequotaList);
        stSalequotaListDomain.setSalequotaListCode(stSalequotaList.getSalequotaListCode());
        return stSalequotaList;
    }

    @Override
    public String saveSalequotaList(StSalequotaListDomain stSalequotaListDomain) throws ApiException {
        StSalequotaList stSalequotaList = this.createStSalequotaList(stSalequotaListDomain);
        this.saveSalequotaListModel(stSalequotaList);
        if (StringUtils.isBlank((String)stSalequotaList.getSalequotaValue())) {
            this.updateStSalequotaListCache(stSalequotaList);
        } else {
            this.updateStSalequotaListCacheCycle(stSalequotaList);
        }
        return stSalequotaList.getSalequotaListCode();
    }

    private void updateStSalequotaListCache(StSalequotaList stSalequotaList) {
        if (null == stSalequotaList) {
            return;
        }
        DisUtil.set((String)(this.cachekey_list + stSalequotaList.getSalequotaCode() + "-" + stSalequotaList.getSalequotaUprovalue() + "-" + stSalequotaList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)stSalequotaList));
    }

    private void updateStSalequotaListCache(StSalequotaListDomain stSalequotaListDomain) {
        if (null == stSalequotaListDomain) {
            return;
        }
        DisUtil.set((String)(this.cachekey_list + stSalequotaListDomain.getSalequotaCode() + "-" + stSalequotaListDomain.getSalequotaUprovalue() + "-" + stSalequotaListDomain.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)stSalequotaListDomain));
    }

    private void updateStSalequotaListCacheCycle(StSalequotaListDomain stSalequotaListDomain) {
        if (null == stSalequotaListDomain) {
            return;
        }
        DisUtil.set((String)(this.cachekey_list + stSalequotaListDomain.getSalequotaCode() + "-" + stSalequotaListDomain.getSalequotaUprovalue() + "-" + stSalequotaListDomain.getSalequotaValue() + "-" + stSalequotaListDomain.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)stSalequotaListDomain));
    }

    private void updateStSalequotaListCacheCycle(StSalequotaList stSalequotaList) {
        if (null == stSalequotaList) {
            return;
        }
        DisUtil.set((String)(this.cachekey_list + stSalequotaList.getSalequotaCode() + "-" + stSalequotaList.getSalequotaUprovalue() + "-" + stSalequotaList.getSalequotaValue() + "-" + stSalequotaList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)stSalequotaList));
    }

    private void deleteStSalequotaListCache(StSalequotaList stSalequotaList) {
        if (null == stSalequotaList) {
            return;
        }
        DisUtil.del((String)(this.cachekey_list + stSalequotaList.getSalequotaCode() + "-" + stSalequotaList.getSalequotaUprovalue() + "-" + stSalequotaList.getTenantCode()));
    }

    private void deleteStSalequotaListCacheCycle(StSalequotaList stSalequotaList) {
        if (null == stSalequotaList) {
            return;
        }
        DisUtil.del((String)(this.cachekey_list + stSalequotaList.getSalequotaCode() + "-" + stSalequotaList.getSalequotaUprovalue() + "-" + stSalequotaList.getSalequotaValue() + "-" + stSalequotaList.getTenantCode()));
    }

    @Override
    public String saveSalequotaListBatch(List<StSalequotaListDomain> stSalequotaListDomainList) throws ApiException {
        if (null == stSalequotaListDomainList || stSalequotaListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<StSalequotaList> stSalequotaListList = new ArrayList<StSalequotaList>();
        String code = "";
        for (StSalequotaListDomain stSalequotaListDomain : stSalequotaListDomainList) {
            StSalequotaList stSalequotaList = this.createStSalequotaList(stSalequotaListDomain);
            code = stSalequotaList.getSalequotaListCode();
            stSalequotaListList.add(stSalequotaList);
        }
        this.saveSalequotaListBatchModel(stSalequotaListList);
        for (StSalequotaList stSalequotaList2 : stSalequotaListList) {
            this.updateStSalequotaListCache(stSalequotaList2);
        }
        return code;
    }

    @Override
    public void updateSalequotaListState(Integer salequotaListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == salequotaListId) {
            return;
        }
        this.updateStateSalequotaListModel(salequotaListId, dataState, oldDataState, map);
    }

    @Override
    public void updateSalequotaListStateByCode(String tenantCode, String salequotaListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)salequotaListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSalequotaListModelByCode(tenantCode, salequotaListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSalequotaList(StSalequotaListDomain stSalequotaListDomain) throws ApiException {
        String msg = this.checkSalequotaList(stSalequotaListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateSalequotaList.checkSalequotaList", msg);
        }
        StSalequotaList oldStSalequotaList = this.getSalequotaListModelById(stSalequotaListDomain.getSalequotaListId());
        if (null == oldStSalequotaList) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateSalequotaList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        StSalequotaList stSalequotaList = this.makeSalequotaList(stSalequotaListDomain, oldStSalequotaList);
        this.setSalequotaListUpdataDefault(stSalequotaList);
        this.updateSalequotaListModel(stSalequotaList);
        if (StringUtils.isBlank((String)stSalequotaList.getSalequotaValue())) {
            this.updateStSalequotaListCache(stSalequotaList);
        } else {
            this.updateStSalequotaListCacheCycle(stSalequotaList);
        }
    }

    @Override
    public void updateSalequotababyList(StSalequotaListDomain stSalequotaListDomain) throws ApiException {
        String msg = this.checkSalequotaList(stSalequotaListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateSalequotaList.checkSalequotaList", msg);
        }
        StSalequotaList stSalequotaList = this.makeSalequotaList(stSalequotaListDomain, null);
        this.updateStSalequotaListNum(stSalequotaList);
        if (StringUtils.isBlank((String)stSalequotaList.getSalequotaValue())) {
            this.updateStSalequotaListCache(stSalequotaList);
        } else {
            this.updateStSalequotaListCacheCycle(stSalequotaList);
        }
    }

    @Override
    public void updateUserSalequotababyList(StSalequotaListDomain stSalequotaListDomain) throws ApiException {
        String msg = this.checkSalequotaList(stSalequotaListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateSalequotaList.checkSalequotaList", msg);
        }
        StSalequotaList stSalequotaList = this.makeSalequotaList(stSalequotaListDomain, null);
        this.updateUserStSalequotaListNum(stSalequotaList);
    }

    private void updateStSalequotaListNum(StSalequotaList stSalequotaList) throws ApiException {
        if (null == stSalequotaList) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaListMapper.updateStSalequotaListNum(stSalequotaList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateSaleforecastListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateSaleforecastListModel.num");
        }
    }

    private void updateUserStSalequotaListNum(StSalequotaList stSalequotaList) throws ApiException {
        if (null == stSalequotaList) {
            return;
        }
        int i = 0;
        try {
            i = this.stSalequotaListMapper.updateUserStSalequotaListNum(stSalequotaList);
        }
        catch (Exception e) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateUserSaleforecastListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("st.StSalequotaListServiceImpl.updateUserSaleforecastListModel.num");
        }
    }

    @Override
    public StSalequotaList getSalequotaList(Integer salequotaListId) {
        if (null == salequotaListId) {
            return null;
        }
        return this.getSalequotaListModelById(salequotaListId);
    }

    @Override
    public void deleteSalequotaList(Integer salequotaListId) throws ApiException {
        if (null == salequotaListId) {
            return;
        }
        StSalequotaList stSalequotaList = this.getSalequotaList(salequotaListId);
        this.deleteSalequotaListModel(salequotaListId);
        this.deleteStSalequotaListCache(stSalequotaList);
    }

    @Override
    public QueryResult<StSalequotaList> querySalequotaListPage(Map<String, Object> map) {
        List<StSalequotaList> stSalequotaListList = this.querySalequotaListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSalequotaList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(stSalequotaListList);
        return queryResult;
    }

    @Override
    public StSalequotaList getSalequotaListByCode(String tenantCode, String salequotaListCode) throws ApiException {
        if (StringUtils.isBlank((String)salequotaListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaListCode", salequotaListCode);
        return this.getSalequotaListModelByCode(map);
    }

    @Override
    public void deleteSalequotaListByCode(String tenantCode, String salequotaListCode) throws ApiException {
        if (StringUtils.isBlank((String)salequotaListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaListCode", salequotaListCode);
        StSalequotaList stSalequotaList = this.getSalequotaListModelByCode(map);
        this.delSalequotaListModelByCode(map);
        this.deleteStSalequotaListCache(stSalequotaList);
    }

    @Override
    public void deleteSalequotaListBysalequotaCode(String tenantCode, String salequotaCode) throws ApiException {
        if (StringUtils.isBlank((String)salequotaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salequotaCode", salequotaCode);
        this.delSalequotaListModelByCode(map);
    }
}

