/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.salesplan.service.impl;

import com.google.common.collect.Maps;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.salesplan.dao.SpScontractFileMapper;
import com.yqbsoft.laser.service.salesplan.dao.SpScontractGoodsMapper;
import com.yqbsoft.laser.service.salesplan.dao.SpScontractMapper;
import com.yqbsoft.laser.service.salesplan.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.salesplan.domain.SpChannelsendDomain;
import com.yqbsoft.laser.service.salesplan.domain.SpScontractDomain;
import com.yqbsoft.laser.service.salesplan.domain.SpScontractFileDomain;
import com.yqbsoft.laser.service.salesplan.domain.SpScontractFileReDomain;
import com.yqbsoft.laser.service.salesplan.domain.SpScontractGoodsDomain;
import com.yqbsoft.laser.service.salesplan.domain.SpScontractGoodsReDomain;
import com.yqbsoft.laser.service.salesplan.domain.SpScontractReDomain;
import com.yqbsoft.laser.service.salesplan.model.SpChannelsend;
import com.yqbsoft.laser.service.salesplan.model.SpScontract;
import com.yqbsoft.laser.service.salesplan.model.SpScontractFile;
import com.yqbsoft.laser.service.salesplan.model.SpScontractGoods;
import com.yqbsoft.laser.service.salesplan.service.SpChannelsendService;
import com.yqbsoft.laser.service.salesplan.service.SpScontractService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class SpScontractServiceImpl
extends BaseServiceImpl
implements SpScontractService {
    private static final String SYS_CODE = "sp.SpScontractServiceImpl";
    private SpScontractMapper sPScontractMapper;
    private SpScontractFileMapper sPScontractFileMapper;
    private SpScontractGoodsMapper spScontractGoodsMapper;
    SpChannelsendService spChannelsendService;

    public SpScontractMapper getsPScontractMapper() {
        return this.sPScontractMapper;
    }

    public void setsPScontractMapper(SpScontractMapper sPScontractMapper) {
        this.sPScontractMapper = sPScontractMapper;
    }

    public SpScontractFileMapper getsPScontractFileMapper() {
        return this.sPScontractFileMapper;
    }

    public void setsPScontractFileMapper(SpScontractFileMapper sPScontractFileMapper) {
        this.sPScontractFileMapper = sPScontractFileMapper;
    }

    public SpScontractGoodsMapper getSpScontractGoodsMapper() {
        return this.spScontractGoodsMapper;
    }

    public void setSPScontractMapper(SpScontractMapper sPScontractMapper) {
        this.sPScontractMapper = sPScontractMapper;
    }

    public void setSPScontractFileMapper(SpScontractFileMapper sPScontractFileMapper) {
        this.sPScontractFileMapper = sPScontractFileMapper;
    }

    public void setSpScontractGoodsMapper(SpScontractGoodsMapper spScontractGoodsMapper) {
        this.spScontractGoodsMapper = spScontractGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.sPScontractMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkScontract(SpScontractDomain sPScontractDomain) {
        if (null == sPScontractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sPScontractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setScontractDefault(SpScontract sPScontract) {
        if (null == sPScontract) {
            return;
        }
        if (null == sPScontract.getDataState()) {
            sPScontract.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sPScontract.getGmtCreate()) {
            sPScontract.setGmtCreate(date);
        }
        sPScontract.setGmtModified(date);
        if (StringUtils.isBlank((String)sPScontract.getScontractCode())) {
            sPScontract.setScontractCode(this.getNo(null, "SpScontract", "sPScontract", sPScontract.getTenantCode()));
        }
    }

    private int getScontractMaxCode() {
        int code = 0;
        try {
            return this.sPScontractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.getScontractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setScontractUpdataDefault(SpScontract sPScontract) {
        if (null == sPScontract) {
            return;
        }
        sPScontract.setGmtModified(this.getSysDate());
    }

    private void updateSconNoMarkUp(String scontractCode, String tenantCode, BigDecimal scontractRefnum) {
        if (null == scontractCode || null == tenantCode) {
            return;
        }
        int i = 0;
        HashMap map = Maps.newHashMap();
        map.put("scontractCode", scontractCode);
        map.put("tenantCode", tenantCode);
        map.put("scontractRefnum", scontractRefnum);
        try {
            i = this.sPScontractMapper.updateSconNoMarkUp(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateSconNoMarkUp.ex", (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("sp.SpScontractServiceImpl.updateSconNoMarkUp.map.null.param", (Object)map);
        }
    }

    private void saveScontractModel(SpScontract sPScontract) throws ApiException {
        if (null == sPScontract) {
            return;
        }
        try {
            this.sPScontractMapper.insert(sPScontract);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.saveScontractModel.ex", (Throwable)e);
        }
    }

    private void saveScontractBatchModel(List<SpScontract> sPScontractList) throws ApiException {
        if (null == sPScontractList || sPScontractList.isEmpty()) {
            return;
        }
        try {
            this.sPScontractMapper.insertBatch(sPScontractList);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.saveScontractBatchModel.ex", (Throwable)e);
        }
    }

    private SpScontract getScontractModelById(Integer scontractId) {
        if (null == scontractId) {
            return null;
        }
        try {
            return this.sPScontractMapper.selectByPrimaryKey(scontractId);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.getScontractModelById", (Throwable)e);
            return null;
        }
    }

    private SpScontract getScontractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sPScontractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.getScontractModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delScontractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sPScontractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.delScontractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.delScontractModelByCode.num");
        }
    }

    private void deleteScontractModel(Integer scontractId) throws ApiException {
        if (null == scontractId) {
            return;
        }
        int i = 0;
        try {
            i = this.sPScontractMapper.deleteByPrimaryKey(scontractId);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.deleteScontractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.deleteScontractModel.num");
        }
    }

    private void updateScontractModel(SpScontract sPScontract) throws ApiException {
        if (null == sPScontract) {
            return;
        }
        int i = 0;
        try {
            i = this.sPScontractMapper.updateByPrimaryKey(sPScontract);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractModel.num");
        }
    }

    private void updateScontractKeySelective(SpScontract sPScontract) throws ApiException {
        if (null == sPScontract) {
            return;
        }
        int i = 0;
        try {
            i = this.sPScontractMapper.updateByPrimaryKeySelective(sPScontract);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractModel.num");
        }
    }

    private void updateStateScontractModel(Integer scontractId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == scontractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scontractId", scontractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sPScontractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractModel.null");
        }
    }

    private void updateStateScontractModelByCode(String tenantCode, String scontractCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)scontractCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractCode", scontractCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sPScontractMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractModelByCode.null");
        }
    }

    private SpScontract makeScontract(SpScontractDomain sPScontractDomain, SpScontract sPScontract) {
        if (null == sPScontractDomain) {
            return null;
        }
        if (null == sPScontract) {
            sPScontract = new SpScontract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sPScontract, (Object)sPScontractDomain);
            return sPScontract;
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.makeScontract", (Throwable)e);
            return null;
        }
    }

    private SpScontractReDomain makeSPScontractReDomain(SpScontract sPScontract) {
        if (null == sPScontract) {
            return null;
        }
        SpScontractReDomain sPScontractReDomain = new SpScontractReDomain();
        try {
            Map parammap = this.getQueryMapParam("scontractCode,tenantCode", new Object[]{sPScontract.getScontractCode(), sPScontract.getTenantCode()});
            BeanUtils.copyAllPropertys((Object)sPScontractReDomain, (Object)sPScontract);
            sPScontractReDomain.setSpScontractGoodsReDomainList(this.makeGoodsList(this.queryScontractGoodsModelPage(parammap)));
            sPScontractReDomain.setSpScontractFileReDomainList(this.makeFileList(this.queryScontractFileModelPage(parammap)));
            return sPScontractReDomain;
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.makeSPScontractReDomain", (Throwable)e);
            return null;
        }
    }

    private SpScontractGoodsReDomain makeSPScontractGoodsReDomain(SpScontractGoods spScontractGoods) {
        if (null == spScontractGoods) {
            return null;
        }
        SpScontractGoodsReDomain sPScontractGoodsReDomain = new SpScontractGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sPScontractGoodsReDomain, (Object)spScontractGoods);
            return sPScontractGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.makeSPScontractReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SpScontractGoodsReDomain> makeGoodsList(List<SpScontractGoods> spScontractGoodsList) {
        if (ListUtil.isEmpty(spScontractGoodsList)) {
            return null;
        }
        ArrayList<SpScontractGoodsReDomain> relist = new ArrayList<SpScontractGoodsReDomain>();
        for (SpScontractGoods spScontractGoods : spScontractGoodsList) {
            relist.add(this.makeSPScontractGoodsReDomain(spScontractGoods));
        }
        return relist;
    }

    private SpScontractFileReDomain makeSPScontractFileReDomain(SpScontractFile spScontractFile) {
        if (null == spScontractFile) {
            return null;
        }
        SpScontractFileReDomain sPScontractFileReDomain = new SpScontractFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sPScontractFileReDomain, (Object)spScontractFile);
            return sPScontractFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.makeSPScontractFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SpScontractFileReDomain> makeFileList(List<SpScontractFile> spScontractFileList) {
        if (ListUtil.isEmpty(spScontractFileList)) {
            return null;
        }
        ArrayList<SpScontractFileReDomain> relist = new ArrayList<SpScontractFileReDomain>();
        for (SpScontractFile spScontractFile : spScontractFileList) {
            relist.add(this.makeSPScontractFileReDomain(spScontractFile));
        }
        return relist;
    }

    private List<SpScontract> queryScontractModelPage(Map<String, Object> parammap) {
        try {
            return this.sPScontractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.queryScontractModel", (Throwable)e);
            return null;
        }
    }

    private int countScontract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sPScontractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.countScontract", (Throwable)e);
        }
        return i;
    }

    private SpScontract createSPScontract(SpScontractDomain sPScontractDomain) {
        String msg = this.checkScontract(sPScontractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sp.SpScontractServiceImpl.saveScontract.checkScontract", msg);
        }
        SpScontract sPScontract = this.makeScontract(sPScontractDomain, null);
        this.setScontractDefault(sPScontract);
        return sPScontract;
    }

    private String checkScontractFile(SpScontractFileDomain sPScontractFileDomain) {
        if (null == sPScontractFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sPScontractFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setScontractFileDefault(SpScontractFile sPScontractFile) {
        if (null == sPScontractFile) {
            return;
        }
        if (null == sPScontractFile.getDataState()) {
            sPScontractFile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sPScontractFile.getGmtCreate()) {
            sPScontractFile.setGmtCreate(date);
        }
        sPScontractFile.setGmtModified(date);
        if (StringUtils.isBlank((String)sPScontractFile.getScontractFileCode())) {
            sPScontractFile.setScontractFileCode(this.getNo(null, "SpScontractFile", "sPScontractFile", sPScontractFile.getTenantCode()));
        }
    }

    private int getScontractFileMaxCode() {
        int code = 0;
        try {
            return this.sPScontractFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.getScontractFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setScontractFileUpdataDefault(SpScontractFile sPScontractFile) {
        if (null == sPScontractFile) {
            return;
        }
        sPScontractFile.setGmtModified(this.getSysDate());
    }

    private void saveScontractFileModel(SpScontractFile sPScontractFile) throws ApiException {
        if (null == sPScontractFile) {
            return;
        }
        try {
            this.sPScontractFileMapper.insert(sPScontractFile);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.saveScontractFileModel.ex", (Throwable)e);
        }
    }

    private void saveScontractFileBatchModel(List<SpScontractFile> sPScontractFileList) throws ApiException {
        if (null == sPScontractFileList || sPScontractFileList.isEmpty()) {
            return;
        }
        try {
            this.sPScontractFileMapper.insertBatch(sPScontractFileList);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.saveScontractFileBatchModel.ex", (Throwable)e);
        }
    }

    private SpScontractFile getScontractFileModelById(Integer scontractFileId) {
        if (null == scontractFileId) {
            return null;
        }
        try {
            return this.sPScontractFileMapper.selectByPrimaryKey(scontractFileId);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.getScontractFileModelById", (Throwable)e);
            return null;
        }
    }

    private SpScontractFile getScontractFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sPScontractFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.getScontractFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delScontractFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sPScontractFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.delScontractFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.delScontractFileModelByCode.num");
        }
    }

    private void deleteScontractFileModel(Integer scontractFileId) throws ApiException {
        if (null == scontractFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.sPScontractFileMapper.deleteByPrimaryKey(scontractFileId);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.deleteScontractFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.deleteScontractFileModel.num");
        }
    }

    private void updateScontractFileModel(SpScontractFile sPScontractFile) throws ApiException {
        if (null == sPScontractFile) {
            return;
        }
        int i = 0;
        try {
            i = this.sPScontractFileMapper.updateByPrimaryKey(sPScontractFile);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractFileModel.num");
        }
    }

    private void updateStateScontractFileModel(Integer scontractFileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == scontractFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scontractFileId", scontractFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sPScontractFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractFileModel.null");
        }
    }

    private void updateStateScontractFileModelByCode(String tenantCode, String scontractFileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)scontractFileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractFileCode", scontractFileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sPScontractFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractFileModelByCode.null");
        }
    }

    private SpScontractFile makeScontractFile(SpScontractFileDomain sPScontractFileDomain, SpScontractFile sPScontractFile) {
        if (null == sPScontractFileDomain) {
            return null;
        }
        if (null == sPScontractFile) {
            sPScontractFile = new SpScontractFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sPScontractFile, (Object)sPScontractFileDomain);
            return sPScontractFile;
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.makeScontractFile", (Throwable)e);
            return null;
        }
    }

    private List<SpScontractFile> queryScontractFileModelPage(Map<String, Object> parammap) {
        try {
            return this.sPScontractFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.queryScontractFileModel", (Throwable)e);
            return null;
        }
    }

    private int countScontractFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sPScontractFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.countScontractFile", (Throwable)e);
        }
        return i;
    }

    private SpScontractFile createSPScontractFile(SpScontractFileDomain sPScontractFileDomain) {
        String msg = this.checkScontractFile(sPScontractFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sp.SpScontractServiceImpl.saveScontractFile.checkScontractFile", msg);
        }
        SpScontractFile sPScontractFile = this.makeScontractFile(sPScontractFileDomain, null);
        this.setScontractFileDefault(sPScontractFile);
        return sPScontractFile;
    }

    @Override
    public List<SpChannelsend> saveScontract(SpScontractDomain sPScontractDomain) throws ApiException {
        SpScontract spScontract = this.savesSpScontract(sPScontractDomain);
        ArrayList<SpScontract> list = new ArrayList<SpScontract>();
        list.add(spScontract);
        List<SpChannelsend> cpRechargeSendList = this.buidPmChannelsend(list, "insert");
        return cpRechargeSendList;
    }

    private SpScontract savesSpScontract(SpScontractDomain sPScontractDomain) {
        if (null == sPScontractDomain) {
            return null;
        }
        SpScontract sPScontract = this.createSPScontract(sPScontractDomain);
        if (null == sPScontract) {
            throw new ApiException("sp.SpScontractServiceImpl.savesSpScontract.sgSendgoods");
        }
        this.saveScontractModel(sPScontract);
        if (ListUtil.isNotEmpty(sPScontractDomain.getSpScontractGoodsDomainList())) {
            ArrayList<SpScontractGoodsDomain> sgSendgoodsGoodsList = new ArrayList<SpScontractGoodsDomain>();
            for (SpScontractGoodsDomain spScontractGoodsDomain : sPScontractDomain.getSpScontractGoodsDomainList()) {
                spScontractGoodsDomain.setScontractCode(sPScontract.getScontractCode());
                spScontractGoodsDomain.setTenantCode(sPScontractDomain.getTenantCode());
                sgSendgoodsGoodsList.add(spScontractGoodsDomain);
            }
            this.saveScontractGoodsBatch(sgSendgoodsGoodsList);
        }
        if (ListUtil.isNotEmpty(sPScontractDomain.getSpScontractFileDomainList())) {
            ArrayList<SpScontractFileDomain> spScontractFileDomainList = new ArrayList<SpScontractFileDomain>();
            for (SpScontractFileDomain spScontractFileDomain : sPScontractDomain.getSpScontractFileDomainList()) {
                spScontractFileDomain.setScontractCode(sPScontract.getScontractCode());
                spScontractFileDomain.setTenantCode(sPScontractDomain.getTenantCode());
                spScontractFileDomain.setMemberCode(sPScontract.getMemberCode());
                spScontractFileDomain.setMemberName(sPScontractDomain.getMemberName());
                spScontractFileDomainList.add(spScontractFileDomain);
            }
            this.saveScontractFileBatch(spScontractFileDomainList);
        }
        return sPScontract;
    }

    @Override
    public List<SpChannelsend> saveScontractBatch(List<SpScontractDomain> sPScontractDomainList) throws ApiException {
        if (null == sPScontractDomainList || sPScontractDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SpScontract> sPScontractList = new ArrayList<SpScontract>();
        String code = "";
        for (SpScontractDomain sPScontractDomain : sPScontractDomainList) {
            SpScontract sPScontract = this.createSPScontract(sPScontractDomain);
            code = sPScontract.getScontractCode();
            sPScontractList.add(sPScontract);
        }
        this.saveScontractBatchModel(sPScontractList);
        List<SpChannelsend> cpRechargeSendList = this.buidPmChannelsend(sPScontractList, "insert");
        return cpRechargeSendList;
    }

    @Override
    public List<SpChannelsend> updateScontractState(Integer scontractId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == scontractId) {
            return null;
        }
        this.updateStateScontractModel(scontractId, dataState, oldDataState, map);
        ArrayList<SpScontract> list = new ArrayList<SpScontract>();
        list.add(this.getScontractModelById(scontractId));
        List<SpChannelsend> cpRechargeSendList = this.buidPmChannelsend(list, "update");
        return cpRechargeSendList;
    }

    @Override
    public List<SpChannelsend> updateScontractStateByCode(String tenantCode, String scontractCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)scontractCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        this.updateStateScontractModelByCode(tenantCode, scontractCode, dataState, oldDataState, map);
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("tenantCode", tenantCode);
        pmap.put("scontractCode", scontractCode);
        ArrayList<SpScontract> list = new ArrayList<SpScontract>();
        list.add(this.getScontractModelByCode(pmap));
        List<SpChannelsend> cpRechargeSendList = this.buidPmChannelsend(list, "update");
        return cpRechargeSendList;
    }

    @Override
    public List<SpChannelsend> updateScontract(SpScontractDomain sPScontractDomain) throws ApiException {
        String msg = this.checkScontract(sPScontractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontract.checkScontract", msg);
        }
        SpScontract oldSpScontract = this.getScontractModelById(sPScontractDomain.getScontractId());
        if (null == oldSpScontract) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SpScontract sPScontract = this.makeScontract(sPScontractDomain, oldSpScontract);
        this.setScontractUpdataDefault(sPScontract);
        this.updateScontractModel(sPScontract);
        ArrayList<SpScontract> list = new ArrayList<SpScontract>();
        list.add(sPScontract);
        List<SpChannelsend> cpRechargeSendList = this.buidPmChannelsend(list, "edit");
        return cpRechargeSendList;
    }

    @Override
    public List<SpChannelsend> updateScontractKey(SpScontractDomain sPScontractDomain) throws ApiException {
        String msg = this.checkScontract(sPScontractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontract.checkScontract", msg);
        }
        SpScontract oldSpScontract = this.getScontractModelById(sPScontractDomain.getScontractId());
        if (null == oldSpScontract) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SpScontract sPScontract = this.makeScontract(sPScontractDomain, oldSpScontract);
        this.setScontractUpdataDefault(sPScontract);
        this.updateScontractKeySelective(sPScontract);
        ArrayList<SpScontract> list = new ArrayList<SpScontract>();
        list.add(sPScontract);
        List<SpChannelsend> cpRechargeSendList = this.buidPmChannelsend(list, "edit");
        return cpRechargeSendList;
    }

    @Override
    public void updateScontractNoMarkUp(String tenantCode, String scontractCode, BigDecimal scontractRefnum) {
        if (null == scontractCode || null == tenantCode) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractNoMarkUp.scontractCode.tenantCode", scontractCode + "," + tenantCode);
        }
        this.updateSconNoMarkUp(scontractCode, tenantCode, scontractRefnum);
    }

    @Override
    public SpScontractReDomain getScontract(Integer scontractId) {
        if (null == scontractId) {
            return null;
        }
        return this.makeSPScontractReDomain(this.getScontractModelById(scontractId));
    }

    @Override
    public List<SpChannelsend> deleteScontract(Integer scontractId) throws ApiException {
        if (null == scontractId) {
            return null;
        }
        ArrayList<SpScontract> list = new ArrayList<SpScontract>();
        list.add(this.getScontractModelById(scontractId));
        this.deleteScontractModel(scontractId);
        List<SpChannelsend> cpRechargeSendList = this.buidPmChannelsend(list, "delete");
        return cpRechargeSendList;
    }

    @Override
    public QueryResult<SpScontract> queryScontractPage(Map<String, Object> map) {
        List<SpScontract> sPScontractList = this.queryScontractModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countScontract(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sPScontractList);
        return queryResult;
    }

    @Override
    public SpScontractReDomain getScontractByCode(String tenantCode, String scontractCode) throws ApiException {
        if (StringUtils.isBlank((String)scontractCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractCode", scontractCode);
        return this.makeSPScontractReDomain(this.getScontractModelByCode(map));
    }

    @Override
    public List<SpChannelsend> deleteScontractByCode(String tenantCode, String scontractCode) throws ApiException {
        if (StringUtils.isBlank((String)scontractCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractCode", scontractCode);
        ArrayList<SpScontract> list = new ArrayList<SpScontract>();
        list.add(this.getScontractModelByCode(map));
        this.delScontractModelByCode(map);
        List<SpChannelsend> cpRechargeSendList = this.buidPmChannelsend(list, "delete");
        return cpRechargeSendList;
    }

    @Override
    public String saveScontractFile(SpScontractFileDomain sPScontractFileDomain) throws ApiException {
        SpScontractFile sPScontractFile = this.createSPScontractFile(sPScontractFileDomain);
        this.saveScontractFileModel(sPScontractFile);
        return sPScontractFile.getScontractFileCode();
    }

    @Override
    public String saveScontractFileBatch(List<SpScontractFileDomain> sPScontractFileDomainList) throws ApiException {
        if (null == sPScontractFileDomainList || sPScontractFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SpScontractFile> sPScontractFileList = new ArrayList<SpScontractFile>();
        String code = "";
        for (SpScontractFileDomain sPScontractFileDomain : sPScontractFileDomainList) {
            SpScontractFile sPScontractFile = this.createSPScontractFile(sPScontractFileDomain);
            code = sPScontractFile.getScontractFileCode();
            sPScontractFileList.add(sPScontractFile);
        }
        this.saveScontractFileBatchModel(sPScontractFileList);
        return code;
    }

    public SpChannelsendService getSpChannelsendService() {
        return this.spChannelsendService;
    }

    public void setSpChannelsendService(SpChannelsendService spChannelsendService) {
        this.spChannelsendService = spChannelsendService;
    }

    private List<SpChannelsend> buidPmChannelsend(List<SpScontract> spScontractList, String dri) {
        if (ListUtil.isEmpty(spScontractList)) {
            return null;
        }
        ArrayList<SpChannelsend> spChannelsendList = new ArrayList();
        ArrayList<SpChannelsendDomain> disChannelsendDomainList = new ArrayList<SpChannelsendDomain>();
        for (SpScontract spScontract : spScontractList) {
            SpChannelsendDomain spChannelsendDomain = new SpChannelsendDomain();
            spChannelsendDomain.setChannelsendOpcode(spScontract.getScontractCode());
            spChannelsendDomain.setChannelsendType("spScontract");
            spChannelsendDomain.setChannelsendDir(dri);
            spChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)spScontract));
            spChannelsendDomain.setTenantCode(spScontract.getTenantCode());
            disChannelsendDomainList.add(spChannelsendDomain);
        }
        spChannelsendList = this.spChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
        return spChannelsendList;
    }

    @Override
    public void updateScontractFileState(Integer scontractFileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == scontractFileId) {
            return;
        }
        this.updateStateScontractFileModel(scontractFileId, dataState, oldDataState, map);
    }

    @Override
    public void updateScontractFileStateByCode(String tenantCode, String scontractFileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)scontractFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateScontractFileModelByCode(tenantCode, scontractFileCode, dataState, oldDataState, map);
    }

    @Override
    public void updateScontractFile(SpScontractFileDomain sPScontractFileDomain) throws ApiException {
        String msg = this.checkScontractFile(sPScontractFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractFile.checkScontractFile", msg);
        }
        this.logger.error("111111111111" + sPScontractFileDomain.toString());
        SpScontractFile oldSpScontractFile = this.getScontractFileModelById(sPScontractFileDomain.getScontractFileId());
        if (null == oldSpScontractFile) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SpScontractFile sPScontractFile = this.makeScontractFile(sPScontractFileDomain, oldSpScontractFile);
        this.setScontractFileUpdataDefault(sPScontractFile);
        this.updateScontractFileModel(sPScontractFile);
    }

    @Override
    public SpScontractFile getScontractFile(Integer scontractFileId) {
        if (null == scontractFileId) {
            return null;
        }
        return this.getScontractFileModelById(scontractFileId);
    }

    @Override
    public void deleteScontractFile(Integer scontractFileId) throws ApiException {
        if (null == scontractFileId) {
            return;
        }
        this.deleteScontractFileModel(scontractFileId);
    }

    @Override
    public QueryResult<SpScontractFile> queryScontractFilePage(Map<String, Object> map) {
        List<SpScontractFile> sPScontractFileList = this.queryScontractFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countScontractFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sPScontractFileList);
        return queryResult;
    }

    @Override
    public SpScontractFile getScontractFileByCode(String tenantCode, String scontractFileCode) throws ApiException {
        if (StringUtils.isBlank((String)scontractFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractFileCode", scontractFileCode);
        return this.getScontractFileModelByCode(map);
    }

    @Override
    public void deleteScontractFileByCode(String tenantCode, String scontractFileCode) throws ApiException {
        if (StringUtils.isBlank((String)scontractFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractFileCode", scontractFileCode);
        this.delScontractFileModelByCode(map);
    }

    private String checkScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)spScontractGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    @Override
    public String saveScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain) throws ApiException {
        SpScontractGoods spScontractGoods = this.createSpScontractGoods(spScontractGoodsDomain);
        this.saveScontractGoodsModel(spScontractGoods);
        return spScontractGoods.getScontractGoodsCode();
    }

    private void saveScontractGoodsModel(SpScontractGoods spScontractGoods) throws ApiException {
        if (null == spScontractGoods) {
            return;
        }
        try {
            this.spScontractGoodsMapper.insert(spScontractGoods);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.saveScontractGoodsModel.ex", (Throwable)e);
        }
    }

    private SpScontractGoods createSpScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain) {
        String msg = this.checkScontractGoods(spScontractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sp.SpScontractServiceImpl.saveScontractGoods.checkScontractGoods", msg);
        }
        SpScontractGoods spScontractGoods = this.makeScontractGoods(spScontractGoodsDomain, null);
        this.setScontractGoodsDefault(spScontractGoods);
        return spScontractGoods;
    }

    private void setScontractGoodsDefault(SpScontractGoods spScontractGoods) {
        if (null == spScontractGoods) {
            return;
        }
        if (null == spScontractGoods.getDataState()) {
            spScontractGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == spScontractGoods.getGmtCreate()) {
            spScontractGoods.setGmtCreate(date);
        }
        spScontractGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)spScontractGoods.getScontractGoodsCode())) {
            spScontractGoods.setScontractGoodsCode(this.getNo(null, "SpScontractGoods", "spScontractGoods", spScontractGoods.getTenantCode()));
        }
    }

    private SpScontractGoods makeScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain, SpScontractGoods spScontractGoods) {
        if (null == spScontractGoodsDomain) {
            return null;
        }
        if (null == spScontractGoods) {
            spScontractGoods = new SpScontractGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)spScontractGoods, (Object)spScontractGoodsDomain);
            return spScontractGoods;
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.makeScontractGoods", (Throwable)e);
            return null;
        }
    }

    @Override
    public String saveScontractGoodsBatch(List<SpScontractGoodsDomain> spScontractGoodsDomainList) throws ApiException {
        if (null == spScontractGoodsDomainList || spScontractGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SpScontractGoods> spScontractGoodsList = new ArrayList<SpScontractGoods>();
        String code = "";
        for (SpScontractGoodsDomain spScontractGoodsDomain : spScontractGoodsDomainList) {
            SpScontractGoods spScontractGoods = this.createSpScontractGoods(spScontractGoodsDomain);
            code = spScontractGoods.getScontractGoodsCode();
            spScontractGoodsList.add(spScontractGoods);
        }
        this.saveScontractGoodsBatchModel(spScontractGoodsList);
        return code;
    }

    private void saveScontractGoodsBatchModel(List<SpScontractGoods> spScontractGoodsList) throws ApiException {
        if (null == spScontractGoodsList || spScontractGoodsList.isEmpty()) {
            return;
        }
        try {
            this.spScontractGoodsMapper.insertBatch(spScontractGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.saveScontractGoodsBatchModel.ex", (Throwable)e);
        }
    }

    @Override
    public void updateScontractGoodsState(Integer scontractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == scontractGoodsId) {
            return;
        }
        this.updateStateScontractGoodsModel(scontractGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateScontractGoodsStateByCode(String tenantCode, String scontractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)scontractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateScontractGoodsModelByCode(tenantCode, scontractGoodsCode, dataState, oldDataState, map);
    }

    private void updateStateScontractGoodsModelByCode(String tenantCode, String scontractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)scontractGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractGoodsCode", scontractGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractGoodsModelByCode.null");
        }
    }

    private void updateScontractGoodsModel(SpScontractGoods spScontractGoods) throws ApiException {
        if (null == spScontractGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateByPrimaryKey(spScontractGoods);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractGoodsModel.num");
        }
    }

    private void updateStateScontractGoodsModel(Integer scontractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == scontractGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scontractGoodsId", scontractGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sp.SpScontractServiceImpl.updateStateScontractGoodsModel.null");
        }
    }

    @Override
    public void updateScontractGoods(SpScontractGoodsDomain spScontractGoodsDomain) throws ApiException {
        String msg = this.checkScontractGoods(spScontractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractGoods.checkScontractGoods", msg);
        }
        SpScontractGoods oldSpScontractGoods = this.getScontractGoodsModelById(spScontractGoodsDomain.getScontractGoodsId());
        if (null == oldSpScontractGoods) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SpScontractGoods spScontractGoods = this.makeScontractGoods(spScontractGoodsDomain, oldSpScontractGoods);
        this.setScontractGoodsUpdataDefault(spScontractGoods);
        this.updateScontractGoodsModel(spScontractGoods);
    }

    private void setScontractGoodsUpdataDefault(SpScontractGoods spScontractGoods) {
        if (null == spScontractGoods) {
            return;
        }
        spScontractGoods.setGmtModified(this.getSysDate());
    }

    private SpScontractGoods getScontractGoodsModelById(Integer scontractGoodsId) {
        if (null == scontractGoodsId) {
            return null;
        }
        try {
            return this.spScontractGoodsMapper.selectByPrimaryKey(scontractGoodsId);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.getScontractGoodsModelById", (Throwable)e);
            return null;
        }
    }

    @Override
    public SpScontractGoods getScontractGoods(Integer scontractGoodsId) {
        if (null == scontractGoodsId) {
            return null;
        }
        return this.getScontractGoodsModelById(scontractGoodsId);
    }

    @Override
    public void deleteScontractGoods(Integer scontractGoodsId) throws ApiException {
        if (null == scontractGoodsId) {
            return;
        }
        this.deleteScontractGoodsModel(scontractGoodsId);
    }

    private void deleteScontractGoodsModel(Integer scontractGoodsId) throws ApiException {
        if (null == scontractGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.deleteByPrimaryKey(scontractGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.deleteScontractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.deleteScontractGoodsModel.num");
        }
    }

    @Override
    public QueryResult<SpScontractGoods> queryScontractGoodsPage(Map<String, Object> map) {
        List<SpScontractGoods> spScontractGoodsList = this.queryScontractGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countScontractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(spScontractGoodsList);
        return queryResult;
    }

    private int countScontractGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.countScontractGoods", (Throwable)e);
        }
        return i;
    }

    private List<SpScontractGoods> queryScontractGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.spScontractGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.queryScontractGoodsModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public SpScontractGoods getScontractGoodsByCode(String tenantCode, String scontractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)scontractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractGoodsCode", scontractGoodsCode);
        return this.getScontractGoodsModelByCode(map);
    }

    private SpScontractGoods getScontractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.spScontractGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sp.SpScontractServiceImpl.getScontractGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteScontractGoodsByCode(String tenantCode, String scontractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)scontractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scontractGoodsCode", scontractGoodsCode);
        this.delScontractGoodsModelByCode(map);
    }

    @Override
    public String updateScontractGoodsOrernum(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        if (null == resourceGoodsList || resourceGoodsList.isEmpty()) {
            this.logger.error("sp.SpScontractServiceImpl.updateScontractGoodsOrernum.null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ResourceStockDomain resourceStockDomain : resourceGoodsList) {
            String tenantCode = resourceStockDomain.getTenantCode();
            map.put("tenantCode", tenantCode);
            map.put("scontractCode", resourceStockDomain.getScontractCode());
            map.put("goodsCode", resourceStockDomain.getGoodsCode());
            QueryResult<SpScontractGoods> spScontractGoodsQueryResult = this.queryScontractGoodsPage(map);
            if (!ListUtil.isNotEmpty((Collection)spScontractGoodsQueryResult.getList())) continue;
            SpScontractGoods SpScontractGoods2 = (SpScontractGoods)spScontractGoodsQueryResult.getList().get(0);
            HashMap<String, Object> mapStr = new HashMap<String, Object>();
            mapStr.put("tenantCode", tenantCode);
            mapStr.put("goodsCode", resourceStockDomain.getGoodsCode());
            mapStr.put("scontractGoodsOrernum", resourceStockDomain.getGoodsNum());
            mapStr.put("scontractGoodsCode", SpScontractGoods2.getScontractGoodsCode());
            this.updateScontractGoodsOrernumModel(mapStr);
            map.put("scontractOrernum", resourceStockDomain.getGoodsNum());
            this.updateScontractOrernumModel(map);
        }
        return "success";
    }

    @Override
    public String updateScontractGoodsSendnum(Map<String, Object> map) throws ApiException {
        this.updateScontractGoodsSendnumModel(map);
        return null;
    }

    @Override
    public String updateScontractGoodsRefnum(Map<String, Object> map) throws ApiException {
        this.updateScontractGoodsSendnumModel(map);
        return null;
    }

    @Override
    public void updateScontractStateJob(String tenantCode) {
        if (StringUtils.isEmpty((String)tenantCode)) {
            this.logger.info("updateScontractStateJob\u5fc5\u586b\u79df\u6237\u53f7");
            return;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("tenantCode", tenantCode);
        parameters.put("contractDepositdateQend", new Date());
        parameters.put("dataState", 0);
        List<SpScontract> queryStartList = this.sPScontractMapper.query(parameters);
        if (CollectionUtils.isNotEmpty(queryStartList)) {
            for (SpScontract spScontract : queryStartList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dataState", 1);
                map.put("scontractId", spScontract.getScontractId());
                this.sPScontractMapper.updateStateByPrimaryKey(map);
                if (!"1".equals(spScontract.getContractPmode())) continue;
                Map<String, Object> userMap = this.getUserinfoByCode(spScontract.getMemberBcode(), spScontract.getTenantCode());
                if (userMap.get("gmtValid") == null) {
                    HashMap<String, Object> newUserMap = new HashMap<String, Object>();
                    newUserMap.put("userId", userMap.get("userId"));
                    newUserMap.put("gmtValid", spScontract.getContractEffectivedate());
                    this.updateUserValidate(newUserMap);
                    continue;
                }
                Date date = null;
                try {
                    date = DateUtils.parseDate((String)userMap.get("gmtValid").toString(), (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (spScontract.getContractEffectivedate().before(date)) continue;
                HashMap<String, Object> newUserMap = new HashMap<String, Object>();
                newUserMap.put("userId", userMap.get("userId"));
                newUserMap.put("gmtValid", spScontract.getContractEffectivedate());
                this.updateUserValidate(newUserMap);
            }
        }
        parameters.put("contractEffectivedateQend", new Date());
        parameters.put("dataState", 1);
        List<SpScontract> queryEndList = this.sPScontractMapper.query(parameters);
        if (CollectionUtils.isNotEmpty(queryEndList)) {
            for (SpScontract spScontract : queryEndList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dataState", 2);
                map.put("scontractId", spScontract.getScontractId());
                this.sPScontractMapper.updateStateByPrimaryKey(map);
            }
        }
    }

    private Map<String, Object> getUserinfoByCode(String userPcode, String tenantCode) {
        if (StringUtils.isBlank((String)userPcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserByPcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userPcode", userPcode);
        paramMap.put("tenantCode", tenantCode);
        return (Map)this.getForObject(apiCode, Map.class, paramMap);
    }

    protected String updateUserValidate(Map<String, Object> map) {
        String apiCode = "um.user.updateUserValidate";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.internalInvoke(apiCode, paramMap);
    }

    private void updateScontractGoodsOrernumModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateScontractGoodsOrernumModel(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractGoodsOrernumModel.map.ex" + map, (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("sp.SpScontractServiceImpl.updateScontractGoodsOrernumModel.map.null.param", map);
        }
    }

    private void updateScontractOrernumModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.sPScontractMapper.updateScontractOrernumModel(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractOrernumModel.map.ex" + map, (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("sp.SpScontractServiceImpl.updateScontractOrernumModel.map.null.param", map);
        }
    }

    private void updateScontractGoodsSendnumModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateScontractGoodsOrernumModel(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractGoodsSendnumModel.map.ex" + map, (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("sp.SpScontractServiceImpl.updateScontractGoodsSendnumModel.map.null.param", map);
        }
    }

    private void updateScontractGoodsRefnumModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.updateScontractGoodsOrernumModel(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.updateScontractGoodsRefnumModel.map.ex" + map, (Throwable)e);
        }
        if (i <= 0) {
            this.logger.error("sp.SpScontractServiceImpl.updateScontractGoodsRefnumModel.map.null.param", map);
        }
    }

    private void delScontractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.spScontractGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sp.SpScontractServiceImpl.delScontractGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sp.SpScontractServiceImpl.delScontractGoodsModelByCode.num");
        }
    }
}

